.\" t
.\" Copyright (c) 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\"
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.in +.5i
..
.de EE
.fi
.in -.5i
.if n .sp 1
.if t .sp .5
..
.TH XCALC 1 __xorgversion__
.SH NAME
xcalc \- scientific calculator for X
.SH SYNOPSIS
.nf
\fBxcalc\fP [\fB-stipple\fP] [\fB-rpn\fP] [-\fItoolkitoption...\fP]
\fBxcalc -version\fP
\fBxcalc -help\fP
.fi
.SH DESCRIPTION
.I xcalc
is a scientific calculator desktop accessory that can emulate a TI-30
or an HP-10C.
.SH OPTIONS
.PP
\fIxcalc\fP accepts all of the standard toolkit command line options along
with these additional options:
.PP
.TP 8
.B \-stipple
This option indicates that the background of the calculator should be
drawn using a stipple of the foreground and background colors.  On monochrome
displays improves the appearance.
.PP
.TP 8
.B \-rpn
This option indicates that Reverse Polish Notation should be used.  In this
mode the calculator will look and behave like an HP-10C.  Without this flag,
it will emulate a TI-30.
.TP 8
.B \-help
This option indicates that \fIxcalc\fP should print its usage message and exit.
.TP 8
.B \-version
This option indicates that \fIxcalc\fP should print its version and exit.
.SH OPERATION
.PP
.I Pointer Usage:
Operations may be performed with pointer button 1, or in some cases,
with the keyboard.
Many common calculator operations have keyboard accelerators.
To quit, press pointer button 3 on the AC key of the TI calculator,
or the ON key of the HP calculator.
.PP
.I Calculator Key Usage (TI mode):
The numbered keys, the +/- key, and the +, -, *, /, and = keys all do exactly
what you would expect them to.  It should be noted that the operators obey
the standard rules of precedence.  Thus, entering "3+4*5=" results in "23",
not "35".  The parentheses can be used to override this.  For example,
"(1+2+3)*(4+5+6)=" results in "6*15=90".
.PP
The entire number in the calculator display can be selected, in order to
paste the result of a calculation into text.
.PP
The action procedures associated with each function are given below.  These
are useful if you are interested in defining a custom calculator.
The action used for all digit keys is \fBdigit(\fIn\fP)\fR, where \fIn\fR
is the corresponding digit, 0..9.
.TP 10
.B 1/x
Replaces the number in the display with its reciprocal.
The corresponding action procedure is \fBreciprocal()\fR.
.TP 10
.B x^2
Squares the number in the display.
The corresponding action procedure is \fBsquare()\fR.
.TP 10
.B SQRT
Takes the square root of the number in the display.
The corresponding action procedure is \fBsquareRoot()\fR.
.TP 10
.B CE/C
When pressed once, clears the number in the display without clearing the state
of the machine.  Allows you to re-enter a number if you make a mistake.
Pressing it twice clears the state, also.
The corresponding action procedure for TI mode is \fBclear()\fR.
.TP 10
.B AC
Clears the display, the state, and the memory.  Pressing it with the third
pointer button turns off the calculator, in that it exits the program.
The action procedure to clear the state is \fBoff()\fR; to quit, \fBquit()\fR.
.TP 10
.B INV
Invert function.  See the individual function keys for details.
The corresponding action procedure is \fBinverse()\fR.
.TP 10
.B sin
Computes the sine of the number in the display, as interpreted by the current
DRG mode (see DRG, below).  If inverted, it computes the arcsine.
The corresponding action procedure is \fBsine()\fR.
.TP 10
.B cos
Computes the cosine, or arccosine when inverted.
The corresponding action procedure is \fBcosine()\fP.
.TP 10
.B tan
Computes the tangent, or arctangent when inverted.
The corresponding action procedure is \fBtangent()\fP.
.TP 10
.B DRG
Changes the DRG mode, as indicated by 'DEG', 'RAD', or 'GRAD' at the bottom
of the calculator ``liquid crystal'' display.
When in 'DEG' mode, numbers in the display are taken as being
degrees.  In 'RAD' mode, numbers are in radians, and in 'GRAD' mode, numbers
are in grads.  When inverted, the DRG key has a feature of
converting degrees to radians to grads and vice-versa.  Example:  put the
calculator into 'DEG' mode, and enter "45 INV DRG".  The display should now
show something along the lines of ".785398", which is 45 degrees converted to
radians.
The corresponding action procedure is \fBdegree()\fP.
.TP 10
.B e
The constant 'e'.  (2.7182818...).
The corresponding action procedure is \fBe()\fR.
.TP 10
.B EE
Used for entering exponential numbers.  For example, to get "-2.3E-4" you'd
enter "2 . 3 +/- EE 4 +/-".
The corresponding action procedure is \fBscientific()\fR.
.TP 10
.B log
Calculates the log (base 10) of the number in the display.  When inverted,
it raises "10.0" to the number in the display.
For example, entering "3 INV log" should result in "1000".
The corresponding action procedure is \fBlogarithm()\fP.
.TP 10
.B ln
Calculates the log (base e) of the number in the display.  When inverted,
it raises "e" to the number in the display.  For example, entering "e ln"
should result in "1".
The corresponding action procedure is \fBnaturalLog()\fR.
.TP 10
.B y^x
Raises the number on the left to the power of the number on the right.  For
example "2 y^x 3 =" results in "8", which is 2^3.  For a further example,
"(1+2+3) y^x (1+2) =" equals "6 y^x 3" which equals "216".
The corresponding action procedure is \fBpower()\fR.
.TP 10
.B not
Performs a bitwise not.
The corresponding action procedure is \fBnot()\fP.
.TP 10
.B and
Performs a bitwise and.
The corresponding action procedure is \fBand()\fP.
.TP 10
.B or
Performs a bitwise or.
The corresponding action procedure is \fBor()\fP.
.TP 10
.B xor
Performs a bitwise exclusive or.
The corresponding action procedure is \fBxor()\fP.
.TP 10
.B trunc
Truncates the number in the display to an integer.
The corresponding action procedure is \fBtrunc()\fP.
.TP 10
.B PI
The constant 'pi'.  (3.1415927....)
The corresponding action procedure is \fBpi()\fR.
.TP 10
.B x!
Computes the factorial of the number in the display.  The number in the display
must be an integer in the range 0-500, though, depending on your math library,
it might overflow long before that.
The corresponding action procedure is \fBfactorial()\fR.
.TP 10
.B (
Left parenthesis.  The corresponding action procedure for TI calculators
is \fBleftParen()\fR.
.TP 10
.B )
Right parenthesis.  The corresponding action procedure for TI calculators
is \fBrightParen()\fR.
.TP 10
.B base
Changes the number base, as indicated by 'DEC', 'HEX, or 'OCT' at the bottom
of the calculator display.
When in 'DEC' mode, numbers in the display are taken as being decimal
(base 10).  In 'HEX' mode, numbers are in hexadecimal (base 16), and in 'OCT'
mode, numbers are in octal (base 8).
The corresponding action procedure is \fBbase()\fP.
.TP 10
.B shl
Performs an arithmetic bitwise shift left,  For example, entering "1 shl 2"
should result in "4".
The corresponding action procedure is \fBshl()\fR.
.TP 10
.B shr
Performs an arithmetic bitwise shift right,  For example, entering "8 shr 1"
should result in "4".
The corresponding action procedure is \fBshr()\fR.
.TP 10
.B mod
Performs the modulo operation, which calculates the remainder when dividing
the first number by the second.  For example, entering "14 mod 8" should
result in "6".
The corresponding action procedure is \fBmod()\fR.
.TP 10
.B /
Division.  The corresponding action procedure is \fBdivide()\fR.
.TP 10
.B *
Multiplication.  The corresponding action procedure is \fBmultiply()\fR.
.TP 10
.B -
Subtraction.  The corresponding action procedure is \fBsubtract()\fR.
.TP 10
.B +
Addition.  The corresponding action procedure is \fBadd()\fR.
.TP 10
.B =
Perform calculation.  The TI-specific action procedure is \fBequal()\fR.
.TP 10
.B STO
Copies the number in the display to the memory location.
The corresponding action procedure is \fBstore()\fR.
.TP 10
.B RCL
Copies the number from the memory location to the display.
The corresponding action procedure is \fBrecall()\fR.
.TP 10
.B SUM
Adds the number in the display to the number in the memory location.
The corresponding action procedure is \fBsum()\fR.
.TP 10
.B EXC
Swaps the number in the display with the number in the memory location.
The corresponding action procedure for the TI calculator is \fBexchange()\fR.
.TP 10
.B +/-
Negate; change sign.  The corresponding action procedure is \fBnegate()\fR.
.TP 10
.B .
Decimal point.  The action procedure is \fBdecimal()\fP.
.sp
.PP
.I Calculator Key Usage (RPN mode):
The number keys, CHS (change sign), +, -, *, /, and ENTR keys all do exactly
what you would expect them to do.  Many of the remaining keys are the same as
in TI mode.  The differences are detailed below.  The action procedure
for the ENTR key is \fBenter()\fR.
.sp
.TP 10
.B <-
This is a backspace key that can be used if you make a mistake while entering
a number.  It will erase digits from the display.  (See BUGS).
Inverse backspace will clear the X register.
The corresponding action procedure is \fBback()\fR.
.TP 10
.B ON
Clears the display, the state, and the memory.  Pressing it with the third
pointer button turns off the calculator, in that it exits the program.
To clear state, the action procedure is \fBoff\fR; to quit, \fBquit()\fR.
.TP 10
.B INV
Inverts the meaning of the function keys.  This would be the  \fIf\fR key
on an HP calculator, but \fIxcalc\fR does not display
multiple legends on each key.  See the individual function keys for details.
.TP 10
.B 10^x
Raises "10.0" to the number in the top of the stack.
When inverted, it calculates the log (base 10) of the number in the display.
The corresponding action procedure is \fBtenpower()\fR.
.TP 10
.B e^x
Raises "e" to the number in the top of the stack.
When inverted, it calculates the log (base e) of the number in the display.
The action procedure is \fBepower()\fR.
.TP 10
.B STO
Copies the number in the top of the stack to a memory location.  There are 10
memory locations.  The desired memory is specified by following this
key with a digit key.
.TP 10
.B RCL
Pushes the number from the specified memory location onto the stack.
.TP 10
.B SUM
Adds the number on top of the stack to the number in the specified
memory location.
.TP 10
.B x:y
Exchanges the numbers in the top two stack positions, the X and Y registers.
The corresponding action procedure is \fBXexchangeY()\fR.
.TP 10
.B R v
Rolls the stack downward.  When inverted, it rolls the stack upward.
The corresponding action procedure is \fBroll()\fR.
.TP 10
.I blank
These keys were used for programming functions on the HP-10C.  Their
functionality has not been duplicated in \fIxcalc\fR.
.PP
Finally, there are two additional action procedures:
\fBbell()\fR, which rings the bell;
and \fBselection()\fR, which performs a cut on the
entire number in the calculator's ``liquid crystal'' display.
.SH ACCELERATORS
.PP
Accelerators are shortcuts for entering commands.  \fIxcalc\fP provides
some sample keyboard accelerators; also users can customize accelerators.
The numeric keypad accelerators provided by \fIxcalc\fP
should be intuitively correct.
The accelerators defined by \fIxcalc\fP on the main keyboard are given below:
.PP
.TS
l l l l l.
TI Key	HP Key	Keyboard Accelerator	TI Function	HP Function
_
SQRT	SQRT	r	squareRoot()	squareRoot()
AC	ON	space	clear()	clear()
AC	<-	Delete	clear()	back()
AC	<-	Backspace	clear()	back()
AC	<-	Control-H	clear()	back()
AC		Clear	clear()
AC	ON	q	quit()	quit()
AC	ON	Control-C	quit()	quit()

INV	i	i	inverse()	inverse()
sin	s	s	sine()	sine()
cos	c	c	cosine()	cosine()
tan	t	t	tangent()	tangent()
DRG	DRG	d	degree()	degree()

e		e	e()
ln	ln	l	naturalLog()	naturalLog()
y^x	y^x	^	power()	power()

PI	PI	p	pi()	pi()
x!	x!	!	factorial()	factorial()
(		(	leftParen()
)		)	rightParen()

/	/	/	divide()	divide()
*	*	*	multiply()	multiply()
-	-	-	subtract()	subtract()
+	+	+	add()	add()
\&=		\&=	equal()

0..9	0..9	0..9	digit()	digit()
.	.	.	decimal()	decimal()
+/-	CHS	n	negate()	negate()

	x:y	x		XexchangeY()
	ENTR	Return		enter()
	ENTR	Linefeed		enter()
.TE
.PP
.SH CUSTOMIZATION
The application class name is XCalc.
.PP
\fIxcalc\fP has an enormous application defaults file which specifies
the position, label, and function of each key on the calculator.
It also gives translations to serve as keyboard accelerators.
Because these resources are not specified in the source code, you can create
a customized calculator by writing a private application defaults file,
using the Athena Command and Form widget resources to specify the size and
position of buttons, the label for each button, and the function of
each button.
.PP
The foreground and background colors of each calculator key can be
individually specified.
For the TI calculator, a classical color resource specification might be:
.sp
.br
XCalc.ti.Command.background:	gray50
.br
XCalc.ti.Command.foreground:	white
.sp
For each of buttons 20, 25, 30, 35, and 40, specify:
.br
XCalc.ti.button20.background:	black
.br
XCalc.ti.button20.foreground:	white
.sp
For each of buttons 22, 23, 24, 27, 28, 29, 32, 33, 34, 37, 38, and 39:
.br
XCalc.ti.button22.background:	white
.br
XCalc.ti.button22.foreground:	black
.SH WIDGET HIERARCHY
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIxcalc\fR.  In the notation below,
indentation indicates hierarchical structure.  The widget class name
is given first, followed by the widget instance name.
.nf
.ft CW
XCalc xcalc
        Form  ti  \fIor\fR  hp    \fI(the name depends on the mode)\fR
                Form  bevel
                        Form  screen
                                Label  M
                                Toggle  LCD
                                Label  INV
                                Label  DEG
                                Label  RAD
                                Label  GRAD
                                Label  P
                Command  button1
                Command  button2
                Command  button3
\fIand so on, ...\fR
                Command  button38
                Command  button39
                Command  button40
.ft
.fi
.SH APPLICATION RESOURCES
.PP
.TP 8
\fBrpn\fR (Class \fBRpn\fR)
Specifies that the rpn mode should be used.  The default is TI mode.
.TP 8
\fBstipple\fR (Class \fBStipple\fR)
Indicates that the background should be stippled.  The default is ``on''
for monochrome displays, and ``off'' for color displays.
.TP 8
\fBcursor\fR (Class \fBCursor\fR)
The name of the symbol used to represent the pointer.
The default is ``hand2''.
.fi
.SH COLORS
If you would like xcalc to use its ti colors, include the following
in the #ifdef COLOR section of the file you read with xrdb:
.sp 1
*customization:                 -color
.sp 1
.br
This will cause xcalc to pick up the colors in the app-defaults color
customization file:
.IR __apploaddir__/XCalc-color .
.fi
.SH "SEE ALSO"
X(__miscmansuffix__), xrdb(__appmansuffix__), the Athena Widget Set
.SH BUGS
.PP
HP mode is not completely debugged.  In particular, the stack is
not handled properly after errors.
.SH AUTHORS
John Bradley, University of Pennsylvania
.br
Mark Rosenstein, MIT Project Athena
.br
Donna Converse, MIT X Consortium
.\" --------------------------------------------------------------------
.\" Emacs settings
.\" --------------------------------------------------------------------
.\" Local Variables:
.\" mode: nroff
.\" tab-width: 15
.\" End:
