# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program. If not, see <http://www.gnu.org/licenses/>.
#
# In addition, as a special exception, the copyright holders give
# permission to link the code of portions of this program with the
# OpenSSL library under certain conditions as described in each
# individual source file, and distribute linked combinations
# including the two.
# You must obey the GNU General Public License in all respects
# for all of the code used other than OpenSSL.  If you modify
# file(s) with this exception, you may extend this exception to your
# version of the file(s), but you are not obligated to do so.  If you
# do not wish to do so, delete this exception statement from your
# version.  If you delete this exception statement from all source
# files in the program, then also delete it here.
"""Tests for the parse_args function."""

from __future__ import unicode_literals

import sys

from twisted.trial.unittest import TestCase

from ubuntu_kylin_sso.utils import ui as main


APP_NAME = 'Foo Bar'
DEFAULTS = dict(
    app_name=APP_NAME,
    help_text='',
    login_only=False,
    ping_url='',
    policy_url='',
    tc_url='',
    window_id=0,
)
DUMMY_TEXT = """Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed
risus orci, lacinia ac tincidunt fermentum, vestibulum suscipit orci. Aliquam
quis aliquet magna. Morbi vitae ligula ut libero porttitor imperdiet.
Vestibulum et ipsum sapien, pellentesque ultricies risus. Aenean in lectus
orci. Cras a lorem sollicitudin dui mollis varius. In hac habitasse platea
dictumst."""
PROGRAM = 'foo-bar'
SOME_URL = 'http://example.com/foo/bar'


class ParseArgsTestCase(TestCase):
    """Test case for the parse_args function."""

    def assert_parse_args_custom_field(self, option_name=None,
                                       option_value=None):
        """The args are correctly set when using a custom value."""
        expected = dict(DEFAULTS)
        argv = [PROGRAM, '--app_name=%s' % APP_NAME]

        if option_name is not None:
            if option_value is not None:
                argv.append('--%s=%s' % (option_name, option_value))
                expected[option_name] = option_value
            else:
                argv.append('--%s' % (option_name,))
                expected[option_name] = True

        self.patch(sys, 'argv', argv)

        result = main.parse_args()

        # Access to a protected member, pylint: disable=W0212
        self.assertEqual(expected, dict(result._get_kwargs()))

    def test_parse_args_defaults(self):
        """The args are correctly set when using defaults."""
        self.assert_parse_args_custom_field()

    def test_parse_args_help_text(self):
        """The args are correctly set when using a custom help_text."""
        self.assert_parse_args_custom_field('help_text', DUMMY_TEXT)

    def test_parse_args_ping_url(self):
        """The args are correctly set when using a custom ping_url."""
        self.assert_parse_args_custom_field('ping_url', SOME_URL)

    def test_parse_args_policy_url(self):
        """The args are correctly set when using a custom policy_url."""
        self.assert_parse_args_custom_field('policy_url', SOME_URL)

    def test_parse_args_tc_url(self):
        """The args are correctly set when using a custom tc_url."""
        self.assert_parse_args_custom_field('tc_url', SOME_URL)

    def test_parse_args_window_id(self):
        """The args are correctly set when using a custom window_id."""
        self.assert_parse_args_custom_field('window_id', 42)

    def test_parse_args_login_only(self):
        """The args are correctly set when using a custom login_only."""
        self.assert_parse_args_custom_field('login_only')
