#!/bin/sh

IEMMATRIX_H=iemmatrix_sources.h
IEMMATRIX_C=iemmatrix_sources.c

EGREP=egrep
SED=sed
LS=ls

#################################
## functions

head_h() {
 echo "/* iemmatrix-setup autogenerated header-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo
 echo "#ifndef IEMMATRIX_SOURCES_H__"
 echo "#define IEMMATRIX_SOURCES_H__"
}

foot_h() {
 echo "#endif /* IEMMATRIX_SOURCES_H__ */"
 echo ""
}

head_c() {
 echo "/* iemmatrix-setup autogenerated setup-file"
 echo " * generated by \"$0\""
 echo " * !! DO NOT MANUALLY EDIT  !!"
 echo " */"
 echo 
 echo "#include \"$IEMMATRIX_H\""
 echo
 echo "void iemmatrix_sources_setup(void)"
 echo "{"
}

foot_c() {
 echo "}"
 echo
}


##################################
## body

head_h > $IEMMATRIX_H
head_c > $IEMMATRIX_C

for i in $(${LS} *.c | ${EGREP} -v "iemmatrix.*\.c")
do
## each c-file in iemmatrix needs to have an ie<file>_setup()-function
## that calls all needed setup-functions
## any non-alpha-numeric-character is replaced by "_"
## e.g. "multiplex~.c" -> "z_multiplex__setup()"
  SETUPNAME=ie$(echo ${i%.c} | ${SED} -e 's/[^[:alnum:]]/_/g')_setup
  echo "void ${SETUPNAME}(void); /* $i */" >> $IEMMATRIX_H
  echo "	${SETUPNAME}(); /* $i */" >> $IEMMATRIX_C
done

foot_h >> $IEMMATRIX_H
foot_c >> $IEMMATRIX_C

