/***************************************************************************
 *
 * $Header: $
 *
 * Copyright (c) 1999-2000 ConnectTel, Inc. All Rights Reserved.
 *  
 * MODULE DESCRIPTION: 
 * This module specializes the RTEMS configuration for the  omniORB examples. 
 * It could be used as a starting point of an application using omniORB 
 * and RTEMS.
 * 
 * This file works along with $(RTEMS)/c/src/exec/sapi/include/confdefs.h,
 * so, changes to that file, would require updates of this file. There is
 * need to use this file, if RTEMS configuration is done in another place
 * on your application.
 *
 * by: Rosimildo da Silva:
 *     rdasilva@connecttel.com
 *     http://www.connecttel.com
 *
 * MODIFICATION/HISTORY:
 *
 * $Log: $
 ****************************************************************************/

#include <bsp.h>

/* functions */
#ifdef __cplusplus
extern "C" {
#endif

/* This seetings overwrite the ones defined in confdefs.h */


/*
 * PC386 BSP, usually has a lot of memory ( an old PC ),
 * and the number of resources here might be too high 
 * for your needs.
 */

/* list of device drivers required */
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER
/*
#define CONFIGURE_APPLICATION_NEEDS_TIMER_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_RTC_DRIVER
*/

/* let's use the IMFS as default */
#define CONFIGURE_USE_IMFS_AS_BASE_FILESYSTEM

/* misc settings */
#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS      50
#define CONFIGURE_MAXIMUM_DEVICES                     20

/* sometimes bsp.h defines this, so let's not touch it */
#ifndef CONFIGURE_NUMBER_OF_TERMIOS_PORTS
#define CONFIGURE_NUMBER_OF_TERMIOS_PORTS             3
#endif

/* Classic API resources */
#define CONFIGURE_MAXIMUM_TASKS                       200
#define CONFIGURE_MAXIMUM_TIMERS                      32
#define CONFIGURE_MAXIMUM_SEMAPHORES                  100
#define CONFIGURE_MAXIMUM_MESSAGE_QUEUES              20
#define CONFIGURE_MAXIMUM_PARTITIONS                  10
#define CONFIGURE_MAXIMUM_REGIONS                     10
#define CONFIGURE_MAXIMUM_PORTS                       1
#define CONFIGURE_MAXIMUM_PERIODS                     5
#define CONFIGURE_MAXIMUM_USER_EXTENSIONS             0


/* POSIX API resources */
#define CONFIGURE_MAXIMUM_POSIX_THREADS      		   128
#define CONFIGURE_MAXIMUM_POSIX_MUTEXES 		         128
#define CONFIGURE_MAXIMUM_POSIX_CONDITION_VARIABLES  	128
#define CONFIGURE_MAXIMUM_POSIX_KEYS         		   128
#define CONFIGURE_MAXIMUM_POSIX_TIMERS                10
#define CONFIGURE_MAXIMUM_POSIX_QUEUED_SIGNALS 		   100
#define CONFIGURE_MAXIMUM_POSIX_MESSAGE_QUEUES        10
#define CONFIGURE_MAXIMUM_POSIX_SEMAPHORES            10

void *POSIX_Init( void *argument );
#define CONFIGURE_INIT_TASK_STACK_SIZE	               (64*1024)
#define CONFIGURE_POSIX_INIT_THREAD_STACK_SIZE        (64*1024)
#define CONFIGURE_POSIX_INIT_THREAD_TABLE


/* iTRON API resources */
#define CONFIGURE_MAXIMUM_ITRON_TASKS                 0
#define CONFIGURE_MAXIMUM_ITRON_SEMAPHORES            0
#define CONFIGURE_MAXIMUM_ITRON_EVENTFLAGS            0
#define CONFIGURE_MAXIMUM_ITRON_MAILBOXES             0
#define CONFIGURE_MAXIMUM_ITRON_MESSAGE_BUFFERS       0
#define CONFIGURE_MAXIMUM_ITRON_PORTS                 0
#define CONFIGURE_MAXIMUM_ITRON_MEMORY_POOLS          0
#define CONFIGURE_MAXIMUM_ITRON_FIXED_MEMORY_POOLS    0


/* using default for the time being */
#define CONFIGURE_TICKS_PER_TIMESLICE                 50


/* should be include after all definitions */
#include <confdefs.h>


#ifdef __cplusplus
}
#endif
/* end of include file */
