/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util.xml;

import com.sourceforge.knecs.util.xml.DataUtils;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementUtils {
    public static Element[] findElements(Element root, String tagName, String[] data, String[] attrNames, String[] attrValues) {
        return ElementUtils.findElementsImpl(root, null, tagName, data, attrNames, attrValues);
    }

    public static Element[] findElements(Element root, String URI2, String localName, String[] data, String[] attrNames, String[] attrValues) {
        return ElementUtils.findElementsImpl(root, URI2, localName, data, attrNames, attrValues);
    }

    private static Element[] findElementsImpl(Element root, String URI2, String name, String[] data, String[] attrNames, String[] attrValues) {
        Vector vector = new Vector();
        ElementUtils.findElementsImpl(root, URI2, name, data, attrNames, attrValues, vector);
        Element[] array = new Element[vector.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Element)vector.get(i);
        }
        return array;
    }

    private static void findElementsImpl(Element root, String URI2, String name, String[] data, String[] attrNames, String[] attrValues, Vector vector) {
        boolean flag = false;
        if (name == null || URI2 == null && name.equals(root.getTagName()) || URI2 != null && URI2.equals(root.getNamespaceURI()) && name.equals(root.getLocalName())) {
            flag = true;
            if (data != null) {
                String[] rootData = DataUtils.getData(root);
                for (int i = 0; i < data.length; ++i) {
                    flag = false;
                    for (int j = 0; j < rootData.length; ++j) {
                        if (rootData[j].indexOf(data[i]) == -1) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) break;
                }
            }
            if (flag && attrNames != null && attrValues != null) {
                for (int i = 0; i < attrNames.length; ++i) {
                    String value = root.getAttribute(attrNames[i]);
                    if (value != null && value.equals(attrValues[i])) continue;
                    flag = false;
                    break;
                }
            }
        }
        if (flag) {
            vector.add(root);
        }
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            ElementUtils.findElementsImpl((Element)child, URI2, name, data, attrNames, attrValues, vector);
        }
    }
}

