/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/CrossLink.hpp"

namespace MsXpS
{
namespace libXpertMassCore
{


//            [3] [4] [5] [6]        [9]    [11]
// o---o---o---o---o--o---o---o---o---o---o---o---o---o---o
//             |   |__|   |       |   |       |       |
//             |          +-----------+       +-------+
//             |                  |
//             +------------------+
//
//
// In the example above, there are two cross-linked regions: [3--9]
// and [11--13].


class DECLSPEC CrossLinkedRegion
{
  public:
  CrossLinkedRegion();
  CrossLinkedRegion(std::size_t index_start, std::size_t index_stop);
  CrossLinkedRegion(const CrossLinkedRegion &other);

  ~CrossLinkedRegion();

  void setStartIndex(std::size_t index);
  std::size_t getStartIndex();

  void setStopIndex(std::size_t index);
  std::size_t getStopIndex();

  const std::vector<CrossLinkSPtr> &getCrossLinksCstRef() const;
  std::vector<CrossLinkSPtr> &getCrossLinksRef();

  std::size_t appendCrossLink(const CrossLinkSPtr &cross_link_sp);
  std::size_t appendCrossLinks(const std::vector<CrossLinkSPtr> &cross_links);

  std::size_t removeCrossLink(CrossLinkSPtr &cross_link_sp);
  std::size_t removeCrossLinkAt(std::size_t index);

  CrossLinkedRegion &operator=(const CrossLinkedRegion &other);

  protected:
  std::size_t m_startIndex;
  std::size_t m_stopIndex;

  std::vector<CrossLinkSPtr> m_crossLinks;
};

} // namespace libXpertMassCore
} // namespace MsXpS
