/*
 *
 * Copyright 2018 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef GRPC_CORE_LIB_SECURITY_SECURITY_CONNECTOR_LOCAL_SECURITY_CONNECTOR_H
#define GRPC_CORE_LIB_SECURITY_SECURITY_CONNECTOR_LOCAL_SECURITY_CONNECTOR_H

#include <grpc/support/port_platform.h>

#include "src/core/lib/security/context/security_context.h"

/**
 * This method creates a local channel security connector.
 *
 * - channel_creds: channel credential instance.
 * - request_metadata_creds: credential object which will be sent with each
 *   request. This parameter can be nullptr.
 * - target_name: the name of the endpoint that the channel is connecting to.
 * - args: channel args passed from the caller.
 * - sc: address of local channel security connector instance to be returned
 *   from the method.
 *
 * It returns GRPC_SECURITY_OK on success, and an error stauts code on failure.
 */
grpc_security_status grpc_local_channel_security_connector_create(
    grpc_channel_credentials* channel_creds,
    grpc_call_credentials* request_metadata_creds,
    const grpc_channel_args* args, const char* target_name,
    grpc_channel_security_connector** sc);

/**
 * This method creates a local server security connector.
 *
 * - server_creds: server credential instance.
 * - sc: address of local server security connector instance to be returned from
 *   the method.
 *
 * It returns GRPC_SECURITY_OK on success, and an error status code on failure.
 */
grpc_security_status grpc_local_server_security_connector_create(
    grpc_server_credentials* server_creds, grpc_server_security_connector** sc);

#endif /* GRPC_CORE_LIB_SECURITY_SECURITY_CONNECTOR_LOCAL_SECURITY_CONNECTOR_H \
        */
