# DIALS: Diffraction Integration for Advanced Light Sources

![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)
[![Coverage](https://codecov.io/gh/dials/dials/branch/main/graph/badge.svg)](https://codecov.io/gh/dials/dials)
[![Slack](https://img.shields.io/badge/chat-Slack-green)](https://join.slack.com/t/dials-support/shared_invite/zt-21fvg5n53-SG~882mWRs189GSMuemPfg)

X-ray crystallography for structural biology has benefited greatly from a number of advances in recent years including high performance pixel array detectors, new beamlines capable of delivering micron and sub-micron focus and new light sources such as XFELs. The DIALS project is a collaborative endeavour to develop new diffraction integration software to meet the data analysis requirements presented by these recent advances. There are three end goals: to develop an extensible framework for the development of algorithms to analyse X-ray diffraction data; the implementation of algorithms within this framework and finally a set of user facing tools using these algorithms to allow integration of data from diffraction experiments on synchrotron and free electron sources.

Website
-------

https://dials.github.io


Reference
---------

[Winter, G., Waterman, D. G., Parkhurst, J. M., Brewster, A. S., Gildea, R. J., Gerstel, M., Fuentes-Montero, L., Vollmar, M., Michels-Clark, T., Young, I. D., Sauter, N. K. and Evans, G. (2018) Acta Cryst. D74.](http://journals.iucr.org/d/issues/2018/02/00/di5011/index.html)

Funding
-------

DIALS development at Diamond Light Source is performed by employees of Diamond Light Source, and STFC via CCP4, supported by funding from Wellcome for grant 218270/Z/19/Z: DIALS: making serial crystallography data analysis accessible for biomedical researchers.

DIALS development at Lawrence Berkeley National Laboratory is supported by National Institutes of Health / National Institute of General Medical Sciences grant R24GM154040 as an NIH NIGMS US National Resource. Work at LBNL is performed under Department of Energy contract DE-AC02-05CH11231.
