#![doc = include_str!("../README.md")]
#![doc(html_root_url = "https://docs.rs/fts-sys/0.2.16")]
#![cfg(any(
    // This list must be kept synchronized with the check in `build.rs`.
    target_os = "android",
    target_os = "dragonfly",
    target_os = "freebsd",
    target_os = "hurd",
    target_os = "linux",
    target_os = "macos",
    target_os = "netbsd",
    target_os = "openbsd",
))]
#![warn(unsafe_op_in_unsafe_fn)]
#![allow(
    non_upper_case_globals,
    non_camel_case_types,
    non_snake_case,
    clippy::redundant_static_lifetimes
)]

#[cfg(test)]
mod tests;

#[allow(unused_imports)]
use libc::{dev_t, ino_t, nlink_t, stat};

#[repr(C)]
#[derive(Debug)]
pub struct FTS {
    _unused: [u8; 0],
}

include!(concat!(env!("OUT_DIR"), "/fts-sys.rs"));
