#include "snd.h"


/* -------------------------------- PROGRAM ICON -------------------------------- 
 */

static const char *snd_icon_xpm[] = {
"48 48 5 1",
". c white m white",
"B c black m black",
"a c white m white s basiccolor",
"r c red m black s cursorcolor",
"g c lightblue m black s listenercolor",
"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB............BBBB.........................a",
"aaBBBB..........BB....BB.......................a",
"aaBBBB........BB.......BB......................a",
"aaBBBB......BB..........BB.....................a",
"aaBBBB.....BB............BB....................a",
"aaBBBB....BB.............BB....................a",
"aaBBBB...BB..............BB....................a",
"aaBBBB..BB................BB...................a",
"aaBBBBBB..................BB...................a",
"aaBBBB.....................BB..................a",
"aaBBBB.....................BB.................Ba",
"aaBBBB......................BB...............BBa",
"aaBBBB.......................BB.............BB.a",
"aaBBBB.........................BB..........BB..a",
"aaBBBB..........................BB.......BB....a",
"aaBBBB...........................BB....BB......a",
"aaBBBB.............................BBB.........a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBB.........................................a",
"aaBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBaa",
"aaBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBaa",
"aaaaaa.........................................a",
"aaaaaa.........................................a",
"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"aggggggggggggggggggggggggggggggggggggggggggggggg",
"aggggggggggggggggggggggggggggggggggggggggggggggg",
"aggggggggggggggggggggggggggggggggggggggggggggggg",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"agggggggggggggggggggggggggggggggggggggggggggggga",
"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};

const char **snd_icon_bits(void) {return(snd_icon_xpm);}



#if USE_MOTIF

#include <X11/xpm.h>

static const char *mini_lock_xpm[] = {
"16 14 5 1",
"-      c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"------.XXX.-----",
"-----X.ooo.X----",
"----..oXXXo..---",
"----XoX...XoX---",
"----XoX.--XoX.--",
"----XoX.--XoX.--",
"---XXXXXXXXXXX--",
"---XOOOOOOOOOX.-",
"---XO.......OX.-",
"---XOOOOOOOOOX.-",
"---XO.......OX.-",
"---XOOOOOOOOOX.-",
"---XXXXXXXXXXX.-",
"----...........-"};

const char **mini_lock_bits(void) {return(mini_lock_xpm);}


static const char * close_icon_xpm[] = {
"16 14 5 1",
"-      c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"----------------",
"----------------",
"----------------",
"--XX.------XX.--",
"---XX.----XX.---",
"----XX.--XX.----",
"-----XX.XX.-----",
"------XXX.------",
"------XXX.------",
"-----XX.XX.-----",
"----XX.--XX.----",
"---XX.----XX.---",
"--XX.------XX.--",
"----------------"};

const char **close_icon_bits(void) {return(close_icon_xpm);}


static const char *blank_xpm[] = {
"18 18 5 1",
"-      c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------",
"------------------"};

const char **blank_bits(void) {return(blank_xpm);}


/* bomb for out-of-date in-core data fuse shortens with sparks flying off; */

static const char * mini_bomb0_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----.--","-X.#X....X---.--",
"-..oX.....---O-O","-.......O.-O-OO-","-......Xo.--OOO-","-X.....X.X--O---","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb1_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----.--","-X.#X....X---Y--",
"-..oX.....---YYY","-.......O.-YYOOY","-......Xo.--OOY-","-X.....X.X--Y---","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb2_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----Y--","-X.#X....X---YY-",
"-..oX.....---OYO","-.......O.--O-OO","-......Xo.--Y-Y-","-X.....X.X------","--.......----Y--","---X...X--------","----------------"};

static const char * mini_bomb3_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----Y--","-X.#X....X---OO-",
"-..oX.....-YYYYO","-.......O.----O-","-......Xo.----O-","-X.....X.X----Y-","--.......-------","---X...X--------","------------YY--"};

static const char * mini_bomb4_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.--Y-","----...-----.---","---.....----O---","--.X#o...---OO--","-X.#X....X-YOYO-",
"-..oX.....--OYY-","-.......O.------","-......Xo.-Y----","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb5_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----Y---","---.....----OO--","--.X#o...--OOO--","-X.#X....X---YO-",
"-..oX.....---YY-","-.......O.-----Y","-......Xo.-----O","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb6_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...------","------.---.-----","-----.-----OO-O-","----...-----YO--","---.....----O---","--.X#o...-YY-OO-","-X.#X....X--Y---",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-----OO","---X...X------Y-","----------------"};

static const char * mini_bomb7_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------...----OO","------.---O-----","-----.-----OOYY-","----...-----YOO-","---.....-YY-O---","--.X#o...-------","-X.#X....X--YO--",
"-..oX.....---Y--","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","--------------YY"};

static const char * mini_bomb8_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------..Y------","------.--OO-----","-----.----OOO-Y-","----...---OO--O-","---.....-YY----O","--.X#o...-------","-X.#X....X------",
"-..oX.....--YO--","-.......O.---O--","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb9_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-------YOY--O---","------.---YO----","-----.----OYY---","----...---------","---.....----YY--","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.--YO--","-......Xo.---Y--","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb10_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-----OYYOYOO----","-----YOO--YO----","-----.-----YY---","----...---------","---.....--------","--.X#o...----OO-","-X.#X....X---Y--",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb11_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-----OOYOO--O---","----OOY----O----","---OOOO---------","----...---------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......---OO--","---X...X--------","----------------"};

static const char * mini_bomb12_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"-----OO---------","--YYOOYYY-------","YYOOOOYYYY------","--OOOOO---------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","------------YY--"};

static const char * mini_bomb13_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"----------------","----OOY---------","--YYYYY-Y-------","--Y-OOO---------","---.YOY.--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static const char * mini_bomb14_xpm[] = {
"16 14 7 1","-      c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","Y      c yellow",
"----------------","----------------","----------------","----------------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

const char **mini_bomb_bits(int n)
{
  switch (n)
    {
    case 0: return(mini_bomb0_xpm); break;
    case 1: return(mini_bomb1_xpm); break;
    case 2: return(mini_bomb2_xpm); break;
    case 3: return(mini_bomb3_xpm); break;
    case 4: return(mini_bomb4_xpm); break;
    case 5: return(mini_bomb5_xpm); break;
    case 6: return(mini_bomb6_xpm); break;
    case 7: return(mini_bomb7_xpm); break;
    case 8: return(mini_bomb8_xpm); break;
    case 9: return(mini_bomb9_xpm); break;
    case 10: return(mini_bomb10_xpm); break;
    case 11: return(mini_bomb11_xpm); break;
    case 12: return(mini_bomb12_xpm); break;
    case 13: return(mini_bomb13_xpm); break;
    case 14: return(mini_bomb14_xpm); break;
    default: return(NULL); break;
    }
}


static const char * mini_glass0_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOOOOOOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.cooooooooooc.-","-cooooooooooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass1_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOOoOOOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---coooOooooc---","--cooooooooooc--","-.cooooooooooc.-","-coooooOooooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass2_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOOoooOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.cOoc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.cooooOoooooc.-","-cooooOOOoooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass3_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOoooOOOO.c-","-.cOOOOooOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.coOc.-----","-------cc-------",
"-----.cOoc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.coooOooooooc.-","-coooOOOOoooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass4_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOooooOOO.c-","-.cOOOOoooOOOc.-","--cOOOOOoOOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.coOc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.coooOOOooooc.-","-coooOOOOoooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass5_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOoooooOO.c-","-.cOOOOooooOOc.-","--cOOOOOoOOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--coooOooooooc--","-.coooOOOOoooc.-","-coooOOOOOooooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass6_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOOoooooOO.c-","-.cOOOOooooOOc.-","--cOOOOoooOOOc--","----cOOOOoOc----","-----.cOOc.-----","-------cc-------",
"-----.cOoc.-----","----coooOooc----","---cooooooooc---","--cooooooooooc--","-.coooOOOOoooc.-","-coooOOOOOOoooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass7_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OOooooooOO.c-","-.cOOOoooooOOc.-","--cOOOOoOoOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooOoooc---","--coooOOoooooc--","-.cooOOOOOoooc.-","-cooOOOOOOOoooc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass8_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.OoooooooOO.c-","-.cOOooooooOOc.-","--cOOOooooOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--coooOOOooooc--","-.cooOOOOOoooc.-","-cooOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass9_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.ooooooooOO.c-","-.cOoooooooOOc.-","--cOOoooooOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOoooc----","---cooooooooc---","--cooOOOOOOOoc--","-.coOOOOOOOOooc.-","-coOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass10_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cOoooooooooc.-","--cOOooooooOOc--","----cOOooOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooOOOOooc---","--cooOOOOOOooc--","-.coOOOOOOOOoc.-","-cOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass11_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cOOooooooooc--","----cOOooOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooOoooc----","---cooOOOOooc---","--coOOOOOOOooc--","-.cOOOOOOOOOoc.-","-cOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass12_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cOoooOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOOooc----","---coOOOOOooc---","--cOOOOOOOOOoc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass13_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cooooooc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOOooc----","---cOOOOOOOOc---","--cOOOOOOOOOOc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

static const char * mini_glass14_xpm[] = {"16 14 6 1","-      c None s None",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cooooooc----","-----.cooc.-----","-------cc-------",
"-----.cOOc.-----","----cOOOOOOc----","---cOOOOOOOOc---","--cOOOOOOOOOOc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

const char **mini_glass_bits(int n)
{
  switch (n)
    {
    case 0: return(mini_glass0_xpm); break;
    case 1: return(mini_glass1_xpm); break;
    case 2: return(mini_glass2_xpm); break;
    case 3: return(mini_glass3_xpm); break;
    case 4: return(mini_glass4_xpm); break;
    case 5: return(mini_glass5_xpm); break;
    case 6: return(mini_glass6_xpm); break;
    case 7: return(mini_glass7_xpm); break;
    case 8: return(mini_glass8_xpm); break;
    case 9: return(mini_glass9_xpm); break;
    case 10: return(mini_glass10_xpm); break;
    case 11: return(mini_glass11_xpm); break;
    case 12: return(mini_glass12_xpm); break;
    case 13: return(mini_glass13_xpm); break;
    case 14: return(mini_glass14_xpm); break;
    default: return(NULL); break;
    }
}

/* from HView */
/* there are at least 3 stop signs in Snd.  This one for the Motif name-box,
 *    the big one for the toolbar (below)
 */
static const char *stop_sign_xpm[] = {
"17 17 3 1",
"-      c None s None",
".      c red",
"X      c white",
"----XXXXXXXXX----",
"---X.........X---",
"--X...........X--",
"-X.............X-",
"X...............X",
"X...............X",
"X.XX.XXX.XX..XX.X",
"X.X...X.X..X.X.XX",
"X..X..X.X..X.XX.X",
"X.XX..X..XX..X..X",
"X...............X",
"X...............X",
"X...............X",
"-X.............X-",
"--X...........X--",
"---X.........X---",
"----XXXXXXXXX----"};

const char **stop_sign_bits(void) {return(stop_sign_xpm);}



/* these are taken mainly from emacs */

static const char *zoom_in_xpm[] = {
"24 24 132 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #D7D7D7",
"e 	c #F5F5F5",
"f 	c #FAFAFA",
"g 	c #FBFBFB",
"h 	c #F8F8F8",
"i 	c #F0F0F0",
"j 	c #E1E1E1",
"k 	c #C2C2C2",
"l 	c #434343",
"m 	c #0F0F0F",
"n 	c #1F1F1F",
"o 	c #B9B9B9",
"p 	c #D6D6D6",
"q 	c #F9F9F9",
"r 	c #FDFDFD",
"s 	c #454545",
"t 	c #F2F2F2",
"u 	c #ECECEC",
"v 	c #E4E4E4",
"w 	c #ABABAB",
"x 	c #0E0E0E",
"y 	c #1B1B1B",
"z 	c #6D6D6D",
"A 	c #FEFEFE",
"B 	c #FCFCFC",
"C 	c #EEEEEE",
"D 	c #E6E6E6",
"E 	c #575757",
"F 	c #090909",
"G 	c #141414",
"H 	c #A8A8A8",
"I 	c #D8D8D8",
"J 	c #F6F6F6",
"K 	c #F4F4F4",
"L 	c #DCDCDC",
"M 	c #9B9B9B",
"N 	c #060606",
"O 	c #111111",
"P 	c #C5C5C5",
"Q 	c #DFDFDF",
"R 	c #444444",
"S 	c #424242",
"T 	c #EDEDED",
"U 	c #BFBFBF",
"V 	c #C6C6C6",
"W 	c #E3E3E3",
"X 	c #414141",
"Y 	c #EAEAEA",
"Z 	c #E0E0E0",
"` 	c #BABABA",
" .	c #050505",
"..	c #0B0B0B",
"+.	c #A5A5A5",
"@.	c #D1D1D1",
"#.	c #939393",
"$.	c #020202",
"%.	c #0A0A0A",
"&.	c #5F5F5F",
"*.	c #D9D9D9",
"=.	c #EBEBEB",
"-.	c #E9E9E9",
";.	c #D4D4D4",
">.	c #000000",
",.	c #E2E2E2",
"'.	c #3F3F3F",
").	c #DADADA",
"!.	c #CBCBCB",
"~.	c #3B3B3B",
"{.	c #D5D5D5",
"].	c #C8C8C8",
"^.	c #BDBDBD",
"/.	c #515151",
"(.	c #C7C7C7",
"_.	c #CDCDCD",
":.	c #B8B8B8",
"<.	c #030303",
"[.	c #313131",
"}.	c #999999",
"|.	c #BBBBBB",
"1.	c #B6B6B6",
"2.	c #909090",
"3.	c #2B2B2B",
"4.	c #010101",
"5.	c #7A7A7A",
"6.	c #9A9A9A",
"7.	c #777777",
"8.	c #3C3C3C",
"9.	c #686868",
"0.	c #797979",
"a.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f g f h e i j k l m             ",
"    n o p 2 q g r s s g h t u v w x             ",
"  y z 7 j e f r A s s B q e C D 1 E F           ",
"  G H I C J q B A s s g h K C D L M N           ",
"  O P Q 3 e R R s s s R l S T 6 1 U N           ",
"  x V W u t l R R R R l S X Y Z d `  .          ",
"  ..+.j 2 T 5 K J l l 4 3 u v 1 @.#.$.          ",
"  %.&.*.j D =.C 3 X X T -.v 1 ;.~ : >.          ",
"    %.= I L ,.6 D '.'.W Q ).;.!.* $.            ",
"    N ~.c 7 ;.).1 ).1 I {.] ].^.$ >.            ",
"       ./.k (.!.c _.!.!.].k :.s >.              ",
"        <.[.}.|.^.8 8 8 1.2.3.>.>.>.            ",
"          4.<.X 5.6.6.7.8.>.>.  >.>.>.>.        ",
"              >.>.>.>.>.>.        , , >.>.      ",
"                                  >.9.. >.>.    ",
"                                    >.0.a.>.>.  ",
"                                      >.9.n >.  ",
"                                        >.>.    ",
"                                                "};

static const char *zoom_out_xpm[] = {
"24 24 131 2",
"  	c None",
". 	c #343434",
"+ 	c #2D2D2D",
"@ 	c #292929",
"# 	c #262626",
"$ 	c #2E2E2E",
"% 	c #303030",
"& 	c #737373",
"* 	c #A1A1A1",
"= 	c #B4B4B4",
"- 	c #B2B2B2",
"; 	c #9D9D9D",
"> 	c #676767",
", 	c #202020",
"' 	c #1C1C1C",
") 	c #272727",
"! 	c #616161",
"~ 	c #CACACA",
"{ 	c #CFCFCF",
"] 	c #D0D0D0",
"^ 	c #CECECE",
"/ 	c #C9C9C9",
"( 	c #C1C1C1",
"_ 	c #A7A7A7",
": 	c #4C4C4C",
"< 	c #131313",
"[ 	c #222222",
"} 	c #757575",
"| 	c #D3D3D3",
"1 	c #DBDBDB",
"2 	c #E7E7E7",
"3 	c #EFEFEF",
"4 	c #F3F3F3",
"5 	c #F1F1F1",
"6 	c #E5E5E5",
"7 	c #D2D2D2",
"8 	c #BCBCBC",
"9 	c #5E5E5E",
"0 	c #101010",
"a 	c #212121",
"b 	c #5B5B5B",
"c 	c #CCCCCC",
"d 	c #D7D7D7",
"e 	c #F5F5F5",
"f 	c #FAFAFA",
"g 	c #FBFBFB",
"h 	c #F8F8F8",
"i 	c #F0F0F0",
"j 	c #E1E1E1",
"k 	c #C2C2C2",
"l 	c #434343",
"m 	c #0F0F0F",
"n 	c #1F1F1F",
"o 	c #B9B9B9",
"p 	c #D6D6D6",
"q 	c #F9F9F9",
"r 	c #FDFDFD",
"s 	c #FCFCFC",
"t 	c #F2F2F2",
"u 	c #ECECEC",
"v 	c #E4E4E4",
"w 	c #ABABAB",
"x 	c #0E0E0E",
"y 	c #1B1B1B",
"z 	c #6D6D6D",
"A 	c #FEFEFE",
"B 	c #EEEEEE",
"C 	c #E6E6E6",
"D 	c #575757",
"E 	c #090909",
"F 	c #141414",
"G 	c #A8A8A8",
"H 	c #D8D8D8",
"I 	c #F6F6F6",
"J 	c #F4F4F4",
"K 	c #DCDCDC",
"L 	c #9B9B9B",
"M 	c #060606",
"N 	c #111111",
"O 	c #C5C5C5",
"P 	c #DFDFDF",
"Q 	c #444444",
"R 	c #454545",
"S 	c #424242",
"T 	c #EDEDED",
"U 	c #BFBFBF",
"V 	c #C6C6C6",
"W 	c #E3E3E3",
"X 	c #414141",
"Y 	c #EAEAEA",
"Z 	c #E0E0E0",
"` 	c #BABABA",
" .	c #050505",
"..	c #0B0B0B",
"+.	c #A5A5A5",
"@.	c #D1D1D1",
"#.	c #939393",
"$.	c #020202",
"%.	c #0A0A0A",
"&.	c #5F5F5F",
"*.	c #D9D9D9",
"=.	c #EBEBEB",
"-.	c #E9E9E9",
";.	c #D4D4D4",
">.	c #000000",
",.	c #E2E2E2",
"'.	c #DADADA",
").	c #CBCBCB",
"!.	c #3B3B3B",
"~.	c #D5D5D5",
"{.	c #C8C8C8",
"].	c #BDBDBD",
"^.	c #515151",
"/.	c #C7C7C7",
"(.	c #CDCDCD",
"_.	c #B8B8B8",
":.	c #030303",
"<.	c #313131",
"[.	c #999999",
"}.	c #BBBBBB",
"|.	c #B6B6B6",
"1.	c #909090",
"2.	c #2B2B2B",
"3.	c #010101",
"4.	c #7A7A7A",
"5.	c #9A9A9A",
"6.	c #777777",
"7.	c #3C3C3C",
"8.	c #686868",
"9.	c #797979",
"0.	c #3A3A3A",
"                                                ",
"              . + @ # # #                       ",
"          $ % & * = - ; > , '                   ",
"        ) ! = ~ { ] ^ / ( _ : <                 ",
"      [ } ~ | 1 2 3 4 5 6 7 8 9 0               ",
"    a b c d 6 e f g f h e i j k l m             ",
"    n o p 2 q g r r s g h t u v w x             ",
"  y z 7 j e f r A A r s q e B C 1 D E           ",
"  F G H B I q s A A r g h J B C K L M           ",
"  N O P 3 e Q Q R R R Q l S T 6 1 U M           ",
"  x V W u t l Q Q Q Q l S X Y Z d `  .          ",
"  ..+.j 2 T 5 J I I e 4 3 u v 1 @.#.$.          ",
"  %.&.*.j C =.B 3 3 B T -.v 1 ;.~ : >.          ",
"    %.= H K ,.6 C C 2 W P '.;.).* $.            ",
"    M !.c 7 ;.'.1 '.1 H ~.] {.].$ >.            ",
"       .^.k /.).c (.).).{.k _.R >.              ",
"        :.<.[.}.].8 8 8 |.1.2.>.>.>.            ",
"          3.:.X 4.5.5.6.7.>.>.  >.>.>.>.        ",
"              >.>.>.>.>.>.        , , >.>.      ",
"                                  >.8.. >.>.    ",
"                                    >.9.0.>.>.  ",
"                                      >.8.n >.  ",
"                                        >.>.    ",
"                                                "};

static const char *cut_xpm[] = {
"24 24 40 1",
" 	c None",
".	c #000000",
"+	c #C9C7C2",
"@	c #E6E4E0",
"#	c #EFEEED",
"$	c #494946",
"%	c #73726E",
"&	c #F0EEED",
"*	c #7F7D75",
"=	c #F2F1EF",
"-	c #D2CFC8",
";	c #E7E7E4",
">	c #BAB5AB",
",	c #565653",
"'	c #EDECE9",
")	c #A4A097",
"!	c #817F7E",
"~	c #4E4C48",
"{	c #F6F5F4",
"]	c #474541",
"^	c #EFEEEC",
"/	c #8C8B8A",
"(	c #F3F2F0",
"_	c #77746D",
":	c #323232",
"<	c #EBEBEA",
"[	c #605D58",
"}	c #F5F4F3",
"|	c #CECCC7",
"1	c #363634",
"2	c #6F6E6D",
"3	c #BEBDBB",
"4	c #EAE7E4",
"5	c #B8B5B1",
"6	c #474747",
"7	c #DAD8D4",
"8	c #9B9996",
"9	c #161615",
"0	c #6D6B6A",
"a	c #3A3837",
"                        ",
"                        ",
"      .        .        ",
"      .        .        ",
"     .+.      .@.       ",
"     .#$      %@.       ",
"     .&*.    .=-.       ",
"     .;>,    %').       ",
"      !#*.  .=-~        ",
"      .{>]  ~^>.        ",
"       /(_.:<-[         ",
"       .}|123>.         ",
"        .456>.          ",
"         .78..          ",
"         .90a.          ",
"     .............      ",
"     . ...  ... ...     ",
"    ..  ..   ..  ..     ",
"    .    .   .    .     ",
"    ..  ..   ..  ..     ",
"     ....     .. .      ",
"     ....     ....      ",
"                        ",
"                        "};

static const char *paste_xpm[] = {
"24 24 89 1",
" 	c None",
".	c #000000",
"+	c #B9B9B9",
"@	c #FEFEFE",
"#	c #F9F9F9",
"$	c #757575",
"%	c #F5F5E8",
"&	c #565651",
"*	c #FFFFFF",
"=	c #A0A0A0",
"-	c #939393",
";	c #7C7C7C",
">	c #C5C5BB",
",	c #CFC6A0",
"'	c #D7CEAA",
")	c #ADA689",
"!	c #4B483C",
"~	c #6D6D6D",
"{	c #6C6C6C",
"]	c #A9A9A9",
"^	c #3D3A30",
"/	c #979178",
"(	c #C1B898",
"_	c #8A793D",
":	c #C3BB9A",
"<	c #AFA78A",
"[	c #444236",
"}	c #FAFAFA",
"|	c #EFEFEF",
"1	c #C7C7C7",
"2	c #D8D8D8",
"3	c #D2D2D2",
"4	c #7B7B7B",
"5	c #302E26",
"6	c #89846C",
"7	c #C4BC9A",
"8	c #847235",
"9	c #C5C5C5",
"0	c #A7A7A7",
"a	c #ADADAD",
"b	c #9A9A9A",
"c	c #9B9B9B",
"d	c #868686",
"e	c #424242",
"f	c #847033",
"g	c #C9C09E",
"h	c #464337",
"i	c #35332A",
"j	c #2D2B23",
"k	c #C6BE9D",
"l	c #826F33",
"m	c #7F7964",
"n	c #4C493C",
"o	c #171612",
"p	c #13120F",
"q	c #3E3B31",
"r	c #282210",
"s	c #474438",
"t	c #B3B3B3",
"u	c #D6D6D6",
"v	c #B7AE90",
"w	c #B1AA8C",
"x	c #37352B",
"y	c #151410",
"z	c #8F8F8F",
"A	c #989898",
"B	c #C6C6C6",
"C	c #B9B293",
"D	c #11100D",
"E	c #434035",
"F	c #636363",
"G	c #767676",
"H	c #AAA48B",
"I	c #A5A086",
"J	c #A19A7F",
"K	c #312F26",
"L	c #AFA88C",
"M	c #050403",
"N	c #12110E",
"O	c #A9A489",
"P	c #A39E85",
"Q	c #EBE7D0",
"R	c #D2C9A5",
"S	c #A29053",
"T	c #8E7C3D",
"U	c #88793B",
"V	c #806C2F",
"W	c #78652B",
"X	c #251F0C",
"       ....             ",
" ......+@#$......       ",
".%%%%%&*=-;&>%%%,.      ",
".%''')!*~{]^/(''_.      ",
".%::<[}|123456<78.      ",
".%''!900abcde!)'f.      ",
".%g:6hijjjjj56<kl.      ",
".%'''////////(''l.      ",
".%g::::mnopppp^qr....   ",
".%'''''st***********u.  ",
".%vwwwwx*************.  ",
".%'''''y*0zzA**Bz*zB*.  ",
".%CwwwwD*************.  ",
".%'''''E*~F*GzzB*Bz**.  ",
".%HIJJJK*************.  ",
".%'''''E*0zz*zzzB*Az*.  ",
".%LIJJJM*************.  ",
".%'''''N*~F*GzzB*Bz**.  ",
".%OPJJJK*************.  ",
".Q'''''E*0zz*zzzB*Az*.  ",
".RSTUVWX*************.  ",
" .......u***********u.  ",
"        .............   ",
"                        "};

static const char *preferences_xpm[] = {
"24 24 87 1",
" 	c None",
".	c #000000",
"+	c #BAB5AB",
"@	c #D0CDC6",
"#	c #88857D",
"$	c #C9C6BE",
"%	c #CCC8C1",
"&	c #E5E3E0",
"*	c #FFFFFF",
"=	c #757575",
"-	c #2E2E2E",
";	c #F6F5F5",
">	c #CCCCCC",
",	c #AFAFAF",
"'	c #D3D1CB",
")	c #C1C0BF",
"!	c #F0EFED",
"~	c #797772",
"{	c #DCDCDC",
"]	c #A5A19C",
"^	c #EAE9E5",
"/	c #F3F1F0",
"(	c #EDEDED",
"_	c #A19D96",
":	c #C1BDB4",
"<	c #DBD8D3",
"[	c #D9D6D1",
"}	c #89857E",
"|	c #FCFCFC",
"1	c #EAE9E6",
"2	c #F5F4F3",
"3	c #C6C2BA",
"4	c #F0EFEE",
"5	c #F4F4F3",
"6	c #CBC7C0",
"7	c #ECECEB",
"8	c #676560",
"9	c #54524D",
"0	c #777676",
"a	c #797978",
"b	c #85827E",
"c	c #79756F",
"d	c #7590AE",
"e	c #A4BAD0",
"f	c #90A6BE",
"g	c #9F9F9E",
"h	c #BEBDBC",
"i	c #B8B4AD",
"j	c #87837C",
"k	c #D3DFEA",
"l	c #A2AEBC",
"m	c #9DB6CE",
"n	c #637B95",
"o	c #E2E2E2",
"p	c #EEEEED",
"q	c #849CB6",
"r	c #D7E2ED",
"s	c #8D98A5",
"t	c #9DB8D2",
"u	c #607791",
"v	c #EDEDEC",
"w	c #99ADC3",
"x	c #DFE7F0",
"y	c #8193A9",
"z	c #586D84",
"A	c #5B7189",
"B	c #F1F1F1",
"C	c #EEEDEB",
"D	c #A7A6A5",
"E	c #726F6A",
"F	c #A1B4C8",
"G	c #EEF3F6",
"H	c #60768F",
"I	c #DEDDDC",
"J	c #787776",
"K	c #4E4E4D",
"L	c #91A6BE",
"M	c #F0F4F7",
"N	c #97A5B6",
"O	c #BFBEBD",
"P	c #AAAAA9",
"Q	c #ACACAB",
"R	c #B0C6DB",
"S	c #EDF2F6",
"T	c #818A95",
"U	c #6C85A1",
"V	c #C0D1E2",
"       ..               ",
"      .+@#.             ",
"       .$%+.        ..  ",
"        .&$.       .*=. ",
"    ..  -;$.      .*>,. ",
"   .' ..)!+~.     .{,.  ",
"   .]%%^/+++.    .(..   ",
"    ._:%$<[+}.  .|.     ",
"     .....123}..>.      ",
"          .456.,.       ",
"           .7.,..       ",
"            .,.89.      ",
"        ....,.0abc.     ",
"       .def.. .ghij.    ",
"      .dklmn.  .op6}.   ",
"     .qrsntu.   .v/$}.  ",
"    .wxyztdA.    .BCDE..",
"   .FGyHtdA.      .IJK,.",
"  .LMNHtdA.        .OPQ.",
"  .RSTtdA..         ... ",
"  .UtVLA..              ",
"   .UUn..               ",
"    ...                 ",
"                        "};


static const char * close_xpm[] = {
"24 24 5 1",
"       c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"      XX.      XX.      ",
"       XX.    XX.       ",
"        XX.  XX.        ",
"         XX.XX.         ",
"          XXX.          ",
"          XXX.          ",
"         XX.XX.         ",
"        XX.  XX.        ",
"       XX.    XX.       ",
"      XX.      XX.      ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        "};

    
static const char *redo_xpm[] = {
"24 24 42 1",
" 	c None",
".	c #000000",
"+	c #939A8D",
"@	c #BAD09D",
"#	c #92998C",
"$	c #818F71",
"%	c #ADBDA0",
"&	c #C2D5AA",
"*	c #D1DFBE",
"=	c #BED2A3",
"-	c #99A28F",
";	c #A8BCA6",
">	c #D5E1C6",
",	c #CDDCBC",
"'	c #D2E0BF",
")	c #C5D7AE",
"!	c #919889",
"~	c #8C9A7F",
"{	c #D4E0C5",
"]	c #D3E0C1",
"^	c #BFD3A6",
"/	c #9BAA87",
"(	c #B5C3A9",
"_	c #92AD62",
":	c #7C9B40",
"<	c #59702D",
"[	c #7F8E6B",
"}	c #C8D9B2",
"|	c #85A24D",
"1	c #53692A",
"2	c #A4B690",
"3	c #9BB572",
"4	c #6D8839",
"5	c #95A77E",
"6	c #8BA859",
"7	c #657255",
"8	c #98AF74",
"9	c #AFC394",
"0	c #6D7A5B",
"a	c #9CAF84",
"b	c #748261",
"c	c #879772",
"                        ",
"                        ",
"                        ",
"            .           ",
"            ..          ",
"            .+.         ",
"         ....@#.        ",
"        .$%&*=@-.       ",
"       .;>,')@@@!.      ",
"      .~{]*^@@@@@/.     ",
"      .(>_::::::<.      ",
"     .[}|::::::1.       ",
"     .23:<...:1.        ",
"     .@:4.  .<.         ",
"     .@:..  ..          ",
"     .56.   .           ",
"     .78.               ",
"      .9.               ",
"      .0a.              ",
"       .bc.             ",
"        ...             ",
"                        ",
"                        ",
"                        "};

static const char *undo_xpm[] = {
"24 24 31 1",
" 	c None",
".	c #000000",
"+	c #EFE5BA",
"@	c #EFE7C1",
"#	c #EED680",
"$	c #EFE4B6",
"%	c #D5B75D",
"&	c #B29544",
"*	c #D1B051",
"=	c #C0AF73",
"-	c #C0A048",
";	c #986B07",
">	c #D1940C",
",	c #E0B74C",
"'	c #D9C374",
")	c #8F6406",
"!	c #D59D1C",
"~	c #B1933F",
"{	c #DFB74A",
"]	c #CCB76D",
"^	c #B8820A",
"/	c #D9A72E",
"(	c #D7A62C",
"_	c #C7B26A",
":	c #D4B150",
"<	c #A39256",
"[	c #E2CB79",
"}	c #C9B46B",
"|	c #8D7E4A",
"1	c #AE9C5C",
"2	c #96864F",
"                        ",
"                        ",
"                        ",
"          .             ",
"         ..             ",
"        .+.             ",
"       .@#....          ",
"      .$####%&.         ",
"     .+#######*.        ",
"    .=#########-.       ",
"     .;>>>>>>,#'..      ",
"      .)>>>>>>!#~.      ",
"       .)>...;>{].      ",
"        .;. ..^/#.      ",
"         ..  ..>#.      ",
"          .   .(_.      ",
"              .:<.      ",
"              .[.       ",
"             .}|.       ",
"            .12.        ",
"             ..         ",
"                        ",
"                        ",
"                        "};

static const char *save_xpm[] = {
"24 24 220 2",
"  	c None",
". 	c #000000",
"+ 	c #C3D7F4",
"@ 	c #A9CDE5",
"# 	c #75757A",
"$ 	c #EFC5BB",
"% 	c #F1C8BE",
"& 	c #F0C6BC",
"* 	c #EEBCB2",
"= 	c #EEBEB5",
"- 	c #EEC1B8",
"; 	c #EDBFB6",
"> 	c #E9B7AD",
", 	c #E9B8AF",
"' 	c #E9B9B1",
") 	c #E5BFBA",
"! 	c #737277",
"~ 	c #B3CDE3",
"{ 	c #A1BED6",
"] 	c #BBD6E8",
"^ 	c #8AAAC5",
"/ 	c #605F68",
"( 	c #E08D7E",
"_ 	c #E0826E",
": 	c #E0806E",
"< 	c #DC7A68",
"[ 	c #DC8171",
"} 	c #DA7868",
"| 	c #D48173",
"1 	c #D47D6E",
"2 	c #CE7265",
"3 	c #CF7264",
"4 	c #CE7567",
"5 	c #C4675B",
"6 	c #C36558",
"7 	c #626169",
"8 	c #87A3B7",
"9 	c #567187",
"0 	c #BAD5E9",
"a 	c #88A7C3",
"b 	c #686670",
"c 	c #C8817B",
"d 	c #CB7C74",
"e 	c #CB7A73",
"f 	c #CB7B73",
"g 	c #CC7C72",
"h 	c #CB7D73",
"i 	c #BF6B64",
"j 	c #CC7A70",
"k 	c #C16A62",
"l 	c #CC7C73",
"m 	c #C2655B",
"n 	c #C36459",
"o 	c #BA6C6A",
"p 	c #819EB6",
"q 	c #547086",
"r 	c #B6D3E7",
"s 	c #87ABC1",
"t 	c #737373",
"u 	c #FFFFFF",
"v 	c #83A0B8",
"w 	c #526C80",
"x 	c #B9D3E7",
"y 	c #85A4BF",
"z 	c #4F697C",
"A 	c #B9D3E6",
"B 	c #84A3BF",
"C 	c #CECECE",
"D 	c #CDCDCD",
"E 	c #BFBFBF",
"F 	c #88A4BB",
"G 	c #486276",
"H 	c #B7D2E7",
"I 	c #82A0BB",
"J 	c #636363",
"K 	c #465E70",
"L 	c #B5CAE5",
"M 	c #7FA2B9",
"N 	c #87A3BA",
"O 	c #455C6D",
"P 	c #AECCE5",
"Q 	c #7DA0B6",
"R 	c #C5C5C5",
"S 	c #546069",
"T 	c #B0D1E4",
"U 	c #83A1B6",
"V 	c #735B5B",
"W 	c #515C64",
"X 	c #AACEE3",
"Y 	c #7B9BB2",
"Z 	c #7A8E9A",
"` 	c #7A7A7A",
" .	c #6B6F72",
"..	c #6F6F6F",
"+.	c #696969",
"@.	c #6F777E",
"#.	c #86A2B9",
"$.	c #3A515D",
"%.	c #A9C9E2",
"&.	c #7494AF",
"*.	c #829FB7",
"=.	c #7F9DB6",
"-.	c #7E9CB5",
";.	c #7998B2",
">.	c #85A1B8",
",.	c #8CA7BD",
"'.	c #8AA5BB",
").	c #364A59",
"!.	c #ABC4E2",
"~.	c #7294AD",
"{.	c #6F90AC",
"].	c #7192AE",
"^.	c #414A4E",
"/.	c #424A51",
"(.	c #525B63",
"_.	c #626F79",
":.	c #5F6C76",
"<.	c #5C6971",
"[.	c #5A666F",
"}.	c #58636B",
"|.	c #57636A",
"1.	c #3B5360",
"2.	c #39424B",
"3.	c #7897B3",
"4.	c #A4B9CB",
"5.	c #364853",
"6.	c #AAC9E2",
"7.	c #7091AA",
"8.	c #6F8FA7",
"9.	c #4A5359",
"0.	c #97938C",
"a.	c #DFDDDA",
"b.	c #E3E1DE",
"c.	c #EBEAE8",
"d.	c #EAE9E7",
"e.	c #CFCEC9",
"f.	c #C9C6C0",
"g.	c #9B968E",
"h.	c #566168",
"i.	c #4B657A",
"j.	c #54738C",
"k.	c #AAC6DD",
"l.	c #34464E",
"m.	c #AAC9E1",
"n.	c #6C8EA6",
"o.	c #6C8CA4",
"p.	c #40474D",
"q.	c #DAD8D3",
"r.	c #E7E6E2",
"s.	c #67655E",
"t.	c #524F47",
"u.	c #D9D7D4",
"v.	c #C7C5BF",
"w.	c #C0BCB5",
"x.	c #B8B3AB",
"y.	c #434C54",
"z.	c #4D697F",
"A.	c #4F6F84",
"B.	c #B3CADC",
"C.	c #313E49",
"D.	c #A8C8E1",
"E.	c #6B8DA6",
"F.	c #728FA4",
"G.	c #E2E1DD",
"H.	c #F0EFEC",
"I.	c #CDCAC6",
"J.	c #C2BFB9",
"K.	c #CAC6C0",
"L.	c #DCDAD7",
"M.	c #4B555D",
"N.	c #4E697F",
"O.	c #BACCDC",
"P.	c #A4C4DE",
"Q.	c #698BA3",
"R.	c #708AA1",
"S.	c #383E43",
"T.	c #E0DEDA",
"U.	c #514E46",
"V.	c #4F4C44",
"W.	c #C7C4BE",
"X.	c #CBC8C2",
"Y.	c #E1E0DC",
"Z.	c #E9E8E6",
"`.	c #475158",
" +	c #4E6879",
".+	c #4D6C80",
"++	c #A3C3DB",
"@+	c #383F43",
"#+	c #778999",
"$+	c #6E899E",
"%+	c #65859C",
"&+	c #33383C",
"*+	c #D7D4D0",
"=+	c #D6D4D0",
"-+	c #4E4A43",
";+	c #4D4942",
">+	c #D1CEC9",
",+	c #E6E5E2",
"'+	c #EDECEA",
")+	c #454F55",
"!+	c #486173",
"~+	c #4D6678",
"{+	c #A1C1DA",
"]+	c #373C40",
"^+	c #0C0D0F",
"/+	c #4E5E6A",
"(+	c #5B6E7C",
"_+	c #4F5B62",
":+	c #A4A099",
"<+	c #CCC9C3",
"[+	c #D7D5D1",
"}+	c #E4E2E0",
"|+	c #DDDBD7",
"1+	c #B8B5B0",
"2+	c #3E474D",
"3+	c #4A6176",
"4+	c #4A6070",
"5+	c #9BC3D8",
"6+	c #363C41",
"7+	c #28323E",
"                                                ",
"                                                ",
"    . . . . . . . . . . . . . . . . . . .       ",
"  . + @ # $ % & * = - ; > , > , ' ) ! ~ { .     ",
"  . ] ^ / ( _ : < [ } | 1 2 3 4 5 6 7 8 9 .     ",
"  . 0 a b c d e f g h i j k l m n o b p q .     ",
"  . r s t u u u u u u u u u u u u u t v w .     ",
"  . x y t u u u u u u u u u u u u u t v z .     ",
"  . A B t C D D D D D D D D D D D E t F G .     ",
"  . H I J u u u u u u u u u u u u u t F K .     ",
"  . L M t u u u u u u u u u u u u u t N O .     ",
"  . P Q t C D D D D D D D D D D D R t N S .     ",
"  . T U V u u u u u u u u u u u u u t v W .     ",
"  . X Y Z ` t t t t t  ...t t t t +.@.#.$..     ",
"  . %.&.p v #.*.=.-.*.;.#.>.>.N *.,.v '.)..     ",
"  . !.~.{.].^./.(._.:.<.[.}.|.(.1.2.3.4.5..     ",
"  . 6.7.8.9.0.a.b.c.c.d.a.e.f.g.h.i.j.k.l..     ",
"  . m.n.o.p.q.r.s.t.t.u.v.w.x.e.y.z.A.B.C..     ",
"  . D.E.F.p.G.H.s.t.t.I.J.w.K.L.M.N.A.O.C..     ",
"  . P.Q.R.S.T.c.U.V.V.W.w.X.Y.Z.`. +.+++@+.     ",
"  . #+$+%+&+*+=+-+;+;+w.>+,+'+,+)+!+~+{+]+.     ",
"    ^+/+(+_+:+w.x.<+<+[+}+d.|+1+2+3+4+5+6+.     ",
"      . . . . . . . . . . . . . . . . 7+.       ",
"                                                "};

static const char *saveas_xpm[] = {
"24 24 262 2",
"  	c None",
". 	c #000000",
"+ 	c #FBE73B",
"@ 	c #F2B64D",
"# 	c #FCEB3D",
"$ 	c #F7B544",
"% 	c #5D502C",
"& 	c #C3D7F4",
"* 	c #A9CDE5",
"= 	c #75757A",
"- 	c #EFC5BB",
"; 	c #F1C8BE",
"> 	c #F0C6BC",
", 	c #EEBCB2",
"' 	c #EEBEB5",
") 	c #EEC1B8",
"! 	c #EDBFB6",
"~ 	c #E8B6AC",
"{ 	c #FCE93B",
"] 	c #F7B545",
"^ 	c #6C5F34",
"/ 	c #434345",
"( 	c #92A7B9",
"_ 	c #96B1C7",
": 	c #BBD6E8",
"< 	c #8AAAC5",
"[ 	c #605F68",
"} 	c #E08D7E",
"| 	c #E0826E",
"1 	c #E0806E",
"2 	c #DC7A68",
"3 	c #DC8171",
"4 	c #DA7868",
"5 	c #D38072",
"6 	c #FAE43A",
"7 	c #F4B244",
"8 	c #615030",
"9 	c #783E35",
"0 	c #4D4C52",
"a 	c #7790A2",
"b 	c #526D82",
"c 	c #BAD5E9",
"d 	c #88A7C3",
"e 	c #686670",
"f 	c #C8817B",
"g 	c #CB7C74",
"h 	c #CB7A73",
"i 	c #CB7B73",
"j 	c #CC7C72",
"k 	c #CA7C72",
"l 	c #F9DF39",
"m 	c #F3AF42",
"n 	c #614F2F",
"o 	c #8F4941",
"p 	c #945554",
"q 	c #5B5A62",
"r 	c #7B97AE",
"s 	c #536F84",
"t 	c #B6D3E7",
"u 	c #87ABC1",
"v 	c #737373",
"w 	c #FFFFFF",
"x 	c #FEFEFE",
"y 	c #F9DC38",
"z 	c #EFB44D",
"A 	c #665A32",
"B 	c #BBBBBB",
"C 	c #CDCDCD",
"D 	c #E4E4E4",
"E 	c #6E6E6E",
"F 	c #819EB6",
"G 	c #526C80",
"H 	c #B9D3E7",
"I 	c #85A4BF",
"J 	c #F8D837",
"K 	c #F0A93F",
"L 	c #655930",
"M 	c #BABABA",
"N 	c #CCCCCC",
"O 	c #E5E5E5",
"P 	c #F7F7F7",
"Q 	c #727272",
"R 	c #83A0B8",
"S 	c #4F697C",
"T 	c #B9D3E6",
"U 	c #84A3BF",
"V 	c #CECECE",
"W 	c #F6D236",
"X 	c #EDA43E",
"Y 	c #5C5130",
"Z 	c #949494",
"` 	c #A3A3A3",
" .	c #B7B7B7",
"..	c #C6C6C6",
"+.	c #BDBDBD",
"@.	c #88A4BB",
"#.	c #486276",
"$.	c #B7D2E7",
"%.	c #82A0BB",
"&.	c #636363",
"*.	c #FDFDFD",
"=.	c #D7AE74",
"-.	c #61562F",
";.	c #465E70",
">.	c #B5CAE5",
",.	c #7FA2B9",
"'.	c #4F4115",
").	c #87A3BA",
"!.	c #455C6D",
"~.	c #AECCE5",
"{.	c #7DA0B6",
"].	c #CBCBCB",
"^.	c #9B9B9B",
"/.	c #9C9C9C",
"(.	c #A7A7A7",
"_.	c #B8B8B8",
":.	c #C5C5C5",
"<.	c #546069",
"[.	c #B0D1E4",
"}.	c #83A1B6",
"|.	c #735B5B",
"1.	c #F0F0F0",
"2.	c #D9D9D9",
"3.	c #D3D3D3",
"4.	c #E1E1E1",
"5.	c #EDEDED",
"6.	c #F8F8F8",
"7.	c #515C64",
"8.	c #AACEE3",
"9.	c #7B9BB2",
"0.	c #7A8E9A",
"a.	c #7A7A7A",
"b.	c #707070",
"c.	c #6C6C6C",
"d.	c #6F6F6F",
"e.	c #6A6E71",
"f.	c #696969",
"g.	c #6F777E",
"h.	c #86A2B9",
"i.	c #3A515D",
"j.	c #A9C9E2",
"k.	c #7494AF",
"l.	c #7E9BB4",
"m.	c #7D9AB3",
"n.	c #7998B2",
"o.	c #85A1B8",
"p.	c #829FB7",
"q.	c #8CA7BD",
"r.	c #8AA5BB",
"s.	c #364A59",
"t.	c #ABC4E2",
"u.	c #7294AD",
"v.	c #6F90AC",
"w.	c #7192AE",
"x.	c #414A4E",
"y.	c #424A51",
"z.	c #525B63",
"A.	c #626F79",
"B.	c #5F6C76",
"C.	c #5C6971",
"D.	c #5A666F",
"E.	c #58636B",
"F.	c #57636A",
"G.	c #3B5360",
"H.	c #39424B",
"I.	c #7897B3",
"J.	c #A4B9CB",
"K.	c #364853",
"L.	c #AAC9E2",
"M.	c #7091AA",
"N.	c #6F8FA7",
"O.	c #4A5359",
"P.	c #97938C",
"Q.	c #DFDDDA",
"R.	c #E3E1DE",
"S.	c #EBEAE8",
"T.	c #EAE9E7",
"U.	c #CFCEC9",
"V.	c #C9C6C0",
"W.	c #9B968E",
"X.	c #566168",
"Y.	c #4B657A",
"Z.	c #54738C",
"`.	c #AAC6DD",
" +	c #34464E",
".+	c #AAC9E1",
"++	c #6C8EA6",
"@+	c #6C8CA4",
"#+	c #40474D",
"$+	c #DAD8D3",
"%+	c #E7E6E2",
"&+	c #67655E",
"*+	c #524F47",
"=+	c #D9D7D4",
"-+	c #C7C5BF",
";+	c #C0BCB5",
">+	c #B8B3AB",
",+	c #434C54",
"'+	c #4D697F",
")+	c #4F6F84",
"!+	c #B3CADC",
"~+	c #313E49",
"{+	c #A8C8E1",
"]+	c #6B8DA6",
"^+	c #728FA4",
"/+	c #E2E1DD",
"(+	c #F0EFEC",
"_+	c #CDCAC6",
":+	c #C2BFB9",
"<+	c #CAC6C0",
"[+	c #DCDAD7",
"}+	c #4B555D",
"|+	c #4E697F",
"1+	c #BACCDC",
"2+	c #A4C4DE",
"3+	c #698BA3",
"4+	c #708AA1",
"5+	c #383E43",
"6+	c #E0DEDA",
"7+	c #514E46",
"8+	c #4F4C44",
"9+	c #C7C4BE",
"0+	c #CBC8C2",
"a+	c #E1E0DC",
"b+	c #E9E8E6",
"c+	c #475158",
"d+	c #4E6879",
"e+	c #4D6C80",
"f+	c #A3C3DB",
"g+	c #383F43",
"h+	c #778999",
"i+	c #6E899E",
"j+	c #65859C",
"k+	c #33383C",
"l+	c #D7D4D0",
"m+	c #D6D4D0",
"n+	c #4E4A43",
"o+	c #4D4942",
"p+	c #D1CEC9",
"q+	c #E6E5E2",
"r+	c #EDECEA",
"s+	c #454F55",
"t+	c #486173",
"u+	c #4D6678",
"v+	c #A1C1DA",
"w+	c #373C40",
"x+	c #0C0D0F",
"y+	c #4E5E6A",
"z+	c #5B6E7C",
"A+	c #4F5B62",
"B+	c #A4A099",
"C+	c #CCC9C3",
"D+	c #D7D5D1",
"E+	c #E4E2E0",
"F+	c #DDDBD7",
"G+	c #B8B5B0",
"H+	c #3E474D",
"I+	c #4A6176",
"J+	c #4A6070",
"K+	c #9BC3D8",
"L+	c #363C41",
"M+	c #28323E",
"                                . .             ",
"                              . + @ .           ",
"    . . . . . . . . . . . . . # $ % . . .       ",
"  . & * = - ; > , ' ) ! ~ . { ] ^ . / ( _ .     ",
"  . : < [ } | 1 2 3 4 5 . 6 7 8 . 9 0 a b .     ",
"  . c d e f g h i j k . l m n . o p q r s .     ",
"  . t u v w w w w x . y z A . B C D E F G .     ",
"  . H I v w w w x . J K L . M N O P Q R S .     ",
"  . T U v V C N . W X Y . Z `  ...+.v @.#..     ",
"  . $.%.&.w w *.. =.-.. M N D P *.w v @.;..     ",
"  . >.,.v w x . '.. . M N D P *.w w v ).!..     ",
"  . ~.{.v V ].. . ^./.(._...].C C :.v ).<..     ",
"  . [.}.|.w *.1.2.3.4.5.6.x w w w w v R 7..     ",
"  . 8.9.0.a.Q b.c.c.d.e.E v v v v f.g.h.i..     ",
"  . j.k.F R h.F l.m.F n.h.o.o.).p.q.R r.s..     ",
"  . t.u.v.w.x.y.z.A.B.C.D.E.F.z.G.H.I.J.K..     ",
"  . L.M.N.O.P.Q.R.S.S.T.Q.U.V.W.X.Y.Z.`. +.     ",
"  . .+++@+#+$+%+&+*+*+=+-+;+>+U.,+'+)+!+~+.     ",
"  . {+]+^+#+/+(+&+*+*+_+:+;+<+[+}+|+)+1+~+.     ",
"  . 2+3+4+5+6+S.7+8+8+9+;+0+a+b+c+d+e+f+g+.     ",
"  . h+i+j+k+l+m+n+o+o+;+p+q+r+q+s+t+u+v+w+.     ",
"    x+y+z+A+B+;+>+C+C+D+E+T.F+G+H+I+J+K+L+.     ",
"      . . . . . . . . . . . . . . . . M+.       ",
"                                                "};

static const char *new_xpm[] = {
"24 24 127 2",
"  	c None",
". 	c #000000",
"+ 	c #D3D3D3",
"@ 	c #F6F6F6",
"# 	c #FFFFFF",
"$ 	c #F9F9F9",
"% 	c #DADADA",
"& 	c #585858",
"* 	c #C7C7C7",
"= 	c #D1D1D1",
"- 	c #D6D6D6",
"; 	c #FEFEFE",
"> 	c #FDFDFD",
", 	c #C0C0C0",
"' 	c #E1E1E1",
") 	c #F0F0F0",
"! 	c #9B9B9B",
"~ 	c #FCFCFB",
"{ 	c #FBFBFB",
"] 	c #AFAFAE",
"^ 	c #E9E9E9",
"/ 	c #DFDFDF",
"( 	c #8F8F8F",
"_ 	c #FAFAF9",
": 	c #F9F9F8",
"< 	c #A4A4A3",
"[ 	c #F4F4F4",
"} 	c #CFCFCF",
"| 	c #A2A2A2",
"1 	c #F8F8F7",
"2 	c #F8F7F6",
"3 	c #9E9E9E",
"4 	c #F7F6F5",
"5 	c #F6F6F4",
"6 	c #F4F3F2",
"7 	c #DEDDDC",
"8 	c #D3D2D0",
"9 	c #B7B7B5",
"0 	c #9F9E9D",
"a 	c #706F6F",
"b 	c #65625A",
"c 	c #F5F4F3",
"d 	c #F2F2F0",
"e 	c #E4E4E2",
"f 	c #DAD9D7",
"g 	c #D8D8D6",
"h 	c #CDCCCA",
"i 	c #AFAEAC",
"j 	c #88847B",
"k 	c #F3F3F1",
"l 	c #EFEFED",
"m 	c #EEEDEB",
"n 	c #EDECEA",
"o 	c #E9E8E6",
"p 	c #D5D4D3",
"q 	c #C4C3C2",
"r 	c #8F8A81",
"s 	c #F6F5F4",
"t 	c #F5F5F3",
"u 	c #F1F1EF",
"v 	c #F1F0EE",
"w 	c #ECEBE9",
"x 	c #EAE9E7",
"y 	c #E5E4E2",
"z 	c #E4E3E0",
"A 	c #D2D1CE",
"B 	c #8D887E",
"C 	c #F3F2F1",
"D 	c #F0F0EE",
"E 	c #F0EFED",
"F 	c #EFEEEC",
"G 	c #E8E7E5",
"H 	c #E5E4E1",
"I 	c #E2E1DE",
"J 	c #E1DFDC",
"K 	c #979288",
"L 	c #A49E93",
"M 	c #E8E7E4",
"N 	c #E7E6E3",
"O 	c #E3E2DF",
"P 	c #E2E0DD",
"Q 	c #E1E0DC",
"R 	c #E0DFDB",
"S 	c #A19C90",
"T 	c #EDEDEB",
"U 	c #EBEAE8",
"V 	c #E9E8E5",
"W 	c #E6E4E1",
"X 	c #E3E2DE",
"Y 	c #DFDEDA",
"Z 	c #DEDDD9",
"` 	c #DDDCD8",
" .	c #A19B90",
"..	c #E7E5E2",
"+.	c #E4E3DF",
"@.	c #DCDBD7",
"#.	c #E6E5E2",
"$.	c #E5E4E0",
"%.	c #E2E1DD",
"&.	c #DBD9D5",
"*.	c #D9D7D3",
"=.	c #9F998D",
"-.	c #E4E2DF",
";.	c #DDDBD7",
">.	c #DCDAD6",
",.	c #D8D6D2",
"'.	c #9E988D",
").	c #EDEDED",
"!.	c #E1E0DD",
"~.	c #E0DEDA",
"{.	c #D8D6D1",
"].	c #D7D5D1",
"^.	c #9D978B",
"/.	c #E1DFDB",
"(.	c #DEDCD8",
"_.	c #D7D6D1",
":.	c #D5D3CE",
"<.	c #9B958A",
"[.	c #999891",
"}.	c #A39E92",
"|.	c #A39D92",
"1.	c #A39D91",
"2.	c #A29C90",
"3.	c #A19B8F",
"4.	c #9D978C",
"5.	c #9B968A",
"6.	c #676359",
"                                                ",
"      . . . . . . . . . . . . .                 ",
"    . + @ # # # # # # # # $ % & .               ",
"    . @ # # # # # # # # # # * = - .             ",
"    . # # # # # # # ; # ; > , ' ) ! .           ",
"    . # # # # # ; > ~ > ~ { ] ^ # / ( .         ",
"    . # # # ; > ~ { _ { _ : < ) # [ } | .       ",
"    . # ; > ~ { _ : 1 : 1 2 3 . . . . . . .     ",
"    . # ~ { _ : 1 2 4 2 4 5 6 7 8 9 0 a b .     ",
"    . # _ : 1 2 4 5 c 5 c 6 d e f g h i j .     ",
"    . # 1 2 4 5 c 6 k 6 k d l m n o p q r .     ",
"    . # s t 6 6 k d u d u v m w x y z A B .     ",
"    . # 6 C d D l v E v E F w G H z I J K .     ",
"    . # 6 C d D l v E v E F w G H z I J L .     ",
"    . # D l l F m n n n n w M N O P Q R S .     ",
"    . # T n w w w U V U V V H W X Y Z `  ..     ",
"    . # U o o G M M N M N ..+.X R Z ` @. ..     ",
"    . # N #.#.#.H W $.W $.+.%.R Z @.&.*.=..     ",
"    . $ z O X -.+.%.X %.X Q Q Z ;.>.*.,.'..     ",
"    . ).!.J Q R %.R Q R Q Y ~.;.>.*.{.].^..     ",
"    . = /.~.Y Z R Z ~.Z ~.(.(.>.>.,._.:.<..     ",
"    . [.}.L |.1.|.S 2.S 2.3. .=.=.4.4.5.6..     ",
"      . . . . . . . . . . . . . . . . . .       ",
"                                                "};

static const char *open_xpm[] = {
"24 24 173 2",
"  	c None",
". 	c #000000",
"+ 	c #010100",
"@ 	c #B5B8A5",
"# 	c #E4E7D2",
"$ 	c #878A76",
"% 	c #33342B",
"& 	c #0B0B0B",
"* 	c #E2E5CF",
"= 	c #CFD4AF",
"- 	c #CED3AE",
"; 	c #B2B696",
"> 	c #2D2D25",
", 	c #23241D",
"' 	c #9D9F90",
") 	c #C6CAA6",
"! 	c #C4C9A5",
"~ 	c #C6CBA7",
"{ 	c #C7CCA8",
"] 	c #C9CEA9",
"^ 	c #555847",
"/ 	c #1A1B15",
"( 	c #20201A",
"_ 	c #D4D6C2",
": 	c #BEC2A0",
"< 	c #B3B896",
"[ 	c #B0B595",
"} 	c #B3B797",
"| 	c #B6BB99",
"1 	c #BBC09E",
"2 	c #BCC19F",
"3 	c #81856C",
"4 	c #3E3F32",
"5 	c #010101",
"6 	c #DADDC8",
"7 	c #AFB494",
"8 	c #AAAF8F",
"9 	c #A3A789",
"0 	c #A6AA8B",
"a 	c #A9AD8E",
"b 	c #A7AB8D",
"c 	c #A4A88A",
"d 	c #A1A588",
"e 	c #AAAD96",
"f 	c #B3B5A5",
"g 	c #B8BBAA",
"h 	c #BABCAB",
"i 	c #C1C3B2",
"j 	c #C7CAB7",
"k 	c #CACDBB",
"l 	c #BABDA8",
"m 	c #0C0C09",
"n 	c #DDDFCB",
"o 	c #969B7E",
"p 	c #9DA286",
"q 	c #95987C",
"r 	c #96997E",
"s 	c #9A9D81",
"t 	c #999D80",
"u 	c #9DA184",
"v 	c #A5AA8B",
"w 	c #A4A98A",
"x 	c #A3A889",
"y 	c #A2A588",
"z 	c #A2A587",
"A 	c #9FA386",
"B 	c #9B9E83",
"C 	c #898D74",
"D 	c #D8DBC9",
"E 	c #84866E",
"F 	c #7D8169",
"G 	c #151612",
"H 	c #D7DAC9",
"I 	c #797D67",
"J 	c #3D3F34",
"K 	c #E0E0D9",
"L 	c #EBEDDD",
"M 	c #E8EBD9",
"N 	c #E7EAD8",
"O 	c #E3E6D4",
"P 	c #DEE1D0",
"Q 	c #DADCCC",
"R 	c #DADCD1",
"S 	c #2B2C28",
"T 	c #D7DAC6",
"U 	c #6F735E",
"V 	c #0D0D0D",
"W 	c #F4F4EC",
"X 	c #CACFAB",
"Y 	c #C6CBA8",
"Z 	c #C2C6A4",
"` 	c #ABB091",
" .	c #23251E",
"..	c #494B3D",
"+.	c #DCDCD4",
"@.	c #EAECDD",
"#.	c #CDD2AD",
"$.	c #CCD1AC",
"%.	c #CACFAA",
"&.	c #BABF9D",
"*.	c #B5B999",
"=.	c #81836C",
"-.	c #070806",
";.	c #D5D8C4",
">.	c #161616",
",.	c #F2F2EA",
"'.	c #C9CEAA",
").	c #C8CDA9",
"!.	c #C4C9A6",
"~.	c #C1C5A3",
"{.	c #BCC09F",
"].	c #B6BB9A",
"^.	c #B0B494",
"/.	c #9DA185",
"(.	c #535445",
"_.	c #B6B8A7",
":.	c #747470",
"<.	c #ECECE2",
"[.	c #C3C8A5",
"}.	c #C2C7A4",
"|.	c #C0C5A2",
"1.	c #BFC4A1",
"2.	c #BDC2A0",
"3.	c #B9BD9C",
"4.	c #B9BE9D",
"5.	c #A9AD8F",
"6.	c #A3A78A",
"7.	c #80836D",
"8.	c #020201",
"9.	c #A6A998",
"0.	c #B8BC9B",
"a.	c #AFB394",
"b.	c #ACB091",
"c.	c #A8AC8E",
"d.	c #A6AA8C",
"e.	c #9FA286",
"f.	c #9B9F83",
"g.	c #9A9D82",
"h.	c #8A8D75",
"i.	c #4F5243",
"j.	c #070705",
"k.	c #9E9F91",
"l.	c #E5E6DA",
"m.	c #ADB192",
"n.	c #A5A98C",
"o.	c #9FA387",
"p.	c #999D81",
"q.	c #95987E",
"r.	c #92957B",
"s.	c #8C8F76",
"t.	c #8A8D74",
"u.	c #71735F",
"v.	c #080908",
"w.	c #E3E5D9",
"x.	c #C0C3AF",
"y.	c #94987C",
"z.	c #8F9379",
"A.	c #8B8F75",
"B.	c #8A8E74",
"C.	c #888C73",
"D.	c #858970",
"E.	c #868971",
"F.	c #82866E",
"G.	c #80836C",
"H.	c #7D8069",
"I.	c #797C66",
"J.	c #727560",
"K.	c #717460",
"L.	c #71745F",
"M.	c #6A6D59",
"N.	c #434538",
"O.	c #080907",
"P.	c #050504",
"                                                ",
"                                                ",
"                                                ",
"    . . . . . . .                               ",
"  + @ # # # # # $ %                             ",
"  & * = = = - - ; >                             ",
", ' * ) ! ~ { ] ] ^ /                           ",
"( _ : < [ } | 1 2 3 4 5 . . . . . . .           ",
", 6 7 8 9 0 8 a b c d e f g h i j k l .         ",
"m n o p q r s t r u v w x y 9 z A B C .         ",
". D E F G . . . . . . . . . . . . . . . 5 5     ",
". H I J K L M M M M M M M M M M M N O P Q R S   ",
". T U V W = = = = = = = = = - - - X Y Z 1 `  .  ",
". T ..+.@.#.- - #.- #.#.#.#.#.$.%.Y Z &.*.=.-.  ",
". ;.>.,.X %.X %.'.%.'.{ ).).Y !.~.{.].^./.(.m   ",
". _.:.<.[.}.}.Z |.Z 1.2.|.2.3.4.} [ 5.6.7.8.    ",
". 9.+.0.0.*.} } [ [ a.a.a.b.c.d.e.f.g.h.i.j.    ",
". k.l.m.5.d.n.6.6.d o.e.f.p.q.r.s.t.t.u.v.      ",
". w.x.y.z.A.B.C.C.D.E.F.G.H.I.J.K.L.M.N.O.      ",
"  . . . . . . . . . . . . . . . . . . P.        ",
"                                                ",
"                                                ",
"                                                ",
"                                                "};

static const char *exit_xpm[] = {
"24 24 140 2",
"  	c None",
". 	c #000000",
"+ 	c #D6D6D4",
"@ 	c #BDBDBC",
"# 	c #A8A8A4",
"$ 	c #92928F",
"% 	c #727370",
"& 	c #61615E",
"* 	c #20201F",
"= 	c #F1F1EF",
"- 	c #E6E6E4",
"; 	c #DADAD7",
"> 	c #CFCFCD",
", 	c #C4C4C1",
"' 	c #A8A8A5",
") 	c #767674",
"! 	c #777774",
"~ 	c #1E1E1D",
"{ 	c #B9B9B7",
"] 	c #AEAEAC",
"^ 	c #8F8F8D",
"/ 	c #262626",
"( 	c #414140",
"_ 	c #E9836C",
": 	c #DEDEDC",
"< 	c #C5C5C2",
"[ 	c #636362",
"} 	c #040504",
"| 	c #040604",
"1 	c #050705",
"2 	c #E87B62",
"3 	c #E67056",
"4 	c #D5D5D3",
"5 	c #DBDBD8",
"6 	c #D0D0CE",
"7 	c #080A07",
"8 	c #0A0C09",
"9 	c #0A0D09",
"0 	c #0B0E0A",
"a 	c #F0B0A1",
"b 	c #EB8D77",
"c 	c #DF421E",
"d 	c #E97E66",
"e 	c #CBCBC8",
"f 	c #0C0F0B",
"g 	c #0F130D",
"h 	c #10140E",
"i 	c #11150F",
"j 	c #EFA392",
"k 	c #BFBFBD",
"l 	c #5D5D5C",
"m 	c #10150F",
"n 	c #141912",
"o 	c #161C14",
"p 	c #171D15",
"q 	c #B7B7B4",
"r 	c #0C0C0C",
"s 	c #192017",
"t 	c #1C2319",
"u 	c #1D241A",
"v 	c #CD8484",
"w 	c #990000",
"x 	c #701616",
"y 	c #A6A6A5",
"z 	c #181E16",
"A 	c #1E261B",
"B 	c #212A1E",
"C 	c #222B1F",
"D 	c #4F0000",
"E 	c #AEAEAB",
"F 	c #1D261B",
"G 	c #242E21",
"H 	c #273224",
"I 	c #283325",
"J 	c #580000",
"K 	c #B5B5B3",
"L 	c #293426",
"M 	c #2D3929",
"N 	c #2E3A2A",
"O 	c #7C4343",
"P 	c #6A0000",
"Q 	c #720000",
"R 	c #BDBDBB",
"S 	c #232C20",
"T 	c #2A3526",
"U 	c #303C2B",
"V 	c #33402E",
"W 	c #C5C5C3",
"X 	c #1E261C",
"Y 	c #303D2C",
"Z 	c #374532",
"` 	c #394834",
" .	c #500000",
"..	c #CDCDCB",
"+.	c #1B2319",
"@.	c #253022",
"#.	c #303E2D",
"$.	c #394934",
"%.	c #3D4E38",
"&.	c #9D9D9B",
"*.	c #565655",
"=.	c #2C3828",
"-.	c #40503A",
";.	c #43553E",
">.	c #BABAB7",
",.	c #777776",
"'.	c #323830",
").	c #232C1F",
"!.	c #313E2D",
"~.	c #3B4A36",
"{.	c #43553D",
"].	c #485B42",
"^.	c #4A5E44",
"/.	c #F0F0EE",
"(.	c #E5E5E3",
"_.	c #C6C6C3",
":.	c #ACACAB",
"<.	c #8B8B8A",
"[.	c #32392F",
"}.	c #2C3728",
"|.	c #3F503A",
"1.	c #465840",
"2.	c #4B5E44",
"3.	c #4E6347",
"4.	c #506549",
"5.	c #DADAD8",
"6.	c #7A7D78",
"7.	c #333C30",
"8.	c #475A41",
"9.	c #4F6348",
"0.	c #53694C",
"a.	c #566C4E",
"b.	c #576D4F",
"c.	c #91968F",
"d.	c #3B4736",
"e.	c #42543C",
"f.	c #51674A",
"g.	c #586F50",
"h.	c #5B7353",
"i.	c #5C7454",
"                                                ",
"              . . . . . . . . . . . . . . . .   ",
"              . + @ # $ % & & & * . . . . . .   ",
"              . = - ; > , ' ) ! ~ . . . . . .   ",
"          .   . = - ; > , { ] ^ / . . . . . .   ",
"          . . . = - ; > , { { { ( . . . . . .   ",
"          . _ . : - ; > < { { { [ } | 1 1 1 .   ",
". . . . . . 2 3 . 4 5 6 < { { { [ 7 8 9 0 0 .   ",
". a 2 2 2 2 b c d . e 6 < { { { [ f g h i i .   ",
". j c c c c c c c 3 . k < { l { [ m n o p p .   ",
". j c c c c c c c c 3 . q { l r [ n s t u u .   ",
". v w w w w w w w w w x . y r { [ z A B C C .   ",
". v w w w w w w w w D . E { { { [ F G H I I .   ",
". v w w w w w w w J . K < { { { [ C L M N N .   ",
". O P P P P Q w J . R 6 < { { { [ S T U V V .   ",
". . . . . . Q J . W 5 6 < { { { [ X H Y Z ` .   ",
"          .  .. ..- 5 6 < { { { [ +.@.#.$.%..   ",
"          . . . = - 5 6 < { ] &.*.B =.Z -.;..   ",
"          .   . = - 5 6 >.&.,.'.).!.~.{.].^..   ",
"              . /.(._.:.<.[.}.Z |.1.2.3.4.4..   ",
"              . 5.k 6.7.Z -.8.9.0.a.a.b.b.b..   ",
"              . c.d.e.^.f.g.h.i.i.i.i.i.i.i..   ",
"              . . . . . . . . . . . . . . . .   ",
"                                                "};

static const char *separator_xpm[] = {
"3 24 4 1",
" 	c None",
".	c #DBD3CB",
"+	c #FCFBFA",
"g      c #777777",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+",
"g.+"};

static const char *up_node2_xpm[] = {
"24 24 18 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"@	c #DADAD6",
"#	c #BCBCB8",
"$	c #778E6F",
"%	c #506B46",
"&	c #0F1308",
"*	c #6B9060",
"=	c #445B2C",
"-	c #A9C7A6",
";	c #BDD3B8",
">	c #77A16E",
",	c #C2D7BE",
"'	c #C1D6BD",
")	c #B0CAAD",
"!	c #A4C3A2",
"~	c #8CA782",
"  ..................    ",
"  .+++++++++++++++@#.   ",
"  .+++++++++++++++#+#.  ",
"  .+++++++++++++++#$%&. ",
"  .+++++++++++++++@$%&. ",
"  .+++++++++++++++++@#. ",
"  .++++++++++++@@@@@@#. ",
"  .+++++++++++++@@@@@#. ",
"  .++++++++++++@@@@@@#. ",
"  .+++++@@##$####@#@@#. ",
"  .+++@+@@#..$$####@@#. ",
"  .++++@@#.*=.%####@##. ",
"  .+++@@#.*-*=.$$###@#. ",
"  .+++@#.*-;**=.%###@#. ",
"  .++@#.*--;***=.$$###. ",
"  .++#.*---;****=.$###. ",
"  .+#.>,,;-;*****=.#@#. ",
"  .+%....')'***.....@#. ",
"  .++++@.'-;***.$#####. ",
"  .++++@.'-;***.###@##. ",
"  .+++++.'-;***.#@++##. ",
"  .......'-;***........ ",
"        .,,@!~>.        ",
"        ........        "};

static const char *stop_xpm[] = {
"24 24 3 1",
" 	c None",
".	c #cc0033",
"X	c #FFFFFFFFFFFF",
"                        ",
"                        ",
"       ..........       ",
"      ............      ",
"     ..............     ",
"    ................    ",
"   ..................   ",
"  ..XX..XXX..XX..XXX..  ",
"  .X..X..X..X..X.X..X.  ",
"  .X.....X..X..X.X..X.  ",
"  .X.....X..X..X.X..X.  ",
"  ..X....X..X..X.X..X.  ",
"  ...X...X..X..X.XXX..  ",
"  ....X..X..X..X.X....  ",
"  ....X..X..X..X.X....  ",
"  .X..X..X..X..X.X....  ",
"  ..XX...X...XX..X....  ",
"   ..................   ",
"    ................    ",
"     ..............     ",
"      ............      ",
"       ..........       ",
"                        ",
"                        "};

static const char *home_xpm[] = {
"24 24 101 2",
"  	c None",
". 	c #000000",
"+ 	c #212121",
"@ 	c #2C2C2C",
"# 	c #C1665A",
"$ 	c #924B37",
"% 	c #2A2A2A",
"& 	c #333333",
"* 	c #343434",
"= 	c #242424",
"- 	c #944D3A",
"; 	c #A05443",
"> 	c #181818",
", 	c #474747",
"' 	c #555555",
") 	c #8D8D8D",
"! 	c #383838",
"~ 	c #191919",
"{ 	c #974F3C",
"] 	c #222222",
"^ 	c #313131",
"/ 	c #A1A1A1",
"( 	c #676767",
"_ 	c #ACACAC",
": 	c #BCBCBC",
"< 	c #585858",
"[ 	c #141414",
"} 	c #1C1C1C",
"| 	c #464646",
"1 	c #666666",
"2 	c #BABABA",
"3 	c #7E7E7E",
"4 	c #D2D2D2",
"5 	c #FFFFFF",
"6 	c #4F4F4F",
"7 	c #262626",
"8 	c #232323",
"9 	c #505050",
"0 	c #B2B2B2",
"a 	c #909090",
"b 	c #9A9A9A",
"c 	c #838383",
"d 	c #171717",
"e 	c #202020",
"f 	c #717171",
"g 	c #A6A6A6",
"h 	c #616161",
"i 	c #1D1D1D",
"j 	c #1F1F1F",
"k 	c #C4C4C4",
"l 	c #CACACA",
"m 	c #AEAEAE",
"n 	c #D1D1D1",
"o 	c #7C7C7C",
"p 	c #BFBFBF",
"q 	c #6C6C6C",
"r 	c #EEEEEE",
"s 	c #949494",
"t 	c #C7C7C7",
"u 	c #EBEBEB",
"v 	c #7D7D7D",
"w 	c #6E6E6E",
"x 	c #A9A9A9",
"y 	c #E99E8F",
"z 	c #DD806D",
"A 	c #9B5343",
"B 	c #CECECE",
"C 	c #626262",
"D 	c #858585",
"E 	c #ECA292",
"F 	c #D0533A",
"G 	c #934F3E",
"H 	c #6D6D6D",
"I 	c #ECA291",
"J 	c #CF543C",
"K 	c #371D16",
"L 	c #5D5D5D",
"M 	c #868686",
"N 	c #787878",
"O 	c #ECA696",
"P 	c #C95C49",
"Q 	c #E17C66",
"R 	c #924E3D",
"S 	c #888888",
"T 	c #A0A0A0",
"U 	c #3D1208",
"V 	c #D15137",
"W 	c #919191",
"X 	c #879981",
"Y 	c #82947C",
"Z 	c #8A9B85",
"` 	c #6E8467",
" .	c #5D7555",
"..	c #4C6042",
"+.	c #3F4F37",
"@.	c #303D2A",
"#.	c #7F8F7A",
"$.	c #64785E",
"%.	c #44563E",
"&.	c #657460",
"*.	c #40503A",
"                                                ",
"                      . .                       ",
"          . . . .   . + @ .                     ",
"          . # $ . . % & * = .                   ",
"          . - ; . > , ' ) ! ~ .                 ",
"          . { . ] ^ / ( _ : < [ .               ",
"          . . } | 1 2 3 4 : 5 6 7 .             ",
"          . 8 9 0 a 4 b 5 : 5 : c d .           ",
"        . e f g 4 b 5 : 5 : 5 : 5 h i .         ",
"      . j k k l 5 m 5 2 5 2 5 : 5 n o } .       ",
"    . 8 m p p p p p p p p . . . . . a q = .     ",
"  . . . . r 5 5 5 5 5 5 5 . s t u . v . . . .   ",
"        . 4 5 . . . . . 5 . : 5 5 . w .         ",
"        . x 5 . y z A . 5 . B 5 5 . C .         ",
"        . D 5 . E F G . 5 . . . . . H .         ",
"        . . 5 . I J K . k s L L M N . .         ",
"        . . r . O P G . 5 5 5 5 5 2 .           ",
"          . 2 . Q # R . : : : : : S .           ",
"          . T U V # A . 5 5 5 5 5 W .           ",
"  . . . . . . . . . . . . . . . . . . . .   .   ",
"        } X Y Z X `  ...+.@.. Y #.$.%.&.*..     ",
"    . .   . . . . . . . . .   . . . . . .       ",
"                . . .                           ",
"                                                "};

static const char *left_arrow_xpm[] = {
"24 24 43 1",
" 	c None",
".	c #000000",
"+	c #B9D0B9",
"@	c #CDDECB",
"#	c #B6C7B6",
"$	c #B1C9B0",
"%	c #B3C4B3",
"&	c #B4CBB2",
"*	c #B5CEB5",
"=	c #B7CCB5",
"-	c #B9CEB7",
";	c #BAD1BA",
">	c #BBCFBA",
",	c #BBD0B9",
"'	c #B2C9B0",
")	c #7EAB78",
"!	c #AAC7A8",
"~	c #B3CAB1",
"{	c #B0C9B0",
"]	c #B0C9AE",
"^	c #AEC7AC",
"/	c #AAC5A8",
"(	c #A9C4A7",
"_	c #698267",
":	c #2D2D2D",
"<	c #CFDFCC",
"[	c #ADC8AB",
"}	c #B0C7AE",
"|	c #ADC6AB",
"1	c #678C63",
"2	c #9BAD9A",
"3	c #85AE81",
"4	c #87AF84",
"5	c #87B083",
"6	c #88AF84",
"7	c #88B085",
"8	c #86AF82",
"9	c #547150",
"0	c #3C5235",
"a	c #5B7950",
"b	c #4A6342",
"c	c #3B5035",
"d	c #415639",
"                        ",
"                        ",
"                        ",
"            .           ",
"           ..           ",
"          .+.           ",
"         .@#.           ",
"        .@$%........    ",
"       .@&*=-;->,').    ",
"      .@!~{]^///^(_.    ",
"     :<[}||[!^^}^[1.    ",
"    .23444445645789.    ",
"     .0aaaaaaaaaaab.    ",
"      .0aaaaaaaaaab.    ",
"       .0aabccccccd.    ",
"        .0ab........    ",
"         .0b.           ",
"          .b.           ",
"           ..           ",
"            .           ",
"                        ",
"                        ",
"                        ",
"                        "};

static const char *right_arrow_xpm[] = {
"24 24 41 1",
" 	c None",
".	c #000000",
"+	c #8CA782",
"@	c #B1CDAE",
"#	c #77A16E",
"$	c #B4CEB1",
"%	c #ACC8A9",
"&	c #709867",
"*	c #C1D6BD",
"=	c #BDD3B8",
"-	c #BFD4BB",
";	c #C2D7BE",
">	c #B0CAAD",
",	c #B2CBB0",
"'	c #AAC7A8",
")	c #0F1308",
"!	c #AEC5A8",
"~	c #AEC8AD",
"{	c #ABC7A8",
"]	c #AAC6A7",
"^	c #A8C6A5",
"/	c #ADC8AD",
"(	c #A8C7A8",
"_	c #A5C4A3",
":	c #7F9F76",
"<	c #A6BFA0",
"[	c #ABC7AA",
"}	c #A7C5A4",
"|	c #A9C7A6",
"1	c #AFC8AD",
"2	c #A4C3A2",
"3	c #6B9060",
"4	c #778E6F",
"5	c #698D60",
"6	c #6B9063",
"7	c #445B2C",
"8	c #6B8661",
"9	c #5B7950",
"0	c #6C8562",
"a	c #65815C",
"b	c #506B46",
"                        ",
"                        ",
"                        ",
"           .            ",
"           ..           ",
"           .+.          ",
"           .@#.         ",
"    ........$%&.        ",
"    .*=-;;;;>,'&)       ",
"    .!~{{{]^'/(_:.      ",
"    .<[^}^|{%'{123.     ",
"    .45666666666657.    ",
"    .8999999999997.     ",
"    .099999999997.      ",
"    .abbbbbb9997.       ",
"    ........b97.        ",
"           .b7.         ",
"           .7.          ",
"           ..           ",
"           .            ",
"                        ",
"                        ",
"                        ",
"                        "};

static const char *back_arrow_xpm[] = {
"24 24 43 1",
" 	c None",
".	c #000000",
"+	c #B9D0B9",
"@	c #CDDECB",
"#	c #B6C7B6",
"$	c #B1C9B0",
"%	c #B3C4B3",
"&	c #B4CBB2",
"*	c #B5CEB5",
"=	c #B7CCB5",
"-	c #B9CEB7",
";	c #BAD1BA",
">	c #BBCFBA",
",	c #BBD0B9",
"'	c #B2C9B0",
")	c #7EAB78",
"!	c #AAC7A8",
"~	c #B3CAB1",
"{	c #B0C9B0",
"]	c #B0C9AE",
"^	c #AEC7AC",
"/	c #AAC5A8",
"(	c #A9C4A7",
"_	c #698267",
":	c #2D2D2D",
"<	c #CFDFCC",
"[	c #ADC8AB",
"}	c #B0C7AE",
"|	c #ADC6AB",
"1	c #678C63",
"2	c #9BAD9A",
"3	c #85AE81",
"4	c #87AF84",
"5	c #87B083",
"6	c #88AF84",
"7	c #88B085",
"8	c #86AF82",
"9	c #547150",
"0	c #3C5235",
"a	c #5B7950",
"b	c #4A6342",
"c	c #3B5035",
"d	c #415639",
"                        ",
"                        ",
"  ...                   ",
"  ...       .           ",
"  ...      ..           ",
"  ...     .+.           ",
"  ...    .@#.           ",
"  ...   .@$%........    ",
"  ...  .@&*=-;->,').    ",
"  ... .@!~{]^///^(_.    ",
"  ...:<[}||[!^^}^[1.    ",
"  ...23444445645789.    ",
"  ....0aaaaaaaaaaab.    ",
"  ... .0aaaaaaaaaab.    ",
"  ...  .0aabccccccd.    ",
"  ...   .0ab........    ",
"  ...    .0b.           ",
"  ...     .b.           ",
"  ...      ..           ",
"  ...       .           ",
"  ...                   ",
"                        ",
"                        ",
"                        "};

static const char *fwd_arrow_xpm[] = {
"24 24 41 1",
" 	c None",
".	c #000000",
"+	c #8CA782",
"@	c #B1CDAE",
"#	c #77A16E",
"$	c #B4CEB1",
"%	c #ACC8A9",
"&	c #709867",
"*	c #C1D6BD",
"=	c #BDD3B8",
"-	c #BFD4BB",
";	c #C2D7BE",
">	c #B0CAAD",
",	c #B2CBB0",
"'	c #AAC7A8",
")	c #0F1308",
"!	c #AEC5A8",
"~	c #AEC8AD",
"{	c #ABC7A8",
"]	c #AAC6A7",
"^	c #A8C6A5",
"/	c #ADC8AD",
"(	c #A8C7A8",
"_	c #A5C4A3",
":	c #7F9F76",
"<	c #A6BFA0",
"[	c #ABC7AA",
"}	c #A7C5A4",
"|	c #A9C7A6",
"1	c #AFC8AD",
"2	c #A4C3A2",
"3	c #6B9060",
"4	c #778E6F",
"5	c #698D60",
"6	c #6B9063",
"7	c #445B2C",
"8	c #6B8661",
"9	c #5B7950",
"0	c #6C8562",
"a	c #65815C",
"b	c #506B46",
"                        ",
"                        ",
"                   ...  ",
"           .       ...  ",
"           ..      ...  ",
"           .+.     ...  ",
"           .@#.    ...  ",
"    ........$%&.   ...  ",
"    .*=-;;;;>,'&)  ...  ",
"    .!~{{{]^'/(_:. ...  ",
"    .<[^}^|{%'{123....  ",
"    .45666666666657...  ",
"    .8999999999997....  ",
"    .099999999997. ...  ",
"    .abbbbbb9997.  ...  ",
"    ........b97.   ...  ",
"           .b7.    ...  ",
"           .7.     ...  ",
"           ..      ...  ",
"           .       ...  ",
"                   ...  ",
"                        ",
"                        ",
"                        "};


/* ---------------- */

static const char *cursor_play_xpm[] = {
"24 24 2 1",
" 	c None",
".	c #000000",
"                        ",
"                        ",
"                        ",
"   .        .           ",
"   ..       ..          ",
"   ...      ...         ",
"   ....     ....        ",
"   .....    .....       ",
"   ......   ......      ",
"   .......  .......     ",
"   ........ ........    ",
"   ..................   ",
"   ..................   ",
"   ........ ........    ",
"   .......  .......     ",
"   ......   ......      ",
"   .....    .....       ",
"   ....     ....        ",
"   ...      ...         ",
"   ..       ..          ",
"   .        .           ",
"                        ",
"                        ",
"                        "};


static const char *play_xpm[] = {
"    24    24        2            1",
"  c None",
"# c #000000",
"                        ",
"                        ",
"                        ",
"        #               ",
"        ##              ",
"        ###             ",
"        ####            ",
"        #####           ",
"        ######          ",
"        #######         ",
"        ########        ",
"        #########       ",
"        #########       ",
"        ########        ",
"        #######         ",
"        ######          ",
"        #####           ",
"        ####            ",
"        ###             ",
"        ##              ",
"        #               ",
"                        ",
"                        ",
"                        "
};

static const char *stop_play_xpm[] = {
"    24    24        2            1",
"  c None",
"# c #000000",
"                        ",
"                        ",
"                        ",
"                        ",
"                        ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"      ###########       ",
"                        ",
"                        ",
"                        ",
"                        ",
"                        "
};


static Pixmap toolbar_pixmaps[NUM_TOOLBAR_PIXMAPS];

void make_toolbar_icons(Widget w)
{ 
  Pixmap shape1, shape2;
  XpmAttributes attributes; 
  XpmColorSymbol symbols[1];
  int i, scr;
  Display *dp;
  Drawable wn;
  
  for (i = 0; i < NUM_TOOLBAR_PIXMAPS; i++)
    toolbar_pixmaps[i] = None;

  dp = XtDisplay(w);
  wn = XtWindow(w);
  scr = DefaultScreen(dp);
  XtVaGetValues(w, XmNdepth, &attributes.depth, XmNcolormap, &attributes.colormap, NULL);
  attributes.visual = DefaultVisual(dp, scr);
  symbols[0].name = (char *)"basiccolor";
  symbols[0].value = NULL;
  symbols[0].pixel = ss->basic_color;
  attributes.colorsymbols = symbols;
  attributes.numsymbols = 1;
  attributes.valuemask = XpmColorSymbols | XpmDepth | XpmColormap | XpmVisual;

  XpmCreatePixmapFromData(dp, wn, (char **)back_arrow_xpm,  &toolbar_pixmaps[SND_XPM_BACK_ARROW],    &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)fwd_arrow_xpm,   &toolbar_pixmaps[SND_XPM_FORWARD_ARROW], &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)zoom_in_xpm,     &toolbar_pixmaps[SND_XPM_ZOOM_IN],       &shape1,  &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)zoom_out_xpm,    &toolbar_pixmaps[SND_XPM_ZOOM_OUT],      &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)cut_xpm,         &toolbar_pixmaps[SND_XPM_CUT],           &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)paste_xpm,       &toolbar_pixmaps[SND_XPM_PASTE],         &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)preferences_xpm, &toolbar_pixmaps[SND_XPM_PREFERENCES],   &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)close_xpm,       &toolbar_pixmaps[SND_XPM_CLOSE],         &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)redo_xpm,        &toolbar_pixmaps[SND_XPM_REDO],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)undo_xpm,        &toolbar_pixmaps[SND_XPM_UNDO],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)save_xpm,        &toolbar_pixmaps[SND_XPM_SAVE],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)saveas_xpm,      &toolbar_pixmaps[SND_XPM_SAVE_AS],       &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)new_xpm,         &toolbar_pixmaps[SND_XPM_NEW],           &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)open_xpm,        &toolbar_pixmaps[SND_XPM_OPEN],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)right_arrow_xpm, &toolbar_pixmaps[SND_XPM_NEXT],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)left_arrow_xpm,  &toolbar_pixmaps[SND_XPM_BACK],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)exit_xpm,        &toolbar_pixmaps[SND_XPM_EXIT],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)separator_xpm,   &toolbar_pixmaps[SND_XPM_SEPARATOR],     &shape2, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)up_node2_xpm,    &toolbar_pixmaps[SND_XPM_UP],            &shape1, &attributes); 
  XpmCreatePixmapFromData(dp, wn, (char **)stop_xpm,        &toolbar_pixmaps[SND_XPM_STOP],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)home_xpm,        &toolbar_pixmaps[SND_XPM_REVERT],        &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)play_xpm,        &toolbar_pixmaps[SND_XPM_PLAY],          &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)cursor_play_xpm, &toolbar_pixmaps[SND_XPM_CURSOR_PLAY],   &shape1, &attributes);
  XpmCreatePixmapFromData(dp, wn, (char **)stop_play_xpm,   &toolbar_pixmaps[SND_XPM_STOP_PLAY],     &shape1, &attributes);
}


Pixmap toolbar_icon(int which)
{
  switch (which)
    {
    case SND_XPM_BACK_ARROW:    return(toolbar_pixmaps[SND_XPM_BACK_ARROW]);
    case SND_XPM_FORWARD_ARROW: return(toolbar_pixmaps[SND_XPM_FORWARD_ARROW]);
    case SND_XPM_ZOOM_IN:       return(toolbar_pixmaps[SND_XPM_ZOOM_IN]);
    case SND_XPM_ZOOM_OUT:      return(toolbar_pixmaps[SND_XPM_ZOOM_OUT]);
    case SND_XPM_CUT:           return(toolbar_pixmaps[SND_XPM_CUT]);
    case SND_XPM_PASTE:         return(toolbar_pixmaps[SND_XPM_PASTE]);
    case SND_XPM_PREFERENCES:   return(toolbar_pixmaps[SND_XPM_PREFERENCES]);
    case SND_XPM_CLOSE:         return(toolbar_pixmaps[SND_XPM_CLOSE]);
    case SND_XPM_REDO:          return(toolbar_pixmaps[SND_XPM_REDO]);
    case SND_XPM_UNDO:          return(toolbar_pixmaps[SND_XPM_UNDO]);
    case SND_XPM_SAVE:          return(toolbar_pixmaps[SND_XPM_SAVE]);
    case SND_XPM_SAVE_AS:       return(toolbar_pixmaps[SND_XPM_SAVE_AS]);
    case SND_XPM_NEW:           return(toolbar_pixmaps[SND_XPM_NEW]);
    case SND_XPM_OPEN:          return(toolbar_pixmaps[SND_XPM_OPEN]);
    case SND_XPM_NEXT:          return(toolbar_pixmaps[SND_XPM_NEXT]);
    case SND_XPM_BACK:          return(toolbar_pixmaps[SND_XPM_BACK]);
    case SND_XPM_EXIT:          return(toolbar_pixmaps[SND_XPM_EXIT]);
    case SND_XPM_SEPARATOR:     return(toolbar_pixmaps[SND_XPM_SEPARATOR]);
    case SND_XPM_UP:            return(toolbar_pixmaps[SND_XPM_UP]);
    case SND_XPM_STOP:          return(toolbar_pixmaps[SND_XPM_STOP]);
    case SND_XPM_REVERT:        return(toolbar_pixmaps[SND_XPM_REVERT]);
    case SND_XPM_PLAY:          return(toolbar_pixmaps[SND_XPM_PLAY]);
    case SND_XPM_CURSOR_PLAY:   return(toolbar_pixmaps[SND_XPM_CURSOR_PLAY]);
    case SND_XPM_STOP_PLAY:     return(toolbar_pixmaps[SND_XPM_STOP_PLAY]);
    }
  return(None);
}

#define NUM_BOMBS 15

void make_icons_transparent(const char *color)
{
  static char *bg1 = NULL;
  static char *bg4 = NULL;
  int i;
  const char **tmp;
  if (bg1) free(bg1);
  bg1 = mus_format("-      c %s s %s", color, color); /* the background color isn't known at compile time */
  mini_lock_xpm[1] = bg1;
  close_icon_xpm[1] = bg1;
  stop_sign_xpm[1] = bg1;
  blank_xpm[1] = bg1;
  for (i = 0; i < NUM_BOMBS; i++)
    {
      tmp = mini_bomb_bits(i);
      tmp[1] = bg1;
    }
  for (i = 0; i < NUM_HOURGLASSES; i++)
    {
      tmp = mini_glass_bits(i);
      tmp[1] = bg1;
    }
  if (bg4) free(bg4);
  bg4 = mus_format("  c %s", color);
  back_arrow_xpm[1] = bg4;
  fwd_arrow_xpm[1] = bg4;
  zoom_in_xpm[1] = bg4;
  zoom_out_xpm[1] = bg4;
  cut_xpm[1] = bg4;
  paste_xpm[1] = bg4;
  preferences_xpm[1] = bg4;
  close_xpm[1] = bg4;
  redo_xpm[1] = bg4;
  undo_xpm[1] = bg4;
  save_xpm[1] = bg4;
  saveas_xpm[1] = bg4;
  new_xpm[1] = bg4;
  open_xpm[1] = bg4;
  right_arrow_xpm[1] = bg4;
  left_arrow_xpm[1] = bg4;
  exit_xpm[1] = bg4;
  separator_xpm[1] = bg4;
  up_node2_xpm[1] = bg4;
  stop_xpm[1] = bg4;
  home_xpm[1] = bg4;
  play_xpm[1] = bg4;
  cursor_play_xpm[1] = bg4;
  stop_play_xpm[1] = bg4;
}

#endif
