% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-bins.R
\name{guide_bins}
\alias{guide_bins}
\title{A binned version of guide_legend}
\usage{
guide_bins(
  title = waiver(),
  theme = NULL,
  angle = NULL,
  position = NULL,
  direction = NULL,
  override.aes = list(),
  reverse = FALSE,
  order = 0,
  show.limits = NULL,
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}

\item{theme}{A \code{\link[=theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide partially overrides, and is combined with, the plot's theme.
Arguments that apply to a single legend are respected, most of which have
the \code{legend}-prefix. Arguments that apply to combined legends
(the legend box) are ignored, including \code{legend.position},
\verb{legend.justification.*}, \code{legend.location} and \verb{legend.box.*}.}

\item{angle}{Overrules the theme settings to automatically apply appropriate
\code{hjust} and \code{vjust} for angled legend text. Can be a single number
representing the text angle in degrees, or \code{NULL} to not overrule the
settings (default).}

\item{position}{A character string indicating where the legend should be
placed relative to the plot panels.
One of "top", "right", "bottom", "left", or "inside".}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical".}

\item{override.aes}{A list specifying aesthetic parameters of legend key.
See details and examples.}

\item{reverse}{logical. If \code{TRUE} the order of legends is reversed.}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{show.limits}{Logical. Should the limits of the scale be shown with
labels and ticks. Default is \code{NULL} meaning it will take the value from the
scale. This argument is ignored if \code{labels} is given as a vector of
values. If one or both of the limits is also given in \code{breaks} it will be
shown irrespective of the value of \code{show.limits}.}

\item{...}{ignored.}
}
\value{
A guide object
}
\description{
This guide is a version of the \code{\link[=guide_legend]{guide_legend()}} guide for binned scales. It
differs in that it places ticks correctly between the keys, and sports a
small axis to better show the binning. Like \code{\link[=guide_legend]{guide_legend()}} it can be used
for all non-position aesthetics though colour and fill defaults to
\code{\link[=guide_coloursteps]{guide_coloursteps()}}, and it will merge aesthetics together into the same
guide if they are mapped in the same way.
}
\section{Use with discrete scale}{

This guide is intended to show binned data and work together with ggplot2's
binning scales. However, it is sometimes desirable to perform the binning in
a separate step, either as part of a stat (e.g. \code{\link[=stat_contour_filled]{stat_contour_filled()}}) or
prior to the visualisation. If you want to use this guide for discrete data
the levels must follow the naming scheme implemented by \code{\link[base:cut]{base::cut()}}. This
means that a bin must be encoded as \code{"(<lower>, <upper>]"} with \verb{<lower>}
giving the lower bound of the bin and \verb{<upper>} giving the upper bound
(\code{"[<lower>, <upper>)"} is also accepted). If you use \code{\link[base:cut]{base::cut()}} to
perform the binning everything should work as expected, if not, some recoding
may be needed.
}

\examples{
p <- ggplot(mtcars) +
  geom_point(aes(disp, mpg, size = hp)) +
  scale_size_binned()

# Standard look
p

# Remove the axis or style it
p + guides(size = guide_bins(
  theme = theme(legend.axis.line = element_blank())
))

p + guides(size = guide_bins(show.limits = TRUE))

my_arrow <- arrow(length = unit(1.5, "mm"), ends = "both")
p + guides(size = guide_bins(
  theme = theme(legend.axis.line = element_line(arrow = my_arrow))
))

# Guides are merged together if possible
ggplot(mtcars) +
  geom_point(aes(disp, mpg, size = hp, colour = hp)) +
  scale_size_binned() +
  scale_colour_binned(guide = "bins")

}
\seealso{
Other guides: 
\code{\link{guide_colourbar}()},
\code{\link{guide_coloursteps}()},
\code{\link{guide_legend}()},
\code{\link{guides}()}
}
\concept{guides}
