% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count.dtplyr_step}
\alias{count.dtplyr_step}
\title{Count observations by group}
\usage{
\method{count}{dtplyr_step}(x, ..., wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{A \code{\link[=lazy_dt]{lazy_dt()}}}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variables to group by.}

\item{wt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will use \code{nn}. If there's a column called \code{n} and \code{nn}, it'll use
\code{nnn}, and so on, adding \code{n}s until it gets a new name.}
}
\description{
This is a method for the dplyr \code{\link[=count]{count()}} generic. It is translated using
\code{.N} in the \code{j} argument, and supplying groups to \code{keyby} as appropriate.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

dt <- lazy_dt(dplyr::starwars)
dt \%>\% count(species)
dt \%>\% count(species, sort = TRUE)
dt \%>\% count(species, wt = mass, sort = TRUE)
}
