#' \code{bayestestR}
#'
#' @title bayestestR: Describing Effects and their Uncertainty, Existence and
#' Significance within the Bayesian Framework
#'
#' @description
#'
#' Existing R packages allow users to easily fit a large variety of models
#' and extract and visualize the posterior draws. However, most of these
#' packages only return a limited set of indices (e.g., point-estimates and
#' CIs). **bayestestR** provides a comprehensive and consistent set of
#' functions to analyze and describe posterior distributions generated by a
#' variety of models objects, including popular modeling packages such as
#' **rstanarm**, **brms** or **BayesFactor**.
#'
#' References:
#'
#' - Makowski et al. (2019) \doi{10.21105/joss.01541}
#' - Makowski et al. (2019) \doi{10.3389/fpsyg.2019.02767}
#'
#' @docType package
#' @aliases bayestestR bayestestR-package
#' @name bayestestR-package
#' @keywords internal
"_PACKAGE"
