//
// C++ Implementation: CPlayerEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CPlayerEdit.hpp"

CPlayerEditDlg::CPlayerEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CPlayerEditDlg::~CPlayerEditDlg() {
}

void CPlayerEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CPlayerEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
	
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());
    ui.online->setChecked(i->GetValue("online",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());
    ui.locz->setValue(i->GetValue("z",i).toDouble());

    ui.scax->setValue(i->GetValue("scax",i).toDouble());
    ui.scay->setValue(i->GetValue("scay",i).toDouble());
    ui.scaz->setValue(i->GetValue("scaz",i).toDouble());

    ui.rotx->setValue(i->GetValue("rotx",i).toDouble());
    ui.roty->setValue(i->GetValue("roty",i).toDouble());
    ui.rotz->setValue(i->GetValue("rotz",i).toDouble());

    ui.rotsp->setText(i->GetValue("rotsp",i));
    ui.transp->setText(i->GetValue("transp",i));
    ui.fmax2->setText(i->GetValue("fmax2",i));

    ui.kbd->setChecked(i->GetValue("kbd",i).toInt());
    
    ui.ax1->setText(i->GetValue("ax1",i));
    ui.ay1->setText(i->GetValue("ay1",i));
    ui.ax2->setText(i->GetValue("ax2",i));
    ui.ay2->setText(i->GetValue("ay2",i));

    if(i->GetValue("joystick",i).toInt()==1){
       ui.joystick_1->setChecked(1);
    }else{
       ui.joystick_1->setChecked(0);
    }
    
    if(i->GetValue("joystick",i).toInt()==2){
       ui.joystick_2->setChecked(1);
    }else{
       ui.joystick_2->setChecked(0);
    }
    
    ui.maus->setChecked(i->GetValue("maus",i).toInt());
    ui.network->setChecked(i->GetValue("network",i).toInt());
            
    ui.kbforward->setText(i->GetValue("kbforward",i));
    ui.kbback->setText(i->GetValue("kbback",i));
    ui.kbleft->setText(i->GetValue("kbleft",i));
    ui.kbright->setText(i->GetValue("kbright",i));

    ui.camego->setChecked(i->GetValue("camego",i).toInt());
    ui.cam2d->setChecked(i->GetValue("cam2d",i).toInt());
    ui.camfix->setChecked(i->GetValue("camfix",i).toInt());

    ui.kbcamrotadd->setText(i->GetValue("kbcamrotadd",i));
    ui.kbcamrotsub->setText(i->GetValue("kbcamrotsub",i));
    ui.kbcamradadd->setText(i->GetValue("kbcamradadd",i));
    ui.kbcamradsub->setText(i->GetValue("kbcamradsub",i));
    ui.kbcamheightadd->setText(i->GetValue("kbcamheightadd",i));
    ui.kbcamheightsub->setText(i->GetValue("kbcamheightsub",i));

    ui.camradius->setText(i->GetValue("camradius",i));
    ui.camrotw->setText(i->GetValue("camrotw",i));
    ui.camhight->setText(i->GetValue("camhight",i));

    qWarning( "CPlayerEditDlg::slotGetData(): Geht !" );
}

void CPlayerEditDlg::slotEditData()
{
    if(point != NULL){
	    point->setText(0,ui.text->text());

        point->SetValue("on", ui.on->isChecked() ? "1" : "0");
        point->SetValue("online", ui.online->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());

        point->SetValue("scax",ui.scax->text());
        point->SetValue("scay",ui.scay->text());
        point->SetValue("scaz",ui.scaz->text());

        point->SetValue("rotx",ui.rotx->text());
        point->SetValue("roty",ui.roty->text());
        point->SetValue("rotz",ui.rotz->text());

        point->SetValue("rotsp",ui.rotsp->text());
        point->SetValue("transp",ui.transp->text());
        point->SetValue("fmax2",ui.fmax2->text());

        point->SetValue("kbd", ui.kbd->isChecked() ? "1" : "0");

        point->SetValue("ax1",ui.ax1->text());
        point->SetValue("ay1",ui.ay1->text());
        point->SetValue("ax2",ui.ax2->text());
        point->SetValue("ay2",ui.ay2->text());

        point->SetValue("joystick", "0");
        if(ui.joystick_1->isChecked()){
          point->SetValue("joystick", "1");
        }
        if(ui.joystick_2->isChecked()){
          point->SetValue("joystick", "2");
        }

        point->SetValue("maus", ui.maus->isChecked() ? "1" : "0");
        point->SetValue("network", ui.network->isChecked() ? "1" : "0");

        point->SetValue("kbforward",ui.kbforward->text());
        point->SetValue("kbback",ui.kbback->text());
        point->SetValue("kbleft",ui.kbleft->text());
        point->SetValue("kbright",ui.kbright->text());

        point->SetValue("camego", ui.camego->isChecked() ? "1" : "0");
        point->SetValue("cam2d", ui.cam2d->isChecked() ? "1" : "0");
        point->SetValue("camfix", ui.camfix->isChecked() ? "1" : "0");

        point->SetValue("kbcamrotadd",ui.kbcamrotadd->text());
        point->SetValue("kbcamrotsub",ui.kbcamrotsub->text());
        point->SetValue("kbcamradadd",ui.kbcamradadd->text());
        point->SetValue("kbcamradsub",ui.kbcamradsub->text());
        point->SetValue("kbcamheightadd",ui.kbcamheightadd->text());
        point->SetValue("kbcamheightsub",ui.kbcamheightsub->text());

        point->SetValue("camradius",ui.camradius->text());
        point->SetValue("camrotw",ui.camrotw->text());
        point->SetValue("camhight",ui.camhight->text());

        point->updategl();
    }
    qWarning( "CPlayerEditDlg::slotEditData(): Geht !" );
}
