/*
 * Copyright (c) 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8249783
 * @summary read very deep constructed OCTET STRING
 * @modules java.base/sun.security.util
 * @library /test/lib
 */

import jdk.test.lib.Asserts;
import jdk.test.lib.Utils;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

import java.io.IOException;

public class DeepOctets {

    public static void main(String[] args) throws Exception {
        byte[] input = {
            0x24, 24,
                0x24, 8, 4, 2, 'a', 'b', 4, 2, 'c', 'd',
                0x24, 8, 4, 2, 'e', 'f', 4, 2, 'g', 'h',
                4, 2, 'i', 'j'
        };

        // DerValue::getOctetString supports constructed BER
        byte[] s = new DerValue(input).getOctetString();
        Asserts.assertEQ(new String(s), "abcdefghij");

        // DerInputStream::getOctetString does not
        Utils.runAndCheckException(
                () -> new DerInputStream(input).getOctetString(),
                IOException.class);
    }
}
