# scscp/demo/maple2gap.mpl
# exported as is from scscp/demo/maple2gap.mw as Maple script
# for Debian by Jerome Benoit <calculus@rezozer.net>
#
# to run the demo:
# $ maple maple2gap.mpl
#
# Calling GAP using Maple's SCSCP[Client]
with(SCSCP);
with(Client);
GapServer := "chrystal.mcs.st-andrews.ac.uk";
# Quering the server about its properties:
#
GetServiceDescription(GapServer);
GetAllowedHeads(GapServer);
# Ask GAP to compute something
#
# Evaluate 20! in GAP.
CallService(GapServer, "scscp_transient_1", "WS_Factorial", [20]);
# Is 26562357 prime?
CallService(GapServer, "scscp_transient_1", "IsPrimeInt", [26562357]);
# Find the library number (ID) of the group in the GAP Small Groups Library
CallService(GapServer, "scscp_transient_1", "WS_IdGroup", [permgroup(4, {[[1, 2], [3, 4]], [[1, 4], [2, 3]]})]);
# Find the number of conjugacy classes of the permutation group
CallService(GapServer, "scscp_transient_1", "NrConjugacyClasses", [permgroup(4, {[[1, 2], [3, 4]], [[1, 4], [2, 3]]})]);
# Check that two-groups are non-isomorphic since they have different IDs in the GAP Small Group Library (using private CD fpgroup1 by A. Konovalov)
G := grelgroup({a, b}, {[b, b], [a, b, 1/a, 1/b], [a, a, a, a, a, a, a, a]});
CallService(GapServer, "scscp_transient_1", "WS_IdGroup", [G]);
G := grelgroup({a, b}, {[b, b], [a, b, a, b], [a, a, a, a, a, a, a, a]});
CallService(GapServer, "scscp_transient_1", "WS_IdGroup", [G]);
m1 := Matrix([[0, 1, 0, 0, 0], [1, 0, 0, 0, 0], [0, 0, 1, 0, 0], [0, 0, 0, 1, 0], [0, 0, 0, 0, 1]]);
m2 := Matrix([[0, 0, 1, 0, 0], [1, 0, 0, 0, 0], [0, 1, 0, 0, 0], [0, 0, 0, 0, 1], [0, 0, 0, 1, 0]]);
# Find the library number of the group generated by the two matrices from above
# (using the procedure which accepts the list generators of the group and not the group itself):
CallService(GapServer, "scscp_transient_1", "GroupIdentificationService", [[m1, m2]]);
# Now create a remote group generated by two matrices and get a cookie pointing to it so we will be able to use it in further procedure calls:
res := CallService(GapServer, "scscp_transient_1", "MatrixGroup", [[m1, m2]], output = cookie);
# The cookie returned by the previous command may be now substituted in procedure calls.
# For example, since the remote object is a group, it is already a valid argument for  WS_IdGroup:
CallService(GapServer, "scscp_transient_1", "WS_IdGroup", [res]);
# In the next example we compute remotely the Sylow 2-subgroup of the group from the previous example, and then get its order:
sylow2 := CallService(GapServer, "scscp_transient_1", "SylowSubgroup", [res, 2], output = cookie);
CallService(GapServer, "scscp_transient_1", "Size", [sylow2]);

#
