/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/gpio.h>
#include <baseboard/variants.h>
#include <console/console.h>
#include <ec/intel/board_id.h>
#include <soc/soc_info.h>
#include <vendorcode/google/chromeos/chromeos.h>

/* Pad configuration in ramstage*/
static const struct pad_config mtl_p_rvp_gpio_table[] = {
	/* GPP_A */
	/* GPP_A00 : GPP_A00 ==> ESPI_SOC_IO0_R configured on reset, do not touch */
	/* GPP_A01 : GPP_A01 ==> ESPI_SOC_IO1_R configured on reset, do not touch */
	/* GPP_A02 : GPP_A02 ==> ESPI_SOC_IO2_R configured on reset, do not touch */
	/* GPP_A03 : GPP_A03 ==> ESPI_SOC_IO3_R configured on reset, do not touch */
	/* GPP_A04 : GPP_A04 ==> ESPI_SOC_CS0_L configured on reset, do not touch */
	/* GPP_A05 : GPP_A05 ==> ESPI_SOC_CLK_R configured on reset, do not touch */
	/* GPP_A06 : GPP_A06 ==> ESPI_SOC_RESET_L configured on reset, do not touch */
	/* GPP_A11: PEG_SLOT_DGPU_SEL_N */
	PAD_CFG_GPO(GPP_A11, 1, DEEP),
	/* GPP_A12: NC */
	PAD_NC(GPP_A12, NONE),
	/* GPP_A13: M2_SSD2_RST_N */
	PAD_CFG_GPO(GPP_A13, 1, DEEP),
	/* GPP_A14: M2_CPU_SSD4_RESET_N */
	PAD_CFG_GPO(GPP_A14, 1, DEEP),

	/* WWAN: GPP_A15: M.2_WWAN_RST_N */
	PAD_CFG_GPO(GPP_A15, 1, DEEP),

	/* GPP_A16: NC */
	PAD_NC(GPP_A16, NONE),
	/* Camera: GPP_A17: CRD2_PWREN */
	PAD_CFG_GPO(GPP_A17, 1, DEEP),
	/* GPP_A18: X1_PCIE_SLOT3_PWR_EN */
	PAD_CFG_GPO(GPP_A18, 1, DEEP),
	/* GPP_A19: X1_DT_PCIE_RST_N */
	PAD_CFG_GPO(GPP_A19, 1, DEEP),
	/* GPP_A20: M2_CPU_SSD3_RESET_N */
	PAD_CFG_GPO(GPP_A20, 1, DEEP),
	/* GPP_A21: I2C_PMC_PD_INT_N */
	PAD_CFG_NF(GPP_A21, NONE, DEEP, NF1),

	/* GPP_B */
	/* GPP_B00: TCH_PAD_INT_N */
	PAD_CFG_GPI_APIC(GPP_B00, NONE, DEEP, EDGE_SINGLE, INVERT),
	/* GPP_B01: CRD_CAM_STROBE */
	PAD_CFG_GPO(GPP_B01, 0, DEEP),
	/* GPP_B02: ISH_I2C0_SDA_ISH_I3C0_SDA_MCF_CRD */
	PAD_CFG_NF(GPP_B02, NONE, DEEP, NF3),
	/* GPP_B03: ISH_I2C0_SCL_ISH_I3C0_SCL_MCF_CRD */
	PAD_CFG_NF(GPP_B03, NONE, DEEP, NF3),
	/* GPP_B04: ISH_INT_GP4_MCF */
	PAD_CFG_NF(GPP_B04, NONE, DEEP, NF4),
	/* ISH: GPP_B5: ISH_GP_0_SNSR_HDR */
	PAD_CFG_NF(GPP_B05, NONE, DEEP, NF4),
	/* GPP_B06: ISH_GP_1_SNSR_HDR */
	PAD_CFG_NF(GPP_B06, NONE, DEEP, NF4),
	/* GPP_B7: ISH_GP_2_SNSR_HDR */
	PAD_CFG_NF(GPP_B07, NONE, DEEP, NF4),
	/* GPP_B8: ISH_GP_3_SNSR_HDR */
	PAD_CFG_NF(GPP_B08, NONE, DEEP, NF4),
	/* GPP_B09: PEG_SLOT_RST_N */
	PAD_CFG_GPO(GPP_B09, 1, DEEP),
	/* GPP_B10: TCP1_DP_HPD */
	PAD_CFG_NF(GPP_B10, NONE, DEEP, NF2),
	/* GPP_B11: HDMI_HPD_CONN */
	PAD_CFG_NF(GPP_B11, NONE, DEEP, NF2),
	/* GPP_B12: PM_SLP_S0_N */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	/* GPP_B13: PLT_RST_N */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	/* GPP_B14: TCP3_DP2_RD_HPD_OUT */
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF2),
	/* GPP_B15: M.2_CPU_SSD3_PWREN */
	PAD_CFG_GPO(GPP_B15, 1, DEEP),
	/* GPP_B16: DDIB_DP_CON_HPD */
	PAD_CFG_NF(GPP_B16, NONE, DEEP, NF2),
	/* GPP_B18: BT_RF_KILL_N */
	PAD_CFG_GPO(GPP_B18, 1, DEEP),
	/* GPP_B19: WIFI_RF_KILL_N */
	PAD_CFG_GPO(GPP_B19, 1, DEEP),
	/* GPP_B20: PEG_RTD3_COLD_MOD */
	PAD_CFG_GPO(GPP_B20, 1, DEEP),
	/* GPP_B21: TCP_RETIMER_FORCE_PWR */
	PAD_CFG_GPO(GPP_B21, 0, DEEP),
	/* GPP_B22: ISH_GP_5_SNSR_HDR */
	PAD_CFG_NF(GPP_B22, NONE, DEEP, NF4),
	/* GPP_B23: ISH_GP_6_SNSR_HDR */
	PAD_CFG_NF(GPP_B23, NONE, DEEP, NF4),

	/* GPP_C */
	/* GPP_C2: X1_PCIE_SLOT3_WAKE_N */
	PAD_CFG_GPI_SCI(GPP_C02, NONE, DEEP, LEVEL, INVERT),
	/* GPP_C3: TCP_SMBUS_SCL_R */
	PAD_CFG_NF(GPP_C03, NONE, DEEP, NF1),
	/* GPP_C4: TCP_SMBUS_SDA_R */
	PAD_CFG_NF(GPP_C04, NONE, DEEP, NF1),
	/* WWAN: GPP_C5: M.2_WWAN_PERST_GPIO_N */
	PAD_CFG_GPO(GPP_C05, 1, DEEP),
	/* GPP_C6: SML1CLK */
	PAD_CFG_NF(GPP_C06, NONE, DEEP, NF1),
	/* GPP_C7: SML1DATA */
	PAD_CFG_NF(GPP_C07, NONE, DEEP, NF1),
	/* Camera: GPP_C8: CRD1_PWREN_MCF_IRQ */
	PAD_CFG_GPO(GPP_C08, 1, DEEP),
	/* SRCCLKREQ: GPP_C9: SRCCLKREQ0_M.2_SSD1_GEN3_N */
	PAD_CFG_NF(GPP_C09, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_C10: SRCCLKREQ1_M.2_WWAN_N */
	PAD_CFG_NF(GPP_C10, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_C11: SRCCLKREQ2_LAN_N */
	PAD_CFG_NF(GPP_C11, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_C12: SRCCLKREQ3_GEN4_X1_DT_SLOT3_N */
	PAD_CFG_NF(GPP_C12, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_C13: SRCCLKREQ4_GEN4_M2_PCH_SSD2_N */
	PAD_CFG_NF(GPP_C13, NONE, DEEP, NF1),
	/* GPP_C14: NC */
	PAD_NC(GPP_C14, NONE),
	/* GPP_C15: PEG_SLOT_DGPU_PWR_OK */
	PAD_CFG_GPI(GPP_C15, NONE, DEEP),
	/* GPP_C16: TBT_LSX0_TXD  */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),
	/* GPP_C17: TBT_LSX0_RXD  */
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),
	/* GPP_C18: TBT_LSX1_TXD  */
	PAD_CFG_NF(GPP_C18, NONE, DEEP, NF1),
	/* GPP_C19: TBT_LSX1_RXD */
	PAD_CFG_NF(GPP_C19, NONE, DEEP, NF1),
	/* GPP_C20: TBT_LSX2_TXD */
	PAD_CFG_NF(GPP_C20, NONE, DEEP, NF1),
	/* GPP_C21: TBT_LSX2_RXD */
	PAD_CFG_NF(GPP_C21, NONE, DEEP, NF1),
	/* GPP_C22: TBT_LSX3_TXD */
	PAD_CFG_NF(GPP_C22, NONE, DEEP, NF1),
	/* GPP_C23: TBT_LSX3_RXD */
	PAD_CFG_NF(GPP_C23, NONE, DEEP, NF1),

	/* GPP_D */
	/* GPP_D00: IMGCLKOUT_1 */
	PAD_CFG_NF(GPP_D00, NONE, DEEP, NF1),
	/* GPP_D1: M2_PCH_SSD2_PWREN */
	PAD_CFG_GPO(GPP_D01, 1, DEEP),
	/* GPP_D2: M2_SSD1_RST_N */
	PAD_CFG_GPO(GPP_D02, 1, DEEP),
	/* GPP_D3: PEG_SLOT_DGPU_PWR_EN_N */
	PAD_CFG_GPO(GPP_D03, 0, DEEP),
	/* Camera: GPP_D4: IMGCLKOUT0 */
	PAD_CFG_NF(GPP_D04, NONE, DEEP, NF1),
	/* M.2: GPP_D5: M2_PCH_SSD1_PWREN */
	PAD_CFG_GPO(GPP_D05, 1, DEEP),
	/* M.2: GPP_D6: M.2_CPU_SSD4_PWREN */
	PAD_CFG_GPO(GPP_D06, 1, DEEP),
	/* GPP_D8: SAR_DPR_PCH */
	PAD_CFG_GPI_SCI(GPP_D08, NONE, DEEP, LEVEL, INVERT),
	/* Audio: GPP_D9:GPP_D17 */
	/* SRCCLKREQ: GPP_D18: SRCCLKREQ6_X8_GEN5_DT_SLOT3_N */
	PAD_CFG_NF(GPP_D18, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_D19: SRCCLKREQ7_SSD4_N */
	PAD_CFG_NF(GPP_D19, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_D20: SRCCLKREQ8_SSD3_N */
	PAD_CFG_NF(GPP_D20, NONE, DEEP, NF1),
	/* SRCCLKREQ: GPP_D21: SRCCLKREQ5_M.2_WLAN_CLKREQ5_N */
	PAD_CFG_NF(GPP_D21, NONE, DEEP, NF2),
	/* GPP_D22: BPKI3C_SDA */
	PAD_CFG_NF(GPP_D22, NONE, DEEP, NF1),
	/* GPP_D23: BPKI3C_SCL */
	PAD_CFG_NF(GPP_D23, NONE, DEEP, NF1),

	/* GPP_E */
	/* GPP_E0: M.2_SSD1_PEDET_R */
	PAD_CFG_NF(GPP_E00, NONE, DEEP, NF1),
	/* GPP_E1: THC0_SPI1_IO_2_TCH_PNL1 */
	PAD_CFG_NF(GPP_E01, NONE, DEEP, NF2),
	/* GPP_E2: THC0_SPI1_IO_3_TCH_PNL1 */
	PAD_CFG_NF(GPP_E02, NONE, DEEP, NF2),
	/* GPP_E4: M2_SSD1_DEVSLP */
	PAD_CFG_NF(GPP_E04, NONE, DEEP, NF1),
	/* GPP_E5: SATA_DIRECT_DEVSLP */
	PAD_CFG_NF(GPP_E05, NONE, DEEP, NF1),
	/* GPP_E6: THC0_SPI1_RST_N_TCH_PNL1 */
	PAD_CFG_NF(GPP_E06, NONE, DEEP, NF2),
	/* GPP_E8: CRD_PRIVACY_LED */
	PAD_CFG_GPO(GPP_E08, 1, DEEP),
	/* GPP_E9: USB_CONN_TYPEA_12_TYPEC_01_FP_P7_P8_P9_P10_OC0_N  */
	PAD_CFG_NF(GPP_E09, NONE, DEEP, NF1),
	/* GPP_E10: THC0_SPI1_CS0_N_TCH_PNL1 */
	PAD_CFG_NF(GPP_E10, NONE, DEEP, NF2),
	/* GPP_E11: THC0_SPI1_CLK_TCH_PNL1 */
	PAD_CFG_NF(GPP_E11, NONE, DEEP, NF2),
	/* GPP_E12: THC0_SPI1_IO_1_I2C4_SDA_TCH_PNL1 */
	PAD_CFG_NF(GPP_E12, NONE, DEEP, NF2),
	/* GPP_E13: THC0_SPI1_IO_0_I2C4_SCL_TCH_PNL1 */
	PAD_CFG_NF(GPP_E13, NONE, DEEP, NF2),
	/* GPP_E14: DDIA_EDP_HPD */
	PAD_CFG_NF(GPP_E14, NONE, DEEP, NF1),
	/* GPP_E15: PM_SLP_DRAM_N */
	PAD_CFG_NF(GPP_E15, NONE, DEEP, NF2),
	/* GPP_E16: GPP_E16_BC_PROCHOT_N */
	PAD_CFG_NF(GPP_E16, NONE, DEEP, NF2),
	/* GPP_E17: THC0_SPI1_INT_N_TCH_PNL1 */
	PAD_CFG_NF(GPP_E17, NONE, DEEP, NF2),
	/* GPP_E22: GPP_E22_DNX_FORCE_RELOAD */
	PAD_CFG_NF(GPP_E22, NONE, DEEP, NF2),

	/* GPP_F */
	/* GPP_F0: M.2_CNV_BRI_DT_BT_UART2_RTS_N */
	PAD_CFG_NF(GPP_F00, NONE, DEEP, NF1),
	/* GPP_F1: M.2_CNV_BRI_RSP_BT_UART2_RXD */
	PAD_CFG_NF(GPP_F01, NONE, DEEP, NF1),
	/* GPP_F2: M.2_CNV_RGI_DT_BT_UART2_TXD */
	PAD_CFG_NF(GPP_F02, NONE, DEEP, NF1),
	/* GPP_F3: M.2_CNV_RGI_RSP_BT_UART2_CTS_N */
	PAD_CFG_NF(GPP_F03, NONE, DEEP, NF1),
	/* GPP_F4: CNV_RF_RESET_R_N */
	PAD_CFG_NF(GPP_F04, NONE, DEEP, NF1),
	/* GPP_F5: CRF_CLKREQ */
	PAD_CFG_NF(GPP_F05, NONE, DEEP, NF3),
	/* GPP_F6: WLAN_WWAN_COEX3 */
	PAD_CFG_GPI(GPP_F06, NONE, DEEP),
	/* Camera: GPP_F7: IMGCLKOUT2 */
	PAD_CFG_NF(GPP_F07, NONE, DEEP, NF2),
	/* GPP_F8: IMGCLKOUT_3 */
	PAD_CFG_NF(GPP_F08, NONE, DEEP, NF2),
	/* GPP_F9: CODEC_INT_N */
	PAD_CFG_GPI_APIC(GPP_F09, NONE, DEEP, LEVEL, INVERT),
	/* TPM: GPP_F11:GPP_F13, GPP_F17 */
	/* GPP_F14: THC1_SPI2_IO_2_TCH_PNL2 */
	PAD_CFG_NF(GPP_F14, NONE, DEEP, NF3),
	/* GPP_F15: THC1_SPI2_IO_3_TCH_PNL2 */
	PAD_CFG_NF(GPP_F15, NONE, DEEP, NF3),
	/* GPP_F16: THC1_SPI2_RST_N_TCH_PNL2 */
	PAD_CFG_NF(GPP_F16, NONE, DEEP, NF3),
	/* GPP_F18: THC1_SPI2_INT_N_TCH_PNL2 */
	PAD_CFG_NF(GPP_F18, NONE, DEEP, NF3),
	/* GPP_F19: X4_PCIE_SLOT2_WAKE_N_R */
	PAD_CFG_GPI_SCI(GPP_F19, NONE, DEEP, LEVEL, INVERT),
	/* GPP_F20: PEG_SLOT_WAKE_R_N */
	PAD_CFG_GPI_SCI(GPP_F20, NONE, DEEP, LEVEL, INVERT),
	/* GPP_F22: TCH_PNL2_PWR_EN */
	PAD_CFG_GPO(GPP_F22, 1, DEEP),
	/* GPP_F23: TCH_PNL1_PWR_EN */
	PAD_CFG_GPO(GPP_F23, 1, DEEP),

	/* GPP_H */
	/* Camera: GPP_H0: GPP2_RST */
	PAD_CFG_GPO(GPP_H00, 1, DEEP),
	/* GPP_H1: TCH_PAD_TCH_PNL2_LS_EN */
	PAD_CFG_GPO(GPP_H01, 1, DEEP),
	/* GPP_H2: WLAN_RST_N */
	PAD_CFG_GPO(GPP_H02, 1, DEEP),
	/* GPP_H4: CNV_MFUART2_RXD */
	PAD_CFG_NF(GPP_H04, NONE, DEEP, NF2),
	/* GPP_H5: CNV_MFUART2_TXD */
	PAD_CFG_NF(GPP_H05, NONE, DEEP, NF2),
	/* GPP_H6: I2C3_SDA_TCH_PAD */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF1),
	/* GPP_H7: I2C3_SCL_TCH_PAD */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF1),
	/* GPP_H13: CPU_C10_GATE_N_R */
	PAD_CFG_NF(GPP_H13, NONE, DEEP, NF1),
	/* ISH: GPP_H14: ISH_I2C1_SDA */
	PAD_CFG_NF(GPP_H14, NONE, DEEP, NF3),
	/* ISH: GPP_H15: ISH_I2C1_SCL */
	PAD_CFG_NF(GPP_H15, NONE, DEEP, NF3),
	/* GPP_H16: DDPB_HDMI_CRLS_CTRLCLK */
	PAD_CFG_NF(GPP_H16, NONE, DEEP, NF1),
	/* GPP_H17: DDPB_HDMI_CRLS_CTRLDATA */
	PAD_CFG_NF(GPP_H17, NONE, DEEP, NF1),
	/* GPP_H19: I2C0_SDA_I3C0_SDA_CSI */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),
	/* GPP_H20: I2C0_SCL_I3C0_SCL_CSI */
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF1),
	/* GPP_H21: I2C1_SDA_I3C1_SDA_CSI */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22: I2C1_SCL_I3C1_SCL_CSI */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),

	/* GPP_V */
	/* GPP_V0: PM_BATLOW_N */
	PAD_CFG_NF(GPP_V00, NONE, DEEP, NF1),
	/* GPP_V1: BC_ACOK_MCP */
	PAD_CFG_NF(GPP_V01, NONE, DEEP, NF1),
	/* GPP_V2: LANWAKE_N_R */
	PAD_CFG_NF(GPP_V02, NONE, DEEP, NF1),
	/* GPP_V3: PWRBTN_MCP_N */
	PAD_CFG_NF(GPP_V03, NONE, DEEP, NF1),
	/* GPP_V4: PM_SLP_S3_N */
	PAD_CFG_NF(GPP_V04, NONE, DEEP, NF1),
	/* GPP_V5: PM_SLP_S4_N */
	PAD_CFG_NF(GPP_V05, NONE, DEEP, NF1),
	/* GPP_V6: PM_SLP_A_N */
	PAD_CFG_NF(GPP_V06, NONE, DEEP, NF1),
	/* GPP_V8: SUS_CLK_MCF */
	PAD_CFG_NF(GPP_V08, NONE, DEEP, NF1),
	/* GPP_V9: SLP_WLAN_N */
	PAD_CFG_NF(GPP_V09, NONE, DEEP, NF1),
	/* GPP_V10: PM_SLP_S5_N */
	PAD_CFG_NF(GPP_V10, NONE, DEEP, NF1),
	/* GPP_V11: LANPHYPC_R_N */
	PAD_CFG_NF(GPP_V11, NONE, DEEP, NF1),
	/* GPP_V12: PM_SLP_LAN_N */
	PAD_CFG_NF(GPP_V12, NONE, DEEP, NF1),
	/* GPP_V14: WAKE_N */
	PAD_CFG_NF(GPP_V14, NONE, DEEP, NF1),
	/* GPP_V15: */
	PAD_CFG_GPO(GPP_V15, 1, DEEP),
	/* GPP_V19: caterr_b */
	PAD_CFG_NF(GPP_V19, NONE, DEEP, NF1),
	/* GPP_V20: H_PROCHOT_N */
	PAD_CFG_NF(GPP_V20, NONE, DEEP, NF1),
	/* GPP_V21: thermtrip_b */
	PAD_CFG_NF(GPP_V21, NONE, DEEP, NF1),
	/* GPP_V22: CRD1_CLK_EN */
	PAD_CFG_GPO(GPP_V22, 1, DEEP),
	/* Camera: GPP_V23: CRD1_CAM1_RST_N */
	PAD_CFG_GPO(GPP_V23, 1, DEEP),
};

/* Early pad configuration in bootblock */
static const struct pad_config mtl_p_rvp_early_gpio_table[] = {
	/* Audio */
	PAD_NC(GPP_D14, NONE), /* M.2_BT_I2S2_PCMCLK/NONE */
	PAD_NC(GPP_D15, NONE), /* M.2_BT_I2S2_PCMFRM/NONE */
	PAD_CFG_GPO(GPP_S04, 1, DEEP), /* EN_SPKR_PA */
	PAD_CFG_GPI_INT(GPP_S05, NONE, PLTRST, EDGE_BOTH),

	/* SMBUS */
	PAD_CFG_NF(GPP_C00, NONE, DEEP, NF1), /* GPP_C0_SMBCLK  */
	PAD_CFG_NF(GPP_C01, NONE, DEEP, NF1), /* GPP_C1_SMBDATA */

	/* SSD */
	PAD_CFG_GPO(GPP_B15, 0, DEEP), /* M.2_CPU_SSD3_PWREN */
	PAD_CFG_GPO(GPP_D06, 0, DEEP), /* M.2_CPU_SSD4_PWREN */
};

static const struct pad_config early_uart_gpio_table[] = {
	/* UART0 */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1), /* UART0_RXD */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1), /* UART0_TXD */
};

static const struct pad_config early_wwan_on_gpio_table[] = {
	/* M.2 WWAN */
	PAD_CFG_GPO(GPP_B17, 1, DEEP), /* WWAN_PWREN */
	PAD_CFG_GPO(GPP_E07, 1, DEEP), /* M.2_WWAN_FCP_OFF_N */
	PAD_CFG_GPO(GPP_A15, 0, DEEP), /* M.2_WWAN_RST_N */
	PAD_CFG_GPO(GPP_C05, 0, DEEP), /* M.2_WWAN_PERST_GPIO_N */
	PAD_CFG_GPI_SCI(GPP_F10, NONE, DEEP, LEVEL, INVERT), /* M.2_WWAN_WAKE_GPIO_N */
};

void configure_early_gpio_pads(void)
{
	uint8_t board_id = get_rvp_board_id();

	if (CONFIG(INTEL_LPSS_UART_FOR_CONSOLE))
		gpio_configure_pads(early_uart_gpio_table, ARRAY_SIZE(early_uart_gpio_table));

	switch (board_id) {
	case MTLP_DDR5_RVP:
	case MTLP_LP5_T3_RVP:
	case MTLP_LP5_T4_RVP:
		gpio_configure_pads(mtl_p_rvp_early_gpio_table,
				    ARRAY_SIZE(mtl_p_rvp_early_gpio_table));
		gpio_configure_pads(early_wwan_on_gpio_table,
				    ARRAY_SIZE(early_wwan_on_gpio_table));
		break;
	default:
		printk(BIOS_WARNING, "Invalid board_id 0x%x."
		       "Skipping early gpio configuration\n", board_id);
		break;
	}
}

void configure_gpio_pads(void)
{
	uint8_t board_id = get_rvp_board_id();

	switch (board_id) {
	case MTLP_DDR5_RVP:
	case MTLP_LP5_T3_RVP:
	case MTLP_LP5_T4_RVP:
		gpio_configure_pads(mtl_p_rvp_gpio_table, ARRAY_SIZE(mtl_p_rvp_gpio_table));
		break;
	default:
		printk(BIOS_WARNING, "Invalid board_id 0x%x."
		       "Skipping ramstage gpio configuration\n", board_id);
		break;
	}
}

static const struct cros_gpio cros_gpios[] = {
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE_NAME),
};
DECLARE_CROS_GPIOS(cros_gpios);
