*
* $Id: c349m.F,v 1.1.1.1 1996/04/01 15:01:19 mclareni Exp $
*
* $Log: c349m.F,v $
* Revision 1.1.1.1  1996/04/01 15:01:19  mclareni
* Mathlib gen
*
*
#include "gen/pilot.h"
      SUBROUTINE C349M
C     This program tests the operation of GENLIB subprograms
C     RTHETA and DTHETA

#if defined(CERNLIB_DOUBLE)
#include "gen/imp64.inc"
C     Set maximum error allowed for test to be considered successful
C     double precision
      PARAMETER (TSTERRD=2D-12 )
C     single precision
      PARAMETER (TSTERRS=1E-6 )
      REAL RTHETA, XREAL, QREAL
      PARAMETER ( IXDIM=15, IQDIM=9, SCALE=1D20, QCUT=0.9001D0 )
      DIMENSION XTAB(IXDIM), QTAB(IQDIM), DTHTAB(4,IXDIM,IQDIM)
      COMMON /C349D/ XTAB, QTAB, DTHTAB

#include "iorc.inc"

      CALL HEADER('C349',0)

C
C  *********************************************************************
C
C  Test for CERN library subprogram C349 (DTHETA/RTHETA).  Prints the
C  largest relative error arising from values of X and Q which have been
C  preset (together with the corresponding function values) in BLOCK
C  DATA subprogram BLKD.
C
C  (Version  9.04.1992)
C
C  *********************************************************************
C
C  Start.
      WRITE (LOUT,2000)
      JTOTAL = 0
      DMAX1 = 0
      DMAX2 = 0
      RMAX1 = 0
      RMAX2 = 0
      DO 3 JQ = 1,IQDIM
         Q = QTAB(JQ)
         QREAL = Q
         DO 2 JX=1,IXDIM
            X = XTAB(JX)
            XREAL = X
            DO 1 K = 1,4
               DTHREF = SCALE*DTHTAB( K, JX, JQ )
               IF ( DTHREF.NE.0 ) THEN
                  DTH = SCALE*DTHETA( K, X, Q )
                  RTHREF = SCALE*DTHETA( K, DBLE(XREAL), DBLE(QREAL) )
                  RTH = SCALE*RTHETA( K, XREAL, QREAL )
                  D = ABS( (DTH-DTHREF)/DTHREF )
                  R = ABS( (RTH-RTHREF)/DTHREF )
                  IF ( Q.LE.QCUT ) THEN
                     DMAX1 = MAX(D,DMAX1)
                     RMAX1 = MAX(R,RMAX1)
                  ELSE
                     DMAX2 = MAX(D,DMAX2)
                     RMAX2 = MAX(R,RMAX2)
                  ENDIF
               ENDIF
               JTOTAL = JTOTAL+1
    1       CONTINUE
    2    CONTINUE
    3 CONTINUE
      WRITE (LOUT,2001) DMAX1, RMAX1, DMAX2, RMAX2
      WRITE (LOUT,2002) JTOTAL/4
C
C  Write sample error messages.
      WRITE (LOUT,2003)
      TH = DTHETA( 0, 0.5D0, -0.5D0 )
      TH = DTHETA( 4, 0.5D0, 1.5D0 )
      TH = DTHETA( -1, 0.5D0, 0.5D0 )
      TH = DTHETA( 5, 0.5D0, 0.5D0 )
      TH = DTHETA( 1, 0.5D0, 1.D0 )
      TH = DTHETA( 2, 0.D0, 1.D0 )
      WRITE (LOUT,2004)
CCC   STOP
C
 2000 FORMAT( ' Test program for C349.'
     $        // ' Prints the largest relative error for selected',
     $        ' values of X and Q.' )
 2001 FORMAT( / 14X, 'Q', 16X, 'DTHETA', 7X, 'RTHETA'
     $        // 5X, ' Not exceeding 0.9:', 1P, 2(E13.1)
     $        /  5X, ' Greater than  0.9:', 2(E13.1) )
 2002 FORMAT( /  ' (Number of (X,Q) pairs = ', I3, ')' )
 2003 FORMAT( // ' Now verify that exactly six error messages',
     $        ' (two of each kind) have been'
     $        / ' written on Unit LOUT.'/ )
 2004 FORMAT( / ' ................................ END OF TEST',
     $       ' ..................................' )
CCC   END

      DMAXT=MAX(DMAX1,DMAX2)
      RMAXT=MAX(RMAX1,RMAX2)
      IRC=ITEST('C349',(DMAXT.LE.TSTERRD).AND.(RMAXT.LE.TSTERRS))
      CALL PAGEND('C349')
      RETURN
      END
      BLOCK DATA BLKD
#include "gen/imp64.inc"
      PARAMETER ( IXDIM=15, IQDIM=9 )
      DIMENSION XTAB(IXDIM), QTAB(IQDIM), DTHTAB(4,IXDIM,IQDIM)
      COMMON /C349D/ XTAB, QTAB, DTHTAB
C
C  *********************************************************************
C  Presets values of x, q and theta(k,x,q) for use by TC349D.
C  (Version 10.03.1992)
C  *********************************************************************
C
      DATA XTAB/ 1D-5, 0.01D0, 0.1D0, 0.2D0, 0.25D0, 0.3D0, 0.4D0,
     $           0.49D0, 0.49999D0,
     $           -0.51D0, -0.4999D0, 0.6D0, 0.99D0, 1.01D0, 1.7D0 /
      DATA QTAB/ 0.01D0, 0.1D0, 0.3D0, 0.7D0, 0.8D0, 0.9D0, 0.99D0,
     $           0.999D0, 0.9999D0 /
      DATA (DTHTAB(1,J,1),J=1,15)/
     $      0.198632157754725453D-04,  0.198599564121013164D-01,
     $      0.195388340858127091D+00,  0.371687884364683724D+00,
     $      0.447168874139960731D+00,  0.511647729650301780D+00,
     $      0.601538129810991681D+00,  0.632206418275082338D+00,
     $      0.632518777275126495D+00, -0.632206418275082338D+00,
     $     -0.632518746348993049D+00,  0.601538129810991681D+00,
     $      0.198599564121013069D-01, -0.198599564121013338D-01,
     $     -0.511647729650301836D+00 /
      DATA (DTHTAB(1,J,2),J=1,15)/
     $      0.342731357551889797D-04,  0.342688918368830777D-01,
     $      0.338448303153667251D+00,  0.650375507769968983D+00,
     $      0.787317226209446663D+00,  0.906410792231181400D+00,
     $      0.107624748216203558D+01,  0.113532571091174450D+01,
     $      0.113593060096330678D+01, -0.113532571091174450D+01,
     $     -0.113593054107095148D+01,  0.107624748216203558D+01,
     $      0.342688918368830595D-01, -0.342688918368831072D-01,
     $     -0.906410792231181484D+00 /
      DATA (DTHTAB(1,J,3),J=1,15)/
     $      0.341148874032195199D-04,  0.341251229167217176D-01,
     $      0.350701610126758975D+00,  0.743325360716168004D+00,
     $      0.951675536091518018D+00,  0.115523417890160118D+01,
     $      0.148602244163968122D+01,  0.161312545262637985D+01,
     $      0.161446033985901960D+01, -0.161312545262637985D+01,
     $     -0.161446020765304965D+01,  0.148602244163968122D+01,
     $      0.341251229167217002D-01, -0.341251229167217479D-01,
     $     -0.115523417890160141D+01 /
      DATA (DTHTAB(1,J,4),J=1,15)/
     $      0.162607019569856244D-05,  0.164235006244872311D-02,
     $      0.353127832146888105D-01,  0.245959457067496945D+00,
     $      0.526440250927469308D+00,  0.981163921741326883D+00,
     $      0.225042412979604212D+01,  0.295962640225301743D+01,
     $      0.296782736070505759D+01, -0.295962640225301743D+01,
     $     -0.296782654768564913D+01,  0.225042412979604212D+01,
     $      0.164235006244872219D-02, -0.164235006244872452D-02,
     $     -0.981163921741327341D+00 /
      DATA (DTHTAB(1,J,5),J=1,15)/
     $      0.523400235070725572D-07,  0.538247271993050233D-04,
     $      0.316822422419801012D-02,  0.700636601883636856D-01,
     $      0.236447213130184963D+00,  0.639634210332025360D+00,
     $      0.241098770377506821D+01,  0.373561308836743255D+01,
     $      0.375217222351964508D+01, -0.373561308836743255D+01,
     $     -0.375217058053589358D+01,  0.241098770377506821D+01,
     $      0.538247271993049928D-04, -0.538247271993050741D-04,
     $     -0.639634210332025832D+00 /
      DATA (DTHTAB(1,J,6),J=1,15)/
     $      0.690712297965843012D-12,  0.788829791612324682D-09,
     $      0.169066643457097958D-05,  0.119075752432300480D-02,
     $      0.156526658224505153D-01,  0.128807596896837337D+00,
     $      0.213999305500227055D+01,  0.540963242188914140D+01,
     $      0.546054497590917953D+01, -0.540963242188914140D+01,
     $     -0.546053991191917665D+01,  0.213999305500227055D+01,
     $      0.788829791612324165D-09, -0.788829791612325560D-09,
     $     -0.128807596896837531D+00 /
      DATA (DTHTAB(1,J,7),J=1,15)/
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.730902308093085031D-37,
     $      0.391011284182882938D-25,  0.154203993057748423D-15,
     $      0.960809728137294568D-03,  0.160264073183361582D+02,
     $      0.176800954882009016D+02, -0.160264073183361582D+02,
     $     -0.176799236036434664D+02,  0.960809728137294568D-03,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $     -0.154203993057750943D-15 /
      DATA (DTHTAB(1,J,8),J=1,15)/
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.208953281519834597D+02,
     $      0.560358403192469190D+02, -0.208953281519834597D+02,
     $     -0.560303681139167438D+02,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(1,J,9),J=1,15)/
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.917199201315058860D-02,
     $      0.177239204624673420D+03, -0.917199201315058860D-02,
     $     -0.177066119050895953D+03,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(2,J,1),J=1,15)/
     $      0.632518777275126495D+00,  0.632206418275082338D+00,
     $      0.601538129810991681D+00,  0.511647729650301780D+00,
     $      0.447168874139960731D+00,  0.371687884364683724D+00,
     $      0.195388340858127091D+00,  0.198599564121013069D-01,
     $      0.198632157754648440D-04, -0.198599564121013069D-01,
     $      0.198632154527802418D-03, -0.195388340858127091D+00,
     $     -0.632206418275082338D+00, -0.632206418275082338D+00,
     $      0.371687884364683654D+00 /
      DATA (DTHTAB(2,J,2),J=1,15)/
     $      0.113593060096330678D+01,  0.113532571091174450D+01,
     $      0.107624748216203558D+01,  0.906410792231181400D+00,
     $      0.787317226209446663D+00,  0.650375507769968983D+00,
     $      0.338448303153667251D+00,  0.342688918368830595D-01,
     $      0.342731357551756915D-04, -0.342688918368830595D-01,
     $      0.342731353350821241D-03, -0.338448303153667251D+00,
     $     -0.113532571091174450D+01, -0.113532571091174450D+01,
     $      0.650375507769968858D+00 /
      DATA (DTHTAB(2,J,3),J=1,15)/
     $      0.161446033985901960D+01,  0.161312545262637985D+01,
     $      0.148602244163968122D+01,  0.115523417890160118D+01,
     $      0.951675536091518018D+00,  0.743325360716168004D+00,
     $      0.350701610126758975D+00,  0.341251229167217002D-01,
     $      0.341148874032062926D-04, -0.341251229167217002D-01,
     $      0.341148884172322482D-03, -0.350701610126758975D+00,
     $     -0.161312545262637985D+01, -0.161312545262637985D+01,
     $      0.743325360716167838D+00 /
      DATA (DTHTAB(2,J,4),J=1,15)/
     $      0.296782736070505759D+01,  0.295962640225301743D+01,
     $      0.225042412979604212D+01,  0.981163921741326883D+00,
     $      0.526440250927469308D+00,  0.245959457067496945D+00,
     $      0.353127832146888105D-01,  0.164235006244872219D-02,
     $      0.162607019569793203D-05, -0.164235006244872219D-02,
     $      0.162607180461073517D-04, -0.353127832146888105D-01,
     $     -0.295962640225301743D+01, -0.295962640225301743D+01,
     $      0.245959457067496778D+00 /
      DATA (DTHTAB(2,J,5),J=1,15)/
     $      0.375217222351964508D+01,  0.373561308836743255D+01,
     $      0.241098770377506821D+01,  0.639634210332025360D+00,
     $      0.236447213130184963D+00,  0.700636601883636856D-01,
     $      0.316822422419801012D-02,  0.538247271993049928D-04,
     $      0.523400235070522657D-07, -0.538247271993049928D-04,
     $      0.523401695350480948D-06, -0.316822422419801012D-02,
     $     -0.373561308836743255D+01, -0.373561308836743255D+01,
     $      0.700636601883636162D-01 /
      DATA (DTHTAB(2,J,6),J=1,15)/
     $      0.546054497590917953D+01,  0.540963242188914140D+01,
     $      0.213999305500227055D+01,  0.128807596896837337D+00,
     $      0.156526658224505153D-01,  0.119075752432300480D-02,
     $      0.169066643457097958D-05,  0.788829791612324165D-09,
     $      0.690712297965575241D-12, -0.788829791612324165D-09,
     $      0.690721658020137083D-11, -0.169066643457097958D-05,
     $     -0.540963242188914140D+01, -0.540963242188914117D+01,
     $      0.119075752432300203D-02 /
      DATA (DTHTAB(2,J,7),J=1,15)/
     $      0.176800954882009016D+02,  0.160264073183361546D+02,
     $      0.960809728137294568D-03,  0.154203993057748423D-15,
     $      0.391011284182882938D-25,  0.730902308093085031D-37,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $     -0.160264073183361582D+02, -0.160264073183361511D+02,
     $      0.730902308093067073D-37 /
      DATA (DTHTAB(2,J,8),J=1,15)/
     $      0.560358403192469190D+02,  0.208953281519834384D+02,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $     -0.208953281519834597D+02, -0.208953281519834029D+02,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(2,J,9),J=1,15)/
     $      0.177239204624673420D+03,  0.917199201315049492D-02,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $     -0.917199201315058860D-02, -0.917199201315033793D-02,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(3,J,1),J=1,15)/
     $      0.102000001996052125D+01,  0.101996055441085942D+01,
     $      0.101618034606783869D+01,  0.100618032370715893D+01,
     $      0.999999979999999997D+00,  0.993819643932161156D+00,
     $      0.983819666292840928D+00,  0.980039485273728583D+00,
     $      0.980000020039478253D+00,  0.980039485273728583D+00,
     $      0.980000023947825830D+00,  0.983819666292840928D+00,
     $      0.101996055441085942D+01,  0.101996055441085942D+01,
     $      0.993819643932161156D+00 /
      DATA (DTHTAB(3,J,2),J=1,15)/
     $      0.120020000160363671D+01,  0.119980377059049181D+01,
     $      0.116186520165583018D+01,  0.106164159385808055D+01,
     $      0.999800000000000189D+00,  0.938034799344169556D+00,
     $      0.838258405141919322D+00,  0.800593075290034262D+00,
     $      0.800199998393205256D+00,  0.800593075290034262D+00,
     $      0.800200037320506388D+00,  0.838258405141919322D+00,
     $      0.119980377059049181D+01,  0.119980377059049181D+01,
     $      0.938034799344169515D+00 /
      DATA (DTHTAB(3,J,3),J=1,15)/
     $      0.161623937329655143D+01,  0.161492697227719662D+01,
     $      0.149040410020556680D+01,  0.117227227621369678D+01,
     $      0.983800008609344190D+00,  0.801515578489422148D+00,
     $      0.519608036481969945D+00,  0.417217560723124062D+00,
     $      0.416160643666316263D+00,  0.417217560723124062D+00,
     $      0.416160748323325655D+00,  0.519608036481969945D+00,
     $      0.161492697227719662D+01,  0.161492697227719662D+01,
     $      0.801515578489422009D+00 /
      DATA (DTHTAB(3,J,4),J=1,15)/
     $      0.296782736071646203D+01,  0.295962640226617668D+01,
     $      0.225042413089090676D+01,  0.981164042610629950D+00,
     $      0.526441282896179932D+00,  0.245967129444088342D+00,
     $      0.355928072348134462D-01,  0.608596214962086549D-02,
     $      0.587641091906428419D-02,  0.608596214962086549D-02,
     $      0.587643158189959762D-02,  0.355928072348134462D-01,
     $      0.295962640226617690D+01,  0.295962640226617668D+01,
     $      0.245967129444088176D+00 /
      DATA (DTHTAB(3,J,5),J=1,15)/
     $      0.375217222351964508D+01,  0.373561308836743255D+01,
     $      0.241098770377507021D+01,  0.639634210335842127D+00,
     $      0.236447213247776400D+00,  0.700636630924666021D-01,
     $      0.316913655643226471D-02,  0.129527162022010146D-03,
     $      0.118336450056192763D-03,  0.129527162022010146D-03,
     $      0.118337544161499754D-03,  0.316913655643226471D-02,
     $      0.373561308836743255D+01,  0.373561308836743255D+01,
     $      0.700636630924665188D-01 /
      DATA (DTHTAB(3,J,6),J=1,15)/
     $      0.546054497590917953D+01,  0.540963242188914140D+01,
     $      0.213999305500227055D+01,  0.128807596896837337D+00,
     $      0.156526658224505153D-01,  0.119075752432300496D-02,
     $      0.169066645926633930D-05,  0.107510478036200374D-08,
     $      0.737353010451161171D-09,  0.107510478036200374D-08,
     $      0.737384354437164498D-09,  0.169066645926633930D-05,
     $      0.540963242188914140D+01,  0.540963242188914117D+01,
     $      0.119075752432300214D-02 /
      DATA (DTHTAB(3,J,7),J=1,15)/
     $      0.176800954882009016D+02,  0.160264073183361546D+02,
     $      0.960809728137294568D-03,  0.154203993057748423D-15,
     $      0.391011284182882938D-25,  0.730902308093085031D-37,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.160264073183361582D+02,  0.160264073183361511D+02,
     $      0.730902308093067073D-37 /
      DATA (DTHTAB(3,J,8),J=1,15)/
     $      0.560358403192469190D+02,  0.208953281519834384D+02,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.208953281519834597D+02,  0.208953281519834029D+02,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(3,J,9),J=1,15)/
     $      0.177239204624673420D+03,  0.917199201315049492D-02,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.917199201315058860D-02,  0.917199201315033793D-02,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(4,J,1),J=1,15)/
     $      0.980000020039478253D+00,  0.980039485273728583D+00,
     $      0.983819666292840928D+00,  0.993819643932161156D+00,
     $      0.999999979999999997D+00,  0.100618032370715893D+01,
     $      0.101618034606783869D+01,  0.101996055441085942D+01,
     $      0.102000001996052125D+01,  0.101996055441085942D+01,
     $      0.102000001605214252D+01,  0.101618034606783869D+01,
     $      0.980039485273728583D+00,  0.980039485273728583D+00,
     $      0.100618032370715893D+01 /
      DATA (DTHTAB(4,J,2),J=1,15)/
     $      0.800199998393205256D+00,  0.800593075290034262D+00,
     $      0.838258405141919322D+00,  0.938034799344169556D+00,
     $      0.999800000000000189D+00,  0.106164159385808055D+01,
     $      0.116186520165583018D+01,  0.119980377059049181D+01,
     $      0.120020000160363671D+01,  0.119980377059049181D+01,
     $      0.120019996236366655D+01,  0.116186520165583018D+01,
     $      0.800593075290034262D+00,  0.800593075290034262D+00,
     $      0.106164159385808055D+01 /
      DATA (DTHTAB(4,J,3),J=1,15)/
     $      0.416160643666316263D+00,  0.417217560723124062D+00,
     $      0.519608036481969945D+00,  0.801515578489422148D+00,
     $      0.983800008609344190D+00,  0.117227227621369678D+01,
     $      0.149040410020556680D+01,  0.161492697227719662D+01,
     $      0.161623937329655143D+01,  0.161492697227719662D+01,
     $      0.161623924331329705D+01,  0.149040410020556680D+01,
     $      0.417217560723124062D+00,  0.417217560723124062D+00,
     $      0.117227227621369701D+01 /
      DATA (DTHTAB(4,J,4),J=1,15)/
     $      0.587641091906428419D-02,  0.608596214962086549D-02,
     $      0.355928072348134462D-01,  0.245967129444088342D+00,
     $      0.526441282896179932D+00,  0.981164042610629950D+00,
     $      0.225042413089090676D+01,  0.295962640226617690D+01,
     $      0.296782736071646203D+01,  0.295962640226617690D+01,
     $      0.296782654769705379D+01,  0.225042413089090676D+01,
     $      0.608596214962086549D-02,  0.608596214962086549D-02,
     $      0.981164042610630407D+00 /
      DATA (DTHTAB(4,J,5),J=1,15)/
     $      0.118336450056192763D-03,  0.129527162022010156D-03,
     $      0.316913655643226471D-02,  0.700636630924666021D-01,
     $      0.236447213247776400D+00,  0.639634210335842127D+00,
     $      0.241098770377507021D+01,  0.373561308836743255D+01,
     $      0.375217222351964508D+01,  0.373561308836743255D+01,
     $      0.375217058053589358D+01,  0.241098770377507021D+01,
     $      0.129527162022010146D-03,  0.129527162022010176D-03,
     $      0.639634210335842598D+00 /
      DATA (DTHTAB(4,J,6),J=1,15)/
     $      0.737353010451161171D-09,  0.107510478036200415D-08,
     $      0.169066645926633930D-05,  0.119075752432300496D-02,
     $      0.156526658224505153D-01,  0.128807596896837337D+00,
     $      0.213999305500227055D+01,  0.540963242188914140D+01,
     $      0.546054497590917953D+01,  0.540963242188914140D+01,
     $      0.546053991191917665D+01,  0.213999305500227055D+01,
     $      0.107510478036200374D-08,  0.107510478036200477D-08,
     $      0.128807596896837531D+00 /
      DATA (DTHTAB(4,J,7),J=1,15)/
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.730902308093085031D-37,
     $      0.391011284182882938D-25,  0.154203993057748423D-15,
     $      0.960809728137294568D-03,  0.160264073183361582D+02,
     $      0.176800954882009016D+02,  0.160264073183361582D+02,
     $      0.176799236036434664D+02,  0.960809728137294568D-03,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.154203993057750943D-15 /
      DATA (DTHTAB(4,J,8),J=1,15)/
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.208953281519834597D+02,
     $      0.560358403192469190D+02,  0.208953281519834597D+02,
     $      0.560303681139167438D+02,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00 /
      DATA (DTHTAB(4,J,9),J=1,15)/
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.917199201315058860D-02,
     $      0.177239204624673420D+03,  0.917199201315058860D-02,
     $      0.177066119050895953D+03,  0.000000000000000000D+00,
     $      0.000000000000000000D+00,  0.000000000000000000D+00,
     $      0.000000000000000000D+00 /
         END

#endif
#if !defined(CERNLIB_DOUBLE)

C     Set maximum error allowed for test to be considered successful
C     single precision
      PARAMETER (TSTERR =1E-13)
      PARAMETER ( IXDIM=15, IQDIM=9, SCALE=1E20, QCUT=0.9001 )
      DIMENSION XTAB(IXDIM), QTAB(IQDIM), RTHTAB(4,IXDIM,IQDIM)
      COMMON /C349R/ XTAB, QTAB, RTHTAB
#include "iorc.inc"
      CALL HEADER('C349',0)
C
C  *********************************************************************
C
C  Test for CERN library subprogram C349 (RTHETA version).  Prints the
C  largest relative error arising from values of X and Q which have been
C  preset (together with the corresponding function values) in BLOCK
C  DATA subprogram BLKR.
C
C  (Version  11.02.1992)
C
C  *********************************************************************
C
C  Start.
      WRITE (LOUT,2000)
      JTOTAL = 0
      RMAX1 = 0
      RMAX2 = 0
      DO 3 JQ = 1,IQDIM
         Q = QTAB(JQ)
         DO 2 JX=1,IXDIM
            X = XTAB(JX)
            DO 1 K = 1,4
               RTHREF = SCALE*RTHTAB( K, JX, JQ )
               IF ( RTHREF.NE.0 ) THEN
                  RTH = SCALE*RTHETA( K, X, Q )
                  R = ABS( (RTH-RTHREF)/RTHREF )
                  IF ( Q.LE.QCUT ) THEN
                     RMAX1 = MAX(R,RMAX1)
                  ELSE
                     RMAX2 = MAX(R,RMAX2)
                  ENDIF
               ENDIF
               JTOTAL = JTOTAL+1
    1       CONTINUE
    2    CONTINUE
    3 CONTINUE
      WRITE (LOUT,2001) RMAX1, RMAX2
      WRITE (LOUT,2002) JTOTAL/4
C
C  Write sample error messages.
      WRITE (LOUT,2003)
      TH = RTHETA( 0, 0.5, -0.5 )
      TH = RTHETA( 4, 0.5, 1.5 )
      TH = RTHETA( -1, 0.5, 0.5 )
      TH = RTHETA( 5, 0.5, 0.5 )
      TH = RTHETA( 1, 0.5, 1.0 )
      TH = RTHETA( 2, 0.0, 1.0 )
      WRITE (LOUT,2004)
CCC   STOP
C
 2000 FORMAT( ' Test program for C349 (RTHETA version).'
     $        // ' Prints the largest relative error for selected',
     $        ' values of X and Q.' )
 2001 FORMAT( / 5X, ' Not exceeding 0.9:', 1P, E13.1
     $        / 5X, ' Greater than  0.9:', E13.1 )
 2002 FORMAT( / ' (Number of (X,Q) pairs = ', I3, ')' )
 2003 FORMAT( // ' Now verify that exactly six error messages',
     $        ' (two of each kind) have been'
     $        / ' written on Unit LOUT.'/ )
 2004 FORMAT( / ' ................................ END OF TEST',
     $       ' ..................................' )
CCC   END

      RMAXT=MAX(RMAX1,RMAX2)
      IRC=ITEST('C349',RMAXT.LE.TSTERR)
      CALL PAGEND('C349')
      RETURN
      END

      BLOCK DATA BLKR
      PARAMETER ( IXDIM=15, IQDIM=9 )
      DIMENSION XTAB(IXDIM), QTAB(IQDIM), RTHTAB(4,IXDIM,IQDIM)
      COMMON /C349R/ XTAB, QTAB, RTHTAB
C
C  *********************************************************************
C  Presets values of x, q and theta(k,x,q) for use by TC349R.
C  (Version 11.02.1992)
C  *********************************************************************

      DATA XTAB/ 1D-5, 0.01, 0.1, 0.2, 0.25, 0.3, 0.4, 0.49, 0.49999,
     $           -0.51, -0.4999, 0.6, 0.99, 1.01, 1.7 /
      DATA QTAB/ 0.01, 0.1, 0.3, 0.7, 0.8, 0.9, 0.99, 0.999, 0.9999 /
      DATA (RTHTAB(1,J,1),J=1,15)/
     $        0.1986321608569005E-04,    0.1985996047820741E-01,
     $        0.1953883938929290E+00,    0.3716878804115662E+00,
     $        0.4471688924494714E+00,    0.5116477645392764E+00,
     $        0.6015381398229293E+00,    0.6322064447981275E+00,
     $        0.6325188032144861E+00,   -0.6322064447981275E+00,
     $       -0.6325187722788321E+00,    0.6015381398229293E+00,
     $        0.1985993829026051E-01,   -0.1986041163312242E-01,
     $       -0.5116479734739409E+00 /
      DATA (RTHTAB(1,J,2),J=1,15)/
     $        0.3427313642702537E-04,    0.3426889899074363E-01,
     $        0.3384483976215273E+00,    0.6503755069687510E+00,
     $        0.7873172693439214E+00,    0.9064108705579993E+00,
     $        0.1076247521386946E+01,    0.1135325785076698E+01,
     $        0.1135930674032911E+01,   -0.1135325785076698E+01,
     $       -0.1135930614122115E+01,    0.1076247521386946E+01,
     $        0.3426886070175763E-01,   -0.3426967753345208E-01,
     $       -0.9064112599483611E+00 /
      DATA (RTHTAB(1,J,3),J=1,15)/
     $        0.3411488592283592E-04,    0.3412512789646213E-01,
     $        0.3507016931483890E+00,    0.7433253087624970E+00,
     $        0.9516755378777994E+00,    0.1155234233665976E+01,
     $        0.1486022403743479E+01,    0.1613125481990883E+01,
     $        0.1614460366738221E+01,   -0.1613125481990883E+01,
     $       -0.1614460234491551E+01,    0.1486022403743479E+01,
     $        0.3412508973580355E-01,   -0.3412590382986981E-01,
     $       -0.1155234935922142E+01 /
      DATA (RTHTAB(1,J,4),J=1,15)/
     $        0.1626070575250972E-05,    0.1642350760064550E-02,
     $        0.3531280862178461E-01,    0.2459594317573693E+00,
     $        0.5264402818299556E+00,    0.9811640796311318E+00,
     $        0.2250423808868681E+01,    0.2959626347608944E+01,
     $        0.2967827289831395E+01,   -0.2959626347608944E+01,
     $       -0.2967826476561793E+01,    0.2250423808868681E+01,
     $        0.1642348888143378E-02,   -0.1642388822488285E-02,
     $       -0.9811660215472074E+00 /
      DATA (RTHTAB(1,J,5),J=1,15)/
     $        0.5233998877980487E-07,    0.5382470237461430E-04,
     $        0.3168225506758064E-02,    0.7006362173806495E-01,
     $        0.2364471773768593E+00,    0.6396342910216622E+00,
     $        0.2410987204577334E+01,    0.3735613243507420E+01,
     $        0.3752172348756504E+01,   -0.3735613243507420E+01,
     $       -0.3752170705266869E+01,    0.2410987204577334E+01,
     $        0.5382463888059103E-04,   -0.5382599342220417E-04,
     $       -0.6396363145485954E+00 /
      DATA (RTHTAB(1,J,6),J=1,15)/
     $        0.6907160870690318E-12,    0.7888342485278886E-09,
     $        0.1690675613940022E-05,    0.1190759100908589E-02,
     $        0.1565268689612706E-01,    0.1288077595898328E+00,
     $        0.2139992334116663E+01,    0.5409631851208299E+01,
     $        0.5460544289293762E+01,   -0.5409631851208299E+01,
     $       -0.5460539223746948E+01,    0.2139992334116663E+01,
     $        0.7888331395165892E-09,   -0.7888567985976718E-09,
     $       -0.1288086226207619E+00 /
      DATA (RTHTAB(1,J,7),J=1,15)/
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.1022990193254645E-66,    0.7308356111927279E-37,
     $        0.3909884698342626E-25,    0.1541989833542450E-15,
     $        0.9607966459721680E-03,    0.1602641649220523E+02,
     $        0.1768010395651999E+02,   -0.1602641649220523E+02,
     $       -0.1767993201880870E+02,    0.9607966459721680E-03,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $       -0.1542098145768002E-15 /
      DATA (RTHTAB(1,J,8),J=1,15)/
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.8057209949692564E-41,    0.2089523653108562E+02,
     $        0.5603620107189387E+02,   -0.2089523653108562E+02,
     $       -0.5603072707652527E+02,    0.8057209949692564E-41,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(1,J,9),J=1,15)/
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.9186434011160556E-02,
     $        0.1772244957790231E+03,   -0.9186434011160556E-02,
     $       -0.1770514000339975E+03,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(2,J,1),J=1,15)/
     $        0.6325188032153351E+00,    0.6322064441000082E+00,
     $        0.6015381398229293E+00,    0.5116477645392764E+00,
     $        0.4471688924494714E+00,    0.3716878804115662E+00,
     $        0.1953883938929290E+00,    0.1985993829026051E-01,
     $        0.1989019147571722E-04,   -0.1985993829026051E-01,
     $        0.1986651235349559E-03,   -0.1953883938929290E+00,
     $       -0.6322064447981275E+00,   -0.6322064299047448E+00,
     $        0.3716875929440658E+00 /
      DATA (RTHTAB(2,J,2),J=1,15)/
     $        0.1135930674034555E+01,    0.1135325783724847E+01,
     $        0.1076247521386946E+01,    0.9064108705579993E+00,
     $        0.7873172693439214E+00,    0.6503755069687510E+00,
     $        0.3384483976215273E+00,    0.3426886070175763E-01,
     $        0.3431968131777517E-04,   -0.3426886070175763E-01,
     $        0.3427882413399479E-03,   -0.3384483976215273E+00,
     $       -0.1135325785076698E+01,   -0.1135325756236884E+01,
     $        0.6503749899758190E+00 /
      DATA (RTHTAB(2,J,3),J=1,15)/
     $        0.1614460366741850E+01,    0.1613125479008349E+01,
     $        0.1486022403743479E+01,    0.1155234233665976E+01,
     $        0.9516755378777994E+00,    0.7433253087624970E+00,
     $        0.3507016931483890E+00,    0.3412508973580355E-01,
     $        0.3416121590033741E-04,   -0.3412508973580355E-01,
     $        0.3412054880066267E-03,   -0.3507016931483890E+00,
     $       -0.1613125481990883E+01,   -0.1613125418362778E+01,
     $        0.7433245697201163E+00 /
      DATA (RTHTAB(2,J,4),J=1,15)/
     $        0.2967827289853716E+01,    0.2959626329303713E+01,
     $        0.2250423808868681E+01,    0.9811640796311318E+00,
     $        0.5264402818299556E+00,    0.2459594317573693E+00,
     $        0.3531280862178461E-01,    0.1642348888143378E-02,
     $        0.1628278872672843E-05,   -0.1642348888143378E-02,
     $        0.1626342055118134E-04,   -0.3531280862178461E-01,
     $       -0.2959626347608944E+01,   -0.2959625957092943E+01,
     $        0.2459587015179157E+00 /
      DATA (RTHTAB(2,J,5),J=1,15)/
     $        0.3752172348801611E+01,    0.3735613206576635E+01,
     $        0.2410987204577334E+01,    0.6396342910216622E+00,
     $        0.2364471773768593E+00,    0.7006362173806495E-01,
     $        0.3168225506758064E-02,    0.5382463888059103E-04,
     $        0.5241106949933525E-07,   -0.5382463888059103E-04,
     $        0.5234882146606818E-06,   -0.3168225506758064E-02,
     $       -0.3735613243507420E+01,   -0.3735612455641802E+01,
     $        0.7006328926246956E-01 /
      DATA (RTHTAB(2,J,6),J=1,15)/
     $        0.5460544289432789E+01,    0.5409631737942014E+01,
     $        0.2139992334116663E+01,    0.1288077595898328E+00,
     $        0.1565268689612706E-01,    0.1190759100908589E-02,
     $        0.1690675613940022E-05,    0.7888331395165892E-09,
     $        0.6916541195046509E-12,   -0.7888331395165892E-09,
     $        0.6908400862791128E-11,   -0.1690675613940022E-05,
     $       -0.5409631851208299E+01,   -0.5409629434833953E+01,
     $        0.1190747133607115E-02 /
      DATA (RTHTAB(2,J,7),J=1,15)/
     $        0.1768010396123896E+02,    0.1602641297443747E+02,
     $        0.9607966459721680E-03,    0.1541989833542450E-15,
     $        0.3909884698342626E-25,    0.7308356111927279E-37,
     $        0.1022990193254645E-66,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,   -0.1022990193254645E-66,
     $       -0.1602641649220523E+02,   -0.1602634144580780E+02,
     $        0.7307586150151781E-37 /
      DATA (RTHTAB(2,J,8),J=1,15)/
     $        0.5603620122213877E+02,    0.2089519045812560E+02,
     $        0.8057209949692564E-41,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $       -0.2089523653108562E+02,   -0.2089425365213780E+02,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(2,J,9),J=1,15)/
     $        0.1772245005320762E+03,    0.9186231401879109E-02,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $       -0.9186434011160556E-02,   -0.9182112599787110E-02,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(3,J,1),J=1,15)/
     $        0.1020000023238790E+01,    0.1019960557669725E+01,
     $        0.1016180346958963E+01,    0.1006180326144896E+01,
     $        0.9999999799999869E+00,    0.9938196414944061E+00,
     $        0.9838196654017130E+00,    0.9800394819267058E+00,
     $        0.9800000167613432E+00,    0.9800394819267058E+00,
     $        0.9800000206708944E+00,    0.9838196654017130E+00,
     $        0.1019960557757909E+01,    0.1019960555876641E+01,
     $        0.9938196201237924E+00 /
      DATA (RTHTAB(3,J,2),J=1,15)/
     $        0.1200200049478092E+01,    0.1199803818239498E+01,
     $        0.1161865222624334E+01,    0.1061641622703555E+01,
     $        0.9997999998092653E+00,    0.9380347702253002E+00,
     $        0.8382583841773196E+00,    0.8005930271401465E+00,
     $        0.8001999509012889E+00,    0.8005930271401465E+00,
     $        0.8001999898405812E+00,    0.8382583841773196E+00,
     $        0.1199803819124850E+01,    0.1199803800237143E+01,
     $        0.9380345567830439E+00 /
      DATA (RTHTAB(3,J,3),J=1,15)/
     $        0.1616239399727414E+01,    0.1614926998210404E+01,
     $        0.1490404062821349E+01,    0.1172272325649216E+01,
     $        0.9838000060344289E+00,    0.8015155277404742E+00,
     $        0.5196080662254426E+00,    0.4172175374536215E+00,
     $        0.4161606223881795E+00,    0.4172175374536215E+00,
     $        0.4161607270774055E+00,    0.5196080662254426E+00,
     $        0.1614927001142599E+01,    0.1614926938588382E+01,
     $        0.8015149080959542E+00 /
      DATA (RTHTAB(3,J,4),J=1,15)/
     $        0.2967827289865120E+01,    0.2959626329316872E+01,
     $        0.2250423809963548E+01,    0.9811642005004704E+00,
     $        0.5264413137994085E+00,    0.2459671041422877E+00,
     $        0.3559283254672319E-01,    0.6085963592336598E-02,
     $        0.5876412720313133E-02,    0.6085963592336598E-02,
     $        0.5876433389512860E-02,    0.3559283254672319E-01,
     $        0.2959626347622103E+01,    0.2959625957106102E+01,
     $        0.2459663739559823E+00 /
      DATA (RTHTAB(3,J,5),J=1,15)/
     $        0.3752172348801611E+01,    0.3735613206576635E+01,
     $        0.2410987204577336E+01,    0.6396342910254789E+00,
     $        0.2364471774944505E+00,    0.7006362464216589E-01,
     $        0.3169137836898215E-02,    0.1295270506446048E-03,
     $        0.1183363666578793E-03,    0.1295270506446048E-03,
     $        0.1183374610993361E-03,    0.3169137836898215E-02,
     $        0.3735613243507420E+01,    0.3735612455641802E+01,
     $        0.7006329216660266E-01 /
      DATA (RTHTAB(3,J,6),J=1,15)/
     $        0.5460544289432789E+01,    0.5409631737942014E+01,
     $        0.2139992334116663E+01,    0.1288077595898328E+00,
     $        0.1565268689612706E-01,    0.1190759100908589E-02,
     $        0.1690675638635522E-05,    0.1075110106882599E-08,
     $        0.7373572602979535E-09,    0.1075110106882599E-08,
     $        0.7373886140966071E-09,    0.1690675638635522E-05,
     $        0.5409631851208299E+01,    0.5409629434833953E+01,
     $        0.1190747133607116E-02 /
      DATA (RTHTAB(3,J,7),J=1,15)/
     $        0.1768010396123896E+02,    0.1602641297443747E+02,
     $        0.9607966459721680E-03,    0.1541989833542450E-15,
     $        0.3909884698342626E-25,    0.7308356111927279E-37,
     $        0.1022990193254645E-66,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.1022990193254645E-66,
     $        0.1602641649220523E+02,    0.1602634144580780E+02,
     $        0.7307586150151781E-37 /
      DATA (RTHTAB(3,J,8),J=1,15)/
     $        0.5603620122213877E+02,    0.2089519045812560E+02,
     $        0.8057209949692564E-41,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.2089523653108562E+02,    0.2089425365213780E+02,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(3,J,9),J=1,15)/
     $        0.1772245005320762E+03,    0.9186231401879109E-02,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.9186434011160556E-02,    0.9182112599787110E-02,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(4,J,1),J=1,15)/
     $        0.9800000167612359E+00,    0.9800394820148885E+00,
     $        0.9838196654017130E+00,    0.9938196414944061E+00,
     $        0.9999999799999869E+00,    0.1006180326144896E+01,
     $        0.1016180346958963E+01,    0.1019960557757909E+01,
     $        0.1020000023238683E+01,    0.1019960557757909E+01,
     $        0.1020000019329100E+01,    0.1016180346958963E+01,
     $        0.9800394819267058E+00,    0.9800394838079585E+00,
     $        0.1006180347515563E+01 /
      DATA (RTHTAB(4,J,2),J=1,15)/
     $        0.8001999509002202E+00,    0.8005930280184570E+00,
     $        0.8382583841773196E+00,    0.9380347702253002E+00,
     $        0.9997999998092653E+00,    0.1061641622703555E+01,
     $        0.1161865222624334E+01,    0.1199803819124850E+01,
     $        0.1200200049477015E+01,    0.1199803819124850E+01,
     $        0.1200200010224957E+01,    0.1161865222624334E+01,
     $        0.8005930271401465E+00,    0.8005930458776495E+00,
     $        0.1061641836674124E+01 /
      DATA (RTHTAB(4,J,3),J=1,15)/
     $        0.4161606223853062E+00,    0.4172175398155172E+00,
     $        0.5196080662254426E+00,    0.8015155277404742E+00,
     $        0.9838000060344289E+00,    0.1172272325649216E+01,
     $        0.1490404062821349E+01,    0.1614927001142599E+01,
     $        0.1616239399723845E+01,    0.1614927001142599E+01,
     $        0.1616239269700575E+01,    0.1490404062821349E+01,
     $        0.4172175374536215E+00,    0.4172175878413029E+00,
     $        0.1172272988086959E+01 /
      DATA (RTHTAB(4,J,4),J=1,15)/
     $        0.5876412719745853E-02,    0.6085964062590301E-02,
     $        0.3559283254672319E-01,    0.2459671041422877E+00,
     $        0.5264413137994085E+00,    0.9811642005004704E+00,
     $        0.2250423809963548E+01,    0.2959626347622103E+01,
     $        0.2967827289842799E+01,    0.2959626347622103E+01,
     $        0.2967826476573198E+01,    0.2250423809963548E+01,
     $        0.6085963592336598E-02,    0.6085973624531383E-02,
     $        0.9811661424155891E+00 /
      DATA (RTHTAB(4,J,5),J=1,15)/
     $        0.1183363666278417E-03,    0.1295270759699969E-03,
     $        0.3169137836898215E-02,    0.7006362464216589E-01,
     $        0.2364471774944505E+00,    0.6396342910254789E+00,
     $        0.2410987204577336E+01,    0.3735613243507420E+01,
     $        0.3752172348756504E+01,    0.3735613243507420E+01,
     $        0.3752170705266869E+01,    0.2410987204577336E+01,
     $        0.1295270506446048E-03,    0.1295275909260801E-03,
     $        0.6396363145524121E+00 /
      DATA (RTHTAB(4,J,6),J=1,15)/
     $        0.7373572594374325E-09,    0.1075110910198101E-08,
     $        0.1690675638635522E-05,    0.1190759100908589E-02,
     $        0.1565268689612706E-01,    0.1288077595898328E+00,
     $        0.2139992334116663E+01,    0.5409631851208299E+01,
     $        0.5460544289293762E+01,    0.5409631851208299E+01,
     $        0.5460539223746948E+01,    0.2139992334116663E+01,
     $        0.1075110106882599E-08,    0.1075127244522668E-08,
     $        0.1288086226207619E+00 /
      DATA (RTHTAB(4,J,7),J=1,15)/
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.1022990193254645E-66,    0.7308356111927279E-37,
     $        0.3909884698342626E-25,    0.1541989833542450E-15,
     $        0.9607966459721680E-03,    0.1602641649220523E+02,
     $        0.1768010395651999E+02,    0.1602641649220523E+02,
     $        0.1767993201880870E+02,    0.9607966459721680E-03,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.1542098145768002E-15 /
      DATA (RTHTAB(4,J,8),J=1,15)/
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.8057209949692564E-41,    0.2089523653108562E+02,
     $        0.5603620107189387E+02,    0.2089523653108562E+02,
     $        0.5603072707652527E+02,    0.8057209949692564E-41,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00 /
      DATA (RTHTAB(4,J,9),J=1,15)/
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.9186434011160556E-02,
     $        0.1772244957790231E+03,    0.9186434011160556E-02,
     $        0.1770514000339975E+03,    0.0000000000000000E+00,
     $        0.0000000000000000E+00,    0.0000000000000000E+00,
     $        0.0000000000000000E+00 /
      END

#endif
