// Copyright 2021 Jean Pierre Cimalando
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
//

#pragma once
#include "ysfx.h"
#include <vector>
#include <string>
#include <atomic>
#include <cstdarg>

struct ysfx_config_s {
    std::string import_root;
    std::string data_root;
    std::vector<ysfx_audio_format_t> audio_formats;
    ysfx_log_reporter_t *log_reporter = nullptr;
    intptr_t userdata = 0;
    std::atomic<uint32_t> ref_count{1};
};

void ysfx_log(ysfx_config_t &conf, ysfx_log_level level, const char *message);
void ysfx_logfv(ysfx_config_t &conf, ysfx_log_level level, const char *format, va_list ap);
#if defined(__GNUC__)
__attribute__((format(printf, 3, 4)))
#endif
void ysfx_logf(ysfx_config_t &conf, ysfx_log_level level, const char *format, ...);
