/* { dg-do run { target { riscv_v } } } */
/* { dg-additional-options "-std=c99" } */

#include "sat_arith.h"

DEF_SAT_U_SUB_IMM_FMT_1(uint64_t, 0)
DEF_SAT_U_SUB_IMM_FMT_1(uint64_t, 1)
DEF_SAT_U_SUB_IMM_FMT_1(uint64_t, 5)
DEF_SAT_U_SUB_IMM_FMT_1(uint64_t, 18446744073709551614u)
DEF_SAT_U_SUB_IMM_FMT_1(uint64_t, 18446744073709551615u)

#define T                       uint64_t
#define RUN(T, imm, op, expect) RUN_SAT_U_SUB_IMM_FMT_1(T, imm, op, expect)

T d[][3] = {
  /* arg_0, arg_1, expect */
  {                     0,                     0,                     0, },
  {                     1,                     0,                     1, },
  {                     1, 18446744073709551615u,                     0, },
  { 18446744073709551614u, 18446744073709551614u,                     0, },
  { 18446744073709551614u, 18446744073709551615u,                     0, },
  { 18446744073709551614u,                     2, 18446744073709551612u, },
  { 18446744073709551615u, 18446744073709551614u,                     1, },
  { 18446744073709551615u,                     0, 18446744073709551615u, },
  {                     5,                     2,                     3, },
  {                     5,                     6,                     0, },
};

int
main ()
{
  RUN (T,                     0, d[0][1], d[0][2]);

  RUN (T,                     1, d[1][1], d[1][2]);
  RUN (T,                     1, d[2][1], d[2][2]);

  RUN (T, 18446744073709551614u, d[3][1], d[3][2]);
  RUN (T, 18446744073709551614u, d[4][1], d[4][2]);
  RUN (T, 18446744073709551614u, d[5][1], d[5][2]);

  RUN (T, 18446744073709551615u, d[6][1], d[6][2]);
  RUN (T, 18446744073709551615u, d[7][1], d[7][2]);

  RUN (T,                     5, d[8][1], d[8][2]);
  RUN (T,                     5, d[9][1], d[9][2]);

  return 0;
}
