package ONVIF::PTZ::Types::ObjectTree;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Rename_of :ATTR(:get<Rename>);
my %Split_of :ATTR(:get<Split>);
my %Merge_of :ATTR(:get<Merge>);
my %Delete_of :ATTR(:get<Delete>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Rename
        Split
        Merge
        Delete
        Extension

    ) ],
    {
        'Rename' => \%Rename_of,
        'Split' => \%Split_of,
        'Merge' => \%Merge_of,
        'Delete' => \%Delete_of,
        'Extension' => \%Extension_of,
    },
    {
        'Rename' => 'ONVIF::PTZ::Types::Rename',
        'Split' => 'ONVIF::PTZ::Types::Split',
        'Merge' => 'ONVIF::PTZ::Types::Merge',
        'Delete' => 'ONVIF::PTZ::Types::ObjectId',
        'Extension' => 'ONVIF::PTZ::Types::ObjectTreeExtension',
    },
    {

        'Rename' => 'Rename',
        'Split' => 'Split',
        'Merge' => 'Merge',
        'Delete' => 'Delete',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::ObjectTree

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ObjectTree from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Rename


=item * Split


=item * Merge


=item * Delete


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::ObjectTree
   Rename =>  { # ONVIF::PTZ::Types::Rename
     from => ,
     to => ,
   },
   Split =>  { # ONVIF::PTZ::Types::Split
     from => ,
     to => ,
   },
   Merge =>  { # ONVIF::PTZ::Types::Merge
     from => ,
     to => ,
   },
   Delete => ,
   Extension =>  { # ONVIF::PTZ::Types::ObjectTreeExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

