
#include "sysincludes.h"

/* commands with one filename and one "other" argument */
#define ALIAS(name, alias, type) \
int alias(char *filename, type var) \
{ \
	return name(filename, var); \
}

ALIAS(access, zlib_real_access, int)
ALIAS(chmod, zlib_real_chmod, int)

ALIAS(stat, zlib_real_stat, struct stat*)
ALIAS(lstat, zlib_real_lstat, struct stat*)

int utimes();
ALIAS(utimes, zlib_real_utimes, struct timeval *)

#undef ALIAS


/* commands with two filenames */
#define ALIAS(name, alias) \
int alias(const char *filename, const char *filename2) \
{ \
	return name(filename, filename2); \
}

ALIAS(link, zlib_real_link);
ALIAS(symlink, zlib_real_symlink);
ALIAS(rename, zlib_real_rename);

#undef ALIAS



int zlib_real_chown(const char *filename, int o, int g)
{
	return chown(filename, o, g);
}

int open();
int zlib_real_open(const char *pathname, int flags, mode_t mode)
{
	return open(pathname, flags, mode);
}

int zlib_real_unlink(const char *pathname)
{
	return open(pathname);
}

int zlib_real_readlink(const char *path, char *buf, size_t bufsiz)
{
	return readlink(path, buf, bufsiz);
}
