//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2014 Thomas S. Ullrich
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: March 28, 2014
//-----------------------------------------------------------------------------
#include <QtGui>
#include <QApplication>
#include <QLocale>
#include <QTranslator>
#include <iostream>
#include "xyscanWindow.h" 
#include "xyscanVersion.h"

// #define FORCE_FRENCH_LOCALE 1

using namespace std; 

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    Q_INIT_RESOURCE(xyscan);
    app.setApplicationVersion(VERSION);
    
    
#ifdef Q_OS_MAC
    //
    //  Set attributes related to Retina display (Mac)
    //
    if (QGuiApplication::primaryScreen()->devicePixelRatio() > 1)
        app.setAttribute(Qt::AA_UseHighDpiPixmaps);
#endif
    
    //
    //  Set language and prepare translator
    //
#ifdef FORCE_FRENCH_LOCALE
    //  for testing only
    QLocale::setDefault(QLocale(QLocale::French, QLocale::France));
    QLocale locale;
#else
    QLocale locale = QLocale::system();
#endif
    
    QTranslator translator;
    QTranslator xyscanTranslator;
    
    if (locale.language() == QLocale::French) {
        QString path = qApp->applicationDirPath();
#if defined(Q_OS_MAC)
        path += "/../Resources/";
#endif
        bool rc = translator.load("qt_fr", QLibraryInfo::location(QLibraryInfo::TranslationsPath));
        if (!rc)
            cerr << "xdvmp (main): Warning, failed to load french translation (qt_fr)." << endl;
        rc = xyscanTranslator.load("xyscan_fr",path);
        if (!rc)
            cerr << "xdvmp (main): Warning, failed to load french translation (xyscan_fr)." << endl;
        app.installTranslator(&translator);
        app.installTranslator(&xyscanTranslator);
    }
    
    //
    //  Create and launch xyscan
    //
    xyscanWindow win;
    win.show();
    return app.exec();
}


