/*
 *========================================================================
 * $Id: set_display_dctl_state.c 72 2006-07-20 18:04:33Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 * Set all the dctl state features according to a display type switch.
 *========================================================================
 */

#include "wulflogger.h"

void set_display_dctl_state()
{

 Host *hostptr;
 ListElement *element;

 if((verbose == D_ALL) || (verbose == D_DISPLAY_VALUES)){
   printf("D_DISPLAY_VALUES: Starting display_values().  Use -v %d to focus.\n",D_DISPLAY_VALUES);
 }

 switch(display_type) {
   case DISPLAY_LOAD:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       printf("DISPLAY_LOAD: display_type = %d\n",DISPLAY_LOAD);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 1;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_NET:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       printf("DISPLAY_NET: display_type = %d\n",DISPLAY_NET);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 1;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_TIMES:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       printf("DISPLAY_TIMES: display_type = %d\n",DISPLAY_TIMES);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 1;
       hostptr->dctl.users = 1;
       hostptr->dctl.cpuinfo = 1;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 1;
       hostptr->dctl.version = 1;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_PIDS:
   case DISPLAY_PIDS_CMDLINE:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       printf("DISPLAY_PIDS: display_type = %d\n",DISPLAY_PIDS);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 1;
       hostptr->dctl.pidstats = 1;
       hostptr->dctl.cmdline = 1;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_MEMORY:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       printf("DISPLAY_MEMORY: display_type = %d\n",DISPLAY_MEMORY);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 0;
       hostptr->dctl.meminfo = 1;
       hostptr->dctl.net = 0;
       hostptr->dctl.stat = 0;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
   case DISPLAY_BASIC:
   default:
     if((verbose == D_ALL) || (verbose == D_STARTUP)){
       printf("DISPLAY_BASIC: display_type = %d\n",DISPLAY_BASIC);
     }
     element = hostlist->head;
     while(element != NULL){
       hostptr = element->data;
       hostptr->dctl.compress = 0;
       hostptr->dctl.whitespace = 0;
       hostptr->dctl.identity = 0;
       hostptr->dctl.time = 0;
       hostptr->dctl.users = 0;
       hostptr->dctl.cpuinfo = 0;
       hostptr->dctl.loadavg = 1;
       hostptr->dctl.meminfo = 0;
       hostptr->dctl.net = 1;
       hostptr->dctl.stat = 1;
       hostptr->dctl.sysvipc = 0;
       hostptr->dctl.uptime = 0;
       hostptr->dctl.version = 0;
       hostptr->dctl.pids = 0;
       hostptr->dctl.pidstats = 0;
       hostptr->dctl.cmdline = 0;
       hostptr->dctl.running = 0;
       hostptr->dctl.root = 0;
       if((verbose == D_ALL) || (verbose == D_STARTUP)){
         dump_dctl_state(hostptr);
       }
       element = element->next;
     }
     break;
 }

}

void dump_dctl_state(Host *hostptr)
{
 printf("==================================\n");
 printf("DCTL STATE DUMP:\n");
 printf("DISPLAY_BASIC: compress = %d\n",hostptr->dctl.compress);
 printf("DISPLAY_BASIC: whitespace = %d\n",hostptr->dctl.whitespace);
 printf("DISPLAY_BASIC: identity = %d\n",hostptr->dctl.identity);
 printf("DISPLAY_BASIC: time = %d\n",hostptr->dctl.time);
 printf("DISPLAY_BASIC: users = %d\n",hostptr->dctl.users);
 printf("DISPLAY_BASIC: cpuinfo = %d\n",hostptr->dctl.cpuinfo);
 printf("DISPLAY_BASIC: loadavg = %d\n",hostptr->dctl.loadavg);
 printf("DISPLAY_BASIC: meminfo = %d\n",hostptr->dctl.meminfo);
 printf("DISPLAY_BASIC: net = %d\n",hostptr->dctl.net);
 printf("DISPLAY_BASIC: stat = %d\n",hostptr->dctl.stat);
 printf("DISPLAY_BASIC: sysvipc = %d\n",hostptr->dctl.sysvipc);
 printf("DISPLAY_BASIC: uptime = %d\n",hostptr->dctl.uptime);
 printf("DISPLAY_BASIC: version = %d\n",hostptr->dctl.version);
 printf("DISPLAY_BASIC: pids = %d\n",hostptr->dctl.pids);
 printf("DISPLAY_BASIC: running = %d\n",hostptr->dctl.running);
 printf("DISPLAY_BASIC: root = %d\n",hostptr->dctl.root);
 printf("==================================\n");

}
