/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Element;
import writer2latex.office.CellView;
import writer2latex.office.TableLine;
import writer2latex.office.TableRange;
import writer2latex.office.TableReader;
import writer2latex.util.Misc;

public class TableView {
    private TableReader reader;
    private TableRange range;
    private int nRowCount;
    private int nColCount;
    private int[] nRowMap;
    private int[] nColMap;
    private CellView[][] cells;

    public TableView(TableReader reader, TableRange range) {
        this.reader = reader;
        this.range = range;
        this.nRowCount = 0;
        for (int nRow = range.getFirstRow(); nRow <= range.getLastRow(); ++nRow) {
            if (!this.isVisibleRow(nRow)) continue;
            ++this.nRowCount;
        }
        this.nColCount = 0;
        for (int nCol = range.getFirstCol(); nCol <= range.getLastCol(); ++nCol) {
            if (!this.isVisibleCol(nCol)) continue;
            ++this.nColCount;
        }
        this.nRowMap = new int[this.nRowCount];
        int nRealRow = range.getFirstRow();
        for (int nRow = 0; nRow < this.nRowCount; ++nRow) {
            while (!this.isVisibleRow(nRealRow)) {
                ++nRealRow;
            }
            this.nRowMap[nRow] = nRealRow++;
        }
        this.nColMap = new int[this.nColCount];
        int nRealCol = range.getFirstCol();
        for (int nCol = 0; nCol < this.nColCount; ++nCol) {
            while (!this.isVisibleCol(nRealCol)) {
                ++nRealCol;
            }
            this.nColMap[nCol] = nRealCol++;
        }
        this.cells = new CellView[this.nRowCount][this.nColCount];
        for (int nRow = 0; nRow < this.nRowCount; ++nRow) {
            for (int nCol = 0; nCol < this.nColCount; ++nCol) {
                this.cells[nRow][nCol] = new CellView();
            }
        }
        int nViewRow = 0;
        for (int nRow = 0; nRow <= range.getLastRow(); ++nRow) {
            if (nViewRow < this.nRowCount && this.nRowMap[nViewRow] < nRow) {
                ++nViewRow;
            }
            int nViewCol = 0;
            for (int nCol = 0; nCol <= range.getLastCol(); ++nCol) {
                Element cell;
                if (nViewCol < this.nColCount && this.nColMap[nViewCol] < nCol) {
                    ++nViewCol;
                }
                if ((cell = reader.getCell(nRow, nCol)) != null) {
                    if (Misc.isElement(cell, "table:table-cell")) {
                        int j;
                        int i;
                        int nRowSpan = Misc.getPosInteger(cell.getAttribute("table:number-rows-spanned"), 1);
                        int nColSpan = Misc.getPosInteger(cell.getAttribute("table:number-columns-spanned"), 1);
                        if (nViewRow >= this.nRowCount || this.nRowMap[nViewRow] >= nRow + nRowSpan || nViewCol >= this.nColCount || this.nColMap[nViewCol] >= nCol + nColSpan) continue;
                        this.cells[nViewRow][nViewCol].cell = cell;
                        this.cells[nViewRow][nViewCol].nOriginalRow = nRow;
                        this.cells[nViewRow][nViewCol].nOriginalCol = nCol;
                        for (i = nViewRow + 1; i < this.nRowCount && this.nRowMap[i] < nRow + nRowSpan; ++i) {
                        }
                        this.cells[nViewRow][nViewCol].nRowSpan = i - nViewRow;
                        for (j = nViewCol + 1; j < this.nColCount && this.nColMap[j] < nCol + nColSpan; ++j) {
                        }
                        this.cells[nViewRow][nViewCol].nColSpan = j - nViewCol;
                        continue;
                    }
                    if (!Misc.isElement(cell, "table:covered-table-cell") || this.cells[nViewRow][nViewCol].cell != null) continue;
                    this.cells[nViewRow][nViewCol].cell = cell;
                    this.cells[nViewRow][nViewCol].nOriginalRow = nRow;
                    this.cells[nViewRow][nViewCol].nOriginalCol = nCol;
                    continue;
                }
                if (nViewRow >= this.nRowCount || this.nRowMap[nViewRow] >= nRow + 1 || nViewCol >= this.nColCount || this.nColMap[nViewCol] >= nCol + 1) continue;
                this.cells[nViewRow][nViewCol].cell = null;
                this.cells[nViewRow][nViewCol].nOriginalRow = nRow;
                this.cells[nViewRow][nViewCol].nOriginalCol = nCol;
                this.cells[nViewRow][nViewCol].nRowSpan = 1;
                this.cells[nViewRow][nViewCol].nColSpan = 1;
            }
        }
    }

    public String getRelTableWidth() {
        return this.reader.getRelTableWidth();
    }

    public int getRowCount() {
        return this.nRowCount;
    }

    public int getColCount() {
        return this.nColCount;
    }

    public String getColumnWidth(int nCol) {
        return 0 <= nCol && nCol <= this.nColCount ? this.reader.getColumnWidth(this.nColMap[nCol]) : null;
    }

    public String getRelColumnWidth(int nCol) {
        return 0 <= nCol && nCol <= this.nColCount ? this.reader.getRelColumnWidth(this.nColMap[nCol]) : null;
    }

    public TableLine getRow(int nRow) {
        return 0 <= nRow && nRow < this.nRowCount ? this.reader.getRow(this.nRowMap[nRow]) : null;
    }

    public TableLine getCol(int nCol) {
        return 0 <= nCol && nCol < this.nColCount ? this.reader.getCol(this.nColMap[nCol]) : null;
    }

    public Element getCell(int nRow, int nCol) {
        return 0 <= nRow && nRow < this.nRowCount && 0 <= nCol && nCol < this.nColCount ? this.cells[nRow][nCol].cell : null;
    }

    public int getRowSpan(int nRow, int nCol) {
        return 0 <= nRow && nRow < this.nRowCount && 0 <= nCol && nCol < this.nColCount ? this.cells[nRow][nCol].nRowSpan : 1;
    }

    public int getColSpan(int nRow, int nCol) {
        return 0 <= nRow && nRow < this.nRowCount && 0 <= nCol && nCol < this.nColCount ? this.cells[nRow][nCol].nColSpan : 1;
    }

    public String getCellStyleName(int nRow, int nCol) {
        return 0 <= nRow && nRow < this.nRowCount && 0 <= nCol && nCol < this.nColCount ? this.reader.getCellStyleName(this.cells[nRow][nCol].nOriginalRow, this.cells[nRow][nCol].nOriginalCol) : null;
    }

    public String getCellWidth(int nRow, int nCol) {
        return 0 <= nRow && nRow < this.nRowCount && 0 <= nCol && nCol < this.nColCount ? this.reader.getCellWidth(this.cells[nRow][nCol].nOriginalRow, this.cells[nRow][nCol].nOriginalCol) : null;
    }

    private boolean isVisibleRow(int nRow) {
        return !(nRow < this.range.getFirstRow() || nRow > this.range.getLastRow() || !this.range.includeHidden() && this.reader.getRow(nRow).isCollapse() || !this.range.includeFiltered() && this.reader.getRow(nRow).isFilter());
    }

    private boolean isVisibleCol(int nCol) {
        return !(nCol < this.range.getFirstCol() || nCol > this.range.getLastCol() || !this.range.includeHidden() && this.reader.getCol(nCol).isCollapse() || !this.range.includeFiltered() && this.reader.getCol(nCol).isFilter());
    }
}

