/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.vrml97;

import java.io.StringReader;
import org.web3d.parser.vrml97.ParseException;
import org.web3d.parser.vrml97.VRML97FieldParser;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.sav.Locator;

public class VRML97FieldReader
implements VRMLFieldReader {
    private static final String DOUBLE_SPT_MSG = "VRML97 does not support doubles";
    private static final String LONG_SPT_MSG = "VRML97 does not support longs";
    private static final String RGBA_SPT_MSG = "VRML97 does not support RGBA colors";
    private static final String MFIMAGE_SPT_MSG = "VRML97 does not support MFImage";
    private static final String MFBOOL_SPT_MSG = "VRML97 does not support MFBool";
    private boolean useLowerBoolean = false;
    private VRML97FieldParser fieldParser;
    private Object mutex;
    private Locator locator;

    public VRML97FieldReader() {
        StringReader stringReader = new StringReader("");
        this.fieldParser = new VRML97FieldParser(stringReader);
        this.mutex = new Object();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setCaseSensitive(boolean bl) {
        this.useLowerBoolean = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseUnknownField(String string, boolean bl) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        Object object = null;
        try {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.fieldParser.ReInit(stringReader);
                object = this.fieldParser.parseUnknownField(bl);
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SFInt32(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int n = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                n = this.fieldParser.SFInt32();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] MFInt32(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int[] nArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                nArray = this.fieldParser.MFInt32();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] MFInt32(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = Integer.parseInt(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFInt32 field: " + stringArray[n2]);
        }
        return nArray;
    }

    public long SFLong(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(LONG_SPT_MSG);
    }

    public long[] MFLong(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(LONG_SPT_MSG);
    }

    public long[] MFLong(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(LONG_SPT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float SFFloat(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float f = 0.0f;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                f = this.fieldParser.SFFloat();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFFloat(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFFloat();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFFloat(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFFloat field: " + stringArray[n2]);
        }
        return fArray;
    }

    public double SFDouble(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFDouble(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFDouble(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SFBool(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        boolean bl = false;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                bl = this.fieldParser.SFBool();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return bl;
    }

    public boolean[] MFBool(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFBOOL_SPT_MSG);
    }

    public boolean[] MFBool(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFBOOL_SPT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String SFString(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        String string2 = string;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                string2 = this.fieldParser.SFString();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] MFString(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        String[] stringArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                stringArray = this.fieldParser.MFString();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return stringArray;
    }

    public String[] MFString(String[] stringArray) throws InvalidFieldFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return this.MFString(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec2f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFVec2f();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec2f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[2];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in MfVec3f field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in MfVec3f field: " + stringArray[1]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec2f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFVec2f();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec2f(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFVec2f field: " + stringArray[n2]);
        }
        return fArray;
    }

    public double[] SFVec2d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] SFVec2d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFVec2d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFVec2d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec3f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFVec3f();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFVec3f(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[3];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in MfVec3f field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in MfVec3f field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in MfVec3f field: " + stringArray[2]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec3f(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFVec3f();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFVec3f(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MfVec3f field: " + stringArray[n2]);
        }
        return fArray;
    }

    public double[] SFVec3d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] SFVec3d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFVec3d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFVec3d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public float[] SFVec4f(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public float[] SFVec4f(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public float[] MFVec4f(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public float[] MFVec4f(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] SFVec4d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] SFVec4d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFVec4d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    public double[] MFVec4d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(DOUBLE_SPT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFRotation(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFRotation();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFRotation(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[4];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[2]);
            }
            try {
                fArray[3] = Float.parseFloat(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFRotation field: " + stringArray[3]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFRotation(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFRotation();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFRotation(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFRotation field: " + stringArray[n2]);
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double SFTime(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double d = 0.0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                d = this.fieldParser.SFTime();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFTime(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        double[] dArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                dArray = this.fieldParser.MFTime();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] MFTime(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFTime field: " + stringArray[n2]);
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFColor(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.SFColor();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] SFColor(String[] stringArray) throws InvalidFieldFormatException {
        float[] fArray = new float[3];
        Object object = this.mutex;
        synchronized (object) {
            try {
                fArray[0] = Float.parseFloat(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColor field: " + stringArray[0]);
            }
            try {
                fArray[1] = Float.parseFloat(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColor field: " + stringArray[1]);
            }
            try {
                fArray[2] = Float.parseFloat(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFieldFormatException("Invalid floating point value in SFColor field: " + stringArray[2]);
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFColor(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        float[] fArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                fArray = this.fieldParser.MFColor();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] MFColor(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        float[] fArray = new float[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    fArray[n2] = Float.parseFloat(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in MFColor field: " + stringArray[n2]);
        }
        return fArray;
    }

    public float[] SFColorRGBA(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(RGBA_SPT_MSG);
    }

    public float[] SFColorRGBA(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(RGBA_SPT_MSG);
    }

    public float[] MFColorRGBA(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(RGBA_SPT_MSG);
    }

    public float[] MFColorRGBA(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(RGBA_SPT_MSG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SFImage(String string) throws InvalidFieldFormatException {
        StringReader stringReader = new StringReader(string);
        int[] nArray = null;
        try {
            Object object = this.mutex;
            synchronized (object) {
                this.fieldParser.ReInit(stringReader);
                nArray = this.fieldParser.SFImage();
            }
        }
        catch (ParseException parseException) {
            System.out.println("Offending value: " + string);
            throw new InvalidFieldFormatException(parseException.getMessage());
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] SFImage(String[] stringArray) throws InvalidFieldFormatException {
        int n = stringArray == null ? 0 : stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        try {
            Object object = this.mutex;
            synchronized (object) {
                for (n2 = 0; n2 < n; ++n2) {
                    nArray[n2] = Integer.parseInt(stringArray[n2]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFieldFormatException("Invalid floating point value in SFImage field: " + stringArray[n2]);
        }
        return nArray;
    }

    public int[] MFImage(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public int[] MFImage(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] SFMatrix3f(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] SFMatrix3f(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] MFMatrix3f(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] MFMatrix3f(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] SFMatrix3d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] SFMatrix3d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] MFMatrix3d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] MFMatrix3d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] SFMatrix4f(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] SFMatrix4f(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] MFMatrix4f(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public float[] MFMatrix4f(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] SFMatrix4d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] SFMatrix4d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] MFMatrix4d(String string) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }

    public double[] MFMatrix4d(String[] stringArray) throws InvalidFieldFormatException {
        throw new InvalidFieldFormatException(MFIMAGE_SPT_MSG);
    }
}

