/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TCOLORCHOSER_H_
#define _TCOLORCHOSER_H_
#include <QtGui>

class TColorChoser : public QWidget
{
	Q_OBJECT
	
	public:
		TColorChoser(QWidget *parent = 0);
		QHBoxLayout *getLayout();
		void setText(QString);
		void setColor(QColor);
		QColor getColor();
	
	private slots:
		void S_SelectColor();
	
	signals:
		void colorChanged(QColor &);
		
	private:
		QString toStyle(QString);
		
		QLabel *colorLabel;
		QPushButton *colorSelect;
		QHBoxLayout *hLayout;

		QColor tmp_color;

};

#endif
