/*   
 *   This is part of Remote System Call (RSC) Library.
 *
 *   rsc_consts.c: RSC constants management
 *   
 *   Copyright (C) 2007 Andrea Forni
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License, version 2, as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "aconv.h"
#include "nr_to_rsc.h"
#include "rsc_to_nr.h"
#include "debug.h"

/*########################################################################*/
/*##                                                                    ##*/
/*##  LOCAL VARIABLES                                                   ##*/
/*##                                                                    ##*/
/*########################################################################*/

/* Strings returned when is required a string for a __RSC_* or __NR_*
 * constant that doesn't exist. */
char *rsc_not_existing = "__RSC_ CONSTANT DOESN'T EXIST!";
char *nr_not_existing = "__NR_ CONSTANT DOESN'T EXIST!";

/**************************************************************************/
/*  The following tables are used to convert to string a __NR_* or        */
/*  __RSC_* constant.                                                     */
/**************************************************************************/

char *rsc_to_str[] = {
	/* 0. __RSC__exit */ "__RSC__exit",
	/* 1. __RSC__llseek */ "__RSC__llseek",
	/* 2. __RSC__newselect */ "__RSC__newselect",
	/* 3. __RSC__sysctl */ "__RSC__sysctl",
	/* 4. __RSC_accept */ "__RSC_accept",
	/* 5. __RSC_access */ "__RSC_access",
	/* 6. __RSC_acct */ "__RSC_acct",
	/* 7. __RSC_add_key */ "__RSC_add_key",
	/* 8. __RSC_adjtimex */ "__RSC_adjtimex",
	/* 9. __RSC_afs_syscall */ "__RSC_afs_syscall",
	/* 10. __RSC_alarm */ "__RSC_alarm",
	/* 11. __RSC_arch_prctl */ "__RSC_arch_prctl",
	/* 12. __RSC_bdflush */ "__RSC_bdflush",
	/* 13. __RSC_bind */ "__RSC_bind",
	/* 14. __RSC_break */ "__RSC_break",
	/* 15. __RSC_brk */ "__RSC_brk",
	/* 16. __RSC_capget */ "__RSC_capget",
	/* 17. __RSC_capset */ "__RSC_capset",
	/* 18. __RSC_chdir */ "__RSC_chdir",
	/* 19. __RSC_chmod */ "__RSC_chmod",
	/* 20. __RSC_chown */ "__RSC_chown",
	/* 21. __RSC_chown32 */ "__RSC_chown32",
	/* 22. __RSC_chroot */ "__RSC_chroot",
	/* 23. __RSC_clock_getres */ "__RSC_clock_getres",
	/* 24. __RSC_clock_gettime */ "__RSC_clock_gettime",
	/* 25. __RSC_clock_nanosleep */ "__RSC_clock_nanosleep",
	/* 26. __RSC_clock_settime */ "__RSC_clock_settime",
	/* 27. __RSC_clone */ "__RSC_clone",
	/* 28. __RSC_close */ "__RSC_close",
	/* 29. __RSC_connect */ "__RSC_connect",
	/* 30. __RSC_creat */ "__RSC_creat",
	/* 31. __RSC_create_module */ "__RSC_create_module",
	/* 32. __RSC_delete_module */ "__RSC_delete_module",
	/* 33. __RSC_dup */ "__RSC_dup",
	/* 34. __RSC_dup2 */ "__RSC_dup2",
	/* 35. __RSC_epoll_create */ "__RSC_epoll_create",
	/* 36. __RSC_epoll_ctl */ "__RSC_epoll_ctl",
	/* 37. __RSC_epoll_ctl_old */ "__RSC_epoll_ctl_old",
	/* 38. __RSC_epoll_wait */ "__RSC_epoll_wait",
	/* 39. __RSC_epoll_wait_old */ "__RSC_epoll_wait_old",
	/* 40. __RSC_execve */ "__RSC_execve",
	/* 41. __RSC_exit */ "__RSC_exit",
	/* 42. __RSC_exit_group */ "__RSC_exit_group",
	/* 43. __RSC_fadvise64 */ "__RSC_fadvise64",
	/* 44. __RSC_fadvise64_64 */ "__RSC_fadvise64_64",
	/* 45. __RSC_fchdir */ "__RSC_fchdir",
	/* 46. __RSC_fchmod */ "__RSC_fchmod",
	/* 47. __RSC_fchown */ "__RSC_fchown",
	/* 48. __RSC_fchown32 */ "__RSC_fchown32",
	/* 49. __RSC_fcntl */ "__RSC_fcntl",
	/* 50. __RSC_fcntl64 */ "__RSC_fcntl64",
	/* 51. __RSC_fdatasync */ "__RSC_fdatasync",
	/* 52. __RSC_fgetxattr */ "__RSC_fgetxattr",
	/* 53. __RSC_flistxattr */ "__RSC_flistxattr",
	/* 54. __RSC_flock */ "__RSC_flock",
	/* 55. __RSC_fork */ "__RSC_fork",
	/* 56. __RSC_fremovexattr */ "__RSC_fremovexattr",
	/* 57. __RSC_fsetxattr */ "__RSC_fsetxattr",
	/* 58. __RSC_fstat */ "__RSC_fstat",
	/* 59. __RSC_fstat64 */ "__RSC_fstat64",
	/* 60. __RSC_fstatfs */ "__RSC_fstatfs",
	/* 61. __RSC_fstatfs64 */ "__RSC_fstatfs64",
	/* 62. __RSC_fsync */ "__RSC_fsync",
	/* 63. __RSC_ftime */ "__RSC_ftime",
	/* 64. __RSC_ftruncate */ "__RSC_ftruncate",
	/* 65. __RSC_ftruncate64 */ "__RSC_ftruncate64",
	/* 66. __RSC_futex */ "__RSC_futex",
	/* 67. __RSC_get_kernel_syms */ "__RSC_get_kernel_syms",
	/* 68. __RSC_get_mempolicy */ "__RSC_get_mempolicy",
	/* 69. __RSC_get_thread_area */ "__RSC_get_thread_area",
	/* 70. __RSC_getcwd */ "__RSC_getcwd",
	/* 71. __RSC_getdents */ "__RSC_getdents",
	/* 72. __RSC_getdents64 */ "__RSC_getdents64",
	/* 73. __RSC_getegid */ "__RSC_getegid",
	/* 74. __RSC_getegid32 */ "__RSC_getegid32",
	/* 75. __RSC_geteuid */ "__RSC_geteuid",
	/* 76. __RSC_geteuid32 */ "__RSC_geteuid32",
	/* 77. __RSC_getgid */ "__RSC_getgid",
	/* 78. __RSC_getgid32 */ "__RSC_getgid32",
	/* 79. __RSC_getgroups */ "__RSC_getgroups",
	/* 80. __RSC_getgroups32 */ "__RSC_getgroups32",
	/* 81. __RSC_getitimer */ "__RSC_getitimer",
	/* 82. __RSC_getpeername */ "__RSC_getpeername",
	/* 83. __RSC_getpgid */ "__RSC_getpgid",
	/* 84. __RSC_getpgrp */ "__RSC_getpgrp",
	/* 85. __RSC_getpid */ "__RSC_getpid",
	/* 86. __RSC_getpmsg */ "__RSC_getpmsg",
	/* 87. __RSC_getppid */ "__RSC_getppid",
	/* 88. __RSC_getpriority */ "__RSC_getpriority",
	/* 89. __RSC_getresgid */ "__RSC_getresgid",
	/* 90. __RSC_getresgid32 */ "__RSC_getresgid32",
	/* 91. __RSC_getresuid */ "__RSC_getresuid",
	/* 92. __RSC_getresuid32 */ "__RSC_getresuid32",
	/* 93. __RSC_getrlimit */ "__RSC_getrlimit",
	/* 94. __RSC_getrusage */ "__RSC_getrusage",
	/* 95. __RSC_getsid */ "__RSC_getsid",
	/* 96. __RSC_getsockname */ "__RSC_getsockname",
	/* 97. __RSC_getsockopt */ "__RSC_getsockopt",
	/* 98. __RSC_gettid */ "__RSC_gettid",
	/* 99. __RSC_gettimeofday */ "__RSC_gettimeofday",
	/* 100. __RSC_getuid */ "__RSC_getuid",
	/* 101. __RSC_getuid32 */ "__RSC_getuid32",
	/* 102. __RSC_getxattr */ "__RSC_getxattr",
	/* 103. __RSC_gtty */ "__RSC_gtty",
	/* 104. __RSC_idle */ "__RSC_idle",
	/* 105. __RSC_init_module */ "__RSC_init_module",
	/* 106. __RSC_io_cancel */ "__RSC_io_cancel",
	/* 107. __RSC_io_destroy */ "__RSC_io_destroy",
	/* 108. __RSC_io_getevents */ "__RSC_io_getevents",
	/* 109. __RSC_io_setup */ "__RSC_io_setup",
	/* 110. __RSC_io_submit */ "__RSC_io_submit",
	/* 111. __RSC_ioctl */ "__RSC_ioctl",
	/* 112. __RSC_ioperm */ "__RSC_ioperm",
	/* 113. __RSC_iopl */ "__RSC_iopl",
	/* 114. __RSC_ipc */ "__RSC_ipc",
	/* 115. __RSC_kexec_load */ "__RSC_kexec_load",
	/* 116. __RSC_keyctl */ "__RSC_keyctl",
	/* 117. __RSC_kill */ "__RSC_kill",
	/* 118. __RSC_lchown */ "__RSC_lchown",
	/* 119. __RSC_lchown32 */ "__RSC_lchown32",
	/* 120. __RSC_lgetxattr */ "__RSC_lgetxattr",
	/* 121. __RSC_link */ "__RSC_link",
	/* 122. __RSC_listen */ "__RSC_listen",
	/* 123. __RSC_listxattr */ "__RSC_listxattr",
	/* 124. __RSC_llistxattr */ "__RSC_llistxattr",
	/* 125. __RSC_lock */ "__RSC_lock",
	/* 126. __RSC_lookup_dcookie */ "__RSC_lookup_dcookie",
	/* 127. __RSC_lremovexattr */ "__RSC_lremovexattr",
	/* 128. __RSC_lseek */ "__RSC_lseek",
	/* 129. __RSC_lsetxattr */ "__RSC_lsetxattr",
	/* 130. __RSC_lstat */ "__RSC_lstat",
	/* 131. __RSC_lstat64 */ "__RSC_lstat64",
	/* 132. __RSC_madvise */ "__RSC_madvise",
	/* 133. __RSC_madvise1 */ "__RSC_madvise1",
	/* 134. __RSC_mbind */ "__RSC_mbind",
	/* 135. __RSC_mincore */ "__RSC_mincore",
	/* 136. __RSC_mkdir */ "__RSC_mkdir",
	/* 137. __RSC_mknod */ "__RSC_mknod",
	/* 138. __RSC_mlock */ "__RSC_mlock",
	/* 139. __RSC_mlockall */ "__RSC_mlockall",
	/* 140. __RSC_mmap */ "__RSC_mmap",
	/* 141. __RSC_mmap2 */ "__RSC_mmap2",
	/* 142. __RSC_modify_ldt */ "__RSC_modify_ldt",
	/* 143. __RSC_mount */ "__RSC_mount",
	/* 144. __RSC_mprotect */ "__RSC_mprotect",
	/* 145. __RSC_mpx */ "__RSC_mpx",
	/* 146. __RSC_mq_getsetattr */ "__RSC_mq_getsetattr",
	/* 147. __RSC_mq_notify */ "__RSC_mq_notify",
	/* 148. __RSC_mq_open */ "__RSC_mq_open",
	/* 149. __RSC_mq_timedreceive */ "__RSC_mq_timedreceive",
	/* 150. __RSC_mq_timedsend */ "__RSC_mq_timedsend",
	/* 151. __RSC_mq_unlink */ "__RSC_mq_unlink",
	/* 152. __RSC_mremap */ "__RSC_mremap",
	/* 153. __RSC_msgctl */ "__RSC_msgctl",
	/* 154. __RSC_msgget */ "__RSC_msgget",
	/* 155. __RSC_msgrcv */ "__RSC_msgrcv",
	/* 156. __RSC_msgsnd */ "__RSC_msgsnd",
	/* 157. __RSC_msync */ "__RSC_msync",
	/* 158. __RSC_multiplexer */ "__RSC_multiplexer",
	/* 159. __RSC_munlock */ "__RSC_munlock",
	/* 160. __RSC_munlockall */ "__RSC_munlockall",
	/* 161. __RSC_munmap */ "__RSC_munmap",
	/* 162. __RSC_nanosleep */ "__RSC_nanosleep",
	/* 163. __RSC_nfsservctl */ "__RSC_nfsservctl",
	/* 164. __RSC_nice */ "__RSC_nice",
	/* 165. __RSC_oldfstat */ "__RSC_oldfstat",
	/* 166. __RSC_oldlstat */ "__RSC_oldlstat",
	/* 167. __RSC_oldolduname */ "__RSC_oldolduname",
	/* 168. __RSC_oldstat */ "__RSC_oldstat",
	/* 169. __RSC_olduname */ "__RSC_olduname",
	/* 170. __RSC_open */ "__RSC_open",
	/* 171. __RSC_pause */ "__RSC_pause",
	/* 172. __RSC_pciconfig_iobase */ "__RSC_pciconfig_iobase",
	/* 173. __RSC_pciconfig_read */ "__RSC_pciconfig_read",
	/* 174. __RSC_pciconfig_write */ "__RSC_pciconfig_write",
	/* 175. __RSC_personality */ "__RSC_personality",
	/* 176. __RSC_pipe */ "__RSC_pipe",
	/* 177. __RSC_pivot_root */ "__RSC_pivot_root",
	/* 178. __RSC_poll */ "__RSC_poll",
	/* 179. __RSC_prctl */ "__RSC_prctl",
	/* 180. __RSC_pread64 */ "__RSC_pread64",
	/* 181. __RSC_prof */ "__RSC_prof",
	/* 182. __RSC_profil */ "__RSC_profil",
	/* 183. __RSC_ptrace */ "__RSC_ptrace",
	/* 184. __RSC_putpmsg */ "__RSC_putpmsg",
	/* 185. __RSC_pwrite64 */ "__RSC_pwrite64",
	/* 186. __RSC_query_module */ "__RSC_query_module",
	/* 187. __RSC_quotactl */ "__RSC_quotactl",
	/* 188. __RSC_read */ "__RSC_read",
	/* 189. __RSC_readahead */ "__RSC_readahead",
	/* 190. __RSC_readdir */ "__RSC_readdir",
	/* 191. __RSC_readlink */ "__RSC_readlink",
	/* 192. __RSC_readv */ "__RSC_readv",
	/* 193. __RSC_reboot */ "__RSC_reboot",
	/* 194. __RSC_recv */ "__RSC_recv",
	/* 195. __RSC_recvfrom */ "__RSC_recvfrom",
	/* 196. __RSC_recvmsg */ "__RSC_recvmsg",
	/* 197. __RSC_remap_file_pages */ "__RSC_remap_file_pages",
	/* 198. __RSC_removexattr */ "__RSC_removexattr",
	/* 199. __RSC_rename */ "__RSC_rename",
	/* 200. __RSC_request_key */ "__RSC_request_key",
	/* 201. __RSC_restart_syscall */ "__RSC_restart_syscall",
	/* 202. __RSC_rmdir */ "__RSC_rmdir",
	/* 203. __RSC_rt_sigaction */ "__RSC_rt_sigaction",
	/* 204. __RSC_rt_sigpending */ "__RSC_rt_sigpending",
	/* 205. __RSC_rt_sigprocmask */ "__RSC_rt_sigprocmask",
	/* 206. __RSC_rt_sigqueueinfo */ "__RSC_rt_sigqueueinfo",
	/* 207. __RSC_rt_sigreturn */ "__RSC_rt_sigreturn",
	/* 208. __RSC_rt_sigsuspend */ "__RSC_rt_sigsuspend",
	/* 209. __RSC_rt_sigtimedwait */ "__RSC_rt_sigtimedwait",
	/* 210. __RSC_sched_get_priority_max */ "__RSC_sched_get_priority_max",
	/* 211. __RSC_sched_get_priority_min */ "__RSC_sched_get_priority_min",
	/* 212. __RSC_sched_getaffinity */ "__RSC_sched_getaffinity",
	/* 213. __RSC_sched_getparam */ "__RSC_sched_getparam",
	/* 214. __RSC_sched_getscheduler */ "__RSC_sched_getscheduler",
	/* 215. __RSC_sched_rr_get_interval */ "__RSC_sched_rr_get_interval",
	/* 216. __RSC_sched_setaffinity */ "__RSC_sched_setaffinity",
	/* 217. __RSC_sched_setparam */ "__RSC_sched_setparam",
	/* 218. __RSC_sched_setscheduler */ "__RSC_sched_setscheduler",
	/* 219. __RSC_sched_yield */ "__RSC_sched_yield",
	/* 220. __RSC_security */ "__RSC_security",
	/* 221. __RSC_select */ "__RSC_select",
	/* 222. __RSC_semctl */ "__RSC_semctl",
	/* 223. __RSC_semget */ "__RSC_semget",
	/* 224. __RSC_semop */ "__RSC_semop",
	/* 225. __RSC_semtimedop */ "__RSC_semtimedop",
	/* 226. __RSC_send */ "__RSC_send",
	/* 227. __RSC_sendfile */ "__RSC_sendfile",
	/* 228. __RSC_sendfile64 */ "__RSC_sendfile64",
	/* 229. __RSC_sendmsg */ "__RSC_sendmsg",
	/* 230. __RSC_sendto */ "__RSC_sendto",
	/* 231. __RSC_set_mempolicy */ "__RSC_set_mempolicy",
	/* 232. __RSC_set_thread_area */ "__RSC_set_thread_area",
	/* 233. __RSC_set_tid_address */ "__RSC_set_tid_address",
	/* 234. __RSC_setdomainname */ "__RSC_setdomainname",
	/* 235. __RSC_setfsgid */ "__RSC_setfsgid",
	/* 236. __RSC_setfsgid32 */ "__RSC_setfsgid32",
	/* 237. __RSC_setfsuid */ "__RSC_setfsuid",
	/* 238. __RSC_setfsuid32 */ "__RSC_setfsuid32",
	/* 239. __RSC_setgid */ "__RSC_setgid",
	/* 240. __RSC_setgid32 */ "__RSC_setgid32",
	/* 241. __RSC_setgroups */ "__RSC_setgroups",
	/* 242. __RSC_setgroups32 */ "__RSC_setgroups32",
	/* 243. __RSC_sethostname */ "__RSC_sethostname",
	/* 244. __RSC_setitimer */ "__RSC_setitimer",
	/* 245. __RSC_setpgid */ "__RSC_setpgid",
	/* 246. __RSC_setpriority */ "__RSC_setpriority",
	/* 247. __RSC_setregid */ "__RSC_setregid",
	/* 248. __RSC_setregid32 */ "__RSC_setregid32",
	/* 249. __RSC_setresgid */ "__RSC_setresgid",
	/* 250. __RSC_setresgid32 */ "__RSC_setresgid32",
	/* 251. __RSC_setresuid */ "__RSC_setresuid",
	/* 252. __RSC_setresuid32 */ "__RSC_setresuid32",
	/* 253. __RSC_setreuid */ "__RSC_setreuid",
	/* 254. __RSC_setreuid32 */ "__RSC_setreuid32",
	/* 255. __RSC_setrlimit */ "__RSC_setrlimit",
	/* 256. __RSC_setsid */ "__RSC_setsid",
	/* 257. __RSC_setsockopt */ "__RSC_setsockopt",
	/* 258. __RSC_settimeofday */ "__RSC_settimeofday",
	/* 259. __RSC_setuid */ "__RSC_setuid",
	/* 260. __RSC_setuid32 */ "__RSC_setuid32",
	/* 261. __RSC_setxattr */ "__RSC_setxattr",
	/* 262. __RSC_sgetmask */ "__RSC_sgetmask",
	/* 263. __RSC_shmat */ "__RSC_shmat",
	/* 264. __RSC_shmctl */ "__RSC_shmctl",
	/* 265. __RSC_shmdt */ "__RSC_shmdt",
	/* 266. __RSC_shmget */ "__RSC_shmget",
	/* 267. __RSC_shutdown */ "__RSC_shutdown",
	/* 268. __RSC_sigaction */ "__RSC_sigaction",
	/* 269. __RSC_sigaltstack */ "__RSC_sigaltstack",
	/* 270. __RSC_signal */ "__RSC_signal",
	/* 271. __RSC_sigpending */ "__RSC_sigpending",
	/* 272. __RSC_sigprocmask */ "__RSC_sigprocmask",
	/* 273. __RSC_sigreturn */ "__RSC_sigreturn",
	/* 274. __RSC_sigsuspend */ "__RSC_sigsuspend",
	/* 275. __RSC_socket */ "__RSC_socket",
	/* 276. __RSC_socketcall */ "__RSC_socketcall",
	/* 277. __RSC_socketpair */ "__RSC_socketpair",
	/* 278. __RSC_ssetmask */ "__RSC_ssetmask",
	/* 279. __RSC_stat */ "__RSC_stat",
	/* 280. __RSC_stat64 */ "__RSC_stat64",
	/* 281. __RSC_statfs */ "__RSC_statfs",
	/* 282. __RSC_statfs64 */ "__RSC_statfs64",
	/* 283. __RSC_stime */ "__RSC_stime",
	/* 284. __RSC_stty */ "__RSC_stty",
	/* 285. __RSC_swapcontext */ "__RSC_swapcontext",
	/* 286. __RSC_swapoff */ "__RSC_swapoff",
	/* 287. __RSC_swapon */ "__RSC_swapon",
	/* 288. __RSC_symlink */ "__RSC_symlink",
	/* 289. __RSC_sync */ "__RSC_sync",
	/* 290. __RSC_sys_kexec_load */ "__RSC_sys_kexec_load",
	/* 291. __RSC_sysfs */ "__RSC_sysfs",
	/* 292. __RSC_sysinfo */ "__RSC_sysinfo",
	/* 293. __RSC_syslog */ "__RSC_syslog",
	/* 294. __RSC_tgkill */ "__RSC_tgkill",
	/* 295. __RSC_time */ "__RSC_time",
	/* 296. __RSC_timer_create */ "__RSC_timer_create",
	/* 297. __RSC_timer_delete */ "__RSC_timer_delete",
	/* 298. __RSC_timer_getoverrun */ "__RSC_timer_getoverrun",
	/* 299. __RSC_timer_gettime */ "__RSC_timer_gettime",
	/* 300. __RSC_timer_settime */ "__RSC_timer_settime",
	/* 301. __RSC_times */ "__RSC_times",
	/* 302. __RSC_tkill */ "__RSC_tkill",
	/* 303. __RSC_truncate */ "__RSC_truncate",
	/* 304. __RSC_truncate64 */ "__RSC_truncate64",
	/* 305. __RSC_tuxcall */ "__RSC_tuxcall",
	/* 306. __RSC_ugetrlimit */ "__RSC_ugetrlimit",
	/* 307. __RSC_ulimit */ "__RSC_ulimit",
	/* 308. __RSC_umask */ "__RSC_umask",
	/* 309. __RSC_umount */ "__RSC_umount",
	/* 310. __RSC_umount2 */ "__RSC_umount2",
	/* 311. __RSC_uname */ "__RSC_uname",
	/* 312. __RSC_unlink */ "__RSC_unlink",
	/* 313. __RSC_uselib */ "__RSC_uselib",
	/* 314. __RSC_ustat */ "__RSC_ustat",
	/* 315. __RSC_utime */ "__RSC_utime",
	/* 316. __RSC_utimes */ "__RSC_utimes",
	/* 317. __RSC_vfork */ "__RSC_vfork",
	/* 318. __RSC_vhangup */ "__RSC_vhangup",
	/* 319. __RSC_vm86 */ "__RSC_vm86",
	/* 320. __RSC_vm86old */ "__RSC_vm86old",
	/* 321. __RSC_vserver */ "__RSC_vserver",
	/* 322. __RSC_wait4 */ "__RSC_wait4",
	/* 323. __RSC_waitid */ "__RSC_waitid",
	/* 324. __RSC_waitpid */ "__RSC_waitpid",
	/* 325. __RSC_write */ "__RSC_write",
	/* 326. __RSC_writev */ "__RSC_writev",
};

char * x86_to_str[] = {
	/* 0. __NR_restart_syscall */ "__NR_restart_syscall",
	/* 1. __NR_exit */ "__NR_exit",
	/* 2. __NR_fork */ "__NR_fork",
	/* 3. __NR_read */ "__NR_read",
	/* 4. __NR_write */ "__NR_write",
	/* 5. __NR_open */ "__NR_open",
	/* 6. __NR_close */ "__NR_close",
	/* 7. __NR_waitpid */ "__NR_waitpid",
	/* 8. __NR_creat */ "__NR_creat",
	/* 9. __NR_link */ "__NR_link",
	/* 10. __NR_unlink */ "__NR_unlink",
	/* 11. __NR_execve */ "__NR_execve",
	/* 12. __NR_chdir */ "__NR_chdir",
	/* 13. __NR_time */ "__NR_time",
	/* 14. __NR_mknod */ "__NR_mknod",
	/* 15. __NR_chmod */ "__NR_chmod",
	/* 16. __NR_lchown */ "__NR_lchown",
	/* 17. __NR_break */ "__NR_break",
	/* 18. __NR_oldstat */ "__NR_oldstat",
	/* 19. __NR_lseek */ "__NR_lseek",
	/* 20. __NR_getpid */ "__NR_getpid",
	/* 21. __NR_mount */ "__NR_mount",
	/* 22. __NR_umount */ "__NR_umount",
	/* 23. __NR_setuid */ "__NR_setuid",
	/* 24. __NR_getuid */ "__NR_getuid",
	/* 25. __NR_stime */ "__NR_stime",
	/* 26. __NR_ptrace */ "__NR_ptrace",
	/* 27. __NR_alarm */ "__NR_alarm",
	/* 28. __NR_oldfstat */ "__NR_oldfstat",
	/* 29. __NR_pause */ "__NR_pause",
	/* 30. __NR_utime */ "__NR_utime",
	/* 31. __NR_stty */ "__NR_stty",
	/* 32. __NR_gtty */ "__NR_gtty",
	/* 33. __NR_access */ "__NR_access",
	/* 34. __NR_nice */ "__NR_nice",
	/* 35. __NR_ftime */ "__NR_ftime",
	/* 36. __NR_sync */ "__NR_sync",
	/* 37. __NR_kill */ "__NR_kill",
	/* 38. __NR_rename */ "__NR_rename",
	/* 39. __NR_mkdir */ "__NR_mkdir",
	/* 40. __NR_rmdir */ "__NR_rmdir",
	/* 41. __NR_dup */ "__NR_dup",
	/* 42. __NR_pipe */ "__NR_pipe",
	/* 43. __NR_times */ "__NR_times",
	/* 44. __NR_prof */ "__NR_prof",
	/* 45. __NR_brk */ "__NR_brk",
	/* 46. __NR_setgid */ "__NR_setgid",
	/* 47. __NR_getgid */ "__NR_getgid",
	/* 48. __NR_signal */ "__NR_signal",
	/* 49. __NR_geteuid */ "__NR_geteuid",
	/* 50. __NR_getegid */ "__NR_getegid",
	/* 51. __NR_acct */ "__NR_acct",
	/* 52. __NR_umount2 */ "__NR_umount2",
	/* 53. __NR_lock */ "__NR_lock",
	/* 54. __NR_ioctl */ "__NR_ioctl",
	/* 55. __NR_fcntl */ "__NR_fcntl",
	/* 56. __NR_mpx */ "__NR_mpx",
	/* 57. __NR_setpgid */ "__NR_setpgid",
	/* 58. __NR_ulimit */ "__NR_ulimit",
	/* 59. __NR_oldolduname */ "__NR_oldolduname",
	/* 60. __NR_umask */ "__NR_umask",
	/* 61. __NR_chroot */ "__NR_chroot",
	/* 62. __NR_ustat */ "__NR_ustat",
	/* 63. __NR_dup2 */ "__NR_dup2",
	/* 64. __NR_getppid */ "__NR_getppid",
	/* 65. __NR_getpgrp */ "__NR_getpgrp",
	/* 66. __NR_setsid */ "__NR_setsid",
	/* 67. __NR_sigaction */ "__NR_sigaction",
	/* 68. __NR_sgetmask */ "__NR_sgetmask",
	/* 69. __NR_ssetmask */ "__NR_ssetmask",
	/* 70. __NR_setreuid */ "__NR_setreuid",
	/* 71. __NR_setregid */ "__NR_setregid",
	/* 72. __NR_sigsuspend */ "__NR_sigsuspend",
	/* 73. __NR_sigpending */ "__NR_sigpending",
	/* 74. __NR_sethostname */ "__NR_sethostname",
	/* 75. __NR_setrlimit */ "__NR_setrlimit",
	/* 76. __NR_getrlimit */ "__NR_getrlimit",
	/* 77. __NR_getrusage */ "__NR_getrusage",
	/* 78. __NR_gettimeofday */ "__NR_gettimeofday",
	/* 79. __NR_settimeofday */ "__NR_settimeofday",
	/* 80. __NR_getgroups */ "__NR_getgroups",
	/* 81. __NR_setgroups */ "__NR_setgroups",
	/* 82. __NR_select */ "__NR_select",
	/* 83. __NR_symlink */ "__NR_symlink",
	/* 84. __NR_oldlstat */ "__NR_oldlstat",
	/* 85. __NR_readlink */ "__NR_readlink",
	/* 86. __NR_uselib */ "__NR_uselib",
	/* 87. __NR_swapon */ "__NR_swapon",
	/* 88. __NR_reboot */ "__NR_reboot",
	/* 89. __NR_readdir */ "__NR_readdir",
	/* 90. __NR_mmap */ "__NR_mmap",
	/* 91. __NR_munmap */ "__NR_munmap",
	/* 92. __NR_truncate */ "__NR_truncate",
	/* 93. __NR_ftruncate */ "__NR_ftruncate",
	/* 94. __NR_fchmod */ "__NR_fchmod",
	/* 95. __NR_fchown */ "__NR_fchown",
	/* 96. __NR_getpriority */ "__NR_getpriority",
	/* 97. __NR_setpriority */ "__NR_setpriority",
	/* 98. __NR_profil */ "__NR_profil",
	/* 99. __NR_statfs */ "__NR_statfs",
	/* 100. __NR_fstatfs */ "__NR_fstatfs",
	/* 101. __NR_ioperm */ "__NR_ioperm",
	/* 102. __NR_socketcall */ "__NR_socketcall",
	/* 103. __NR_syslog */ "__NR_syslog",
	/* 104. __NR_setitimer */ "__NR_setitimer",
	/* 105. __NR_getitimer */ "__NR_getitimer",
	/* 106. __NR_stat */ "__NR_stat",
	/* 107. __NR_lstat */ "__NR_lstat",
	/* 108. __NR_fstat */ "__NR_fstat",
	/* 109. __NR_olduname */ "__NR_olduname",
	/* 110. __NR_iopl */ "__NR_iopl",
	/* 111. __NR_vhangup */ "__NR_vhangup",
	/* 112. __NR_idle */ "__NR_idle",
	/* 113. __NR_vm86old */ "__NR_vm86old",
	/* 114. __NR_wait4 */ "__NR_wait4",
	/* 115. __NR_swapoff */ "__NR_swapoff",
	/* 116. __NR_sysinfo */ "__NR_sysinfo",
	/* 117. __NR_ipc */ "__NR_ipc",
	/* 118. __NR_fsync */ "__NR_fsync",
	/* 119. __NR_sigreturn */ "__NR_sigreturn",
	/* 120. __NR_clone */ "__NR_clone",
	/* 121. __NR_setdomainname */ "__NR_setdomainname",
	/* 122. __NR_uname */ "__NR_uname",
	/* 123. __NR_modify_ldt */ "__NR_modify_ldt",
	/* 124. __NR_adjtimex */ "__NR_adjtimex",
	/* 125. __NR_mprotect */ "__NR_mprotect",
	/* 126. __NR_sigprocmask */ "__NR_sigprocmask",
	/* 127. __NR_create_module */ "__NR_create_module",
	/* 128. __NR_init_module */ "__NR_init_module",
	/* 129. __NR_delete_module */ "__NR_delete_module",
	/* 130. __NR_get_kernel_syms */ "__NR_get_kernel_syms",
	/* 131. __NR_quotactl */ "__NR_quotactl",
	/* 132. __NR_getpgid */ "__NR_getpgid",
	/* 133. __NR_fchdir */ "__NR_fchdir",
	/* 134. __NR_bdflush */ "__NR_bdflush",
	/* 135. __NR_sysfs */ "__NR_sysfs",
	/* 136. __NR_personality */ "__NR_personality",
	/* 137. __NR_afs_syscall */ "__NR_afs_syscall",
	/* 138. __NR_setfsuid */ "__NR_setfsuid",
	/* 139. __NR_setfsgid */ "__NR_setfsgid",
	/* 140. __NR__llseek */ "__NR__llseek",
	/* 141. __NR_getdents */ "__NR_getdents",
	/* 142. __NR__newselect */ "__NR__newselect",
	/* 143. __NR_flock */ "__NR_flock",
	/* 144. __NR_msync */ "__NR_msync",
	/* 145. __NR_readv */ "__NR_readv",
	/* 146. __NR_writev */ "__NR_writev",
	/* 147. __NR_getsid */ "__NR_getsid",
	/* 148. __NR_fdatasync */ "__NR_fdatasync",
	/* 149. __NR__sysctl */ "__NR__sysctl",
	/* 150. __NR_mlock */ "__NR_mlock",
	/* 151. __NR_munlock */ "__NR_munlock",
	/* 152. __NR_mlockall */ "__NR_mlockall",
	/* 153. __NR_munlockall */ "__NR_munlockall",
	/* 154. __NR_sched_setparam */ "__NR_sched_setparam",
	/* 155. __NR_sched_getparam */ "__NR_sched_getparam",
	/* 156. __NR_sched_setscheduler */ "__NR_sched_setscheduler",
	/* 157. __NR_sched_getscheduler */ "__NR_sched_getscheduler",
	/* 158. __NR_sched_yield */ "__NR_sched_yield",
	/* 159. __NR_sched_get_priority_max */ "__NR_sched_get_priority_max",
	/* 160. __NR_sched_get_priority_min */ "__NR_sched_get_priority_min",
	/* 161. __NR_sched_rr_get_interval */ "__NR_sched_rr_get_interval",
	/* 162. __NR_nanosleep */ "__NR_nanosleep",
	/* 163. __NR_mremap */ "__NR_mremap",
	/* 164. __NR_setresuid */ "__NR_setresuid",
	/* 165. __NR_getresuid */ "__NR_getresuid",
	/* 166. __NR_vm86 */ "__NR_vm86",
	/* 167. __NR_query_module */ "__NR_query_module",
	/* 168. __NR_poll */ "__NR_poll",
	/* 169. __NR_nfsservctl */ "__NR_nfsservctl",
	/* 170. __NR_setresgid */ "__NR_setresgid",
	/* 171. __NR_getresgid */ "__NR_getresgid",
	/* 172. __NR_prctl */ "__NR_prctl",
	/* 173. __NR_rt_sigreturn */ "__NR_rt_sigreturn",
	/* 174. __NR_rt_sigaction */ "__NR_rt_sigaction",
	/* 175. __NR_rt_sigprocmask */ "__NR_rt_sigprocmask",
	/* 176. __NR_rt_sigpending */ "__NR_rt_sigpending",
	/* 177. __NR_rt_sigtimedwait */ "__NR_rt_sigtimedwait",
	/* 178. __NR_rt_sigqueueinfo */ "__NR_rt_sigqueueinfo",
	/* 179. __NR_rt_sigsuspend */ "__NR_rt_sigsuspend",
	/* 180. __NR_pread64 */ "__NR_pread64",
	/* 181. __NR_pwrite64 */ "__NR_pwrite64",
	/* 182. __NR_chown */ "__NR_chown",
	/* 183. __NR_getcwd */ "__NR_getcwd",
	/* 184. __NR_capget */ "__NR_capget",
	/* 185. __NR_capset */ "__NR_capset",
	/* 186. __NR_sigaltstack */ "__NR_sigaltstack",
	/* 187. __NR_sendfile */ "__NR_sendfile",
	/* 188. __NR_getpmsg */ "__NR_getpmsg",
	/* 189. __NR_putpmsg */ "__NR_putpmsg",
	/* 190. __NR_vfork */ "__NR_vfork",
	/* 191. __NR_ugetrlimit */ "__NR_ugetrlimit",
	/* 192. __NR_mmap2 */ "__NR_mmap2",
	/* 193. __NR_truncate64 */ "__NR_truncate64",
	/* 194. __NR_ftruncate64 */ "__NR_ftruncate64",
	/* 195. __NR_stat64 */ "__NR_stat64",
	/* 196. __NR_lstat64 */ "__NR_lstat64",
	/* 197. __NR_fstat64 */ "__NR_fstat64",
	/* 198. __NR_lchown32 */ "__NR_lchown32",
	/* 199. __NR_getuid32 */ "__NR_getuid32",
	/* 200. __NR_getgid32 */ "__NR_getgid32",
	/* 201. __NR_geteuid32 */ "__NR_geteuid32",
	/* 202. __NR_getegid32 */ "__NR_getegid32",
	/* 203. __NR_setreuid32 */ "__NR_setreuid32",
	/* 204. __NR_setregid32 */ "__NR_setregid32",
	/* 205. __NR_getgroups32 */ "__NR_getgroups32",
	/* 206. __NR_setgroups32 */ "__NR_setgroups32",
	/* 207. __NR_fchown32 */ "__NR_fchown32",
	/* 208. __NR_setresuid32 */ "__NR_setresuid32",
	/* 209. __NR_getresuid32 */ "__NR_getresuid32",
	/* 210. __NR_setresgid32 */ "__NR_setresgid32",
	/* 211. __NR_getresgid32 */ "__NR_getresgid32",
	/* 212. __NR_chown32 */ "__NR_chown32",
	/* 213. __NR_setuid32 */ "__NR_setuid32",
	/* 214. __NR_setgid32 */ "__NR_setgid32",
	/* 215. __NR_setfsuid32 */ "__NR_setfsuid32",
	/* 216. __NR_setfsgid32 */ "__NR_setfsgid32",
	/* 217. __NR_pivot_root */ "__NR_pivot_root",
	/* 218. __NR_mincore */ "__NR_mincore",
	/* 219. __NR_madvise1 */ "__NR_madvise1",
	/* 220. __NR_getdents64 */ "__NR_getdents64",
	/* 221. __NR_fcntl64 */ "__NR_fcntl64",
	/* 222. NOT USED */ "UNDEFINED",
	/* 223. NOT USED */ "UNDEFINED",
	/* 224. __NR_gettid */ "__NR_gettid",
	/* 225. __NR_readahead */ "__NR_readahead",
	/* 226. __NR_setxattr */ "__NR_setxattr",
	/* 227. __NR_lsetxattr */ "__NR_lsetxattr",
	/* 228. __NR_fsetxattr */ "__NR_fsetxattr",
	/* 229. __NR_getxattr */ "__NR_getxattr",
	/* 230. __NR_lgetxattr */ "__NR_lgetxattr",
	/* 231. __NR_fgetxattr */ "__NR_fgetxattr",
	/* 232. __NR_listxattr */ "__NR_listxattr",
	/* 233. __NR_llistxattr */ "__NR_llistxattr",
	/* 234. __NR_flistxattr */ "__NR_flistxattr",
	/* 235. __NR_removexattr */ "__NR_removexattr",
	/* 236. __NR_lremovexattr */ "__NR_lremovexattr",
	/* 237. __NR_fremovexattr */ "__NR_fremovexattr",
	/* 238. __NR_tkill */ "__NR_tkill",
	/* 239. __NR_sendfile64 */ "__NR_sendfile64",
	/* 240. __NR_futex */ "__NR_futex",
	/* 241. __NR_sched_setaffinity */ "__NR_sched_setaffinity",
	/* 242. __NR_sched_getaffinity */ "__NR_sched_getaffinity",
	/* 243. __NR_set_thread_area */ "__NR_set_thread_area",
	/* 244. __NR_get_thread_area */ "__NR_get_thread_area",
	/* 245. __NR_io_setup */ "__NR_io_setup",
	/* 246. __NR_io_destroy */ "__NR_io_destroy",
	/* 247. __NR_io_getevents */ "__NR_io_getevents",
	/* 248. __NR_io_submit */ "__NR_io_submit",
	/* 249. __NR_io_cancel */ "__NR_io_cancel",
	/* 250. __NR_fadvise64 */ "__NR_fadvise64",
	/* 251. NOT USED */ "UNDEFINED",
	/* 252. __NR_exit_group */ "__NR_exit_group",
	/* 253. __NR_lookup_dcookie */ "__NR_lookup_dcookie",
	/* 254. __NR_epoll_create */ "__NR_epoll_create",
	/* 255. __NR_epoll_ctl */ "__NR_epoll_ctl",
	/* 256. __NR_epoll_wait */ "__NR_epoll_wait",
	/* 257. __NR_remap_file_pages */ "__NR_remap_file_pages",
	/* 258. __NR_set_tid_address */ "__NR_set_tid_address",
	/* 259. __NR_timer_create */ "__NR_timer_create",
	/* 260. __NR_timer_settime */ "__NR_timer_settime",
	/* 261. __NR_timer_gettime */ "__NR_timer_gettime",
	/* 262. __NR_timer_getoverrun */ "__NR_timer_getoverrun",
	/* 263. __NR_timer_delete */ "__NR_timer_delete",
	/* 264. __NR_clock_settime */ "__NR_clock_settime",
	/* 265. __NR_clock_gettime */ "__NR_clock_gettime",
	/* 266. __NR_clock_getres */ "__NR_clock_getres",
	/* 267. __NR_clock_nanosleep */ "__NR_clock_nanosleep",
	/* 268. __NR_statfs64 */ "__NR_statfs64",
	/* 269. __NR_fstatfs64 */ "__NR_fstatfs64",
	/* 270. __NR_tgkill */ "__NR_tgkill",
	/* 271. __NR_utimes */ "__NR_utimes",
	/* 272. __NR_fadvise64_64 */ "__NR_fadvise64_64",
	/* 273. __NR_vserver */ "__NR_vserver",
	/* 274. __NR_mbind */ "__NR_mbind",
	/* 275. __NR_get_mempolicy */ "__NR_get_mempolicy",
	/* 276. __NR_set_mempolicy */ "__NR_set_mempolicy",
	/* 277. __NR_mq_open */ "__NR_mq_open",
	/* 278. __NR_mq_unlink */ "__NR_mq_unlink",
	/* 279. __NR_mq_timedsend */ "__NR_mq_timedsend",
	/* 280. __NR_mq_timedreceive */ "__NR_mq_timedreceive",
	/* 281. __NR_mq_notify */ "__NR_mq_notify",
	/* 282. __NR_mq_getsetattr */ "__NR_mq_getsetattr",
	/* 283. __NR_sys_kexec_load */ "__NR_sys_kexec_load",
	/* 284. __NR_waitid */ "__NR_waitid",
	/* 285. NOT USED */ "UNDEFINED",
	/* 286. __NR_add_key */ "__NR_add_key",
	/* 287. __NR_request_key */ "__NR_request_key",
	/* 288. __NR_keyctl */ "__NR_keyctl"
};

char * x86_64_to_str[] = {
	/* 0. __NR_read */ "__NR_read",
	/* 1. __NR_write */ "__NR_write",
	/* 2. __NR_open */ "__NR_open",
	/* 3. __NR_close */ "__NR_close",
	/* 4. __NR_stat */ "__NR_stat",
	/* 5. __NR_fstat */ "__NR_fstat",
	/* 6. __NR_lstat */ "__NR_lstat",
	/* 7. __NR_poll */ "__NR_poll",
	/* 8. __NR_lseek */ "__NR_lseek",
	/* 9. __NR_mmap */ "__NR_mmap",
	/* 10. __NR_mprotect */ "__NR_mprotect",
	/* 11. __NR_munmap */ "__NR_munmap",
	/* 12. __NR_brk */ "__NR_brk",
	/* 13. __NR_rt_sigaction */ "__NR_rt_sigaction",
	/* 14. __NR_rt_sigprocmask */ "__NR_rt_sigprocmask",
	/* 15. __NR_rt_sigreturn */ "__NR_rt_sigreturn",
	/* 16. __NR_ioctl */ "__NR_ioctl",
	/* 17. __NR_pread64 */ "__NR_pread64",
	/* 18. __NR_pwrite64 */ "__NR_pwrite64",
	/* 19. __NR_readv */ "__NR_readv",
	/* 20. __NR_writev */ "__NR_writev",
	/* 21. __NR_access */ "__NR_access",
	/* 22. __NR_pipe */ "__NR_pipe",
	/* 23. __NR_select */ "__NR_select",
	/* 24. __NR_sched_yield */ "__NR_sched_yield",
	/* 25. __NR_mremap */ "__NR_mremap",
	/* 26. __NR_msync */ "__NR_msync",
	/* 27. __NR_mincore */ "__NR_mincore",
	/* 28. __NR_madvise */ "__NR_madvise",
	/* 29. __NR_shmget */ "__NR_shmget",
	/* 30. __NR_shmat */ "__NR_shmat",
	/* 31. __NR_shmctl */ "__NR_shmctl",
	/* 32. __NR_dup */ "__NR_dup",
	/* 33. __NR_dup2 */ "__NR_dup2",
	/* 34. __NR_pause */ "__NR_pause",
	/* 35. __NR_nanosleep */ "__NR_nanosleep",
	/* 36. __NR_getitimer */ "__NR_getitimer",
	/* 37. __NR_alarm */ "__NR_alarm",
	/* 38. __NR_setitimer */ "__NR_setitimer",
	/* 39. __NR_getpid */ "__NR_getpid",
	/* 40. __NR_sendfile */ "__NR_sendfile",
	/* 41. __NR_socket */ "__NR_socket",
	/* 42. __NR_connect */ "__NR_connect",
	/* 43. __NR_accept */ "__NR_accept",
	/* 44. __NR_sendto */ "__NR_sendto",
	/* 45. __NR_recvfrom */ "__NR_recvfrom",
	/* 46. __NR_sendmsg */ "__NR_sendmsg",
	/* 47. __NR_recvmsg */ "__NR_recvmsg",
	/* 48. __NR_shutdown */ "__NR_shutdown",
	/* 49. __NR_bind */ "__NR_bind",
	/* 50. __NR_listen */ "__NR_listen",
	/* 51. __NR_getsockname */ "__NR_getsockname",
	/* 52. __NR_getpeername */ "__NR_getpeername",
	/* 53. __NR_socketpair */ "__NR_socketpair",
	/* 54. __NR_setsockopt */ "__NR_setsockopt",
	/* 55. __NR_getsockopt */ "__NR_getsockopt",
	/* 56. __NR_clone */ "__NR_clone",
	/* 57. __NR_fork */ "__NR_fork",
	/* 58. __NR_vfork */ "__NR_vfork",
	/* 59. __NR_execve */ "__NR_execve",
	/* 60. __NR_exit */ "__NR_exit",
	/* 61. __NR_wait4 */ "__NR_wait4",
	/* 62. __NR_kill */ "__NR_kill",
	/* 63. __NR_uname */ "__NR_uname",
	/* 64. __NR_semget */ "__NR_semget",
	/* 65. __NR_semop */ "__NR_semop",
	/* 66. __NR_semctl */ "__NR_semctl",
	/* 67. __NR_shmdt */ "__NR_shmdt",
	/* 68. __NR_msgget */ "__NR_msgget",
	/* 69. __NR_msgsnd */ "__NR_msgsnd",
	/* 70. __NR_msgrcv */ "__NR_msgrcv",
	/* 71. __NR_msgctl */ "__NR_msgctl",
	/* 72. __NR_fcntl */ "__NR_fcntl",
	/* 73. __NR_flock */ "__NR_flock",
	/* 74. __NR_fsync */ "__NR_fsync",
	/* 75. __NR_fdatasync */ "__NR_fdatasync",
	/* 76. __NR_truncate */ "__NR_truncate",
	/* 77. __NR_ftruncate */ "__NR_ftruncate",
	/* 78. __NR_getdents */ "__NR_getdents",
	/* 79. __NR_getcwd */ "__NR_getcwd",
	/* 80. __NR_chdir */ "__NR_chdir",
	/* 81. __NR_fchdir */ "__NR_fchdir",
	/* 82. __NR_rename */ "__NR_rename",
	/* 83. __NR_mkdir */ "__NR_mkdir",
	/* 84. __NR_rmdir */ "__NR_rmdir",
	/* 85. __NR_creat */ "__NR_creat",
	/* 86. __NR_link */ "__NR_link",
	/* 87. __NR_unlink */ "__NR_unlink",
	/* 88. __NR_symlink */ "__NR_symlink",
	/* 89. __NR_readlink */ "__NR_readlink",
	/* 90. __NR_chmod */ "__NR_chmod",
	/* 91. __NR_fchmod */ "__NR_fchmod",
	/* 92. __NR_chown */ "__NR_chown",
	/* 93. __NR_fchown */ "__NR_fchown",
	/* 94. __NR_lchown */ "__NR_lchown",
	/* 95. __NR_umask */ "__NR_umask",
	/* 96. __NR_gettimeofday */ "__NR_gettimeofday",
	/* 97. __NR_getrlimit */ "__NR_getrlimit",
	/* 98. __NR_getrusage */ "__NR_getrusage",
	/* 99. __NR_sysinfo */ "__NR_sysinfo",
	/* 100. __NR_times */ "__NR_times",
	/* 101. __NR_ptrace */ "__NR_ptrace",
	/* 102. __NR_getuid */ "__NR_getuid",
	/* 103. __NR_syslog */ "__NR_syslog",
	/* 104. __NR_getgid */ "__NR_getgid",
	/* 105. __NR_setuid */ "__NR_setuid",
	/* 106. __NR_setgid */ "__NR_setgid",
	/* 107. __NR_geteuid */ "__NR_geteuid",
	/* 108. __NR_getegid */ "__NR_getegid",
	/* 109. __NR_setpgid */ "__NR_setpgid",
	/* 110. __NR_getppid */ "__NR_getppid",
	/* 111. __NR_getpgrp */ "__NR_getpgrp",
	/* 112. __NR_setsid */ "__NR_setsid",
	/* 113. __NR_setreuid */ "__NR_setreuid",
	/* 114. __NR_setregid */ "__NR_setregid",
	/* 115. __NR_getgroups */ "__NR_getgroups",
	/* 116. __NR_setgroups */ "__NR_setgroups",
	/* 117. __NR_setresuid */ "__NR_setresuid",
	/* 118. __NR_getresuid */ "__NR_getresuid",
	/* 119. __NR_setresgid */ "__NR_setresgid",
	/* 120. __NR_getresgid */ "__NR_getresgid",
	/* 121. __NR_getpgid */ "__NR_getpgid",
	/* 122. __NR_setfsuid */ "__NR_setfsuid",
	/* 123. __NR_setfsgid */ "__NR_setfsgid",
	/* 124. __NR_getsid */ "__NR_getsid",
	/* 125. __NR_capget */ "__NR_capget",
	/* 126. __NR_capset */ "__NR_capset",
	/* 127. __NR_rt_sigpending */ "__NR_rt_sigpending",
	/* 128. __NR_rt_sigtimedwait */ "__NR_rt_sigtimedwait",
	/* 129. __NR_rt_sigqueueinfo */ "__NR_rt_sigqueueinfo",
	/* 130. __NR_rt_sigsuspend */ "__NR_rt_sigsuspend",
	/* 131. __NR_sigaltstack */ "__NR_sigaltstack",
	/* 132. __NR_utime */ "__NR_utime",
	/* 133. __NR_mknod */ "__NR_mknod",
	/* 134. __NR_uselib */ "__NR_uselib",
	/* 135. __NR_personality */ "__NR_personality",
	/* 136. __NR_ustat */ "__NR_ustat",
	/* 137. __NR_statfs */ "__NR_statfs",
	/* 138. __NR_fstatfs */ "__NR_fstatfs",
	/* 139. __NR_sysfs */ "__NR_sysfs",
	/* 140. __NR_getpriority */ "__NR_getpriority",
	/* 141. __NR_setpriority */ "__NR_setpriority",
	/* 142. __NR_sched_setparam */ "__NR_sched_setparam",
	/* 143. __NR_sched_getparam */ "__NR_sched_getparam",
	/* 144. __NR_sched_setscheduler */ "__NR_sched_setscheduler",
	/* 145. __NR_sched_getscheduler */ "__NR_sched_getscheduler",
	/* 146. __NR_sched_get_priority_max */ "__NR_sched_get_priority_max",
	/* 147. __NR_sched_get_priority_min */ "__NR_sched_get_priority_min",
	/* 148. __NR_sched_rr_get_interval */ "__NR_sched_rr_get_interval",
	/* 149. __NR_mlock */ "__NR_mlock",
	/* 150. __NR_munlock */ "__NR_munlock",
	/* 151. __NR_mlockall */ "__NR_mlockall",
	/* 152. __NR_munlockall */ "__NR_munlockall",
	/* 153. __NR_vhangup */ "__NR_vhangup",
	/* 154. __NR_modify_ldt */ "__NR_modify_ldt",
	/* 155. __NR_pivot_root */ "__NR_pivot_root",
	/* 156. __NR__sysctl */ "__NR__sysctl",
	/* 157. __NR_prctl */ "__NR_prctl",
	/* 158. __NR_arch_prctl */ "__NR_arch_prctl",
	/* 159. __NR_adjtimex */ "__NR_adjtimex",
	/* 160. __NR_setrlimit */ "__NR_setrlimit",
	/* 161. __NR_chroot */ "__NR_chroot",
	/* 162. __NR_sync */ "__NR_sync",
	/* 163. __NR_acct */ "__NR_acct",
	/* 164. __NR_settimeofday */ "__NR_settimeofday",
	/* 165. __NR_mount */ "__NR_mount",
	/* 166. __NR_umount2 */ "__NR_umount2",
	/* 167. __NR_swapon */ "__NR_swapon",
	/* 168. __NR_swapoff */ "__NR_swapoff",
	/* 169. __NR_reboot */ "__NR_reboot",
	/* 170. __NR_sethostname */ "__NR_sethostname",
	/* 171. __NR_setdomainname */ "__NR_setdomainname",
	/* 172. __NR_iopl */ "__NR_iopl",
	/* 173. __NR_ioperm */ "__NR_ioperm",
	/* 174. __NR_create_module */ "__NR_create_module",
	/* 175. __NR_init_module */ "__NR_init_module",
	/* 176. __NR_delete_module */ "__NR_delete_module",
	/* 177. __NR_get_kernel_syms */ "__NR_get_kernel_syms",
	/* 178. __NR_query_module */ "__NR_query_module",
	/* 179. __NR_quotactl */ "__NR_quotactl",
	/* 180. __NR_nfsservctl */ "__NR_nfsservctl",
	/* 181. __NR_getpmsg */ "__NR_getpmsg",
	/* 182. __NR_putpmsg */ "__NR_putpmsg",
	/* 183. __NR_afs_syscall */ "__NR_afs_syscall",
	/* 184. __NR_tuxcall */ "__NR_tuxcall",
	/* 185. __NR_security */ "__NR_security",
	/* 186. __NR_gettid */ "__NR_gettid",
	/* 187. __NR_readahead */ "__NR_readahead",
	/* 188. __NR_setxattr */ "__NR_setxattr",
	/* 189. __NR_lsetxattr */ "__NR_lsetxattr",
	/* 190. __NR_fsetxattr */ "__NR_fsetxattr",
	/* 191. __NR_getxattr */ "__NR_getxattr",
	/* 192. __NR_lgetxattr */ "__NR_lgetxattr",
	/* 193. __NR_fgetxattr */ "__NR_fgetxattr",
	/* 194. __NR_listxattr */ "__NR_listxattr",
	/* 195. __NR_llistxattr */ "__NR_llistxattr",
	/* 196. __NR_flistxattr */ "__NR_flistxattr",
	/* 197. __NR_removexattr */ "__NR_removexattr",
	/* 198. __NR_lremovexattr */ "__NR_lremovexattr",
	/* 199. __NR_fremovexattr */ "__NR_fremovexattr",
	/* 200. __NR_tkill */ "__NR_tkill",
	/* 201. __NR_time */ "__NR_time",
	/* 202. __NR_futex */ "__NR_futex",
	/* 203. __NR_sched_setaffinity */ "__NR_sched_setaffinity",
	/* 204. __NR_sched_getaffinity */ "__NR_sched_getaffinity",
	/* 205. __NR_set_thread_area */ "__NR_set_thread_area",
	/* 206. __NR_io_setup */ "__NR_io_setup",
	/* 207. __NR_io_destroy */ "__NR_io_destroy",
	/* 208. __NR_io_getevents */ "__NR_io_getevents",
	/* 209. __NR_io_submit */ "__NR_io_submit",
	/* 210. __NR_io_cancel */ "__NR_io_cancel",
	/* 211. __NR_get_thread_area */ "__NR_get_thread_area",
	/* 212. __NR_lookup_dcookie */ "__NR_lookup_dcookie",
	/* 213. __NR_epoll_create */ "__NR_epoll_create",
	/* 214. __NR_epoll_ctl_old */ "__NR_epoll_ctl_old",
	/* 215. __NR_epoll_wait_old */ "__NR_epoll_wait_old",
	/* 216. __NR_remap_file_pages */ "__NR_remap_file_pages",
	/* 217. __NR_getdents64 */ "__NR_getdents64",
	/* 218. __NR_set_tid_address */ "__NR_set_tid_address",
	/* 219. __NR_restart_syscall */ "__NR_restart_syscall",
	/* 220. __NR_semtimedop */ "__NR_semtimedop",
	/* 221. __NR_fadvise64 */ "__NR_fadvise64",
	/* 222. __NR_timer_create */ "__NR_timer_create",
	/* 223. __NR_timer_settime */ "__NR_timer_settime",
	/* 224. __NR_timer_gettime */ "__NR_timer_gettime",
	/* 225. __NR_timer_getoverrun */ "__NR_timer_getoverrun",
	/* 226. __NR_timer_delete */ "__NR_timer_delete",
	/* 227. __NR_clock_settime */ "__NR_clock_settime",
	/* 228. __NR_clock_gettime */ "__NR_clock_gettime",
	/* 229. __NR_clock_getres */ "__NR_clock_getres",
	/* 230. __NR_clock_nanosleep */ "__NR_clock_nanosleep",
	/* 231. __NR_exit_group */ "__NR_exit_group",
	/* 232. __NR_epoll_wait */ "__NR_epoll_wait",
	/* 233. __NR_epoll_ctl */ "__NR_epoll_ctl",
	/* 234. __NR_tgkill */ "__NR_tgkill",
	/* 235. __NR_utimes */ "__NR_utimes",
	/* 236. __NR_vserver */ "__NR_vserver",
	/* 237. __NR_mbind */ "__NR_mbind",
	/* 238. __NR_set_mempolicy */ "__NR_set_mempolicy",
	/* 239. __NR_get_mempolicy */ "__NR_get_mempolicy",
	/* 240. __NR_mq_open */ "__NR_mq_open",
	/* 241. __NR_mq_unlink */ "__NR_mq_unlink",
	/* 242. __NR_mq_timedsend */ "__NR_mq_timedsend",
	/* 243. __NR_mq_timedreceive */ "__NR_mq_timedreceive",
	/* 244. __NR_mq_notify */ "__NR_mq_notify",
	/* 245. __NR_mq_getsetattr */ "__NR_mq_getsetattr",
	/* 246. __NR_kexec_load */ "__NR_kexec_load",
	/* 247. __NR_waitid */ "__NR_waitid",
	/* 248. __NR_add_key */ "__NR_add_key",
	/* 249. __NR_request_key */ "__NR_request_key",
	/* 250. __NR_keyctl */ "__NR_keyctl"
};

char * ppc_to_str[] = {
	/* 0. __NR_restart_syscall */ "__NR_restart_syscall",
	/* 1. __NR_exit */ "__NR_exit",
	/* 2. __NR_fork */ "__NR_fork",
	/* 3. __NR_read */ "__NR_read",
	/* 4. __NR_write */ "__NR_write",
	/* 5. __NR_open */ "__NR_open",
	/* 6. __NR_close */ "__NR_close",
	/* 7. __NR_waitpid */ "__NR_waitpid",
	/* 8. __NR_creat */ "__NR_creat",
	/* 9. __NR_link */ "__NR_link",
	/* 10. __NR_unlink */ "__NR_unlink",
	/* 11. __NR_execve */ "__NR_execve",
	/* 12. __NR_chdir */ "__NR_chdir",
	/* 13. __NR_time */ "__NR_time",
	/* 14. __NR_mknod */ "__NR_mknod",
	/* 15. __NR_chmod */ "__NR_chmod",
	/* 16. __NR_lchown */ "__NR_lchown",
	/* 17. __NR_break */ "__NR_break",
	/* 18. __NR_oldstat */ "__NR_oldstat",
	/* 19. __NR_lseek */ "__NR_lseek",
	/* 20. __NR_getpid */ "__NR_getpid",
	/* 21. __NR_mount */ "__NR_mount",
	/* 22. __NR_umount */ "__NR_umount",
	/* 23. __NR_setuid */ "__NR_setuid",
	/* 24. __NR_getuid */ "__NR_getuid",
	/* 25. __NR_stime */ "__NR_stime",
	/* 26. __NR_ptrace */ "__NR_ptrace",
	/* 27. __NR_alarm */ "__NR_alarm",
	/* 28. __NR_oldfstat */ "__NR_oldfstat",
	/* 29. __NR_pause */ "__NR_pause",
	/* 30. __NR_utime */ "__NR_utime",
	/* 31. __NR_stty */ "__NR_stty",
	/* 32. __NR_gtty */ "__NR_gtty",
	/* 33. __NR_access */ "__NR_access",
	/* 34. __NR_nice */ "__NR_nice",
	/* 35. __NR_ftime */ "__NR_ftime",
	/* 36. __NR_sync */ "__NR_sync",
	/* 37. __NR_kill */ "__NR_kill",
	/* 38. __NR_rename */ "__NR_rename",
	/* 39. __NR_mkdir */ "__NR_mkdir",
	/* 40. __NR_rmdir */ "__NR_rmdir",
	/* 41. __NR_dup */ "__NR_dup",
	/* 42. __NR_pipe */ "__NR_pipe",
	/* 43. __NR_times */ "__NR_times",
	/* 44. __NR_prof */ "__NR_prof",
	/* 45. __NR_brk */ "__NR_brk",
	/* 46. __NR_setgid */ "__NR_setgid",
	/* 47. __NR_getgid */ "__NR_getgid",
	/* 48. __NR_signal */ "__NR_signal",
	/* 49. __NR_geteuid */ "__NR_geteuid",
	/* 50. __NR_getegid */ "__NR_getegid",
	/* 51. __NR_acct */ "__NR_acct",
	/* 52. __NR_umount2 */ "__NR_umount2",
	/* 53. __NR_lock */ "__NR_lock",
	/* 54. __NR_ioctl */ "__NR_ioctl",
	/* 55. __NR_fcntl */ "__NR_fcntl",
	/* 56. __NR_mpx */ "__NR_mpx",
	/* 57. __NR_setpgid */ "__NR_setpgid",
	/* 58. __NR_ulimit */ "__NR_ulimit",
	/* 59. __NR_oldolduname */ "__NR_oldolduname",
	/* 60. __NR_umask */ "__NR_umask",
	/* 61. __NR_chroot */ "__NR_chroot",
	/* 62. __NR_ustat */ "__NR_ustat",
	/* 63. __NR_dup2 */ "__NR_dup2",
	/* 64. __NR_getppid */ "__NR_getppid",
	/* 65. __NR_getpgrp */ "__NR_getpgrp",
	/* 66. __NR_setsid */ "__NR_setsid",
	/* 67. __NR_sigaction */ "__NR_sigaction",
	/* 68. __NR_sgetmask */ "__NR_sgetmask",
	/* 69. __NR_ssetmask */ "__NR_ssetmask",
	/* 70. __NR_setreuid */ "__NR_setreuid",
	/* 71. __NR_setregid */ "__NR_setregid",
	/* 72. __NR_sigsuspend */ "__NR_sigsuspend",
	/* 73. __NR_sigpending */ "__NR_sigpending",
	/* 74. __NR_sethostname */ "__NR_sethostname",
	/* 75. __NR_setrlimit */ "__NR_setrlimit",
	/* 76. __NR_getrlimit */ "__NR_getrlimit",
	/* 77. __NR_getrusage */ "__NR_getrusage",
	/* 78. __NR_gettimeofday */ "__NR_gettimeofday",
	/* 79. __NR_settimeofday */ "__NR_settimeofday",
	/* 80. __NR_getgroups */ "__NR_getgroups",
	/* 81. __NR_setgroups */ "__NR_setgroups",
	/* 82. __NR_select */ "__NR_select",
	/* 83. __NR_symlink */ "__NR_symlink",
	/* 84. __NR_oldlstat */ "__NR_oldlstat",
	/* 85. __NR_readlink */ "__NR_readlink",
	/* 86. __NR_uselib */ "__NR_uselib",
	/* 87. __NR_swapon */ "__NR_swapon",
	/* 88. __NR_reboot */ "__NR_reboot",
	/* 89. __NR_readdir */ "__NR_readdir",
	/* 90. __NR_mmap */ "__NR_mmap",
	/* 91. __NR_munmap */ "__NR_munmap",
	/* 92. __NR_truncate */ "__NR_truncate",
	/* 93. __NR_ftruncate */ "__NR_ftruncate",
	/* 94. __NR_fchmod */ "__NR_fchmod",
	/* 95. __NR_fchown */ "__NR_fchown",
	/* 96. __NR_getpriority */ "__NR_getpriority",
	/* 97. __NR_setpriority */ "__NR_setpriority",
	/* 98. __NR_profil */ "__NR_profil",
	/* 99. __NR_statfs */ "__NR_statfs",
	/* 100. __NR_fstatfs */ "__NR_fstatfs",
	/* 101. __NR_ioperm */ "__NR_ioperm",
	/* 102. __NR_socketcall */ "__NR_socketcall",
	/* 103. __NR_syslog */ "__NR_syslog",
	/* 104. __NR_setitimer */ "__NR_setitimer",
	/* 105. __NR_getitimer */ "__NR_getitimer",
	/* 106. __NR_stat */ "__NR_stat",
	/* 107. __NR_lstat */ "__NR_lstat",
	/* 108. __NR_fstat */ "__NR_fstat",
	/* 109. __NR_olduname */ "__NR_olduname",
	/* 110. __NR_iopl */ "__NR_iopl",
	/* 111. __NR_vhangup */ "__NR_vhangup",
	/* 112. __NR_idle */ "__NR_idle",
	/* 113. __NR_vm86 */ "__NR_vm86",
	/* 114. __NR_wait4 */ "__NR_wait4",
	/* 115. __NR_swapoff */ "__NR_swapoff",
	/* 116. __NR_sysinfo */ "__NR_sysinfo",
	/* 117. __NR_ipc */ "__NR_ipc",
	/* 118. __NR_fsync */ "__NR_fsync",
	/* 119. __NR_sigreturn */ "__NR_sigreturn",
	/* 120. __NR_clone */ "__NR_clone",
	/* 121. __NR_setdomainname */ "__NR_setdomainname",
	/* 122. __NR_uname */ "__NR_uname",
	/* 123. __NR_modify_ldt */ "__NR_modify_ldt",
	/* 124. __NR_adjtimex */ "__NR_adjtimex",
	/* 125. __NR_mprotect */ "__NR_mprotect",
	/* 126. __NR_sigprocmask */ "__NR_sigprocmask",
	/* 127. __NR_create_module */ "__NR_create_module",
	/* 128. __NR_init_module */ "__NR_init_module",
	/* 129. __NR_delete_module */ "__NR_delete_module",
	/* 130. __NR_get_kernel_syms */ "__NR_get_kernel_syms",
	/* 131. __NR_quotactl */ "__NR_quotactl",
	/* 132. __NR_getpgid */ "__NR_getpgid",
	/* 133. __NR_fchdir */ "__NR_fchdir",
	/* 134. __NR_bdflush */ "__NR_bdflush",
	/* 135. __NR_sysfs */ "__NR_sysfs",
	/* 136. __NR_personality */ "__NR_personality",
	/* 137. __NR_afs_syscall */ "__NR_afs_syscall",
	/* 138. __NR_setfsuid */ "__NR_setfsuid",
	/* 139. __NR_setfsgid */ "__NR_setfsgid",
	/* 140. __NR__llseek */ "__NR__llseek",
	/* 141. __NR_getdents */ "__NR_getdents",
	/* 142. __NR__newselect */ "__NR__newselect",
	/* 143. __NR_flock */ "__NR_flock",
	/* 144. __NR_msync */ "__NR_msync",
	/* 145. __NR_readv */ "__NR_readv",
	/* 146. __NR_writev */ "__NR_writev",
	/* 147. __NR_getsid */ "__NR_getsid",
	/* 148. __NR_fdatasync */ "__NR_fdatasync",
	/* 149. __NR__sysctl */ "__NR__sysctl",
	/* 150. __NR_mlock */ "__NR_mlock",
	/* 151. __NR_munlock */ "__NR_munlock",
	/* 152. __NR_mlockall */ "__NR_mlockall",
	/* 153. __NR_munlockall */ "__NR_munlockall",
	/* 154. __NR_sched_setparam */ "__NR_sched_setparam",
	/* 155. __NR_sched_getparam */ "__NR_sched_getparam",
	/* 156. __NR_sched_setscheduler */ "__NR_sched_setscheduler",
	/* 157. __NR_sched_getscheduler */ "__NR_sched_getscheduler",
	/* 158. __NR_sched_yield */ "__NR_sched_yield",
	/* 159. __NR_sched_get_priority_max */ "__NR_sched_get_priority_max",
	/* 160. __NR_sched_get_priority_min */ "__NR_sched_get_priority_min",
	/* 161. __NR_sched_rr_get_interval */ "__NR_sched_rr_get_interval",
	/* 162. __NR_nanosleep */ "__NR_nanosleep",
	/* 163. __NR_mremap */ "__NR_mremap",
	/* 164. __NR_setresuid */ "__NR_setresuid",
	/* 165. __NR_getresuid */ "__NR_getresuid",
	/* 166. __NR_query_module */ "__NR_query_module",
	/* 167. __NR_poll */ "__NR_poll",
	/* 168. __NR_nfsservctl */ "__NR_nfsservctl",
	/* 169. __NR_setresgid */ "__NR_setresgid",
	/* 170. __NR_getresgid */ "__NR_getresgid",
	/* 171. __NR_prctl */ "__NR_prctl",
	/* 172. __NR_rt_sigreturn */ "__NR_rt_sigreturn",
	/* 173. __NR_rt_sigaction */ "__NR_rt_sigaction",
	/* 174. __NR_rt_sigprocmask */ "__NR_rt_sigprocmask",
	/* 175. __NR_rt_sigpending */ "__NR_rt_sigpending",
	/* 176. __NR_rt_sigtimedwait */ "__NR_rt_sigtimedwait",
	/* 177. __NR_rt_sigqueueinfo */ "__NR_rt_sigqueueinfo",
	/* 178. __NR_rt_sigsuspend */ "__NR_rt_sigsuspend",
	/* 179. __NR_pread64 */ "__NR_pread64",
	/* 180. __NR_pwrite64 */ "__NR_pwrite64",
	/* 181. __NR_chown */ "__NR_chown",
	/* 182. __NR_getcwd */ "__NR_getcwd",
	/* 183. __NR_capget */ "__NR_capget",
	/* 184. __NR_capset */ "__NR_capset",
	/* 185. __NR_sigaltstack */ "__NR_sigaltstack",
	/* 186. __NR_sendfile */ "__NR_sendfile",
	/* 187. __NR_getpmsg */ "__NR_getpmsg",
	/* 188. __NR_putpmsg */ "__NR_putpmsg",
	/* 189. __NR_vfork */ "__NR_vfork",
	/* 190. __NR_ugetrlimit */ "__NR_ugetrlimit",
	/* 191. __NR_readahead */ "__NR_readahead",
	/* 192. __NR_mmap2 */ "__NR_mmap2",
	/* 193. __NR_truncate64 */ "__NR_truncate64",
	/* 194. __NR_ftruncate64 */ "__NR_ftruncate64",
	/* 195. __NR_stat64 */ "__NR_stat64",
	/* 196. __NR_lstat64 */ "__NR_lstat64",
	/* 197. __NR_fstat64 */ "__NR_fstat64",
	/* 198. __NR_pciconfig_read */ "__NR_pciconfig_read",
	/* 199. __NR_pciconfig_write */ "__NR_pciconfig_write",
	/* 200. __NR_pciconfig_iobase */ "__NR_pciconfig_iobase",
	/* 201. __NR_multiplexer */ "__NR_multiplexer",
	/* 202. __NR_getdents64 */ "__NR_getdents64",
	/* 203. __NR_pivot_root */ "__NR_pivot_root",
	/* 204. __NR_fcntl64 */ "__NR_fcntl64",
	/* 205. __NR_madvise */ "__NR_madvise",
	/* 206. __NR_mincore */ "__NR_mincore",
	/* 207. __NR_gettid */ "__NR_gettid",
	/* 208. __NR_tkill */ "__NR_tkill",
	/* 209. __NR_setxattr */ "__NR_setxattr",
	/* 210. __NR_lsetxattr */ "__NR_lsetxattr",
	/* 211. __NR_fsetxattr */ "__NR_fsetxattr",
	/* 212. __NR_getxattr */ "__NR_getxattr",
	/* 213. __NR_lgetxattr */ "__NR_lgetxattr",
	/* 214. __NR_fgetxattr */ "__NR_fgetxattr",
	/* 215. __NR_listxattr */ "__NR_listxattr",
	/* 216. __NR_llistxattr */ "__NR_llistxattr",
	/* 217. __NR_flistxattr */ "__NR_flistxattr",
	/* 218. __NR_removexattr */ "__NR_removexattr",
	/* 219. __NR_lremovexattr */ "__NR_lremovexattr",
	/* 220. __NR_fremovexattr */ "__NR_fremovexattr",
	/* 221. __NR_futex */ "__NR_futex",
	/* 222. __NR_sched_setaffinity */ "__NR_sched_setaffinity",
	/* 223. __NR_sched_getaffinity */ "__NR_sched_getaffinity",
	/* 224. NOT USED */ "UNDEFINED",
	/* 225. __NR_tuxcall */ "__NR_tuxcall",
	/* 226. __NR_sendfile64 */ "__NR_sendfile64",
	/* 227. __NR_io_setup */ "__NR_io_setup",
	/* 228. __NR_io_destroy */ "__NR_io_destroy",
	/* 229. __NR_io_getevents */ "__NR_io_getevents",
	/* 230. __NR_io_submit */ "__NR_io_submit",
	/* 231. __NR_io_cancel */ "__NR_io_cancel",
	/* 232. __NR_set_tid_address */ "__NR_set_tid_address",
	/* 233. __NR_fadvise64 */ "__NR_fadvise64",
	/* 234. __NR_exit_group */ "__NR_exit_group",
	/* 235. __NR_lookup_dcookie */ "__NR_lookup_dcookie",
	/* 236. __NR_epoll_create */ "__NR_epoll_create",
	/* 237. __NR_epoll_ctl */ "__NR_epoll_ctl",
	/* 238. __NR_epoll_wait */ "__NR_epoll_wait",
	/* 239. __NR_remap_file_pages */ "__NR_remap_file_pages",
	/* 240. __NR_timer_create */ "__NR_timer_create",
	/* 241. __NR_timer_settime */ "__NR_timer_settime",
	/* 242. __NR_timer_gettime */ "__NR_timer_gettime",
	/* 243. __NR_timer_getoverrun */ "__NR_timer_getoverrun",
	/* 244. __NR_timer_delete */ "__NR_timer_delete",
	/* 245. __NR_clock_settime */ "__NR_clock_settime",
	/* 246. __NR_clock_gettime */ "__NR_clock_gettime",
	/* 247. __NR_clock_getres */ "__NR_clock_getres",
	/* 248. __NR_clock_nanosleep */ "__NR_clock_nanosleep",
	/* 249. __NR_swapcontext */ "__NR_swapcontext",
	/* 250. __NR_tgkill */ "__NR_tgkill",
	/* 251. __NR_utimes */ "__NR_utimes",
	/* 252. __NR_statfs64 */ "__NR_statfs64",
	/* 253. __NR_fstatfs64 */ "__NR_fstatfs64",
	/* 254. __NR_fadvise64_64 */ "__NR_fadvise64_64"
};


/* SYS_ values are equal in each architecture,
 * so a single table is sufficent. */
char *sys_to_str[] = {
	/* 0. Isn't used */ "__NR_socketcall, UNDEFINED SYS_*",
	/* 1. SYS_SOCKET */ "__NR_socketcall, SYS_SOCKET",
	/* 2. SYS_BIND	*/ "__NR_socketcall, SYS_BIND",
	/* 3. SYS_CONNECT */ "__NR_socketcall, SYS_CONNECT",
	/* 4. SYS_LISTEN */ "__NR_socketcall, SYS_LISTEN",
	/* 5. SYS_ACCEPT */ "__NR_socketcall, SYS_ACCEPT",
	/* 6. SYS_GETSOCKNAME */ "__NR_socketcall, SYS_GETSOCKNAME",
	/* 7. SYS_GETPEERNAME */ "__NR_socketcall, SYS_GETPEERNAME",
	/* 8. SYS_SOCKETPAIR */ "__NR_socketcall, SYS_SOCKETPAIR",
	/* 9. SYS_SEND */ "__NR_socketcall, SYS_SEND",
	/* 10. SYS_RECV */ "__NR_socketcall, SYS_RECV",
	/* 11. SYS_SENDTO */ "__NR_socketcall, SYS_SENDTO",
	/* 12. SYS_RECVFROM */ "__NR_socketcall, SYS_RECVFROM",
	/* 13. SYS_SHUTDOWN */ "__NR_socketcall, SYS_SHUTDOWN",
	/* 14. SYS_SETSOCKOPT */ "__NR_socketcall, SYS_SETSOCKOPT",
	/* 15. SYS_GETSOCKOPT */ "__NR_socketcall, SYS_GETSOCKOPT",
	/* 16. SYS_SENDMSG */ "__NR_socketcall, SYS_SENDMSG",
	/* 17 SYS_RECVMSG */ "__NR_socketcall, SYS_RECVMSG"
};

/*########################################################################*/
/*##                                                                    ##*/
/*##  LOCAL FUNCTIONS                                                   ##*/
/*##                                                                    ##*/
/*########################################################################*/
static enum rsc_constant get_rsc(int32_t nr_const, int32_t sys, enum rsc_constant table[], int table_size) {
  enum rsc_constant res;

  if((nr_const < 0) || (nr_const >= table_size ))
    return __RSC_ERROR;

  res = table[nr_const];
  /* If "nr_const" is __NR_socketcall, then I have to get the right
   * __RSC_* constant using the SYS_* one. */
  if(res == __RSC_socketcall) {
    if( (sys != NO_VALUE) && (sys > 0) && (sys < SYS_TO_RSC_SIZE) )
      res = sys_to_rsc[sys];
    else
      /* I need the SYS_ value (and I need that is correct) if __NR_ is __NR_socketcall! */
      res = __RSC_ERROR;
  }

  return res;
}

static struct nr_and_sys *get_nr(enum rsc_constant rsc_const, struct nr_and_sys table[]) {
  struct nr_and_sys *res;
  if((rsc_const < __RSC_FIRST) || (rsc_const > __RSC_LAST))
    return NULL;

  res = &table[rsc_const];
  /* If the resulting structure is empty (both fields defined as NO_VALUE)
   * I return NUUL */
  if( (res->nr == NO_VALUE) && (res->sys == NO_VALUE) )
    res = NULL;
  return res;
}

static char *get_str(int32_t nr_const, int32_t sys, char *table[], int table_size) {
  char *res;

  if((nr_const < 0) || (nr_const >= table_size ))
    return nr_not_existing;
  res = table[nr_const];
  /* If "nr_const" is __NR_socketcall, then I have to get the right
   * __RSC_* constant using the SYS_* one. */
  if(strcmp("__NR_socketcall", res) == 0) {
    if( (sys != NO_VALUE) && (sys > 0) && (sys < SYS_TO_STR_SIZE) ) {
      res = sys_to_str[sys];
    } else {
      /* I need a correct SYS_ value __NR_ is __NR_socketcall! */
      res = nr_not_existing;
    }
  }

  return res;
}



/*########################################################################*/
/*##                                                                    ##*/
/*##  LIBRARY FUNCTIONS                                                 ##*/
/*##                                                                    ##*/
/*########################################################################*/
/* sys can be equal to NO_VALUE */
enum rsc_constant nr2rsc(int32_t nr_const, int32_t sys, enum arch arch) {
  enum rsc_constant res;
  
  switch(arch) {
    case ACONV_X86:
      res = get_rsc(nr_const, sys, x86_to_rsc, X86_TO_RSC_SIZE);
      break;
    case ACONV_PPC:
      res = get_rsc(nr_const, sys, ppc_to_rsc, PPC_TO_RSC_SIZE);
      break;
    case ACONV_X86_64:
      res = get_rsc(nr_const, sys, x86_64_to_rsc, X86_64_TO_RSC_SIZE);
      break;
    default:
      res = __RSC_ERROR;
      break;
  }

  RSC_DEBUG(RSCD_REQ_RESP, "nr2rsc: %s(# %d; sys = %d) => %s (# %d)", 
      nr2str(nr_const, sys, arch), nr_const, sys,
      res == __RSC_ERROR ? rsc_not_existing : rsc2str(res), res);
  return res ;
}

struct nr_and_sys *rsc2nr(enum rsc_constant rsc_const, enum arch arch) {
  struct nr_and_sys *res;
  switch(arch) {
    case ACONV_X86:
      res = get_nr(rsc_const, rsc_to_x86);
      break;
    case ACONV_PPC:
      res = get_nr(rsc_const, rsc_to_ppc);
      break;
    case ACONV_X86_64:
      res = get_nr(rsc_const, rsc_to_x86_64);
      break;
    default:
      res = NULL;
      break;
  }
  RSC_DEBUG(RSCD_REQ_RESP, "rsc2nr: %s(# %d) => %s (# %d; sys = %d)", 
      rsc2str(rsc_const), rsc_const, 
      res == NULL ? nr_not_existing : nr2str(res->nr, res->sys, arch), 
      res == NULL ? -1 : res->nr,
      res == NULL ? -1 : res->sys);
  return res;
}

char *rsc2str(enum rsc_constant rsc_const) {
  if((rsc_const < __RSC_FIRST) || (rsc_const > __RSC_LAST))
    return rsc_not_existing;

  return rsc_to_str[rsc_const];
}

char *nr2str(int32_t nr_const, int32_t sys, enum arch arch) {
  char *res;
  
  switch(arch) {
    case ACONV_X86:
      res = get_str(nr_const, sys, x86_to_str, X86_TO_STR_SIZE);
      break;
    case ACONV_PPC:
      res = get_str(nr_const, sys, ppc_to_str, PPC_TO_STR_SIZE);
      break;
    case ACONV_X86_64:
      res = get_str(nr_const, sys, x86_64_to_str, X86_64_TO_STR_SIZE);
      break;
    default:
      res = nr_not_existing;
      break;
  }

  return res;
}
