from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       






class IBaseImageItem(_Mock):
  pass
  _can_setfullscale = True
  _can_sethistogram = False

class IBasePlotItem(_Mock):
  pass
  _can_move = True
  _can_resize = True
  _can_rotate = True
  _can_select = True
  _private = False
  _readonly = False
  selected = False

class ICSImageItemType(_Mock):
  pass


class IColormapImageItemType(_Mock):
  pass


class ICurveItemType(_Mock):
  pass


class IDecoratorItemType(_Mock):
  pass


class IExportROIImageItemType(_Mock):
  pass


class IHistDataSource(_Mock):
  pass


class IImageItemType(_Mock):
  pass


class IItemType(_Mock):
  pass


class IPanel(_Mock):
  pass


class IPlotManager(_Mock):
  pass


class ISerializableType(_Mock):
  pass


class IShapeItemType(_Mock):
  pass


class IStatsImageItemType(_Mock):
  pass


class ITrackableItemType(_Mock):
  pass


class IVoiImageItemType(_Mock):
  pass


