from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


ConfigDict = _Mock()

DataDisplay = _Mock()

Elements = _Mock()

IconDict = _Mock()

PyMcaDataDir = _Mock()

PyMcaDirs = _Mock()

QSpecFileWidget = _Mock()

SpecFileDataSource = _Mock()

downstep = _Mock()

numpy = _Mock()

os = _Mock()

osPathBasename = _Mock()

osPathIsDir = _Mock()

osPathJoin = _Mock()

qt = _Mock()

sys = _Mock()

upstep = _Mock()

DEBUG = 0

NEWLINE = '\n'

class Calculations(_Mock):
  pass


class LineEditDisplay(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  NoEcho = 1
  Normal = 0
  Password = 2
  PasswordEchoOnEdit = 3
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class LoadDichorismDataDialog(_Mock):
  pass
  Accept = 3
  AcceptOpen = 0
  AcceptSave = 1
  Accepted = 1
  AnyFile = 0
  Detail = 0
  Directory = 2
  DirectoryOnly = 4
  DontConfirmOverwrite = 4
  DontResolveSymlinks = 2
  DontUseCustomDirectoryIcons = 128
  DontUseNativeDialog = 16
  DontUseSheet = 8
  DrawChildren = 2
  DrawWindowBackground = 1
  ExistingFile = 1
  ExistingFiles = 3
  FileName = 1
  FileType = 2
  HideNameFilterDetails = 64
  IgnoreMask = 4
  List = 1
  LookIn = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  ReadOnly = 32
  Reject = 4
  Rejected = 0
  ShowDirsOnly = 1

class MarkerSpinBox(_Mock):
  pass
  CorrectToNearestValue = 1
  CorrectToPreviousValue = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  NoButtons = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  PlusMinus = 1
  StepDownEnabled = 2
  StepNone = 0
  StepUpEnabled = 1
  UpDownArrows = 0

class QString(_Mock):
  pass


class QStringList(_Mock):
  pass


class SumRulesWindow(_Mock):
  pass
  AllowNestedDocks = 2
  AllowTabbedDocks = 4
  AnimatedDocks = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ForceTabbedDocks = 8
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  VerticalTabs = 16
  _SumRulesWindow__intP = 'p'
  _SumRulesWindow__intQ = 'q'
  _SumRulesWindow__intR = 'r'
  _SumRulesWindow__postMax = 'Post Max'
  _SumRulesWindow__postMin = 'Post Min'
  _SumRulesWindow__preMax = 'Pre Max'
  _SumRulesWindow__preMin = 'Pre Min'
  _SumRulesWindow__tabBG = 'background'
  _SumRulesWindow__tabElem = 'element'
  _SumRulesWindow__tabInt = 'integration'
  _SumRulesWindow__xasBGmodel = 'xas BG model'

