/* ====================================================================
 * Copyright (c) 2003-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "LogEntryLvi.h"
#include "svn/LogEntry.h"


LogEntryLvi::LogEntryLvi( QTreeWidget* parent, const svn::LogEntryPtr entry )
: super(parent,UserType), _entry(entry)
{
  setText( 0, QString().sprintf( "%10ld", (unsigned long)_entry->getRevnumber() ) );
  setTextAlignment( 0, Qt::AlignRight );

  char time[APR_CTIME_LEN] = {};
  apr_ctime( time, _entry->getDate() );
  setText( 1, QString(time) );
  setTextAlignment( 1, Qt::AlignRight );

  setText( 2, QString().sprintf( "%s", (const char*)_entry->getAuthor() ) );
  setTextAlignment( 2, Qt::AlignLeft );
}

LogEntryLvi::~LogEntryLvi()
{
}

const svn::LogEntryPtr LogEntryLvi::getLogEntry() const
{
  return _entry;
}
