2.4 Czas trwania obwiedni dźwięku

# Czas trwania obwiedni dźwięku

W poprzedniej sekcji, zobaczyliśmy w jaki sposób możemy używać komendy 
`sleep` aby kontrolować, kiedy dźwięki zaczynają grać. Nie wiemy jednak 
jeszcze w jaki sposób kontrolować długość trwania naszych dźwięków.

Aby móc korzystać z prostej ale jakże potężnej możliwości *kontrolowania 
długości trwania* naszych dźwięków, Sonic Pi udostępnia pojęcie 
*obwiedni dla amplitudy ADSR* (czym jest ADSR dowiesz się za chwilę 
w kolejnych sekcjach). Obwiednia amplitudy udostępnia dwa przydatne 
aspekty kontroli:

* kontrolę długości trwania dźwięku
* kontrolę amplitudy dźwięku

## Długość trwania dźwięku (ang. Duration)

Długość trwania mówi o tym jak długo słychać dany dźwięk. Im długość trwania jest 
większa tym dłużej słyszysz dźwięk. Wszystkie dźwięki w Sonic Pi posiadają 
kontrolowalną obwiednię amplitudy a całkowita długości trwania tej obwiedni  
to długość trwania dźwięku. Dlatego też kontrolując obwiednię kontrolujesz 
Długość trwania.

## Amplituda (ang. Amplitude)

Obwiednia ADSR kontroluje nie tylko długość trwania, lecz pozwala Ci również 
na *precyzyjną kontrolę amplitudy dźwięku*. Wszystkie dźwięki zaczynają się 
i kończą ciszą. Pomiędzy tymi ciszami jest moment podczas, którego 
słychać dźwięk. Obwiednie pozwalają Ci przesuwać i ustawiać amplitudę tej części, 
w której słychać dźwięk. Jest to analogiczne do sytuacji, w której 
powiedziałbyś komuś kiedy powinien zwiększać i zmieniejszać głośność 
dla jakiegoś utworu muzycznego. Na przykład - możesz poprosić kogoś 
"zacznij od ciszy, potem powoli zwiększaj poziom głośności, utrzymaj go 
na tym poziomie przez chwilę po czym szybko wycisz". Sonic Pi pozwala 
Ci na zaprogramowanie tego za pomocą obwiedni.

Jak widzieliśmy w poprzedniej sekcji samouczka, amplituda o wartości 0 to cisza, 
natomiast amplituda o wartości 1 to głośność normalna.

## Release Time - czas zanikania amplitudy

Domyślnie wszystkie syntezatory posiadają czas zanikania amplitudy równy 1. Oznacza to, 
że trwa to 1 uderzenie przed zakończeniem (domyślnie będzie to 1 sekunda). Możemy 
zmieniać czas trwania tego zanikania za pomocą przekazania do naszego polecenia `play` 
parametru `release:`. Na przykład, aby sprawić by syntezator grał przez 2 uderzenia, dla parametru
`release:` ustawiamy wartość `2`:

```
play 60, release: 2
```

Możemy też sprawić aby syntezator brzmiał przez bardzo krótką chwilę. Wystarczy 
użyć bardzo małej wartości dla czasu zanikania amplitudy:

```
play 60, release: 0.2
```

W takim razie czym jest długość zanikania amplitudy? Jesto to czas, który jest 
potrzebny aby dźwięk z maksymalnej amplitudy (zazwyczaj jest to wartość 1) 
zmniejszył się do amplitudy równej zero. Jest to tak zwana *faza zanikania 
(ang. release phase)* i jest to przejście liniowe (tzn. obniżające się w linii 
prostej). Poniższy diagram ilustruje to przejście: 

![release envelope](../images/tutorial/env-release.png)

Pionowa linia po lewej stronie diagramu pokazuje, że dźwięk zaczyna się 
z amplitudą równą 0, ale osiąga pełną głośność momentalnie (jest to faza 
ataku, omówimy ją za chwilę). Gdy pełna głośność zostanie już osiągnięta 
następuje zmniejszanie głośności po linii prostej aż do wartości zero 
i zajmuje to tyle czasu ile zostało ustawione za pomocą parametru zanikania 
`release:`. *Im czas zanikania jest dłuższy, tym dłuższy będzie czas znikania 
(wyciszania) dźwięku syntezatora.*

Możesz zatem zmieniać długość trwania twoich dźwięków zmieniając czas 
zanikania. Spróbuj teraz pobawić się dodając do twojej muzyki 
różne czasy zanikania.

## Attack Time - czas narastania amplitudy

Domyślnie, faza ataku jest równa 0 dla wszystkich sytezatorów. Oznacza to, 
że przejście od amplitudy 0 do aplitudy 1 jest natychmiastowe. Nadaje to 
syntezatorowi początkowy perkusyjny dźwięk. Mimo to, może się zdarzyć, że 
będziesz chciał aby twój dźwięk zaczynał brzmieć stopniowo. Aby to zrobić 
wystarczy wykorzystać parametr 'attack:'. Spróbuj użyć takiego przejścia 
w kilku różnych dźwiękach:  

```
play 60, attack: 2
sleep 3
play 65, attack: 0.5
```

Zauważ, że możesz używać wielu parametrów w tym samym czasie. Na przykład dla krótkiej 
fazy ataku (attack) i długiej fazy zanikania (release) spróbuj coś takiego: 

```
play 60, attack: 0.7, release: 4
```

Taka obwiednia z krótką fazą ataku i długą zanikania została zilustrowana 
na poniższym rysunku:

![attack release envelope](../images/tutorial/env-attack-release.png)

Oczywiście, możesz zmieniać parametry według swoich upodobań. Spróbuj teraz 
długiej fazy ataku i krótkiej fazy zanikania:

```
play 60, attack: 4, release: 0.7
```

![long attack short release envelope](../images/tutorial/env-long-attack-short-release.png)

Na koniec możesz też spróbować ustawić obie wartości dla czasu narastania i zanikania 
na małe wartości aby uzyskać krótsze dźwięki.

```
play 60, attack: 0.5, release: 0.5
```

![short attack short release envelope](../images/tutorial/env-short-attack-short-release.png)

## Sustain Time - czas podtrzymania amplitudy

Oprócz możliwości ustawiania czasu narastania i czasu zanikania dźwięku, 
możesz również określić czas podtrzymania. Jest to moment, w którym dźwięk jest 
utrzymany na pełnej aplitudzie pomiędzy fazami narastania i zanikania.

```
play 60, attack: 0.3, sustain: 1, release: 1
```

![ASR envelope](../images/tutorial/env-attack-sustain-release.png)

Czas podtrzymania jest bardzo przydatny dla istotnych dźwięków, którym 
chciałbyś dać pełną obecność w miksie tuż przed wejściem opcjonalnej fazy
zanikania. Oczywiście, całkowicie dopuszczalne jest ustawienie obu 
parametrów, zarówno fazy ataku jak i fazy zanikania na wartość 0 
a także użycie tylko fazy podtrzymania żeby nie mieć absolutnie żadnej  
fazy wejścia lub wyjścia dla danego dźwięku. Bądź jednak ostrożny i wiedz,
że ustawienie fazy zanikania na 0 może spowodować dziwne kliki w dźwiękach 
i bardzo często zamiast tego dużo lepiej jest użyć bardzo małej wartości, 
np. 0.2.

## Decay Time - czas opadania amplitudy

Na sam koniec, dla momentów gdzie potrzebujesz dodatkowego poziomu kontroli, 
masz możliwość skorzystania z fazy opadania. Jest to taki moment w obwiedni dźwięku, 
który znajduje się pomiędzy fazą ataku a fazą podtrzymania (wybrzmiewania) 
i określa moment, w którym amplituda spada z poziomu ataku `attack_level` do poziomu 
podtrzymania `sustain_level`. Domyślnym argumentem dla fazy opadania jest 0, natomiast 
poziomy ataku i podtrzymania posiadają domyślną wartość 1. W związku z tym musisz 
określić dla nich czas opadania aby uzyskać jakikolwiek efekt: 

```
play 60, attack: 0.1, attack_level: 1, decay: 0.2, sustain_level: 0.4, sustain: 1, release: 0.5
```

![ADSR envelope](../images/tutorial/env-attack-decay-sustain-release.png)

## Obwiednie ADSR

## Obwiednie ADSR

Podsumowując, obwiednie ADSR w Sonic Pi posiadają następujące fazy:

1. *attack* - czas narastania amplitudy od zera do poziomu maksymalnego, 
którego wysokość jest określana przez parametr `attack_level`.
2. *decay* - czas opadania amplitudy od poziomu maksymalnego (`attack_level`) 
do poziomu podtrzymania (`sustain_level`).
3. *sustain* - czas podtrzymania dźwięku na poziomie określonym przez 
parametr `sustain_level`.
4. *release* - czas zanikania amplitudy od poziomu podtrzymania 
(`sustain_level`) do zera.

Należy tu zwrócić uwagę na fakt, że całkowita długość trwania dźwięku jest sumą 
czasu trwania każdej z faz występujących w danym dźwięku. Dlatego też poniższy 
dźwięk będzie miał długość 0.5 + 1 + 2 + 0.5 = 4 uderzeń:

```
play 60, attack: 0.5, decay: 1, sustain_level: 0.4, sustain: 2, release: 0.5
```

Tyle teorii, teraz spróbuj sam pobawić się dodając obwiednie do twoich dźwięków...
