/* xg.c: s7, Ruby, and Forth bindings for gtk/pango/cairo, some of glib
 *   this file generated automatically from makexg.scm and xgdata.scm
 *   needs xen.h
 *
 * reference args initial values are usually ignored, resultant values are returned in a list.
 * null ptrs are passed and returned as #f, trailing "user_data" callback function arguments are optional (default: #f).
 * where supported, "..." args are passed as a list, trailing NULL or -1 should be omitted.
 * 'xg is added to *features*
 *
 * added funcs:
 *    (xg-version): date string.
 *    (c-array->list arr len) derefs each member of arr, returning lisp list, len=#f: null terminated array
 *    (list->c-array lst ctype) packages each member of list as c-type "type" returning (wrapped) c array
 *    (GtkTextIter): GtkTextIter struct
 *    (GtkTreeIter): GtkTreeIter struct
 *    (PangoRectangle): PangoRectangle struct
 *    (cairo_matrix_t): cairo_matrix_t struct (if cairo)
 *
 * omitted functions and macros:
 *     anything with a va_list or GtkArg* argument.
 *     most of the unusual keysym names
 *     all *_CLASS, *_IFACE macros, *_get_type functions
 *     win32-specific functions
 *
 * HISTORY:
 *
 *     28-Jul-17: scheme Init_libxg arg added.
 *     --------
 *     17-Mar-16: gtk_enum_t for better signature checks.
 *     --------
 *     29-Oct:    removed ->string.
 *     21-Aug-15: procedure-signature changes.
 *     --------
 *     27-Dec:    integer procedure stuff.
 *     16-Apr:    changed max-args to 8.
 *     6-Mar:     changed most macros.
 *     21-Feb-14: changed _p to _is_.
 *     --------
 *     3-Sep:     use symbol directly in type checks, not the symbol name.
 *     18-Aug:    changed the gtk version macros to reflect the version number.
 *     7-Jun-13:  added mixed arg types to the ... arg lists.
 *     --------
 *     19-Aug-10: removed lots of Gdk stuff -- we assume Gtk 2.9 and cairo now.
 *     28-Jan-10: removed the rest of the struct accessors.
 *     --------
 *     16-Dec-09: removed Guile support.
 *     --------
 *     16-Oct:    removed Gauche support.
 *     1-Sep:     s7 support.
 *     8-Jul-08:  started removing all struct accessors (for Gtk 3).
 *     --------
 *     9-Mar:     removed all *_get_type functions (nearly 300!).
 *     5-Mar-07:  cairo and more gtkprint.
 *     --------
 *     26-Aug:    removed --with-x11, WITH_GTK_AND_X11, xg-x11.h.
 *     4-Aug:     added a form of g_object_get and gtk_settings_get_for_screen.
 *     20-Jul:    gtkprint stuff.
 *     17-Jul:    g_signal_connect and other related macros.
 *     21-Apr:    Gauche support.
 *     29-Mar:    Forth support.
 *     7-Mar-06:  if g_set_error, return the error message, not the GError pointer
 *     --------
 *     9-Jul:     Collapse 2.3.* into 2.3.6, 2.5.* into 2.5.6.
 *     13-Jun:    folded xg-ruby.c into xg.c.
 *     21-Feb:    changed libxm to libxg, xm-version to xg-version.
 *     10-Jan:    plugged some memory leaks.
 *     4-Jan-05:  removed deprecated Xen_VECTOR_ELEMENTS.
 *     --------
 *     8-Dec:     added some g_log handler funcs.
 *     6-Dec:     check for lost callback context.
 *                tightened type (pointer) checking considerably (#f only acceptable if explicit @ used in xgdata.scm).
 *     3-Dec:     changed GPOINTER cast func to accept non-lists.
 *     27-Aug:    removed the PANGO_ENGINE and PANGO_BACKEND stuff.
 *     2-Jun:     gdk_atom_name needs to free return value
 *     28-May:    GtkFileSelection struct support put back in -- need ok_button et al.
 *     14-Apr:    make-target-entry.
 *     4-Apr:     various additions, deletions, and bugfixes for snd-test 26
 *     29-Mar:    support for some ... args.
 *     22-Mar:    g_source_remove and related changes.
 *     12-Feb-04: g_list_nth_data (Kjetil S. Matheussen).
 *     --------
 *     15-Sep:    removed client_window GtkIMMulticontext struct field.
 *     26-May:    removed nugatory GdkInputFunction stuff and some unused type converters.
 *     1-Apr:     gdk_property_get uses scm_mem2string in some cases now.
 *     31-Mar:    gchar* -> xen string bugfix (thanks to Friedrich Delgado Friedrichs).
 *     10-Mar-03: Ruby Xm_Version.
 *     --------
 *     18-Nov:    Ruby/Gtk bugfixes.
 *     25-Oct:    removed (deprecated) gdk_set_pointer_hooks
 *     31-Jul:    removed GTK 1.n support
 *     24-Jul:    changed Guile prefix (R5RS reserves vertical-bar).
 *     19-Jul:    XG_FIELD_PRE for change from using vertical-bar (reserved in R5RS)
 *     2-Jun:     removed deprecated and broken stuff
 *     12-Mar:    support for GtkDestroyNotify callbacks
 *                Ruby support via xg-ruby.c
 *     21-Feb:    #f=NULL throughout, gdk-pixbuf, GTypes.
 *     11-Feb-02: initial version.
 */

#include "mus-config.h"

#define HAVE_CAIRO_1_8    ((CAIRO_VERSION_MAJOR >= 1) && (CAIRO_VERSION_MINOR >= 8))
#define HAVE_CAIRO_1_9_12 ((CAIRO_VERSION_MAJOR >= 1) && (CAIRO_VERSION_MINOR >= 9) && (CAIRO_VERSION_MICRO >= 12))

#if ((!__NetBSD__) && ((_MSC_VER) || (!defined(__STC__)) || (defined(__STDC_VERSION__) && (__STDC_VERSION__ < 199901L))))
  #define __func__ __FUNCTION__
#endif

#if HAVE_EXTENSION_LANGUAGE

#include <string.h>
#include <stdlib.h>
#include <stdint.h>
#include <inttypes.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#if (!GTK_CHECK_VERSION(3, 0, 0))
  #include <gdk/gdkkeysyms.h>
#endif
#include <glib-object.h>
#include <pango/pango.h>
#include <cairo/cairo.h>
#if USE_SND
  /* USE_SND causes xm to use Snd's error handlers which are much smarter than xen's fallback versions */
  #include "snd.h"
#else
  #include "xen.h"
  #define NOT_A_GC_LOC -1
#endif

#ifndef PROC_FALSE
  #if HAVE_RUBY
    #define PROC_FALSE "false"
    #define PROC_TRUE "true"
  #else
    #define PROC_FALSE "#f"
    #define PROC_TRUE  "#t"
  #endif
#endif

/* -------------------------------- GC -------------------------------- */
static Xen_object_type_t xm_obj_tag;
#if HAVE_RUBY
static void *xm_obj_free(Xen obj)
{
  void *xobj;
  xobj = (void *)obj;
  free(xobj);
  return(NULL);
}
#endif
#if HAVE_FORTH
static void xm_obj_free(Xen obj)
{
  void *val;
  val = (void *)Xen_object_ref(obj);
  free(val);
}
#endif
#if HAVE_SCHEME
static void xm_obj_free(void *val)
{
  free(val);
}
static bool s7_equalp_xm(void *x1, void *x2)
{
  return(x1 == x2);
}
#endif
static Xen make_xm_obj(void *ptr)
{
  return(Xen_make_object(xm_obj_tag, ptr, 0, xm_obj_free));
}
static void define_xm_obj(void)
{
#if HAVE_SCHEME
  xm_obj_tag = s7_make_c_type(s7, "<XmObj>");
  s7_c_type_set_free(s7, xm_obj_tag, xm_obj_free);
  s7_c_type_set_equal(s7, xm_obj_tag, s7_equalp_xm);
#else
  xm_obj_tag = Xen_make_object_type("XmObj", sizeof(void *));
#endif
#if HAVE_FORTH
  fth_set_object_free(xm_obj_tag, xm_obj_free);
#endif
}  

/* prefix for all names */
#if HAVE_SCHEME
  #define Xg_pre ""
  #define Xg_field_pre "."
  #define Xg_post ""
#endif
#if HAVE_RUBY
/* for Ruby, XG PRE needs to be uppercase */
  #define Xg_pre "R"
  #define Xg_post ""
  #define Xg_field_pre "R"
#endif
#if HAVE_FORTH
  #define Xg_pre "F"
  #define Xg_post ""
  #define Xg_field_pre "F"
#endif

static Xen xg_GMenu__symbol, xg_GtkApplicationInhibitFlags_symbol, xg_GApplicationFlags_symbol, xg_GtkContentFormats__symbol, xg_GtkStyleProvider__symbol, xg_GdkAtom__symbol, xg_GdkDisplay_gtk_invisible_get_display_symbol, xg_GtkInvisible__symbol, xg_GtkIconSize_symbol, xg_GValue_symbol, xg_GBytes__symbol, xg_GdkContentDeserializeFunc_symbol, xg_GdkContentDeserializer__symbol, xg_GdkContentSerializeFunc_symbol, xg_GdkContentSerializer__symbol, xg_GOutputStream__symbol, xg_GdkContentFormatsBuilder__symbol, xg_GdkContentFormatsBuilder_symbol, xg_GString__symbol, xg_va_list_symbol, xg_GdkTexture__symbol, xg_har___symbol, xg_GInputStream__symbol, xg_GAsyncResult__symbol, xg_GAsyncReadyCallback_symbol, xg_GCancellable__symbol, xg_GdkContentProvider__symbol, xg_GdkContentFormats__symbol, xg_GdkClipboard__symbol, xg_GdkAppLaunchContext__symbol, xg_GtkEventControllerScroll__symbol, xg_GtkEventControllerScrollFlags_symbol, xg_GtkSnapshot__symbol, xg_GdkTouchpadGesturePhase_symbol, xg_GdkNotifyType_symbol, xg_GdkCrossingMode_symbol, xg_GdkEventScroll__symbol, xg_GtkScrollbar__symbol, xg_GtkCenterBox__symbol, xg_GtkCheckButton__symbol, xg_GdkDrawContext__symbol, xg_GtkDrawingAreaDrawFunc_symbol, xg_GtkShortcutLabel__symbol, xg_GtkPadActionType_symbol, xg_GtkPadActionEntry__symbol, xg_GActionGroup__symbol, xg_GtkPadController__symbol, xg_GdkDevicePadFeature_symbol, xg_GdkDevicePad__symbol, xg_GdkDrawingContext__symbol, xg_GdkSubpixelLayout_symbol, xg_GdkMonitor__symbol, xg_GdkDeviceTool__symbol, xg_GdkAxisFlags_symbol, xg_GdkSeatGrabPrepareFunc_symbol, xg_GdkSeatCapabilities_symbol, xg_GdkGrabStatus_symbol, xg_GtkPopoverConstraint_symbol, xg_GtkShortcutsWindow__symbol, xg_GtkStackSidebar__symbol, xg_GtkSearchEntry__symbol, xg_GtkPopoverMenu__symbol, xg_GtkStyleContext__symbol, xg_GdkGLContext__symbol, xg_GtkGLArea__symbol, xg_GtkPropagationPhase_symbol, xg_GtkEventController__symbol, xg_GtkGestureZoom__symbol, xg_GtkGestureSwipe__symbol, xg_GtkGestureSingle__symbol, xg_GtkGestureRotate__symbol, xg_GtkGestureMultiPress__symbol, xg_GtkGesturePan__symbol, xg_GtkGestureDrag__symbol, xg_GdkEventSequence__symbol, xg_GtkEventSequenceState_symbol, xg_GtkGesture__symbol, xg_GtkAllocation__symbol, xg_GtkPopover__symbol, xg_GtkActionBar__symbol, xg_GtkFlowBox__symbol, xg_GtkFlowBoxChild__symbol, xg_GdkEventType_symbol, xg_GtkSearchBar__symbol, xg_GtkListBox__symbol, xg_GtkListBoxRow__symbol, xg_GtkHeaderBar__symbol, xg_GtkRevealerTransitionType_symbol, xg_GtkRevealer__symbol, xg_GtkStackTransitionType_symbol, xg_GtkStack__symbol, xg_GtkStackSwitcher__symbol, xg_GtkPlacesSidebar__symbol, xg_GtkPlacesOpenFlags_symbol, xg_GtkBaselinePosition_symbol, xg_GdkFullscreenMode_symbol, xg_GtkInputHints_symbol, xg_GtkInputPurpose_symbol, xg_GtkLevelBarMode_symbol, xg_GtkLevelBar__symbol, xg_GtkMenuButton__symbol, xg_GtkColorChooser__symbol, xg_GtkApplicationWindow__symbol, xg_GtkApplication__symbol, xg_GMenuModel__symbol, xg_guint___symbol, xg_GdkModifierIntent_symbol, xg_GtkFontChooser__symbol, xg_GdkScrollDirection_symbol, xg_GtkOverlay__symbol, xg_GtkWidgetPath__symbol, xg_GtkStateFlags_symbol, xg_GtkToolShell__symbol, xg_GtkWindowGroup__symbol, xg_GIcon__symbol, xg_GtkOrientable__symbol, xg_GtkCellArea__symbol, xg_GtkBorder__symbol, xg_GtkSwitch__symbol, xg_GtkScrollablePolicy_symbol, xg_GtkScrollable__symbol, xg_GtkGrid__symbol, xg_GdkRGBA__symbol, xg_GtkComboBoxText__symbol, xg_GtkAlign_symbol, xg_GtkSizeRequestMode_symbol, xg_cairo_region_overlap_t_symbol, xg_cairo_rectangle_int_t__symbol, xg_double__symbol, xg_cairo_rectangle_t__symbol, xg_cairo_device_t__symbol, xg_cairo_bool_t_symbol, xg_cairo_text_cluster_flags_t__symbol, xg_cairo_text_cluster_t___symbol, xg_cairo_glyph_t___symbol, xg_cairo_text_cluster_flags_t_symbol, xg_cairo_text_cluster_t__symbol, xg_cairo_region_t__symbol, xg_GtkMessageDialog__symbol, xg_GdkDevice__symbol, xg_GtkAccessible__symbol, xg_GdkModifierType__symbol, xg_GtkDestDefaults_symbol, xg_GtkToolPaletteDragTargets_symbol, xg_GtkToolItemGroup__symbol, xg_GtkToolPalette__symbol, xg_GtkPackType_symbol, xg_GtkSpinner__symbol, xg_GtkEntryBuffer__symbol, xg_GtkMessageType_symbol, xg_GtkInfoBar__symbol, xg_GtkEntryIconPosition_symbol, xg_GFile__symbol, xg_GtkScaleButton__symbol, xg_GtkCalendarDetailFunc_symbol, xg_GtkTooltip__symbol, xg_cairo_rectangle_list_t__symbol, xg_void__symbol, xg_cairo_filter_t_symbol, xg_cairo_extend_t_symbol, xg_cairo_format_t_symbol, xg_cairo_path_t__symbol, xg_cairo_destroy_func_t_symbol, xg_cairo_user_data_key_t__symbol, xg_cairo_text_extents_t__symbol, xg_cairo_font_extents_t__symbol, xg_cairo_font_face_t__symbol, xg_cairo_glyph_t__symbol, xg_cairo_scaled_font_t__symbol, xg_cairo_font_weight_t_symbol, xg_cairo_font_slant_t_symbol, xg_cairo_hint_metrics_t_symbol, xg_cairo_hint_style_t_symbol, xg_cairo_subpixel_order_t_symbol, xg_cairo_status_t_symbol, xg_bool_symbol, xg_cairo_matrix_t__symbol, xg_cairo_line_join_t_symbol, xg_cairo_line_cap_t_symbol, xg_cairo_fill_rule_t_symbol, xg_cairo_antialias_t_symbol, xg_cairo_operator_t_symbol, xg_cairo_pattern_t__symbol, xg_cairo_content_t_symbol, xg_GtkPageSet_symbol, xg_GtkPageRange__symbol, xg_GtkPrintPages_symbol, xg_GtkPrintQuality_symbol, xg_GtkPrintDuplex_symbol, xg_GtkPaperSize__symbol, xg_GtkPageOrientation_symbol, xg_GtkPrintSettingsFunc_symbol, xg_GtkPageSetupDoneFunc_symbol, xg_GtkPrintStatus_symbol, xg_GtkPrintOperationAction_symbol, xg_GtkPrintOperationResult_symbol, xg_GtkUnit_symbol, xg_GtkPrintSettings__symbol, xg_GtkPrintOperation__symbol, xg_GtkPageSetup__symbol, xg_GtkPrintContext__symbol, xg_cairo_surface_t__symbol, xg_GtkTreeViewGridLines_symbol, xg_GtkRecentData__symbol, xg_time_t_symbol, xg_GtkRecentChooserMenu__symbol, xg_GtkRecentManager__symbol, xg_GtkRecentFilter__symbol, xg_GtkRecentSortFunc_symbol, xg_GtkRecentSortType_symbol, xg_GtkRecentChooser__symbol, xg_GtkLinkButton__symbol, xg_GtkAssistantPageType_symbol, xg_GtkAssistantPageFunc_symbol, xg_GtkAssistant__symbol, xg_GDestroyNotify_symbol, xg_GtkTreeViewSearchPositionFunc_symbol, xg_GtkSensitivityType_symbol, xg_GtkMenuBar__symbol, xg_GtkPackDirection_symbol, xg_GtkIconViewDropPosition_symbol, xg_GValue__symbol, xg_GLogFunc_symbol, xg_PangoMatrix__symbol, xg_PangoRenderPart_symbol, xg_PangoRenderer__symbol, xg_GtkMenuToolButton__symbol, xg_GtkFileChooserButton__symbol, xg_PangoScriptIter__symbol, xg_PangoScript_symbol, xg_PangoAttrFilterFunc_symbol, xg_PangoEllipsizeMode_symbol, xg_GtkIconViewForeachFunc_symbol, xg_GtkAboutDialog__symbol, xg_GtkTreeViewRowSeparatorFunc_symbol, xg_GtkCellView__symbol, xg_GtkAccelMap__symbol, xg_GtkOrientation_symbol, xg_GtkToolButton__symbol, xg_GtkIconLookupFlags_symbol, xg_GtkIconInfo__symbol, xg_gchar___symbol, xg_GtkIconTheme__symbol, xg_GtkFileChooser__symbol, xg_GtkCellLayoutDataFunc_symbol, xg_GtkCellLayout__symbol, xg_GtkFileFilterFunc_symbol, xg_GtkFileFilterFlags_symbol, xg_GtkFileFilter__symbol, xg_GSourceFunc_symbol, xg_GtkToggleToolButton__symbol, xg_GtkSeparatorToolItem__symbol, xg_GtkRadioToolButton__symbol, xg_GtkEntryCompletionMatchFunc_symbol, xg_GtkFontButton__symbol, xg_GtkExpander__symbol, xg_GtkComboBox__symbol, xg_GtkTreeModelFilter__symbol, xg_GtkFileChooserAction_symbol, xg_GtkToolItem__symbol, xg_GtkCalendarDisplayOptions_symbol, xg_GdkDisplay__symbol, xg_PangoLayoutRun__symbol, xg_PangoLayoutIter__symbol, xg_PangoLayoutLine__symbol, xg_int__symbol, xg_PangoAlignment_symbol, xg_PangoWrapMode_symbol, xg_PangoItem__symbol, xg_PangoGlyphString__symbol, xg_PangoFontMap__symbol, xg_PangoGlyph_symbol, xg_PangoFontFace__symbol, xg_PangoFontFace___symbol, xg_PangoFontFamily__symbol, xg_PangoFontMask_symbol, xg_PangoFontDescription___symbol, xg_PangoCoverageLevel_symbol, xg_PangoCoverage__symbol, xg_PangoFontMetrics__symbol, xg_PangoFontset__symbol, xg_PangoFont__symbol, xg_PangoFontFamily___symbol, xg_PangoLogAttr__symbol, xg_PangoAnalysis__symbol, xg_PangoAttrList___symbol, xg_PangoAttrIterator__symbol, xg_PangoRectangle__symbol, xg_PangoUnderline_symbol, xg_PangoStretch_symbol, xg_PangoVariant_symbol, xg_PangoWeight_symbol, xg_PangoStyle_symbol, xg_guint16_symbol, xg_PangoAttribute__symbol, xg_PangoAttrType_symbol, xg_PangoColor__symbol, xg_GdkGravity_symbol, xg_GtkWindowPosition_symbol, xg_GtkWindowType_symbol, xg_GtkWindow__symbol, xg_GtkTextDirection_symbol, xg_PangoContext__symbol, xg_AtkObject__symbol, xg_GtkDirectionType_symbol, xg_GtkViewport__symbol, xg_GtkTreeViewSearchEqualFunc_symbol, xg_GtkTreeViewDropPosition_symbol, xg_GtkTreeViewMappingFunc_symbol, xg_GtkTreeViewColumnDropFunc_symbol, xg_GtkTreeViewColumnSizing_symbol, xg_GtkTreeCellDataFunc_symbol, xg_GtkTreeStore__symbol, xg_GtkTreeIterCompareFunc_symbol, xg_GtkSortType_symbol, xg_GtkTreeSortable__symbol, xg_GtkTreeSelectionForeachFunc_symbol, xg_GtkTreeModel___symbol, xg_GtkTreeSelectionFunc_symbol, xg_GtkSelectionMode_symbol, xg_GtkTreeModelSort__symbol, xg_GtkTreeModelForeachFunc_symbol, xg_GtkTreeModelFlags_symbol, xg_GtkTreeRowReference__symbol, xg_GtkTreeDragDest__symbol, xg_GtkTreeDragSource__symbol, xg_GtkToolbarStyle_symbol, xg_GtkToolbar__symbol, xg_GtkToggleButton__symbol, xg_PangoTabArray__symbol, xg_GtkWrapMode_symbol, xg_GtkTextWindowType_symbol, xg_GtkTextView__symbol, xg_GtkTextTagTableForeach_symbol, xg_GtkTextSearchFlags_symbol, xg_GtkTextCharPredicate_symbol, xg_GtkTextMark__symbol, xg_GtkTextChildAnchor__symbol, xg_GtkTextIter__symbol, xg_GtkTextTagTable__symbol, xg_GtkTextBuffer__symbol, xg_GtkStatusbar__symbol, xg_GtkSpinType_symbol, xg_GtkSpinButtonUpdatePolicy_symbol, xg_GtkSpinButton__symbol, xg_GtkSizeGroupMode_symbol, xg_GtkSizeGroup__symbol, xg_GtkSettings__symbol, xg_GtkSelectionData__symbol, xg_GtkCornerType_symbol, xg_GtkPolicyType_symbol, xg_GtkScrolledWindow__symbol, xg_GtkScale__symbol, xg_GtkRange__symbol, xg_GtkRadioMenuItem__symbol, xg_GtkRadioButton__symbol, xg_GtkProgressBar__symbol, xg_GtkPaned__symbol, xg_GtkPositionType_symbol, xg_GtkNotebook__symbol, xg_GtkMenuShell__symbol, xg_gint__symbol, xg_GtkMenuItem__symbol, xg_GtkMenu__symbol, xg_PangoLanguage__symbol, xg_GtkListStore__symbol, xg_GtkLayout__symbol, xg_GtkJustification_symbol, xg_GtkLabel__symbol, xg_guint16__symbol, xg_GtkIMContextSimple__symbol, xg_GdkEventKey__symbol, xg_PangoAttrList__symbol, xg_GtkIMContext__symbol, xg_GtkImageType_symbol, xg_GtkImage__symbol, xg_GtkShadowType_symbol, xg_GtkFrame__symbol, xg_GtkFixed__symbol, xg_PangoLayout__symbol, xg_GtkEntry__symbol, xg_GtkEditable__symbol, xg_GdkAtom_symbol, xg_etc_symbol, xg_GtkDialog__symbol, xg_GtkCallback_symbol, xg_GtkContainer__symbol, xg_GtkCheckMenuItem__symbol, xg_GtkCellRendererToggle__symbol, xg_GtkCellRendererText__symbol, xg_GtkCellRendererState_symbol, xg_GtkCellEditable__symbol, xg_GtkCalendar__symbol, xg_GtkReliefStyle_symbol, xg_GtkButton__symbol, xg_GtkBox__symbol, xg_GtkBin__symbol, xg_GtkBindingSet__symbol, xg_GtkButtonBox__symbol, xg_GtkButtonBoxStyle_symbol, xg_GtkAspectFrame__symbol, xg_GtkAdjustment__symbol, xg_GtkAccelMapForeach_symbol, xg_GtkAccelLabel__symbol, xg_GtkAccelGroupEntry__symbol, xg_lambda3_symbol, xg_GSList__symbol, xg_GObject__symbol, xg_GtkAccelFlags_symbol, xg_GtkAccelGroup__symbol, xg_GdkInterpType_symbol, xg_double_symbol, xg_gfloat_symbol, xg_guchar_symbol, xg_char___symbol, xg_GdkPixbufDestroyNotify_symbol, xg_GError__symbol, xg_char__symbol, xg_guchar__symbol, xg_int_symbol, xg_GdkPixbuf__symbol, xg_GdkColorspace_symbol, xg_GdkCursor__symbol, xg_GdkWindowTypeHint_symbol, xg_GdkWindowHints_symbol, xg_GdkGeometry__symbol, xg_GdkWindowEdge_symbol, xg_GdkWMFunction_symbol, xg_GdkWMDecoration_symbol, xg_GdkEventMask_symbol, xg_GList__symbol, xg_GdkWindowState_symbol, xg_GdkFilterFunc_symbol, xg_GdkWindowType_symbol, xg_PangoDirection_symbol, xg_GdkKeymapKey__symbol, xg_GdkKeymap__symbol, xg_GdkRectangle__symbol, xg_GdkEventFunc_symbol, xg_gdouble_symbol, xg_guint32_symbol, xg_GdkDragAction_symbol, xg_GdkDragContext__symbol, xg_GSignalMatchType_symbol, xg_GConnectFlags_symbol, xg_GtkDestroyNotify_symbol, xg_GSignalEmissionHook_symbol, xg_gulong_symbol, xg_GSignalInvocationHint__symbol, xg_GQuark_symbol, xg_guint__symbol, xg_GSignalQuery__symbol, xg_GType__symbol, xg_GSignalCMarshaller_symbol, xg_gpointer_symbol, xg_GSignalAccumulator_symbol, xg_GSignalFlags_symbol, xg_GType_symbol, xg_GClosureNotify_symbol, xg_GCallback_symbol, xg_GNormalizeMode_symbol, xg_glong_symbol, xg_gssize_symbol, xg_gsize_symbol, xg_gunichar__symbol, xg_void_symbol, xg_GtkDrawingArea__symbol, xg_GdkSeat__symbol, xg_GtkRecentInfo__symbol, xg_GLogLevelFlags_symbol, xg_GtkIconView__symbol, xg_GtkEntryCompletion__symbol, xg_GtkFileFilterInfo__symbol, xg_GtkTreeSelection__symbol, xg_GtkCellRenderer__symbol, xg_gint_symbol, xg_GtkTreeViewColumn__symbol, xg_GtkTreeView__symbol, xg_gunichar_symbol, xg_GtkTreeIter__symbol, xg_GtkTreePath__symbol, xg_GtkTreeModel__symbol, xg_gboolean_symbol, xg_GdkModifierType_symbol, xg_guint_symbol, xg_gchar__symbol, xg_GtkTextTag__symbol, xg_GdkXEvent__symbol, xg_GtkWidget__symbol, xg_lambda_data_symbol, xg_GClosure__symbol, xg_GtkAccelKey__symbol, xg_GdkEventMotion__symbol, xg_gdouble__symbol, xg_GdkEventAny__symbol, xg_GdkEvent__symbol, xg_GdkWindow__symbol, xg_cairo_t__symbol, xg_cairo_font_options_t__symbol, xg_PangoFontDescription__symbol, xg_idler_symbol, xg_GtkCellRendererPixbuf__symbol, xg_GtkSeparator__symbol, xg_GtkSeparatorMenuItem__symbol, xg_GdkEventExpose__symbol, xg_GdkEventNoExpose__symbol, xg_GdkEventVisibility__symbol, xg_GdkEventButton__symbol, xg_GdkEventCrossing__symbol, xg_GdkEventFocus__symbol, xg_GdkEventConfigure__symbol, xg_GdkEventProperty__symbol, xg_GdkEventSelection__symbol, xg_GdkEventProximity__symbol, xg_GdkEventSetting__symbol, xg_GdkEventWindowState__symbol, xg_GdkEventDND__symbol, xg_GtkFileChooserDialog__symbol, xg_GtkFileChooserWidget__symbol, xg_GtkColorButton__symbol, xg_GtkAccelMap_symbol, xg_GtkCellRendererCombo__symbol, xg_GtkCellRendererProgress__symbol, xg_GtkCellRendererAccel__symbol, xg_GtkCellRendererSpin__symbol, xg_GtkRecentChooserDialog__symbol, xg_GtkRecentChooserWidget__symbol, xg_GtkCellRendererSpinner__symbol, xg_gboolean__symbol, xg_GtkFontChooserDialog__symbol, xg_GtkFontChooserWidget__symbol, xg_GtkColorChooserDialog__symbol, xg_GtkColorChooserWidget__symbol, xg_GtkColorWidget__symbol, xg_GtkGestureLongPress__symbol;

#define wrap_for_Xen(Name, Value) Xen_list_2(xg_ ## Name ## _symbol, Xen_wrap_C_pointer(Value))
#define is_wrapped(Name, Value) (Xen_is_pair(Value) && (Xen_car(Value) == xg_ ## Name ## _symbol))

#define Xm_type(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {return(Xen_list_2(xg_ ## Name ## _symbol, C_ulong_to_Xen_ulong(val)));} \
  static XType Xen_to_C_ ## Name (Xen val) {return((XType)Xen_ulong_to_C_ulong(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_1(Name, XType) \
  static XType Xen_to_C_ ## Name (Xen val) {return((XType)Xen_ulong_to_C_ulong(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_no_p_2(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {return(wrap_for_Xen(Name, val));}

#define Xm_type_Ptr(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {if (val) return(wrap_for_Xen(Name, val)); return(Xen_false);} \
  static XType Xen_to_C_ ## Name (Xen val) {if (Xen_is_false(val)) return(NULL); return((XType)Xen_unwrap_C_pointer(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_Ptr_const(Name, XType) \
  static Xen C_to_Xen_ ## Name (const XType val) {if (val) return(wrap_for_Xen(Name, val)); return(Xen_false);} \
  static const XType Xen_to_C_ ## Name (Xen val) {if (Xen_is_false(val)) return(NULL); return((const XType)Xen_unwrap_C_pointer(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_Ptr_1(Name, XType) \
  static XType Xen_to_C_ ## Name (Xen val) {if (Xen_is_false(val)) return(NULL); return((XType)Xen_unwrap_C_pointer(Xen_cadr(val)));} \
  static bool Xen_is_ ## Name (Xen val) {return(is_wrapped(Name, val));}

#define Xm_type_Ptr_2(Name, XType) \
  static Xen C_to_Xen_ ## Name (XType val) {if (val) return(wrap_for_Xen(Name, val)); return(Xen_false);} \

/* type checks for callback wrappers */
#define Xen_is_lambda3(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkCallback(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GSourceFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 1)))
#define Xen_is_GtkDestroyNotify(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 1)))
#define Xen_is_GdkFilterFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GdkEventFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkTextTagTableForeach(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkAccelMapForeach(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeModelForeachFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeSelectionForeachFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTextCharPredicate(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkTreeViewColumnDropFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeViewMappingFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkTreeViewSearchEqualFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeCellDataFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkTreeIterCompareFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeSelectionFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 5)))
#define Xen_is_GtkFileFilterFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkEntryCompletionMatchFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeViewRowSeparatorFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkIconViewForeachFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GLogFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 4)))
#define Xen_is_GtkTreeViewSearchPositionFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkAssistantPageFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GtkRecentSortFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GdkSeatGrabPrepareFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 3)))
#define Xen_is_GtkDrawingAreaFunc(Arg)  Xen_is_false(Arg) || (Xen_is_procedure(Arg) && (Xen_is_aritable(Arg, 2)))
#define Xen_is_GCallback(Arg) (Xen_is_procedure(Arg) && ((Xen_is_aritable(Arg, 2)) || (Xen_is_aritable(Arg, 3)) || (Xen_is_aritable(Arg, 4))))
#define Xen_to_C_lambda3(Arg) Xen_is_false(Arg) ? NULL : gxg_find_func
#define Xen_to_C_GtkCallback(Arg) Xen_is_false(Arg) ? NULL : gxg_func2
#define Xen_to_C_GSourceFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_timer_func
#define Xen_to_C_GtkDestroyNotify(Arg) Xen_is_false(Arg) ? NULL : gxg_destroy_func
#define Xen_to_C_GdkFilterFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_filter_func
#define Xen_to_C_GdkEventFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_event_func
#define Xen_to_C_GtkTextTagTableForeach(Arg) Xen_is_false(Arg) ? NULL : gxg_text_tag_table_foreach
#define Xen_to_C_GtkAccelMapForeach(Arg) Xen_is_false(Arg) ? NULL : gxg_accel_map_foreach
#define Xen_to_C_GtkTreeModelForeachFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_model_func
#define Xen_to_C_GtkTreeSelectionForeachFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_selection_func
#define Xen_to_C_GtkTextCharPredicate(Arg) Xen_is_false(Arg) ? NULL : gxg_text_char_predicate
#define Xen_to_C_GtkTreeViewColumnDropFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_column
#define Xen_to_C_GtkTreeViewMappingFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_mapping
#define Xen_to_C_GtkTreeViewSearchEqualFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_search
#define Xen_to_C_GtkTreeCellDataFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_cell_data
#define Xen_to_C_GtkTreeIterCompareFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_iter_compare
#define Xen_to_C_GtkTreeSelectionFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_tree_selection
#define Xen_to_C_GtkFileFilterFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_file_filter
#define Xen_to_C_GtkEntryCompletionMatchFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_entry_completion_match
#define Xen_to_C_GtkTreeViewRowSeparatorFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_row_separator
#define Xen_to_C_GtkIconViewForeachFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_icon_view_foreach
#define Xen_to_C_GLogFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_g_message_log_func
#define Xen_to_C_GtkTreeViewSearchPositionFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_search_position
#define Xen_to_C_GtkAssistantPageFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_page_func
#define Xen_to_C_GtkRecentSortFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_recent_sort
#define Xen_to_C_GdkSeatGrabPrepareFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_prepare_func
#define Xen_to_C_GtkDrawingAreaFunc(Arg) Xen_is_false(Arg) ? NULL : gxg_draw_func
#define Xen_to_C_GCallback(Arg) ((Xen_is_aritable(Arg, 4)) ? (GCallback)gxg_func4 : ((Xen_is_aritable(Arg, 3)) ? (GCallback)gxg_func3 : (GCallback)gxg_func2))
#define Xen_to_C_lambda_data(Arg) (gpointer)gxg_ptr
#define Xen_is_lambda_data(Arg) 1
#define C_to_Xen_GtkTreeViewSearchPositionFunc(Arg) wrap_for_Xen(GtkTreeViewSearchPositionFunc, Arg)
#define C_to_Xen_GtkTreeViewSearchEqualFunc(Arg) wrap_for_Xen(GtkTreeViewSearchEqualFunc, Arg)
#define Xen_to_C_GdkFilterReturn(Arg) (GdkFilterReturn)Xen_integer_to_C_int(Arg)
#define C_to_Xen_String(Arg) C_string_to_Xen_string((char *)Arg)
static Xen C_to_Xen_GError_(GError *err)
{
  if (err)
    {
      Xen msg;
      msg = C_string_to_Xen_string(err->message);
      g_error_free(err);
      return(msg);
    }
  return(Xen_false);
}


/* ---------------------------------------- types ---------------------------------------- */

Xm_type_Ptr(PangoFontDescription_, PangoFontDescription*)
Xm_type_Ptr(cairo_font_options_t_, cairo_font_options_t*)
Xm_type_Ptr(cairo_t_, cairo_t*)
Xm_type_Ptr(GdkWindow_, GdkWindow*)
Xm_type_Ptr(GdkEvent_, GdkEvent*)
Xm_type_Ptr_2(GdkEventAny_, GdkEventAny*)
Xm_type_Ptr_1(gdouble_, gdouble*)
Xm_type_Ptr_1(GdkEventMotion_, GdkEventMotion*)
Xm_type_Ptr(GtkAccelKey_, GtkAccelKey*)
Xm_type_Ptr(GClosure_, GClosure*)
Xm_type_Ptr(GtkWidget_, GtkWidget*)
Xm_type_Ptr_2(GdkXEvent_, GdkXEvent*)
Xm_type_Ptr(GtkTextTag_, GtkTextTag*)
#define C_to_Xen_gchar_(Arg) C_string_to_Xen_string(Arg)
#define Xen_to_C_gchar_(Arg) (gchar*)(Xen_string_to_C_string(Arg))
#define Xen_is_gchar_(Arg) Xen_is_string(Arg)
#define C_to_Xen_guint(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_guint(Arg) (guint)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_guint(Arg) Xen_is_ulong(Arg)
#define C_to_Xen_GdkModifierType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkModifierType(Arg) (GdkModifierType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkModifierType(Arg) Xen_is_integer(Arg)
#define C_to_Xen_gboolean(Arg) C_bool_to_Xen_boolean(Arg)
#define Xen_to_C_gboolean(Arg) (gboolean)(Xen_boolean_to_C_bool(Arg))
#define Xen_is_gboolean(Arg) Xen_is_boolean(Arg)
Xm_type_Ptr(GtkTreeModel_, GtkTreeModel*)
Xm_type_Ptr(GtkTreePath_, GtkTreePath*)
Xm_type_Ptr(GtkTreeIter_, GtkTreeIter*)
#define C_to_Xen_gunichar(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_gunichar(Arg) (gunichar)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_gunichar(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr(GtkTreeView_, GtkTreeView*)
Xm_type_Ptr(GtkTreeViewColumn_, GtkTreeViewColumn*)
#define C_to_Xen_gint(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_gint(Arg) (gint)(Xen_integer_to_C_int(Arg))
#define Xen_is_gint(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkCellRenderer_, GtkCellRenderer*)
Xm_type_Ptr(GtkTreeSelection_, GtkTreeSelection*)
Xm_type_Ptr(GtkFileFilterInfo_, GtkFileFilterInfo*)
Xm_type_Ptr(GtkEntryCompletion_, GtkEntryCompletion*)
Xm_type_Ptr(GtkIconView_, GtkIconView*)
#define C_to_Xen_GLogLevelFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GLogLevelFlags(Arg) (GLogLevelFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GLogLevelFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkRecentInfo_, GtkRecentInfo*)
#define Xen_to_C_gunichar_(Arg) (gunichar*)(Xen_string_to_C_string(Arg))
#define Xen_is_gunichar_(Arg) Xen_is_string(Arg)
#define C_to_Xen_gsize(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_gsize(Arg) (gsize)(Xen_integer_to_C_int(Arg))
#define Xen_is_gsize(Arg) Xen_is_integer(Arg)
#define Xen_to_C_gssize(Arg) (gssize)(Xen_integer_to_C_int(Arg))
#define Xen_is_gssize(Arg) Xen_is_integer(Arg)
#define C_to_Xen_glong(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GNormalizeMode(Arg) (GNormalizeMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GNormalizeMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GClosureNotify, GClosureNotify)
#define C_to_Xen_GType(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_GType(Arg) (GType)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_GType(Arg) Xen_is_ulong(Arg)
#define Xen_to_C_GSignalFlags(Arg) (GSignalFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GSignalFlags(Arg) Xen_is_integer(Arg)
Xm_type_1(GSignalAccumulator, GSignalAccumulator)
Xm_type_Ptr(gpointer, gpointer)
Xm_type_1(GSignalCMarshaller, GSignalCMarshaller)
Xm_type_Ptr_1(GType_, GType*)
Xm_type_Ptr_1(GSignalQuery_, GSignalQuery*)
Xm_type_Ptr(guint_, guint*)
#define C_to_Xen_GQuark(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_GQuark(Arg) (GQuark)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_GQuark(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr_2(GSignalInvocationHint_, GSignalInvocationHint*)
#define C_to_Xen_gulong(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_gulong(Arg) (gulong)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_gulong(Arg) Xen_is_ulong(Arg)
Xm_type_1(GSignalEmissionHook, GSignalEmissionHook)
#define Xen_to_C_GConnectFlags(Arg) (GConnectFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GConnectFlags(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GSignalMatchType(Arg) (GSignalMatchType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GSignalMatchType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkDragContext_, GdkDragContext*)
#define Xen_to_C_GdkDragAction(Arg) (GdkDragAction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkDragAction(Arg) Xen_is_integer(Arg)
#define C_to_Xen_guint32(Arg) C_ulong_to_Xen_ulong(Arg)
#define Xen_to_C_guint32(Arg) (guint32)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_guint32(Arg) Xen_is_ulong(Arg)
#define C_to_Xen_gdouble(Arg) C_double_to_Xen_real(Arg)
#define Xen_to_C_gdouble(Arg) (gdouble)(Xen_real_to_C_double(Arg))
#define Xen_is_gdouble(Arg) Xen_is_number(Arg)
Xm_type_Ptr_1(GdkRectangle_, GdkRectangle*)
Xm_type_Ptr(GdkKeymap_, GdkKeymap*)
Xm_type_Ptr(GdkKeymapKey_, GdkKeymapKey*)
#define C_to_Xen_PangoDirection(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoDirection(Arg) (PangoDirection)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoDirection(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GdkWindowType(Arg) C_int_to_Xen_integer(Arg)
#define C_to_Xen_GdkWindowState(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(GList_, GList*)
#define C_to_Xen_GdkEventMask(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkEventMask(Arg) (GdkEventMask)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkEventMask(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GdkWMDecoration(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkWMDecoration(Arg) (GdkWMDecoration)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkWMDecoration(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GdkWMFunction(Arg) (GdkWMFunction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkWMFunction(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GdkWindowEdge(Arg) (GdkWindowEdge)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkWindowEdge(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GdkGeometry_, GdkGeometry*)
#define Xen_to_C_GdkWindowHints(Arg) (GdkWindowHints)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkWindowHints(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GdkWindowTypeHint(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkWindowTypeHint(Arg) (GdkWindowTypeHint)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkWindowTypeHint(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkCursor_, GdkCursor*)
#define C_to_Xen_GdkColorspace(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkColorspace(Arg) (GdkColorspace)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkColorspace(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkPixbuf_, GdkPixbuf*)
#define C_to_Xen_int(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_int(Arg) (int)(Xen_integer_to_C_int(Arg))
#define Xen_is_int(Arg) Xen_is_integer(Arg)
#define C_to_Xen_guchar_(Arg) C_to_Xen_String(Arg)
#define Xen_to_C_guchar_(Arg) (guchar*)(Xen_string_to_C_string(Arg))
#define Xen_is_guchar_(Arg) Xen_is_string(Arg)
#define C_to_Xen_char_(Arg) C_string_to_Xen_string(Arg)
#define Xen_to_C_char_(Arg) (char*)(Xen_string_to_C_string(Arg))
#define Xen_is_char_(Arg) Xen_is_string(Arg)
Xm_type_1(GdkPixbufDestroyNotify, GdkPixbufDestroyNotify)
Xm_type_Ptr(char__, char**)
#define C_to_Xen_guchar(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_guchar(Arg) (guchar)(Xen_integer_to_C_int(Arg))
#define Xen_is_guchar(Arg) Xen_is_integer(Arg)
#define C_to_Xen_gfloat(Arg) C_double_to_Xen_real(Arg)
#define Xen_to_C_gfloat(Arg) (gfloat)(Xen_real_to_C_double(Arg))
#define Xen_is_gfloat(Arg) Xen_is_number(Arg)
#define C_to_Xen_double(Arg) C_double_to_Xen_real(Arg)
#define Xen_to_C_double(Arg) (double)(Xen_real_to_C_double(Arg))
#define Xen_to_C_GdkInterpType(Arg) (GdkInterpType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkInterpType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkAccelGroup_, GtkAccelGroup*)
#define Xen_to_C_GtkAccelFlags(Arg) (GtkAccelFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkAccelFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GObject_, GObject*)
Xm_type_Ptr(GSList_, GSList*)
Xm_type_Ptr_2(GtkAccelGroupEntry_, GtkAccelGroupEntry*)
Xm_type_Ptr_1(GtkAccelLabel_, GtkAccelLabel*)
Xm_type_Ptr(GtkAdjustment_, GtkAdjustment*)
Xm_type_Ptr_1(GtkAspectFrame_, GtkAspectFrame*)
#define C_to_Xen_GtkButtonBoxStyle(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkButtonBoxStyle(Arg) (GtkButtonBoxStyle)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkButtonBoxStyle(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkButtonBox_, GtkButtonBox*)
Xm_type_Ptr(GtkBindingSet_, GtkBindingSet*)
Xm_type_Ptr_1(GtkBin_, GtkBin*)
Xm_type_Ptr_1(GtkBox_, GtkBox*)
Xm_type_Ptr_1(GtkButton_, GtkButton*)
#define C_to_Xen_GtkReliefStyle(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkReliefStyle(Arg) (GtkReliefStyle)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkReliefStyle(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkCalendar_, GtkCalendar*)
Xm_type_Ptr(GtkCellEditable_, GtkCellEditable*)
#define Xen_to_C_GtkCellRendererState(Arg) (GtkCellRendererState)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkCellRendererState(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkCellRendererText_, GtkCellRendererText*)
Xm_type_Ptr_1(GtkCellRendererToggle_, GtkCellRendererToggle*)
Xm_type_Ptr_1(GtkCheckMenuItem_, GtkCheckMenuItem*)
Xm_type_Ptr_1(GtkContainer_, GtkContainer*)
Xm_type_Ptr_1(GtkDialog_, GtkDialog*)
#define Xen_is_etc(Arg) (Xen_is_list(Arg))
Xm_type(GdkAtom, GdkAtom)
Xm_type_Ptr_1(GtkEditable_, GtkEditable*)
Xm_type_Ptr(GtkEntry_, GtkEntry*)
Xm_type_Ptr(PangoLayout_, PangoLayout*)
Xm_type_Ptr_1(GtkFixed_, GtkFixed*)
Xm_type_Ptr_1(GtkFrame_, GtkFrame*)
#define C_to_Xen_GtkShadowType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkShadowType(Arg) (GtkShadowType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkShadowType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkImage_, GtkImage*)
#define C_to_Xen_GtkImageType(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(GtkIMContext_, GtkIMContext*)
Xm_type_Ptr(PangoAttrList_, PangoAttrList*)
Xm_type_Ptr_1(GdkEventKey_, GdkEventKey*)
Xm_type_Ptr_1(GtkIMContextSimple_, GtkIMContextSimple*)
Xm_type_Ptr_1(guint16_, guint16*)
Xm_type_Ptr_1(GtkLabel_, GtkLabel*)
#define C_to_Xen_GtkJustification(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkJustification(Arg) (GtkJustification)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkJustification(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkLayout_, GtkLayout*)
Xm_type_Ptr(GtkListStore_, GtkListStore*)
Xm_type_Ptr(PangoLanguage_, PangoLanguage*)
Xm_type_Ptr(GtkMenu_, GtkMenu*)
Xm_type_Ptr_1(GtkMenuItem_, GtkMenuItem*)
Xm_type_Ptr(gint_, gint*)
Xm_type_Ptr_1(GtkMenuShell_, GtkMenuShell*)
Xm_type_Ptr_1(GtkNotebook_, GtkNotebook*)
#define C_to_Xen_GtkPositionType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPositionType(Arg) (GtkPositionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPositionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkPaned_, GtkPaned*)
Xm_type_Ptr_1(GtkProgressBar_, GtkProgressBar*)
Xm_type_Ptr_1(GtkRadioButton_, GtkRadioButton*)
Xm_type_Ptr_1(GtkRadioMenuItem_, GtkRadioMenuItem*)
Xm_type_Ptr_1(GtkRange_, GtkRange*)
Xm_type_Ptr_1(GtkScale_, GtkScale*)
Xm_type_Ptr_1(GtkScrolledWindow_, GtkScrolledWindow*)
#define C_to_Xen_GtkPolicyType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPolicyType(Arg) (GtkPolicyType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPolicyType(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkCornerType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkCornerType(Arg) (GtkCornerType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkCornerType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkSelectionData_, GtkSelectionData*)
Xm_type_Ptr(GtkSettings_, GtkSettings*)
Xm_type_Ptr(GtkSizeGroup_, GtkSizeGroup*)
#define C_to_Xen_GtkSizeGroupMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSizeGroupMode(Arg) (GtkSizeGroupMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSizeGroupMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkSpinButton_, GtkSpinButton*)
#define C_to_Xen_GtkSpinButtonUpdatePolicy(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSpinButtonUpdatePolicy(Arg) (GtkSpinButtonUpdatePolicy)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSpinButtonUpdatePolicy(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GtkSpinType(Arg) (GtkSpinType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSpinType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkStatusbar_, GtkStatusbar*)
Xm_type_Ptr(GtkTextBuffer_, GtkTextBuffer*)
Xm_type_Ptr(GtkTextTagTable_, GtkTextTagTable*)
Xm_type_Ptr(GtkTextIter_, GtkTextIter*)
Xm_type_Ptr(GtkTextChildAnchor_, GtkTextChildAnchor*)
Xm_type_Ptr(GtkTextMark_, GtkTextMark*)
#define Xen_to_C_GtkTextSearchFlags(Arg) (GtkTextSearchFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTextSearchFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTextView_, GtkTextView*)
#define C_to_Xen_GtkTextWindowType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTextWindowType(Arg) (GtkTextWindowType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTextWindowType(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkWrapMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkWrapMode(Arg) (GtkWrapMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkWrapMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoTabArray_, PangoTabArray*)
Xm_type_Ptr_1(GtkToggleButton_, GtkToggleButton*)
Xm_type_Ptr_1(GtkToolbar_, GtkToolbar*)
#define C_to_Xen_GtkToolbarStyle(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkToolbarStyle(Arg) (GtkToolbarStyle)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkToolbarStyle(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTreeDragSource_, GtkTreeDragSource*)
Xm_type_Ptr_1(GtkTreeDragDest_, GtkTreeDragDest*)
Xm_type_Ptr(GtkTreeRowReference_, GtkTreeRowReference*)
#define C_to_Xen_GtkTreeModelFlags(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GtkTreeModelSort_, GtkTreeModelSort*)
#define C_to_Xen_GtkSelectionMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSelectionMode(Arg) (GtkSelectionMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSelectionMode(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTreeModel__, GtkTreeModel**)
Xm_type_Ptr_1(GtkTreeSortable_, GtkTreeSortable*)
#define C_to_Xen_GtkSortType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSortType(Arg) (GtkSortType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSortType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkTreeStore_, GtkTreeStore*)
#define C_to_Xen_GtkTreeViewColumnSizing(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTreeViewColumnSizing(Arg) (GtkTreeViewColumnSizing)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTreeViewColumnSizing(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkTreeViewDropPosition(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTreeViewDropPosition(Arg) (GtkTreeViewDropPosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTreeViewDropPosition(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkViewport_, GtkViewport*)
#define Xen_to_C_GtkDirectionType(Arg) (GtkDirectionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkDirectionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_2(AtkObject_, AtkObject*)
Xm_type_Ptr(PangoContext_, PangoContext*)
#define C_to_Xen_GtkTextDirection(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTextDirection(Arg) (GtkTextDirection)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTextDirection(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkWindow_, GtkWindow*)
#define C_to_Xen_GtkWindowType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkWindowType(Arg) (GtkWindowType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkWindowType(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GtkWindowPosition(Arg) (GtkWindowPosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkWindowPosition(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GdkGravity(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkGravity(Arg) (GdkGravity)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkGravity(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoColor_, PangoColor*)
#define C_to_Xen_PangoAttrType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoAttrType(Arg) (PangoAttrType)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoAttrType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoAttribute_, PangoAttribute*)
#define C_to_Xen_guint16(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_guint16(Arg) (guint16)(Xen_integer_to_C_int(Arg))
#define Xen_is_guint16(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoStyle(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoStyle(Arg) (PangoStyle)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoStyle(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoWeight(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoWeight(Arg) (PangoWeight)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoWeight(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoVariant(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoVariant(Arg) (PangoVariant)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoVariant(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoStretch(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoStretch(Arg) (PangoStretch)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoStretch(Arg) Xen_is_integer(Arg)
#define Xen_to_C_PangoUnderline(Arg) (PangoUnderline)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoUnderline(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoRectangle_, PangoRectangle*)
Xm_type_Ptr(PangoAttrIterator_, PangoAttrIterator*)
Xm_type_Ptr_1(PangoAttrList__, PangoAttrList**)
Xm_type_Ptr_1(PangoAnalysis_, PangoAnalysis*)
Xm_type_Ptr(PangoLogAttr_, PangoLogAttr*)
Xm_type_Ptr_2(PangoFontFamily__, PangoFontFamily**)
Xm_type_Ptr(PangoFont_, PangoFont*)
Xm_type_Ptr_2(PangoFontset_, PangoFontset*)
Xm_type_Ptr(PangoFontMetrics_, PangoFontMetrics*)
Xm_type_Ptr(PangoCoverage_, PangoCoverage*)
#define C_to_Xen_PangoCoverageLevel(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoCoverageLevel(Arg) (PangoCoverageLevel)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoCoverageLevel(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoFontDescription__, PangoFontDescription**)
#define C_to_Xen_PangoFontMask(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoFontMask(Arg) (PangoFontMask)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoFontMask(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(PangoFontFamily_, PangoFontFamily*)
Xm_type_Ptr_2(PangoFontFace__, PangoFontFace**)
Xm_type_Ptr(PangoFontFace_, PangoFontFace*)
#define Xen_to_C_PangoGlyph(Arg) (PangoGlyph)(Xen_ulong_to_C_ulong(Arg))
#define Xen_is_PangoGlyph(Arg) Xen_is_ulong(Arg)
Xm_type_Ptr(PangoFontMap_, PangoFontMap*)
Xm_type_Ptr(PangoGlyphString_, PangoGlyphString*)
Xm_type_Ptr(PangoItem_, PangoItem*)
#define C_to_Xen_PangoWrapMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoWrapMode(Arg) (PangoWrapMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoWrapMode(Arg) Xen_is_integer(Arg)
#define C_to_Xen_PangoAlignment(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoAlignment(Arg) (PangoAlignment)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoAlignment(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(int_, int*)
Xm_type_Ptr(PangoLayoutLine_, PangoLayoutLine*)
Xm_type_Ptr(PangoLayoutIter_, PangoLayoutIter*)
Xm_type_Ptr_2(PangoLayoutRun_, PangoLayoutRun*)
Xm_type_Ptr(GdkDisplay_, GdkDisplay*)
#define C_to_Xen_GtkCalendarDisplayOptions(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkCalendarDisplayOptions(Arg) (GtkCalendarDisplayOptions)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkCalendarDisplayOptions(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkToolItem_, GtkToolItem*)
#define C_to_Xen_GtkFileChooserAction(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkFileChooserAction(Arg) (GtkFileChooserAction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkFileChooserAction(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTreeModelFilter_, GtkTreeModelFilter*)
Xm_type_Ptr_1(GtkComboBox_, GtkComboBox*)
Xm_type_Ptr_1(GtkExpander_, GtkExpander*)
Xm_type_Ptr_1(GtkFontButton_, GtkFontButton*)
Xm_type_Ptr_1(GtkRadioToolButton_, GtkRadioToolButton*)
Xm_type_Ptr_1(GtkSeparatorToolItem_, GtkSeparatorToolItem*)
Xm_type_Ptr_1(GtkToggleToolButton_, GtkToggleToolButton*)
Xm_type_Ptr(GtkFileFilter_, GtkFileFilter*)
#define C_to_Xen_GtkFileFilterFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkFileFilterFlags(Arg) (GtkFileFilterFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkFileFilterFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkCellLayout_, GtkCellLayout*)
Xm_type_1(GtkCellLayoutDataFunc, GtkCellLayoutDataFunc)
Xm_type_Ptr_1(GtkFileChooser_, GtkFileChooser*)
Xm_type_Ptr(GtkIconTheme_, GtkIconTheme*)
Xm_type_Ptr(gchar__, gchar**)
Xm_type_Ptr(GtkIconInfo_, GtkIconInfo*)
#define Xen_to_C_GtkIconLookupFlags(Arg) (GtkIconLookupFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkIconLookupFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkToolButton_, GtkToolButton*)
#define C_to_Xen_GtkOrientation(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkOrientation(Arg) (GtkOrientation)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkOrientation(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_2(GtkAccelMap_, GtkAccelMap*)
Xm_type_Ptr_1(GtkCellView_, GtkCellView*)
Xm_type_Ptr_1(GtkAboutDialog_, GtkAboutDialog*)
#define C_to_Xen_PangoEllipsizeMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_PangoEllipsizeMode(Arg) (PangoEllipsizeMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoEllipsizeMode(Arg) Xen_is_integer(Arg)
Xm_type_1(PangoAttrFilterFunc, PangoAttrFilterFunc)
#define C_to_Xen_PangoScript(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(PangoScriptIter_, PangoScriptIter*)
Xm_type_Ptr_1(GtkFileChooserButton_, GtkFileChooserButton*)
Xm_type_Ptr_1(GtkMenuToolButton_, GtkMenuToolButton*)
Xm_type_Ptr_1(PangoRenderer_, PangoRenderer*)
#define Xen_to_C_PangoRenderPart(Arg) (PangoRenderPart)(Xen_integer_to_C_int(Arg))
#define Xen_is_PangoRenderPart(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(PangoMatrix_, PangoMatrix*)
Xm_type_Ptr_1(GValue_, GValue*)
#define C_to_Xen_GtkIconViewDropPosition(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkIconViewDropPosition(Arg) (GtkIconViewDropPosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkIconViewDropPosition(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPackDirection(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPackDirection(Arg) (GtkPackDirection)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPackDirection(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkMenuBar_, GtkMenuBar*)
#define C_to_Xen_GtkSensitivityType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkSensitivityType(Arg) (GtkSensitivityType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkSensitivityType(Arg) Xen_is_integer(Arg)
Xm_type_1(GDestroyNotify, GDestroyNotify)
Xm_type_Ptr_1(GtkAssistant_, GtkAssistant*)
#define C_to_Xen_GtkAssistantPageType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkAssistantPageType(Arg) (GtkAssistantPageType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkAssistantPageType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkLinkButton_, GtkLinkButton*)
Xm_type_Ptr_1(GtkRecentChooser_, GtkRecentChooser*)
#define C_to_Xen_GtkRecentSortType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkRecentSortType(Arg) (GtkRecentSortType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkRecentSortType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkRecentFilter_, GtkRecentFilter*)
Xm_type_Ptr(GtkRecentManager_, GtkRecentManager*)
Xm_type_Ptr_1(GtkRecentChooserMenu_, GtkRecentChooserMenu*)
Xm_type_no_p_2(time_t, time_t)
Xm_type_Ptr_1(GtkRecentData_, GtkRecentData*)
#define C_to_Xen_GtkTreeViewGridLines(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkTreeViewGridLines(Arg) (GtkTreeViewGridLines)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkTreeViewGridLines(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPrintContext_, GtkPrintContext*)
Xm_type_Ptr(GtkPageSetup_, GtkPageSetup*)
Xm_type_Ptr(GtkPrintOperation_, GtkPrintOperation*)
Xm_type_Ptr(GtkPrintSettings_, GtkPrintSettings*)
#define Xen_to_C_GtkUnit(Arg) (GtkUnit)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkUnit(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintOperationResult(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintOperationAction(Arg) (GtkPrintOperationAction)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintOperationAction(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintStatus(Arg) C_int_to_Xen_integer(Arg)
Xm_type_1(GtkPageSetupDoneFunc, GtkPageSetupDoneFunc)
Xm_type_1(GtkPrintSettingsFunc, GtkPrintSettingsFunc)
#define C_to_Xen_GtkPageOrientation(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPageOrientation(Arg) (GtkPageOrientation)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPageOrientation(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPaperSize_, GtkPaperSize*)
#define C_to_Xen_GtkPrintDuplex(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintDuplex(Arg) (GtkPrintDuplex)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintDuplex(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintQuality(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintQuality(Arg) (GtkPrintQuality)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintQuality(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPrintPages(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPrintPages(Arg) (GtkPrintPages)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPrintPages(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPageRange_, GtkPageRange*)
#define C_to_Xen_GtkPageSet(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPageSet(Arg) (GtkPageSet)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPageSet(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkTooltip_, GtkTooltip*)
#if GTK_CHECK_VERSION(2, 14, 0)
Xm_type_1(GtkCalendarDetailFunc, GtkCalendarDetailFunc)
Xm_type_Ptr_1(GtkScaleButton_, GtkScaleButton*)
Xm_type_Ptr(GFile_, GFile*)
#endif

#if GTK_CHECK_VERSION(2, 16, 0)
#define Xen_to_C_GtkEntryIconPosition(Arg) (GtkEntryIconPosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkEntryIconPosition(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(2, 18, 0)
Xm_type_Ptr_1(GtkInfoBar_, GtkInfoBar*)
#define C_to_Xen_GtkMessageType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkMessageType(Arg) (GtkMessageType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkMessageType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkEntryBuffer_, GtkEntryBuffer*)
#endif

#if GTK_CHECK_VERSION(2, 20, 0)
Xm_type_Ptr_1(GtkSpinner_, GtkSpinner*)
#define C_to_Xen_GtkPackType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPackType(Arg) (GtkPackType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPackType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkToolPalette_, GtkToolPalette*)
Xm_type_Ptr(GtkToolItemGroup_, GtkToolItemGroup*)
#define Xen_to_C_GtkToolPaletteDragTargets(Arg) (GtkToolPaletteDragTargets)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkToolPaletteDragTargets(Arg) Xen_is_integer(Arg)
#define Xen_to_C_GtkDestDefaults(Arg) (GtkDestDefaults)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkDestDefaults(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 0, 0)
Xm_type_Ptr_1(GdkModifierType_, GdkModifierType*)
Xm_type_Ptr_1(GtkAccessible_, GtkAccessible*)
Xm_type_Ptr(GdkDevice_, GdkDevice*)
Xm_type_Ptr_1(GtkMessageDialog_, GtkMessageDialog*)
Xm_type_Ptr(cairo_region_t_, cairo_region_t*)
#define C_to_Xen_GtkSizeRequestMode(Arg) C_int_to_Xen_integer(Arg)
#define C_to_Xen_GtkAlign(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkAlign(Arg) (GtkAlign)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkAlign(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkComboBoxText_, GtkComboBoxText*)
Xm_type_Ptr(GdkRGBA_, GdkRGBA*)
Xm_type_Ptr_1(GtkGrid_, GtkGrid*)
Xm_type_Ptr_1(GtkScrollable_, GtkScrollable*)
#define C_to_Xen_GtkScrollablePolicy(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkScrollablePolicy(Arg) (GtkScrollablePolicy)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkScrollablePolicy(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkSwitch_, GtkSwitch*)
Xm_type_Ptr(GtkBorder_, GtkBorder*)
Xm_type_Ptr_1(GtkCellArea_, GtkCellArea*)
Xm_type_Ptr_1(GtkOrientable_, GtkOrientable*)
Xm_type_Ptr(GIcon_, GIcon*)
Xm_type_Ptr(GtkWindowGroup_, GtkWindowGroup*)
Xm_type_Ptr_1(GtkToolShell_, GtkToolShell*)
#define C_to_Xen_GtkStateFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkStateFlags(Arg) (GtkStateFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkStateFlags(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 2, 0)
Xm_type_Ptr_1(GtkWidgetPath_, GtkWidgetPath*)
Xm_type_Ptr_1(GtkOverlay_, GtkOverlay*)
#define C_to_Xen_GdkScrollDirection(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr_1(GtkFontChooser_, GtkFontChooser*)
#endif

#if GTK_CHECK_VERSION(3, 4, 0)
#define Xen_to_C_GdkModifierIntent(Arg) (GdkModifierIntent)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkModifierIntent(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(guint__, guint**)
Xm_type_Ptr(GMenuModel_, GMenuModel*)
Xm_type_Ptr_1(GtkApplication_, GtkApplication*)
Xm_type_Ptr_1(GtkApplicationWindow_, GtkApplicationWindow*)
Xm_type_Ptr_1(GtkColorChooser_, GtkColorChooser*)
#endif

#if GTK_CHECK_VERSION(3, 6, 0)
Xm_type_Ptr_1(GtkMenuButton_, GtkMenuButton*)
Xm_type_Ptr_1(GtkLevelBar_, GtkLevelBar*)
#define C_to_Xen_GtkLevelBarMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkLevelBarMode(Arg) (GtkLevelBarMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkLevelBarMode(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkInputPurpose(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkInputPurpose(Arg) (GtkInputPurpose)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkInputPurpose(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkInputHints(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkInputHints(Arg) (GtkInputHints)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkInputHints(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 8, 0)
#define C_to_Xen_GdkFullscreenMode(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkFullscreenMode(Arg) (GdkFullscreenMode)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkFullscreenMode(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 10, 0)
#define C_to_Xen_GtkBaselinePosition(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkBaselinePosition(Arg) (GtkBaselinePosition)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkBaselinePosition(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GtkPlacesOpenFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPlacesOpenFlags(Arg) (GtkPlacesOpenFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPlacesOpenFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkPlacesSidebar_, GtkPlacesSidebar*)
Xm_type_Ptr_1(GtkStackSwitcher_, GtkStackSwitcher*)
Xm_type_Ptr(GtkStack_, GtkStack*)
#define C_to_Xen_GtkStackTransitionType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkStackTransitionType(Arg) (GtkStackTransitionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkStackTransitionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkRevealer_, GtkRevealer*)
#define C_to_Xen_GtkRevealerTransitionType(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkRevealerTransitionType(Arg) (GtkRevealerTransitionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkRevealerTransitionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkHeaderBar_, GtkHeaderBar*)
Xm_type_Ptr(GtkListBoxRow_, GtkListBoxRow*)
Xm_type_Ptr_1(GtkListBox_, GtkListBox*)
Xm_type_Ptr_1(GtkSearchBar_, GtkSearchBar*)
#define C_to_Xen_GdkEventType(Arg) C_int_to_Xen_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 12, 0)
Xm_type_Ptr(GtkFlowBoxChild_, GtkFlowBoxChild*)
Xm_type_Ptr_1(GtkFlowBox_, GtkFlowBox*)
Xm_type_Ptr_1(GtkActionBar_, GtkActionBar*)
Xm_type_Ptr_1(GtkPopover_, GtkPopover*)
#endif

#if GTK_CHECK_VERSION(3, 14, 0)
Xm_type_Ptr_1(GtkAllocation_, GtkAllocation*)
Xm_type_Ptr(GtkGesture_, GtkGesture*)
#define C_to_Xen_GtkEventSequenceState(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkEventSequenceState(Arg) (GtkEventSequenceState)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkEventSequenceState(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GdkEventSequence_, GdkEventSequence*)
Xm_type_Ptr_1(GtkGestureDrag_, GtkGestureDrag*)
Xm_type_Ptr_1(GtkGesturePan_, GtkGesturePan*)
Xm_type_Ptr_1(GtkGestureMultiPress_, GtkGestureMultiPress*)
Xm_type_Ptr_1(GtkGestureRotate_, GtkGestureRotate*)
Xm_type_Ptr_1(GtkGestureSingle_, GtkGestureSingle*)
Xm_type_Ptr_1(GtkGestureSwipe_, GtkGestureSwipe*)
Xm_type_Ptr_1(GtkGestureZoom_, GtkGestureZoom*)
Xm_type_Ptr_1(GtkEventController_, GtkEventController*)
#define C_to_Xen_GtkPropagationPhase(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPropagationPhase(Arg) (GtkPropagationPhase)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPropagationPhase(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 16, 0)
Xm_type_Ptr_1(GtkGLArea_, GtkGLArea*)
Xm_type_Ptr(GdkGLContext_, GdkGLContext*)
Xm_type_Ptr_1(GtkStyleContext_, GtkStyleContext*)
Xm_type_Ptr_1(GtkPopoverMenu_, GtkPopoverMenu*)
Xm_type_Ptr_1(GtkSearchEntry_, GtkSearchEntry*)
Xm_type_Ptr_1(GtkStackSidebar_, GtkStackSidebar*)
#endif

#if GTK_CHECK_VERSION(3, 20, 0)
Xm_type_Ptr(GdkSeat_, GdkSeat*)
Xm_type_Ptr_1(GtkShortcutsWindow_, GtkShortcutsWindow*)
#define C_to_Xen_GtkPopoverConstraint(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkPopoverConstraint(Arg) (GtkPopoverConstraint)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPopoverConstraint(Arg) Xen_is_integer(Arg)
#define C_to_Xen_GdkGrabStatus(Arg) C_int_to_Xen_integer(Arg)
#define C_to_Xen_GdkSeatCapabilities(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkSeatCapabilities(Arg) (GdkSeatCapabilities)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkSeatCapabilities(Arg) Xen_is_integer(Arg)
#endif

#if GTK_CHECK_VERSION(3, 22, 0)
#define C_to_Xen_GdkAxisFlags(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(GdkDeviceTool_, GdkDeviceTool*)
Xm_type_Ptr(GdkMonitor_, GdkMonitor*)
#define C_to_Xen_GdkSubpixelLayout(Arg) C_int_to_Xen_integer(Arg)
Xm_type_Ptr(GdkDrawingContext_, GdkDrawingContext*)
Xm_type_Ptr_1(GdkDevicePad_, GdkDevicePad*)
#define Xen_to_C_GdkDevicePadFeature(Arg) (GdkDevicePadFeature)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkDevicePadFeature(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkPadController_, GtkPadController*)
Xm_type_Ptr_1(GActionGroup_, GActionGroup*)
Xm_type_Ptr_1(GtkPadActionEntry_, GtkPadActionEntry*)
#define Xen_to_C_GtkPadActionType(Arg) (GtkPadActionType)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkPadActionType(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkShortcutLabel_, GtkShortcutLabel*)
#endif

#if GTK_CHECK_VERSION(3, 99, 0)
Xm_type_Ptr_1(GtkDrawingArea_, GtkDrawingArea*)
Xm_type(GtkDrawingAreaDrawFunc, GtkDrawingAreaDrawFunc)
Xm_type_Ptr(GdkDrawContext_, GdkDrawContext*)
Xm_type_Ptr(GtkCheckButton_, GtkCheckButton*)
Xm_type_Ptr(GtkCenterBox_, GtkCenterBox*)
Xm_type_Ptr(GtkScrollbar_, GtkScrollbar*)
Xm_type_Ptr_1(GdkEventScroll_, GdkEventScroll*)
#define C_to_Xen_GdkCrossingMode(Arg) C_int_to_Xen_integer(Arg)
#define C_to_Xen_GdkNotifyType(Arg) C_int_to_Xen_integer(Arg)
#define C_to_Xen_GdkTouchpadGesturePhase(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GdkTouchpadGesturePhase(Arg) (GdkTouchpadGesturePhase)(Xen_integer_to_C_int(Arg))
#define Xen_is_GdkTouchpadGesturePhase(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkSnapshot_, GtkSnapshot*)
#define C_to_Xen_GtkEventControllerScrollFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkEventControllerScrollFlags(Arg) (GtkEventControllerScrollFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkEventControllerScrollFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GtkEventControllerScroll_, GtkEventControllerScroll*)
Xm_type_Ptr(GdkAppLaunchContext_, GdkAppLaunchContext*)
Xm_type_Ptr(GdkClipboard_, GdkClipboard*)
Xm_type_Ptr(GdkContentFormats_, GdkContentFormats*)
Xm_type_Ptr(GdkContentProvider_, GdkContentProvider*)
Xm_type_Ptr(GCancellable_, GCancellable*)
Xm_type(GAsyncReadyCallback, GAsyncReadyCallback)
Xm_type_Ptr(GAsyncResult_, GAsyncResult*)
Xm_type_Ptr(GInputStream_, GInputStream*)
Xm_type_Ptr(har__, har**)
Xm_type_Ptr(GdkTexture_, GdkTexture*)
Xm_type(va_list, va_list)
Xm_type_Ptr_1(GString_, GString*)
Xm_type(GdkContentFormatsBuilder, GdkContentFormatsBuilder)
Xm_type_Ptr(GdkContentFormatsBuilder_, GdkContentFormatsBuilder*)
Xm_type_Ptr(GOutputStream_, GOutputStream*)
Xm_type_Ptr(GdkContentSerializer_, GdkContentSerializer*)
Xm_type(GdkContentSerializeFunc, GdkContentSerializeFunc)
Xm_type_Ptr(GdkContentDeserializer_, GdkContentDeserializer*)
Xm_type(GdkContentDeserializeFunc, GdkContentDeserializeFunc)
Xm_type_Ptr(GBytes_, GBytes*)
Xm_type(GValue, GValue)
#define C_to_Xen_GtkIconSize(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkIconSize(Arg) (GtkIconSize)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkIconSize(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(GtkInvisible_, GtkInvisible*)
Xm_type_Ptr(GdkDisplay_gtk_invisible_get_display, GdkDisplay*gtk_invisible_get_display)
Xm_type_Ptr(GdkAtom_, GdkAtom*)
Xm_type_Ptr(GtkStyleProvider_, GtkStyleProvider*)
Xm_type_Ptr(GtkContentFormats_, GtkContentFormats*)
Xm_type(GApplicationFlags, GApplicationFlags)
#define C_to_Xen_GtkApplicationInhibitFlags(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_GtkApplicationInhibitFlags(Arg) (GtkApplicationInhibitFlags)(Xen_integer_to_C_int(Arg))
#define Xen_is_GtkApplicationInhibitFlags(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(GMenu_, GMenu*)
#endif

Xm_type_Ptr(cairo_surface_t_, cairo_surface_t*)
#define C_to_Xen_cairo_content_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_content_t(Arg) (cairo_content_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_content_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(cairo_pattern_t_, cairo_pattern_t*)
#define C_to_Xen_cairo_operator_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_operator_t(Arg) (cairo_operator_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_operator_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_antialias_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_antialias_t(Arg) (cairo_antialias_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_antialias_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_fill_rule_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_fill_rule_t(Arg) (cairo_fill_rule_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_fill_rule_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_line_cap_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_line_cap_t(Arg) (cairo_line_cap_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_line_cap_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_line_join_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_line_join_t(Arg) (cairo_line_join_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_line_join_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(cairo_matrix_t_, cairo_matrix_t*)
#define C_to_Xen_bool(Arg) C_bool_to_Xen_boolean(Arg)
#define Xen_to_C_bool(Arg) (bool)(Xen_boolean_to_C_bool(Arg))
#define Xen_is_bool(Arg) Xen_is_boolean(Arg)
#define C_to_Xen_cairo_status_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_status_t(Arg) (cairo_status_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_status_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_subpixel_order_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_subpixel_order_t(Arg) (cairo_subpixel_order_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_subpixel_order_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_hint_style_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_hint_style_t(Arg) (cairo_hint_style_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_hint_style_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_hint_metrics_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_hint_metrics_t(Arg) (cairo_hint_metrics_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_hint_metrics_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_font_slant_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_font_slant_t(Arg) (cairo_font_slant_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_font_slant_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_font_weight_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_font_weight_t(Arg) (cairo_font_weight_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_font_weight_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(cairo_scaled_font_t_, cairo_scaled_font_t*)
Xm_type_Ptr(cairo_glyph_t_, cairo_glyph_t*)
Xm_type_Ptr(cairo_font_face_t_, cairo_font_face_t*)
Xm_type_Ptr_1(cairo_font_extents_t_, cairo_font_extents_t*)
Xm_type_Ptr_1(cairo_text_extents_t_, cairo_text_extents_t*)
Xm_type_Ptr_1(cairo_user_data_key_t_, cairo_user_data_key_t*)
Xm_type_1(cairo_destroy_func_t, cairo_destroy_func_t)
Xm_type_Ptr(cairo_path_t_, cairo_path_t*)
#define C_to_Xen_cairo_format_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_format_t(Arg) (cairo_format_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_format_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_extend_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_extend_t(Arg) (cairo_extend_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_extend_t(Arg) Xen_is_integer(Arg)
#define C_to_Xen_cairo_filter_t(Arg) C_int_to_Xen_integer(Arg)
#define Xen_to_C_cairo_filter_t(Arg) (cairo_filter_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_filter_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr(void_, void*)
Xm_type_Ptr(cairo_rectangle_list_t_, cairo_rectangle_list_t*)
#if HAVE_CAIRO_1_8
Xm_type_Ptr(cairo_text_cluster_t_, cairo_text_cluster_t*)
#define Xen_to_C_cairo_text_cluster_flags_t(Arg) (cairo_text_cluster_flags_t)(Xen_integer_to_C_int(Arg))
#define Xen_is_cairo_text_cluster_flags_t(Arg) Xen_is_integer(Arg)
Xm_type_Ptr_1(cairo_glyph_t__, cairo_glyph_t**)
Xm_type_Ptr_1(cairo_text_cluster_t__, cairo_text_cluster_t**)
Xm_type_Ptr_1(cairo_text_cluster_flags_t_, cairo_text_cluster_flags_t*)
#define C_to_Xen_cairo_bool_t(Arg) C_int_to_Xen_integer(Arg)
#endif

#if HAVE_CAIRO_1_9_12 && GTK_CHECK_VERSION(3, 0, 0)
Xm_type_Ptr(cairo_device_t_, cairo_device_t*)
Xm_type_Ptr_1(cairo_rectangle_t_, cairo_rectangle_t*)
Xm_type_Ptr_1(double_, double*)
Xm_type_Ptr_1(cairo_rectangle_int_t_, cairo_rectangle_int_t*)
Xm_type_no_p_2(cairo_region_overlap_t, cairo_region_overlap_t)
#endif

#define XLS(a, b) Xen_to_C_gchar_(Xen_list_ref(a, b))
#define XLI(a, b) ((int)Xen_integer_to_C_int(Xen_list_ref(a, b)))
#define XLL(a, b) (Xen_llong_to_C_llong(Xen_list_ref(a, b)))
#define XLG(a, b) Xen_to_C_GType(Xen_list_ref(a, b))
#define XLT(a, b) Xen_to_C_GtkTextTag_(Xen_list_ref(a, b))
#define XLA(a, b) ((Xen_is_integer(Xen_list_ref(a, b))) ? ((gpointer)((intptr_t)XLL(a, b))) : ((Xen_is_string(Xen_list_ref(a, b))) ? ((gpointer)XLS(a, b)) : ((gpointer)XLG(a, b))))

/* -------------------------------- gc protection -------------------------------- */

static Xen xm_protected;
static int xm_protected_size = 0;
static Xen xm_gc_table;
static int last_xm_unprotect = NOT_A_GC_LOC;

static int xm_protect(Xen obj)
{
  int i, new_size;
  Xen new_table;
  if (last_xm_unprotect >= 0)
    {
      i = last_xm_unprotect;
      if (Xen_is_false(Xen_vector_ref(xm_protected, i)))
	{
	  Xen_vector_set(xm_protected, i, obj);
	  last_xm_unprotect = NOT_A_GC_LOC;
	  return(i);
	}
      last_xm_unprotect = NOT_A_GC_LOC;
    }
  for (i = 0; i < xm_protected_size; i++)
    if (Xen_is_false(Xen_vector_ref(xm_protected, i)))
      {
	Xen_vector_set(xm_protected, i, obj);
	return(i);
      }
  new_size = xm_protected_size * 2;
  new_table = Xen_make_vector(new_size, Xen_false);
  for (i = 0; i < xm_protected_size; i++)
    {
      Xen_vector_set(new_table, i, Xen_vector_ref(xm_protected, i));
      Xen_vector_set(xm_protected, i, Xen_false);
    }
  Xen_vector_set(new_table, xm_protected_size, obj);
  Xen_vector_set(xm_gc_table, 0, new_table);
  i = xm_protected_size;
  xm_protected_size = new_size;
  xm_protected = new_table;
  return(i);
}

static void xm_unprotect_at(int ind)
{
  Xen_vector_set(xm_protected, ind, Xen_false);
  last_xm_unprotect = ind;
}



/* ---------------------------------------- callback handlers ---------------------------------------- */

static gboolean gxg_find_func(GtkAccelKey* key, GClosure* closure, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_3_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkAccelKey_(key),
                                      C_to_Xen_GClosure_(closure),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_func2(GtkWidget* w, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_2_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkWidget_(w),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_timer_func(gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_1_arg(Xen_car((Xen)func_info),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_destroy_func(gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_1_arg(Xen_cadddr((Xen)func_info),
             Xen_cadr((Xen)func_info),
             __func__);
}

static GdkFilterReturn gxg_filter_func(GdkXEvent* xevent, GdkEvent* event, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((GdkFilterReturn)0);
  return(Xen_to_C_GdkFilterReturn(Xen_call_with_3_args(Xen_car((Xen)func_info),
                                             C_to_Xen_GdkXEvent_(xevent),
                                             C_to_Xen_GdkEvent_(event),
                                             Xen_cadr((Xen)func_info),
                                             __func__)));
}

static void gxg_event_func(GdkEvent* event, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_2_args(Xen_car((Xen)func_info),
             C_to_Xen_GdkEvent_(event),
             Xen_cadr((Xen)func_info),
             __func__);
}

static void gxg_text_tag_table_foreach(GtkTextTag* tag, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_2_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTextTag_(tag),
             Xen_cadr((Xen)func_info),
             __func__);
}

static void gxg_accel_map_foreach(gpointer func_info, const gchar* accel_path, guint accel_key, GdkModifierType accel_mods, gboolean changed)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_5_args(Xen_car((Xen)func_info),
             Xen_cadr((Xen)func_info),
             C_to_Xen_gchar_(accel_path),
             C_to_Xen_guint(accel_key),
             C_to_Xen_GdkModifierType(accel_mods),
             C_to_Xen_gboolean(changed),
             __func__);
}

static gboolean gxg_model_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_4_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_GtkTreePath_(path),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_tree_selection_func(GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_4_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeModel_(model),
             C_to_Xen_GtkTreePath_(path),
             C_to_Xen_GtkTreeIter_(iter),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_text_char_predicate(gunichar ch, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_2_args(Xen_car((Xen)func_info),
                                      C_to_Xen_gunichar(ch),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_tree_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, GtkTreeViewColumn* prev_column, GtkTreeViewColumn* next_column, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_5_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeView_(tree_view),
                                      C_to_Xen_GtkTreeViewColumn_(column),
                                      C_to_Xen_GtkTreeViewColumn_(prev_column),
                                      C_to_Xen_GtkTreeViewColumn_(next_column),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_tree_mapping(GtkTreeView* tree_view, GtkTreePath* path, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_3_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeView_(tree_view),
             C_to_Xen_GtkTreePath_(path),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gboolean gxg_tree_search(GtkTreeModel* model, gint column, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_5_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_gint(column),
                                      C_to_Xen_gchar_(key),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_cell_data(GtkTreeViewColumn* tree_column, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_5_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeViewColumn_(tree_column),
             C_to_Xen_GtkCellRenderer_(cell),
             C_to_Xen_GtkTreeModel_(tree_model),
             C_to_Xen_GtkTreeIter_(iter),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gint gxg_iter_compare(GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gint)0);
  return(Xen_to_C_gint(Xen_call_with_4_args(Xen_car((Xen)func_info),
                                  C_to_Xen_GtkTreeModel_(model),
                                  C_to_Xen_GtkTreeIter_(a),
                                  C_to_Xen_GtkTreeIter_(b),
                                  Xen_cadr((Xen)func_info),
                                  __func__)));
}

static gboolean gxg_tree_selection(GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_5_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeSelection_(selection),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_GtkTreePath_(path),
                                      C_to_Xen_gboolean(path_currently_selected),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_file_filter(const GtkFileFilterInfo* info, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_2_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkFileFilterInfo_((GtkFileFilterInfo *)info),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_entry_completion_match(GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_4_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkEntryCompletion_(completion),
                                      C_to_Xen_gchar_(key),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static gboolean gxg_row_separator(GtkTreeModel* model, GtkTreeIter* iter, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gboolean)0);
  return(Xen_to_C_gboolean(Xen_call_with_3_args(Xen_car((Xen)func_info),
                                      C_to_Xen_GtkTreeModel_(model),
                                      C_to_Xen_GtkTreeIter_(iter),
                                      Xen_cadr((Xen)func_info),
                                      __func__)));
}

static void gxg_icon_view_foreach(GtkIconView* icon_view, GtkTreePath* path, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_3_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkIconView_(icon_view),
             C_to_Xen_GtkTreePath_(path),
             Xen_cadr((Xen)func_info),
             __func__);
}

static void gxg_g_message_log_func(const gchar* domain, GLogLevelFlags log_level, const gchar* message, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_4_args(Xen_car((Xen)func_info),
             C_to_Xen_gchar_(domain),
             C_to_Xen_GLogLevelFlags(log_level),
             C_to_Xen_gchar_(message),
             Xen_cadr((Xen)func_info),
             __func__);
}

static void gxg_search_position(GtkTreeView* tree_view, GtkWidget* search_dialog, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_3_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkTreeView_(tree_view),
             C_to_Xen_GtkWidget_(search_dialog),
             Xen_cadr((Xen)func_info),
             __func__);
}

static gint gxg_page_func(gint current_page, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gint)0);
  return(Xen_to_C_gint(Xen_call_with_2_args(Xen_car((Xen)func_info),
                                  C_to_Xen_gint(current_page),
                                  Xen_cadr((Xen)func_info),
                                  __func__)));
}

static gint gxg_recent_sort(GtkRecentInfo* a, GtkRecentInfo* b, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return((gint)0);
  return(Xen_to_C_gint(Xen_call_with_3_args(Xen_car((Xen)func_info),
                                  C_to_Xen_GtkRecentInfo_(a),
                                  C_to_Xen_GtkRecentInfo_(b),
                                  Xen_cadr((Xen)func_info),
                                  __func__)));
}

#if GTK_CHECK_VERSION(3, 20, 0)
static void gxg_prepare_func(GdkSeat* seat, GdkWindow* window, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_3_args(Xen_car((Xen)func_info),
             C_to_Xen_GdkSeat_(seat),
             C_to_Xen_GdkWindow_(window),
             Xen_cadr((Xen)func_info),
             __func__);
}
#endif

#if GTK_CHECK_VERSION(3, 99, 0)
static void gxg_draw_func(GtkDrawingArea* self, gpointer func_info)
{
  if (!Xen_is_list((Xen)func_info)) return;
  Xen_call_with_2_args(Xen_car((Xen)func_info),
             C_to_Xen_GtkDrawingArea_(self),
             Xen_cadr((Xen)func_info),
             __func__);
}
#endif


static gboolean gxg_func3(GtkWidget *w, GdkEventAny *ev, gpointer data)
{
  return(Xen_boolean_to_C_bool(Xen_call_with_3_args(Xen_car((Xen)data),
                                     C_to_Xen_GtkWidget_(w),
                                     C_to_Xen_GdkEventAny_(ev),
                                     Xen_cadr((Xen)data),
                                     __func__)));
}

static gboolean gxg_func4(GtkPrintOperation *op, GtkPrintContext *context, gint page_nr, gpointer data)
{
  return(Xen_boolean_to_C_bool(Xen_call_with_4_args(Xen_car((Xen)data),
                                     C_to_Xen_GtkPrintOperation_(op),
                                     C_to_Xen_GtkPrintContext_(context),
                                     C_int_to_Xen_integer(page_nr),
                                     Xen_cadr((Xen)data),
                                     __func__)));
}

#if (!GTK_CHECK_VERSION(3, 90, 0))
static Xen gxg_gtk_widget_set_events(Xen widget, Xen events)
{
  #define H_gtk_widget_set_events "void gtk_widget_set_events(GtkWidget* widget, gint events)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_events", "GtkWidget*");
  Xen_check_type(Xen_is_gint(events), events, 2, "gtk_widget_set_events", "gint");
  gtk_widget_set_events(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(events));
  return(Xen_false);
}
#endif



/* ---------------------------------------- functions ---------------------------------------- */

static Xen gxg_g_unichar_validate(Xen ch)
{
  #define H_g_unichar_validate "gboolean g_unichar_validate(gunichar ch)"
  Xen_check_type(Xen_is_gunichar(ch), ch, 1, "g_unichar_validate", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_validate(Xen_to_C_gunichar(ch))));
}

static Xen gxg_g_unichar_isalnum(Xen c)
{
  #define H_g_unichar_isalnum "gboolean g_unichar_isalnum(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isalnum", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isalnum(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isalpha(Xen c)
{
  #define H_g_unichar_isalpha "gboolean g_unichar_isalpha(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isalpha", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isalpha(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iscntrl(Xen c)
{
  #define H_g_unichar_iscntrl "gboolean g_unichar_iscntrl(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iscntrl", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iscntrl(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isdefined(Xen c)
{
  #define H_g_unichar_isdefined "gboolean g_unichar_isdefined(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isdefined", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isdefined(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isdigit(Xen c)
{
  #define H_g_unichar_isdigit "gboolean g_unichar_isdigit(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isdigit", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isdigit(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isgraph(Xen c)
{
  #define H_g_unichar_isgraph "gboolean g_unichar_isgraph(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isgraph", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isgraph(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_islower(Xen c)
{
  #define H_g_unichar_islower "gboolean g_unichar_islower(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_islower", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_islower(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_ismark(Xen c)
{
  #define H_g_unichar_ismark "gboolean g_unichar_ismark(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_ismark", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_ismark(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isprint(Xen c)
{
  #define H_g_unichar_isprint "gboolean g_unichar_isprint(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isprint", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isprint(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_ispunct(Xen c)
{
  #define H_g_unichar_ispunct "gboolean g_unichar_ispunct(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_ispunct", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_ispunct(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isspace(Xen c)
{
  #define H_g_unichar_isspace "gboolean g_unichar_isspace(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isspace", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isspace(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_istitle(Xen c)
{
  #define H_g_unichar_istitle "gboolean g_unichar_istitle(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_istitle", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_istitle(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isupper(Xen c)
{
  #define H_g_unichar_isupper "gboolean g_unichar_isupper(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isupper", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isupper(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_isxdigit(Xen c)
{
  #define H_g_unichar_isxdigit "gboolean g_unichar_isxdigit(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_isxdigit", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_isxdigit(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iswide(Xen c)
{
  #define H_g_unichar_iswide "gboolean g_unichar_iswide(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iswide", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iswide(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iswide_cjk(Xen c)
{
  #define H_g_unichar_iswide_cjk "gboolean g_unichar_iswide_cjk(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iswide_cjk", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iswide_cjk(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_iszerowidth(Xen c)
{
  #define H_g_unichar_iszerowidth "gboolean g_unichar_iszerowidth(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_iszerowidth", "gunichar");
  return(C_to_Xen_gboolean(g_unichar_iszerowidth(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_toupper(Xen c)
{
  #define H_g_unichar_toupper "gunichar g_unichar_toupper(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_toupper", "gunichar");
  return(C_to_Xen_gunichar(g_unichar_toupper(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_tolower(Xen c)
{
  #define H_g_unichar_tolower "gunichar g_unichar_tolower(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_tolower", "gunichar");
  return(C_to_Xen_gunichar(g_unichar_tolower(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_totitle(Xen c)
{
  #define H_g_unichar_totitle "gunichar g_unichar_totitle(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_totitle", "gunichar");
  return(C_to_Xen_gunichar(g_unichar_totitle(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_digit_value(Xen c)
{
  #define H_g_unichar_digit_value "gint g_unichar_digit_value(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_digit_value", "gunichar");
  return(C_to_Xen_gint(g_unichar_digit_value(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_xdigit_value(Xen c)
{
  #define H_g_unichar_xdigit_value "gint g_unichar_xdigit_value(gunichar c)"
  Xen_check_type(Xen_is_gunichar(c), c, 1, "g_unichar_xdigit_value", "gunichar");
  return(C_to_Xen_gint(g_unichar_xdigit_value(Xen_to_C_gunichar(c))));
}

static Xen gxg_g_unichar_combining_class(Xen uc)
{
  #define H_g_unichar_combining_class "gint g_unichar_combining_class(gunichar uc)"
  Xen_check_type(Xen_is_gunichar(uc), uc, 1, "g_unichar_combining_class", "gunichar");
  return(C_to_Xen_gint(g_unichar_combining_class(Xen_to_C_gunichar(uc))));
}

static Xen gxg_g_unicode_canonical_ordering(Xen string, Xen len)
{
  #define H_g_unicode_canonical_ordering "void g_unicode_canonical_ordering(gunichar* string, gsize len)"
  Xen_check_type(Xen_is_gunichar_(string), string, 1, "g_unicode_canonical_ordering", "gunichar*");
  Xen_check_type(Xen_is_gsize(len), len, 2, "g_unicode_canonical_ordering", "gsize");
  g_unicode_canonical_ordering(Xen_to_C_gunichar_(string), Xen_to_C_gsize(len));
  return(Xen_false);
}

static Xen gxg_g_utf8_get_char(Xen p)
{
  #define H_g_utf8_get_char "gunichar g_utf8_get_char(gchar* p)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_get_char", "gchar*");
  return(C_to_Xen_gunichar(g_utf8_get_char((const gchar*)Xen_to_C_gchar_(p))));
}

static Xen gxg_g_utf8_get_char_validated(Xen p, Xen max_len)
{
  #define H_g_utf8_get_char_validated "gunichar g_utf8_get_char_validated(gchar* p, gssize max_len)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_get_char_validated", "gchar*");
  Xen_check_type(Xen_is_gssize(max_len), max_len, 2, "g_utf8_get_char_validated", "gssize");
  return(C_to_Xen_gunichar(g_utf8_get_char_validated((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(max_len))));
}

static Xen gxg_g_utf8_prev_char(Xen p)
{
  #define H_g_utf8_prev_char "gchar* g_utf8_prev_char(gchar* p)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_prev_char", "gchar*");
  return(C_to_Xen_gchar_(g_utf8_prev_char((const gchar*)Xen_to_C_gchar_(p))));
}

static Xen gxg_g_utf8_find_next_char(Xen p, Xen end)
{
  #define H_g_utf8_find_next_char "gchar* g_utf8_find_next_char(gchar* p, gchar* end)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_find_next_char", "gchar*");
  Xen_check_type(Xen_is_gchar_(end), end, 2, "g_utf8_find_next_char", "gchar*");
  return(C_to_Xen_gchar_(g_utf8_find_next_char((const gchar*)Xen_to_C_gchar_(p), (const gchar*)Xen_to_C_gchar_(end))));
}

static Xen gxg_g_utf8_find_prev_char(Xen str, Xen p)
{
  #define H_g_utf8_find_prev_char "gchar* g_utf8_find_prev_char(gchar* str, gchar* p)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_find_prev_char", "gchar*");
  Xen_check_type(Xen_is_gchar_(p), p, 2, "g_utf8_find_prev_char", "gchar*");
  return(C_to_Xen_gchar_(g_utf8_find_prev_char((const gchar*)Xen_to_C_gchar_(str), (const gchar*)Xen_to_C_gchar_(p))));
}

static Xen gxg_g_utf8_strlen(Xen p, Xen max)
{
  #define H_g_utf8_strlen "glong g_utf8_strlen(gchar* p, gssize max)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_strlen", "gchar*");
  Xen_check_type(Xen_is_gssize(max), max, 2, "g_utf8_strlen", "gssize");
  return(C_to_Xen_glong(g_utf8_strlen((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(max))));
}

static Xen gxg_g_utf8_strchr(Xen p, Xen len, Xen c)
{
  #define H_g_utf8_strchr "gchar* g_utf8_strchr(gchar* p, gssize len, gunichar c)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_strchr", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strchr", "gssize");
  Xen_check_type(Xen_is_gunichar(c), c, 3, "g_utf8_strchr", "gunichar");
  return(C_to_Xen_gchar_(g_utf8_strchr((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(len), Xen_to_C_gunichar(c))));
}

static Xen gxg_g_utf8_strrchr(Xen p, Xen len, Xen c)
{
  #define H_g_utf8_strrchr "gchar* g_utf8_strrchr(gchar* p, gssize len, gunichar c)"
  Xen_check_type(Xen_is_gchar_(p), p, 1, "g_utf8_strrchr", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strrchr", "gssize");
  Xen_check_type(Xen_is_gunichar(c), c, 3, "g_utf8_strrchr", "gunichar");
  return(C_to_Xen_gchar_(g_utf8_strrchr((const gchar*)Xen_to_C_gchar_(p), Xen_to_C_gssize(len), Xen_to_C_gunichar(c))));
}

static Xen gxg_g_utf8_strreverse(Xen str, Xen len)
{
  #define H_g_utf8_strreverse "gchar* g_utf8_strreverse(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_strreverse", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strreverse", "gssize");
  return(C_to_Xen_gchar_(g_utf8_strreverse((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_validate(Xen str, Xen max_len, Xen ignore_end)
{
  #define H_g_utf8_validate "gboolean g_utf8_validate(gchar* str, gssize max_len, gchar** [end])"
  gchar* ref_end = NULL;
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_validate", "gchar*");
  Xen_check_type(Xen_is_gssize(max_len), max_len, 2, "g_utf8_validate", "gssize");
  {
    Xen result;
    result = C_to_Xen_gboolean(g_utf8_validate((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(max_len), (const gchar**)&ref_end));
    return(Xen_list_2(result, C_to_Xen_gchar_(ref_end)));
   }
}

static Xen gxg_g_utf8_strup(Xen str, Xen len)
{
  #define H_g_utf8_strup "gchar* g_utf8_strup(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_strup", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strup", "gssize");
  return(C_to_Xen_gchar_(g_utf8_strup((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_strdown(Xen str, Xen len)
{
  #define H_g_utf8_strdown "gchar* g_utf8_strdown(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_strdown", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_strdown", "gssize");
  return(C_to_Xen_gchar_(g_utf8_strdown((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_casefold(Xen str, Xen len)
{
  #define H_g_utf8_casefold "gchar* g_utf8_casefold(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_casefold", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_casefold", "gssize");
  return(C_to_Xen_gchar_(g_utf8_casefold((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_normalize(Xen str, Xen len, Xen mode)
{
  #define H_g_utf8_normalize "gchar* g_utf8_normalize(gchar* str, gssize len, GNormalizeMode mode)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_normalize", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_normalize", "gssize");
  Xen_check_type(Xen_is_GNormalizeMode(mode), mode, 3, "g_utf8_normalize", "GNormalizeMode");
  return(C_to_Xen_gchar_(g_utf8_normalize((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len), Xen_to_C_GNormalizeMode(mode))));
}

static Xen gxg_g_utf8_collate(Xen str1, Xen str2)
{
  #define H_g_utf8_collate "gint g_utf8_collate(gchar* str1, gchar* str2)"
  Xen_check_type(Xen_is_gchar_(str1), str1, 1, "g_utf8_collate", "gchar*");
  Xen_check_type(Xen_is_gchar_(str2), str2, 2, "g_utf8_collate", "gchar*");
  return(C_to_Xen_gint(g_utf8_collate((const gchar*)Xen_to_C_gchar_(str1), (const gchar*)Xen_to_C_gchar_(str2))));
}

static Xen gxg_g_utf8_collate_key(Xen str, Xen len)
{
  #define H_g_utf8_collate_key "gchar* g_utf8_collate_key(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_collate_key", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_collate_key", "gssize");
  return(C_to_Xen_gchar_(g_utf8_collate_key((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_utf8_collate_key_for_filename(Xen str, Xen len)
{
  #define H_g_utf8_collate_key_for_filename "gchar* g_utf8_collate_key_for_filename(gchar* str, gssize len)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "g_utf8_collate_key_for_filename", "gchar*");
  Xen_check_type(Xen_is_gssize(len), len, 2, "g_utf8_collate_key_for_filename", "gssize");
  return(C_to_Xen_gchar_(g_utf8_collate_key_for_filename((const gchar*)Xen_to_C_gchar_(str), Xen_to_C_gssize(len))));
}

static Xen gxg_g_cclosure_new(Xen func, Xen func_info, Xen destroy_data)
{
  #define H_g_cclosure_new "GClosure* g_cclosure_new(GCallback func, lambda_data func_info, GClosureNotify destroy_data)"
  Xen_check_type(Xen_is_GCallback(func), func, 1, "g_cclosure_new", "GCallback");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 2, "g_cclosure_new", "lambda_data");
  Xen_check_type(Xen_is_GClosureNotify(destroy_data) || Xen_is_false(destroy_data), destroy_data, 3, "g_cclosure_new", "GClosureNotify");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_GClosure_(g_cclosure_new(Xen_to_C_GCallback(func), Xen_to_C_lambda_data(func_info), Xen_to_C_GClosureNotify(destroy_data)));
    return(result);
   }
}

static Xen gxg_g_signal_newv(Xen arglist)
{
  #define H_g_signal_newv "guint g_signal_newv(gchar* signal_name, GType itype, GSignalFlags signal_flags, \
GClosure* class_closure, GSignalAccumulator accumulator, gpointer accu_data, GSignalCMarshaller c_marshaller, \
GType return_type, guint n_params, GType* param_types)"
  Xen signal_name, itype, signal_flags, class_closure, accumulator, accu_data, c_marshaller, return_type, n_params, param_types;
  signal_name = Xen_list_ref(arglist, 0);
  itype = Xen_list_ref(arglist, 1);
  signal_flags = Xen_list_ref(arglist, 2);
  class_closure = Xen_list_ref(arglist, 3);
  accumulator = Xen_list_ref(arglist, 4);
  accu_data = Xen_list_ref(arglist, 5);
  c_marshaller = Xen_list_ref(arglist, 6);
  return_type = Xen_list_ref(arglist, 7);
  n_params = Xen_list_ref(arglist, 8);
  param_types = Xen_list_ref(arglist, 9);
  Xen_check_type(Xen_is_gchar_(signal_name), signal_name, 1, "g_signal_newv", "gchar*");
  Xen_check_type(Xen_is_GType(itype), itype, 2, "g_signal_newv", "GType");
  Xen_check_type(Xen_is_GSignalFlags(signal_flags), signal_flags, 3, "g_signal_newv", "GSignalFlags");
  Xen_check_type(Xen_is_GClosure_(class_closure) || Xen_is_false(class_closure), class_closure, 4, "g_signal_newv", "GClosure*");
  Xen_check_type(Xen_is_GSignalAccumulator(accumulator), accumulator, 5, "g_signal_newv", "GSignalAccumulator");
  Xen_check_type(Xen_is_gpointer(accu_data), accu_data, 6, "g_signal_newv", "gpointer");
  Xen_check_type(Xen_is_GSignalCMarshaller(c_marshaller), c_marshaller, 7, "g_signal_newv", "GSignalCMarshaller");
  Xen_check_type(Xen_is_GType(return_type), return_type, 8, "g_signal_newv", "GType");
  Xen_check_type(Xen_is_guint(n_params), n_params, 9, "g_signal_newv", "guint");
  Xen_check_type(Xen_is_GType_(param_types), param_types, 10, "g_signal_newv", "GType*");
  return(C_to_Xen_guint(g_signal_newv(Xen_to_C_gchar_(signal_name), Xen_to_C_GType(itype), Xen_to_C_GSignalFlags(signal_flags), 
                                      Xen_to_C_GClosure_(class_closure), Xen_to_C_GSignalAccumulator(accumulator), Xen_to_C_gpointer(accu_data), 
                                      Xen_to_C_GSignalCMarshaller(c_marshaller), Xen_to_C_GType(return_type), Xen_to_C_guint(n_params), 
                                      Xen_to_C_GType_(param_types))));
}

static Xen gxg_g_signal_lookup(Xen name, Xen itype)
{
  #define H_g_signal_lookup "guint g_signal_lookup(gchar* name, GType itype)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "g_signal_lookup", "gchar*");
  Xen_check_type(Xen_is_GType(itype), itype, 2, "g_signal_lookup", "GType");
  return(C_to_Xen_guint(g_signal_lookup(Xen_to_C_gchar_(name), Xen_to_C_GType(itype))));
}

static Xen gxg_g_signal_name(Xen signal_id)
{
  #define H_g_signal_name "gchar* g_signal_name(guint signal_id)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_name", "guint");
  return(C_to_Xen_gchar_(g_signal_name(Xen_to_C_guint(signal_id))));
}

static Xen gxg_g_signal_query(Xen signal_id, Xen query)
{
  #define H_g_signal_query "void g_signal_query(guint signal_id, GSignalQuery* query)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_query", "guint");
  Xen_check_type(Xen_is_GSignalQuery_(query), query, 2, "g_signal_query", "GSignalQuery*");
  g_signal_query(Xen_to_C_guint(signal_id), Xen_to_C_GSignalQuery_(query));
  return(Xen_false);
}

static Xen gxg_g_signal_list_ids(Xen itype, Xen n_ids)
{
  #define H_g_signal_list_ids "guint* g_signal_list_ids(GType itype, guint* n_ids)"
  Xen_check_type(Xen_is_GType(itype), itype, 1, "g_signal_list_ids", "GType");
  Xen_check_type(Xen_is_guint_(n_ids), n_ids, 2, "g_signal_list_ids", "guint*");
  return(C_to_Xen_guint_(g_signal_list_ids(Xen_to_C_GType(itype), Xen_to_C_guint_(n_ids))));
}

static Xen gxg_g_signal_parse_name(Xen detailed_signal, Xen itype, Xen ignore_signal_id_p, Xen ignore_detail_p, Xen force_detail_quark)
{
  #define H_g_signal_parse_name "gboolean g_signal_parse_name(gchar* detailed_signal, GType itype, guint* [signal_id_p], \
GQuark* [detail_p], gboolean force_detail_quark)"
  guint ref_signal_id_p;
  GQuark ref_detail_p;
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 1, "g_signal_parse_name", "gchar*");
  Xen_check_type(Xen_is_GType(itype), itype, 2, "g_signal_parse_name", "GType");
  Xen_check_type(Xen_is_gboolean(force_detail_quark), force_detail_quark, 5, "g_signal_parse_name", "gboolean");
  {
    Xen result;
    result = C_to_Xen_gboolean(g_signal_parse_name(Xen_to_C_gchar_(detailed_signal), Xen_to_C_GType(itype), &ref_signal_id_p, 
                                                   &ref_detail_p, Xen_to_C_gboolean(force_detail_quark)));
    return(Xen_list_3(result, C_to_Xen_guint(ref_signal_id_p), C_to_Xen_GQuark(ref_detail_p)));
   }
}

static Xen gxg_g_signal_get_invocation_hint(Xen instance)
{
  #define H_g_signal_get_invocation_hint "GSignalInvocationHint* g_signal_get_invocation_hint(gpointer instance)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_get_invocation_hint", "gpointer");
  return(C_to_Xen_GSignalInvocationHint_(g_signal_get_invocation_hint(Xen_to_C_gpointer(instance))));
}

static Xen gxg_g_signal_stop_emission(Xen instance, Xen signal_id, Xen detail)
{
  #define H_g_signal_stop_emission "void g_signal_stop_emission(gpointer instance, guint signal_id, GQuark detail)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_stop_emission", "gpointer");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "g_signal_stop_emission", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 3, "g_signal_stop_emission", "GQuark");
  g_signal_stop_emission(Xen_to_C_gpointer(instance), Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail));
  return(Xen_false);
}

static Xen gxg_g_signal_stop_emission_by_name(Xen instance, Xen detailed_signal)
{
  #define H_g_signal_stop_emission_by_name "void g_signal_stop_emission_by_name(gpointer instance, gchar* detailed_signal)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_stop_emission_by_name", "gpointer");
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 2, "g_signal_stop_emission_by_name", "gchar*");
  g_signal_stop_emission_by_name(Xen_to_C_gpointer(instance), Xen_to_C_gchar_(detailed_signal));
  return(Xen_false);
}

static Xen gxg_g_signal_add_emission_hook(Xen signal_id, Xen quark, Xen hook_func, Xen func_info, Xen data_destroy)
{
  #define H_g_signal_add_emission_hook "gulong g_signal_add_emission_hook(guint signal_id, GQuark quark, \
GSignalEmissionHook hook_func, lambda_data func_info, GtkDestroyNotify data_destroy)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_add_emission_hook", "guint");
  Xen_check_type(Xen_is_GQuark(quark), quark, 2, "g_signal_add_emission_hook", "GQuark");
  Xen_check_type(Xen_is_GSignalEmissionHook(hook_func), hook_func, 3, "g_signal_add_emission_hook", "GSignalEmissionHook");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "g_signal_add_emission_hook", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(data_destroy), data_destroy, 5, "g_signal_add_emission_hook", "GtkDestroyNotify");
  {
    Xen result;
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, data_destroy);
    result = C_to_Xen_gulong(g_signal_add_emission_hook(Xen_to_C_guint(signal_id), Xen_to_C_GQuark(quark), Xen_to_C_GSignalEmissionHook(hook_func), 
                                                        Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(data_destroy)));
    return(result);
   }
}

static Xen gxg_g_signal_remove_emission_hook(Xen signal_id, Xen hook_id)
{
  #define H_g_signal_remove_emission_hook "void g_signal_remove_emission_hook(guint signal_id, gulong hook_id)"
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 1, "g_signal_remove_emission_hook", "guint");
  Xen_check_type(Xen_is_gulong(hook_id), hook_id, 2, "g_signal_remove_emission_hook", "gulong");
  g_signal_remove_emission_hook(Xen_to_C_guint(signal_id), Xen_to_C_gulong(hook_id));
  return(Xen_false);
}

static Xen gxg_g_signal_has_handler_pending(Xen instance, Xen signal_id, Xen detail, Xen may_be_blocked)
{
  #define H_g_signal_has_handler_pending "gboolean g_signal_has_handler_pending(gpointer instance, guint signal_id, \
GQuark detail, gboolean may_be_blocked)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_has_handler_pending", "gpointer");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "g_signal_has_handler_pending", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 3, "g_signal_has_handler_pending", "GQuark");
  Xen_check_type(Xen_is_gboolean(may_be_blocked), may_be_blocked, 4, "g_signal_has_handler_pending", "gboolean");
  return(C_to_Xen_gboolean(g_signal_has_handler_pending(Xen_to_C_gpointer(instance), Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail), 
                                                        Xen_to_C_gboolean(may_be_blocked))));
}

static Xen gxg_g_signal_connect_closure_by_id(Xen instance, Xen signal_id, Xen detail, Xen closure, Xen after)
{
  #define H_g_signal_connect_closure_by_id "gulong g_signal_connect_closure_by_id(gpointer instance, \
guint signal_id, GQuark detail, GClosure* closure, gboolean after)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_connect_closure_by_id", "gpointer");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "g_signal_connect_closure_by_id", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 3, "g_signal_connect_closure_by_id", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure), closure, 4, "g_signal_connect_closure_by_id", "GClosure*");
  Xen_check_type(Xen_is_gboolean(after), after, 5, "g_signal_connect_closure_by_id", "gboolean");
  return(C_to_Xen_gulong(g_signal_connect_closure_by_id(Xen_to_C_gpointer(instance), Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail), 
                                                        Xen_to_C_GClosure_(closure), Xen_to_C_gboolean(after))));
}

static Xen gxg_g_signal_connect_closure(Xen instance, Xen detailed_signal, Xen closure, Xen after)
{
  #define H_g_signal_connect_closure "gulong g_signal_connect_closure(gpointer instance, gchar* detailed_signal, \
GClosure* closure, gboolean after)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_connect_closure", "gpointer");
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 2, "g_signal_connect_closure", "gchar*");
  Xen_check_type(Xen_is_GClosure_(closure), closure, 3, "g_signal_connect_closure", "GClosure*");
  Xen_check_type(Xen_is_gboolean(after), after, 4, "g_signal_connect_closure", "gboolean");
  return(C_to_Xen_gulong(g_signal_connect_closure(Xen_to_C_gpointer(instance), Xen_to_C_gchar_(detailed_signal), Xen_to_C_GClosure_(closure), 
                                                  Xen_to_C_gboolean(after))));
}

static Xen gxg_g_signal_connect_data(Xen instance, Xen detailed_signal, Xen func, Xen func_info, Xen destroy_data, Xen connect_flags)
{
  #define H_g_signal_connect_data "gulong g_signal_connect_data(gpointer instance, gchar* detailed_signal, \
GCallback func, lambda_data func_info, GClosureNotify destroy_data, GConnectFlags connect_flags)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_connect_data", "gpointer");
  Xen_check_type(Xen_is_gchar_(detailed_signal), detailed_signal, 2, "g_signal_connect_data", "gchar*");
  Xen_check_type(Xen_is_GCallback(func), func, 3, "g_signal_connect_data", "GCallback");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "g_signal_connect_data", "lambda_data");
  Xen_check_type(Xen_is_GClosureNotify(destroy_data) || Xen_is_false(destroy_data), destroy_data, 5, "g_signal_connect_data", "GClosureNotify");
  Xen_check_type(Xen_is_GConnectFlags(connect_flags), connect_flags, 6, "g_signal_connect_data", "GConnectFlags");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_gulong(g_signal_connect_data(Xen_to_C_gpointer(instance), Xen_to_C_gchar_(detailed_signal), Xen_to_C_GCallback(func), 
                                                   Xen_to_C_lambda_data(func_info), Xen_to_C_GClosureNotify(destroy_data), 
                                                   Xen_to_C_GConnectFlags(connect_flags)));
    return(result);
   }
}

static Xen gxg_g_signal_handler_block(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_block "void g_signal_handler_block(gpointer instance, gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_block", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_block", "gulong");
  g_signal_handler_block(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id));
  return(Xen_false);
}

static Xen gxg_g_signal_handler_unblock(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_unblock "void g_signal_handler_unblock(gpointer instance, gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_unblock", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_unblock", "gulong");
  g_signal_handler_unblock(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id));
  return(Xen_false);
}

static Xen gxg_g_signal_handler_disconnect(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_disconnect "void g_signal_handler_disconnect(gpointer instance, gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_disconnect", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_disconnect", "gulong");
  g_signal_handler_disconnect(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id));
  return(Xen_false);
}

static Xen gxg_g_signal_handler_is_connected(Xen instance, Xen handler_id)
{
  #define H_g_signal_handler_is_connected "gboolean g_signal_handler_is_connected(gpointer instance, \
gulong handler_id)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_is_connected", "gpointer");
  Xen_check_type(Xen_is_gulong(handler_id), handler_id, 2, "g_signal_handler_is_connected", "gulong");
  return(C_to_Xen_gboolean(g_signal_handler_is_connected(Xen_to_C_gpointer(instance), Xen_to_C_gulong(handler_id))));
}

static Xen gxg_g_signal_handler_find(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handler_find "gulong g_signal_handler_find(gpointer instance, GSignalMatchType mask, \
guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handler_find", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handler_find", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handler_find", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handler_find", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handler_find", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handler_find", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handler_find", "gpointer");
  return(C_to_Xen_gulong(g_signal_handler_find(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), Xen_to_C_guint(signal_id), 
                                               Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), Xen_to_C_gpointer(func), 
                                               Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_block_matched(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handlers_block_matched "guint g_signal_handlers_block_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_block_matched", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handlers_block_matched", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handlers_block_matched", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handlers_block_matched", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handlers_block_matched", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handlers_block_matched", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handlers_block_matched", "gpointer");
  return(C_to_Xen_guint(g_signal_handlers_block_matched(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), Xen_to_C_guint(signal_id), 
                                                        Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), Xen_to_C_gpointer(func), 
                                                        Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_unblock_matched(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handlers_unblock_matched "guint g_signal_handlers_unblock_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_unblock_matched", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handlers_unblock_matched", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handlers_unblock_matched", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handlers_unblock_matched", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handlers_unblock_matched", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handlers_unblock_matched", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handlers_unblock_matched", "gpointer");
  return(C_to_Xen_guint(g_signal_handlers_unblock_matched(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), Xen_to_C_guint(signal_id), 
                                                          Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), Xen_to_C_gpointer(func), 
                                                          Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_disconnect_matched(Xen instance, Xen mask, Xen signal_id, Xen detail, Xen closure, Xen func, Xen data)
{
  #define H_g_signal_handlers_disconnect_matched "guint g_signal_handlers_disconnect_matched(gpointer instance, \
GSignalMatchType mask, guint signal_id, GQuark detail, GClosure* closure, gpointer func, gpointer data)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_disconnect_matched", "gpointer");
  Xen_check_type(Xen_is_GSignalMatchType(mask), mask, 2, "g_signal_handlers_disconnect_matched", "GSignalMatchType");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 3, "g_signal_handlers_disconnect_matched", "guint");
  Xen_check_type(Xen_is_GQuark(detail), detail, 4, "g_signal_handlers_disconnect_matched", "GQuark");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "g_signal_handlers_disconnect_matched", "GClosure*");
  Xen_check_type(Xen_is_gpointer(func), func, 6, "g_signal_handlers_disconnect_matched", "gpointer");
  Xen_check_type(Xen_is_gpointer(data), data, 7, "g_signal_handlers_disconnect_matched", "gpointer");
  return(C_to_Xen_guint(g_signal_handlers_disconnect_matched(Xen_to_C_gpointer(instance), Xen_to_C_GSignalMatchType(mask), 
                                                             Xen_to_C_guint(signal_id), Xen_to_C_GQuark(detail), Xen_to_C_GClosure_(closure), 
                                                             Xen_to_C_gpointer(func), Xen_to_C_gpointer(data))));
}

static Xen gxg_g_signal_handlers_destroy(Xen instance)
{
  #define H_g_signal_handlers_destroy "void g_signal_handlers_destroy(gpointer instance)"
  Xen_check_type(Xen_is_gpointer(instance), instance, 1, "g_signal_handlers_destroy", "gpointer");
  g_signal_handlers_destroy(Xen_to_C_gpointer(instance));
  return(Xen_false);
}

static Xen gxg_g_object_ref(Xen object)
{
  #define H_g_object_ref "gpointer g_object_ref(gpointer object)"
  Xen_check_type(Xen_is_gpointer(object), object, 1, "g_object_ref", "gpointer");
  return(C_to_Xen_gpointer(g_object_ref(Xen_to_C_gpointer(object))));
}

static Xen gxg_g_object_unref(Xen object)
{
  #define H_g_object_unref "void g_object_unref(gpointer object)"
  Xen_check_type(Xen_is_gpointer(object), object, 1, "g_object_unref", "gpointer");
  g_object_unref(Xen_to_C_gpointer(object));
  return(Xen_false);
}

static Xen gxg_gdk_drag_status(Xen context, Xen action, Xen time)
{
  #define H_gdk_drag_status "void gdk_drag_status(GdkDragContext* context, GdkDragAction action, guint32 time)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gdk_drag_status", "GdkDragContext*");
  Xen_check_type(Xen_is_GdkDragAction(action), action, 2, "gdk_drag_status", "GdkDragAction");
  Xen_check_type(Xen_is_guint32(time), time, 3, "gdk_drag_status", "guint32");
  gdk_drag_status(Xen_to_C_GdkDragContext_(context), Xen_to_C_GdkDragAction(action), Xen_to_C_guint32(time));
  return(Xen_false);
}

static Xen gxg_gdk_drop_reply(Xen context, Xen ok, Xen time)
{
  #define H_gdk_drop_reply "void gdk_drop_reply(GdkDragContext* context, gboolean ok, guint32 time)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gdk_drop_reply", "GdkDragContext*");
  Xen_check_type(Xen_is_gboolean(ok), ok, 2, "gdk_drop_reply", "gboolean");
  Xen_check_type(Xen_is_guint32(time), time, 3, "gdk_drop_reply", "guint32");
  gdk_drop_reply(Xen_to_C_GdkDragContext_(context), Xen_to_C_gboolean(ok), Xen_to_C_guint32(time));
  return(Xen_false);
}

static Xen gxg_gdk_drop_finish(Xen context, Xen success, Xen time)
{
  #define H_gdk_drop_finish "void gdk_drop_finish(GdkDragContext* context, gboolean success, guint32 time)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gdk_drop_finish", "GdkDragContext*");
  Xen_check_type(Xen_is_gboolean(success), success, 2, "gdk_drop_finish", "gboolean");
  Xen_check_type(Xen_is_guint32(time), time, 3, "gdk_drop_finish", "guint32");
  gdk_drop_finish(Xen_to_C_GdkDragContext_(context), Xen_to_C_gboolean(success), Xen_to_C_guint32(time));
  return(Xen_false);
}

static Xen gxg_gdk_event_copy(Xen event)
{
  #define H_gdk_event_copy "GdkEvent* gdk_event_copy(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gdk_event_copy", "GdkEvent*");
  return(C_to_Xen_GdkEvent_(gdk_event_copy(Xen_to_C_GdkEvent_(event))));
}

static Xen gxg_gdk_event_free(Xen event)
{
  #define H_gdk_event_free "void gdk_event_free(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gdk_event_free", "GdkEvent*");
  gdk_event_free(Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gdk_event_get_time(Xen event)
{
  #define H_gdk_event_get_time "guint32 gdk_event_get_time(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 1, "gdk_event_get_time", "GdkEvent*");
  return(C_to_Xen_guint32(gdk_event_get_time(Xen_to_C_GdkEvent_(event))));
}

static Xen gxg_gdk_event_get_state(Xen event, Xen ignore_state)
{
  #define H_gdk_event_get_state "gboolean gdk_event_get_state(GdkEvent* event, GdkModifierType* [state])"
  GdkModifierType ref_state;
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gdk_event_get_state", "GdkEvent*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_event_get_state(Xen_to_C_GdkEvent_(event), &ref_state));
    return(Xen_list_2(result, C_to_Xen_GdkModifierType(ref_state)));
   }
}

static Xen gxg_gdk_event_get_coords(Xen event, Xen ignore_x_win, Xen ignore_y_win)
{
  #define H_gdk_event_get_coords "gboolean gdk_event_get_coords(GdkEvent* event, gdouble* [x_win], gdouble* [y_win])"
  gdouble ref_x_win;
  gdouble ref_y_win;
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gdk_event_get_coords", "GdkEvent*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_event_get_coords(Xen_to_C_GdkEvent_(event), &ref_x_win, &ref_y_win));
    return(Xen_list_3(result, C_to_Xen_gdouble(ref_x_win), C_to_Xen_gdouble(ref_y_win)));
   }
}

static Xen gxg_gdk_event_get_root_coords(Xen event, Xen ignore_x_root, Xen ignore_y_root)
{
  #define H_gdk_event_get_root_coords "gboolean gdk_event_get_root_coords(GdkEvent* event, gdouble* [x_root], \
gdouble* [y_root])"
  gdouble ref_x_root;
  gdouble ref_y_root;
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gdk_event_get_root_coords", "GdkEvent*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_event_get_root_coords(Xen_to_C_GdkEvent_(event), &ref_x_root, &ref_y_root));
    return(Xen_list_3(result, C_to_Xen_gdouble(ref_x_root), C_to_Xen_gdouble(ref_y_root)));
   }
}

static Xen gxg_gdk_event_handler_set(Xen func, Xen func_info, Xen notify)
{
  #define H_gdk_event_handler_set "void gdk_event_handler_set(GdkEventFunc func, lambda_data func_info, \
GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_GdkEventFunc(func), func, 1, "gdk_event_handler_set", "GdkEventFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 2, "gdk_event_handler_set", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 3, "gdk_event_handler_set", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, notify);
    gdk_event_handler_set(Xen_to_C_GdkEventFunc(func), Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(notify));
    return(Xen_false);
   }
}

static Xen gxg_gdk_set_show_events(Xen show_events)
{
  #define H_gdk_set_show_events "void gdk_set_show_events(gboolean show_events)"
  Xen_check_type(Xen_is_gboolean(show_events), show_events, 1, "gdk_set_show_events", "gboolean");
  gdk_set_show_events(Xen_to_C_gboolean(show_events));
  return(Xen_false);
}

static Xen gxg_gdk_get_show_events(void)
{
  #define H_gdk_get_show_events "gboolean gdk_get_show_events( void)"
  return(C_to_Xen_gboolean(gdk_get_show_events()));
}

static Xen gxg_gdk_rectangle_intersect(Xen src1, Xen src2, Xen dest)
{
  #define H_gdk_rectangle_intersect "gboolean gdk_rectangle_intersect(GdkRectangle* src1, GdkRectangle* src2, \
GdkRectangle* dest)"
  Xen_check_type(Xen_is_GdkRectangle_(src1), src1, 1, "gdk_rectangle_intersect", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(src2), src2, 2, "gdk_rectangle_intersect", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(dest), dest, 3, "gdk_rectangle_intersect", "GdkRectangle*");
  return(C_to_Xen_gboolean(gdk_rectangle_intersect(Xen_to_C_GdkRectangle_(src1), Xen_to_C_GdkRectangle_(src2), Xen_to_C_GdkRectangle_(dest))));
}

static Xen gxg_gdk_rectangle_union(Xen src1, Xen src2, Xen dest)
{
  #define H_gdk_rectangle_union "void gdk_rectangle_union(GdkRectangle* src1, GdkRectangle* src2, GdkRectangle* dest)"
  Xen_check_type(Xen_is_GdkRectangle_(src1), src1, 1, "gdk_rectangle_union", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(src2), src2, 2, "gdk_rectangle_union", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(dest), dest, 3, "gdk_rectangle_union", "GdkRectangle*");
  gdk_rectangle_union(Xen_to_C_GdkRectangle_(src1), Xen_to_C_GdkRectangle_(src2), Xen_to_C_GdkRectangle_(dest));
  return(Xen_false);
}

static Xen gxg_gdk_keymap_lookup_key(Xen keymap, Xen key)
{
  #define H_gdk_keymap_lookup_key "guint gdk_keymap_lookup_key(GdkKeymap* keymap, GdkKeymapKey* key)"
  Xen_check_type(Xen_is_GdkKeymap_(keymap), keymap, 1, "gdk_keymap_lookup_key", "GdkKeymap*");
  Xen_check_type(Xen_is_GdkKeymapKey_(key), key, 2, "gdk_keymap_lookup_key", "GdkKeymapKey*");
  return(C_to_Xen_guint(gdk_keymap_lookup_key(Xen_to_C_GdkKeymap_(keymap), Xen_to_C_GdkKeymapKey_(key))));
}

static Xen gxg_gdk_keymap_get_entries_for_keyval(Xen keymap, Xen keyval, Xen ignore_keys, Xen ignore_n_keys)
{
  #define H_gdk_keymap_get_entries_for_keyval "gboolean gdk_keymap_get_entries_for_keyval(GdkKeymap* keymap, \
guint keyval, GdkKeymapKey** [keys], gint* [n_keys])"
  GdkKeymapKey* ref_keys = NULL;
  gint ref_n_keys;
  Xen_check_type(Xen_is_GdkKeymap_(keymap), keymap, 1, "gdk_keymap_get_entries_for_keyval", "GdkKeymap*");
  Xen_check_type(Xen_is_guint(keyval), keyval, 2, "gdk_keymap_get_entries_for_keyval", "guint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_keymap_get_entries_for_keyval(Xen_to_C_GdkKeymap_(keymap), Xen_to_C_guint(keyval), &ref_keys, 
                                                                 &ref_n_keys));
    return(Xen_list_3(result, C_to_Xen_GdkKeymapKey_(ref_keys), C_to_Xen_gint(ref_n_keys)));
   }
}

static Xen gxg_gdk_keymap_get_entries_for_keycode(Xen keymap, Xen hardware_keycode, Xen ignore_keys, Xen ignore_keyvals, Xen ignore_n_entries)
{
  #define H_gdk_keymap_get_entries_for_keycode "gboolean gdk_keymap_get_entries_for_keycode(GdkKeymap* keymap, \
guint hardware_keycode, GdkKeymapKey** [keys], guint** [keyvals], gint* [n_entries])"
  GdkKeymapKey* ref_keys = NULL;
  guint* ref_keyvals = NULL;
  gint ref_n_entries;
  Xen_check_type(Xen_is_GdkKeymap_(keymap), keymap, 1, "gdk_keymap_get_entries_for_keycode", "GdkKeymap*");
  Xen_check_type(Xen_is_guint(hardware_keycode), hardware_keycode, 2, "gdk_keymap_get_entries_for_keycode", "guint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_keymap_get_entries_for_keycode(Xen_to_C_GdkKeymap_(keymap), Xen_to_C_guint(hardware_keycode), 
                                                                  &ref_keys, &ref_keyvals, &ref_n_entries));
    return(Xen_list_4(result, C_to_Xen_GdkKeymapKey_(ref_keys), C_to_Xen_guint_(ref_keyvals), C_to_Xen_gint(ref_n_entries)));
   }
}

static Xen gxg_gdk_keymap_get_direction(Xen keymap)
{
  #define H_gdk_keymap_get_direction "PangoDirection gdk_keymap_get_direction(GdkKeymap* keymap)"
  Xen_check_type(Xen_is_GdkKeymap_(keymap), keymap, 1, "gdk_keymap_get_direction", "GdkKeymap*");
  return(C_to_Xen_PangoDirection(gdk_keymap_get_direction(Xen_to_C_GdkKeymap_(keymap))));
}

static Xen gxg_gdk_keyval_name(Xen keyval)
{
  #define H_gdk_keyval_name "gchar* gdk_keyval_name(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_name", "guint");
  return(C_to_Xen_gchar_(gdk_keyval_name(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_from_name(Xen keyval_name)
{
  #define H_gdk_keyval_from_name "guint gdk_keyval_from_name(gchar* keyval_name)"
  Xen_check_type(Xen_is_gchar_(keyval_name), keyval_name, 1, "gdk_keyval_from_name", "gchar*");
  return(C_to_Xen_guint(gdk_keyval_from_name(Xen_to_C_gchar_(keyval_name))));
}

static Xen gxg_gdk_keyval_convert_case(Xen symbol, Xen ignore_lower, Xen ignore_upper)
{
  #define H_gdk_keyval_convert_case "void gdk_keyval_convert_case(guint symbol, guint* [lower], guint* [upper])"
  guint ref_lower;
  guint ref_upper;
  Xen_check_type(Xen_is_guint(symbol), symbol, 1, "gdk_keyval_convert_case", "guint");
  gdk_keyval_convert_case(Xen_to_C_guint(symbol), &ref_lower, &ref_upper);
  return(Xen_list_2(C_to_Xen_guint(ref_lower), C_to_Xen_guint(ref_upper)));
}

static Xen gxg_gdk_keyval_to_upper(Xen keyval)
{
  #define H_gdk_keyval_to_upper "guint gdk_keyval_to_upper(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_to_upper", "guint");
  return(C_to_Xen_guint(gdk_keyval_to_upper(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_to_lower(Xen keyval)
{
  #define H_gdk_keyval_to_lower "guint gdk_keyval_to_lower(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_to_lower", "guint");
  return(C_to_Xen_guint(gdk_keyval_to_lower(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_is_upper(Xen keyval)
{
  #define H_gdk_keyval_is_upper "gboolean gdk_keyval_is_upper(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_is_upper", "guint");
  return(C_to_Xen_gboolean(gdk_keyval_is_upper(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_is_lower(Xen keyval)
{
  #define H_gdk_keyval_is_lower "gboolean gdk_keyval_is_lower(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_is_lower", "guint");
  return(C_to_Xen_gboolean(gdk_keyval_is_lower(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_keyval_to_unicode(Xen keyval)
{
  #define H_gdk_keyval_to_unicode "guint32 gdk_keyval_to_unicode(guint keyval)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gdk_keyval_to_unicode", "guint");
  return(C_to_Xen_guint32(gdk_keyval_to_unicode(Xen_to_C_guint(keyval))));
}

static Xen gxg_gdk_unicode_to_keyval(Xen wc)
{
  #define H_gdk_unicode_to_keyval "guint gdk_unicode_to_keyval(guint32 wc)"
  Xen_check_type(Xen_is_guint32(wc), wc, 1, "gdk_unicode_to_keyval", "guint32");
  return(C_to_Xen_guint(gdk_unicode_to_keyval(Xen_to_C_guint32(wc))));
}

static Xen gxg_gdk_utf8_to_string_target(Xen str)
{
  #define H_gdk_utf8_to_string_target "gchar* gdk_utf8_to_string_target(gchar* str)"
  Xen_check_type(Xen_is_gchar_(str), str, 1, "gdk_utf8_to_string_target", "gchar*");
  {
   gchar* result;
   Xen rtn;
   result = gdk_utf8_to_string_target(Xen_to_C_gchar_(str));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gdk_window_destroy(Xen window)
{
  #define H_gdk_window_destroy "void gdk_window_destroy(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_destroy", "GdkWindow*");
  gdk_window_destroy(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_get_window_type(Xen window)
{
  #define H_gdk_window_get_window_type "GdkWindowType gdk_window_get_window_type(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_window_type", "GdkWindow*");
  return(C_to_Xen_GdkWindowType(gdk_window_get_window_type(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_show(Xen window)
{
  #define H_gdk_window_show "void gdk_window_show(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_show", "GdkWindow*");
  gdk_window_show(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_hide(Xen window)
{
  #define H_gdk_window_hide "void gdk_window_hide(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_hide", "GdkWindow*");
  gdk_window_hide(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_withdraw(Xen window)
{
  #define H_gdk_window_withdraw "void gdk_window_withdraw(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_withdraw", "GdkWindow*");
  gdk_window_withdraw(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_show_unraised(Xen window)
{
  #define H_gdk_window_show_unraised "void gdk_window_show_unraised(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_show_unraised", "GdkWindow*");
  gdk_window_show_unraised(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_move(Xen window, Xen x, Xen y)
{
  #define H_gdk_window_move "void gdk_window_move(GdkWindow* window, gint x, gint y)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_move", "GdkWindow*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gdk_window_move", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gdk_window_move", "gint");
  gdk_window_move(Xen_to_C_GdkWindow_(window), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gdk_window_resize(Xen window, Xen width, Xen height)
{
  #define H_gdk_window_resize "void gdk_window_resize(GdkWindow* window, gint width, gint height)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_resize", "GdkWindow*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gdk_window_resize", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gdk_window_resize", "gint");
  gdk_window_resize(Xen_to_C_GdkWindow_(window), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gdk_window_move_resize(Xen window, Xen x, Xen y, Xen width, Xen height)
{
  #define H_gdk_window_move_resize "void gdk_window_move_resize(GdkWindow* window, gint x, gint y, gint width, \
gint height)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_move_resize", "GdkWindow*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gdk_window_move_resize", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gdk_window_move_resize", "gint");
  Xen_check_type(Xen_is_gint(width), width, 4, "gdk_window_move_resize", "gint");
  Xen_check_type(Xen_is_gint(height), height, 5, "gdk_window_move_resize", "gint");
  gdk_window_move_resize(Xen_to_C_GdkWindow_(window), Xen_to_C_gint(x), Xen_to_C_gint(y), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gdk_window_raise(Xen window)
{
  #define H_gdk_window_raise "void gdk_window_raise(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_raise", "GdkWindow*");
  gdk_window_raise(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_lower(Xen window)
{
  #define H_gdk_window_lower "void gdk_window_lower(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_lower", "GdkWindow*");
  gdk_window_lower(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_focus(Xen window, Xen timestamp)
{
  #define H_gdk_window_focus "void gdk_window_focus(GdkWindow* window, guint32 timestamp)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_focus", "GdkWindow*");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 2, "gdk_window_focus", "guint32");
  gdk_window_focus(Xen_to_C_GdkWindow_(window), Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_user_data(Xen window, Xen user_data)
{
  #define H_gdk_window_set_user_data "void gdk_window_set_user_data(GdkWindow* window, gpointer user_data)"
  Xen_check_type(Xen_is_GdkWindow_(window) || Xen_is_false(window), window, 1, "gdk_window_set_user_data", "GdkWindow*");
  Xen_check_type(Xen_is_gpointer(user_data), user_data, 2, "gdk_window_set_user_data", "gpointer");
  gdk_window_set_user_data(Xen_to_C_GdkWindow_(window), Xen_to_C_gpointer(user_data));
  return(Xen_false);
}

static Xen gxg_gdk_window_add_filter(Xen window, Xen func, Xen func_info)
{
  #define H_gdk_window_add_filter "void gdk_window_add_filter(GdkWindow* window, GdkFilterFunc func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_add_filter", "GdkWindow*");
  Xen_check_type(Xen_is_GdkFilterFunc(func), func, 2, "gdk_window_add_filter", "GdkFilterFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gdk_window_add_filter", "lambda_data");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    gdk_window_add_filter(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkFilterFunc(func), Xen_to_C_lambda_data(func_info));
    return(Xen_false);
   }
}

static Xen gxg_gdk_window_remove_filter(Xen window, Xen func, Xen func_info)
{
  #define H_gdk_window_remove_filter "void gdk_window_remove_filter(GdkWindow* window, GdkFilterFunc func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_remove_filter", "GdkWindow*");
  Xen_check_type(Xen_is_GdkFilterFunc(func), func, 2, "gdk_window_remove_filter", "GdkFilterFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gdk_window_remove_filter", "lambda_data");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    gdk_window_remove_filter(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkFilterFunc(func), Xen_to_C_lambda_data(func_info));
    return(Xen_false);
   }
}

static Xen gxg_gdk_window_scroll(Xen window, Xen dx, Xen dy)
{
  #define H_gdk_window_scroll "void gdk_window_scroll(GdkWindow* window, gint dx, gint dy)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_scroll", "GdkWindow*");
  Xen_check_type(Xen_is_gint(dx), dx, 2, "gdk_window_scroll", "gint");
  Xen_check_type(Xen_is_gint(dy), dy, 3, "gdk_window_scroll", "gint");
  gdk_window_scroll(Xen_to_C_GdkWindow_(window), Xen_to_C_gint(dx), Xen_to_C_gint(dy));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_child_shapes(Xen window)
{
  #define H_gdk_window_set_child_shapes "void gdk_window_set_child_shapes(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_child_shapes", "GdkWindow*");
  gdk_window_set_child_shapes(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_merge_child_shapes(Xen window)
{
  #define H_gdk_window_merge_child_shapes "void gdk_window_merge_child_shapes(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_merge_child_shapes", "GdkWindow*");
  gdk_window_merge_child_shapes(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_is_visible(Xen window)
{
  #define H_gdk_window_is_visible "gboolean gdk_window_is_visible(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_is_visible", "GdkWindow*");
  return(C_to_Xen_gboolean(gdk_window_is_visible(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_is_viewable(Xen window)
{
  #define H_gdk_window_is_viewable "gboolean gdk_window_is_viewable(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_is_viewable", "GdkWindow*");
  return(C_to_Xen_gboolean(gdk_window_is_viewable(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_get_state(Xen window)
{
  #define H_gdk_window_get_state "GdkWindowState gdk_window_get_state(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_state", "GdkWindow*");
  return(C_to_Xen_GdkWindowState(gdk_window_get_state(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_get_root_origin(Xen window, Xen ignore_x, Xen ignore_y)
{
  #define H_gdk_window_get_root_origin "void gdk_window_get_root_origin(GdkWindow* window, gint* [x], \
gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_root_origin", "GdkWindow*");
  gdk_window_get_root_origin(Xen_to_C_GdkWindow_(window), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gdk_window_get_frame_extents(Xen window, Xen rect)
{
  #define H_gdk_window_get_frame_extents "void gdk_window_get_frame_extents(GdkWindow* window, GdkRectangle* rect)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_frame_extents", "GdkWindow*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 2, "gdk_window_get_frame_extents", "GdkRectangle*");
  gdk_window_get_frame_extents(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkRectangle_(rect));
  return(Xen_false);
}

static Xen gxg_gdk_window_get_parent(Xen window)
{
  #define H_gdk_window_get_parent "GdkWindow* gdk_window_get_parent(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_parent", "GdkWindow*");
  return(C_to_Xen_GdkWindow_(gdk_window_get_parent(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_get_toplevel(Xen window)
{
  #define H_gdk_window_get_toplevel "GdkWindow* gdk_window_get_toplevel(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_toplevel", "GdkWindow*");
  return(C_to_Xen_GdkWindow_(gdk_window_get_toplevel(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_get_children(Xen window)
{
  #define H_gdk_window_get_children "GList* gdk_window_get_children(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_children", "GdkWindow*");
  return(C_to_Xen_GList_(gdk_window_get_children(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_peek_children(Xen window)
{
  #define H_gdk_window_peek_children "GList* gdk_window_peek_children(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_peek_children", "GdkWindow*");
  return(C_to_Xen_GList_(gdk_window_peek_children(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_get_events(Xen window)
{
  #define H_gdk_window_get_events "GdkEventMask gdk_window_get_events(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_events", "GdkWindow*");
  return(C_to_Xen_GdkEventMask(gdk_window_get_events(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gdk_window_set_events(Xen window, Xen event_mask)
{
  #define H_gdk_window_set_events "void gdk_window_set_events(GdkWindow* window, GdkEventMask event_mask)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_events", "GdkWindow*");
  Xen_check_type(Xen_is_GdkEventMask(event_mask), event_mask, 2, "gdk_window_set_events", "GdkEventMask");
  gdk_window_set_events(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkEventMask(event_mask));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_icon_name(Xen window, Xen name)
{
  #define H_gdk_window_set_icon_name "void gdk_window_set_icon_name(GdkWindow* window, gchar* name)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_icon_name", "GdkWindow*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gdk_window_set_icon_name", "gchar*");
  gdk_window_set_icon_name(Xen_to_C_GdkWindow_(window), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_group(Xen window, Xen leader)
{
  #define H_gdk_window_set_group "void gdk_window_set_group(GdkWindow* window, GdkWindow* leader)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_group", "GdkWindow*");
  Xen_check_type(Xen_is_GdkWindow_(leader), leader, 2, "gdk_window_set_group", "GdkWindow*");
  gdk_window_set_group(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkWindow_(leader));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_decorations(Xen window, Xen decorations)
{
  #define H_gdk_window_set_decorations "void gdk_window_set_decorations(GdkWindow* window, GdkWMDecoration decorations)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_decorations", "GdkWindow*");
  Xen_check_type(Xen_is_GdkWMDecoration(decorations), decorations, 2, "gdk_window_set_decorations", "GdkWMDecoration");
  gdk_window_set_decorations(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkWMDecoration(decorations));
  return(Xen_false);
}

static Xen gxg_gdk_window_get_decorations(Xen window, Xen ignore_decorations)
{
  #define H_gdk_window_get_decorations "gboolean gdk_window_get_decorations(GdkWindow* window, GdkWMDecoration* [decorations])"
  GdkWMDecoration ref_decorations;
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_decorations", "GdkWindow*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_window_get_decorations(Xen_to_C_GdkWindow_(window), &ref_decorations));
    return(Xen_list_2(result, C_to_Xen_GdkWMDecoration(ref_decorations)));
   }
}

static Xen gxg_gdk_window_set_functions(Xen window, Xen functions)
{
  #define H_gdk_window_set_functions "void gdk_window_set_functions(GdkWindow* window, GdkWMFunction functions)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_functions", "GdkWindow*");
  Xen_check_type(Xen_is_GdkWMFunction(functions), functions, 2, "gdk_window_set_functions", "GdkWMFunction");
  gdk_window_set_functions(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkWMFunction(functions));
  return(Xen_false);
}

static Xen gxg_gdk_window_iconify(Xen window)
{
  #define H_gdk_window_iconify "void gdk_window_iconify(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_iconify", "GdkWindow*");
  gdk_window_iconify(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_deiconify(Xen window)
{
  #define H_gdk_window_deiconify "void gdk_window_deiconify(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_deiconify", "GdkWindow*");
  gdk_window_deiconify(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_stick(Xen window)
{
  #define H_gdk_window_stick "void gdk_window_stick(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_stick", "GdkWindow*");
  gdk_window_stick(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_unstick(Xen window)
{
  #define H_gdk_window_unstick "void gdk_window_unstick(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_unstick", "GdkWindow*");
  gdk_window_unstick(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_maximize(Xen window)
{
  #define H_gdk_window_maximize "void gdk_window_maximize(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_maximize", "GdkWindow*");
  gdk_window_maximize(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_unmaximize(Xen window)
{
  #define H_gdk_window_unmaximize "void gdk_window_unmaximize(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_unmaximize", "GdkWindow*");
  gdk_window_unmaximize(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_register_dnd(Xen window)
{
  #define H_gdk_window_register_dnd "void gdk_window_register_dnd(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_register_dnd", "GdkWindow*");
  gdk_window_register_dnd(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_begin_resize_drag(Xen window, Xen edge, Xen button, Xen root_x, Xen root_y, Xen timestamp)
{
  #define H_gdk_window_begin_resize_drag "void gdk_window_begin_resize_drag(GdkWindow* window, GdkWindowEdge edge, \
gint button, gint root_x, gint root_y, guint32 timestamp)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_begin_resize_drag", "GdkWindow*");
  Xen_check_type(Xen_is_GdkWindowEdge(edge), edge, 2, "gdk_window_begin_resize_drag", "GdkWindowEdge");
  Xen_check_type(Xen_is_gint(button), button, 3, "gdk_window_begin_resize_drag", "gint");
  Xen_check_type(Xen_is_gint(root_x), root_x, 4, "gdk_window_begin_resize_drag", "gint");
  Xen_check_type(Xen_is_gint(root_y), root_y, 5, "gdk_window_begin_resize_drag", "gint");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 6, "gdk_window_begin_resize_drag", "guint32");
  gdk_window_begin_resize_drag(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkWindowEdge(edge), Xen_to_C_gint(button), Xen_to_C_gint(root_x), 
                               Xen_to_C_gint(root_y), Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gdk_window_begin_move_drag(Xen window, Xen button, Xen root_x, Xen root_y, Xen timestamp)
{
  #define H_gdk_window_begin_move_drag "void gdk_window_begin_move_drag(GdkWindow* window, gint button, \
gint root_x, gint root_y, guint32 timestamp)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_begin_move_drag", "GdkWindow*");
  Xen_check_type(Xen_is_gint(button), button, 2, "gdk_window_begin_move_drag", "gint");
  Xen_check_type(Xen_is_gint(root_x), root_x, 3, "gdk_window_begin_move_drag", "gint");
  Xen_check_type(Xen_is_gint(root_y), root_y, 4, "gdk_window_begin_move_drag", "gint");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 5, "gdk_window_begin_move_drag", "guint32");
  gdk_window_begin_move_drag(Xen_to_C_GdkWindow_(window), Xen_to_C_gint(button), Xen_to_C_gint(root_x), Xen_to_C_gint(root_y), 
                             Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gdk_window_invalidate_rect(Xen window, Xen rect, Xen invalidate_children)
{
  #define H_gdk_window_invalidate_rect "void gdk_window_invalidate_rect(GdkWindow* window, GdkRectangle* rect, \
gboolean invalidate_children)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_invalidate_rect", "GdkWindow*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 2, "gdk_window_invalidate_rect", "GdkRectangle*");
  Xen_check_type(Xen_is_gboolean(invalidate_children), invalidate_children, 3, "gdk_window_invalidate_rect", "gboolean");
  gdk_window_invalidate_rect(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkRectangle_(rect), Xen_to_C_gboolean(invalidate_children));
  return(Xen_false);
}

static Xen gxg_gdk_window_freeze_updates(Xen window)
{
  #define H_gdk_window_freeze_updates "void gdk_window_freeze_updates(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_freeze_updates", "GdkWindow*");
  gdk_window_freeze_updates(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_thaw_updates(Xen window)
{
  #define H_gdk_window_thaw_updates "void gdk_window_thaw_updates(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_thaw_updates", "GdkWindow*");
  gdk_window_thaw_updates(Xen_to_C_GdkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gdk_window_constrain_size(Xen geometry, Xen flags, Xen width, Xen height, Xen ignore_new_width, Xen ignore_new_height)
{
  #define H_gdk_window_constrain_size "void gdk_window_constrain_size(GdkGeometry* geometry, GdkWindowHints flags, \
gint width, gint height, gint* [new_width], gint* [new_height])"
  gint ref_new_width;
  gint ref_new_height;
  Xen_check_type(Xen_is_GdkGeometry_(geometry), geometry, 1, "gdk_window_constrain_size", "GdkGeometry*");
  Xen_check_type(Xen_is_GdkWindowHints(flags), flags, 2, "gdk_window_constrain_size", "GdkWindowHints");
  Xen_check_type(Xen_is_gint(width), width, 3, "gdk_window_constrain_size", "gint");
  Xen_check_type(Xen_is_gint(height), height, 4, "gdk_window_constrain_size", "gint");
  gdk_window_constrain_size(Xen_to_C_GdkGeometry_(geometry), Xen_to_C_GdkWindowHints(flags), Xen_to_C_gint(width), Xen_to_C_gint(height), 
                            &ref_new_width, &ref_new_height);
  return(Xen_list_2(C_to_Xen_gint(ref_new_width), C_to_Xen_gint(ref_new_height)));
}

static Xen gxg_gdk_window_set_type_hint(Xen window, Xen hint)
{
  #define H_gdk_window_set_type_hint "void gdk_window_set_type_hint(GdkWindow* window, GdkWindowTypeHint hint)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_type_hint", "GdkWindow*");
  Xen_check_type(Xen_is_GdkWindowTypeHint(hint), hint, 2, "gdk_window_set_type_hint", "GdkWindowTypeHint");
  gdk_window_set_type_hint(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkWindowTypeHint(hint));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_modal_hint(Xen window, Xen modal)
{
  #define H_gdk_window_set_modal_hint "void gdk_window_set_modal_hint(GdkWindow* window, gboolean modal)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_modal_hint", "GdkWindow*");
  Xen_check_type(Xen_is_gboolean(modal), modal, 2, "gdk_window_set_modal_hint", "gboolean");
  gdk_window_set_modal_hint(Xen_to_C_GdkWindow_(window), Xen_to_C_gboolean(modal));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_title(Xen window, Xen title)
{
  #define H_gdk_window_set_title "void gdk_window_set_title(GdkWindow* window, gchar* title)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_title", "GdkWindow*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gdk_window_set_title", "gchar*");
  gdk_window_set_title(Xen_to_C_GdkWindow_(window), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_role(Xen window, Xen role)
{
  #define H_gdk_window_set_role "void gdk_window_set_role(GdkWindow* window, gchar* role)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_role", "GdkWindow*");
  Xen_check_type(Xen_is_gchar_(role), role, 2, "gdk_window_set_role", "gchar*");
  gdk_window_set_role(Xen_to_C_GdkWindow_(window), Xen_to_C_gchar_(role));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_transient_for(Xen window, Xen parent)
{
  #define H_gdk_window_set_transient_for "void gdk_window_set_transient_for(GdkWindow* window, GdkWindow* parent)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_transient_for", "GdkWindow*");
  Xen_check_type(Xen_is_GdkWindow_(parent), parent, 2, "gdk_window_set_transient_for", "GdkWindow*");
  gdk_window_set_transient_for(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkWindow_(parent));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_cursor(Xen window, Xen cursor)
{
  #define H_gdk_window_set_cursor "void gdk_window_set_cursor(GdkWindow* window, GdkCursor* cursor)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_cursor", "GdkWindow*");
  Xen_check_type(Xen_is_GdkCursor_(cursor), cursor, 2, "gdk_window_set_cursor", "GdkCursor*");
  gdk_window_set_cursor(Xen_to_C_GdkWindow_(window), Xen_to_C_GdkCursor_(cursor));
  return(Xen_false);
}

static Xen gxg_gdk_window_get_user_data(Xen window, Xen ignore_data)
{
  #define H_gdk_window_get_user_data "void gdk_window_get_user_data(GdkWindow* window, gpointer* [data])"
  gpointer ref_data;
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_user_data", "GdkWindow*");
  gdk_window_get_user_data(Xen_to_C_GdkWindow_(window), &ref_data);
  return(Xen_list_1(C_to_Xen_gpointer(ref_data)));
}

static Xen gxg_gdk_window_get_position(Xen window, Xen ignore_x, Xen ignore_y)
{
  #define H_gdk_window_get_position "void gdk_window_get_position(GdkWindow* window, gint* [x], gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_position", "GdkWindow*");
  gdk_window_get_position(Xen_to_C_GdkWindow_(window), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gdk_window_get_origin(Xen window, Xen ignore_x, Xen ignore_y)
{
  #define H_gdk_window_get_origin "gint gdk_window_get_origin(GdkWindow* window, gint* [x], gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_origin", "GdkWindow*");
  {
    Xen result;
    result = C_to_Xen_gint(gdk_window_get_origin(Xen_to_C_GdkWindow_(window), &ref_x, &ref_y));
    return(Xen_list_3(result, C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
   }
}

static Xen gxg_gdk_pixbuf_error_quark(void)
{
  #define H_gdk_pixbuf_error_quark "GQuark gdk_pixbuf_error_quark( void)"
  return(C_to_Xen_GQuark(gdk_pixbuf_error_quark()));
}

static Xen gxg_gdk_pixbuf_get_colorspace(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_colorspace "GdkColorspace gdk_pixbuf_get_colorspace(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_colorspace", "GdkPixbuf*");
  return(C_to_Xen_GdkColorspace(gdk_pixbuf_get_colorspace(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_n_channels(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_n_channels "int gdk_pixbuf_get_n_channels(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_n_channels", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_n_channels(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_has_alpha(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_has_alpha "gboolean gdk_pixbuf_get_has_alpha(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_has_alpha", "GdkPixbuf*");
  return(C_to_Xen_gboolean(gdk_pixbuf_get_has_alpha(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_bits_per_sample(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_bits_per_sample "int gdk_pixbuf_get_bits_per_sample(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_bits_per_sample", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_bits_per_sample(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_pixels(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_pixels "guchar* gdk_pixbuf_get_pixels(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_pixels", "GdkPixbuf*");
  return(C_to_Xen_guchar_(gdk_pixbuf_get_pixels(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_width(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_width "int gdk_pixbuf_get_width(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_width", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_width(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_height(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_height "int gdk_pixbuf_get_height(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_height", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_height(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_get_rowstride(Xen pixbuf)
{
  #define H_gdk_pixbuf_get_rowstride "int gdk_pixbuf_get_rowstride(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_rowstride", "GdkPixbuf*");
  return(C_to_Xen_int(gdk_pixbuf_get_rowstride(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_new(Xen colorspace, Xen has_alpha, Xen bits_per_sample, Xen width, Xen height)
{
  #define H_gdk_pixbuf_new "GdkPixbuf* gdk_pixbuf_new(GdkColorspace colorspace, gboolean has_alpha, int bits_per_sample, \
int width, int height)"
  Xen_check_type(Xen_is_GdkColorspace(colorspace), colorspace, 1, "gdk_pixbuf_new", "GdkColorspace");
  Xen_check_type(Xen_is_gboolean(has_alpha), has_alpha, 2, "gdk_pixbuf_new", "gboolean");
  Xen_check_type(Xen_is_int(bits_per_sample), bits_per_sample, 3, "gdk_pixbuf_new", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "gdk_pixbuf_new", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "gdk_pixbuf_new", "int");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new(Xen_to_C_GdkColorspace(colorspace), Xen_to_C_gboolean(has_alpha), Xen_to_C_int(bits_per_sample), 
                                            Xen_to_C_int(width), Xen_to_C_int(height))));
}

static Xen gxg_gdk_pixbuf_copy(Xen pixbuf)
{
  #define H_gdk_pixbuf_copy "GdkPixbuf* gdk_pixbuf_copy(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_copy", "GdkPixbuf*");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_copy(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gdk_pixbuf_new_subpixbuf(Xen src_pixbuf, Xen src_x, Xen src_y, Xen width, Xen height)
{
  #define H_gdk_pixbuf_new_subpixbuf "GdkPixbuf* gdk_pixbuf_new_subpixbuf(GdkPixbuf* src_pixbuf, int src_x, \
int src_y, int width, int height)"
  Xen_check_type(Xen_is_GdkPixbuf_(src_pixbuf), src_pixbuf, 1, "gdk_pixbuf_new_subpixbuf", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(src_x), src_x, 2, "gdk_pixbuf_new_subpixbuf", "int");
  Xen_check_type(Xen_is_int(src_y), src_y, 3, "gdk_pixbuf_new_subpixbuf", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "gdk_pixbuf_new_subpixbuf", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "gdk_pixbuf_new_subpixbuf", "int");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_subpixbuf(Xen_to_C_GdkPixbuf_(src_pixbuf), Xen_to_C_int(src_x), Xen_to_C_int(src_y), 
                                                      Xen_to_C_int(width), Xen_to_C_int(height))));
}

static Xen gxg_gdk_pixbuf_new_from_file(Xen filename, Xen ignore_error)
{
  #define H_gdk_pixbuf_new_from_file "GdkPixbuf* gdk_pixbuf_new_from_file(char* filename, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_char_(filename), filename, 1, "gdk_pixbuf_new_from_file", "char*");
  {
    Xen result;
    result = C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_from_file(Xen_to_C_char_(filename), &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gdk_pixbuf_new_from_data(Xen arglist)
{
  #define H_gdk_pixbuf_new_from_data "GdkPixbuf* gdk_pixbuf_new_from_data(guchar* data, GdkColorspace colorspace, \
gboolean has_alpha, int bits_per_sample, int width, int height, int rowstride, GdkPixbufDestroyNotify destroy_fn, \
gpointer destroy_fn_data)"
  Xen data, colorspace, has_alpha, bits_per_sample, width, height, rowstride, destroy_fn, destroy_fn_data;
  data = Xen_list_ref(arglist, 0);
  colorspace = Xen_list_ref(arglist, 1);
  has_alpha = Xen_list_ref(arglist, 2);
  bits_per_sample = Xen_list_ref(arglist, 3);
  width = Xen_list_ref(arglist, 4);
  height = Xen_list_ref(arglist, 5);
  rowstride = Xen_list_ref(arglist, 6);
  destroy_fn = Xen_list_ref(arglist, 7);
  destroy_fn_data = Xen_list_ref(arglist, 8);
  Xen_check_type(Xen_is_guchar_(data), data, 1, "gdk_pixbuf_new_from_data", "guchar*");
  Xen_check_type(Xen_is_GdkColorspace(colorspace), colorspace, 2, "gdk_pixbuf_new_from_data", "GdkColorspace");
  Xen_check_type(Xen_is_gboolean(has_alpha), has_alpha, 3, "gdk_pixbuf_new_from_data", "gboolean");
  Xen_check_type(Xen_is_int(bits_per_sample), bits_per_sample, 4, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_int(width), width, 5, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_int(height), height, 6, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_int(rowstride), rowstride, 7, "gdk_pixbuf_new_from_data", "int");
  Xen_check_type(Xen_is_GdkPixbufDestroyNotify(destroy_fn), destroy_fn, 8, "gdk_pixbuf_new_from_data", "GdkPixbufDestroyNotify");
  Xen_check_type(Xen_is_gpointer(destroy_fn_data), destroy_fn_data, 9, "gdk_pixbuf_new_from_data", "gpointer");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_from_data(Xen_to_C_guchar_(data), Xen_to_C_GdkColorspace(colorspace), Xen_to_C_gboolean(has_alpha), 
                                                      Xen_to_C_int(bits_per_sample), Xen_to_C_int(width), Xen_to_C_int(height), 
                                                      Xen_to_C_int(rowstride), Xen_to_C_GdkPixbufDestroyNotify(destroy_fn), 
                                                      Xen_to_C_gpointer(destroy_fn_data))));
}

static Xen gxg_gdk_pixbuf_new_from_xpm_data(Xen data)
{
  #define H_gdk_pixbuf_new_from_xpm_data "GdkPixbuf* gdk_pixbuf_new_from_xpm_data(char** data)"
  Xen_check_type(Xen_is_char__(data), data, 1, "gdk_pixbuf_new_from_xpm_data", "char**");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_new_from_xpm_data((const char**)Xen_to_C_char__(data))));
}

static Xen gxg_gdk_pixbuf_fill(Xen pixbuf, Xen pixel)
{
  #define H_gdk_pixbuf_fill "void gdk_pixbuf_fill(GdkPixbuf* pixbuf, guint32 pixel)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_fill", "GdkPixbuf*");
  Xen_check_type(Xen_is_guint32(pixel), pixel, 2, "gdk_pixbuf_fill", "guint32");
  gdk_pixbuf_fill(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_guint32(pixel));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_savev(Xen pixbuf, Xen filename, Xen type, Xen option_keys, Xen option_values, Xen ignore_error)
{
  #define H_gdk_pixbuf_savev "gboolean gdk_pixbuf_savev(GdkPixbuf* pixbuf, char* filename, char* type, \
char** option_keys, char** option_values, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_savev", "GdkPixbuf*");
  Xen_check_type(Xen_is_char_(filename), filename, 2, "gdk_pixbuf_savev", "char*");
  Xen_check_type(Xen_is_char_(type), type, 3, "gdk_pixbuf_savev", "char*");
  Xen_check_type(Xen_is_char__(option_keys), option_keys, 4, "gdk_pixbuf_savev", "char**");
  Xen_check_type(Xen_is_char__(option_values), option_values, 5, "gdk_pixbuf_savev", "char**");
  {
    Xen result;
    result = C_to_Xen_gboolean(gdk_pixbuf_savev(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_char_(filename), Xen_to_C_char_(type), 
                                                Xen_to_C_char__(option_keys), Xen_to_C_char__(option_values), &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gdk_pixbuf_add_alpha(Xen pixbuf, Xen substitute_color, Xen r, Xen g, Xen b)
{
  #define H_gdk_pixbuf_add_alpha "GdkPixbuf* gdk_pixbuf_add_alpha(GdkPixbuf* pixbuf, gboolean substitute_color, \
guchar r, guchar g, guchar b)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_add_alpha", "GdkPixbuf*");
  Xen_check_type(Xen_is_gboolean(substitute_color), substitute_color, 2, "gdk_pixbuf_add_alpha", "gboolean");
  Xen_check_type(Xen_is_guchar(r), r, 3, "gdk_pixbuf_add_alpha", "guchar");
  Xen_check_type(Xen_is_guchar(g), g, 4, "gdk_pixbuf_add_alpha", "guchar");
  Xen_check_type(Xen_is_guchar(b), b, 5, "gdk_pixbuf_add_alpha", "guchar");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_add_alpha(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_gboolean(substitute_color), Xen_to_C_guchar(r), 
                                                  Xen_to_C_guchar(g), Xen_to_C_guchar(b))));
}

static Xen gxg_gdk_pixbuf_copy_area(Xen arglist)
{
  #define H_gdk_pixbuf_copy_area "void gdk_pixbuf_copy_area(GdkPixbuf* src_pixbuf, int src_x, int src_y, \
int width, int height, GdkPixbuf* dest_pixbuf, int dest_x, int dest_y)"
  Xen src_pixbuf, src_x, src_y, width, height, dest_pixbuf, dest_x, dest_y;
  src_pixbuf = Xen_list_ref(arglist, 0);
  src_x = Xen_list_ref(arglist, 1);
  src_y = Xen_list_ref(arglist, 2);
  width = Xen_list_ref(arglist, 3);
  height = Xen_list_ref(arglist, 4);
  dest_pixbuf = Xen_list_ref(arglist, 5);
  dest_x = Xen_list_ref(arglist, 6);
  dest_y = Xen_list_ref(arglist, 7);
  Xen_check_type(Xen_is_GdkPixbuf_(src_pixbuf), src_pixbuf, 1, "gdk_pixbuf_copy_area", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(src_x), src_x, 2, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(src_y), src_y, 3, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_GdkPixbuf_(dest_pixbuf), dest_pixbuf, 6, "gdk_pixbuf_copy_area", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 7, "gdk_pixbuf_copy_area", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 8, "gdk_pixbuf_copy_area", "int");
  gdk_pixbuf_copy_area(Xen_to_C_GdkPixbuf_(src_pixbuf), Xen_to_C_int(src_x), Xen_to_C_int(src_y), Xen_to_C_int(width), Xen_to_C_int(height), 
                       Xen_to_C_GdkPixbuf_(dest_pixbuf), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_saturate_and_pixelate(Xen src, Xen dest, Xen saturation, Xen pixelate)
{
  #define H_gdk_pixbuf_saturate_and_pixelate "void gdk_pixbuf_saturate_and_pixelate(GdkPixbuf* src, GdkPixbuf* dest, \
gfloat saturation, gboolean pixelate)"
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_saturate_and_pixelate", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_saturate_and_pixelate", "GdkPixbuf*");
  Xen_check_type(Xen_is_gfloat(saturation), saturation, 3, "gdk_pixbuf_saturate_and_pixelate", "gfloat");
  Xen_check_type(Xen_is_gboolean(pixelate), pixelate, 4, "gdk_pixbuf_saturate_and_pixelate", "gboolean");
  gdk_pixbuf_saturate_and_pixelate(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_gfloat(saturation), Xen_to_C_gboolean(pixelate));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_scale(Xen arglist)
{
  #define H_gdk_pixbuf_scale "void gdk_pixbuf_scale(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, int dest_y, \
int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, GdkInterpType interp_type)"
  Xen src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type;
  src = Xen_list_ref(arglist, 0);
  dest = Xen_list_ref(arglist, 1);
  dest_x = Xen_list_ref(arglist, 2);
  dest_y = Xen_list_ref(arglist, 3);
  dest_width = Xen_list_ref(arglist, 4);
  dest_height = Xen_list_ref(arglist, 5);
  offset_x = Xen_list_ref(arglist, 6);
  offset_y = Xen_list_ref(arglist, 7);
  scale_x = Xen_list_ref(arglist, 8);
  scale_y = Xen_list_ref(arglist, 9);
  interp_type = Xen_list_ref(arglist, 10);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_scale", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_scale", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 3, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 4, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 5, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 6, "gdk_pixbuf_scale", "int");
  Xen_check_type(Xen_is_double(offset_x), offset_x, 7, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_double(offset_y), offset_y, 8, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_double(scale_x), scale_x, 9, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_double(scale_y), scale_y, 10, "gdk_pixbuf_scale", "double");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 11, "gdk_pixbuf_scale", "GdkInterpType");
  gdk_pixbuf_scale(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y), Xen_to_C_int(dest_width), 
                   Xen_to_C_int(dest_height), Xen_to_C_double(offset_x), Xen_to_C_double(offset_y), Xen_to_C_double(scale_x), 
                   Xen_to_C_double(scale_y), Xen_to_C_GdkInterpType(interp_type));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_composite(Xen arglist)
{
  #define H_gdk_pixbuf_composite "void gdk_pixbuf_composite(GdkPixbuf* src, GdkPixbuf* dest, int dest_x, \
int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, double scale_y, \
GdkInterpType interp_type, int overall_alpha)"
  Xen src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha;
  src = Xen_list_ref(arglist, 0);
  dest = Xen_list_ref(arglist, 1);
  dest_x = Xen_list_ref(arglist, 2);
  dest_y = Xen_list_ref(arglist, 3);
  dest_width = Xen_list_ref(arglist, 4);
  dest_height = Xen_list_ref(arglist, 5);
  offset_x = Xen_list_ref(arglist, 6);
  offset_y = Xen_list_ref(arglist, 7);
  scale_x = Xen_list_ref(arglist, 8);
  scale_y = Xen_list_ref(arglist, 9);
  interp_type = Xen_list_ref(arglist, 10);
  overall_alpha = Xen_list_ref(arglist, 11);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_composite", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_composite", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 3, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 4, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 5, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 6, "gdk_pixbuf_composite", "int");
  Xen_check_type(Xen_is_double(offset_x), offset_x, 7, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_double(offset_y), offset_y, 8, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_double(scale_x), scale_x, 9, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_double(scale_y), scale_y, 10, "gdk_pixbuf_composite", "double");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 11, "gdk_pixbuf_composite", "GdkInterpType");
  Xen_check_type(Xen_is_int(overall_alpha), overall_alpha, 12, "gdk_pixbuf_composite", "int");
  gdk_pixbuf_composite(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y), Xen_to_C_int(dest_width), 
                       Xen_to_C_int(dest_height), Xen_to_C_double(offset_x), Xen_to_C_double(offset_y), Xen_to_C_double(scale_x), 
                       Xen_to_C_double(scale_y), Xen_to_C_GdkInterpType(interp_type), Xen_to_C_int(overall_alpha));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_composite_color(Xen arglist)
{
  #define H_gdk_pixbuf_composite_color "void gdk_pixbuf_composite_color(GdkPixbuf* src, GdkPixbuf* dest, \
int dest_x, int dest_y, int dest_width, int dest_height, double offset_x, double offset_y, double scale_x, \
double scale_y, GdkInterpType interp_type, int overall_alpha, int check_x, int check_y, int check_size, \
guint32 color1, guint32 color2)"
  Xen src, dest, dest_x, dest_y, dest_width, dest_height, offset_x, offset_y, scale_x, scale_y, interp_type, overall_alpha, check_x, check_y, check_size, color1, color2;
  src = Xen_list_ref(arglist, 0);
  dest = Xen_list_ref(arglist, 1);
  dest_x = Xen_list_ref(arglist, 2);
  dest_y = Xen_list_ref(arglist, 3);
  dest_width = Xen_list_ref(arglist, 4);
  dest_height = Xen_list_ref(arglist, 5);
  offset_x = Xen_list_ref(arglist, 6);
  offset_y = Xen_list_ref(arglist, 7);
  scale_x = Xen_list_ref(arglist, 8);
  scale_y = Xen_list_ref(arglist, 9);
  interp_type = Xen_list_ref(arglist, 10);
  overall_alpha = Xen_list_ref(arglist, 11);
  check_x = Xen_list_ref(arglist, 12);
  check_y = Xen_list_ref(arglist, 13);
  check_size = Xen_list_ref(arglist, 14);
  color1 = Xen_list_ref(arglist, 15);
  color2 = Xen_list_ref(arglist, 16);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_composite_color", "GdkPixbuf*");
  Xen_check_type(Xen_is_GdkPixbuf_(dest), dest, 2, "gdk_pixbuf_composite_color", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_x), dest_x, 3, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(dest_y), dest_y, 4, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 5, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 6, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_double(offset_x), offset_x, 7, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_double(offset_y), offset_y, 8, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_double(scale_x), scale_x, 9, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_double(scale_y), scale_y, 10, "gdk_pixbuf_composite_color", "double");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 11, "gdk_pixbuf_composite_color", "GdkInterpType");
  Xen_check_type(Xen_is_int(overall_alpha), overall_alpha, 12, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(check_x), check_x, 13, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(check_y), check_y, 14, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_int(check_size), check_size, 15, "gdk_pixbuf_composite_color", "int");
  Xen_check_type(Xen_is_guint32(color1), color1, 16, "gdk_pixbuf_composite_color", "guint32");
  Xen_check_type(Xen_is_guint32(color2), color2, 17, "gdk_pixbuf_composite_color", "guint32");
  gdk_pixbuf_composite_color(Xen_to_C_GdkPixbuf_(src), Xen_to_C_GdkPixbuf_(dest), Xen_to_C_int(dest_x), Xen_to_C_int(dest_y), 
                             Xen_to_C_int(dest_width), Xen_to_C_int(dest_height), Xen_to_C_double(offset_x), Xen_to_C_double(offset_y), 
                             Xen_to_C_double(scale_x), Xen_to_C_double(scale_y), Xen_to_C_GdkInterpType(interp_type), Xen_to_C_int(overall_alpha), 
                             Xen_to_C_int(check_x), Xen_to_C_int(check_y), Xen_to_C_int(check_size), Xen_to_C_guint32(color1), 
                             Xen_to_C_guint32(color2));
  return(Xen_false);
}

static Xen gxg_gdk_pixbuf_scale_simple(Xen src, Xen dest_width, Xen dest_height, Xen interp_type)
{
  #define H_gdk_pixbuf_scale_simple "GdkPixbuf* gdk_pixbuf_scale_simple(GdkPixbuf* src, int dest_width, \
int dest_height, GdkInterpType interp_type)"
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_scale_simple", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 2, "gdk_pixbuf_scale_simple", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 3, "gdk_pixbuf_scale_simple", "int");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 4, "gdk_pixbuf_scale_simple", "GdkInterpType");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_scale_simple(Xen_to_C_GdkPixbuf_(src), Xen_to_C_int(dest_width), Xen_to_C_int(dest_height), 
                                                     Xen_to_C_GdkInterpType(interp_type))));
}

static Xen gxg_gdk_pixbuf_composite_color_simple(Xen arglist)
{
  #define H_gdk_pixbuf_composite_color_simple "GdkPixbuf* gdk_pixbuf_composite_color_simple(GdkPixbuf* src, \
int dest_width, int dest_height, GdkInterpType interp_type, int overall_alpha, int check_size, guint32 color1, \
guint32 color2)"
  Xen src, dest_width, dest_height, interp_type, overall_alpha, check_size, color1, color2;
  src = Xen_list_ref(arglist, 0);
  dest_width = Xen_list_ref(arglist, 1);
  dest_height = Xen_list_ref(arglist, 2);
  interp_type = Xen_list_ref(arglist, 3);
  overall_alpha = Xen_list_ref(arglist, 4);
  check_size = Xen_list_ref(arglist, 5);
  color1 = Xen_list_ref(arglist, 6);
  color2 = Xen_list_ref(arglist, 7);
  Xen_check_type(Xen_is_GdkPixbuf_(src), src, 1, "gdk_pixbuf_composite_color_simple", "GdkPixbuf*");
  Xen_check_type(Xen_is_int(dest_width), dest_width, 2, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_int(dest_height), dest_height, 3, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_GdkInterpType(interp_type), interp_type, 4, "gdk_pixbuf_composite_color_simple", "GdkInterpType");
  Xen_check_type(Xen_is_int(overall_alpha), overall_alpha, 5, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_int(check_size), check_size, 6, "gdk_pixbuf_composite_color_simple", "int");
  Xen_check_type(Xen_is_guint32(color1), color1, 7, "gdk_pixbuf_composite_color_simple", "guint32");
  Xen_check_type(Xen_is_guint32(color2), color2, 8, "gdk_pixbuf_composite_color_simple", "guint32");
  return(C_to_Xen_GdkPixbuf_(gdk_pixbuf_composite_color_simple(Xen_to_C_GdkPixbuf_(src), Xen_to_C_int(dest_width), Xen_to_C_int(dest_height), 
                                                               Xen_to_C_GdkInterpType(interp_type), Xen_to_C_int(overall_alpha), 
                                                               Xen_to_C_int(check_size), Xen_to_C_guint32(color1), Xen_to_C_guint32(color2))));
}

static Xen gxg_gdk_pixbuf_get_option(Xen pixbuf, Xen key)
{
  #define H_gdk_pixbuf_get_option "gchar* gdk_pixbuf_get_option(GdkPixbuf* pixbuf, gchar* key)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf), pixbuf, 1, "gdk_pixbuf_get_option", "GdkPixbuf*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "gdk_pixbuf_get_option", "gchar*");
  return(C_to_Xen_gchar_(gdk_pixbuf_get_option(Xen_to_C_GdkPixbuf_(pixbuf), Xen_to_C_gchar_(key))));
}

static Xen gxg_gtk_accel_group_new(void)
{
  #define H_gtk_accel_group_new "GtkAccelGroup* gtk_accel_group_new( void)"
  return(C_to_Xen_GtkAccelGroup_(gtk_accel_group_new()));
}

static Xen gxg_gtk_accel_group_lock(Xen accel_group)
{
  #define H_gtk_accel_group_lock "void gtk_accel_group_lock(GtkAccelGroup* accel_group)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_lock", "GtkAccelGroup*");
  gtk_accel_group_lock(Xen_to_C_GtkAccelGroup_(accel_group));
  return(Xen_false);
}

static Xen gxg_gtk_accel_group_unlock(Xen accel_group)
{
  #define H_gtk_accel_group_unlock "void gtk_accel_group_unlock(GtkAccelGroup* accel_group)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_unlock", "GtkAccelGroup*");
  gtk_accel_group_unlock(Xen_to_C_GtkAccelGroup_(accel_group));
  return(Xen_false);
}

static Xen gxg_gtk_accel_group_connect(Xen accel_group, Xen accel_key, Xen accel_mods, Xen accel_flags, Xen closure)
{
  #define H_gtk_accel_group_connect "void gtk_accel_group_connect(GtkAccelGroup* accel_group, guint accel_key, \
GdkModifierType accel_mods, GtkAccelFlags accel_flags, GClosure* closure)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_connect", "GtkAccelGroup*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 2, "gtk_accel_group_connect", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 3, "gtk_accel_group_connect", "GdkModifierType");
  Xen_check_type(Xen_is_GtkAccelFlags(accel_flags), accel_flags, 4, "gtk_accel_group_connect", "GtkAccelFlags");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 5, "gtk_accel_group_connect", "GClosure*");
  gtk_accel_group_connect(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods), 
                          Xen_to_C_GtkAccelFlags(accel_flags), Xen_to_C_GClosure_(closure));
  return(Xen_false);
}

static Xen gxg_gtk_accel_group_connect_by_path(Xen accel_group, Xen accel_path, Xen closure)
{
  #define H_gtk_accel_group_connect_by_path "void gtk_accel_group_connect_by_path(GtkAccelGroup* accel_group, \
gchar* accel_path, GClosure* closure)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_connect_by_path", "GtkAccelGroup*");
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 2, "gtk_accel_group_connect_by_path", "gchar*");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 3, "gtk_accel_group_connect_by_path", "GClosure*");
  gtk_accel_group_connect_by_path(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_gchar_(accel_path), Xen_to_C_GClosure_(closure));
  return(Xen_false);
}

static Xen gxg_gtk_accel_group_disconnect(Xen accel_group, Xen closure)
{
  #define H_gtk_accel_group_disconnect "gboolean gtk_accel_group_disconnect(GtkAccelGroup* accel_group, \
GClosure* closure)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_disconnect", "GtkAccelGroup*");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 2, "gtk_accel_group_disconnect", "GClosure*");
  return(C_to_Xen_gboolean(gtk_accel_group_disconnect(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_GClosure_(closure))));
}

static Xen gxg_gtk_accel_group_disconnect_key(Xen accel_group, Xen accel_key, Xen accel_mods)
{
  #define H_gtk_accel_group_disconnect_key "gboolean gtk_accel_group_disconnect_key(GtkAccelGroup* accel_group, \
guint accel_key, GdkModifierType accel_mods)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_disconnect_key", "GtkAccelGroup*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 2, "gtk_accel_group_disconnect_key", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 3, "gtk_accel_group_disconnect_key", "GdkModifierType");
  return(C_to_Xen_gboolean(gtk_accel_group_disconnect_key(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_guint(accel_key), 
                                                          Xen_to_C_GdkModifierType(accel_mods))));
}

static Xen gxg_gtk_accel_groups_activate(Xen object, Xen accel_key, Xen accel_mods)
{
  #define H_gtk_accel_groups_activate "gboolean gtk_accel_groups_activate(GObject* object, guint accel_key, \
GdkModifierType accel_mods)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "gtk_accel_groups_activate", "GObject*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 2, "gtk_accel_groups_activate", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 3, "gtk_accel_groups_activate", "GdkModifierType");
  return(C_to_Xen_gboolean(gtk_accel_groups_activate(Xen_to_C_GObject_(object), Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods))));
}

static Xen gxg_gtk_accel_groups_from_object(Xen object)
{
  #define H_gtk_accel_groups_from_object "GSList* gtk_accel_groups_from_object(GObject* object)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "gtk_accel_groups_from_object", "GObject*");
  return(C_to_Xen_GSList_(gtk_accel_groups_from_object(Xen_to_C_GObject_(object))));
}

static Xen gxg_gtk_accel_group_find(Xen accel_group, Xen func, Xen func_info)
{
  #define H_gtk_accel_group_find "GtkAccelKey* gtk_accel_group_find(GtkAccelGroup* accel_group, lambda3 func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_find", "GtkAccelGroup*");
  Xen_check_type(Xen_is_lambda3(func), func, 2, "gtk_accel_group_find", "lambda3");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_accel_group_find", "lambda_data");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_GtkAccelKey_(gtk_accel_group_find(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_lambda3(func), Xen_to_C_lambda_data(func_info)));
    xm_unprotect_at(loc);
    return(result);
   }
}

static Xen gxg_gtk_accel_group_from_accel_closure(Xen closure)
{
  #define H_gtk_accel_group_from_accel_closure "GtkAccelGroup* gtk_accel_group_from_accel_closure(GClosure* closure)"
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 1, "gtk_accel_group_from_accel_closure", "GClosure*");
  return(C_to_Xen_GtkAccelGroup_(gtk_accel_group_from_accel_closure(Xen_to_C_GClosure_(closure))));
}

static Xen gxg_gtk_accelerator_valid(Xen keyval, Xen modifiers)
{
  #define H_gtk_accelerator_valid "gboolean gtk_accelerator_valid(guint keyval, GdkModifierType modifiers)"
  Xen_check_type(Xen_is_guint(keyval), keyval, 1, "gtk_accelerator_valid", "guint");
  Xen_check_type(Xen_is_GdkModifierType(modifiers), modifiers, 2, "gtk_accelerator_valid", "GdkModifierType");
  return(C_to_Xen_gboolean(gtk_accelerator_valid(Xen_to_C_guint(keyval), Xen_to_C_GdkModifierType(modifiers))));
}

static Xen gxg_gtk_accelerator_parse(Xen accelerator, Xen ignore_accelerator_key, Xen ignore_accelerator_mods)
{
  #define H_gtk_accelerator_parse "void gtk_accelerator_parse(gchar* accelerator, guint* [accelerator_key], \
GdkModifierType* [accelerator_mods])"
  guint ref_accelerator_key;
  GdkModifierType ref_accelerator_mods;
  Xen_check_type(Xen_is_gchar_(accelerator), accelerator, 1, "gtk_accelerator_parse", "gchar*");
  gtk_accelerator_parse(Xen_to_C_gchar_(accelerator), &ref_accelerator_key, &ref_accelerator_mods);
  return(Xen_list_2(C_to_Xen_guint(ref_accelerator_key), C_to_Xen_GdkModifierType(ref_accelerator_mods)));
}

static Xen gxg_gtk_accelerator_name(Xen accelerator_key, Xen accelerator_mods)
{
  #define H_gtk_accelerator_name "gchar* gtk_accelerator_name(guint accelerator_key, GdkModifierType accelerator_mods)"
  Xen_check_type(Xen_is_guint(accelerator_key), accelerator_key, 1, "gtk_accelerator_name", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accelerator_mods), accelerator_mods, 2, "gtk_accelerator_name", "GdkModifierType");
  {
   gchar* result;
   Xen rtn;
   result = gtk_accelerator_name(Xen_to_C_guint(accelerator_key), Xen_to_C_GdkModifierType(accelerator_mods));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_accelerator_set_default_mod_mask(Xen default_mod_mask)
{
  #define H_gtk_accelerator_set_default_mod_mask "void gtk_accelerator_set_default_mod_mask(GdkModifierType default_mod_mask)"
  Xen_check_type(Xen_is_GdkModifierType(default_mod_mask), default_mod_mask, 1, "gtk_accelerator_set_default_mod_mask", "GdkModifierType");
  gtk_accelerator_set_default_mod_mask(Xen_to_C_GdkModifierType(default_mod_mask));
  return(Xen_false);
}

static Xen gxg_gtk_accel_group_query(Xen accel_group, Xen accel_key, Xen accel_mods, Xen ignore_n_entries)
{
  #define H_gtk_accel_group_query "GtkAccelGroupEntry* gtk_accel_group_query(GtkAccelGroup* accel_group, \
guint accel_key, GdkModifierType accel_mods, guint* [n_entries])"
  guint ref_n_entries;
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_query", "GtkAccelGroup*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 2, "gtk_accel_group_query", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 3, "gtk_accel_group_query", "GdkModifierType");
  {
    Xen result;
    result = C_to_Xen_GtkAccelGroupEntry_(gtk_accel_group_query(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_guint(accel_key), 
                                                                Xen_to_C_GdkModifierType(accel_mods), &ref_n_entries));
    return(Xen_list_2(result, C_to_Xen_guint(ref_n_entries)));
   }
}

static Xen gxg_gtk_accel_group_activate(Xen accel_group, Xen accel_quark, Xen acceleratable, Xen accel_key, Xen accel_mods)
{
  #define H_gtk_accel_group_activate "gboolean gtk_accel_group_activate(GtkAccelGroup* accel_group, GQuark accel_quark, \
GObject* acceleratable, guint accel_key, GdkModifierType accel_mods)"
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 1, "gtk_accel_group_activate", "GtkAccelGroup*");
  Xen_check_type(Xen_is_GQuark(accel_quark), accel_quark, 2, "gtk_accel_group_activate", "GQuark");
  Xen_check_type(Xen_is_GObject_(acceleratable), acceleratable, 3, "gtk_accel_group_activate", "GObject*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 4, "gtk_accel_group_activate", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 5, "gtk_accel_group_activate", "GdkModifierType");
  return(C_to_Xen_gboolean(gtk_accel_group_activate(Xen_to_C_GtkAccelGroup_(accel_group), Xen_to_C_GQuark(accel_quark), Xen_to_C_GObject_(acceleratable), 
                                                    Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods))));
}

static Xen gxg_gtk_accel_label_new(Xen string)
{
  #define H_gtk_accel_label_new "GtkWidget* gtk_accel_label_new(gchar* string)"
  Xen_check_type(Xen_is_gchar_(string), string, 1, "gtk_accel_label_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_accel_label_new(Xen_to_C_gchar_(string))));
}

static Xen gxg_gtk_accel_label_get_accel_widget(Xen accel_label)
{
  #define H_gtk_accel_label_get_accel_widget "GtkWidget* gtk_accel_label_get_accel_widget(GtkAccelLabel* accel_label)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_get_accel_widget", "GtkAccelLabel*");
  return(C_to_Xen_GtkWidget_(gtk_accel_label_get_accel_widget(Xen_to_C_GtkAccelLabel_(accel_label))));
}

static Xen gxg_gtk_accel_label_get_accel_width(Xen accel_label)
{
  #define H_gtk_accel_label_get_accel_width "guint gtk_accel_label_get_accel_width(GtkAccelLabel* accel_label)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_get_accel_width", "GtkAccelLabel*");
  return(C_to_Xen_guint(gtk_accel_label_get_accel_width(Xen_to_C_GtkAccelLabel_(accel_label))));
}

static Xen gxg_gtk_accel_label_set_accel_widget(Xen accel_label, Xen accel_widget)
{
  #define H_gtk_accel_label_set_accel_widget "void gtk_accel_label_set_accel_widget(GtkAccelLabel* accel_label, \
GtkWidget* accel_widget)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_set_accel_widget", "GtkAccelLabel*");
  Xen_check_type(Xen_is_GtkWidget_(accel_widget), accel_widget, 2, "gtk_accel_label_set_accel_widget", "GtkWidget*");
  gtk_accel_label_set_accel_widget(Xen_to_C_GtkAccelLabel_(accel_label), Xen_to_C_GtkWidget_(accel_widget));
  return(Xen_false);
}

static Xen gxg_gtk_accel_label_set_accel_closure(Xen accel_label, Xen closure)
{
  #define H_gtk_accel_label_set_accel_closure "void gtk_accel_label_set_accel_closure(GtkAccelLabel* accel_label, \
GClosure* closure)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_set_accel_closure", "GtkAccelLabel*");
  Xen_check_type(Xen_is_GClosure_(closure) || Xen_is_false(closure), closure, 2, "gtk_accel_label_set_accel_closure", "GClosure*");
  gtk_accel_label_set_accel_closure(Xen_to_C_GtkAccelLabel_(accel_label), Xen_to_C_GClosure_(closure));
  return(Xen_false);
}

static Xen gxg_gtk_accel_label_refetch(Xen accel_label)
{
  #define H_gtk_accel_label_refetch "gboolean gtk_accel_label_refetch(GtkAccelLabel* accel_label)"
  Xen_check_type(Xen_is_GtkAccelLabel_(accel_label), accel_label, 1, "gtk_accel_label_refetch", "GtkAccelLabel*");
  return(C_to_Xen_gboolean(gtk_accel_label_refetch(Xen_to_C_GtkAccelLabel_(accel_label))));
}

static Xen gxg_gtk_accel_map_add_entry(Xen accel_path, Xen accel_key, Xen accel_mods)
{
  #define H_gtk_accel_map_add_entry "void gtk_accel_map_add_entry(gchar* accel_path, guint accel_key, \
GdkModifierType accel_mods)"
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 1, "gtk_accel_map_add_entry", "gchar*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 2, "gtk_accel_map_add_entry", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 3, "gtk_accel_map_add_entry", "GdkModifierType");
  gtk_accel_map_add_entry(Xen_to_C_gchar_(accel_path), Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods));
  return(Xen_false);
}

static Xen gxg_gtk_accel_map_lookup_entry(Xen accel_path, Xen key)
{
  #define H_gtk_accel_map_lookup_entry "gboolean gtk_accel_map_lookup_entry(gchar* accel_path, GtkAccelKey* key)"
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 1, "gtk_accel_map_lookup_entry", "gchar*");
  Xen_check_type(Xen_is_GtkAccelKey_(key), key, 2, "gtk_accel_map_lookup_entry", "GtkAccelKey*");
  return(C_to_Xen_gboolean(gtk_accel_map_lookup_entry(Xen_to_C_gchar_(accel_path), Xen_to_C_GtkAccelKey_(key))));
}

static Xen gxg_gtk_accel_map_change_entry(Xen accel_path, Xen accel_key, Xen accel_mods, Xen replace)
{
  #define H_gtk_accel_map_change_entry "gboolean gtk_accel_map_change_entry(gchar* accel_path, guint accel_key, \
GdkModifierType accel_mods, gboolean replace)"
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 1, "gtk_accel_map_change_entry", "gchar*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 2, "gtk_accel_map_change_entry", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 3, "gtk_accel_map_change_entry", "GdkModifierType");
  Xen_check_type(Xen_is_gboolean(replace), replace, 4, "gtk_accel_map_change_entry", "gboolean");
  return(C_to_Xen_gboolean(gtk_accel_map_change_entry(Xen_to_C_gchar_(accel_path), Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods), 
                                                      Xen_to_C_gboolean(replace))));
}

static Xen gxg_gtk_accel_map_load(Xen file_name)
{
  #define H_gtk_accel_map_load "void gtk_accel_map_load(gchar* file_name)"
  Xen_check_type(Xen_is_gchar_(file_name), file_name, 1, "gtk_accel_map_load", "gchar*");
  gtk_accel_map_load(Xen_to_C_gchar_(file_name));
  return(Xen_false);
}

static Xen gxg_gtk_accel_map_save(Xen file_name)
{
  #define H_gtk_accel_map_save "void gtk_accel_map_save(gchar* file_name)"
  Xen_check_type(Xen_is_gchar_(file_name), file_name, 1, "gtk_accel_map_save", "gchar*");
  gtk_accel_map_save(Xen_to_C_gchar_(file_name));
  return(Xen_false);
}

static Xen gxg_gtk_accel_map_foreach(Xen func_info, Xen func)
{
  #define H_gtk_accel_map_foreach "void gtk_accel_map_foreach(lambda_data func_info, GtkAccelMapForeach func)"
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 1, "gtk_accel_map_foreach", "lambda_data");
  Xen_check_type(Xen_is_GtkAccelMapForeach(func), func, 2, "gtk_accel_map_foreach", "GtkAccelMapForeach");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_accel_map_foreach(Xen_to_C_lambda_data(func_info), Xen_to_C_GtkAccelMapForeach(func));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_accel_map_load_fd(Xen fd)
{
  #define H_gtk_accel_map_load_fd "void gtk_accel_map_load_fd(gint fd)"
  Xen_check_type(Xen_is_gint(fd), fd, 1, "gtk_accel_map_load_fd", "gint");
  gtk_accel_map_load_fd(Xen_to_C_gint(fd));
  return(Xen_false);
}

static Xen gxg_gtk_accel_map_save_fd(Xen fd)
{
  #define H_gtk_accel_map_save_fd "void gtk_accel_map_save_fd(gint fd)"
  Xen_check_type(Xen_is_gint(fd), fd, 1, "gtk_accel_map_save_fd", "gint");
  gtk_accel_map_save_fd(Xen_to_C_gint(fd));
  return(Xen_false);
}

static Xen gxg_gtk_accel_map_add_filter(Xen filter_pattern)
{
  #define H_gtk_accel_map_add_filter "void gtk_accel_map_add_filter(gchar* filter_pattern)"
  Xen_check_type(Xen_is_gchar_(filter_pattern), filter_pattern, 1, "gtk_accel_map_add_filter", "gchar*");
  gtk_accel_map_add_filter(Xen_to_C_gchar_(filter_pattern));
  return(Xen_false);
}

static Xen gxg_gtk_accel_map_foreach_unfiltered(Xen func_info, Xen func)
{
  #define H_gtk_accel_map_foreach_unfiltered "void gtk_accel_map_foreach_unfiltered(lambda_data func_info, \
GtkAccelMapForeach func)"
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 1, "gtk_accel_map_foreach_unfiltered", "lambda_data");
  Xen_check_type(Xen_is_GtkAccelMapForeach(func), func, 2, "gtk_accel_map_foreach_unfiltered", "GtkAccelMapForeach");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_accel_map_foreach_unfiltered(Xen_to_C_lambda_data(func_info), Xen_to_C_GtkAccelMapForeach(func));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_adjustment_clamp_page(Xen adjustment, Xen lower, Xen upper)
{
  #define H_gtk_adjustment_clamp_page "void gtk_adjustment_clamp_page(GtkAdjustment* adjustment, gdouble lower, \
gdouble upper)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_clamp_page", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(lower), lower, 2, "gtk_adjustment_clamp_page", "gdouble");
  Xen_check_type(Xen_is_gdouble(upper), upper, 3, "gtk_adjustment_clamp_page", "gdouble");
  gtk_adjustment_clamp_page(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(lower), Xen_to_C_gdouble(upper));
  return(Xen_false);
}

static Xen gxg_gtk_adjustment_get_value(Xen adjustment)
{
  #define H_gtk_adjustment_get_value "gdouble gtk_adjustment_get_value(GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_get_value", "GtkAdjustment*");
  return(C_to_Xen_gdouble(gtk_adjustment_get_value(Xen_to_C_GtkAdjustment_(adjustment))));
}

static Xen gxg_gtk_adjustment_set_value(Xen adjustment, Xen value)
{
  #define H_gtk_adjustment_set_value "void gtk_adjustment_set_value(GtkAdjustment* adjustment, gdouble value)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment), adjustment, 1, "gtk_adjustment_set_value", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_adjustment_set_value", "gdouble");
  gtk_adjustment_set_value(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_aspect_frame_new(Xen label, Xen xalign, Xen yalign, Xen ratio, Xen obey_child)
{
  #define H_gtk_aspect_frame_new "GtkWidget* gtk_aspect_frame_new(gchar* label, gfloat xalign, gfloat yalign, \
gfloat ratio, gboolean obey_child)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_aspect_frame_new", "gchar*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_aspect_frame_new", "gfloat");
  Xen_check_type(Xen_is_gfloat(yalign), yalign, 3, "gtk_aspect_frame_new", "gfloat");
  Xen_check_type(Xen_is_gfloat(ratio), ratio, 4, "gtk_aspect_frame_new", "gfloat");
  Xen_check_type(Xen_is_gboolean(obey_child), obey_child, 5, "gtk_aspect_frame_new", "gboolean");
  return(C_to_Xen_GtkWidget_(gtk_aspect_frame_new(Xen_to_C_gchar_(label), Xen_to_C_gfloat(xalign), Xen_to_C_gfloat(yalign), 
                                                  Xen_to_C_gfloat(ratio), Xen_to_C_gboolean(obey_child))));
}

static Xen gxg_gtk_aspect_frame_set(Xen aspect_frame, Xen xalign, Xen yalign, Xen ratio, Xen obey_child)
{
  #define H_gtk_aspect_frame_set "void gtk_aspect_frame_set(GtkAspectFrame* aspect_frame, gfloat xalign, \
gfloat yalign, gfloat ratio, gboolean obey_child)"
  Xen_check_type(Xen_is_GtkAspectFrame_(aspect_frame), aspect_frame, 1, "gtk_aspect_frame_set", "GtkAspectFrame*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_aspect_frame_set", "gfloat");
  Xen_check_type(Xen_is_gfloat(yalign), yalign, 3, "gtk_aspect_frame_set", "gfloat");
  Xen_check_type(Xen_is_gfloat(ratio), ratio, 4, "gtk_aspect_frame_set", "gfloat");
  Xen_check_type(Xen_is_gboolean(obey_child), obey_child, 5, "gtk_aspect_frame_set", "gboolean");
  gtk_aspect_frame_set(Xen_to_C_GtkAspectFrame_(aspect_frame), Xen_to_C_gfloat(xalign), Xen_to_C_gfloat(yalign), Xen_to_C_gfloat(ratio), 
                       Xen_to_C_gboolean(obey_child));
  return(Xen_false);
}

static Xen gxg_gtk_button_box_get_layout(Xen widget)
{
  #define H_gtk_button_box_get_layout "GtkButtonBoxStyle gtk_button_box_get_layout(GtkButtonBox* widget)"
  Xen_check_type(Xen_is_GtkButtonBox_(widget), widget, 1, "gtk_button_box_get_layout", "GtkButtonBox*");
  return(C_to_Xen_GtkButtonBoxStyle(gtk_button_box_get_layout(Xen_to_C_GtkButtonBox_(widget))));
}

static Xen gxg_gtk_button_box_set_layout(Xen widget, Xen layout_style)
{
  #define H_gtk_button_box_set_layout "void gtk_button_box_set_layout(GtkButtonBox* widget, GtkButtonBoxStyle layout_style)"
  Xen_check_type(Xen_is_GtkButtonBox_(widget), widget, 1, "gtk_button_box_set_layout", "GtkButtonBox*");
  Xen_check_type(Xen_is_GtkButtonBoxStyle(layout_style), layout_style, 2, "gtk_button_box_set_layout", "GtkButtonBoxStyle");
  gtk_button_box_set_layout(Xen_to_C_GtkButtonBox_(widget), Xen_to_C_GtkButtonBoxStyle(layout_style));
  return(Xen_false);
}

static Xen gxg_gtk_button_box_set_child_secondary(Xen widget, Xen child, Xen is_secondary)
{
  #define H_gtk_button_box_set_child_secondary "void gtk_button_box_set_child_secondary(GtkButtonBox* widget, \
GtkWidget* child, gboolean is_secondary)"
  Xen_check_type(Xen_is_GtkButtonBox_(widget), widget, 1, "gtk_button_box_set_child_secondary", "GtkButtonBox*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_button_box_set_child_secondary", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(is_secondary), is_secondary, 3, "gtk_button_box_set_child_secondary", "gboolean");
  gtk_button_box_set_child_secondary(Xen_to_C_GtkButtonBox_(widget), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(is_secondary));
  return(Xen_false);
}

static Xen gxg_gtk_binding_set_new(Xen set_name)
{
  #define H_gtk_binding_set_new "GtkBindingSet* gtk_binding_set_new(gchar* set_name)"
  Xen_check_type(Xen_is_gchar_(set_name), set_name, 1, "gtk_binding_set_new", "gchar*");
  return(C_to_Xen_GtkBindingSet_(gtk_binding_set_new(Xen_to_C_gchar_(set_name))));
}

static Xen gxg_gtk_binding_set_by_class(Xen object_class)
{
  #define H_gtk_binding_set_by_class "GtkBindingSet* gtk_binding_set_by_class(gpointer object_class)"
  Xen_check_type(Xen_is_gpointer(object_class), object_class, 1, "gtk_binding_set_by_class", "gpointer");
  return(C_to_Xen_GtkBindingSet_(gtk_binding_set_by_class(Xen_to_C_gpointer(object_class))));
}

static Xen gxg_gtk_binding_set_find(Xen set_name)
{
  #define H_gtk_binding_set_find "GtkBindingSet* gtk_binding_set_find(gchar* set_name)"
  Xen_check_type(Xen_is_gchar_(set_name), set_name, 1, "gtk_binding_set_find", "gchar*");
  return(C_to_Xen_GtkBindingSet_(gtk_binding_set_find(Xen_to_C_gchar_(set_name))));
}

static Xen gxg_gtk_binding_entry_remove(Xen binding_set, Xen keyval, Xen modifiers)
{
  #define H_gtk_binding_entry_remove "void gtk_binding_entry_remove(GtkBindingSet* binding_set, guint keyval, \
GdkModifierType modifiers)"
  Xen_check_type(Xen_is_GtkBindingSet_(binding_set), binding_set, 1, "gtk_binding_entry_remove", "GtkBindingSet*");
  Xen_check_type(Xen_is_guint(keyval), keyval, 2, "gtk_binding_entry_remove", "guint");
  Xen_check_type(Xen_is_GdkModifierType(modifiers), modifiers, 3, "gtk_binding_entry_remove", "GdkModifierType");
  gtk_binding_entry_remove(Xen_to_C_GtkBindingSet_(binding_set), Xen_to_C_guint(keyval), Xen_to_C_GdkModifierType(modifiers));
  return(Xen_false);
}

static Xen gxg_gtk_bin_get_child(Xen bin)
{
  #define H_gtk_bin_get_child "GtkWidget* gtk_bin_get_child(GtkBin* bin)"
  Xen_check_type(Xen_is_GtkBin_(bin), bin, 1, "gtk_bin_get_child", "GtkBin*");
  return(C_to_Xen_GtkWidget_(gtk_bin_get_child(Xen_to_C_GtkBin_(bin))));
}

static Xen gxg_gtk_box_set_homogeneous(Xen box, Xen homogeneous)
{
  #define H_gtk_box_set_homogeneous "void gtk_box_set_homogeneous(GtkBox* box, gboolean homogeneous)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_set_homogeneous", "GtkBox*");
  Xen_check_type(Xen_is_gboolean(homogeneous), homogeneous, 2, "gtk_box_set_homogeneous", "gboolean");
  gtk_box_set_homogeneous(Xen_to_C_GtkBox_(box), Xen_to_C_gboolean(homogeneous));
  return(Xen_false);
}

static Xen gxg_gtk_box_get_homogeneous(Xen box)
{
  #define H_gtk_box_get_homogeneous "gboolean gtk_box_get_homogeneous(GtkBox* box)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_get_homogeneous", "GtkBox*");
  return(C_to_Xen_gboolean(gtk_box_get_homogeneous(Xen_to_C_GtkBox_(box))));
}

static Xen gxg_gtk_box_set_spacing(Xen box, Xen spacing)
{
  #define H_gtk_box_set_spacing "void gtk_box_set_spacing(GtkBox* box, gint spacing)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_set_spacing", "GtkBox*");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_box_set_spacing", "gint");
  gtk_box_set_spacing(Xen_to_C_GtkBox_(box), Xen_to_C_gint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_box_get_spacing(Xen box)
{
  #define H_gtk_box_get_spacing "gint gtk_box_get_spacing(GtkBox* box)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_get_spacing", "GtkBox*");
  return(C_to_Xen_gint(gtk_box_get_spacing(Xen_to_C_GtkBox_(box))));
}

static Xen gxg_gtk_box_reorder_child(Xen box, Xen child, Xen position)
{
  #define H_gtk_box_reorder_child "void gtk_box_reorder_child(GtkBox* box, GtkWidget* child, gint position)"
  Xen_check_type(Xen_is_GtkBox_(box), box, 1, "gtk_box_reorder_child", "GtkBox*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_box_reorder_child", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_box_reorder_child", "gint");
  gtk_box_reorder_child(Xen_to_C_GtkBox_(box), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_button_new(void)
{
  #define H_gtk_button_new "GtkWidget* gtk_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_button_new()));
}

static Xen gxg_gtk_button_new_with_label(Xen label)
{
  #define H_gtk_button_new_with_label "GtkWidget* gtk_button_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_button_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_button_new_with_mnemonic(Xen label)
{
  #define H_gtk_button_new_with_mnemonic "GtkWidget* gtk_button_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_button_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_button_clicked(Xen button)
{
  #define H_gtk_button_clicked "void gtk_button_clicked(GtkButton* button)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_clicked", "GtkButton*");
  gtk_button_clicked(Xen_to_C_GtkButton_(button));
  return(Xen_false);
}

static Xen gxg_gtk_button_set_relief(Xen button, Xen newstyle)
{
  #define H_gtk_button_set_relief "void gtk_button_set_relief(GtkButton* button, GtkReliefStyle newstyle)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_set_relief", "GtkButton*");
  Xen_check_type(Xen_is_GtkReliefStyle(newstyle), newstyle, 2, "gtk_button_set_relief", "GtkReliefStyle");
  gtk_button_set_relief(Xen_to_C_GtkButton_(button), Xen_to_C_GtkReliefStyle(newstyle));
  return(Xen_false);
}

static Xen gxg_gtk_button_get_relief(Xen button)
{
  #define H_gtk_button_get_relief "GtkReliefStyle gtk_button_get_relief(GtkButton* button)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_get_relief", "GtkButton*");
  return(C_to_Xen_GtkReliefStyle(gtk_button_get_relief(Xen_to_C_GtkButton_(button))));
}

static Xen gxg_gtk_button_set_label(Xen button, Xen label)
{
  #define H_gtk_button_set_label "void gtk_button_set_label(GtkButton* button, gchar* label)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_set_label", "GtkButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_button_set_label", "gchar*");
  gtk_button_set_label(Xen_to_C_GtkButton_(button), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_button_get_label(Xen button)
{
  #define H_gtk_button_get_label "gchar* gtk_button_get_label(GtkButton* button)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_get_label", "GtkButton*");
  return(C_to_Xen_gchar_(gtk_button_get_label(Xen_to_C_GtkButton_(button))));
}

static Xen gxg_gtk_button_set_use_underline(Xen button, Xen use_underline)
{
  #define H_gtk_button_set_use_underline "void gtk_button_set_use_underline(GtkButton* button, gboolean use_underline)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_set_use_underline", "GtkButton*");
  Xen_check_type(Xen_is_gboolean(use_underline), use_underline, 2, "gtk_button_set_use_underline", "gboolean");
  gtk_button_set_use_underline(Xen_to_C_GtkButton_(button), Xen_to_C_gboolean(use_underline));
  return(Xen_false);
}

static Xen gxg_gtk_button_get_use_underline(Xen button)
{
  #define H_gtk_button_get_use_underline "gboolean gtk_button_get_use_underline(GtkButton* button)"
  Xen_check_type(Xen_is_GtkButton_(button), button, 1, "gtk_button_get_use_underline", "GtkButton*");
  return(C_to_Xen_gboolean(gtk_button_get_use_underline(Xen_to_C_GtkButton_(button))));
}

static Xen gxg_gtk_calendar_new(void)
{
  #define H_gtk_calendar_new "GtkWidget* gtk_calendar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_calendar_new()));
}

static Xen gxg_gtk_calendar_select_day(Xen calendar, Xen day)
{
  #define H_gtk_calendar_select_day "void gtk_calendar_select_day(GtkCalendar* calendar, guint day)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_select_day", "GtkCalendar*");
  Xen_check_type(Xen_is_guint(day), day, 2, "gtk_calendar_select_day", "guint");
  gtk_calendar_select_day(Xen_to_C_GtkCalendar_(calendar), Xen_to_C_guint(day));
  return(Xen_false);
}

static Xen gxg_gtk_calendar_clear_marks(Xen calendar)
{
  #define H_gtk_calendar_clear_marks "void gtk_calendar_clear_marks(GtkCalendar* calendar)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_clear_marks", "GtkCalendar*");
  gtk_calendar_clear_marks(Xen_to_C_GtkCalendar_(calendar));
  return(Xen_false);
}

static Xen gxg_gtk_calendar_get_date(Xen calendar, Xen ignore_year, Xen ignore_month, Xen ignore_day)
{
  #define H_gtk_calendar_get_date "void gtk_calendar_get_date(GtkCalendar* calendar, guint* [year], guint* [month], \
guint* [day])"
  guint ref_year;
  guint ref_month;
  guint ref_day;
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_get_date", "GtkCalendar*");
  gtk_calendar_get_date(Xen_to_C_GtkCalendar_(calendar), &ref_year, &ref_month, &ref_day);
  return(Xen_list_3(C_to_Xen_guint(ref_year), C_to_Xen_guint(ref_month), C_to_Xen_guint(ref_day)));
}

static Xen gxg_gtk_cell_editable_start_editing(Xen cell_editable, Xen event)
{
  #define H_gtk_cell_editable_start_editing "void gtk_cell_editable_start_editing(GtkCellEditable* cell_editable, \
GdkEvent* event)"
  Xen_check_type(Xen_is_GtkCellEditable_(cell_editable), cell_editable, 1, "gtk_cell_editable_start_editing", "GtkCellEditable*");
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 2, "gtk_cell_editable_start_editing", "GdkEvent*");
  gtk_cell_editable_start_editing(Xen_to_C_GtkCellEditable_(cell_editable), Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gtk_cell_editable_editing_done(Xen cell_editable)
{
  #define H_gtk_cell_editable_editing_done "void gtk_cell_editable_editing_done(GtkCellEditable* cell_editable)"
  Xen_check_type(Xen_is_GtkCellEditable_(cell_editable), cell_editable, 1, "gtk_cell_editable_editing_done", "GtkCellEditable*");
  gtk_cell_editable_editing_done(Xen_to_C_GtkCellEditable_(cell_editable));
  return(Xen_false);
}

static Xen gxg_gtk_cell_editable_remove_widget(Xen cell_editable)
{
  #define H_gtk_cell_editable_remove_widget "void gtk_cell_editable_remove_widget(GtkCellEditable* cell_editable)"
  Xen_check_type(Xen_is_GtkCellEditable_(cell_editable), cell_editable, 1, "gtk_cell_editable_remove_widget", "GtkCellEditable*");
  gtk_cell_editable_remove_widget(Xen_to_C_GtkCellEditable_(cell_editable));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_activate(Xen cell, Xen event, Xen widget, Xen path, Xen background_area, Xen cell_area, Xen flags)
{
  #define H_gtk_cell_renderer_activate "gboolean gtk_cell_renderer_activate(GtkCellRenderer* cell, GdkEvent* event, \
GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, GtkCellRendererState flags)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_activate", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GdkEvent_(event), event, 2, "gtk_cell_renderer_activate", "GdkEvent*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 3, "gtk_cell_renderer_activate", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(path), path, 4, "gtk_cell_renderer_activate", "gchar*");
  Xen_check_type(Xen_is_GdkRectangle_(background_area), background_area, 5, "gtk_cell_renderer_activate", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(cell_area), cell_area, 6, "gtk_cell_renderer_activate", "GdkRectangle*");
  Xen_check_type(Xen_is_GtkCellRendererState(flags), flags, 7, "gtk_cell_renderer_activate", "GtkCellRendererState");
  return(C_to_Xen_gboolean(gtk_cell_renderer_activate(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GdkEvent_(event), Xen_to_C_GtkWidget_(widget), 
                                                      Xen_to_C_gchar_(path), Xen_to_C_GdkRectangle_(background_area), Xen_to_C_GdkRectangle_(cell_area), 
                                                      Xen_to_C_GtkCellRendererState(flags))));
}

static Xen gxg_gtk_cell_renderer_start_editing(Xen cell, Xen event, Xen widget, Xen path, Xen background_area, Xen cell_area, Xen flags)
{
  #define H_gtk_cell_renderer_start_editing "GtkCellEditable* gtk_cell_renderer_start_editing(GtkCellRenderer* cell, \
GdkEvent* event, GtkWidget* widget, gchar* path, GdkRectangle* background_area, GdkRectangle* cell_area, \
GtkCellRendererState flags)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_start_editing", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 2, "gtk_cell_renderer_start_editing", "GdkEvent*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 3, "gtk_cell_renderer_start_editing", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(path), path, 4, "gtk_cell_renderer_start_editing", "gchar*");
  Xen_check_type(Xen_is_GdkRectangle_(background_area), background_area, 5, "gtk_cell_renderer_start_editing", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(cell_area), cell_area, 6, "gtk_cell_renderer_start_editing", "GdkRectangle*");
  Xen_check_type(Xen_is_GtkCellRendererState(flags), flags, 7, "gtk_cell_renderer_start_editing", "GtkCellRendererState");
  return(C_to_Xen_GtkCellEditable_(gtk_cell_renderer_start_editing(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GdkEvent_(event), 
                                                                   Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(path), Xen_to_C_GdkRectangle_(background_area), 
                                                                   Xen_to_C_GdkRectangle_(cell_area), Xen_to_C_GtkCellRendererState(flags))));
}

static Xen gxg_gtk_cell_renderer_set_fixed_size(Xen cell, Xen width, Xen height)
{
  #define H_gtk_cell_renderer_set_fixed_size "void gtk_cell_renderer_set_fixed_size(GtkCellRenderer* cell, \
gint width, gint height)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_set_fixed_size", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_cell_renderer_set_fixed_size", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_cell_renderer_set_fixed_size", "gint");
  gtk_cell_renderer_set_fixed_size(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_get_fixed_size(Xen cell, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_cell_renderer_get_fixed_size "void gtk_cell_renderer_get_fixed_size(GtkCellRenderer* cell, \
gint* [width], gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_get_fixed_size", "GtkCellRenderer*");
  gtk_cell_renderer_get_fixed_size(Xen_to_C_GtkCellRenderer_(cell), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_cell_renderer_pixbuf_new(void)
{
  #define H_gtk_cell_renderer_pixbuf_new "GtkCellRenderer* gtk_cell_renderer_pixbuf_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_pixbuf_new()));
}

static Xen gxg_gtk_cell_renderer_text_new(void)
{
  #define H_gtk_cell_renderer_text_new "GtkCellRenderer* gtk_cell_renderer_text_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_text_new()));
}

static Xen gxg_gtk_cell_renderer_text_set_fixed_height_from_font(Xen renderer, Xen number_of_rows)
{
  #define H_gtk_cell_renderer_text_set_fixed_height_from_font "void gtk_cell_renderer_text_set_fixed_height_from_font(GtkCellRendererText* renderer, \
gint number_of_rows)"
  Xen_check_type(Xen_is_GtkCellRendererText_(renderer), renderer, 1, "gtk_cell_renderer_text_set_fixed_height_from_font", "GtkCellRendererText*");
  Xen_check_type(Xen_is_gint(number_of_rows), number_of_rows, 2, "gtk_cell_renderer_text_set_fixed_height_from_font", "gint");
  gtk_cell_renderer_text_set_fixed_height_from_font(Xen_to_C_GtkCellRendererText_(renderer), Xen_to_C_gint(number_of_rows));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_toggle_new(void)
{
  #define H_gtk_cell_renderer_toggle_new "GtkCellRenderer* gtk_cell_renderer_toggle_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_toggle_new()));
}

static Xen gxg_gtk_cell_renderer_toggle_get_radio(Xen toggle)
{
  #define H_gtk_cell_renderer_toggle_get_radio "gboolean gtk_cell_renderer_toggle_get_radio(GtkCellRendererToggle* toggle)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_get_radio", "GtkCellRendererToggle*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_toggle_get_radio(Xen_to_C_GtkCellRendererToggle_(toggle))));
}

static Xen gxg_gtk_cell_renderer_toggle_set_radio(Xen toggle, Xen radio)
{
  #define H_gtk_cell_renderer_toggle_set_radio "void gtk_cell_renderer_toggle_set_radio(GtkCellRendererToggle* toggle, \
gboolean radio)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_set_radio", "GtkCellRendererToggle*");
  Xen_check_type(Xen_is_gboolean(radio), radio, 2, "gtk_cell_renderer_toggle_set_radio", "gboolean");
  gtk_cell_renderer_toggle_set_radio(Xen_to_C_GtkCellRendererToggle_(toggle), Xen_to_C_gboolean(radio));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_toggle_get_active(Xen toggle)
{
  #define H_gtk_cell_renderer_toggle_get_active "gboolean gtk_cell_renderer_toggle_get_active(GtkCellRendererToggle* toggle)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_get_active", "GtkCellRendererToggle*");
  return(C_to_Xen_gboolean(gtk_cell_renderer_toggle_get_active(Xen_to_C_GtkCellRendererToggle_(toggle))));
}

static Xen gxg_gtk_cell_renderer_toggle_set_active(Xen toggle, Xen setting)
{
  #define H_gtk_cell_renderer_toggle_set_active "void gtk_cell_renderer_toggle_set_active(GtkCellRendererToggle* toggle, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkCellRendererToggle_(toggle), toggle, 1, "gtk_cell_renderer_toggle_set_active", "GtkCellRendererToggle*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_cell_renderer_toggle_set_active", "gboolean");
  gtk_cell_renderer_toggle_set_active(Xen_to_C_GtkCellRendererToggle_(toggle), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_check_button_new(void)
{
  #define H_gtk_check_button_new "GtkWidget* gtk_check_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_check_button_new()));
}

static Xen gxg_gtk_check_button_new_with_label(Xen label)
{
  #define H_gtk_check_button_new_with_label "GtkWidget* gtk_check_button_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_check_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_check_button_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_check_button_new_with_mnemonic(Xen label)
{
  #define H_gtk_check_button_new_with_mnemonic "GtkWidget* gtk_check_button_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_check_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_check_button_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_check_menu_item_new(void)
{
  #define H_gtk_check_menu_item_new "GtkWidget* gtk_check_menu_item_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_check_menu_item_new()));
}

static Xen gxg_gtk_check_menu_item_new_with_label(Xen label)
{
  #define H_gtk_check_menu_item_new_with_label "GtkWidget* gtk_check_menu_item_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_check_menu_item_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_check_menu_item_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_check_menu_item_new_with_mnemonic(Xen label)
{
  #define H_gtk_check_menu_item_new_with_mnemonic "GtkWidget* gtk_check_menu_item_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_check_menu_item_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_check_menu_item_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_check_menu_item_set_active(Xen check_menu_item, Xen is_active)
{
  #define H_gtk_check_menu_item_set_active "void gtk_check_menu_item_set_active(GtkCheckMenuItem* check_menu_item, \
gboolean is_active)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_set_active", "GtkCheckMenuItem*");
  Xen_check_type(Xen_is_gboolean(is_active), is_active, 2, "gtk_check_menu_item_set_active", "gboolean");
  gtk_check_menu_item_set_active(Xen_to_C_GtkCheckMenuItem_(check_menu_item), Xen_to_C_gboolean(is_active));
  return(Xen_false);
}

static Xen gxg_gtk_check_menu_item_get_active(Xen check_menu_item)
{
  #define H_gtk_check_menu_item_get_active "gboolean gtk_check_menu_item_get_active(GtkCheckMenuItem* check_menu_item)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_get_active", "GtkCheckMenuItem*");
  return(C_to_Xen_gboolean(gtk_check_menu_item_get_active(Xen_to_C_GtkCheckMenuItem_(check_menu_item))));
}

static Xen gxg_gtk_check_menu_item_toggled(Xen check_menu_item)
{
  #define H_gtk_check_menu_item_toggled "void gtk_check_menu_item_toggled(GtkCheckMenuItem* check_menu_item)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_toggled", "GtkCheckMenuItem*");
  gtk_check_menu_item_toggled(Xen_to_C_GtkCheckMenuItem_(check_menu_item));
  return(Xen_false);
}

static Xen gxg_gtk_check_menu_item_set_inconsistent(Xen check_menu_item, Xen setting)
{
  #define H_gtk_check_menu_item_set_inconsistent "void gtk_check_menu_item_set_inconsistent(GtkCheckMenuItem* check_menu_item, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_set_inconsistent", "GtkCheckMenuItem*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_check_menu_item_set_inconsistent", "gboolean");
  gtk_check_menu_item_set_inconsistent(Xen_to_C_GtkCheckMenuItem_(check_menu_item), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_check_menu_item_get_inconsistent(Xen check_menu_item)
{
  #define H_gtk_check_menu_item_get_inconsistent "gboolean gtk_check_menu_item_get_inconsistent(GtkCheckMenuItem* check_menu_item)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_get_inconsistent", "GtkCheckMenuItem*");
  return(C_to_Xen_gboolean(gtk_check_menu_item_get_inconsistent(Xen_to_C_GtkCheckMenuItem_(check_menu_item))));
}

static Xen gxg_gtk_container_add(Xen container, Xen widget)
{
  #define H_gtk_container_add "void gtk_container_add(GtkContainer* container, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkContainer_(container), container, 1, "gtk_container_add", "GtkContainer*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_container_add", "GtkWidget*");
  gtk_container_add(Xen_to_C_GtkContainer_(container), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_container_remove(Xen container, Xen widget)
{
  #define H_gtk_container_remove "void gtk_container_remove(GtkContainer* container, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkContainer_(container), container, 1, "gtk_container_remove", "GtkContainer*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_container_remove", "GtkWidget*");
  gtk_container_remove(Xen_to_C_GtkContainer_(container), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_container_check_resize(Xen container)
{
  #define H_gtk_container_check_resize "void gtk_container_check_resize(GtkContainer* container)"
  Xen_check_type(Xen_is_GtkContainer_(container), container, 1, "gtk_container_check_resize", "GtkContainer*");
  gtk_container_check_resize(Xen_to_C_GtkContainer_(container));
  return(Xen_false);
}

static Xen gxg_gtk_container_foreach(Xen container, Xen func, Xen func_info)
{
  #define H_gtk_container_foreach "void gtk_container_foreach(GtkContainer* container, GtkCallback func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GtkContainer_(container), container, 1, "gtk_container_foreach", "GtkContainer*");
  Xen_check_type(Xen_is_GtkCallback(func), func, 2, "gtk_container_foreach", "GtkCallback");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_container_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_container_foreach(Xen_to_C_GtkContainer_(container), Xen_to_C_GtkCallback(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_container_get_children(Xen container)
{
  #define H_gtk_container_get_children "GList* gtk_container_get_children(GtkContainer* container)"
  Xen_check_type(Xen_is_GtkContainer_(container), container, 1, "gtk_container_get_children", "GtkContainer*");
  return(C_to_Xen_GList_(gtk_container_get_children(Xen_to_C_GtkContainer_(container))));
}

static Xen gxg_gtk_dialog_new(void)
{
  #define H_gtk_dialog_new "GtkWidget* gtk_dialog_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_dialog_new()));
}

static Xen gxg_gtk_dialog_add_action_widget(Xen dialog, Xen child, Xen response_id)
{
  #define H_gtk_dialog_add_action_widget "void gtk_dialog_add_action_widget(GtkDialog* dialog, GtkWidget* child, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_add_action_widget", "GtkDialog*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_dialog_add_action_widget", "GtkWidget*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 3, "gtk_dialog_add_action_widget", "gint");
  gtk_dialog_add_action_widget(Xen_to_C_GtkDialog_(dialog), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_add_button(Xen dialog, Xen button_text, Xen response_id)
{
  #define H_gtk_dialog_add_button "GtkWidget* gtk_dialog_add_button(GtkDialog* dialog, gchar* button_text, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_add_button", "GtkDialog*");
  Xen_check_type(Xen_is_gchar_(button_text), button_text, 2, "gtk_dialog_add_button", "gchar*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 3, "gtk_dialog_add_button", "gint");
  return(C_to_Xen_GtkWidget_(gtk_dialog_add_button(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gchar_(button_text), Xen_to_C_gint(response_id))));
}

static Xen gxg_gtk_dialog_add_buttons(Xen dialog, Xen buttons)
{
  #define H_gtk_dialog_add_buttons "void gtk_dialog_add_buttons(GtkDialog* dialog, etc buttons)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_add_buttons", "GtkDialog*");
  Xen_check_type(Xen_is_etc(buttons), buttons, 2, "gtk_dialog_add_buttons", "etc");
  {
    int etc_len = 0;
    GtkDialog* p_arg0;
    if (Xen_is_list(buttons)) etc_len = Xen_list_length(buttons);
    if (etc_len < 2) Xen_out_of_range_error("gtk_dialog_add_buttons", 1, buttons, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_dialog_add_buttons", 1, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_dialog_add_buttons", 1, buttons, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkDialog_(dialog);
    switch (etc_len)
      {
        case 2: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), NULL); break;
        case 4: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), NULL); break;
        case 6: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), NULL); break;
        case 8: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), NULL); break;
        case 10: gtk_dialog_add_buttons(p_arg0, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), XLS(buttons, 8), XLI(buttons, 9), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_dialog_set_response_sensitive(Xen dialog, Xen response_id, Xen setting)
{
  #define H_gtk_dialog_set_response_sensitive "void gtk_dialog_set_response_sensitive(GtkDialog* dialog, \
gint response_id, gboolean setting)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_set_response_sensitive", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_set_response_sensitive", "gint");
  Xen_check_type(Xen_is_gboolean(setting), setting, 3, "gtk_dialog_set_response_sensitive", "gboolean");
  gtk_dialog_set_response_sensitive(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_set_default_response(Xen dialog, Xen response_id)
{
  #define H_gtk_dialog_set_default_response "void gtk_dialog_set_default_response(GtkDialog* dialog, \
gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_set_default_response", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_set_default_response", "gint");
  gtk_dialog_set_default_response(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_response(Xen dialog, Xen response_id)
{
  #define H_gtk_dialog_response "void gtk_dialog_response(GtkDialog* dialog, gint response_id)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_response", "GtkDialog*");
  Xen_check_type(Xen_is_gint(response_id), response_id, 2, "gtk_dialog_response", "gint");
  gtk_dialog_response(Xen_to_C_GtkDialog_(dialog), Xen_to_C_gint(response_id));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_run(Xen dialog)
{
  #define H_gtk_dialog_run "gint gtk_dialog_run(GtkDialog* dialog)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_run", "GtkDialog*");
  return(C_to_Xen_gint(gtk_dialog_run(Xen_to_C_GtkDialog_(dialog))));
}

static Xen gxg_gtk_drag_get_data(Xen widget, Xen context, Xen target, Xen time)
{
  #define H_gtk_drag_get_data "void gtk_drag_get_data(GtkWidget* widget, GdkDragContext* context, GdkAtom target, \
guint32 time)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_get_data", "GtkWidget*");
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 2, "gtk_drag_get_data", "GdkDragContext*");
  Xen_check_type(Xen_is_GdkAtom(target), target, 3, "gtk_drag_get_data", "GdkAtom");
  Xen_check_type(Xen_is_guint32(time), time, 4, "gtk_drag_get_data", "guint32");
  gtk_drag_get_data(Xen_to_C_GtkWidget_(widget), Xen_to_C_GdkDragContext_(context), Xen_to_C_GdkAtom(target), Xen_to_C_guint32(time));
  return(Xen_false);
}

static Xen gxg_gtk_drag_get_source_widget(Xen context)
{
  #define H_gtk_drag_get_source_widget "GtkWidget* gtk_drag_get_source_widget(GdkDragContext* context)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gtk_drag_get_source_widget", "GdkDragContext*");
  return(C_to_Xen_GtkWidget_(gtk_drag_get_source_widget(Xen_to_C_GdkDragContext_(context))));
}

static Xen gxg_gtk_drag_highlight(Xen widget)
{
  #define H_gtk_drag_highlight "void gtk_drag_highlight(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_highlight", "GtkWidget*");
  gtk_drag_highlight(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_unhighlight(Xen widget)
{
  #define H_gtk_drag_unhighlight "void gtk_drag_unhighlight(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_unhighlight", "GtkWidget*");
  gtk_drag_unhighlight(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_dest_unset(Xen widget)
{
  #define H_gtk_drag_dest_unset "void gtk_drag_dest_unset(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_dest_unset", "GtkWidget*");
  gtk_drag_dest_unset(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_source_unset(Xen widget)
{
  #define H_gtk_drag_source_unset "void gtk_drag_source_unset(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_source_unset", "GtkWidget*");
  gtk_drag_source_unset(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_set_icon_widget(Xen context, Xen widget, Xen hot_x, Xen hot_y)
{
  #define H_gtk_drag_set_icon_widget "void gtk_drag_set_icon_widget(GdkDragContext* context, GtkWidget* widget, \
gint hot_x, gint hot_y)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gtk_drag_set_icon_widget", "GdkDragContext*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_drag_set_icon_widget", "GtkWidget*");
  Xen_check_type(Xen_is_gint(hot_x), hot_x, 3, "gtk_drag_set_icon_widget", "gint");
  Xen_check_type(Xen_is_gint(hot_y), hot_y, 4, "gtk_drag_set_icon_widget", "gint");
  gtk_drag_set_icon_widget(Xen_to_C_GdkDragContext_(context), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(hot_x), Xen_to_C_gint(hot_y));
  return(Xen_false);
}

static Xen gxg_gtk_drag_set_icon_default(Xen context)
{
  #define H_gtk_drag_set_icon_default "void gtk_drag_set_icon_default(GdkDragContext* context)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gtk_drag_set_icon_default", "GdkDragContext*");
  gtk_drag_set_icon_default(Xen_to_C_GdkDragContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_drag_check_threshold(Xen widget, Xen start_x, Xen start_y, Xen current_x, Xen current_y)
{
  #define H_gtk_drag_check_threshold "gboolean gtk_drag_check_threshold(GtkWidget* widget, gint start_x, \
gint start_y, gint current_x, gint current_y)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_check_threshold", "GtkWidget*");
  Xen_check_type(Xen_is_gint(start_x), start_x, 2, "gtk_drag_check_threshold", "gint");
  Xen_check_type(Xen_is_gint(start_y), start_y, 3, "gtk_drag_check_threshold", "gint");
  Xen_check_type(Xen_is_gint(current_x), current_x, 4, "gtk_drag_check_threshold", "gint");
  Xen_check_type(Xen_is_gint(current_y), current_y, 5, "gtk_drag_check_threshold", "gint");
  return(C_to_Xen_gboolean(gtk_drag_check_threshold(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(start_x), Xen_to_C_gint(start_y), 
                                                    Xen_to_C_gint(current_x), Xen_to_C_gint(current_y))));
}

static Xen gxg_gtk_drawing_area_new(void)
{
  #define H_gtk_drawing_area_new "GtkWidget* gtk_drawing_area_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_drawing_area_new()));
}

static Xen gxg_gtk_editable_select_region(Xen editable, Xen start, Xen end)
{
  #define H_gtk_editable_select_region "void gtk_editable_select_region(GtkEditable* editable, gint start, \
gint end)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_select_region", "GtkEditable*");
  Xen_check_type(Xen_is_gint(start), start, 2, "gtk_editable_select_region", "gint");
  Xen_check_type(Xen_is_gint(end), end, 3, "gtk_editable_select_region", "gint");
  gtk_editable_select_region(Xen_to_C_GtkEditable_(editable), Xen_to_C_gint(start), Xen_to_C_gint(end));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_selection_bounds(Xen editable, Xen ignore_start, Xen ignore_end)
{
  #define H_gtk_editable_get_selection_bounds "gboolean gtk_editable_get_selection_bounds(GtkEditable* editable, \
gint* [start], gint* [end])"
  gint ref_start;
  gint ref_end;
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_selection_bounds", "GtkEditable*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_editable_get_selection_bounds(Xen_to_C_GtkEditable_(editable), &ref_start, &ref_end));
    return(Xen_list_3(result, C_to_Xen_gint(ref_start), C_to_Xen_gint(ref_end)));
   }
}

static Xen gxg_gtk_editable_insert_text(Xen editable, Xen new_text, Xen new_text_length, Xen ignore_position)
{
  #define H_gtk_editable_insert_text "void gtk_editable_insert_text(GtkEditable* editable, gchar* new_text, \
gint new_text_length, gint* [position])"
  gint ref_position;
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_insert_text", "GtkEditable*");
  Xen_check_type(Xen_is_gchar_(new_text), new_text, 2, "gtk_editable_insert_text", "gchar*");
  Xen_check_type(Xen_is_gint(new_text_length), new_text_length, 3, "gtk_editable_insert_text", "gint");
  gtk_editable_insert_text(Xen_to_C_GtkEditable_(editable), Xen_to_C_gchar_(new_text), Xen_to_C_gint(new_text_length), &ref_position);
  return(Xen_list_1(C_to_Xen_gint(ref_position)));
}

static Xen gxg_gtk_editable_delete_text(Xen editable, Xen start_pos, Xen end_pos)
{
  #define H_gtk_editable_delete_text "void gtk_editable_delete_text(GtkEditable* editable, gint start_pos, \
gint end_pos)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_delete_text", "GtkEditable*");
  Xen_check_type(Xen_is_gint(start_pos), start_pos, 2, "gtk_editable_delete_text", "gint");
  Xen_check_type(Xen_is_gint(end_pos), end_pos, 3, "gtk_editable_delete_text", "gint");
  gtk_editable_delete_text(Xen_to_C_GtkEditable_(editable), Xen_to_C_gint(start_pos), Xen_to_C_gint(end_pos));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_chars(Xen editable, Xen start_pos, Xen end_pos)
{
  #define H_gtk_editable_get_chars "gchar* gtk_editable_get_chars(GtkEditable* editable, gint start_pos, \
gint end_pos)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_chars", "GtkEditable*");
  Xen_check_type(Xen_is_gint(start_pos), start_pos, 2, "gtk_editable_get_chars", "gint");
  Xen_check_type(Xen_is_gint(end_pos), end_pos, 3, "gtk_editable_get_chars", "gint");
  {
   gchar* result;
   Xen rtn;
   result = gtk_editable_get_chars(Xen_to_C_GtkEditable_(editable), Xen_to_C_gint(start_pos), 
                                                                     Xen_to_C_gint(end_pos));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_editable_cut_clipboard(Xen editable)
{
  #define H_gtk_editable_cut_clipboard "void gtk_editable_cut_clipboard(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_cut_clipboard", "GtkEditable*");
  gtk_editable_cut_clipboard(Xen_to_C_GtkEditable_(editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_copy_clipboard(Xen editable)
{
  #define H_gtk_editable_copy_clipboard "void gtk_editable_copy_clipboard(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_copy_clipboard", "GtkEditable*");
  gtk_editable_copy_clipboard(Xen_to_C_GtkEditable_(editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_paste_clipboard(Xen editable)
{
  #define H_gtk_editable_paste_clipboard "void gtk_editable_paste_clipboard(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_paste_clipboard", "GtkEditable*");
  gtk_editable_paste_clipboard(Xen_to_C_GtkEditable_(editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_delete_selection(Xen editable)
{
  #define H_gtk_editable_delete_selection "void gtk_editable_delete_selection(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_delete_selection", "GtkEditable*");
  gtk_editable_delete_selection(Xen_to_C_GtkEditable_(editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_set_position(Xen editable, Xen position)
{
  #define H_gtk_editable_set_position "void gtk_editable_set_position(GtkEditable* editable, gint position)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_set_position", "GtkEditable*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_editable_set_position", "gint");
  gtk_editable_set_position(Xen_to_C_GtkEditable_(editable), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_position(Xen editable)
{
  #define H_gtk_editable_get_position "gint gtk_editable_get_position(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_position", "GtkEditable*");
  return(C_to_Xen_gint(gtk_editable_get_position(Xen_to_C_GtkEditable_(editable))));
}

static Xen gxg_gtk_editable_set_editable(Xen editable, Xen is_editable)
{
  #define H_gtk_editable_set_editable "void gtk_editable_set_editable(GtkEditable* editable, gboolean is_editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_set_editable", "GtkEditable*");
  Xen_check_type(Xen_is_gboolean(is_editable), is_editable, 2, "gtk_editable_set_editable", "gboolean");
  gtk_editable_set_editable(Xen_to_C_GtkEditable_(editable), Xen_to_C_gboolean(is_editable));
  return(Xen_false);
}

static Xen gxg_gtk_editable_get_editable(Xen editable)
{
  #define H_gtk_editable_get_editable "gboolean gtk_editable_get_editable(GtkEditable* editable)"
  Xen_check_type(Xen_is_GtkEditable_(editable), editable, 1, "gtk_editable_get_editable", "GtkEditable*");
  return(C_to_Xen_gboolean(gtk_editable_get_editable(Xen_to_C_GtkEditable_(editable))));
}

static Xen gxg_gtk_entry_new(void)
{
  #define H_gtk_entry_new "GtkWidget* gtk_entry_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_entry_new()));
}

static Xen gxg_gtk_entry_set_visibility(Xen entry, Xen visible)
{
  #define H_gtk_entry_set_visibility "void gtk_entry_set_visibility(GtkEntry* entry, gboolean visible)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_visibility", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(visible), visible, 2, "gtk_entry_set_visibility", "gboolean");
  gtk_entry_set_visibility(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(visible));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_visibility(Xen entry)
{
  #define H_gtk_entry_get_visibility "gboolean gtk_entry_get_visibility(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_visibility", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_visibility(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_invisible_char(Xen entry, Xen ch)
{
  #define H_gtk_entry_set_invisible_char "void gtk_entry_set_invisible_char(GtkEntry* entry, gunichar ch)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_invisible_char", "GtkEntry*");
  Xen_check_type(Xen_is_gunichar(ch), ch, 2, "gtk_entry_set_invisible_char", "gunichar");
  gtk_entry_set_invisible_char(Xen_to_C_GtkEntry_(entry), Xen_to_C_gunichar(ch));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_invisible_char(Xen entry)
{
  #define H_gtk_entry_get_invisible_char "gunichar gtk_entry_get_invisible_char(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_invisible_char", "GtkEntry*");
  return(C_to_Xen_gunichar(gtk_entry_get_invisible_char(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_has_frame(Xen entry, Xen setting)
{
  #define H_gtk_entry_set_has_frame "void gtk_entry_set_has_frame(GtkEntry* entry, gboolean setting)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_has_frame", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_entry_set_has_frame", "gboolean");
  gtk_entry_set_has_frame(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_has_frame(Xen entry)
{
  #define H_gtk_entry_get_has_frame "gboolean gtk_entry_get_has_frame(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_has_frame", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_has_frame(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_max_length(Xen entry, Xen max)
{
  #define H_gtk_entry_set_max_length "void gtk_entry_set_max_length(GtkEntry* entry, gint max)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_max_length", "GtkEntry*");
  Xen_check_type(Xen_is_gint(max), max, 2, "gtk_entry_set_max_length", "gint");
  gtk_entry_set_max_length(Xen_to_C_GtkEntry_(entry), Xen_to_C_gint(max));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_max_length(Xen entry)
{
  #define H_gtk_entry_get_max_length "gint gtk_entry_get_max_length(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_max_length", "GtkEntry*");
  return(C_to_Xen_gint(gtk_entry_get_max_length(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_activates_default(Xen entry, Xen setting)
{
  #define H_gtk_entry_set_activates_default "void gtk_entry_set_activates_default(GtkEntry* entry, gboolean setting)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_activates_default", "GtkEntry*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_entry_set_activates_default", "gboolean");
  gtk_entry_set_activates_default(Xen_to_C_GtkEntry_(entry), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_activates_default(Xen entry)
{
  #define H_gtk_entry_get_activates_default "gboolean gtk_entry_get_activates_default(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_activates_default", "GtkEntry*");
  return(C_to_Xen_gboolean(gtk_entry_get_activates_default(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_width_chars(Xen entry, Xen n_chars)
{
  #define H_gtk_entry_set_width_chars "void gtk_entry_set_width_chars(GtkEntry* entry, gint n_chars)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_width_chars", "GtkEntry*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_entry_set_width_chars", "gint");
  gtk_entry_set_width_chars(Xen_to_C_GtkEntry_(entry), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_width_chars(Xen entry)
{
  #define H_gtk_entry_get_width_chars "gint gtk_entry_get_width_chars(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_width_chars", "GtkEntry*");
  return(C_to_Xen_gint(gtk_entry_get_width_chars(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_set_text(Xen entry, Xen text)
{
  #define H_gtk_entry_set_text "void gtk_entry_set_text(GtkEntry* entry, gchar* text)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_text", "GtkEntry*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_entry_set_text", "gchar*");
  gtk_entry_set_text(Xen_to_C_GtkEntry_(entry), Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_text(Xen entry)
{
  #define H_gtk_entry_get_text "gchar* gtk_entry_get_text(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_text", "GtkEntry*");
  return(C_to_Xen_gchar_(gtk_entry_get_text(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_get_layout(Xen entry)
{
  #define H_gtk_entry_get_layout "PangoLayout* gtk_entry_get_layout(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_layout", "GtkEntry*");
  return(C_to_Xen_PangoLayout_(gtk_entry_get_layout(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_entry_get_layout_offsets(Xen entry, Xen ignore_x, Xen ignore_y)
{
  #define H_gtk_entry_get_layout_offsets "void gtk_entry_get_layout_offsets(GtkEntry* entry, gint* [x], \
gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_layout_offsets", "GtkEntry*");
  gtk_entry_get_layout_offsets(Xen_to_C_GtkEntry_(entry), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gtk_fixed_new(void)
{
  #define H_gtk_fixed_new "GtkWidget* gtk_fixed_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_fixed_new()));
}

static Xen gxg_gtk_fixed_put(Xen fixed, Xen widget, Xen x, Xen y)
{
  #define H_gtk_fixed_put "void gtk_fixed_put(GtkFixed* fixed, GtkWidget* widget, gint x, gint y)"
  Xen_check_type(Xen_is_GtkFixed_(fixed), fixed, 1, "gtk_fixed_put", "GtkFixed*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_fixed_put", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 3, "gtk_fixed_put", "gint");
  Xen_check_type(Xen_is_gint(y), y, 4, "gtk_fixed_put", "gint");
  gtk_fixed_put(Xen_to_C_GtkFixed_(fixed), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_fixed_move(Xen fixed, Xen widget, Xen x, Xen y)
{
  #define H_gtk_fixed_move "void gtk_fixed_move(GtkFixed* fixed, GtkWidget* widget, gint x, gint y)"
  Xen_check_type(Xen_is_GtkFixed_(fixed), fixed, 1, "gtk_fixed_move", "GtkFixed*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_fixed_move", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 3, "gtk_fixed_move", "gint");
  Xen_check_type(Xen_is_gint(y), y, 4, "gtk_fixed_move", "gint");
  gtk_fixed_move(Xen_to_C_GtkFixed_(fixed), Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_frame_new(Xen label)
{
  #define H_gtk_frame_new "GtkWidget* gtk_frame_new(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_frame_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_frame_new(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_frame_set_label(Xen frame, Xen label)
{
  #define H_gtk_frame_set_label "void gtk_frame_set_label(GtkFrame* frame, gchar* label)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_set_label", "GtkFrame*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_frame_set_label", "gchar*");
  gtk_frame_set_label(Xen_to_C_GtkFrame_(frame), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_frame_get_label(Xen frame)
{
  #define H_gtk_frame_get_label "gchar* gtk_frame_get_label(GtkFrame* frame)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_get_label", "GtkFrame*");
  return(C_to_Xen_gchar_(gtk_frame_get_label(Xen_to_C_GtkFrame_(frame))));
}

static Xen gxg_gtk_frame_set_label_widget(Xen frame, Xen label_widget)
{
  #define H_gtk_frame_set_label_widget "void gtk_frame_set_label_widget(GtkFrame* frame, GtkWidget* label_widget)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_set_label_widget", "GtkFrame*");
  Xen_check_type(Xen_is_GtkWidget_(label_widget), label_widget, 2, "gtk_frame_set_label_widget", "GtkWidget*");
  gtk_frame_set_label_widget(Xen_to_C_GtkFrame_(frame), Xen_to_C_GtkWidget_(label_widget));
  return(Xen_false);
}

static Xen gxg_gtk_frame_get_label_widget(Xen frame)
{
  #define H_gtk_frame_get_label_widget "GtkWidget* gtk_frame_get_label_widget(GtkFrame* frame)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_get_label_widget", "GtkFrame*");
  return(C_to_Xen_GtkWidget_(gtk_frame_get_label_widget(Xen_to_C_GtkFrame_(frame))));
}

static Xen gxg_gtk_frame_set_label_align(Xen frame, Xen xalign, Xen yalign)
{
  #define H_gtk_frame_set_label_align "void gtk_frame_set_label_align(GtkFrame* frame, gfloat xalign, \
gfloat yalign)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_set_label_align", "GtkFrame*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_frame_set_label_align", "gfloat");
  Xen_check_type(Xen_is_gfloat(yalign), yalign, 3, "gtk_frame_set_label_align", "gfloat");
  gtk_frame_set_label_align(Xen_to_C_GtkFrame_(frame), Xen_to_C_gfloat(xalign), Xen_to_C_gfloat(yalign));
  return(Xen_false);
}

static Xen gxg_gtk_frame_get_label_align(Xen frame, Xen ignore_xalign, Xen ignore_yalign)
{
  #define H_gtk_frame_get_label_align "void gtk_frame_get_label_align(GtkFrame* frame, gfloat* [xalign], \
gfloat* [yalign])"
  gfloat ref_xalign;
  gfloat ref_yalign;
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_get_label_align", "GtkFrame*");
  gtk_frame_get_label_align(Xen_to_C_GtkFrame_(frame), &ref_xalign, &ref_yalign);
  return(Xen_list_2(C_to_Xen_gfloat(ref_xalign), C_to_Xen_gfloat(ref_yalign)));
}

static Xen gxg_gtk_frame_set_shadow_type(Xen frame, Xen type)
{
  #define H_gtk_frame_set_shadow_type "void gtk_frame_set_shadow_type(GtkFrame* frame, GtkShadowType type)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_set_shadow_type", "GtkFrame*");
  Xen_check_type(Xen_is_GtkShadowType(type), type, 2, "gtk_frame_set_shadow_type", "GtkShadowType");
  gtk_frame_set_shadow_type(Xen_to_C_GtkFrame_(frame), Xen_to_C_GtkShadowType(type));
  return(Xen_false);
}

static Xen gxg_gtk_frame_get_shadow_type(Xen frame)
{
  #define H_gtk_frame_get_shadow_type "GtkShadowType gtk_frame_get_shadow_type(GtkFrame* frame)"
  Xen_check_type(Xen_is_GtkFrame_(frame), frame, 1, "gtk_frame_get_shadow_type", "GtkFrame*");
  return(C_to_Xen_GtkShadowType(gtk_frame_get_shadow_type(Xen_to_C_GtkFrame_(frame))));
}

static Xen gxg_gtk_image_new(void)
{
  #define H_gtk_image_new "GtkWidget* gtk_image_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_image_new()));
}

static Xen gxg_gtk_image_new_from_file(Xen filename)
{
  #define H_gtk_image_new_from_file "GtkWidget* gtk_image_new_from_file(gchar* filename)"
  Xen_check_type(Xen_is_gchar_(filename), filename, 1, "gtk_image_new_from_file", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_image_new_from_file(Xen_to_C_gchar_(filename))));
}

static Xen gxg_gtk_image_new_from_pixbuf(Xen pixbuf)
{
  #define H_gtk_image_new_from_pixbuf "GtkWidget* gtk_image_new_from_pixbuf(GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf) || Xen_is_false(pixbuf), pixbuf, 1, "gtk_image_new_from_pixbuf", "GdkPixbuf*");
  return(C_to_Xen_GtkWidget_(gtk_image_new_from_pixbuf(Xen_to_C_GdkPixbuf_(pixbuf))));
}

static Xen gxg_gtk_image_set_from_file(Xen image, Xen filename)
{
  #define H_gtk_image_set_from_file "void gtk_image_set_from_file(GtkImage* image, gchar* filename)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_set_from_file", "GtkImage*");
  Xen_check_type(Xen_is_gchar_(filename), filename, 2, "gtk_image_set_from_file", "gchar*");
  gtk_image_set_from_file(Xen_to_C_GtkImage_(image), Xen_to_C_gchar_(filename));
  return(Xen_false);
}

static Xen gxg_gtk_image_set_from_pixbuf(Xen image, Xen pixbuf)
{
  #define H_gtk_image_set_from_pixbuf "void gtk_image_set_from_pixbuf(GtkImage* image, GdkPixbuf* pixbuf)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_set_from_pixbuf", "GtkImage*");
  Xen_check_type(Xen_is_GdkPixbuf_(pixbuf) || Xen_is_false(pixbuf), pixbuf, 2, "gtk_image_set_from_pixbuf", "GdkPixbuf*");
  gtk_image_set_from_pixbuf(Xen_to_C_GtkImage_(image), Xen_to_C_GdkPixbuf_(pixbuf));
  return(Xen_false);
}

static Xen gxg_gtk_image_get_storage_type(Xen image)
{
  #define H_gtk_image_get_storage_type "GtkImageType gtk_image_get_storage_type(GtkImage* image)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_get_storage_type", "GtkImage*");
  return(C_to_Xen_GtkImageType(gtk_image_get_storage_type(Xen_to_C_GtkImage_(image))));
}

static Xen gxg_gtk_im_context_get_preedit_string(Xen context, Xen ignore_str, Xen ignore_attrs, Xen ignore_cursor_pos)
{
  #define H_gtk_im_context_get_preedit_string "void gtk_im_context_get_preedit_string(GtkIMContext* context, \
gchar** [str], PangoAttrList** [attrs], gint* [cursor_pos])"
  gchar* ref_str = NULL;
  PangoAttrList* ref_attrs = NULL;
  gint ref_cursor_pos;
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_get_preedit_string", "GtkIMContext*");
  gtk_im_context_get_preedit_string(Xen_to_C_GtkIMContext_(context), &ref_str, &ref_attrs, &ref_cursor_pos);
  return(Xen_list_3(C_to_Xen_gchar_(ref_str), C_to_Xen_PangoAttrList_(ref_attrs), C_to_Xen_gint(ref_cursor_pos)));
}

static Xen gxg_gtk_im_context_filter_keypress(Xen context, Xen event)
{
  #define H_gtk_im_context_filter_keypress "gboolean gtk_im_context_filter_keypress(GtkIMContext* context, \
GdkEventKey* event)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_filter_keypress", "GtkIMContext*");
  Xen_check_type(Xen_is_GdkEventKey_(event), event, 2, "gtk_im_context_filter_keypress", "GdkEventKey*");
  return(C_to_Xen_gboolean(gtk_im_context_filter_keypress(Xen_to_C_GtkIMContext_(context), Xen_to_C_GdkEventKey_(event))));
}

static Xen gxg_gtk_im_context_focus_in(Xen context)
{
  #define H_gtk_im_context_focus_in "void gtk_im_context_focus_in(GtkIMContext* context)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_focus_in", "GtkIMContext*");
  gtk_im_context_focus_in(Xen_to_C_GtkIMContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_focus_out(Xen context)
{
  #define H_gtk_im_context_focus_out "void gtk_im_context_focus_out(GtkIMContext* context)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_focus_out", "GtkIMContext*");
  gtk_im_context_focus_out(Xen_to_C_GtkIMContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_reset(Xen context)
{
  #define H_gtk_im_context_reset "void gtk_im_context_reset(GtkIMContext* context)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_reset", "GtkIMContext*");
  gtk_im_context_reset(Xen_to_C_GtkIMContext_(context));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_set_cursor_location(Xen context, Xen area)
{
  #define H_gtk_im_context_set_cursor_location "void gtk_im_context_set_cursor_location(GtkIMContext* context, \
GdkRectangle* area)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_set_cursor_location", "GtkIMContext*");
  Xen_check_type(Xen_is_GdkRectangle_(area), area, 2, "gtk_im_context_set_cursor_location", "GdkRectangle*");
  gtk_im_context_set_cursor_location(Xen_to_C_GtkIMContext_(context), Xen_to_C_GdkRectangle_(area));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_set_use_preedit(Xen context, Xen use_preedit)
{
  #define H_gtk_im_context_set_use_preedit "void gtk_im_context_set_use_preedit(GtkIMContext* context, \
gboolean use_preedit)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_set_use_preedit", "GtkIMContext*");
  Xen_check_type(Xen_is_gboolean(use_preedit), use_preedit, 2, "gtk_im_context_set_use_preedit", "gboolean");
  gtk_im_context_set_use_preedit(Xen_to_C_GtkIMContext_(context), Xen_to_C_gboolean(use_preedit));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_set_surrounding(Xen context, Xen text, Xen len, Xen cursor_index)
{
  #define H_gtk_im_context_set_surrounding "void gtk_im_context_set_surrounding(GtkIMContext* context, \
gchar* text, gint len, gint cursor_index)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_set_surrounding", "GtkIMContext*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_im_context_set_surrounding", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_im_context_set_surrounding", "gint");
  Xen_check_type(Xen_is_gint(cursor_index), cursor_index, 4, "gtk_im_context_set_surrounding", "gint");
  gtk_im_context_set_surrounding(Xen_to_C_GtkIMContext_(context), Xen_to_C_gchar_(text), Xen_to_C_gint(len), Xen_to_C_gint(cursor_index));
  return(Xen_false);
}

static Xen gxg_gtk_im_context_get_surrounding(Xen context, Xen ignore_text, Xen ignore_cursor_index)
{
  #define H_gtk_im_context_get_surrounding "gboolean gtk_im_context_get_surrounding(GtkIMContext* context, \
gchar** [text], gint* [cursor_index])"
  gchar* ref_text = NULL;
  gint ref_cursor_index;
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_get_surrounding", "GtkIMContext*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_im_context_get_surrounding(Xen_to_C_GtkIMContext_(context), &ref_text, &ref_cursor_index));
    return(Xen_list_3(result, C_to_Xen_gchar_(ref_text), C_to_Xen_gint(ref_cursor_index)));
   }
}

static Xen gxg_gtk_im_context_delete_surrounding(Xen context, Xen offset, Xen n_chars)
{
  #define H_gtk_im_context_delete_surrounding "gboolean gtk_im_context_delete_surrounding(GtkIMContext* context, \
gint offset, gint n_chars)"
  Xen_check_type(Xen_is_GtkIMContext_(context), context, 1, "gtk_im_context_delete_surrounding", "GtkIMContext*");
  Xen_check_type(Xen_is_gint(offset), offset, 2, "gtk_im_context_delete_surrounding", "gint");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 3, "gtk_im_context_delete_surrounding", "gint");
  return(C_to_Xen_gboolean(gtk_im_context_delete_surrounding(Xen_to_C_GtkIMContext_(context), Xen_to_C_gint(offset), Xen_to_C_gint(n_chars))));
}

static Xen gxg_gtk_im_context_simple_new(void)
{
  #define H_gtk_im_context_simple_new "GtkIMContext* gtk_im_context_simple_new( void)"
  return(C_to_Xen_GtkIMContext_(gtk_im_context_simple_new()));
}

static Xen gxg_gtk_im_context_simple_add_table(Xen context_simple, Xen data, Xen max_seq_len, Xen n_seqs)
{
  #define H_gtk_im_context_simple_add_table "void gtk_im_context_simple_add_table(GtkIMContextSimple* context_simple, \
guint16* data, gint max_seq_len, gint n_seqs)"
  Xen_check_type(Xen_is_GtkIMContextSimple_(context_simple), context_simple, 1, "gtk_im_context_simple_add_table", "GtkIMContextSimple*");
  Xen_check_type(Xen_is_guint16_(data), data, 2, "gtk_im_context_simple_add_table", "guint16*");
  Xen_check_type(Xen_is_gint(max_seq_len), max_seq_len, 3, "gtk_im_context_simple_add_table", "gint");
  Xen_check_type(Xen_is_gint(n_seqs), n_seqs, 4, "gtk_im_context_simple_add_table", "gint");
  gtk_im_context_simple_add_table(Xen_to_C_GtkIMContextSimple_(context_simple), Xen_to_C_guint16_(data), Xen_to_C_gint(max_seq_len), 
                                  Xen_to_C_gint(n_seqs));
  return(Xen_false);
}

static Xen gxg_gtk_invisible_new(void)
{
  #define H_gtk_invisible_new "GtkWidget* gtk_invisible_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_invisible_new()));
}

static Xen gxg_gtk_label_new(Xen str)
{
  #define H_gtk_label_new "GtkWidget* gtk_label_new(char* str)"
  Xen_check_type(Xen_is_char_(str), str, 1, "gtk_label_new", "char*");
  return(C_to_Xen_GtkWidget_(gtk_label_new(Xen_to_C_char_(str))));
}

static Xen gxg_gtk_label_new_with_mnemonic(Xen str)
{
  #define H_gtk_label_new_with_mnemonic "GtkWidget* gtk_label_new_with_mnemonic(char* str)"
  Xen_check_type(Xen_is_char_(str), str, 1, "gtk_label_new_with_mnemonic", "char*");
  return(C_to_Xen_GtkWidget_(gtk_label_new_with_mnemonic(Xen_to_C_char_(str))));
}

static Xen gxg_gtk_label_set_text(Xen label, Xen str)
{
  #define H_gtk_label_set_text "void gtk_label_set_text(GtkLabel* label, char* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_text", "GtkLabel*");
  Xen_check_type(Xen_is_char_(str), str, 2, "gtk_label_set_text", "char*");
  gtk_label_set_text(Xen_to_C_GtkLabel_(label), Xen_to_C_char_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_text(Xen label)
{
  #define H_gtk_label_get_text "gchar* gtk_label_get_text(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_text", "GtkLabel*");
  return(C_to_Xen_gchar_(gtk_label_get_text(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_attributes(Xen label, Xen attrs)
{
  #define H_gtk_label_set_attributes "void gtk_label_set_attributes(GtkLabel* label, PangoAttrList* attrs)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_attributes", "GtkLabel*");
  Xen_check_type(Xen_is_PangoAttrList_(attrs), attrs, 2, "gtk_label_set_attributes", "PangoAttrList*");
  gtk_label_set_attributes(Xen_to_C_GtkLabel_(label), Xen_to_C_PangoAttrList_(attrs));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_attributes(Xen label)
{
  #define H_gtk_label_get_attributes "PangoAttrList* gtk_label_get_attributes(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_attributes", "GtkLabel*");
  return(C_to_Xen_PangoAttrList_(gtk_label_get_attributes(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_label(Xen label, Xen str)
{
  #define H_gtk_label_set_label "void gtk_label_set_label(GtkLabel* label, gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_label", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_label", "gchar*");
  gtk_label_set_label(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_label(Xen label)
{
  #define H_gtk_label_get_label "gchar* gtk_label_get_label(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_label", "GtkLabel*");
  return(C_to_Xen_gchar_(gtk_label_get_label(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_markup(Xen label, Xen str)
{
  #define H_gtk_label_set_markup "void gtk_label_set_markup(GtkLabel* label, gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_markup", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_markup", "gchar*");
  gtk_label_set_markup(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_use_markup(Xen label, Xen setting)
{
  #define H_gtk_label_set_use_markup "void gtk_label_set_use_markup(GtkLabel* label, gboolean setting)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_use_markup", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_label_set_use_markup", "gboolean");
  gtk_label_set_use_markup(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_use_markup(Xen label)
{
  #define H_gtk_label_get_use_markup "gboolean gtk_label_get_use_markup(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_use_markup", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_use_markup(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_use_underline(Xen label, Xen setting)
{
  #define H_gtk_label_set_use_underline "void gtk_label_set_use_underline(GtkLabel* label, gboolean setting)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_use_underline", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_label_set_use_underline", "gboolean");
  gtk_label_set_use_underline(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_use_underline(Xen label)
{
  #define H_gtk_label_get_use_underline "gboolean gtk_label_get_use_underline(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_use_underline", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_use_underline(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_markup_with_mnemonic(Xen label, Xen str)
{
  #define H_gtk_label_set_markup_with_mnemonic "void gtk_label_set_markup_with_mnemonic(GtkLabel* label, \
gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_markup_with_mnemonic", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_markup_with_mnemonic", "gchar*");
  gtk_label_set_markup_with_mnemonic(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_mnemonic_keyval(Xen label)
{
  #define H_gtk_label_get_mnemonic_keyval "guint gtk_label_get_mnemonic_keyval(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_mnemonic_keyval", "GtkLabel*");
  return(C_to_Xen_guint(gtk_label_get_mnemonic_keyval(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_mnemonic_widget(Xen label, Xen widget)
{
  #define H_gtk_label_set_mnemonic_widget "void gtk_label_set_mnemonic_widget(GtkLabel* label, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_mnemonic_widget", "GtkLabel*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_label_set_mnemonic_widget", "GtkWidget*");
  gtk_label_set_mnemonic_widget(Xen_to_C_GtkLabel_(label), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_mnemonic_widget(Xen label)
{
  #define H_gtk_label_get_mnemonic_widget "GtkWidget* gtk_label_get_mnemonic_widget(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_mnemonic_widget", "GtkLabel*");
  return(C_to_Xen_GtkWidget_(gtk_label_get_mnemonic_widget(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_text_with_mnemonic(Xen label, Xen str)
{
  #define H_gtk_label_set_text_with_mnemonic "void gtk_label_set_text_with_mnemonic(GtkLabel* label, \
gchar* str)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_text_with_mnemonic", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_label_set_text_with_mnemonic", "gchar*");
  gtk_label_set_text_with_mnemonic(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(str));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_justify(Xen label, Xen jtype)
{
  #define H_gtk_label_set_justify "void gtk_label_set_justify(GtkLabel* label, GtkJustification jtype)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_justify", "GtkLabel*");
  Xen_check_type(Xen_is_GtkJustification(jtype), jtype, 2, "gtk_label_set_justify", "GtkJustification");
  gtk_label_set_justify(Xen_to_C_GtkLabel_(label), Xen_to_C_GtkJustification(jtype));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_justify(Xen label)
{
  #define H_gtk_label_get_justify "GtkJustification gtk_label_get_justify(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_justify", "GtkLabel*");
  return(C_to_Xen_GtkJustification(gtk_label_get_justify(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_pattern(Xen label, Xen pattern)
{
  #define H_gtk_label_set_pattern "void gtk_label_set_pattern(GtkLabel* label, gchar* pattern)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_pattern", "GtkLabel*");
  Xen_check_type(Xen_is_gchar_(pattern), pattern, 2, "gtk_label_set_pattern", "gchar*");
  gtk_label_set_pattern(Xen_to_C_GtkLabel_(label), Xen_to_C_gchar_(pattern));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_line_wrap(Xen label, Xen wrap)
{
  #define H_gtk_label_set_line_wrap "void gtk_label_set_line_wrap(GtkLabel* label, gboolean wrap)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_line_wrap", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(wrap), wrap, 2, "gtk_label_set_line_wrap", "gboolean");
  gtk_label_set_line_wrap(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(wrap));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_line_wrap(Xen label)
{
  #define H_gtk_label_get_line_wrap "gboolean gtk_label_get_line_wrap(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_line_wrap", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_line_wrap(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_set_selectable(Xen label, Xen setting)
{
  #define H_gtk_label_set_selectable "void gtk_label_set_selectable(GtkLabel* label, gboolean setting)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_selectable", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_label_set_selectable", "gboolean");
  gtk_label_set_selectable(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_selectable(Xen label)
{
  #define H_gtk_label_get_selectable "gboolean gtk_label_get_selectable(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_selectable", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_selectable(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_select_region(Xen label, Xen start_offset, Xen end_offset)
{
  #define H_gtk_label_select_region "void gtk_label_select_region(GtkLabel* label, gint start_offset, \
gint end_offset)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_select_region", "GtkLabel*");
  Xen_check_type(Xen_is_gint(start_offset), start_offset, 2, "gtk_label_select_region", "gint");
  Xen_check_type(Xen_is_gint(end_offset), end_offset, 3, "gtk_label_select_region", "gint");
  gtk_label_select_region(Xen_to_C_GtkLabel_(label), Xen_to_C_gint(start_offset), Xen_to_C_gint(end_offset));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_selection_bounds(Xen label, Xen ignore_start, Xen ignore_end)
{
  #define H_gtk_label_get_selection_bounds "gboolean gtk_label_get_selection_bounds(GtkLabel* label, \
gint* [start], gint* [end])"
  gint ref_start;
  gint ref_end;
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_selection_bounds", "GtkLabel*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_label_get_selection_bounds(Xen_to_C_GtkLabel_(label), &ref_start, &ref_end));
    return(Xen_list_3(result, C_to_Xen_gint(ref_start), C_to_Xen_gint(ref_end)));
   }
}

static Xen gxg_gtk_label_get_layout(Xen label)
{
  #define H_gtk_label_get_layout "PangoLayout* gtk_label_get_layout(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_layout", "GtkLabel*");
  return(C_to_Xen_PangoLayout_(gtk_label_get_layout(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_label_get_layout_offsets(Xen label, Xen ignore_x, Xen ignore_y)
{
  #define H_gtk_label_get_layout_offsets "void gtk_label_get_layout_offsets(GtkLabel* label, gint* [x], \
gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_layout_offsets", "GtkLabel*");
  gtk_label_get_layout_offsets(Xen_to_C_GtkLabel_(label), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gtk_layout_new(Xen hadjustment, Xen vadjustment)
{
  #define H_gtk_layout_new "GtkWidget* gtk_layout_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 1, "gtk_layout_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_GtkAdjustment_(vadjustment) || Xen_is_false(vadjustment), vadjustment, 2, "gtk_layout_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_layout_new(Xen_to_C_GtkAdjustment_(hadjustment), Xen_to_C_GtkAdjustment_(vadjustment))));
}

static Xen gxg_gtk_layout_put(Xen layout, Xen child_widget, Xen x, Xen y)
{
  #define H_gtk_layout_put "void gtk_layout_put(GtkLayout* layout, GtkWidget* child_widget, gint x, gint y)"
  Xen_check_type(Xen_is_GtkLayout_(layout), layout, 1, "gtk_layout_put", "GtkLayout*");
  Xen_check_type(Xen_is_GtkWidget_(child_widget), child_widget, 2, "gtk_layout_put", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 3, "gtk_layout_put", "gint");
  Xen_check_type(Xen_is_gint(y), y, 4, "gtk_layout_put", "gint");
  gtk_layout_put(Xen_to_C_GtkLayout_(layout), Xen_to_C_GtkWidget_(child_widget), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_layout_move(Xen layout, Xen child_widget, Xen x, Xen y)
{
  #define H_gtk_layout_move "void gtk_layout_move(GtkLayout* layout, GtkWidget* child_widget, gint x, \
gint y)"
  Xen_check_type(Xen_is_GtkLayout_(layout), layout, 1, "gtk_layout_move", "GtkLayout*");
  Xen_check_type(Xen_is_GtkWidget_(child_widget), child_widget, 2, "gtk_layout_move", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 3, "gtk_layout_move", "gint");
  Xen_check_type(Xen_is_gint(y), y, 4, "gtk_layout_move", "gint");
  gtk_layout_move(Xen_to_C_GtkLayout_(layout), Xen_to_C_GtkWidget_(child_widget), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_layout_set_size(Xen layout, Xen width, Xen height)
{
  #define H_gtk_layout_set_size "void gtk_layout_set_size(GtkLayout* layout, guint width, guint height)"
  Xen_check_type(Xen_is_GtkLayout_(layout), layout, 1, "gtk_layout_set_size", "GtkLayout*");
  Xen_check_type(Xen_is_guint(width), width, 2, "gtk_layout_set_size", "guint");
  Xen_check_type(Xen_is_guint(height), height, 3, "gtk_layout_set_size", "guint");
  gtk_layout_set_size(Xen_to_C_GtkLayout_(layout), Xen_to_C_guint(width), Xen_to_C_guint(height));
  return(Xen_false);
}

static Xen gxg_gtk_layout_get_size(Xen layout, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_layout_get_size "void gtk_layout_get_size(GtkLayout* layout, guint* [width], guint* [height])"
  guint ref_width;
  guint ref_height;
  Xen_check_type(Xen_is_GtkLayout_(layout), layout, 1, "gtk_layout_get_size", "GtkLayout*");
  gtk_layout_get_size(Xen_to_C_GtkLayout_(layout), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_guint(ref_width), C_to_Xen_guint(ref_height)));
}

static Xen gxg_gtk_list_store_new(Xen n_columns, Xen types)
{
  #define H_gtk_list_store_new "GtkListStore* gtk_list_store_new(gint n_columns, etc types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_list_store_new", "gint");
  Xen_check_type(Xen_is_etc(types), types, 2, "gtk_list_store_new", "etc");
  {
    int etc_len = 0;
    GtkListStore* result = NULL;
    gint p_arg0;
    if (Xen_is_list(types)) etc_len = Xen_list_length(types);
    if (etc_len < 1) Xen_out_of_range_error("gtk_list_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_list_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = Xen_to_C_gint(n_columns);
    switch (etc_len)
      {
        case 1: result = gtk_list_store_new(p_arg0, XLG(types, 0)); break;
        case 2: result = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1)); break;
        case 3: result = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2)); break;
        case 4: result = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3)); break;
        case 5: result = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4)); break;
        case 6: result = gtk_list_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4), XLG(types, 5)); break;
      }
    return(C_to_Xen_GtkListStore_(result));
  }
}

static Xen gxg_gtk_list_store_newv(Xen n_columns, Xen types)
{
  #define H_gtk_list_store_newv "GtkListStore* gtk_list_store_newv(gint n_columns, GType* types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_list_store_newv", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 2, "gtk_list_store_newv", "GType*");
  return(C_to_Xen_GtkListStore_(gtk_list_store_newv(Xen_to_C_gint(n_columns), Xen_to_C_GType_(types))));
}

static Xen gxg_gtk_list_store_set_column_types(Xen list_store, Xen n_columns, Xen types)
{
  #define H_gtk_list_store_set_column_types "void gtk_list_store_set_column_types(GtkListStore* list_store, \
gint n_columns, GType* types)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_set_column_types", "GtkListStore*");
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 2, "gtk_list_store_set_column_types", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 3, "gtk_list_store_set_column_types", "GType*");
  gtk_list_store_set_column_types(Xen_to_C_GtkListStore_(list_store), Xen_to_C_gint(n_columns), Xen_to_C_GType_(types));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_set(Xen list_store, Xen iter, Xen values)
{
  #define H_gtk_list_store_set "void gtk_list_store_set(GtkListStore* list_store, GtkTreeIter* iter, \
etc values)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_set", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_set", "GtkTreeIter*");
  Xen_check_type(Xen_is_etc(values), values, 3, "gtk_list_store_set", "etc");
  {
    int etc_len = 0;
    GtkListStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (Xen_is_list(values)) etc_len = Xen_list_length(values);
    if (etc_len < 2) Xen_out_of_range_error("gtk_list_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_list_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_list_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkListStore_(list_store);
    p_arg1 = Xen_to_C_GtkTreeIter_(iter);
    switch (etc_len)
      {
        case 2: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), -1); break;
        case 4: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), -1); break;
        case 6: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), -1); break;
        case 8: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), -1); break;
        case 10: gtk_list_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), XLI(values, 8), XLS(values, 9), -1); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_list_store_insert(Xen list_store, Xen iter, Xen position)
{
  #define H_gtk_list_store_insert "void gtk_list_store_insert(GtkListStore* list_store, GtkTreeIter* iter, \
gint position)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_list_store_insert", "gint");
  gtk_list_store_insert(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_insert_before(Xen list_store, Xen iter, Xen sibling)
{
  #define H_gtk_list_store_insert_before "void gtk_list_store_insert_before(GtkListStore* list_store, \
GtkTreeIter* iter, GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_before", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 3, "gtk_list_store_insert_before", "GtkTreeIter*");
  gtk_list_store_insert_before(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_insert_after(Xen list_store, Xen iter, Xen sibling)
{
  #define H_gtk_list_store_insert_after "void gtk_list_store_insert_after(GtkListStore* list_store, GtkTreeIter* iter, \
GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_after", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 3, "gtk_list_store_insert_after", "GtkTreeIter*");
  gtk_list_store_insert_after(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_prepend(Xen list_store, Xen iter)
{
  #define H_gtk_list_store_prepend "void gtk_list_store_prepend(GtkListStore* list_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_prepend", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_prepend", "GtkTreeIter*");
  gtk_list_store_prepend(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_append(Xen list_store, Xen iter)
{
  #define H_gtk_list_store_append "void gtk_list_store_append(GtkListStore* list_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_append", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_append", "GtkTreeIter*");
  gtk_list_store_append(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_clear(Xen list_store)
{
  #define H_gtk_list_store_clear "void gtk_list_store_clear(GtkListStore* list_store)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_clear", "GtkListStore*");
  gtk_list_store_clear(Xen_to_C_GtkListStore_(list_store));
  return(Xen_false);
}

static Xen gxg_gtk_check_version(Xen required_major, Xen required_minor, Xen required_micro)
{
  #define H_gtk_check_version "gchar* gtk_check_version(guint required_major, guint required_minor, guint required_micro)"
  Xen_check_type(Xen_is_guint(required_major), required_major, 1, "gtk_check_version", "guint");
  Xen_check_type(Xen_is_guint(required_minor), required_minor, 2, "gtk_check_version", "guint");
  Xen_check_type(Xen_is_guint(required_micro), required_micro, 3, "gtk_check_version", "guint");
    return(C_to_Xen_gchar_((gchar*)gtk_check_version(Xen_to_C_guint(required_major), Xen_to_C_guint(required_minor), Xen_to_C_guint(required_micro))));
}

static Xen gxg_gtk_disable_setlocale(void)
{
  #define H_gtk_disable_setlocale "void gtk_disable_setlocale( void)"
  gtk_disable_setlocale();
  return(Xen_false);
}

static Xen gxg_gtk_get_default_language(void)
{
  #define H_gtk_get_default_language "PangoLanguage* gtk_get_default_language( void)"
  return(C_to_Xen_PangoLanguage_(gtk_get_default_language()));
}

static Xen gxg_gtk_events_pending(void)
{
  #define H_gtk_events_pending "gint gtk_events_pending( void)"
  return(C_to_Xen_gint(gtk_events_pending()));
}

static Xen gxg_gtk_main_do_event(Xen event)
{
  #define H_gtk_main_do_event "void gtk_main_do_event(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event), event, 1, "gtk_main_do_event", "GdkEvent*");
  gtk_main_do_event(Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gtk_main(void)
{
  #define H_gtk_main "void gtk_main( void)"
  gtk_main();
  return(Xen_false);
}

static Xen gxg_gtk_main_level(void)
{
  #define H_gtk_main_level "guint gtk_main_level( void)"
  return(C_to_Xen_guint(gtk_main_level()));
}

static Xen gxg_gtk_main_quit(void)
{
  #define H_gtk_main_quit "void gtk_main_quit( void)"
  gtk_main_quit();
  return(Xen_false);
}

static Xen gxg_gtk_main_iteration(void)
{
  #define H_gtk_main_iteration "gboolean gtk_main_iteration( void)"
  return(C_to_Xen_gboolean(gtk_main_iteration()));
}

static Xen gxg_gtk_main_iteration_do(Xen blocking)
{
  #define H_gtk_main_iteration_do "gboolean gtk_main_iteration_do(gboolean blocking)"
  Xen_check_type(Xen_is_gboolean(blocking), blocking, 1, "gtk_main_iteration_do", "gboolean");
  return(C_to_Xen_gboolean(gtk_main_iteration_do(Xen_to_C_gboolean(blocking))));
}

static Xen gxg_gtk_true(void)
{
  #define H_gtk_true "gboolean gtk_true( void)"
  return(C_to_Xen_gboolean(gtk_true()));
}

static Xen gxg_gtk_false(void)
{
  #define H_gtk_false "gboolean gtk_false( void)"
  return(C_to_Xen_gboolean(gtk_false()));
}

static Xen gxg_gtk_grab_add(Xen widget)
{
  #define H_gtk_grab_add "void gtk_grab_add(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_grab_add", "GtkWidget*");
  gtk_grab_add(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_grab_get_current(void)
{
  #define H_gtk_grab_get_current "GtkWidget* gtk_grab_get_current( void)"
  return(C_to_Xen_GtkWidget_(gtk_grab_get_current()));
}

static Xen gxg_gtk_grab_remove(Xen widget)
{
  #define H_gtk_grab_remove "void gtk_grab_remove(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_grab_remove", "GtkWidget*");
  gtk_grab_remove(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_get_current_event(void)
{
  #define H_gtk_get_current_event "GdkEvent* gtk_get_current_event( void)"
  return(C_to_Xen_GdkEvent_(gtk_get_current_event()));
}

static Xen gxg_gtk_get_current_event_time(void)
{
  #define H_gtk_get_current_event_time "guint32 gtk_get_current_event_time( void)"
  return(C_to_Xen_guint32(gtk_get_current_event_time()));
}

static Xen gxg_gtk_get_current_event_state(Xen ignore_state)
{
  #define H_gtk_get_current_event_state "gboolean gtk_get_current_event_state(GdkModifierType* [state])"
  GdkModifierType ref_state;
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_get_current_event_state(&ref_state));
    return(Xen_list_2(result, C_to_Xen_GdkModifierType(ref_state)));
   }
}

static Xen gxg_gtk_get_event_widget(Xen event)
{
  #define H_gtk_get_event_widget "GtkWidget* gtk_get_event_widget(GdkEvent* event)"
  Xen_check_type(Xen_is_GdkEvent_(event) || Xen_is_false(event), event, 1, "gtk_get_event_widget", "GdkEvent*");
  return(C_to_Xen_GtkWidget_(gtk_get_event_widget(Xen_to_C_GdkEvent_(event))));
}

static Xen gxg_gtk_propagate_event(Xen widget, Xen event)
{
  #define H_gtk_propagate_event "void gtk_propagate_event(GtkWidget* widget, GdkEvent* event)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_propagate_event", "GtkWidget*");
  Xen_check_type(Xen_is_GdkEvent_(event), event, 2, "gtk_propagate_event", "GdkEvent*");
  gtk_propagate_event(Xen_to_C_GtkWidget_(widget), Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gtk_menu_bar_new(void)
{
  #define H_gtk_menu_bar_new "GtkWidget* gtk_menu_bar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_menu_bar_new()));
}

static Xen gxg_gtk_menu_new(void)
{
  #define H_gtk_menu_new "GtkWidget* gtk_menu_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_menu_new()));
}

static Xen gxg_gtk_menu_reposition(Xen menu)
{
  #define H_gtk_menu_reposition "void gtk_menu_reposition(GtkMenu* menu)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_reposition", "GtkMenu*");
  gtk_menu_reposition(Xen_to_C_GtkMenu_(menu));
  return(Xen_false);
}

static Xen gxg_gtk_menu_popdown(Xen menu)
{
  #define H_gtk_menu_popdown "void gtk_menu_popdown(GtkMenu* menu)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_popdown", "GtkMenu*");
  gtk_menu_popdown(Xen_to_C_GtkMenu_(menu));
  return(Xen_false);
}

static Xen gxg_gtk_menu_get_active(Xen menu)
{
  #define H_gtk_menu_get_active "GtkWidget* gtk_menu_get_active(GtkMenu* menu)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_get_active", "GtkMenu*");
  return(C_to_Xen_GtkWidget_(gtk_menu_get_active(Xen_to_C_GtkMenu_(menu))));
}

static Xen gxg_gtk_menu_set_active(Xen menu, Xen index)
{
  #define H_gtk_menu_set_active "void gtk_menu_set_active(GtkMenu* menu, guint index)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_set_active", "GtkMenu*");
  Xen_check_type(Xen_is_guint(index), index, 2, "gtk_menu_set_active", "guint");
  gtk_menu_set_active(Xen_to_C_GtkMenu_(menu), Xen_to_C_guint(index));
  return(Xen_false);
}

static Xen gxg_gtk_menu_set_accel_group(Xen menu, Xen accel_group)
{
  #define H_gtk_menu_set_accel_group "void gtk_menu_set_accel_group(GtkMenu* menu, GtkAccelGroup* accel_group)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_set_accel_group", "GtkMenu*");
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group) || Xen_is_false(accel_group), accel_group, 2, "gtk_menu_set_accel_group", "GtkAccelGroup*");
  gtk_menu_set_accel_group(Xen_to_C_GtkMenu_(menu), Xen_to_C_GtkAccelGroup_(accel_group));
  return(Xen_false);
}

static Xen gxg_gtk_menu_get_accel_group(Xen menu)
{
  #define H_gtk_menu_get_accel_group "GtkAccelGroup* gtk_menu_get_accel_group(GtkMenu* menu)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_get_accel_group", "GtkMenu*");
  return(C_to_Xen_GtkAccelGroup_(gtk_menu_get_accel_group(Xen_to_C_GtkMenu_(menu))));
}

static Xen gxg_gtk_menu_set_accel_path(Xen menu, Xen accel_path)
{
  #define H_gtk_menu_set_accel_path "void gtk_menu_set_accel_path(GtkMenu* menu, gchar* accel_path)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_set_accel_path", "GtkMenu*");
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 2, "gtk_menu_set_accel_path", "gchar*");
  gtk_menu_set_accel_path(Xen_to_C_GtkMenu_(menu), Xen_to_C_gchar_(accel_path));
  return(Xen_false);
}

static Xen gxg_gtk_menu_detach(Xen menu)
{
  #define H_gtk_menu_detach "void gtk_menu_detach(GtkMenu* menu)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_detach", "GtkMenu*");
  gtk_menu_detach(Xen_to_C_GtkMenu_(menu));
  return(Xen_false);
}

static Xen gxg_gtk_menu_get_attach_widget(Xen menu)
{
  #define H_gtk_menu_get_attach_widget "GtkWidget* gtk_menu_get_attach_widget(GtkMenu* menu)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_get_attach_widget", "GtkMenu*");
  return(C_to_Xen_GtkWidget_(gtk_menu_get_attach_widget(Xen_to_C_GtkMenu_(menu))));
}

static Xen gxg_gtk_menu_reorder_child(Xen menu, Xen child, Xen position)
{
  #define H_gtk_menu_reorder_child "void gtk_menu_reorder_child(GtkMenu* menu, GtkWidget* child, gint position)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_reorder_child", "GtkMenu*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_menu_reorder_child", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_menu_reorder_child", "gint");
  gtk_menu_reorder_child(Xen_to_C_GtkMenu_(menu), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_menu_set_monitor(Xen menu, Xen monitor_num)
{
  #define H_gtk_menu_set_monitor "void gtk_menu_set_monitor(GtkMenu* menu, gint monitor_num)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_set_monitor", "GtkMenu*");
  Xen_check_type(Xen_is_gint(monitor_num), monitor_num, 2, "gtk_menu_set_monitor", "gint");
  gtk_menu_set_monitor(Xen_to_C_GtkMenu_(menu), Xen_to_C_gint(monitor_num));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_new(void)
{
  #define H_gtk_menu_item_new "GtkWidget* gtk_menu_item_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_menu_item_new()));
}

static Xen gxg_gtk_menu_item_new_with_label(Xen label)
{
  #define H_gtk_menu_item_new_with_label "GtkWidget* gtk_menu_item_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_menu_item_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_menu_item_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_menu_item_new_with_mnemonic(Xen label)
{
  #define H_gtk_menu_item_new_with_mnemonic "GtkWidget* gtk_menu_item_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_menu_item_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_menu_item_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_menu_item_set_submenu(Xen menu_item, Xen submenu)
{
  #define H_gtk_menu_item_set_submenu "void gtk_menu_item_set_submenu(GtkMenuItem* menu_item, GtkWidget* submenu)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_set_submenu", "GtkMenuItem*");
  Xen_check_type(Xen_is_GtkWidget_(submenu), submenu, 2, "gtk_menu_item_set_submenu", "GtkWidget*");
  gtk_menu_item_set_submenu(Xen_to_C_GtkMenuItem_(menu_item), Xen_to_C_GtkWidget_(submenu));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_get_submenu(Xen menu_item)
{
  #define H_gtk_menu_item_get_submenu "GtkWidget* gtk_menu_item_get_submenu(GtkMenuItem* menu_item)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_get_submenu", "GtkMenuItem*");
  return(C_to_Xen_GtkWidget_(gtk_menu_item_get_submenu(Xen_to_C_GtkMenuItem_(menu_item))));
}

static Xen gxg_gtk_menu_item_select(Xen menu_item)
{
  #define H_gtk_menu_item_select "void gtk_menu_item_select(GtkMenuItem* menu_item)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_select", "GtkMenuItem*");
  gtk_menu_item_select(Xen_to_C_GtkMenuItem_(menu_item));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_deselect(Xen menu_item)
{
  #define H_gtk_menu_item_deselect "void gtk_menu_item_deselect(GtkMenuItem* menu_item)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_deselect", "GtkMenuItem*");
  gtk_menu_item_deselect(Xen_to_C_GtkMenuItem_(menu_item));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_activate(Xen menu_item)
{
  #define H_gtk_menu_item_activate "void gtk_menu_item_activate(GtkMenuItem* menu_item)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_activate", "GtkMenuItem*");
  gtk_menu_item_activate(Xen_to_C_GtkMenuItem_(menu_item));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_toggle_size_request(Xen menu_item, Xen requisition)
{
  #define H_gtk_menu_item_toggle_size_request "void gtk_menu_item_toggle_size_request(GtkMenuItem* menu_item, \
gint* requisition)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_toggle_size_request", "GtkMenuItem*");
  Xen_check_type(Xen_is_gint_(requisition), requisition, 2, "gtk_menu_item_toggle_size_request", "gint*");
  gtk_menu_item_toggle_size_request(Xen_to_C_GtkMenuItem_(menu_item), Xen_to_C_gint_(requisition));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_toggle_size_allocate(Xen menu_item, Xen allocation)
{
  #define H_gtk_menu_item_toggle_size_allocate "void gtk_menu_item_toggle_size_allocate(GtkMenuItem* menu_item, \
gint allocation)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_toggle_size_allocate", "GtkMenuItem*");
  Xen_check_type(Xen_is_gint(allocation), allocation, 2, "gtk_menu_item_toggle_size_allocate", "gint");
  gtk_menu_item_toggle_size_allocate(Xen_to_C_GtkMenuItem_(menu_item), Xen_to_C_gint(allocation));
  return(Xen_false);
}

static Xen gxg_gtk_menu_item_set_accel_path(Xen menu_item, Xen accel_path)
{
  #define H_gtk_menu_item_set_accel_path "void gtk_menu_item_set_accel_path(GtkMenuItem* menu_item, gchar* accel_path)"
  Xen_check_type(Xen_is_GtkMenuItem_(menu_item), menu_item, 1, "gtk_menu_item_set_accel_path", "GtkMenuItem*");
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 2, "gtk_menu_item_set_accel_path", "gchar*");
  gtk_menu_item_set_accel_path(Xen_to_C_GtkMenuItem_(menu_item), Xen_to_C_gchar_(accel_path));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_append(Xen menu_shell, Xen child)
{
  #define H_gtk_menu_shell_append "void gtk_menu_shell_append(GtkMenuShell* menu_shell, GtkWidget* child)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_append", "GtkMenuShell*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_menu_shell_append", "GtkWidget*");
  gtk_menu_shell_append(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_GtkWidget_(child));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_prepend(Xen menu_shell, Xen child)
{
  #define H_gtk_menu_shell_prepend "void gtk_menu_shell_prepend(GtkMenuShell* menu_shell, GtkWidget* child)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_prepend", "GtkMenuShell*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_menu_shell_prepend", "GtkWidget*");
  gtk_menu_shell_prepend(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_GtkWidget_(child));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_insert(Xen menu_shell, Xen child, Xen position)
{
  #define H_gtk_menu_shell_insert "void gtk_menu_shell_insert(GtkMenuShell* menu_shell, GtkWidget* child, \
gint position)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_insert", "GtkMenuShell*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_menu_shell_insert", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_menu_shell_insert", "gint");
  gtk_menu_shell_insert(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_deactivate(Xen menu_shell)
{
  #define H_gtk_menu_shell_deactivate "void gtk_menu_shell_deactivate(GtkMenuShell* menu_shell)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_deactivate", "GtkMenuShell*");
  gtk_menu_shell_deactivate(Xen_to_C_GtkMenuShell_(menu_shell));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_select_item(Xen menu_shell, Xen menu_item)
{
  #define H_gtk_menu_shell_select_item "void gtk_menu_shell_select_item(GtkMenuShell* menu_shell, GtkWidget* menu_item)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_select_item", "GtkMenuShell*");
  Xen_check_type(Xen_is_GtkWidget_(menu_item), menu_item, 2, "gtk_menu_shell_select_item", "GtkWidget*");
  gtk_menu_shell_select_item(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_GtkWidget_(menu_item));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_deselect(Xen menu_shell)
{
  #define H_gtk_menu_shell_deselect "void gtk_menu_shell_deselect(GtkMenuShell* menu_shell)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_deselect", "GtkMenuShell*");
  gtk_menu_shell_deselect(Xen_to_C_GtkMenuShell_(menu_shell));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_activate_item(Xen menu_shell, Xen menu_item, Xen force_deactivate)
{
  #define H_gtk_menu_shell_activate_item "void gtk_menu_shell_activate_item(GtkMenuShell* menu_shell, \
GtkWidget* menu_item, gboolean force_deactivate)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_activate_item", "GtkMenuShell*");
  Xen_check_type(Xen_is_GtkWidget_(menu_item), menu_item, 2, "gtk_menu_shell_activate_item", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(force_deactivate), force_deactivate, 3, "gtk_menu_shell_activate_item", "gboolean");
  gtk_menu_shell_activate_item(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_GtkWidget_(menu_item), Xen_to_C_gboolean(force_deactivate));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_new(void)
{
  #define H_gtk_notebook_new "GtkWidget* gtk_notebook_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_notebook_new()));
}

static Xen gxg_gtk_notebook_remove_page(Xen notebook, Xen page_num)
{
  #define H_gtk_notebook_remove_page "void gtk_notebook_remove_page(GtkNotebook* notebook, gint page_num)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_remove_page", "GtkNotebook*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_notebook_remove_page", "gint");
  gtk_notebook_remove_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gint(page_num));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_current_page(Xen notebook)
{
  #define H_gtk_notebook_get_current_page "gint gtk_notebook_get_current_page(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_current_page", "GtkNotebook*");
  return(C_to_Xen_gint(gtk_notebook_get_current_page(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_get_nth_page(Xen notebook, Xen page_num)
{
  #define H_gtk_notebook_get_nth_page "GtkWidget* gtk_notebook_get_nth_page(GtkNotebook* notebook, gint page_num)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_nth_page", "GtkNotebook*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_notebook_get_nth_page", "gint");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_nth_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gint(page_num))));
}

static Xen gxg_gtk_notebook_page_num(Xen notebook, Xen child)
{
  #define H_gtk_notebook_page_num "gint gtk_notebook_page_num(GtkNotebook* notebook, GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_page_num", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_page_num", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_page_num(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_current_page(Xen notebook, Xen page_num)
{
  #define H_gtk_notebook_set_current_page "void gtk_notebook_set_current_page(GtkNotebook* notebook, \
gint page_num)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_current_page", "GtkNotebook*");
  Xen_check_type(Xen_is_gint(page_num), page_num, 2, "gtk_notebook_set_current_page", "gint");
  gtk_notebook_set_current_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gint(page_num));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_next_page(Xen notebook)
{
  #define H_gtk_notebook_next_page "void gtk_notebook_next_page(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_next_page", "GtkNotebook*");
  gtk_notebook_next_page(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_prev_page(Xen notebook)
{
  #define H_gtk_notebook_prev_page "void gtk_notebook_prev_page(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_prev_page", "GtkNotebook*");
  gtk_notebook_prev_page(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_set_show_border(Xen notebook, Xen show_border)
{
  #define H_gtk_notebook_set_show_border "void gtk_notebook_set_show_border(GtkNotebook* notebook, gboolean show_border)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_show_border", "GtkNotebook*");
  Xen_check_type(Xen_is_gboolean(show_border), show_border, 2, "gtk_notebook_set_show_border", "gboolean");
  gtk_notebook_set_show_border(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gboolean(show_border));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_show_border(Xen notebook)
{
  #define H_gtk_notebook_get_show_border "gboolean gtk_notebook_get_show_border(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_show_border", "GtkNotebook*");
  return(C_to_Xen_gboolean(gtk_notebook_get_show_border(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_set_show_tabs(Xen notebook, Xen show_tabs)
{
  #define H_gtk_notebook_set_show_tabs "void gtk_notebook_set_show_tabs(GtkNotebook* notebook, gboolean show_tabs)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_show_tabs", "GtkNotebook*");
  Xen_check_type(Xen_is_gboolean(show_tabs), show_tabs, 2, "gtk_notebook_set_show_tabs", "gboolean");
  gtk_notebook_set_show_tabs(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gboolean(show_tabs));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_show_tabs(Xen notebook)
{
  #define H_gtk_notebook_get_show_tabs "gboolean gtk_notebook_get_show_tabs(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_show_tabs", "GtkNotebook*");
  return(C_to_Xen_gboolean(gtk_notebook_get_show_tabs(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_set_tab_pos(Xen notebook, Xen pos)
{
  #define H_gtk_notebook_set_tab_pos "void gtk_notebook_set_tab_pos(GtkNotebook* notebook, GtkPositionType pos)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_pos", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkPositionType(pos), pos, 2, "gtk_notebook_set_tab_pos", "GtkPositionType");
  gtk_notebook_set_tab_pos(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkPositionType(pos));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_pos(Xen notebook)
{
  #define H_gtk_notebook_get_tab_pos "GtkPositionType gtk_notebook_get_tab_pos(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_pos", "GtkNotebook*");
  return(C_to_Xen_GtkPositionType(gtk_notebook_get_tab_pos(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_set_scrollable(Xen notebook, Xen scrollable)
{
  #define H_gtk_notebook_set_scrollable "void gtk_notebook_set_scrollable(GtkNotebook* notebook, gboolean scrollable)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_scrollable", "GtkNotebook*");
  Xen_check_type(Xen_is_gboolean(scrollable), scrollable, 2, "gtk_notebook_set_scrollable", "gboolean");
  gtk_notebook_set_scrollable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_gboolean(scrollable));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_scrollable(Xen notebook)
{
  #define H_gtk_notebook_get_scrollable "gboolean gtk_notebook_get_scrollable(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_scrollable", "GtkNotebook*");
  return(C_to_Xen_gboolean(gtk_notebook_get_scrollable(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_notebook_popup_enable(Xen notebook)
{
  #define H_gtk_notebook_popup_enable "void gtk_notebook_popup_enable(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_popup_enable", "GtkNotebook*");
  gtk_notebook_popup_enable(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_popup_disable(Xen notebook)
{
  #define H_gtk_notebook_popup_disable "void gtk_notebook_popup_disable(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_popup_disable", "GtkNotebook*");
  gtk_notebook_popup_disable(Xen_to_C_GtkNotebook_(notebook));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_label(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_label "GtkWidget* gtk_notebook_get_tab_label(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_label", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_tab_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_tab_label(Xen notebook, Xen child, Xen tab_label)
{
  #define H_gtk_notebook_set_tab_label "void gtk_notebook_set_tab_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_set_tab_label", "GtkWidget*");
  gtk_notebook_set_tab_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_set_tab_label_text(Xen notebook, Xen child, Xen tab_text)
{
  #define H_gtk_notebook_set_tab_label_text "void gtk_notebook_set_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* tab_text)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_label_text", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(tab_text), tab_text, 3, "gtk_notebook_set_tab_label_text", "gchar*");
  gtk_notebook_set_tab_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gchar_(tab_text));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_label_text(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_label_text "gchar* gtk_notebook_get_tab_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_label_text", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_notebook_get_tab_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_get_menu_label(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_menu_label "GtkWidget* gtk_notebook_get_menu_label(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_menu_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_menu_label", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_notebook_get_menu_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_menu_label(Xen notebook, Xen child, Xen menu_label)
{
  #define H_gtk_notebook_set_menu_label "void gtk_notebook_set_menu_label(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* menu_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_menu_label", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_menu_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label), menu_label, 3, "gtk_notebook_set_menu_label", "GtkWidget*");
  gtk_notebook_set_menu_label(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(menu_label));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_set_menu_label_text(Xen notebook, Xen child, Xen menu_text)
{
  #define H_gtk_notebook_set_menu_label_text "void gtk_notebook_set_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child, gchar* menu_text)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_menu_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_menu_label_text", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(menu_text), menu_text, 3, "gtk_notebook_set_menu_label_text", "gchar*");
  gtk_notebook_set_menu_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gchar_(menu_text));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_menu_label_text(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_menu_label_text "gchar* gtk_notebook_get_menu_label_text(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_menu_label_text", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_menu_label_text", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_notebook_get_menu_label_text(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_reorder_child(Xen notebook, Xen child, Xen position)
{
  #define H_gtk_notebook_reorder_child "void gtk_notebook_reorder_child(GtkNotebook* notebook, GtkWidget* child, \
gint position)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_reorder_child", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_reorder_child", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_notebook_reorder_child", "gint");
  gtk_notebook_reorder_child(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_append_page(Xen notebook, Xen child, Xen tab_label)
{
  #define H_gtk_notebook_append_page "gint gtk_notebook_append_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_append_page", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_append_page", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_append_page", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_append_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label))));
}

static Xen gxg_gtk_notebook_append_page_menu(Xen notebook, Xen child, Xen tab_label, Xen menu_label)
{
  #define H_gtk_notebook_append_page_menu "gint gtk_notebook_append_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_append_page_menu", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_append_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_append_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label) || Xen_is_false(menu_label), menu_label, 4, "gtk_notebook_append_page_menu", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_append_page_menu(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                     Xen_to_C_GtkWidget_(menu_label))));
}

static Xen gxg_gtk_notebook_prepend_page(Xen notebook, Xen child, Xen tab_label)
{
  #define H_gtk_notebook_prepend_page "gint gtk_notebook_prepend_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_prepend_page", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_prepend_page", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_prepend_page", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_prepend_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label))));
}

static Xen gxg_gtk_notebook_prepend_page_menu(Xen notebook, Xen child, Xen tab_label, Xen menu_label)
{
  #define H_gtk_notebook_prepend_page_menu "gint gtk_notebook_prepend_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_prepend_page_menu", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_prepend_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_prepend_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label) || Xen_is_false(menu_label), menu_label, 4, "gtk_notebook_prepend_page_menu", "GtkWidget*");
  return(C_to_Xen_gint(gtk_notebook_prepend_page_menu(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                      Xen_to_C_GtkWidget_(menu_label))));
}

static Xen gxg_gtk_notebook_insert_page(Xen notebook, Xen child, Xen tab_label, Xen position)
{
  #define H_gtk_notebook_insert_page "gint gtk_notebook_insert_page(GtkNotebook* notebook, GtkWidget* child, \
GtkWidget* tab_label, gint position)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_insert_page", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_insert_page", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_insert_page", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 4, "gtk_notebook_insert_page", "gint");
  return(C_to_Xen_gint(gtk_notebook_insert_page(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                Xen_to_C_gint(position))));
}

static Xen gxg_gtk_notebook_insert_page_menu(Xen notebook, Xen child, Xen tab_label, Xen menu_label, Xen position)
{
  #define H_gtk_notebook_insert_page_menu "gint gtk_notebook_insert_page_menu(GtkNotebook* notebook, \
GtkWidget* child, GtkWidget* tab_label, GtkWidget* menu_label, gint position)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_insert_page_menu", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_insert_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(tab_label) || Xen_is_false(tab_label), tab_label, 3, "gtk_notebook_insert_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(menu_label) || Xen_is_false(menu_label), menu_label, 4, "gtk_notebook_insert_page_menu", "GtkWidget*");
  Xen_check_type(Xen_is_gint(position), position, 5, "gtk_notebook_insert_page_menu", "gint");
  return(C_to_Xen_gint(gtk_notebook_insert_page_menu(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkWidget_(tab_label), 
                                                     Xen_to_C_GtkWidget_(menu_label), Xen_to_C_gint(position))));
}

static Xen gxg_gtk_paned_add1(Xen paned, Xen child)
{
  #define H_gtk_paned_add1 "void gtk_paned_add1(GtkPaned* paned, GtkWidget* child)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_add1", "GtkPaned*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_paned_add1", "GtkWidget*");
  gtk_paned_add1(Xen_to_C_GtkPaned_(paned), Xen_to_C_GtkWidget_(child));
  return(Xen_false);
}

static Xen gxg_gtk_paned_add2(Xen paned, Xen child)
{
  #define H_gtk_paned_add2 "void gtk_paned_add2(GtkPaned* paned, GtkWidget* child)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_add2", "GtkPaned*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_paned_add2", "GtkWidget*");
  gtk_paned_add2(Xen_to_C_GtkPaned_(paned), Xen_to_C_GtkWidget_(child));
  return(Xen_false);
}

static Xen gxg_gtk_paned_pack1(Xen paned, Xen child, Xen resize, Xen shrink)
{
  #define H_gtk_paned_pack1 "void gtk_paned_pack1(GtkPaned* paned, GtkWidget* child, gboolean resize, \
gboolean shrink)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_pack1", "GtkPaned*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_paned_pack1", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(resize), resize, 3, "gtk_paned_pack1", "gboolean");
  Xen_check_type(Xen_is_gboolean(shrink), shrink, 4, "gtk_paned_pack1", "gboolean");
  gtk_paned_pack1(Xen_to_C_GtkPaned_(paned), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(resize), Xen_to_C_gboolean(shrink));
  return(Xen_false);
}

static Xen gxg_gtk_paned_pack2(Xen paned, Xen child, Xen resize, Xen shrink)
{
  #define H_gtk_paned_pack2 "void gtk_paned_pack2(GtkPaned* paned, GtkWidget* child, gboolean resize, \
gboolean shrink)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_pack2", "GtkPaned*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_paned_pack2", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(resize), resize, 3, "gtk_paned_pack2", "gboolean");
  Xen_check_type(Xen_is_gboolean(shrink), shrink, 4, "gtk_paned_pack2", "gboolean");
  gtk_paned_pack2(Xen_to_C_GtkPaned_(paned), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(resize), Xen_to_C_gboolean(shrink));
  return(Xen_false);
}

static Xen gxg_gtk_paned_get_position(Xen paned)
{
  #define H_gtk_paned_get_position "gint gtk_paned_get_position(GtkPaned* paned)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_get_position", "GtkPaned*");
  return(C_to_Xen_gint(gtk_paned_get_position(Xen_to_C_GtkPaned_(paned))));
}

static Xen gxg_gtk_paned_set_position(Xen paned, Xen position)
{
  #define H_gtk_paned_set_position "void gtk_paned_set_position(GtkPaned* paned, gint position)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_set_position", "GtkPaned*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_paned_set_position", "gint");
  gtk_paned_set_position(Xen_to_C_GtkPaned_(paned), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_new(void)
{
  #define H_gtk_progress_bar_new "GtkWidget* gtk_progress_bar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_progress_bar_new()));
}

static Xen gxg_gtk_progress_bar_pulse(Xen pbar)
{
  #define H_gtk_progress_bar_pulse "void gtk_progress_bar_pulse(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_pulse", "GtkProgressBar*");
  gtk_progress_bar_pulse(Xen_to_C_GtkProgressBar_(pbar));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_set_text(Xen pbar, Xen text)
{
  #define H_gtk_progress_bar_set_text "void gtk_progress_bar_set_text(GtkProgressBar* pbar, gchar* text)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_text", "GtkProgressBar*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_progress_bar_set_text", "gchar*");
  gtk_progress_bar_set_text(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_set_fraction(Xen pbar, Xen fraction)
{
  #define H_gtk_progress_bar_set_fraction "void gtk_progress_bar_set_fraction(GtkProgressBar* pbar, gdouble fraction)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_fraction", "GtkProgressBar*");
  Xen_check_type(Xen_is_gdouble(fraction), fraction, 2, "gtk_progress_bar_set_fraction", "gdouble");
  gtk_progress_bar_set_fraction(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gdouble(fraction));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_set_pulse_step(Xen pbar, Xen fraction)
{
  #define H_gtk_progress_bar_set_pulse_step "void gtk_progress_bar_set_pulse_step(GtkProgressBar* pbar, \
gdouble fraction)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_pulse_step", "GtkProgressBar*");
  Xen_check_type(Xen_is_gdouble(fraction), fraction, 2, "gtk_progress_bar_set_pulse_step", "gdouble");
  gtk_progress_bar_set_pulse_step(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_gdouble(fraction));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_get_text(Xen pbar)
{
  #define H_gtk_progress_bar_get_text "gchar* gtk_progress_bar_get_text(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_text", "GtkProgressBar*");
  return(C_to_Xen_gchar_(gtk_progress_bar_get_text(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_progress_bar_get_fraction(Xen pbar)
{
  #define H_gtk_progress_bar_get_fraction "gdouble gtk_progress_bar_get_fraction(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_fraction", "GtkProgressBar*");
  return(C_to_Xen_gdouble(gtk_progress_bar_get_fraction(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_progress_bar_get_pulse_step(Xen pbar)
{
  #define H_gtk_progress_bar_get_pulse_step "gdouble gtk_progress_bar_get_pulse_step(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_pulse_step", "GtkProgressBar*");
  return(C_to_Xen_gdouble(gtk_progress_bar_get_pulse_step(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_radio_button_new(Xen group)
{
  #define H_gtk_radio_button_new "GtkWidget* gtk_radio_button_new(GSList* group)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_button_new", "GSList*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new(Xen_to_C_GSList_(group))));
}

static Xen gxg_gtk_radio_button_new_from_widget(Xen group)
{
  #define H_gtk_radio_button_new_from_widget "GtkWidget* gtk_radio_button_new_from_widget(GtkRadioButton* group)"
  Xen_check_type(Xen_is_GtkRadioButton_(group), group, 1, "gtk_radio_button_new_from_widget", "GtkRadioButton*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_from_widget(Xen_to_C_GtkRadioButton_(group))));
}

static Xen gxg_gtk_radio_button_new_with_label(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_label "GtkWidget* gtk_radio_button_new_with_label(GSList* group, \
gchar* label)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_button_new_with_label", "GSList*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_label(Xen_to_C_GSList_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_new_with_label_from_widget(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_label_from_widget "GtkWidget* gtk_radio_button_new_with_label_from_widget(GtkRadioButton* group, \
gchar* label)"
  Xen_check_type(Xen_is_GtkRadioButton_(group), group, 1, "gtk_radio_button_new_with_label_from_widget", "GtkRadioButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_label_from_widget", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_label_from_widget(Xen_to_C_GtkRadioButton_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_new_with_mnemonic(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_mnemonic "GtkWidget* gtk_radio_button_new_with_mnemonic(GSList* group, \
gchar* label)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_button_new_with_mnemonic", "GSList*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_mnemonic(Xen_to_C_GSList_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_new_with_mnemonic_from_widget(Xen group, Xen label)
{
  #define H_gtk_radio_button_new_with_mnemonic_from_widget "GtkWidget* gtk_radio_button_new_with_mnemonic_from_widget(GtkRadioButton* group, \
gchar* label)"
  Xen_check_type(Xen_is_GtkRadioButton_(group), group, 1, "gtk_radio_button_new_with_mnemonic_from_widget", "GtkRadioButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_button_new_with_mnemonic_from_widget", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_button_new_with_mnemonic_from_widget(Xen_to_C_GtkRadioButton_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_button_get_group(Xen radio_button)
{
  #define H_gtk_radio_button_get_group "GSList* gtk_radio_button_get_group(GtkRadioButton* radio_button)"
  Xen_check_type(Xen_is_GtkRadioButton_(radio_button), radio_button, 1, "gtk_radio_button_get_group", "GtkRadioButton*");
  return(C_to_Xen_GSList_(gtk_radio_button_get_group(Xen_to_C_GtkRadioButton_(radio_button))));
}

static Xen gxg_gtk_radio_button_set_group(Xen radio_button, Xen group)
{
  #define H_gtk_radio_button_set_group "void gtk_radio_button_set_group(GtkRadioButton* radio_button, \
GSList* group)"
  Xen_check_type(Xen_is_GtkRadioButton_(radio_button), radio_button, 1, "gtk_radio_button_set_group", "GtkRadioButton*");
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 2, "gtk_radio_button_set_group", "GSList*");
  gtk_radio_button_set_group(Xen_to_C_GtkRadioButton_(radio_button), Xen_to_C_GSList_(group));
  return(Xen_false);
}

static Xen gxg_gtk_radio_menu_item_new(Xen group)
{
  #define H_gtk_radio_menu_item_new "GtkWidget* gtk_radio_menu_item_new(GSList* group)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_menu_item_new", "GSList*");
  return(C_to_Xen_GtkWidget_(gtk_radio_menu_item_new(Xen_to_C_GSList_(group))));
}

static Xen gxg_gtk_radio_menu_item_new_with_label(Xen group, Xen label)
{
  #define H_gtk_radio_menu_item_new_with_label "GtkWidget* gtk_radio_menu_item_new_with_label(GSList* group, \
gchar* label)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_menu_item_new_with_label", "GSList*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_menu_item_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_menu_item_new_with_label(Xen_to_C_GSList_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_menu_item_new_with_mnemonic(Xen group, Xen label)
{
  #define H_gtk_radio_menu_item_new_with_mnemonic "GtkWidget* gtk_radio_menu_item_new_with_mnemonic(GSList* group, \
gchar* label)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_menu_item_new_with_mnemonic", "GSList*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_menu_item_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_menu_item_new_with_mnemonic(Xen_to_C_GSList_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_menu_item_get_group(Xen radio_menu_item)
{
  #define H_gtk_radio_menu_item_get_group "GSList* gtk_radio_menu_item_get_group(GtkRadioMenuItem* radio_menu_item)"
  Xen_check_type(Xen_is_GtkRadioMenuItem_(radio_menu_item), radio_menu_item, 1, "gtk_radio_menu_item_get_group", "GtkRadioMenuItem*");
  return(C_to_Xen_GSList_(gtk_radio_menu_item_get_group(Xen_to_C_GtkRadioMenuItem_(radio_menu_item))));
}

static Xen gxg_gtk_radio_menu_item_set_group(Xen radio_menu_item, Xen group)
{
  #define H_gtk_radio_menu_item_set_group "void gtk_radio_menu_item_set_group(GtkRadioMenuItem* radio_menu_item, \
GSList* group)"
  Xen_check_type(Xen_is_GtkRadioMenuItem_(radio_menu_item), radio_menu_item, 1, "gtk_radio_menu_item_set_group", "GtkRadioMenuItem*");
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 2, "gtk_radio_menu_item_set_group", "GSList*");
  gtk_radio_menu_item_set_group(Xen_to_C_GtkRadioMenuItem_(radio_menu_item), Xen_to_C_GSList_(group));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_adjustment(Xen range, Xen adjustment)
{
  #define H_gtk_range_set_adjustment "void gtk_range_set_adjustment(GtkRange* range, GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_adjustment", "GtkRange*");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 2, "gtk_range_set_adjustment", "GtkAdjustment*");
  gtk_range_set_adjustment(Xen_to_C_GtkRange_(range), Xen_to_C_GtkAdjustment_(adjustment));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_adjustment(Xen range)
{
  #define H_gtk_range_get_adjustment "GtkAdjustment* gtk_range_get_adjustment(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_adjustment", "GtkRange*");
  return(C_to_Xen_GtkAdjustment_(gtk_range_get_adjustment(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_inverted(Xen range, Xen setting)
{
  #define H_gtk_range_set_inverted "void gtk_range_set_inverted(GtkRange* range, gboolean setting)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_inverted", "GtkRange*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_range_set_inverted", "gboolean");
  gtk_range_set_inverted(Xen_to_C_GtkRange_(range), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_inverted(Xen range)
{
  #define H_gtk_range_get_inverted "gboolean gtk_range_get_inverted(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_inverted", "GtkRange*");
  return(C_to_Xen_gboolean(gtk_range_get_inverted(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_increments(Xen range, Xen step, Xen page)
{
  #define H_gtk_range_set_increments "void gtk_range_set_increments(GtkRange* range, gdouble step, gdouble page)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_increments", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(step), step, 2, "gtk_range_set_increments", "gdouble");
  Xen_check_type(Xen_is_gdouble(page), page, 3, "gtk_range_set_increments", "gdouble");
  gtk_range_set_increments(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(step), Xen_to_C_gdouble(page));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_range(Xen range, Xen min, Xen max)
{
  #define H_gtk_range_set_range "void gtk_range_set_range(GtkRange* range, gdouble min, gdouble max)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_range", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(min), min, 2, "gtk_range_set_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 3, "gtk_range_set_range", "gdouble");
  gtk_range_set_range(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(min), Xen_to_C_gdouble(max));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_value(Xen range, Xen value)
{
  #define H_gtk_range_set_value "void gtk_range_set_value(GtkRange* range, gdouble value)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_value", "GtkRange*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_range_set_value", "gdouble");
  gtk_range_set_value(Xen_to_C_GtkRange_(range), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_value(Xen range)
{
  #define H_gtk_range_get_value "gdouble gtk_range_get_value(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_value", "GtkRange*");
  return(C_to_Xen_gdouble(gtk_range_get_value(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_scale_set_digits(Xen scale, Xen digits)
{
  #define H_gtk_scale_set_digits "void gtk_scale_set_digits(GtkScale* scale, gint digits)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_set_digits", "GtkScale*");
  Xen_check_type(Xen_is_gint(digits), digits, 2, "gtk_scale_set_digits", "gint");
  gtk_scale_set_digits(Xen_to_C_GtkScale_(scale), Xen_to_C_gint(digits));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_digits(Xen scale)
{
  #define H_gtk_scale_get_digits "gint gtk_scale_get_digits(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_digits", "GtkScale*");
  return(C_to_Xen_gint(gtk_scale_get_digits(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scale_set_draw_value(Xen scale, Xen draw_value)
{
  #define H_gtk_scale_set_draw_value "void gtk_scale_set_draw_value(GtkScale* scale, gboolean draw_value)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_set_draw_value", "GtkScale*");
  Xen_check_type(Xen_is_gboolean(draw_value), draw_value, 2, "gtk_scale_set_draw_value", "gboolean");
  gtk_scale_set_draw_value(Xen_to_C_GtkScale_(scale), Xen_to_C_gboolean(draw_value));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_draw_value(Xen scale)
{
  #define H_gtk_scale_get_draw_value "gboolean gtk_scale_get_draw_value(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_draw_value", "GtkScale*");
  return(C_to_Xen_gboolean(gtk_scale_get_draw_value(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scale_set_value_pos(Xen scale, Xen pos)
{
  #define H_gtk_scale_set_value_pos "void gtk_scale_set_value_pos(GtkScale* scale, GtkPositionType pos)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_set_value_pos", "GtkScale*");
  Xen_check_type(Xen_is_GtkPositionType(pos), pos, 2, "gtk_scale_set_value_pos", "GtkPositionType");
  gtk_scale_set_value_pos(Xen_to_C_GtkScale_(scale), Xen_to_C_GtkPositionType(pos));
  return(Xen_false);
}

static Xen gxg_gtk_scale_get_value_pos(Xen scale)
{
  #define H_gtk_scale_get_value_pos "GtkPositionType gtk_scale_get_value_pos(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_value_pos", "GtkScale*");
  return(C_to_Xen_GtkPositionType(gtk_scale_get_value_pos(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scrolled_window_new(Xen hadjustment, Xen vadjustment)
{
  #define H_gtk_scrolled_window_new "GtkWidget* gtk_scrolled_window_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 1, "gtk_scrolled_window_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_GtkAdjustment_(vadjustment) || Xen_is_false(vadjustment), vadjustment, 2, "gtk_scrolled_window_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_scrolled_window_new(Xen_to_C_GtkAdjustment_(hadjustment), Xen_to_C_GtkAdjustment_(vadjustment))));
}

static Xen gxg_gtk_scrolled_window_set_hadjustment(Xen scrolled_window, Xen hadjustment)
{
  #define H_gtk_scrolled_window_set_hadjustment "void gtk_scrolled_window_set_hadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_hadjustment", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 2, "gtk_scrolled_window_set_hadjustment", "GtkAdjustment*");
  gtk_scrolled_window_set_hadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkAdjustment_(hadjustment));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_set_vadjustment(Xen scrolled_window, Xen hadjustment)
{
  #define H_gtk_scrolled_window_set_vadjustment "void gtk_scrolled_window_set_vadjustment(GtkScrolledWindow* scrolled_window, \
GtkAdjustment* hadjustment)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_vadjustment", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 2, "gtk_scrolled_window_set_vadjustment", "GtkAdjustment*");
  gtk_scrolled_window_set_vadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkAdjustment_(hadjustment));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_hadjustment(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_hadjustment "GtkAdjustment* gtk_scrolled_window_get_hadjustment(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_hadjustment", "GtkScrolledWindow*");
  return(C_to_Xen_GtkAdjustment_(gtk_scrolled_window_get_hadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_get_vadjustment(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_vadjustment "GtkAdjustment* gtk_scrolled_window_get_vadjustment(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_vadjustment", "GtkScrolledWindow*");
  return(C_to_Xen_GtkAdjustment_(gtk_scrolled_window_get_vadjustment(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_set_policy(Xen scrolled_window, Xen hscrollbar_policy, Xen vscrollbar_policy)
{
  #define H_gtk_scrolled_window_set_policy "void gtk_scrolled_window_set_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType hscrollbar_policy, GtkPolicyType vscrollbar_policy)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_policy", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkPolicyType(hscrollbar_policy), hscrollbar_policy, 2, "gtk_scrolled_window_set_policy", "GtkPolicyType");
  Xen_check_type(Xen_is_GtkPolicyType(vscrollbar_policy), vscrollbar_policy, 3, "gtk_scrolled_window_set_policy", "GtkPolicyType");
  gtk_scrolled_window_set_policy(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkPolicyType(hscrollbar_policy), 
                                 Xen_to_C_GtkPolicyType(vscrollbar_policy));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_policy(Xen scrolled_window, Xen ignore_hscrollbar_policy, Xen ignore_vscrollbar_policy)
{
  #define H_gtk_scrolled_window_get_policy "void gtk_scrolled_window_get_policy(GtkScrolledWindow* scrolled_window, \
GtkPolicyType* [hscrollbar_policy], GtkPolicyType* [vscrollbar_policy])"
  GtkPolicyType ref_hscrollbar_policy;
  GtkPolicyType ref_vscrollbar_policy;
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_policy", "GtkScrolledWindow*");
  gtk_scrolled_window_get_policy(Xen_to_C_GtkScrolledWindow_(scrolled_window), &ref_hscrollbar_policy, &ref_vscrollbar_policy);
  return(Xen_list_2(C_to_Xen_GtkPolicyType(ref_hscrollbar_policy), C_to_Xen_GtkPolicyType(ref_vscrollbar_policy)));
}

static Xen gxg_gtk_scrolled_window_set_placement(Xen scrolled_window, Xen window_placement)
{
  #define H_gtk_scrolled_window_set_placement "void gtk_scrolled_window_set_placement(GtkScrolledWindow* scrolled_window, \
GtkCornerType window_placement)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_placement", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkCornerType(window_placement), window_placement, 2, "gtk_scrolled_window_set_placement", "GtkCornerType");
  gtk_scrolled_window_set_placement(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkCornerType(window_placement));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_placement(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_placement "GtkCornerType gtk_scrolled_window_get_placement(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_placement", "GtkScrolledWindow*");
  return(C_to_Xen_GtkCornerType(gtk_scrolled_window_get_placement(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_scrolled_window_set_shadow_type(Xen scrolled_window, Xen type)
{
  #define H_gtk_scrolled_window_set_shadow_type "void gtk_scrolled_window_set_shadow_type(GtkScrolledWindow* scrolled_window, \
GtkShadowType type)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_set_shadow_type", "GtkScrolledWindow*");
  Xen_check_type(Xen_is_GtkShadowType(type), type, 2, "gtk_scrolled_window_set_shadow_type", "GtkShadowType");
  gtk_scrolled_window_set_shadow_type(Xen_to_C_GtkScrolledWindow_(scrolled_window), Xen_to_C_GtkShadowType(type));
  return(Xen_false);
}

static Xen gxg_gtk_scrolled_window_get_shadow_type(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_get_shadow_type "GtkShadowType gtk_scrolled_window_get_shadow_type(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_get_shadow_type", "GtkScrolledWindow*");
  return(C_to_Xen_GtkShadowType(gtk_scrolled_window_get_shadow_type(Xen_to_C_GtkScrolledWindow_(scrolled_window))));
}

static Xen gxg_gtk_selection_data_copy(Xen data)
{
  #define H_gtk_selection_data_copy "GtkSelectionData* gtk_selection_data_copy(GtkSelectionData* data)"
  Xen_check_type(Xen_is_GtkSelectionData_(data), data, 1, "gtk_selection_data_copy", "GtkSelectionData*");
  return(C_to_Xen_GtkSelectionData_(gtk_selection_data_copy(Xen_to_C_GtkSelectionData_(data))));
}

static Xen gxg_gtk_selection_data_free(Xen data)
{
  #define H_gtk_selection_data_free "void gtk_selection_data_free(GtkSelectionData* data)"
  Xen_check_type(Xen_is_GtkSelectionData_(data), data, 1, "gtk_selection_data_free", "GtkSelectionData*");
  gtk_selection_data_free(Xen_to_C_GtkSelectionData_(data));
  return(Xen_false);
}

static Xen gxg_gtk_separator_menu_item_new(void)
{
  #define H_gtk_separator_menu_item_new "GtkWidget* gtk_separator_menu_item_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_separator_menu_item_new()));
}

static Xen gxg_gtk_settings_get_default(void)
{
  #define H_gtk_settings_get_default "GtkSettings* gtk_settings_get_default( void)"
  return(C_to_Xen_GtkSettings_(gtk_settings_get_default()));
}

static Xen gxg_gtk_size_group_new(Xen mode)
{
  #define H_gtk_size_group_new "GtkSizeGroup* gtk_size_group_new(GtkSizeGroupMode mode)"
  Xen_check_type(Xen_is_GtkSizeGroupMode(mode), mode, 1, "gtk_size_group_new", "GtkSizeGroupMode");
  return(C_to_Xen_GtkSizeGroup_(gtk_size_group_new(Xen_to_C_GtkSizeGroupMode(mode))));
}

static Xen gxg_gtk_size_group_set_mode(Xen size_group, Xen mode)
{
  #define H_gtk_size_group_set_mode "void gtk_size_group_set_mode(GtkSizeGroup* size_group, GtkSizeGroupMode mode)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_set_mode", "GtkSizeGroup*");
  Xen_check_type(Xen_is_GtkSizeGroupMode(mode), mode, 2, "gtk_size_group_set_mode", "GtkSizeGroupMode");
  gtk_size_group_set_mode(Xen_to_C_GtkSizeGroup_(size_group), Xen_to_C_GtkSizeGroupMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_size_group_get_mode(Xen size_group)
{
  #define H_gtk_size_group_get_mode "GtkSizeGroupMode gtk_size_group_get_mode(GtkSizeGroup* size_group)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_get_mode", "GtkSizeGroup*");
  return(C_to_Xen_GtkSizeGroupMode(gtk_size_group_get_mode(Xen_to_C_GtkSizeGroup_(size_group))));
}

static Xen gxg_gtk_size_group_add_widget(Xen size_group, Xen widget)
{
  #define H_gtk_size_group_add_widget "void gtk_size_group_add_widget(GtkSizeGroup* size_group, GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_add_widget", "GtkSizeGroup*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_size_group_add_widget", "GtkWidget*");
  gtk_size_group_add_widget(Xen_to_C_GtkSizeGroup_(size_group), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_size_group_remove_widget(Xen size_group, Xen widget)
{
  #define H_gtk_size_group_remove_widget "void gtk_size_group_remove_widget(GtkSizeGroup* size_group, \
GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1, "gtk_size_group_remove_widget", "GtkSizeGroup*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_size_group_remove_widget", "GtkWidget*");
  gtk_size_group_remove_widget(Xen_to_C_GtkSizeGroup_(size_group), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_configure(Xen spin_button, Xen adjustment, Xen climb_rate, Xen digits)
{
  #define H_gtk_spin_button_configure "void gtk_spin_button_configure(GtkSpinButton* spin_button, GtkAdjustment* adjustment, \
gdouble climb_rate, guint digits)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_configure", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 2, "gtk_spin_button_configure", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(climb_rate), climb_rate, 3, "gtk_spin_button_configure", "gdouble");
  Xen_check_type(Xen_is_guint(digits), digits, 4, "gtk_spin_button_configure", "guint");
  gtk_spin_button_configure(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(climb_rate), 
                            Xen_to_C_guint(digits));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_new(Xen adjustment, Xen climb_rate, Xen digits)
{
  #define H_gtk_spin_button_new "GtkWidget* gtk_spin_button_new(GtkAdjustment* adjustment, gdouble climb_rate, \
guint digits)"
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 1, "gtk_spin_button_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_gdouble(climb_rate), climb_rate, 2, "gtk_spin_button_new", "gdouble");
  Xen_check_type(Xen_is_guint(digits), digits, 3, "gtk_spin_button_new", "guint");
  return(C_to_Xen_GtkWidget_(gtk_spin_button_new(Xen_to_C_GtkAdjustment_(adjustment), Xen_to_C_gdouble(climb_rate), Xen_to_C_guint(digits))));
}

static Xen gxg_gtk_spin_button_new_with_range(Xen min, Xen max, Xen step)
{
  #define H_gtk_spin_button_new_with_range "GtkWidget* gtk_spin_button_new_with_range(gdouble min, gdouble max, \
gdouble step)"
  Xen_check_type(Xen_is_gdouble(min), min, 1, "gtk_spin_button_new_with_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 2, "gtk_spin_button_new_with_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(step), step, 3, "gtk_spin_button_new_with_range", "gdouble");
  return(C_to_Xen_GtkWidget_(gtk_spin_button_new_with_range(Xen_to_C_gdouble(min), Xen_to_C_gdouble(max), Xen_to_C_gdouble(step))));
}

static Xen gxg_gtk_spin_button_set_adjustment(Xen spin_button, Xen adjustment)
{
  #define H_gtk_spin_button_set_adjustment "void gtk_spin_button_set_adjustment(GtkSpinButton* spin_button, \
GtkAdjustment* adjustment)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_adjustment", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkAdjustment_(adjustment) || Xen_is_false(adjustment), adjustment, 2, "gtk_spin_button_set_adjustment", "GtkAdjustment*");
  gtk_spin_button_set_adjustment(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkAdjustment_(adjustment));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_adjustment(Xen spin_button)
{
  #define H_gtk_spin_button_get_adjustment "GtkAdjustment* gtk_spin_button_get_adjustment(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_adjustment", "GtkSpinButton*");
  return(C_to_Xen_GtkAdjustment_(gtk_spin_button_get_adjustment(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_digits(Xen spin_button, Xen digits)
{
  #define H_gtk_spin_button_set_digits "void gtk_spin_button_set_digits(GtkSpinButton* spin_button, guint digits)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_digits", "GtkSpinButton*");
  Xen_check_type(Xen_is_guint(digits), digits, 2, "gtk_spin_button_set_digits", "guint");
  gtk_spin_button_set_digits(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_guint(digits));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_digits(Xen spin_button)
{
  #define H_gtk_spin_button_get_digits "guint gtk_spin_button_get_digits(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_digits", "GtkSpinButton*");
  return(C_to_Xen_guint(gtk_spin_button_get_digits(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_increments(Xen spin_button, Xen step, Xen page)
{
  #define H_gtk_spin_button_set_increments "void gtk_spin_button_set_increments(GtkSpinButton* spin_button, \
gdouble step, gdouble page)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_increments", "GtkSpinButton*");
  Xen_check_type(Xen_is_gdouble(step), step, 2, "gtk_spin_button_set_increments", "gdouble");
  Xen_check_type(Xen_is_gdouble(page), page, 3, "gtk_spin_button_set_increments", "gdouble");
  gtk_spin_button_set_increments(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gdouble(step), Xen_to_C_gdouble(page));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_increments(Xen spin_button, Xen ignore_step, Xen ignore_page)
{
  #define H_gtk_spin_button_get_increments "void gtk_spin_button_get_increments(GtkSpinButton* spin_button, \
gdouble* [step], gdouble* [page])"
  gdouble ref_step;
  gdouble ref_page;
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_increments", "GtkSpinButton*");
  gtk_spin_button_get_increments(Xen_to_C_GtkSpinButton_(spin_button), &ref_step, &ref_page);
  return(Xen_list_2(C_to_Xen_gdouble(ref_step), C_to_Xen_gdouble(ref_page)));
}

static Xen gxg_gtk_spin_button_set_range(Xen spin_button, Xen min, Xen max)
{
  #define H_gtk_spin_button_set_range "void gtk_spin_button_set_range(GtkSpinButton* spin_button, gdouble min, \
gdouble max)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_range", "GtkSpinButton*");
  Xen_check_type(Xen_is_gdouble(min), min, 2, "gtk_spin_button_set_range", "gdouble");
  Xen_check_type(Xen_is_gdouble(max), max, 3, "gtk_spin_button_set_range", "gdouble");
  gtk_spin_button_set_range(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gdouble(min), Xen_to_C_gdouble(max));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_range(Xen spin_button, Xen ignore_min, Xen ignore_max)
{
  #define H_gtk_spin_button_get_range "void gtk_spin_button_get_range(GtkSpinButton* spin_button, gdouble* [min], \
gdouble* [max])"
  gdouble ref_min;
  gdouble ref_max;
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_range", "GtkSpinButton*");
  gtk_spin_button_get_range(Xen_to_C_GtkSpinButton_(spin_button), &ref_min, &ref_max);
  return(Xen_list_2(C_to_Xen_gdouble(ref_min), C_to_Xen_gdouble(ref_max)));
}

static Xen gxg_gtk_spin_button_get_value(Xen spin_button)
{
  #define H_gtk_spin_button_get_value "gdouble gtk_spin_button_get_value(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_value", "GtkSpinButton*");
  return(C_to_Xen_gdouble(gtk_spin_button_get_value(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_get_value_as_int(Xen spin_button)
{
  #define H_gtk_spin_button_get_value_as_int "gint gtk_spin_button_get_value_as_int(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_value_as_int", "GtkSpinButton*");
  return(C_to_Xen_gint(gtk_spin_button_get_value_as_int(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_value(Xen spin_button, Xen value)
{
  #define H_gtk_spin_button_set_value "void gtk_spin_button_set_value(GtkSpinButton* spin_button, gdouble value)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_value", "GtkSpinButton*");
  Xen_check_type(Xen_is_gdouble(value), value, 2, "gtk_spin_button_set_value", "gdouble");
  gtk_spin_button_set_value(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gdouble(value));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_set_update_policy(Xen spin_button, Xen policy)
{
  #define H_gtk_spin_button_set_update_policy "void gtk_spin_button_set_update_policy(GtkSpinButton* spin_button, \
GtkSpinButtonUpdatePolicy policy)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_update_policy", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkSpinButtonUpdatePolicy(policy), policy, 2, "gtk_spin_button_set_update_policy", "GtkSpinButtonUpdatePolicy");
  gtk_spin_button_set_update_policy(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkSpinButtonUpdatePolicy(policy));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_update_policy(Xen spin_button)
{
  #define H_gtk_spin_button_get_update_policy "GtkSpinButtonUpdatePolicy gtk_spin_button_get_update_policy(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_update_policy", "GtkSpinButton*");
  return(C_to_Xen_GtkSpinButtonUpdatePolicy(gtk_spin_button_get_update_policy(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_numeric(Xen spin_button, Xen numeric)
{
  #define H_gtk_spin_button_set_numeric "void gtk_spin_button_set_numeric(GtkSpinButton* spin_button, \
gboolean numeric)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_numeric", "GtkSpinButton*");
  Xen_check_type(Xen_is_gboolean(numeric), numeric, 2, "gtk_spin_button_set_numeric", "gboolean");
  gtk_spin_button_set_numeric(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gboolean(numeric));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_numeric(Xen spin_button)
{
  #define H_gtk_spin_button_get_numeric "gboolean gtk_spin_button_get_numeric(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_numeric", "GtkSpinButton*");
  return(C_to_Xen_gboolean(gtk_spin_button_get_numeric(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_spin(Xen spin_button, Xen direction, Xen increment)
{
  #define H_gtk_spin_button_spin "void gtk_spin_button_spin(GtkSpinButton* spin_button, GtkSpinType direction, \
gdouble increment)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_spin", "GtkSpinButton*");
  Xen_check_type(Xen_is_GtkSpinType(direction), direction, 2, "gtk_spin_button_spin", "GtkSpinType");
  Xen_check_type(Xen_is_gdouble(increment), increment, 3, "gtk_spin_button_spin", "gdouble");
  gtk_spin_button_spin(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_GtkSpinType(direction), Xen_to_C_gdouble(increment));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_set_wrap(Xen spin_button, Xen wrap)
{
  #define H_gtk_spin_button_set_wrap "void gtk_spin_button_set_wrap(GtkSpinButton* spin_button, gboolean wrap)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_wrap", "GtkSpinButton*");
  Xen_check_type(Xen_is_gboolean(wrap), wrap, 2, "gtk_spin_button_set_wrap", "gboolean");
  gtk_spin_button_set_wrap(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gboolean(wrap));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_wrap(Xen spin_button)
{
  #define H_gtk_spin_button_get_wrap "gboolean gtk_spin_button_get_wrap(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_wrap", "GtkSpinButton*");
  return(C_to_Xen_gboolean(gtk_spin_button_get_wrap(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_set_snap_to_ticks(Xen spin_button, Xen snap_to_ticks)
{
  #define H_gtk_spin_button_set_snap_to_ticks "void gtk_spin_button_set_snap_to_ticks(GtkSpinButton* spin_button, \
gboolean snap_to_ticks)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_set_snap_to_ticks", "GtkSpinButton*");
  Xen_check_type(Xen_is_gboolean(snap_to_ticks), snap_to_ticks, 2, "gtk_spin_button_set_snap_to_ticks", "gboolean");
  gtk_spin_button_set_snap_to_ticks(Xen_to_C_GtkSpinButton_(spin_button), Xen_to_C_gboolean(snap_to_ticks));
  return(Xen_false);
}

static Xen gxg_gtk_spin_button_get_snap_to_ticks(Xen spin_button)
{
  #define H_gtk_spin_button_get_snap_to_ticks "gboolean gtk_spin_button_get_snap_to_ticks(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_get_snap_to_ticks", "GtkSpinButton*");
  return(C_to_Xen_gboolean(gtk_spin_button_get_snap_to_ticks(Xen_to_C_GtkSpinButton_(spin_button))));
}

static Xen gxg_gtk_spin_button_update(Xen spin_button)
{
  #define H_gtk_spin_button_update "void gtk_spin_button_update(GtkSpinButton* spin_button)"
  Xen_check_type(Xen_is_GtkSpinButton_(spin_button), spin_button, 1, "gtk_spin_button_update", "GtkSpinButton*");
  gtk_spin_button_update(Xen_to_C_GtkSpinButton_(spin_button));
  return(Xen_false);
}

static Xen gxg_gtk_statusbar_new(void)
{
  #define H_gtk_statusbar_new "GtkWidget* gtk_statusbar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_statusbar_new()));
}

static Xen gxg_gtk_statusbar_get_context_id(Xen statusbar, Xen context_description)
{
  #define H_gtk_statusbar_get_context_id "guint gtk_statusbar_get_context_id(GtkStatusbar* statusbar, \
gchar* context_description)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_get_context_id", "GtkStatusbar*");
  Xen_check_type(Xen_is_gchar_(context_description), context_description, 2, "gtk_statusbar_get_context_id", "gchar*");
  return(C_to_Xen_guint(gtk_statusbar_get_context_id(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_gchar_(context_description))));
}

static Xen gxg_gtk_statusbar_push(Xen statusbar, Xen context_id, Xen text)
{
  #define H_gtk_statusbar_push "guint gtk_statusbar_push(GtkStatusbar* statusbar, guint context_id, gchar* text)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_push", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_push", "guint");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_statusbar_push", "gchar*");
  return(C_to_Xen_guint(gtk_statusbar_push(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id), Xen_to_C_gchar_(text))));
}

static Xen gxg_gtk_statusbar_pop(Xen statusbar, Xen context_id)
{
  #define H_gtk_statusbar_pop "void gtk_statusbar_pop(GtkStatusbar* statusbar, guint context_id)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_pop", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_pop", "guint");
  gtk_statusbar_pop(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id));
  return(Xen_false);
}

static Xen gxg_gtk_statusbar_remove(Xen statusbar, Xen context_id, Xen message_id)
{
  #define H_gtk_statusbar_remove "void gtk_statusbar_remove(GtkStatusbar* statusbar, guint context_id, \
guint message_id)"
  Xen_check_type(Xen_is_GtkStatusbar_(statusbar), statusbar, 1, "gtk_statusbar_remove", "GtkStatusbar*");
  Xen_check_type(Xen_is_guint(context_id), context_id, 2, "gtk_statusbar_remove", "guint");
  Xen_check_type(Xen_is_guint(message_id), message_id, 3, "gtk_statusbar_remove", "guint");
  gtk_statusbar_remove(Xen_to_C_GtkStatusbar_(statusbar), Xen_to_C_guint(context_id), Xen_to_C_guint(message_id));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_new(Xen table)
{
  #define H_gtk_text_buffer_new "GtkTextBuffer* gtk_text_buffer_new(GtkTextTagTable* table)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table) || Xen_is_false(table), table, 1, "gtk_text_buffer_new", "GtkTextTagTable*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_buffer_new(Xen_to_C_GtkTextTagTable_(table))));
}

static Xen gxg_gtk_text_buffer_get_line_count(Xen buffer)
{
  #define H_gtk_text_buffer_get_line_count "gint gtk_text_buffer_get_line_count(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_line_count", "GtkTextBuffer*");
  return(C_to_Xen_gint(gtk_text_buffer_get_line_count(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_get_char_count(Xen buffer)
{
  #define H_gtk_text_buffer_get_char_count "gint gtk_text_buffer_get_char_count(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_char_count", "GtkTextBuffer*");
  return(C_to_Xen_gint(gtk_text_buffer_get_char_count(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_get_tag_table(Xen buffer)
{
  #define H_gtk_text_buffer_get_tag_table "GtkTextTagTable* gtk_text_buffer_get_tag_table(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_tag_table", "GtkTextBuffer*");
  return(C_to_Xen_GtkTextTagTable_(gtk_text_buffer_get_tag_table(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_set_text(Xen buffer, Xen text, Xen len)
{
  #define H_gtk_text_buffer_set_text "void gtk_text_buffer_set_text(GtkTextBuffer* buffer, gchar* text, \
gint len)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_set_text", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_text_buffer_set_text", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_text_buffer_set_text", "gint");
  gtk_text_buffer_set_text(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(text), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert(Xen buffer, Xen iter, Xen text, Xen len)
{
  #define H_gtk_text_buffer_insert "void gtk_text_buffer_insert(GtkTextBuffer* buffer, GtkTextIter* iter, \
gchar* text, gint len)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert", "gint");
  gtk_text_buffer_insert(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gchar_(text), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert_at_cursor(Xen buffer, Xen text, Xen len)
{
  #define H_gtk_text_buffer_insert_at_cursor "void gtk_text_buffer_insert_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_at_cursor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_text_buffer_insert_at_cursor", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_text_buffer_insert_at_cursor", "gint");
  gtk_text_buffer_insert_at_cursor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(text), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert_interactive(Xen buffer, Xen iter, Xen text, Xen len, Xen default_editable)
{
  #define H_gtk_text_buffer_insert_interactive "gboolean gtk_text_buffer_insert_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_interactive", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert_interactive", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert_interactive", "gint");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 5, "gtk_text_buffer_insert_interactive", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_insert_interactive(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), 
                                                              Xen_to_C_gchar_(text), Xen_to_C_gint(len), Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_insert_interactive_at_cursor(Xen buffer, Xen text, Xen len, Xen default_editable)
{
  #define H_gtk_text_buffer_insert_interactive_at_cursor "gboolean gtk_text_buffer_insert_interactive_at_cursor(GtkTextBuffer* buffer, \
gchar* text, gint len, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_interactive_at_cursor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_text_buffer_insert_interactive_at_cursor", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 3, "gtk_text_buffer_insert_interactive_at_cursor", "gint");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 4, "gtk_text_buffer_insert_interactive_at_cursor", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_insert_interactive_at_cursor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(text), 
                                                                        Xen_to_C_gint(len), Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_insert_range(Xen buffer, Xen iter, Xen start, Xen end)
{
  #define H_gtk_text_buffer_insert_range "void gtk_text_buffer_insert_range(GtkTextBuffer* buffer, GtkTextIter* iter, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_range", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_insert_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_insert_range", "GtkTextIter*");
  gtk_text_buffer_insert_range(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextIter_(start), 
                               Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_insert_range_interactive(Xen buffer, Xen iter, Xen start, Xen end, Xen default_editable)
{
  #define H_gtk_text_buffer_insert_range_interactive "gboolean gtk_text_buffer_insert_range_interactive(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextIter* start, GtkTextIter* end, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_range_interactive", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_range_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_insert_range_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_insert_range_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 5, "gtk_text_buffer_insert_range_interactive", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_insert_range_interactive(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), 
                                                                    Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end), 
                                                                    Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_insert_with_tags(Xen buffer, Xen iter, Xen text, Xen len, Xen tags)
{
  #define H_gtk_text_buffer_insert_with_tags "void gtk_text_buffer_insert_with_tags(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_with_tags", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_with_tags", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert_with_tags", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert_with_tags", "gint");
  Xen_check_type(Xen_is_etc(tags), tags, 5, "gtk_text_buffer_insert_with_tags", "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (Xen_is_list(tags)) etc_len = Xen_list_length(tags);
    if (etc_len < 1) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags", 4, tags, "... list too long (max len: 6)");
    p_arg0 = Xen_to_C_GtkTextBuffer_(buffer);
    p_arg1 = Xen_to_C_GtkTextIter_(iter);
    p_arg2 = Xen_to_C_gchar_(text);
    p_arg3 = Xen_to_C_gint(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), NULL); break;
        case 2: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), NULL); break;
        case 4: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), XLT(tags, 3), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), XLT(tags, 3), XLT(tags, 4), NULL); break;
        case 6: gtk_text_buffer_insert_with_tags(p_arg0, p_arg1, p_arg2, p_arg3, XLT(tags, 0), XLT(tags, 1), XLT(tags, 2), XLT(tags, 3), XLT(tags, 4), XLT(tags, 5), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_text_buffer_insert_with_tags_by_name(Xen buffer, Xen iter, Xen text, Xen len, Xen tags)
{
  #define H_gtk_text_buffer_insert_with_tags_by_name "void gtk_text_buffer_insert_with_tags_by_name(GtkTextBuffer* buffer, \
GtkTextIter* iter, gchar* text, gint len, etc tags)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_with_tags_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_with_tags_by_name", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_text_buffer_insert_with_tags_by_name", "gchar*");
  Xen_check_type(Xen_is_gint(len), len, 4, "gtk_text_buffer_insert_with_tags_by_name", "gint");
  Xen_check_type(Xen_is_etc(tags), tags, 5, "gtk_text_buffer_insert_with_tags_by_name", "etc");
  {
    int etc_len = 0;
    GtkTextBuffer* p_arg0;
    GtkTextIter* p_arg1;
    gchar* p_arg2;
    gint p_arg3;
    if (Xen_is_list(tags)) etc_len = Xen_list_length(tags);
    if (etc_len < 1) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_text_buffer_insert_with_tags_by_name", 4, tags, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTextBuffer_(buffer);
    p_arg1 = Xen_to_C_GtkTextIter_(iter);
    p_arg2 = Xen_to_C_gchar_(text);
    p_arg3 = Xen_to_C_gint(len);
    switch (etc_len)
      {
        case 1: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, XLS(tags, 0), NULL); break;
        case 3: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, XLS(tags, 0), XLI(tags, 1), XLS(tags, 2), NULL); break;
        case 5: gtk_text_buffer_insert_with_tags_by_name(p_arg0, p_arg1, p_arg2, p_arg3, XLS(tags, 0), XLI(tags, 1), XLS(tags, 2), XLI(tags, 3), XLS(tags, 4), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_text_buffer_delete(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_delete "void gtk_text_buffer_delete(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_delete", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_delete", "GtkTextIter*");
  gtk_text_buffer_delete(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_delete_interactive(Xen buffer, Xen start_iter, Xen end_iter, Xen default_editable)
{
  #define H_gtk_text_buffer_delete_interactive "gboolean gtk_text_buffer_delete_interactive(GtkTextBuffer* buffer, \
GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_interactive", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start_iter), start_iter, 2, "gtk_text_buffer_delete_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end_iter), end_iter, 3, "gtk_text_buffer_delete_interactive", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 4, "gtk_text_buffer_delete_interactive", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_delete_interactive(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start_iter), 
                                                              Xen_to_C_GtkTextIter_(end_iter), Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_get_text(Xen buffer, Xen start, Xen end, Xen include_hidden_chars)
{
  #define H_gtk_text_buffer_get_text "gchar* gtk_text_buffer_get_text(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_text", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_text", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_text", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(include_hidden_chars), include_hidden_chars, 4, "gtk_text_buffer_get_text", "gboolean");
  {
   gchar* result;
   Xen rtn;
   result = gtk_text_buffer_get_text(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), 
                                                                       Xen_to_C_GtkTextIter_(end), Xen_to_C_gboolean(include_hidden_chars));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_text_buffer_get_slice(Xen buffer, Xen start, Xen end, Xen include_hidden_chars)
{
  #define H_gtk_text_buffer_get_slice "gchar* gtk_text_buffer_get_slice(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end, gboolean include_hidden_chars)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_slice", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(include_hidden_chars), include_hidden_chars, 4, "gtk_text_buffer_get_slice", "gboolean");
  {
   gchar* result;
   Xen rtn;
   result = gtk_text_buffer_get_slice(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), 
                                                                        Xen_to_C_GtkTextIter_(end), Xen_to_C_gboolean(include_hidden_chars));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_text_buffer_insert_child_anchor(Xen buffer, Xen iter, Xen anchor)
{
  #define H_gtk_text_buffer_insert_child_anchor "void gtk_text_buffer_insert_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_insert_child_anchor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_insert_child_anchor", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 3, "gtk_text_buffer_insert_child_anchor", "GtkTextChildAnchor*");
  gtk_text_buffer_insert_child_anchor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextChildAnchor_(anchor));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_create_child_anchor(Xen buffer, Xen iter)
{
  #define H_gtk_text_buffer_create_child_anchor "GtkTextChildAnchor* gtk_text_buffer_create_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_create_child_anchor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_create_child_anchor", "GtkTextIter*");
  return(C_to_Xen_GtkTextChildAnchor_(gtk_text_buffer_create_child_anchor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_buffer_create_mark(Xen buffer, Xen mark_name, Xen where, Xen left_gravity)
{
  #define H_gtk_text_buffer_create_mark "GtkTextMark* gtk_text_buffer_create_mark(GtkTextBuffer* buffer, \
gchar* mark_name, GtkTextIter* where, gboolean left_gravity)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_create_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(mark_name), mark_name, 2, "gtk_text_buffer_create_mark", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_create_mark", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(left_gravity), left_gravity, 4, "gtk_text_buffer_create_mark", "gboolean");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_create_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(mark_name), Xen_to_C_GtkTextIter_(where), 
                                                           Xen_to_C_gboolean(left_gravity))));
}

static Xen gxg_gtk_text_buffer_move_mark(Xen buffer, Xen mark, Xen where)
{
  #define H_gtk_text_buffer_move_mark "void gtk_text_buffer_move_mark(GtkTextBuffer* buffer, GtkTextMark* mark, \
GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_move_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_buffer_move_mark", "GtkTextMark*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_move_mark", "GtkTextIter*");
  gtk_text_buffer_move_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextMark_(mark), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_delete_mark(Xen buffer, Xen mark)
{
  #define H_gtk_text_buffer_delete_mark "void gtk_text_buffer_delete_mark(GtkTextBuffer* buffer, GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_buffer_delete_mark", "GtkTextMark*");
  gtk_text_buffer_delete_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextMark_(mark));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_mark(Xen buffer, Xen name)
{
  #define H_gtk_text_buffer_get_mark "GtkTextMark* gtk_text_buffer_get_mark(GtkTextBuffer* buffer, gchar* name)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_get_mark", "gchar*");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_get_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name))));
}

static Xen gxg_gtk_text_buffer_move_mark_by_name(Xen buffer, Xen name, Xen where)
{
  #define H_gtk_text_buffer_move_mark_by_name "void gtk_text_buffer_move_mark_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_move_mark_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_move_mark_by_name", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 3, "gtk_text_buffer_move_mark_by_name", "GtkTextIter*");
  gtk_text_buffer_move_mark_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_delete_mark_by_name(Xen buffer, Xen name)
{
  #define H_gtk_text_buffer_delete_mark_by_name "void gtk_text_buffer_delete_mark_by_name(GtkTextBuffer* buffer, \
gchar* name)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_mark_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_delete_mark_by_name", "gchar*");
  gtk_text_buffer_delete_mark_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_insert(Xen buffer)
{
  #define H_gtk_text_buffer_get_insert "GtkTextMark* gtk_text_buffer_get_insert(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_insert", "GtkTextBuffer*");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_get_insert(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_get_selection_bound(Xen buffer)
{
  #define H_gtk_text_buffer_get_selection_bound "GtkTextMark* gtk_text_buffer_get_selection_bound(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_selection_bound", "GtkTextBuffer*");
  return(C_to_Xen_GtkTextMark_(gtk_text_buffer_get_selection_bound(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_place_cursor(Xen buffer, Xen where)
{
  #define H_gtk_text_buffer_place_cursor "void gtk_text_buffer_place_cursor(GtkTextBuffer* buffer, GtkTextIter* where)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_place_cursor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(where), where, 2, "gtk_text_buffer_place_cursor", "GtkTextIter*");
  gtk_text_buffer_place_cursor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(where));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_apply_tag(Xen buffer, Xen tag, Xen start, Xen end)
{
  #define H_gtk_text_buffer_apply_tag "void gtk_text_buffer_apply_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_apply_tag", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_buffer_apply_tag", "GtkTextTag*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_apply_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_apply_tag", "GtkTextIter*");
  gtk_text_buffer_apply_tag(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextTag_(tag), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_remove_tag(Xen buffer, Xen tag, Xen start, Xen end)
{
  #define H_gtk_text_buffer_remove_tag "void gtk_text_buffer_remove_tag(GtkTextBuffer* buffer, GtkTextTag* tag, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_remove_tag", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_buffer_remove_tag", "GtkTextTag*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_remove_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_remove_tag", "GtkTextIter*");
  gtk_text_buffer_remove_tag(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextTag_(tag), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_apply_tag_by_name(Xen buffer, Xen name, Xen start, Xen end)
{
  #define H_gtk_text_buffer_apply_tag_by_name "void gtk_text_buffer_apply_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_apply_tag_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_apply_tag_by_name", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_apply_tag_by_name", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_apply_tag_by_name", "GtkTextIter*");
  gtk_text_buffer_apply_tag_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name), Xen_to_C_GtkTextIter_(start), 
                                    Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_remove_tag_by_name(Xen buffer, Xen name, Xen start, Xen end)
{
  #define H_gtk_text_buffer_remove_tag_by_name "void gtk_text_buffer_remove_tag_by_name(GtkTextBuffer* buffer, \
gchar* name, GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_remove_tag_by_name", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_buffer_remove_tag_by_name", "gchar*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 3, "gtk_text_buffer_remove_tag_by_name", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 4, "gtk_text_buffer_remove_tag_by_name", "GtkTextIter*");
  gtk_text_buffer_remove_tag_by_name(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gchar_(name), Xen_to_C_GtkTextIter_(start), 
                                     Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_remove_all_tags(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_remove_all_tags "void gtk_text_buffer_remove_all_tags(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_remove_all_tags", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_remove_all_tags", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_remove_all_tags", "GtkTextIter*");
  gtk_text_buffer_remove_all_tags(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_create_tag(Xen buffer, Xen tag_name, Xen tags)
{
  #define H_gtk_text_buffer_create_tag "GtkTextTag* gtk_text_buffer_create_tag(GtkTextBuffer* buffer, \
gchar* tag_name, etc tags)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_create_tag", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gchar_(tag_name), tag_name, 2, "gtk_text_buffer_create_tag", "gchar*");
  if (!Xen_is_bound(tags)) tags = Xen_false; 
  else Xen_check_type(Xen_is_etc(tags), tags, 3, "gtk_text_buffer_create_tag", "etc");
  {
    int etc_len = 0;
    GtkTextTag* result = NULL;
    GtkTextBuffer* p_arg0;
    gchar* p_arg1;
    if (Xen_is_list(tags)) etc_len = Xen_list_length(tags);
    if (etc_len > 6) Xen_out_of_range_error("gtk_text_buffer_create_tag", 2, tags, "... list too long (max len: 6)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_text_buffer_create_tag", 2, tags, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTextBuffer_(buffer);
    p_arg1 = Xen_to_C_gchar_(tag_name);
    switch (etc_len)
      {
        case 0: result = gtk_text_buffer_create_tag(p_arg0, p_arg1, NULL); break;
        case 2: result = gtk_text_buffer_create_tag(p_arg0, p_arg1, XLS(tags, 0), XLA(tags, 1), NULL); break;
        case 4: result = gtk_text_buffer_create_tag(p_arg0, p_arg1, XLS(tags, 0), XLA(tags, 1), XLS(tags, 2), XLA(tags, 3), NULL); break;
        case 6: result = gtk_text_buffer_create_tag(p_arg0, p_arg1, XLS(tags, 0), XLA(tags, 1), XLS(tags, 2), XLA(tags, 3), XLS(tags, 4), XLA(tags, 5), NULL); break;
      }
    return(C_to_Xen_GtkTextTag_(result));
  }
}

static Xen gxg_gtk_text_buffer_get_iter_at_line_offset(Xen buffer, Xen iter, Xen line_number, Xen char_offset)
{
  #define H_gtk_text_buffer_get_iter_at_line_offset "void gtk_text_buffer_get_iter_at_line_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint char_offset)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_line_offset", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_line_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 3, "gtk_text_buffer_get_iter_at_line_offset", "gint");
  Xen_check_type(Xen_is_gint(char_offset), char_offset, 4, "gtk_text_buffer_get_iter_at_line_offset", "gint");
  gtk_text_buffer_get_iter_at_line_offset(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number), 
                                          Xen_to_C_gint(char_offset));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_line_index(Xen buffer, Xen iter, Xen line_number, Xen byte_index)
{
  #define H_gtk_text_buffer_get_iter_at_line_index "void gtk_text_buffer_get_iter_at_line_index(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number, gint byte_index)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_line_index", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_line_index", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 3, "gtk_text_buffer_get_iter_at_line_index", "gint");
  Xen_check_type(Xen_is_gint(byte_index), byte_index, 4, "gtk_text_buffer_get_iter_at_line_index", "gint");
  gtk_text_buffer_get_iter_at_line_index(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number), 
                                         Xen_to_C_gint(byte_index));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_offset(Xen buffer, Xen iter, Xen char_offset)
{
  #define H_gtk_text_buffer_get_iter_at_offset "void gtk_text_buffer_get_iter_at_offset(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint char_offset)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_offset", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_offset), char_offset, 3, "gtk_text_buffer_get_iter_at_offset", "gint");
  gtk_text_buffer_get_iter_at_offset(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_offset));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_line(Xen buffer, Xen iter, Xen line_number)
{
  #define H_gtk_text_buffer_get_iter_at_line "void gtk_text_buffer_get_iter_at_line(GtkTextBuffer* buffer, \
GtkTextIter* iter, gint line_number)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_line", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_line", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 3, "gtk_text_buffer_get_iter_at_line", "gint");
  gtk_text_buffer_get_iter_at_line(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_start_iter(Xen buffer, Xen iter)
{
  #define H_gtk_text_buffer_get_start_iter "void gtk_text_buffer_get_start_iter(GtkTextBuffer* buffer, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_start_iter", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_start_iter", "GtkTextIter*");
  gtk_text_buffer_get_start_iter(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_end_iter(Xen buffer, Xen iter)
{
  #define H_gtk_text_buffer_get_end_iter "void gtk_text_buffer_get_end_iter(GtkTextBuffer* buffer, GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_end_iter", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_end_iter", "GtkTextIter*");
  gtk_text_buffer_get_end_iter(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_bounds(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_get_bounds "void gtk_text_buffer_get_bounds(GtkTextBuffer* buffer, GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_bounds", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_bounds", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_bounds", "GtkTextIter*");
  gtk_text_buffer_get_bounds(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_mark(Xen buffer, Xen iter, Xen mark)
{
  #define H_gtk_text_buffer_get_iter_at_mark "void gtk_text_buffer_get_iter_at_mark(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_mark", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_mark", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 3, "gtk_text_buffer_get_iter_at_mark", "GtkTextMark*");
  gtk_text_buffer_get_iter_at_mark(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextMark_(mark));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_iter_at_child_anchor(Xen buffer, Xen iter, Xen anchor)
{
  #define H_gtk_text_buffer_get_iter_at_child_anchor "void gtk_text_buffer_get_iter_at_child_anchor(GtkTextBuffer* buffer, \
GtkTextIter* iter, GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_iter_at_child_anchor", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_get_iter_at_child_anchor", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 3, "gtk_text_buffer_get_iter_at_child_anchor", "GtkTextChildAnchor*");
  gtk_text_buffer_get_iter_at_child_anchor(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextChildAnchor_(anchor));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_modified(Xen buffer)
{
  #define H_gtk_text_buffer_get_modified "gboolean gtk_text_buffer_get_modified(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_modified", "GtkTextBuffer*");
  return(C_to_Xen_gboolean(gtk_text_buffer_get_modified(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_buffer_set_modified(Xen buffer, Xen setting)
{
  #define H_gtk_text_buffer_set_modified "void gtk_text_buffer_set_modified(GtkTextBuffer* buffer, gboolean setting)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_set_modified", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_buffer_set_modified", "gboolean");
  gtk_text_buffer_set_modified(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_get_selection_bounds(Xen buffer, Xen start, Xen end)
{
  #define H_gtk_text_buffer_get_selection_bounds "gboolean gtk_text_buffer_get_selection_bounds(GtkTextBuffer* buffer, \
GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_get_selection_bounds", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_buffer_get_selection_bounds", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_buffer_get_selection_bounds", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_buffer_get_selection_bounds(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(start), 
                                                                Xen_to_C_GtkTextIter_(end))));
}

static Xen gxg_gtk_text_buffer_delete_selection(Xen buffer, Xen interactive, Xen default_editable)
{
  #define H_gtk_text_buffer_delete_selection "gboolean gtk_text_buffer_delete_selection(GtkTextBuffer* buffer, \
gboolean interactive, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_delete_selection", "GtkTextBuffer*");
  Xen_check_type(Xen_is_gboolean(interactive), interactive, 2, "gtk_text_buffer_delete_selection", "gboolean");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 3, "gtk_text_buffer_delete_selection", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_delete_selection(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_gboolean(interactive), 
                                                            Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_text_buffer_begin_user_action(Xen buffer)
{
  #define H_gtk_text_buffer_begin_user_action "void gtk_text_buffer_begin_user_action(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_begin_user_action", "GtkTextBuffer*");
  gtk_text_buffer_begin_user_action(Xen_to_C_GtkTextBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_end_user_action(Xen buffer)
{
  #define H_gtk_text_buffer_end_user_action "void gtk_text_buffer_end_user_action(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_end_user_action", "GtkTextBuffer*");
  gtk_text_buffer_end_user_action(Xen_to_C_GtkTextBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_text_child_anchor_new(void)
{
  #define H_gtk_text_child_anchor_new "GtkTextChildAnchor* gtk_text_child_anchor_new( void)"
  return(C_to_Xen_GtkTextChildAnchor_(gtk_text_child_anchor_new()));
}

static Xen gxg_gtk_text_child_anchor_get_widgets(Xen anchor)
{
  #define H_gtk_text_child_anchor_get_widgets "GList* gtk_text_child_anchor_get_widgets(GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 1, "gtk_text_child_anchor_get_widgets", "GtkTextChildAnchor*");
  return(C_to_Xen_GList_(gtk_text_child_anchor_get_widgets(Xen_to_C_GtkTextChildAnchor_(anchor))));
}

static Xen gxg_gtk_text_child_anchor_get_deleted(Xen anchor)
{
  #define H_gtk_text_child_anchor_get_deleted "gboolean gtk_text_child_anchor_get_deleted(GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 1, "gtk_text_child_anchor_get_deleted", "GtkTextChildAnchor*");
  return(C_to_Xen_gboolean(gtk_text_child_anchor_get_deleted(Xen_to_C_GtkTextChildAnchor_(anchor))));
}

static Xen gxg_gtk_text_iter_get_buffer(Xen iter)
{
  #define H_gtk_text_iter_get_buffer "GtkTextBuffer* gtk_text_iter_get_buffer(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_buffer", "GtkTextIter*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_iter_get_buffer(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_copy(Xen iter)
{
  #define H_gtk_text_iter_copy "GtkTextIter* gtk_text_iter_copy(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_copy", "GtkTextIter*");
  return(C_to_Xen_GtkTextIter_(gtk_text_iter_copy(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_free(Xen iter)
{
  #define H_gtk_text_iter_free "void gtk_text_iter_free(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_free", "GtkTextIter*");
  gtk_text_iter_free(Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_get_offset(Xen iter)
{
  #define H_gtk_text_iter_get_offset "gint gtk_text_iter_get_offset(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_offset", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_offset(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_line(Xen iter)
{
  #define H_gtk_text_iter_get_line "gint gtk_text_iter_get_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_line", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_line_offset(Xen iter)
{
  #define H_gtk_text_iter_get_line_offset "gint gtk_text_iter_get_line_offset(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_line_offset", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_line_offset(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_line_index(Xen iter)
{
  #define H_gtk_text_iter_get_line_index "gint gtk_text_iter_get_line_index(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_line_index", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_line_index(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_visible_line_offset(Xen iter)
{
  #define H_gtk_text_iter_get_visible_line_offset "gint gtk_text_iter_get_visible_line_offset(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_visible_line_offset", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_visible_line_offset(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_visible_line_index(Xen iter)
{
  #define H_gtk_text_iter_get_visible_line_index "gint gtk_text_iter_get_visible_line_index(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_visible_line_index", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_visible_line_index(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_char(Xen iter)
{
  #define H_gtk_text_iter_get_char "gunichar gtk_text_iter_get_char(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_char", "GtkTextIter*");
  return(C_to_Xen_gunichar(gtk_text_iter_get_char(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_slice(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_slice "gchar* gtk_text_iter_get_slice(GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_slice", "GtkTextIter*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_text_iter_get_slice(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_text(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_text "gchar* gtk_text_iter_get_text(GtkTextIter* start, GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_text", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_text", "GtkTextIter*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_text_iter_get_text(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_visible_slice(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_visible_slice "gchar* gtk_text_iter_get_visible_slice(GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_visible_slice", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_visible_slice", "GtkTextIter*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_text_iter_get_visible_slice(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_visible_text(Xen start, Xen end)
{
  #define H_gtk_text_iter_get_visible_text "gchar* gtk_text_iter_get_visible_text(GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 1, "gtk_text_iter_get_visible_text", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 2, "gtk_text_iter_get_visible_text", "GtkTextIter*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_text_iter_get_visible_text(Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_text_iter_get_marks(Xen iter)
{
  #define H_gtk_text_iter_get_marks "GSList* gtk_text_iter_get_marks(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_marks", "GtkTextIter*");
  return(C_to_Xen_GSList_(gtk_text_iter_get_marks(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_child_anchor(Xen iter)
{
  #define H_gtk_text_iter_get_child_anchor "GtkTextChildAnchor* gtk_text_iter_get_child_anchor(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_child_anchor", "GtkTextIter*");
  return(C_to_Xen_GtkTextChildAnchor_(gtk_text_iter_get_child_anchor(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_toggled_tags(Xen iter, Xen toggled_on)
{
  #define H_gtk_text_iter_get_toggled_tags "GSList* gtk_text_iter_get_toggled_tags(GtkTextIter* iter, \
gboolean toggled_on)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_toggled_tags", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(toggled_on), toggled_on, 2, "gtk_text_iter_get_toggled_tags", "gboolean");
  return(C_to_Xen_GSList_(gtk_text_iter_get_toggled_tags(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(toggled_on))));
}

static Xen gxg_gtk_text_iter_ends_tag(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_ends_tag "gboolean gtk_text_iter_ends_tag(GtkTextIter* iter, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_ends_tag", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_tag(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_toggles_tag(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_toggles_tag "gboolean gtk_text_iter_toggles_tag(GtkTextIter* iter, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_toggles_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_toggles_tag", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_toggles_tag(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_has_tag(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_has_tag "gboolean gtk_text_iter_has_tag(GtkTextIter* iter, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_has_tag", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_iter_has_tag", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_has_tag(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_get_tags(Xen iter)
{
  #define H_gtk_text_iter_get_tags "GSList* gtk_text_iter_get_tags(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_tags", "GtkTextIter*");
  return(C_to_Xen_GSList_(gtk_text_iter_get_tags(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_editable(Xen iter, Xen default_setting)
{
  #define H_gtk_text_iter_editable "gboolean gtk_text_iter_editable(GtkTextIter* iter, gboolean default_setting)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_editable", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_setting), default_setting, 2, "gtk_text_iter_editable", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_iter_editable(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(default_setting))));
}

static Xen gxg_gtk_text_iter_can_insert(Xen iter, Xen default_editability)
{
  #define H_gtk_text_iter_can_insert "gboolean gtk_text_iter_can_insert(GtkTextIter* iter, gboolean default_editability)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_can_insert", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(default_editability), default_editability, 2, "gtk_text_iter_can_insert", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_iter_can_insert(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(default_editability))));
}

static Xen gxg_gtk_text_iter_starts_word(Xen iter)
{
  #define H_gtk_text_iter_starts_word "gboolean gtk_text_iter_starts_word(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_starts_word", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_starts_word(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_ends_word(Xen iter)
{
  #define H_gtk_text_iter_ends_word "gboolean gtk_text_iter_ends_word(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_word", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_word(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_inside_word(Xen iter)
{
  #define H_gtk_text_iter_inside_word "gboolean gtk_text_iter_inside_word(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_inside_word", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_inside_word(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_starts_sentence(Xen iter)
{
  #define H_gtk_text_iter_starts_sentence "gboolean gtk_text_iter_starts_sentence(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_starts_sentence", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_starts_sentence(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_ends_sentence(Xen iter)
{
  #define H_gtk_text_iter_ends_sentence "gboolean gtk_text_iter_ends_sentence(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_sentence", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_sentence(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_inside_sentence(Xen iter)
{
  #define H_gtk_text_iter_inside_sentence "gboolean gtk_text_iter_inside_sentence(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_inside_sentence", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_inside_sentence(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_starts_line(Xen iter)
{
  #define H_gtk_text_iter_starts_line "gboolean gtk_text_iter_starts_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_starts_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_starts_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_ends_line(Xen iter)
{
  #define H_gtk_text_iter_ends_line "gboolean gtk_text_iter_ends_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_ends_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_ends_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_is_cursor_position(Xen iter)
{
  #define H_gtk_text_iter_is_cursor_position "gboolean gtk_text_iter_is_cursor_position(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_is_cursor_position", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_is_cursor_position(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_chars_in_line(Xen iter)
{
  #define H_gtk_text_iter_get_chars_in_line "gint gtk_text_iter_get_chars_in_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_chars_in_line", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_chars_in_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_bytes_in_line(Xen iter)
{
  #define H_gtk_text_iter_get_bytes_in_line "gint gtk_text_iter_get_bytes_in_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_bytes_in_line", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_get_bytes_in_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_get_language(Xen iter)
{
  #define H_gtk_text_iter_get_language "PangoLanguage* gtk_text_iter_get_language(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_get_language", "GtkTextIter*");
  return(C_to_Xen_PangoLanguage_(gtk_text_iter_get_language(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_is_end(Xen iter)
{
  #define H_gtk_text_iter_is_end "gboolean gtk_text_iter_is_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_is_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_is_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_is_start(Xen iter)
{
  #define H_gtk_text_iter_is_start "gboolean gtk_text_iter_is_start(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_is_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_is_start(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_char(Xen iter)
{
  #define H_gtk_text_iter_forward_char "gboolean gtk_text_iter_forward_char(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_char", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_char(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_char(Xen iter)
{
  #define H_gtk_text_iter_backward_char "gboolean gtk_text_iter_backward_char(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_char", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_char(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_chars(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_chars "gboolean gtk_text_iter_forward_chars(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_chars", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_chars", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_chars(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_chars(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_chars "gboolean gtk_text_iter_backward_chars(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_chars", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_chars", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_chars(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_line(Xen iter)
{
  #define H_gtk_text_iter_forward_line "gboolean gtk_text_iter_forward_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_line(Xen iter)
{
  #define H_gtk_text_iter_backward_line "gboolean gtk_text_iter_backward_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_lines "gboolean gtk_text_iter_forward_lines(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_lines "gboolean gtk_text_iter_backward_lines(GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_word_end(Xen iter)
{
  #define H_gtk_text_iter_forward_word_end "gboolean gtk_text_iter_forward_word_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_word_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_word_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_word_start(Xen iter)
{
  #define H_gtk_text_iter_backward_word_start "gboolean gtk_text_iter_backward_word_start(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_word_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_word_start(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_word_ends(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_word_ends "gboolean gtk_text_iter_forward_word_ends(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_word_ends", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_word_ends", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_word_ends(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_word_starts(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_word_starts "gboolean gtk_text_iter_backward_word_starts(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_word_starts", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_word_starts", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_word_starts(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_sentence_end(Xen iter)
{
  #define H_gtk_text_iter_forward_sentence_end "gboolean gtk_text_iter_forward_sentence_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_sentence_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_sentence_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_sentence_start(Xen iter)
{
  #define H_gtk_text_iter_backward_sentence_start "gboolean gtk_text_iter_backward_sentence_start(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_sentence_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_sentence_start(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_sentence_ends(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_sentence_ends "gboolean gtk_text_iter_forward_sentence_ends(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_sentence_ends", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_sentence_ends", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_sentence_ends(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_sentence_starts(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_sentence_starts "gboolean gtk_text_iter_backward_sentence_starts(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_sentence_starts", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_sentence_starts", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_sentence_starts(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_forward_cursor_position(Xen iter)
{
  #define H_gtk_text_iter_forward_cursor_position "gboolean gtk_text_iter_forward_cursor_position(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_cursor_position", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_cursor_position(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_cursor_position(Xen iter)
{
  #define H_gtk_text_iter_backward_cursor_position "gboolean gtk_text_iter_backward_cursor_position(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_cursor_position", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_cursor_position(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_cursor_positions(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_cursor_positions "gboolean gtk_text_iter_forward_cursor_positions(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_cursor_positions", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_cursor_positions", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_cursor_positions(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_cursor_positions(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_cursor_positions "gboolean gtk_text_iter_backward_cursor_positions(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_cursor_positions", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_cursor_positions", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_cursor_positions(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_set_offset(Xen iter, Xen char_offset)
{
  #define H_gtk_text_iter_set_offset "void gtk_text_iter_set_offset(GtkTextIter* iter, gint char_offset)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_offset), char_offset, 2, "gtk_text_iter_set_offset", "gint");
  gtk_text_iter_set_offset(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_offset));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_line(Xen iter, Xen line_number)
{
  #define H_gtk_text_iter_set_line "void gtk_text_iter_set_line(GtkTextIter* iter, gint line_number)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_line", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(line_number), line_number, 2, "gtk_text_iter_set_line", "gint");
  gtk_text_iter_set_line(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(line_number));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_line_offset(Xen iter, Xen char_on_line)
{
  #define H_gtk_text_iter_set_line_offset "void gtk_text_iter_set_line_offset(GtkTextIter* iter, gint char_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_line_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_on_line), char_on_line, 2, "gtk_text_iter_set_line_offset", "gint");
  gtk_text_iter_set_line_offset(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_line_index(Xen iter, Xen byte_on_line)
{
  #define H_gtk_text_iter_set_line_index "void gtk_text_iter_set_line_index(GtkTextIter* iter, gint byte_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_line_index", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(byte_on_line), byte_on_line, 2, "gtk_text_iter_set_line_index", "gint");
  gtk_text_iter_set_line_index(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(byte_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_to_end(Xen iter)
{
  #define H_gtk_text_iter_forward_to_end "void gtk_text_iter_forward_to_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_to_end", "GtkTextIter*");
  gtk_text_iter_forward_to_end(Xen_to_C_GtkTextIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_to_line_end(Xen iter)
{
  #define H_gtk_text_iter_forward_to_line_end "gboolean gtk_text_iter_forward_to_line_end(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_to_line_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_to_line_end(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_set_visible_line_offset(Xen iter, Xen char_on_line)
{
  #define H_gtk_text_iter_set_visible_line_offset "void gtk_text_iter_set_visible_line_offset(GtkTextIter* iter, \
gint char_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_visible_line_offset", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(char_on_line), char_on_line, 2, "gtk_text_iter_set_visible_line_offset", "gint");
  gtk_text_iter_set_visible_line_offset(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(char_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_set_visible_line_index(Xen iter, Xen byte_on_line)
{
  #define H_gtk_text_iter_set_visible_line_index "void gtk_text_iter_set_visible_line_index(GtkTextIter* iter, \
gint byte_on_line)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_set_visible_line_index", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(byte_on_line), byte_on_line, 2, "gtk_text_iter_set_visible_line_index", "gint");
  gtk_text_iter_set_visible_line_index(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(byte_on_line));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_to_tag_toggle(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_forward_to_tag_toggle "gboolean gtk_text_iter_forward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_to_tag_toggle", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_forward_to_tag_toggle", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_to_tag_toggle(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_backward_to_tag_toggle(Xen iter, Xen tag)
{
  #define H_gtk_text_iter_backward_to_tag_toggle "gboolean gtk_text_iter_backward_to_tag_toggle(GtkTextIter* iter, \
GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_to_tag_toggle", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextTag_(tag) || Xen_is_false(tag), tag, 2, "gtk_text_iter_backward_to_tag_toggle", "GtkTextTag*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_to_tag_toggle(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_iter_forward_find_char(Xen iter, Xen pred, Xen func_info, Xen limit)
{
  #define H_gtk_text_iter_forward_find_char "gboolean gtk_text_iter_forward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_find_char", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextCharPredicate(pred), pred, 2, "gtk_text_iter_forward_find_char", "GtkTextCharPredicate");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_text_iter_forward_find_char", "lambda_data");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 4, "gtk_text_iter_forward_find_char", "GtkTextIter*");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_gboolean(gtk_text_iter_forward_find_char(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextCharPredicate(pred), 
                                                               Xen_to_C_lambda_data(func_info), Xen_to_C_GtkTextIter_(limit)));
    xm_unprotect_at(loc);
    return(result);
   }
}

static Xen gxg_gtk_text_iter_backward_find_char(Xen iter, Xen pred, Xen func_info, Xen limit)
{
  #define H_gtk_text_iter_backward_find_char "gboolean gtk_text_iter_backward_find_char(GtkTextIter* iter, \
GtkTextCharPredicate pred, lambda_data func_info, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_find_char", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextCharPredicate(pred), pred, 2, "gtk_text_iter_backward_find_char", "GtkTextCharPredicate");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_text_iter_backward_find_char", "lambda_data");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 4, "gtk_text_iter_backward_find_char", "GtkTextIter*");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(Xen_false, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_gboolean(gtk_text_iter_backward_find_char(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextCharPredicate(pred), 
                                                                Xen_to_C_lambda_data(func_info), Xen_to_C_GtkTextIter_(limit)));
    xm_unprotect_at(loc);
    return(result);
   }
}

static Xen gxg_gtk_text_iter_forward_search(Xen iter, Xen str, Xen flags, Xen match_start, Xen match_end, Xen limit)
{
  #define H_gtk_text_iter_forward_search "gboolean gtk_text_iter_forward_search(GtkTextIter* iter, gchar* str, \
GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_text_iter_forward_search", "gchar*");
  Xen_check_type(Xen_is_GtkTextSearchFlags(flags), flags, 3, "gtk_text_iter_forward_search", "GtkTextSearchFlags");
  Xen_check_type(Xen_is_GtkTextIter_(match_start) || Xen_is_false(match_start), match_start, 4, "gtk_text_iter_forward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(match_end) || Xen_is_false(match_end), match_end, 5, "gtk_text_iter_forward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 6, "gtk_text_iter_forward_search", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_search(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gchar_(str), Xen_to_C_GtkTextSearchFlags(flags), 
                                                        Xen_to_C_GtkTextIter_(match_start), Xen_to_C_GtkTextIter_(match_end), 
                                                        Xen_to_C_GtkTextIter_(limit))));
}

static Xen gxg_gtk_text_iter_backward_search(Xen iter, Xen str, Xen flags, Xen match_start, Xen match_end, Xen limit)
{
  #define H_gtk_text_iter_backward_search "gboolean gtk_text_iter_backward_search(GtkTextIter* iter, \
gchar* str, GtkTextSearchFlags flags, GtkTextIter* match_start, GtkTextIter* match_end, GtkTextIter* limit)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_gchar_(str), str, 2, "gtk_text_iter_backward_search", "gchar*");
  Xen_check_type(Xen_is_GtkTextSearchFlags(flags), flags, 3, "gtk_text_iter_backward_search", "GtkTextSearchFlags");
  Xen_check_type(Xen_is_GtkTextIter_(match_start) || Xen_is_false(match_start), match_start, 4, "gtk_text_iter_backward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(match_end) || Xen_is_false(match_end), match_end, 5, "gtk_text_iter_backward_search", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(limit) || Xen_is_false(limit), limit, 6, "gtk_text_iter_backward_search", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_search(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gchar_(str), Xen_to_C_GtkTextSearchFlags(flags), 
                                                         Xen_to_C_GtkTextIter_(match_start), Xen_to_C_GtkTextIter_(match_end), 
                                                         Xen_to_C_GtkTextIter_(limit))));
}

static Xen gxg_gtk_text_iter_equal(Xen lhs, Xen rhs)
{
  #define H_gtk_text_iter_equal "gboolean gtk_text_iter_equal(GtkTextIter* lhs, GtkTextIter* rhs)"
  Xen_check_type(Xen_is_GtkTextIter_(lhs), lhs, 1, "gtk_text_iter_equal", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(rhs), rhs, 2, "gtk_text_iter_equal", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_equal(Xen_to_C_GtkTextIter_(lhs), Xen_to_C_GtkTextIter_(rhs))));
}

static Xen gxg_gtk_text_iter_compare(Xen lhs, Xen rhs)
{
  #define H_gtk_text_iter_compare "gint gtk_text_iter_compare(GtkTextIter* lhs, GtkTextIter* rhs)"
  Xen_check_type(Xen_is_GtkTextIter_(lhs), lhs, 1, "gtk_text_iter_compare", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(rhs), rhs, 2, "gtk_text_iter_compare", "GtkTextIter*");
  return(C_to_Xen_gint(gtk_text_iter_compare(Xen_to_C_GtkTextIter_(lhs), Xen_to_C_GtkTextIter_(rhs))));
}

static Xen gxg_gtk_text_iter_in_range(Xen iter, Xen start, Xen end)
{
  #define H_gtk_text_iter_in_range "gboolean gtk_text_iter_in_range(GtkTextIter* iter, GtkTextIter* start, \
GtkTextIter* end)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_in_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(start), start, 2, "gtk_text_iter_in_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(end), end, 3, "gtk_text_iter_in_range", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_in_range(Xen_to_C_GtkTextIter_(iter), Xen_to_C_GtkTextIter_(start), Xen_to_C_GtkTextIter_(end))));
}

static Xen gxg_gtk_text_iter_order(Xen first, Xen second)
{
  #define H_gtk_text_iter_order "void gtk_text_iter_order(GtkTextIter* first, GtkTextIter* second)"
  Xen_check_type(Xen_is_GtkTextIter_(first), first, 1, "gtk_text_iter_order", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(second), second, 2, "gtk_text_iter_order", "GtkTextIter*");
  gtk_text_iter_order(Xen_to_C_GtkTextIter_(first), Xen_to_C_GtkTextIter_(second));
  return(Xen_false);
}

static Xen gxg_gtk_text_mark_set_visible(Xen mark, Xen setting)
{
  #define H_gtk_text_mark_set_visible "void gtk_text_mark_set_visible(GtkTextMark* mark, gboolean setting)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_set_visible", "GtkTextMark*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_mark_set_visible", "gboolean");
  gtk_text_mark_set_visible(Xen_to_C_GtkTextMark_(mark), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_mark_get_visible(Xen mark)
{
  #define H_gtk_text_mark_get_visible "gboolean gtk_text_mark_get_visible(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_visible", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_mark_get_visible(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_name(Xen mark)
{
  #define H_gtk_text_mark_get_name "char* gtk_text_mark_get_name(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_name", "GtkTextMark*");
  return(C_to_Xen_char_(gtk_text_mark_get_name(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_deleted(Xen mark)
{
  #define H_gtk_text_mark_get_deleted "gboolean gtk_text_mark_get_deleted(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_deleted", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_mark_get_deleted(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_buffer(Xen mark)
{
  #define H_gtk_text_mark_get_buffer "GtkTextBuffer* gtk_text_mark_get_buffer(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_buffer", "GtkTextMark*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_mark_get_buffer(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_mark_get_left_gravity(Xen mark)
{
  #define H_gtk_text_mark_get_left_gravity "gboolean gtk_text_mark_get_left_gravity(GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 1, "gtk_text_mark_get_left_gravity", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_mark_get_left_gravity(Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_tag_new(Xen name)
{
  #define H_gtk_text_tag_new "GtkTextTag* gtk_text_tag_new(gchar* name)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "gtk_text_tag_new", "gchar*");
  return(C_to_Xen_GtkTextTag_(gtk_text_tag_new(Xen_to_C_gchar_(name))));
}

static Xen gxg_gtk_text_tag_get_priority(Xen tag)
{
  #define H_gtk_text_tag_get_priority "gint gtk_text_tag_get_priority(GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 1, "gtk_text_tag_get_priority", "GtkTextTag*");
  return(C_to_Xen_gint(gtk_text_tag_get_priority(Xen_to_C_GtkTextTag_(tag))));
}

static Xen gxg_gtk_text_tag_set_priority(Xen tag, Xen priority)
{
  #define H_gtk_text_tag_set_priority "void gtk_text_tag_set_priority(GtkTextTag* tag, gint priority)"
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 1, "gtk_text_tag_set_priority", "GtkTextTag*");
  Xen_check_type(Xen_is_gint(priority), priority, 2, "gtk_text_tag_set_priority", "gint");
  gtk_text_tag_set_priority(Xen_to_C_GtkTextTag_(tag), Xen_to_C_gint(priority));
  return(Xen_false);
}

static Xen gxg_gtk_text_tag_table_new(void)
{
  #define H_gtk_text_tag_table_new "GtkTextTagTable* gtk_text_tag_table_new( void)"
  return(C_to_Xen_GtkTextTagTable_(gtk_text_tag_table_new()));
}

static Xen gxg_gtk_text_tag_table_add(Xen table, Xen tag)
{
  #define H_gtk_text_tag_table_add "void gtk_text_tag_table_add(GtkTextTagTable* table, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_add", "GtkTextTagTable*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_tag_table_add", "GtkTextTag*");
  gtk_text_tag_table_add(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_GtkTextTag_(tag));
  return(Xen_false);
}

static Xen gxg_gtk_text_tag_table_remove(Xen table, Xen tag)
{
  #define H_gtk_text_tag_table_remove "void gtk_text_tag_table_remove(GtkTextTagTable* table, GtkTextTag* tag)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_remove", "GtkTextTagTable*");
  Xen_check_type(Xen_is_GtkTextTag_(tag), tag, 2, "gtk_text_tag_table_remove", "GtkTextTag*");
  gtk_text_tag_table_remove(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_GtkTextTag_(tag));
  return(Xen_false);
}

static Xen gxg_gtk_text_tag_table_lookup(Xen table, Xen name)
{
  #define H_gtk_text_tag_table_lookup "GtkTextTag* gtk_text_tag_table_lookup(GtkTextTagTable* table, \
gchar* name)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_lookup", "GtkTextTagTable*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_text_tag_table_lookup", "gchar*");
  return(C_to_Xen_GtkTextTag_(gtk_text_tag_table_lookup(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_gchar_(name))));
}

static Xen gxg_gtk_text_tag_table_foreach(Xen table, Xen func, Xen func_info)
{
  #define H_gtk_text_tag_table_foreach "void gtk_text_tag_table_foreach(GtkTextTagTable* table, GtkTextTagTableForeach func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_foreach", "GtkTextTagTable*");
  Xen_check_type(Xen_is_GtkTextTagTableForeach(func), func, 2, "gtk_text_tag_table_foreach", "GtkTextTagTableForeach");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_text_tag_table_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_text_tag_table_foreach(Xen_to_C_GtkTextTagTable_(table), Xen_to_C_GtkTextTagTableForeach(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_text_tag_table_get_size(Xen table)
{
  #define H_gtk_text_tag_table_get_size "gint gtk_text_tag_table_get_size(GtkTextTagTable* table)"
  Xen_check_type(Xen_is_GtkTextTagTable_(table), table, 1, "gtk_text_tag_table_get_size", "GtkTextTagTable*");
  return(C_to_Xen_gint(gtk_text_tag_table_get_size(Xen_to_C_GtkTextTagTable_(table))));
}

static Xen gxg_gtk_text_view_new(void)
{
  #define H_gtk_text_view_new "GtkWidget* gtk_text_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_text_view_new()));
}

static Xen gxg_gtk_text_view_new_with_buffer(Xen buffer)
{
  #define H_gtk_text_view_new_with_buffer "GtkWidget* gtk_text_view_new_with_buffer(GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_view_new_with_buffer", "GtkTextBuffer*");
  return(C_to_Xen_GtkWidget_(gtk_text_view_new_with_buffer(Xen_to_C_GtkTextBuffer_(buffer))));
}

static Xen gxg_gtk_text_view_set_buffer(Xen text_view, Xen buffer)
{
  #define H_gtk_text_view_set_buffer "void gtk_text_view_set_buffer(GtkTextView* text_view, GtkTextBuffer* buffer)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_buffer", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 2, "gtk_text_view_set_buffer", "GtkTextBuffer*");
  gtk_text_view_set_buffer(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextBuffer_(buffer));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_buffer(Xen text_view)
{
  #define H_gtk_text_view_get_buffer "GtkTextBuffer* gtk_text_view_get_buffer(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_buffer", "GtkTextView*");
  return(C_to_Xen_GtkTextBuffer_(gtk_text_view_get_buffer(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_scroll_to_iter(Xen text_view, Xen iter, Xen within_margin, Xen use_align, Xen xalign, Xen yalign)
{
  #define H_gtk_text_view_scroll_to_iter "gboolean gtk_text_view_scroll_to_iter(GtkTextView* text_view, \
GtkTextIter* iter, gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_scroll_to_iter", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_scroll_to_iter", "GtkTextIter*");
  Xen_check_type(Xen_is_gdouble(within_margin), within_margin, 3, "gtk_text_view_scroll_to_iter", "gdouble");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 4, "gtk_text_view_scroll_to_iter", "gboolean");
  Xen_check_type(Xen_is_gdouble(xalign), xalign, 5, "gtk_text_view_scroll_to_iter", "gdouble");
  Xen_check_type(Xen_is_gdouble(yalign), yalign, 6, "gtk_text_view_scroll_to_iter", "gdouble");
  return(C_to_Xen_gboolean(gtk_text_view_scroll_to_iter(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gdouble(within_margin), 
                                                        Xen_to_C_gboolean(use_align), Xen_to_C_gdouble(xalign), Xen_to_C_gdouble(yalign))));
}

static Xen gxg_gtk_text_view_scroll_to_mark(Xen text_view, Xen mark, Xen within_margin, Xen use_align, Xen xalign, Xen yalign)
{
  #define H_gtk_text_view_scroll_to_mark "void gtk_text_view_scroll_to_mark(GtkTextView* text_view, GtkTextMark* mark, \
gdouble within_margin, gboolean use_align, gdouble xalign, gdouble yalign)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_scroll_to_mark", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_view_scroll_to_mark", "GtkTextMark*");
  Xen_check_type(Xen_is_gdouble(within_margin), within_margin, 3, "gtk_text_view_scroll_to_mark", "gdouble");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 4, "gtk_text_view_scroll_to_mark", "gboolean");
  Xen_check_type(Xen_is_gdouble(xalign), xalign, 5, "gtk_text_view_scroll_to_mark", "gdouble");
  Xen_check_type(Xen_is_gdouble(yalign), yalign, 6, "gtk_text_view_scroll_to_mark", "gdouble");
  gtk_text_view_scroll_to_mark(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextMark_(mark), Xen_to_C_gdouble(within_margin), 
                               Xen_to_C_gboolean(use_align), Xen_to_C_gdouble(xalign), Xen_to_C_gdouble(yalign));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_scroll_mark_onscreen(Xen text_view, Xen mark)
{
  #define H_gtk_text_view_scroll_mark_onscreen "void gtk_text_view_scroll_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_scroll_mark_onscreen", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_view_scroll_mark_onscreen", "GtkTextMark*");
  gtk_text_view_scroll_mark_onscreen(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextMark_(mark));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_move_mark_onscreen(Xen text_view, Xen mark)
{
  #define H_gtk_text_view_move_mark_onscreen "gboolean gtk_text_view_move_mark_onscreen(GtkTextView* text_view, \
GtkTextMark* mark)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_move_mark_onscreen", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextMark_(mark), mark, 2, "gtk_text_view_move_mark_onscreen", "GtkTextMark*");
  return(C_to_Xen_gboolean(gtk_text_view_move_mark_onscreen(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextMark_(mark))));
}

static Xen gxg_gtk_text_view_place_cursor_onscreen(Xen text_view)
{
  #define H_gtk_text_view_place_cursor_onscreen "gboolean gtk_text_view_place_cursor_onscreen(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_place_cursor_onscreen", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_place_cursor_onscreen(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_get_visible_rect(Xen text_view, Xen visible_rect)
{
  #define H_gtk_text_view_get_visible_rect "void gtk_text_view_get_visible_rect(GtkTextView* text_view, \
GdkRectangle* visible_rect)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_visible_rect", "GtkTextView*");
  Xen_check_type(Xen_is_GdkRectangle_(visible_rect), visible_rect, 2, "gtk_text_view_get_visible_rect", "GdkRectangle*");
  gtk_text_view_get_visible_rect(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GdkRectangle_(visible_rect));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_set_cursor_visible(Xen text_view, Xen setting)
{
  #define H_gtk_text_view_set_cursor_visible "void gtk_text_view_set_cursor_visible(GtkTextView* text_view, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_cursor_visible", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_view_set_cursor_visible", "gboolean");
  gtk_text_view_set_cursor_visible(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_cursor_visible(Xen text_view)
{
  #define H_gtk_text_view_get_cursor_visible "gboolean gtk_text_view_get_cursor_visible(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_cursor_visible", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_cursor_visible(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_get_iter_location(Xen text_view, Xen iter, Xen location)
{
  #define H_gtk_text_view_get_iter_location "void gtk_text_view_get_iter_location(GtkTextView* text_view, \
GtkTextIter* iter, GdkRectangle* location)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_iter_location", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_get_iter_location", "GtkTextIter*");
  Xen_check_type(Xen_is_GdkRectangle_(location), location, 3, "gtk_text_view_get_iter_location", "GdkRectangle*");
  gtk_text_view_get_iter_location(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), Xen_to_C_GdkRectangle_(location));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_line_yrange(Xen text_view, Xen iter, Xen ignore_y, Xen ignore_height)
{
  #define H_gtk_text_view_get_line_yrange "void gtk_text_view_get_line_yrange(GtkTextView* text_view, \
GtkTextIter* iter, gint* [y], gint* [height])"
  gint ref_y;
  gint ref_height;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_line_yrange", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_get_line_yrange", "GtkTextIter*");
  gtk_text_view_get_line_yrange(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), &ref_y, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_y), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_text_view_get_line_at_y(Xen text_view, Xen target_iter, Xen y, Xen ignore_line_top)
{
  #define H_gtk_text_view_get_line_at_y "void gtk_text_view_get_line_at_y(GtkTextView* text_view, GtkTextIter* target_iter, \
gint y, gint* [line_top])"
  gint ref_line_top;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_line_at_y", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(target_iter), target_iter, 2, "gtk_text_view_get_line_at_y", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_text_view_get_line_at_y", "gint");
  gtk_text_view_get_line_at_y(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(target_iter), Xen_to_C_gint(y), &ref_line_top);
  return(Xen_list_1(C_to_Xen_gint(ref_line_top)));
}

static Xen gxg_gtk_text_view_buffer_to_window_coords(Xen text_view, Xen win, Xen buffer_x, Xen buffer_y, Xen ignore_window_x, Xen ignore_window_y)
{
  #define H_gtk_text_view_buffer_to_window_coords "void gtk_text_view_buffer_to_window_coords(GtkTextView* text_view, \
GtkTextWindowType win, gint buffer_x, gint buffer_y, gint* [window_x], gint* [window_y])"
  gint ref_window_x;
  gint ref_window_y;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_buffer_to_window_coords", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextWindowType(win), win, 2, "gtk_text_view_buffer_to_window_coords", "GtkTextWindowType");
  Xen_check_type(Xen_is_gint(buffer_x), buffer_x, 3, "gtk_text_view_buffer_to_window_coords", "gint");
  Xen_check_type(Xen_is_gint(buffer_y), buffer_y, 4, "gtk_text_view_buffer_to_window_coords", "gint");
  gtk_text_view_buffer_to_window_coords(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextWindowType(win), Xen_to_C_gint(buffer_x), 
                                        Xen_to_C_gint(buffer_y), &ref_window_x, &ref_window_y);
  return(Xen_list_2(C_to_Xen_gint(ref_window_x), C_to_Xen_gint(ref_window_y)));
}

static Xen gxg_gtk_text_view_window_to_buffer_coords(Xen text_view, Xen win, Xen window_x, Xen window_y, Xen ignore_buffer_x, Xen ignore_buffer_y)
{
  #define H_gtk_text_view_window_to_buffer_coords "void gtk_text_view_window_to_buffer_coords(GtkTextView* text_view, \
GtkTextWindowType win, gint window_x, gint window_y, gint* [buffer_x], gint* [buffer_y])"
  gint ref_buffer_x;
  gint ref_buffer_y;
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_window_to_buffer_coords", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextWindowType(win), win, 2, "gtk_text_view_window_to_buffer_coords", "GtkTextWindowType");
  Xen_check_type(Xen_is_gint(window_x), window_x, 3, "gtk_text_view_window_to_buffer_coords", "gint");
  Xen_check_type(Xen_is_gint(window_y), window_y, 4, "gtk_text_view_window_to_buffer_coords", "gint");
  gtk_text_view_window_to_buffer_coords(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextWindowType(win), Xen_to_C_gint(window_x), 
                                        Xen_to_C_gint(window_y), &ref_buffer_x, &ref_buffer_y);
  return(Xen_list_2(C_to_Xen_gint(ref_buffer_x), C_to_Xen_gint(ref_buffer_y)));
}

static Xen gxg_gtk_text_view_set_border_window_size(Xen text_view, Xen type, Xen size)
{
  #define H_gtk_text_view_set_border_window_size "void gtk_text_view_set_border_window_size(GtkTextView* text_view, \
GtkTextWindowType type, gint size)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_border_window_size", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextWindowType(type), type, 2, "gtk_text_view_set_border_window_size", "GtkTextWindowType");
  Xen_check_type(Xen_is_gint(size), size, 3, "gtk_text_view_set_border_window_size", "gint");
  gtk_text_view_set_border_window_size(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextWindowType(type), Xen_to_C_gint(size));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_border_window_size(Xen text_view, Xen type)
{
  #define H_gtk_text_view_get_border_window_size "gint gtk_text_view_get_border_window_size(GtkTextView* text_view, \
GtkTextWindowType type)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_border_window_size", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextWindowType(type), type, 2, "gtk_text_view_get_border_window_size", "GtkTextWindowType");
  return(C_to_Xen_gint(gtk_text_view_get_border_window_size(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextWindowType(type))));
}

static Xen gxg_gtk_text_view_forward_display_line(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_forward_display_line "gboolean gtk_text_view_forward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_forward_display_line", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_forward_display_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_forward_display_line(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_backward_display_line(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_backward_display_line "gboolean gtk_text_view_backward_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_backward_display_line", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_backward_display_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_backward_display_line(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_forward_display_line_end(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_forward_display_line_end "gboolean gtk_text_view_forward_display_line_end(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_forward_display_line_end", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_forward_display_line_end", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_forward_display_line_end(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_backward_display_line_start(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_backward_display_line_start "gboolean gtk_text_view_backward_display_line_start(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_backward_display_line_start", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_backward_display_line_start", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_backward_display_line_start(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_starts_display_line(Xen text_view, Xen iter)
{
  #define H_gtk_text_view_starts_display_line "gboolean gtk_text_view_starts_display_line(GtkTextView* text_view, \
GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_starts_display_line", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_starts_display_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_view_starts_display_line(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_view_move_visually(Xen text_view, Xen iter, Xen count)
{
  #define H_gtk_text_view_move_visually "gboolean gtk_text_view_move_visually(GtkTextView* text_view, \
GtkTextIter* iter, gint count)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_move_visually", "GtkTextView*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_view_move_visually", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 3, "gtk_text_view_move_visually", "gint");
  return(C_to_Xen_gboolean(gtk_text_view_move_visually(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_view_add_child_at_anchor(Xen text_view, Xen child, Xen anchor)
{
  #define H_gtk_text_view_add_child_at_anchor "void gtk_text_view_add_child_at_anchor(GtkTextView* text_view, \
GtkWidget* child, GtkTextChildAnchor* anchor)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_add_child_at_anchor", "GtkTextView*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_text_view_add_child_at_anchor", "GtkWidget*");
  Xen_check_type(Xen_is_GtkTextChildAnchor_(anchor), anchor, 3, "gtk_text_view_add_child_at_anchor", "GtkTextChildAnchor*");
  gtk_text_view_add_child_at_anchor(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkTextChildAnchor_(anchor));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_add_child_in_window(Xen text_view, Xen child, Xen which_window, Xen xpos, Xen ypos)
{
  #define H_gtk_text_view_add_child_in_window "void gtk_text_view_add_child_in_window(GtkTextView* text_view, \
GtkWidget* child, GtkTextWindowType which_window, gint xpos, gint ypos)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_add_child_in_window", "GtkTextView*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_text_view_add_child_in_window", "GtkWidget*");
  Xen_check_type(Xen_is_GtkTextWindowType(which_window), which_window, 3, "gtk_text_view_add_child_in_window", "GtkTextWindowType");
  Xen_check_type(Xen_is_gint(xpos), xpos, 4, "gtk_text_view_add_child_in_window", "gint");
  Xen_check_type(Xen_is_gint(ypos), ypos, 5, "gtk_text_view_add_child_in_window", "gint");
  gtk_text_view_add_child_in_window(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkWidget_(child), Xen_to_C_GtkTextWindowType(which_window), 
                                    Xen_to_C_gint(xpos), Xen_to_C_gint(ypos));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_move_child(Xen text_view, Xen child, Xen xpos, Xen ypos)
{
  #define H_gtk_text_view_move_child "void gtk_text_view_move_child(GtkTextView* text_view, GtkWidget* child, \
gint xpos, gint ypos)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_move_child", "GtkTextView*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_text_view_move_child", "GtkWidget*");
  Xen_check_type(Xen_is_gint(xpos), xpos, 3, "gtk_text_view_move_child", "gint");
  Xen_check_type(Xen_is_gint(ypos), ypos, 4, "gtk_text_view_move_child", "gint");
  gtk_text_view_move_child(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkWidget_(child), Xen_to_C_gint(xpos), Xen_to_C_gint(ypos));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_set_wrap_mode(Xen text_view, Xen wrap_mode)
{
  #define H_gtk_text_view_set_wrap_mode "void gtk_text_view_set_wrap_mode(GtkTextView* text_view, GtkWrapMode wrap_mode)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_wrap_mode", "GtkTextView*");
  Xen_check_type(Xen_is_GtkWrapMode(wrap_mode), wrap_mode, 2, "gtk_text_view_set_wrap_mode", "GtkWrapMode");
  gtk_text_view_set_wrap_mode(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkWrapMode(wrap_mode));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_wrap_mode(Xen text_view)
{
  #define H_gtk_text_view_get_wrap_mode "GtkWrapMode gtk_text_view_get_wrap_mode(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_wrap_mode", "GtkTextView*");
  return(C_to_Xen_GtkWrapMode(gtk_text_view_get_wrap_mode(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_editable(Xen text_view, Xen setting)
{
  #define H_gtk_text_view_set_editable "void gtk_text_view_set_editable(GtkTextView* text_view, gboolean setting)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_editable", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_text_view_set_editable", "gboolean");
  gtk_text_view_set_editable(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_editable(Xen text_view)
{
  #define H_gtk_text_view_get_editable "gboolean gtk_text_view_get_editable(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_editable", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_editable(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_pixels_above_lines(Xen text_view, Xen pixels_above_lines)
{
  #define H_gtk_text_view_set_pixels_above_lines "void gtk_text_view_set_pixels_above_lines(GtkTextView* text_view, \
gint pixels_above_lines)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_pixels_above_lines", "GtkTextView*");
  Xen_check_type(Xen_is_gint(pixels_above_lines), pixels_above_lines, 2, "gtk_text_view_set_pixels_above_lines", "gint");
  gtk_text_view_set_pixels_above_lines(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(pixels_above_lines));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_pixels_above_lines(Xen text_view)
{
  #define H_gtk_text_view_get_pixels_above_lines "gint gtk_text_view_get_pixels_above_lines(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_pixels_above_lines", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_pixels_above_lines(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_pixels_below_lines(Xen text_view, Xen pixels_below_lines)
{
  #define H_gtk_text_view_set_pixels_below_lines "void gtk_text_view_set_pixels_below_lines(GtkTextView* text_view, \
gint pixels_below_lines)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_pixels_below_lines", "GtkTextView*");
  Xen_check_type(Xen_is_gint(pixels_below_lines), pixels_below_lines, 2, "gtk_text_view_set_pixels_below_lines", "gint");
  gtk_text_view_set_pixels_below_lines(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(pixels_below_lines));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_pixels_below_lines(Xen text_view)
{
  #define H_gtk_text_view_get_pixels_below_lines "gint gtk_text_view_get_pixels_below_lines(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_pixels_below_lines", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_pixels_below_lines(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_pixels_inside_wrap(Xen text_view, Xen pixels_inside_wrap)
{
  #define H_gtk_text_view_set_pixels_inside_wrap "void gtk_text_view_set_pixels_inside_wrap(GtkTextView* text_view, \
gint pixels_inside_wrap)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_pixels_inside_wrap", "GtkTextView*");
  Xen_check_type(Xen_is_gint(pixels_inside_wrap), pixels_inside_wrap, 2, "gtk_text_view_set_pixels_inside_wrap", "gint");
  gtk_text_view_set_pixels_inside_wrap(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(pixels_inside_wrap));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_pixels_inside_wrap(Xen text_view)
{
  #define H_gtk_text_view_get_pixels_inside_wrap "gint gtk_text_view_get_pixels_inside_wrap(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_pixels_inside_wrap", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_pixels_inside_wrap(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_justification(Xen text_view, Xen justification)
{
  #define H_gtk_text_view_set_justification "void gtk_text_view_set_justification(GtkTextView* text_view, \
GtkJustification justification)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_justification", "GtkTextView*");
  Xen_check_type(Xen_is_GtkJustification(justification), justification, 2, "gtk_text_view_set_justification", "GtkJustification");
  gtk_text_view_set_justification(Xen_to_C_GtkTextView_(text_view), Xen_to_C_GtkJustification(justification));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_justification(Xen text_view)
{
  #define H_gtk_text_view_get_justification "GtkJustification gtk_text_view_get_justification(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_justification", "GtkTextView*");
  return(C_to_Xen_GtkJustification(gtk_text_view_get_justification(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_left_margin(Xen text_view, Xen left_margin)
{
  #define H_gtk_text_view_set_left_margin "void gtk_text_view_set_left_margin(GtkTextView* text_view, \
gint left_margin)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_left_margin", "GtkTextView*");
  Xen_check_type(Xen_is_gint(left_margin), left_margin, 2, "gtk_text_view_set_left_margin", "gint");
  gtk_text_view_set_left_margin(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(left_margin));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_left_margin(Xen text_view)
{
  #define H_gtk_text_view_get_left_margin "gint gtk_text_view_get_left_margin(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_left_margin", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_left_margin(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_right_margin(Xen text_view, Xen right_margin)
{
  #define H_gtk_text_view_set_right_margin "void gtk_text_view_set_right_margin(GtkTextView* text_view, \
gint right_margin)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_right_margin", "GtkTextView*");
  Xen_check_type(Xen_is_gint(right_margin), right_margin, 2, "gtk_text_view_set_right_margin", "gint");
  gtk_text_view_set_right_margin(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(right_margin));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_right_margin(Xen text_view)
{
  #define H_gtk_text_view_get_right_margin "gint gtk_text_view_get_right_margin(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_right_margin", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_right_margin(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_indent(Xen text_view, Xen indent)
{
  #define H_gtk_text_view_set_indent "void gtk_text_view_set_indent(GtkTextView* text_view, gint indent)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_indent", "GtkTextView*");
  Xen_check_type(Xen_is_gint(indent), indent, 2, "gtk_text_view_set_indent", "gint");
  gtk_text_view_set_indent(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gint(indent));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_indent(Xen text_view)
{
  #define H_gtk_text_view_get_indent "gint gtk_text_view_get_indent(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_indent", "GtkTextView*");
  return(C_to_Xen_gint(gtk_text_view_get_indent(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_tabs(Xen text_view, Xen tabs)
{
  #define H_gtk_text_view_set_tabs "void gtk_text_view_set_tabs(GtkTextView* text_view, PangoTabArray* tabs)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_tabs", "GtkTextView*");
  Xen_check_type(Xen_is_PangoTabArray_(tabs) || Xen_is_false(tabs), tabs, 2, "gtk_text_view_set_tabs", "PangoTabArray*");
  gtk_text_view_set_tabs(Xen_to_C_GtkTextView_(text_view), Xen_to_C_PangoTabArray_(tabs));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_tabs(Xen text_view)
{
  #define H_gtk_text_view_get_tabs "PangoTabArray* gtk_text_view_get_tabs(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_tabs", "GtkTextView*");
  return(C_to_Xen_PangoTabArray_(gtk_text_view_get_tabs(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_toggle_button_new(void)
{
  #define H_gtk_toggle_button_new "GtkWidget* gtk_toggle_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_toggle_button_new()));
}

static Xen gxg_gtk_toggle_button_new_with_label(Xen label)
{
  #define H_gtk_toggle_button_new_with_label "GtkWidget* gtk_toggle_button_new_with_label(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_toggle_button_new_with_label", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_toggle_button_new_with_label(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_toggle_button_new_with_mnemonic(Xen label)
{
  #define H_gtk_toggle_button_new_with_mnemonic "GtkWidget* gtk_toggle_button_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_toggle_button_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_toggle_button_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_toggle_button_set_active(Xen toggle_button, Xen is_active)
{
  #define H_gtk_toggle_button_set_active "void gtk_toggle_button_set_active(GtkToggleButton* toggle_button, \
gboolean is_active)"
  Xen_check_type(Xen_is_GtkToggleButton_(toggle_button), toggle_button, 1, "gtk_toggle_button_set_active", "GtkToggleButton*");
  Xen_check_type(Xen_is_gboolean(is_active), is_active, 2, "gtk_toggle_button_set_active", "gboolean");
  gtk_toggle_button_set_active(Xen_to_C_GtkToggleButton_(toggle_button), Xen_to_C_gboolean(is_active));
  return(Xen_false);
}

static Xen gxg_gtk_toggle_button_get_active(Xen toggle_button)
{
  #define H_gtk_toggle_button_get_active "gboolean gtk_toggle_button_get_active(GtkToggleButton* toggle_button)"
  Xen_check_type(Xen_is_GtkToggleButton_(toggle_button), toggle_button, 1, "gtk_toggle_button_get_active", "GtkToggleButton*");
  return(C_to_Xen_gboolean(gtk_toggle_button_get_active(Xen_to_C_GtkToggleButton_(toggle_button))));
}

static Xen gxg_gtk_toggle_button_toggled(Xen toggle_button)
{
  #define H_gtk_toggle_button_toggled "void gtk_toggle_button_toggled(GtkToggleButton* toggle_button)"
  Xen_check_type(Xen_is_GtkToggleButton_(toggle_button), toggle_button, 1, "gtk_toggle_button_toggled", "GtkToggleButton*");
  gtk_toggle_button_toggled(Xen_to_C_GtkToggleButton_(toggle_button));
  return(Xen_false);
}

static Xen gxg_gtk_toolbar_new(void)
{
  #define H_gtk_toolbar_new "GtkWidget* gtk_toolbar_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_toolbar_new()));
}

static Xen gxg_gtk_toolbar_set_style(Xen toolbar, Xen style)
{
  #define H_gtk_toolbar_set_style "void gtk_toolbar_set_style(GtkToolbar* toolbar, GtkToolbarStyle style)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_set_style", "GtkToolbar*");
  Xen_check_type(Xen_is_GtkToolbarStyle(style), style, 2, "gtk_toolbar_set_style", "GtkToolbarStyle");
  gtk_toolbar_set_style(Xen_to_C_GtkToolbar_(toolbar), Xen_to_C_GtkToolbarStyle(style));
  return(Xen_false);
}

static Xen gxg_gtk_toolbar_unset_style(Xen toolbar)
{
  #define H_gtk_toolbar_unset_style "void gtk_toolbar_unset_style(GtkToolbar* toolbar)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_unset_style", "GtkToolbar*");
  gtk_toolbar_unset_style(Xen_to_C_GtkToolbar_(toolbar));
  return(Xen_false);
}

static Xen gxg_gtk_toolbar_get_style(Xen toolbar)
{
  #define H_gtk_toolbar_get_style "GtkToolbarStyle gtk_toolbar_get_style(GtkToolbar* toolbar)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_get_style", "GtkToolbar*");
  return(C_to_Xen_GtkToolbarStyle(gtk_toolbar_get_style(Xen_to_C_GtkToolbar_(toolbar))));
}

static Xen gxg_gtk_tree_drag_source_row_draggable(Xen drag_source, Xen path)
{
  #define H_gtk_tree_drag_source_row_draggable "gboolean gtk_tree_drag_source_row_draggable(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeDragSource_(drag_source), drag_source, 1, "gtk_tree_drag_source_row_draggable", "GtkTreeDragSource*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_drag_source_row_draggable", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_drag_source_row_draggable(Xen_to_C_GtkTreeDragSource_(drag_source), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_drag_source_drag_data_delete(Xen drag_source, Xen path)
{
  #define H_gtk_tree_drag_source_drag_data_delete "gboolean gtk_tree_drag_source_drag_data_delete(GtkTreeDragSource* drag_source, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeDragSource_(drag_source), drag_source, 1, "gtk_tree_drag_source_drag_data_delete", "GtkTreeDragSource*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_drag_source_drag_data_delete", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_drag_source_drag_data_delete(Xen_to_C_GtkTreeDragSource_(drag_source), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_drag_source_drag_data_get(Xen drag_source, Xen path, Xen selection_data)
{
  #define H_gtk_tree_drag_source_drag_data_get "gboolean gtk_tree_drag_source_drag_data_get(GtkTreeDragSource* drag_source, \
GtkTreePath* path, GtkSelectionData* selection_data)"
  Xen_check_type(Xen_is_GtkTreeDragSource_(drag_source), drag_source, 1, "gtk_tree_drag_source_drag_data_get", "GtkTreeDragSource*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_drag_source_drag_data_get", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkSelectionData_(selection_data), selection_data, 3, "gtk_tree_drag_source_drag_data_get", "GtkSelectionData*");
  return(C_to_Xen_gboolean(gtk_tree_drag_source_drag_data_get(Xen_to_C_GtkTreeDragSource_(drag_source), Xen_to_C_GtkTreePath_(path), 
                                                              Xen_to_C_GtkSelectionData_(selection_data))));
}

static Xen gxg_gtk_tree_drag_dest_drag_data_received(Xen drag_dest, Xen dest, Xen selection_data)
{
  #define H_gtk_tree_drag_dest_drag_data_received "gboolean gtk_tree_drag_dest_drag_data_received(GtkTreeDragDest* drag_dest, \
GtkTreePath* dest, GtkSelectionData* selection_data)"
  Xen_check_type(Xen_is_GtkTreeDragDest_(drag_dest), drag_dest, 1, "gtk_tree_drag_dest_drag_data_received", "GtkTreeDragDest*");
  Xen_check_type(Xen_is_GtkTreePath_(dest), dest, 2, "gtk_tree_drag_dest_drag_data_received", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkSelectionData_(selection_data), selection_data, 3, "gtk_tree_drag_dest_drag_data_received", "GtkSelectionData*");
  return(C_to_Xen_gboolean(gtk_tree_drag_dest_drag_data_received(Xen_to_C_GtkTreeDragDest_(drag_dest), Xen_to_C_GtkTreePath_(dest), 
                                                                 Xen_to_C_GtkSelectionData_(selection_data))));
}

static Xen gxg_gtk_tree_drag_dest_row_drop_possible(Xen drag_dest, Xen dest_path, Xen selection_data)
{
  #define H_gtk_tree_drag_dest_row_drop_possible "gboolean gtk_tree_drag_dest_row_drop_possible(GtkTreeDragDest* drag_dest, \
GtkTreePath* dest_path, GtkSelectionData* selection_data)"
  Xen_check_type(Xen_is_GtkTreeDragDest_(drag_dest), drag_dest, 1, "gtk_tree_drag_dest_row_drop_possible", "GtkTreeDragDest*");
  Xen_check_type(Xen_is_GtkTreePath_(dest_path), dest_path, 2, "gtk_tree_drag_dest_row_drop_possible", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkSelectionData_(selection_data), selection_data, 3, "gtk_tree_drag_dest_row_drop_possible", "GtkSelectionData*");
  return(C_to_Xen_gboolean(gtk_tree_drag_dest_row_drop_possible(Xen_to_C_GtkTreeDragDest_(drag_dest), Xen_to_C_GtkTreePath_(dest_path), 
                                                                Xen_to_C_GtkSelectionData_(selection_data))));
}

static Xen gxg_gtk_tree_set_row_drag_data(Xen selection_data, Xen tree_model, Xen path)
{
  #define H_gtk_tree_set_row_drag_data "gboolean gtk_tree_set_row_drag_data(GtkSelectionData* selection_data, \
GtkTreeModel* tree_model, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkSelectionData_(selection_data), selection_data, 1, "gtk_tree_set_row_drag_data", "GtkSelectionData*");
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 2, "gtk_tree_set_row_drag_data", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_set_row_drag_data", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_set_row_drag_data(Xen_to_C_GtkSelectionData_(selection_data), Xen_to_C_GtkTreeModel_(tree_model), 
                                                      Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_get_row_drag_data(Xen selection_data, Xen ignore_tree_model, Xen ignore_path)
{
  #define H_gtk_tree_get_row_drag_data "gboolean gtk_tree_get_row_drag_data(GtkSelectionData* selection_data, \
GtkTreeModel** [tree_model], GtkTreePath** [path])"
  GtkTreeModel* ref_tree_model = NULL;
  GtkTreePath* ref_path = NULL;
  Xen_check_type(Xen_is_GtkSelectionData_(selection_data), selection_data, 1, "gtk_tree_get_row_drag_data", "GtkSelectionData*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_tree_get_row_drag_data(Xen_to_C_GtkSelectionData_(selection_data), &ref_tree_model, &ref_path));
    return(Xen_list_3(result, C_to_Xen_GtkTreeModel_(ref_tree_model), C_to_Xen_GtkTreePath_(ref_path)));
   }
}

static Xen gxg_gtk_tree_path_new(void)
{
  #define H_gtk_tree_path_new "GtkTreePath* gtk_tree_path_new( void)"
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_new()));
}

static Xen gxg_gtk_tree_path_new_from_string(Xen path)
{
  #define H_gtk_tree_path_new_from_string "GtkTreePath* gtk_tree_path_new_from_string(gchar* path)"
  Xen_check_type(Xen_is_gchar_(path), path, 1, "gtk_tree_path_new_from_string", "gchar*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_new_from_string(Xen_to_C_gchar_(path))));
}

static Xen gxg_gtk_tree_path_to_string(Xen path)
{
  #define H_gtk_tree_path_to_string "gchar* gtk_tree_path_to_string(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_to_string", "GtkTreePath*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_tree_path_to_string(Xen_to_C_GtkTreePath_(path));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_tree_path_new_first(void)
{
  #define H_gtk_tree_path_new_first "GtkTreePath* gtk_tree_path_new_first( void)"
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_new_first()));
}

static Xen gxg_gtk_tree_path_append_index(Xen path, Xen index)
{
  #define H_gtk_tree_path_append_index "void gtk_tree_path_append_index(GtkTreePath* path, gint index)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_append_index", "GtkTreePath*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_tree_path_append_index", "gint");
  gtk_tree_path_append_index(Xen_to_C_GtkTreePath_(path), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_prepend_index(Xen path, Xen index)
{
  #define H_gtk_tree_path_prepend_index "void gtk_tree_path_prepend_index(GtkTreePath* path, gint index)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_prepend_index", "GtkTreePath*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_tree_path_prepend_index", "gint");
  gtk_tree_path_prepend_index(Xen_to_C_GtkTreePath_(path), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_get_depth(Xen path)
{
  #define H_gtk_tree_path_get_depth "gint gtk_tree_path_get_depth(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_get_depth", "GtkTreePath*");
  return(C_to_Xen_gint(gtk_tree_path_get_depth(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_get_indices(Xen path)
{
  #define H_gtk_tree_path_get_indices "gint* gtk_tree_path_get_indices(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_get_indices", "GtkTreePath*");
  return(C_to_Xen_gint_(gtk_tree_path_get_indices(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_free(Xen path)
{
  #define H_gtk_tree_path_free "void gtk_tree_path_free(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_free", "GtkTreePath*");
  gtk_tree_path_free(Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_copy(Xen path)
{
  #define H_gtk_tree_path_copy "GtkTreePath* gtk_tree_path_copy(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_copy", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_path_copy(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_compare(Xen a, Xen b)
{
  #define H_gtk_tree_path_compare "gint gtk_tree_path_compare(GtkTreePath* a, GtkTreePath* b)"
  Xen_check_type(Xen_is_GtkTreePath_(a), a, 1, "gtk_tree_path_compare", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(b), b, 2, "gtk_tree_path_compare", "GtkTreePath*");
  return(C_to_Xen_gint(gtk_tree_path_compare(Xen_to_C_GtkTreePath_(a), Xen_to_C_GtkTreePath_(b))));
}

static Xen gxg_gtk_tree_path_next(Xen path)
{
  #define H_gtk_tree_path_next "void gtk_tree_path_next(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_next", "GtkTreePath*");
  gtk_tree_path_next(Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_prev(Xen path)
{
  #define H_gtk_tree_path_prev "gboolean gtk_tree_path_prev(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_prev", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_prev(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_up(Xen path)
{
  #define H_gtk_tree_path_up "gboolean gtk_tree_path_up(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_up", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_up(Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_path_down(Xen path)
{
  #define H_gtk_tree_path_down "void gtk_tree_path_down(GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_down", "GtkTreePath*");
  gtk_tree_path_down(Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_path_is_ancestor(Xen path, Xen descendant)
{
  #define H_gtk_tree_path_is_ancestor "gboolean gtk_tree_path_is_ancestor(GtkTreePath* path, GtkTreePath* descendant)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_is_ancestor", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(descendant), descendant, 2, "gtk_tree_path_is_ancestor", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_is_ancestor(Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreePath_(descendant))));
}

static Xen gxg_gtk_tree_path_is_descendant(Xen path, Xen ancestor)
{
  #define H_gtk_tree_path_is_descendant "gboolean gtk_tree_path_is_descendant(GtkTreePath* path, GtkTreePath* ancestor)"
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 1, "gtk_tree_path_is_descendant", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(ancestor), ancestor, 2, "gtk_tree_path_is_descendant", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_path_is_descendant(Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreePath_(ancestor))));
}

static Xen gxg_gtk_tree_row_reference_new(Xen model, Xen path)
{
  #define H_gtk_tree_row_reference_new "GtkTreeRowReference* gtk_tree_row_reference_new(GtkTreeModel* model, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_tree_row_reference_new", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_new", "GtkTreePath*");
  return(C_to_Xen_GtkTreeRowReference_(gtk_tree_row_reference_new(Xen_to_C_GtkTreeModel_(model), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_row_reference_new_proxy(Xen proxy, Xen model, Xen path)
{
  #define H_gtk_tree_row_reference_new_proxy "GtkTreeRowReference* gtk_tree_row_reference_new_proxy(GObject* proxy, \
GtkTreeModel* model, GtkTreePath* path)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_new_proxy", "GObject*");
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 2, "gtk_tree_row_reference_new_proxy", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_row_reference_new_proxy", "GtkTreePath*");
  return(C_to_Xen_GtkTreeRowReference_(gtk_tree_row_reference_new_proxy(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreeModel_(model), 
                                                                        Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_row_reference_get_path(Xen reference)
{
  #define H_gtk_tree_row_reference_get_path "GtkTreePath* gtk_tree_row_reference_get_path(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_get_path", "GtkTreeRowReference*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_row_reference_get_path(Xen_to_C_GtkTreeRowReference_(reference))));
}

static Xen gxg_gtk_tree_row_reference_valid(Xen reference)
{
  #define H_gtk_tree_row_reference_valid "gboolean gtk_tree_row_reference_valid(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_valid", "GtkTreeRowReference*");
  return(C_to_Xen_gboolean(gtk_tree_row_reference_valid(Xen_to_C_GtkTreeRowReference_(reference))));
}

static Xen gxg_gtk_tree_row_reference_free(Xen reference)
{
  #define H_gtk_tree_row_reference_free "void gtk_tree_row_reference_free(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_free", "GtkTreeRowReference*");
  gtk_tree_row_reference_free(Xen_to_C_GtkTreeRowReference_(reference));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_inserted(Xen proxy, Xen path)
{
  #define H_gtk_tree_row_reference_inserted "void gtk_tree_row_reference_inserted(GObject* proxy, GtkTreePath* path)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_inserted", "GObject*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_inserted", "GtkTreePath*");
  gtk_tree_row_reference_inserted(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_deleted(Xen proxy, Xen path)
{
  #define H_gtk_tree_row_reference_deleted "void gtk_tree_row_reference_deleted(GObject* proxy, GtkTreePath* path)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_deleted", "GObject*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_deleted", "GtkTreePath*");
  gtk_tree_row_reference_deleted(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_row_reference_reordered(Xen proxy, Xen path, Xen iter, Xen new_order)
{
  #define H_gtk_tree_row_reference_reordered "void gtk_tree_row_reference_reordered(GObject* proxy, GtkTreePath* path, \
GtkTreeIter* iter, gint* new_order)"
  Xen_check_type(Xen_is_GObject_(proxy), proxy, 1, "gtk_tree_row_reference_reordered", "GObject*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_row_reference_reordered", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_row_reference_reordered", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint_(new_order), new_order, 4, "gtk_tree_row_reference_reordered", "gint*");
  gtk_tree_row_reference_reordered(Xen_to_C_GObject_(proxy), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_iter_copy(Xen iter)
{
  #define H_gtk_tree_iter_copy "GtkTreeIter* gtk_tree_iter_copy(GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 1, "gtk_tree_iter_copy", "GtkTreeIter*");
  return(C_to_Xen_GtkTreeIter_(gtk_tree_iter_copy(Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_iter_free(Xen iter)
{
  #define H_gtk_tree_iter_free "void gtk_tree_iter_free(GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 1, "gtk_tree_iter_free", "GtkTreeIter*");
  gtk_tree_iter_free(Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_get_flags(Xen tree_model)
{
  #define H_gtk_tree_model_get_flags "GtkTreeModelFlags gtk_tree_model_get_flags(GtkTreeModel* tree_model)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_flags", "GtkTreeModel*");
  return(C_to_Xen_GtkTreeModelFlags(gtk_tree_model_get_flags(Xen_to_C_GtkTreeModel_(tree_model))));
}

static Xen gxg_gtk_tree_model_get_n_columns(Xen tree_model)
{
  #define H_gtk_tree_model_get_n_columns "gint gtk_tree_model_get_n_columns(GtkTreeModel* tree_model)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_n_columns", "GtkTreeModel*");
  return(C_to_Xen_gint(gtk_tree_model_get_n_columns(Xen_to_C_GtkTreeModel_(tree_model))));
}

static Xen gxg_gtk_tree_model_get_column_type(Xen tree_model, Xen index)
{
  #define H_gtk_tree_model_get_column_type "GType gtk_tree_model_get_column_type(GtkTreeModel* tree_model, \
gint index)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_column_type", "GtkTreeModel*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_tree_model_get_column_type", "gint");
  return(C_to_Xen_GType(gtk_tree_model_get_column_type(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_gint(index))));
}

static Xen gxg_gtk_tree_model_get_iter(Xen tree_model, Xen iter, Xen path)
{
  #define H_gtk_tree_model_get_iter "gboolean gtk_tree_model_get_iter(GtkTreeModel* tree_model, GtkTreeIter* iter, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_iter", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 3, "gtk_tree_model_get_iter", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_model_get_iter(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_model_get_iter_from_string(Xen tree_model, Xen iter, Xen path_string)
{
  #define H_gtk_tree_model_get_iter_from_string "gboolean gtk_tree_model_get_iter_from_string(GtkTreeModel* tree_model, \
GtkTreeIter* iter, gchar* path_string)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_iter_from_string", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_iter_from_string", "GtkTreeIter*");
  Xen_check_type(Xen_is_gchar_(path_string), path_string, 3, "gtk_tree_model_get_iter_from_string", "gchar*");
  return(C_to_Xen_gboolean(gtk_tree_model_get_iter_from_string(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                                               Xen_to_C_gchar_(path_string))));
}

static Xen gxg_gtk_tree_model_get_iter_first(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_get_iter_first "gboolean gtk_tree_model_get_iter_first(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_iter_first", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_iter_first", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_get_iter_first(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_get_path(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_get_path "GtkTreePath* gtk_tree_model_get_path(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_path", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_path", "GtkTreeIter*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_get_path(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_next(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_iter_next "gboolean gtk_tree_model_iter_next(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_next", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_next", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_next(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_children(Xen tree_model, Xen iter, Xen parent)
{
  #define H_gtk_tree_model_iter_children "gboolean gtk_tree_model_iter_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_children", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_children", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_model_iter_children", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_children(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                                        Xen_to_C_GtkTreeIter_(parent))));
}

static Xen gxg_gtk_tree_model_iter_has_child(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_iter_has_child "gboolean gtk_tree_model_iter_has_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_has_child", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_has_child", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_has_child(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_n_children(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_iter_n_children "gint gtk_tree_model_iter_n_children(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_n_children", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter) || Xen_is_false(iter), iter, 2, "gtk_tree_model_iter_n_children", "GtkTreeIter*");
  return(C_to_Xen_gint(gtk_tree_model_iter_n_children(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_model_iter_nth_child(Xen tree_model, Xen iter, Xen parent, Xen n)
{
  #define H_gtk_tree_model_iter_nth_child "gboolean gtk_tree_model_iter_nth_child(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* parent, gint n)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_nth_child", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_nth_child", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_model_iter_nth_child", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(n), n, 4, "gtk_tree_model_iter_nth_child", "gint");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_nth_child(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                                         Xen_to_C_GtkTreeIter_(parent), Xen_to_C_gint(n))));
}

static Xen gxg_gtk_tree_model_iter_parent(Xen tree_model, Xen iter, Xen child)
{
  #define H_gtk_tree_model_iter_parent "gboolean gtk_tree_model_iter_parent(GtkTreeModel* tree_model, \
GtkTreeIter* iter, GtkTreeIter* child)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_iter_parent", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_iter_parent", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child), child, 3, "gtk_tree_model_iter_parent", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_iter_parent(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(child))));
}

static Xen gxg_gtk_tree_model_ref_node(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_ref_node "void gtk_tree_model_ref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_ref_node", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_ref_node", "GtkTreeIter*");
  gtk_tree_model_ref_node(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_unref_node(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_unref_node "void gtk_tree_model_unref_node(GtkTreeModel* tree_model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_unref_node", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_unref_node", "GtkTreeIter*");
  gtk_tree_model_unref_node(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_foreach(Xen model, Xen func, Xen func_info)
{
  #define H_gtk_tree_model_foreach "void gtk_tree_model_foreach(GtkTreeModel* model, GtkTreeModelForeachFunc func, \
lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_tree_model_foreach", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeModelForeachFunc(func), func, 2, "gtk_tree_model_foreach", "GtkTreeModelForeachFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_model_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_tree_model_foreach(Xen_to_C_GtkTreeModel_(model), Xen_to_C_GtkTreeModelForeachFunc(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_model_row_changed(Xen tree_model, Xen path, Xen iter)
{
  #define H_gtk_tree_model_row_changed "void gtk_tree_model_row_changed(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_changed", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_changed", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_row_changed", "GtkTreeIter*");
  gtk_tree_model_row_changed(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_row_inserted(Xen tree_model, Xen path, Xen iter)
{
  #define H_gtk_tree_model_row_inserted "void gtk_tree_model_row_inserted(GtkTreeModel* tree_model, GtkTreePath* path, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_inserted", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_inserted", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_row_inserted", "GtkTreeIter*");
  gtk_tree_model_row_inserted(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_row_has_child_toggled(Xen tree_model, Xen path, Xen iter)
{
  #define H_gtk_tree_model_row_has_child_toggled "void gtk_tree_model_row_has_child_toggled(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_has_child_toggled", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_has_child_toggled", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_row_has_child_toggled", "GtkTreeIter*");
  gtk_tree_model_row_has_child_toggled(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_row_deleted(Xen tree_model, Xen path)
{
  #define H_gtk_tree_model_row_deleted "void gtk_tree_model_row_deleted(GtkTreeModel* tree_model, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_row_deleted", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_row_deleted", "GtkTreePath*");
  gtk_tree_model_row_deleted(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_rows_reordered(Xen tree_model, Xen path, Xen iter, Xen new_order)
{
  #define H_gtk_tree_model_rows_reordered "void gtk_tree_model_rows_reordered(GtkTreeModel* tree_model, \
GtkTreePath* path, GtkTreeIter* iter, gint* new_order)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_rows_reordered", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_model_rows_reordered", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_model_rows_reordered", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint_(new_order), new_order, 4, "gtk_tree_model_rows_reordered", "gint*");
  gtk_tree_model_rows_reordered(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeIter_(iter), 
                                Xen_to_C_gint_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_new_with_model(Xen child_model)
{
  #define H_gtk_tree_model_sort_new_with_model "GtkTreeModel* gtk_tree_model_sort_new_with_model(GtkTreeModel* child_model)"
  Xen_check_type(Xen_is_GtkTreeModel_(child_model), child_model, 1, "gtk_tree_model_sort_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_sort_new_with_model(Xen_to_C_GtkTreeModel_(child_model))));
}

static Xen gxg_gtk_tree_model_sort_get_model(Xen tree_model)
{
  #define H_gtk_tree_model_sort_get_model "GtkTreeModel* gtk_tree_model_sort_get_model(GtkTreeModelSort* tree_model)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model), tree_model, 1, "gtk_tree_model_sort_get_model", "GtkTreeModelSort*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_sort_get_model(Xen_to_C_GtkTreeModelSort_(tree_model))));
}

static Xen gxg_gtk_tree_model_sort_convert_child_path_to_path(Xen tree_model_sort, Xen child_path)
{
  #define H_gtk_tree_model_sort_convert_child_path_to_path "GtkTreePath* gtk_tree_model_sort_convert_child_path_to_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* child_path)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_child_path_to_path", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreePath_(child_path), child_path, 2, "gtk_tree_model_sort_convert_child_path_to_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_sort_convert_child_path_to_path(Xen_to_C_GtkTreeModelSort_(tree_model_sort), 
                                                                              Xen_to_C_GtkTreePath_(child_path))));
}

static Xen gxg_gtk_tree_model_sort_convert_child_iter_to_iter(Xen tree_model_sort, Xen sort_iter, Xen child_iter)
{
  #define H_gtk_tree_model_sort_convert_child_iter_to_iter "void gtk_tree_model_sort_convert_child_iter_to_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* sort_iter, GtkTreeIter* child_iter)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_child_iter_to_iter", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreeIter_(sort_iter), sort_iter, 2, "gtk_tree_model_sort_convert_child_iter_to_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 3, "gtk_tree_model_sort_convert_child_iter_to_iter", "GtkTreeIter*");
  gtk_tree_model_sort_convert_child_iter_to_iter(Xen_to_C_GtkTreeModelSort_(tree_model_sort), Xen_to_C_GtkTreeIter_(sort_iter), 
                                                 Xen_to_C_GtkTreeIter_(child_iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_convert_path_to_child_path(Xen tree_model_sort, Xen sorted_path)
{
  #define H_gtk_tree_model_sort_convert_path_to_child_path "GtkTreePath* gtk_tree_model_sort_convert_path_to_child_path(GtkTreeModelSort* tree_model_sort, \
GtkTreePath* sorted_path)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_path_to_child_path", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreePath_(sorted_path), sorted_path, 2, "gtk_tree_model_sort_convert_path_to_child_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_sort_convert_path_to_child_path(Xen_to_C_GtkTreeModelSort_(tree_model_sort), 
                                                                              Xen_to_C_GtkTreePath_(sorted_path))));
}

static Xen gxg_gtk_tree_model_sort_convert_iter_to_child_iter(Xen tree_model_sort, Xen child_iter, Xen sorted_iter)
{
  #define H_gtk_tree_model_sort_convert_iter_to_child_iter "void gtk_tree_model_sort_convert_iter_to_child_iter(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* child_iter, GtkTreeIter* sorted_iter)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_convert_iter_to_child_iter", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 2, "gtk_tree_model_sort_convert_iter_to_child_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sorted_iter), sorted_iter, 3, "gtk_tree_model_sort_convert_iter_to_child_iter", "GtkTreeIter*");
  gtk_tree_model_sort_convert_iter_to_child_iter(Xen_to_C_GtkTreeModelSort_(tree_model_sort), Xen_to_C_GtkTreeIter_(child_iter), 
                                                 Xen_to_C_GtkTreeIter_(sorted_iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_reset_default_sort_func(Xen tree_model_sort)
{
  #define H_gtk_tree_model_sort_reset_default_sort_func "void gtk_tree_model_sort_reset_default_sort_func(GtkTreeModelSort* tree_model_sort)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_reset_default_sort_func", "GtkTreeModelSort*");
  gtk_tree_model_sort_reset_default_sort_func(Xen_to_C_GtkTreeModelSort_(tree_model_sort));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_sort_clear_cache(Xen tree_model_sort)
{
  #define H_gtk_tree_model_sort_clear_cache "void gtk_tree_model_sort_clear_cache(GtkTreeModelSort* tree_model_sort)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_clear_cache", "GtkTreeModelSort*");
  gtk_tree_model_sort_clear_cache(Xen_to_C_GtkTreeModelSort_(tree_model_sort));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_set_mode(Xen selection, Xen type)
{
  #define H_gtk_tree_selection_set_mode "void gtk_tree_selection_set_mode(GtkTreeSelection* selection, \
GtkSelectionMode type)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_set_mode", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkSelectionMode(type), type, 2, "gtk_tree_selection_set_mode", "GtkSelectionMode");
  gtk_tree_selection_set_mode(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkSelectionMode(type));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_get_mode(Xen selection)
{
  #define H_gtk_tree_selection_get_mode "GtkSelectionMode gtk_tree_selection_get_mode(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_mode", "GtkTreeSelection*");
  return(C_to_Xen_GtkSelectionMode(gtk_tree_selection_get_mode(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_tree_selection_set_select_function(Xen selection, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_selection_set_select_function "void gtk_tree_selection_set_select_function(GtkTreeSelection* selection, \
GtkTreeSelectionFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_set_select_function", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeSelectionFunc(func), func, 2, "gtk_tree_selection_set_select_function", "GtkTreeSelectionFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_selection_set_select_function", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_selection_set_select_function", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_selection_set_select_function(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeSelectionFunc(func), Xen_to_C_lambda_data(func_info), 
                                       Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_selection_get_user_data(Xen selection)
{
  #define H_gtk_tree_selection_get_user_data "gpointer gtk_tree_selection_get_user_data(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_user_data", "GtkTreeSelection*");
  return(C_to_Xen_gpointer(gtk_tree_selection_get_user_data(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_tree_selection_get_tree_view(Xen selection)
{
  #define H_gtk_tree_selection_get_tree_view "GtkTreeView* gtk_tree_selection_get_tree_view(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_tree_view", "GtkTreeSelection*");
  return(C_to_Xen_GtkTreeView_(gtk_tree_selection_get_tree_view(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_tree_selection_get_selected(Xen selection, Xen model, Xen iter)
{
  #define H_gtk_tree_selection_get_selected "gboolean gtk_tree_selection_get_selected(GtkTreeSelection* selection, \
GtkTreeModel** model, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_selected", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeModel__(model), model, 2, "gtk_tree_selection_get_selected", "GtkTreeModel**");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_selection_get_selected", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_selection_get_selected(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeModel__(model), 
                                                           Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_selection_selected_foreach(Xen selection, Xen func, Xen func_info)
{
  #define H_gtk_tree_selection_selected_foreach "void gtk_tree_selection_selected_foreach(GtkTreeSelection* selection, \
GtkTreeSelectionForeachFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_selected_foreach", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeSelectionForeachFunc(func), func, 2, "gtk_tree_selection_selected_foreach", "GtkTreeSelectionForeachFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_selection_selected_foreach", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_tree_selection_selected_foreach(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeSelectionForeachFunc(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_selection_select_path(Xen selection, Xen path)
{
  #define H_gtk_tree_selection_select_path "void gtk_tree_selection_select_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_path", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_selection_select_path", "GtkTreePath*");
  gtk_tree_selection_select_path(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_unselect_path(Xen selection, Xen path)
{
  #define H_gtk_tree_selection_unselect_path "void gtk_tree_selection_unselect_path(GtkTreeSelection* selection, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_unselect_path", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_selection_unselect_path", "GtkTreePath*");
  gtk_tree_selection_unselect_path(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_select_iter(Xen selection, Xen iter)
{
  #define H_gtk_tree_selection_select_iter "void gtk_tree_selection_select_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_iter", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_selection_select_iter", "GtkTreeIter*");
  gtk_tree_selection_select_iter(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_unselect_iter(Xen selection, Xen iter)
{
  #define H_gtk_tree_selection_unselect_iter "void gtk_tree_selection_unselect_iter(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_unselect_iter", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_selection_unselect_iter", "GtkTreeIter*");
  gtk_tree_selection_unselect_iter(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_path_is_selected(Xen selection, Xen path)
{
  #define H_gtk_tree_selection_path_is_selected "gboolean gtk_tree_selection_path_is_selected(GtkTreeSelection* selection, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_path_is_selected", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_selection_path_is_selected", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_selection_path_is_selected(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_selection_iter_is_selected(Xen selection, Xen iter)
{
  #define H_gtk_tree_selection_iter_is_selected "gboolean gtk_tree_selection_iter_is_selected(GtkTreeSelection* selection, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_iter_is_selected", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_selection_iter_is_selected", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_selection_iter_is_selected(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_selection_select_all(Xen selection)
{
  #define H_gtk_tree_selection_select_all "void gtk_tree_selection_select_all(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_all", "GtkTreeSelection*");
  gtk_tree_selection_select_all(Xen_to_C_GtkTreeSelection_(selection));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_unselect_all(Xen selection)
{
  #define H_gtk_tree_selection_unselect_all "void gtk_tree_selection_unselect_all(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_unselect_all", "GtkTreeSelection*");
  gtk_tree_selection_unselect_all(Xen_to_C_GtkTreeSelection_(selection));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_select_range(Xen selection, Xen start_path, Xen end_path)
{
  #define H_gtk_tree_selection_select_range "void gtk_tree_selection_select_range(GtkTreeSelection* selection, \
GtkTreePath* start_path, GtkTreePath* end_path)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_select_range", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreePath_(start_path), start_path, 2, "gtk_tree_selection_select_range", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreePath_(end_path), end_path, 3, "gtk_tree_selection_select_range", "GtkTreePath*");
  gtk_tree_selection_select_range(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreePath_(start_path), Xen_to_C_GtkTreePath_(end_path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_sortable_sort_column_changed(Xen sortable)
{
  #define H_gtk_tree_sortable_sort_column_changed "void gtk_tree_sortable_sort_column_changed(GtkTreeSortable* sortable)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_sort_column_changed", "GtkTreeSortable*");
  gtk_tree_sortable_sort_column_changed(Xen_to_C_GtkTreeSortable_(sortable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_sortable_get_sort_column_id(Xen sortable, Xen ignore_sort_column_id, Xen ignore_order)
{
  #define H_gtk_tree_sortable_get_sort_column_id "gboolean gtk_tree_sortable_get_sort_column_id(GtkTreeSortable* sortable, \
gint* [sort_column_id], GtkSortType* [order])"
  gint ref_sort_column_id;
  GtkSortType ref_order;
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_get_sort_column_id", "GtkTreeSortable*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_tree_sortable_get_sort_column_id(Xen_to_C_GtkTreeSortable_(sortable), &ref_sort_column_id, 
                                                                    &ref_order));
    return(Xen_list_3(result, C_to_Xen_gint(ref_sort_column_id), C_to_Xen_GtkSortType(ref_order)));
   }
}

static Xen gxg_gtk_tree_sortable_set_sort_column_id(Xen sortable, Xen sort_column_id, Xen order)
{
  #define H_gtk_tree_sortable_set_sort_column_id "void gtk_tree_sortable_set_sort_column_id(GtkTreeSortable* sortable, \
gint sort_column_id, GtkSortType order)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_set_sort_column_id", "GtkTreeSortable*");
  Xen_check_type(Xen_is_gint(sort_column_id), sort_column_id, 2, "gtk_tree_sortable_set_sort_column_id", "gint");
  Xen_check_type(Xen_is_GtkSortType(order), order, 3, "gtk_tree_sortable_set_sort_column_id", "GtkSortType");
  gtk_tree_sortable_set_sort_column_id(Xen_to_C_GtkTreeSortable_(sortable), Xen_to_C_gint(sort_column_id), Xen_to_C_GtkSortType(order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_sortable_set_sort_func(Xen sortable, Xen sort_column_id, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_sortable_set_sort_func "void gtk_tree_sortable_set_sort_func(GtkTreeSortable* sortable, \
gint sort_column_id, GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_set_sort_func", "GtkTreeSortable*");
  Xen_check_type(Xen_is_gint(sort_column_id), sort_column_id, 2, "gtk_tree_sortable_set_sort_func", "gint");
  Xen_check_type(Xen_is_GtkTreeIterCompareFunc(func), func, 3, "gtk_tree_sortable_set_sort_func", "GtkTreeIterCompareFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "gtk_tree_sortable_set_sort_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 5, "gtk_tree_sortable_set_sort_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_sortable_set_sort_func(Xen_to_C_GtkTreeSortable_(sortable), Xen_to_C_gint(sort_column_id), Xen_to_C_GtkTreeIterCompareFunc(func), 
                                Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_sortable_set_default_sort_func(Xen sortable, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_sortable_set_default_sort_func "void gtk_tree_sortable_set_default_sort_func(GtkTreeSortable* sortable, \
GtkTreeIterCompareFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_set_default_sort_func", "GtkTreeSortable*");
  Xen_check_type(Xen_is_GtkTreeIterCompareFunc(func), func, 2, "gtk_tree_sortable_set_default_sort_func", "GtkTreeIterCompareFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_sortable_set_default_sort_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_sortable_set_default_sort_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_sortable_set_default_sort_func(Xen_to_C_GtkTreeSortable_(sortable), Xen_to_C_GtkTreeIterCompareFunc(func), Xen_to_C_lambda_data(func_info), 
                                        Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_sortable_has_default_sort_func(Xen sortable)
{
  #define H_gtk_tree_sortable_has_default_sort_func "gboolean gtk_tree_sortable_has_default_sort_func(GtkTreeSortable* sortable)"
  Xen_check_type(Xen_is_GtkTreeSortable_(sortable), sortable, 1, "gtk_tree_sortable_has_default_sort_func", "GtkTreeSortable*");
  return(C_to_Xen_gboolean(gtk_tree_sortable_has_default_sort_func(Xen_to_C_GtkTreeSortable_(sortable))));
}

static Xen gxg_gtk_tree_store_new(Xen n_columns, Xen types)
{
  #define H_gtk_tree_store_new "GtkTreeStore* gtk_tree_store_new(gint n_columns, etc types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_tree_store_new", "gint");
  Xen_check_type(Xen_is_etc(types), types, 2, "gtk_tree_store_new", "etc");
  {
    int etc_len = 0;
    GtkTreeStore* result = NULL;
    gint p_arg0;
    if (Xen_is_list(types)) etc_len = Xen_list_length(types);
    if (etc_len < 1) Xen_out_of_range_error("gtk_tree_store_new", 1, types, "... list must have at least 1 entry");
    if (etc_len > 6) Xen_out_of_range_error("gtk_tree_store_new", 1, types, "... list too long (max len: 6)");
    p_arg0 = Xen_to_C_gint(n_columns);
    switch (etc_len)
      {
        case 1: result = gtk_tree_store_new(p_arg0, XLG(types, 0)); break;
        case 2: result = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1)); break;
        case 3: result = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2)); break;
        case 4: result = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3)); break;
        case 5: result = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4)); break;
        case 6: result = gtk_tree_store_new(p_arg0, XLG(types, 0), XLG(types, 1), XLG(types, 2), XLG(types, 3), XLG(types, 4), XLG(types, 5)); break;
      }
    return(C_to_Xen_GtkTreeStore_(result));
  }
}

static Xen gxg_gtk_tree_store_newv(Xen n_columns, Xen types)
{
  #define H_gtk_tree_store_newv "GtkTreeStore* gtk_tree_store_newv(gint n_columns, GType* types)"
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 1, "gtk_tree_store_newv", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 2, "gtk_tree_store_newv", "GType*");
  return(C_to_Xen_GtkTreeStore_(gtk_tree_store_newv(Xen_to_C_gint(n_columns), Xen_to_C_GType_(types))));
}

static Xen gxg_gtk_tree_store_set_column_types(Xen tree_store, Xen n_columns, Xen types)
{
  #define H_gtk_tree_store_set_column_types "void gtk_tree_store_set_column_types(GtkTreeStore* tree_store, \
gint n_columns, GType* types)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_set_column_types", "GtkTreeStore*");
  Xen_check_type(Xen_is_gint(n_columns), n_columns, 2, "gtk_tree_store_set_column_types", "gint");
  Xen_check_type(Xen_is_GType_(types), types, 3, "gtk_tree_store_set_column_types", "GType*");
  gtk_tree_store_set_column_types(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_gint(n_columns), Xen_to_C_GType_(types));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_set(Xen tree_store, Xen iter, Xen values)
{
  #define H_gtk_tree_store_set "void gtk_tree_store_set(GtkTreeStore* tree_store, GtkTreeIter* iter, \
etc values)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_set", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_set", "GtkTreeIter*");
  Xen_check_type(Xen_is_etc(values), values, 3, "gtk_tree_store_set", "etc");
  {
    int etc_len = 0;
    GtkTreeStore* p_arg0;
    GtkTreeIter* p_arg1;
    if (Xen_is_list(values)) etc_len = Xen_list_length(values);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_store_set", 2, values, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_store_set", 2, values, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_store_set", 2, values, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTreeStore_(tree_store);
    p_arg1 = Xen_to_C_GtkTreeIter_(iter);
    switch (etc_len)
      {
        case 2: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), -1); break;
        case 4: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), -1); break;
        case 6: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), -1); break;
        case 8: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), -1); break;
        case 10: gtk_tree_store_set(p_arg0, p_arg1, XLI(values, 0), XLS(values, 1), XLI(values, 2), XLS(values, 3), XLI(values, 4), XLS(values, 5), XLI(values, 6), XLS(values, 7), XLI(values, 8), XLS(values, 9), -1); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_tree_store_remove(Xen tree_store, Xen iter)
{
  #define H_gtk_tree_store_remove "void gtk_tree_store_remove(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_remove", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_remove", "GtkTreeIter*");
  gtk_tree_store_remove(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_insert(Xen tree_store, Xen iter, Xen parent, Xen position)
{
  #define H_gtk_tree_store_insert "void gtk_tree_store_insert(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, gint position)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_insert", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_insert", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_insert", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 4, "gtk_tree_store_insert", "gint");
  gtk_tree_store_insert(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_insert_before(Xen tree_store, Xen iter, Xen parent, Xen sibling)
{
  #define H_gtk_tree_store_insert_before "void gtk_tree_store_insert_before(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* parent, GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_insert_before", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_insert_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_insert_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 4, "gtk_tree_store_insert_before", "GtkTreeIter*");
  gtk_tree_store_insert_before(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent), 
                               Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_insert_after(Xen tree_store, Xen iter, Xen parent, Xen sibling)
{
  #define H_gtk_tree_store_insert_after "void gtk_tree_store_insert_after(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent, GtkTreeIter* sibling)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_insert_after", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_insert_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_insert_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(sibling) || Xen_is_false(sibling), sibling, 4, "gtk_tree_store_insert_after", "GtkTreeIter*");
  gtk_tree_store_insert_after(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent), 
                              Xen_to_C_GtkTreeIter_(sibling));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_prepend(Xen tree_store, Xen iter, Xen parent)
{
  #define H_gtk_tree_store_prepend "void gtk_tree_store_prepend(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_prepend", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_prepend", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_prepend", "GtkTreeIter*");
  gtk_tree_store_prepend(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_append(Xen tree_store, Xen iter, Xen parent)
{
  #define H_gtk_tree_store_append "void gtk_tree_store_append(GtkTreeStore* tree_store, GtkTreeIter* iter, \
GtkTreeIter* parent)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_append", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_append", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent) || Xen_is_false(parent), parent, 3, "gtk_tree_store_append", "GtkTreeIter*");
  gtk_tree_store_append(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_is_ancestor(Xen tree_store, Xen iter, Xen descendant)
{
  #define H_gtk_tree_store_is_ancestor "gboolean gtk_tree_store_is_ancestor(GtkTreeStore* tree_store, \
GtkTreeIter* iter, GtkTreeIter* descendant)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_is_ancestor", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_is_ancestor", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(descendant), descendant, 3, "gtk_tree_store_is_ancestor", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_store_is_ancestor(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(descendant))));
}

static Xen gxg_gtk_tree_store_iter_depth(Xen tree_store, Xen iter)
{
  #define H_gtk_tree_store_iter_depth "gint gtk_tree_store_iter_depth(GtkTreeStore* tree_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_iter_depth", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_store_iter_depth", "GtkTreeIter*");
  return(C_to_Xen_gint(gtk_tree_store_iter_depth(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_store_clear(Xen tree_store)
{
  #define H_gtk_tree_store_clear "void gtk_tree_store_clear(GtkTreeStore* tree_store)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_clear", "GtkTreeStore*");
  gtk_tree_store_clear(Xen_to_C_GtkTreeStore_(tree_store));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_new(void)
{
  #define H_gtk_tree_view_column_new "GtkTreeViewColumn* gtk_tree_view_column_new( void)"
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_column_new()));
}

static Xen gxg_gtk_tree_view_column_new_with_attributes(Xen title, Xen cell, Xen attributes)
{
  #define H_gtk_tree_view_column_new_with_attributes "GtkTreeViewColumn* gtk_tree_view_column_new_with_attributes(gchar* title, \
GtkCellRenderer* cell, etc attributes)"
  Xen_check_type(Xen_is_gchar_(title), title, 1, "gtk_tree_view_column_new_with_attributes", "gchar*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_new_with_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 3, "gtk_tree_view_column_new_with_attributes", "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* result = NULL;
    gchar* p_arg0;
    GtkCellRenderer* p_arg1;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_view_column_new_with_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_view_column_new_with_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_view_column_new_with_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_gchar_(title);
    p_arg1 = Xen_to_C_GtkCellRenderer_(cell);
    switch (etc_len)
      {
        case 2: result = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: result = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: result = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: result = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: result = gtk_tree_view_column_new_with_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(C_to_Xen_GtkTreeViewColumn_(result));
  }
}

static Xen gxg_gtk_tree_view_column_pack_start(Xen tree_column, Xen cell, Xen expand)
{
  #define H_gtk_tree_view_column_pack_start "void gtk_tree_view_column_pack_start(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_pack_start", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_pack_start", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_tree_view_column_pack_start", "gboolean");
  gtk_tree_view_column_pack_start(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_pack_end(Xen tree_column, Xen cell, Xen expand)
{
  #define H_gtk_tree_view_column_pack_end "void gtk_tree_view_column_pack_end(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell, gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_pack_end", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_tree_view_column_pack_end", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_tree_view_column_pack_end", "gboolean");
  gtk_tree_view_column_pack_end(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_clear(Xen tree_column)
{
  #define H_gtk_tree_view_column_clear "void gtk_tree_view_column_clear(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_clear", "GtkTreeViewColumn*");
  gtk_tree_view_column_clear(Xen_to_C_GtkTreeViewColumn_(tree_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_add_attribute(Xen tree_column, Xen cell_renderer, Xen attribute, Xen column)
{
  #define H_gtk_tree_view_column_add_attribute "void gtk_tree_view_column_add_attribute(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gchar* attribute, gint column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_add_attribute", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_add_attribute", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gchar_(attribute), attribute, 3, "gtk_tree_view_column_add_attribute", "gchar*");
  Xen_check_type(Xen_is_gint(column), column, 4, "gtk_tree_view_column_add_attribute", "gint");
  gtk_tree_view_column_add_attribute(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer), 
                                     Xen_to_C_gchar_(attribute), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_attributes(Xen tree_column, Xen cell_renderer, Xen attributes)
{
  #define H_gtk_tree_view_column_set_attributes "void gtk_tree_view_column_set_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, etc attributes)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_attributes", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_set_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 3, "gtk_tree_view_column_set_attributes", "etc");
  {
    int etc_len = 0;
    GtkTreeViewColumn* p_arg0;
    GtkCellRenderer* p_arg1;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_view_column_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_view_column_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_view_column_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTreeViewColumn_(tree_column);
    p_arg1 = Xen_to_C_GtkCellRenderer_(cell_renderer);
    switch (etc_len)
      {
        case 2: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: gtk_tree_view_column_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_tree_view_column_set_cell_data_func(Xen tree_column, Xen cell_renderer, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_view_column_set_cell_data_func "void gtk_tree_view_column_set_cell_data_func(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, GtkTreeCellDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_cell_data_func", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_set_cell_data_func", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkTreeCellDataFunc(func), func, 3, "gtk_tree_view_column_set_cell_data_func", "GtkTreeCellDataFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "gtk_tree_view_column_set_cell_data_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 5, "gtk_tree_view_column_set_cell_data_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_view_column_set_cell_data_func(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer), 
                                        Xen_to_C_GtkTreeCellDataFunc(func), Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_view_column_clear_attributes(Xen tree_column, Xen cell_renderer)
{
  #define H_gtk_tree_view_column_clear_attributes "void gtk_tree_view_column_clear_attributes(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_clear_attributes", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_clear_attributes", "GtkCellRenderer*");
  gtk_tree_view_column_clear_attributes(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_spacing(Xen tree_column, Xen spacing)
{
  #define H_gtk_tree_view_column_set_spacing "void gtk_tree_view_column_set_spacing(GtkTreeViewColumn* tree_column, \
gint spacing)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_spacing", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_tree_view_column_set_spacing", "gint");
  gtk_tree_view_column_set_spacing(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_spacing(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_spacing "gint gtk_tree_view_column_get_spacing(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_spacing", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_spacing(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_visible(Xen tree_column, Xen visible)
{
  #define H_gtk_tree_view_column_set_visible "void gtk_tree_view_column_set_visible(GtkTreeViewColumn* tree_column, \
gboolean visible)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_visible", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(visible), visible, 2, "gtk_tree_view_column_set_visible", "gboolean");
  gtk_tree_view_column_set_visible(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(visible));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_visible(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_visible "gboolean gtk_tree_view_column_get_visible(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_visible", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_visible(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_resizable(Xen tree_column, Xen resizable)
{
  #define H_gtk_tree_view_column_set_resizable "void gtk_tree_view_column_set_resizable(GtkTreeViewColumn* tree_column, \
gboolean resizable)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_resizable", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(resizable), resizable, 2, "gtk_tree_view_column_set_resizable", "gboolean");
  gtk_tree_view_column_set_resizable(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(resizable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_resizable(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_resizable "gboolean gtk_tree_view_column_get_resizable(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_resizable", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_resizable(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sizing(Xen tree_column, Xen type)
{
  #define H_gtk_tree_view_column_set_sizing "void gtk_tree_view_column_set_sizing(GtkTreeViewColumn* tree_column, \
GtkTreeViewColumnSizing type)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sizing", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkTreeViewColumnSizing(type), type, 2, "gtk_tree_view_column_set_sizing", "GtkTreeViewColumnSizing");
  gtk_tree_view_column_set_sizing(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkTreeViewColumnSizing(type));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sizing(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sizing "GtkTreeViewColumnSizing gtk_tree_view_column_get_sizing(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sizing", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkTreeViewColumnSizing(gtk_tree_view_column_get_sizing(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_get_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_width "gint gtk_tree_view_column_get_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_get_fixed_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_fixed_width "gint gtk_tree_view_column_get_fixed_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_fixed_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_fixed_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_fixed_width(Xen tree_column, Xen fixed_width)
{
  #define H_gtk_tree_view_column_set_fixed_width "void gtk_tree_view_column_set_fixed_width(GtkTreeViewColumn* tree_column, \
gint fixed_width)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_fixed_width", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(fixed_width), fixed_width, 2, "gtk_tree_view_column_set_fixed_width", "gint");
  gtk_tree_view_column_set_fixed_width(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(fixed_width));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_min_width(Xen tree_column, Xen min_width)
{
  #define H_gtk_tree_view_column_set_min_width "void gtk_tree_view_column_set_min_width(GtkTreeViewColumn* tree_column, \
gint min_width)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_min_width", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(min_width), min_width, 2, "gtk_tree_view_column_set_min_width", "gint");
  gtk_tree_view_column_set_min_width(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(min_width));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_min_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_min_width "gint gtk_tree_view_column_get_min_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_min_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_min_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_max_width(Xen tree_column, Xen max_width)
{
  #define H_gtk_tree_view_column_set_max_width "void gtk_tree_view_column_set_max_width(GtkTreeViewColumn* tree_column, \
gint max_width)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_max_width", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(max_width), max_width, 2, "gtk_tree_view_column_set_max_width", "gint");
  gtk_tree_view_column_set_max_width(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(max_width));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_max_width(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_max_width "gint gtk_tree_view_column_get_max_width(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_max_width", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_max_width(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_clicked(Xen tree_column)
{
  #define H_gtk_tree_view_column_clicked "void gtk_tree_view_column_clicked(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_clicked", "GtkTreeViewColumn*");
  gtk_tree_view_column_clicked(Xen_to_C_GtkTreeViewColumn_(tree_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_set_title(Xen tree_column, Xen title)
{
  #define H_gtk_tree_view_column_set_title "void gtk_tree_view_column_set_title(GtkTreeViewColumn* tree_column, \
gchar* title)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_title", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_tree_view_column_set_title", "gchar*");
  gtk_tree_view_column_set_title(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_title(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_title "gchar* gtk_tree_view_column_get_title(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_title", "GtkTreeViewColumn*");
  return(C_to_Xen_gchar_(gtk_tree_view_column_get_title(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_clickable(Xen tree_column, Xen clickable)
{
  #define H_gtk_tree_view_column_set_clickable "void gtk_tree_view_column_set_clickable(GtkTreeViewColumn* tree_column, \
gboolean clickable)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_clickable", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(clickable), clickable, 2, "gtk_tree_view_column_set_clickable", "gboolean");
  gtk_tree_view_column_set_clickable(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(clickable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_clickable(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_clickable "gboolean gtk_tree_view_column_get_clickable(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_clickable", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_clickable(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_widget(Xen tree_column, Xen widget)
{
  #define H_gtk_tree_view_column_set_widget "void gtk_tree_view_column_set_widget(GtkTreeViewColumn* tree_column, \
GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_widget", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkWidget_(widget) || Xen_is_false(widget), widget, 2, "gtk_tree_view_column_set_widget", "GtkWidget*");
  gtk_tree_view_column_set_widget(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_widget(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_widget "GtkWidget* gtk_tree_view_column_get_widget(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_widget", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkWidget_(gtk_tree_view_column_get_widget(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_alignment(Xen tree_column, Xen xalign)
{
  #define H_gtk_tree_view_column_set_alignment "void gtk_tree_view_column_set_alignment(GtkTreeViewColumn* tree_column, \
gfloat xalign)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_alignment", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_tree_view_column_set_alignment", "gfloat");
  gtk_tree_view_column_set_alignment(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gfloat(xalign));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_alignment(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_alignment "gfloat gtk_tree_view_column_get_alignment(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_alignment", "GtkTreeViewColumn*");
  return(C_to_Xen_gfloat(gtk_tree_view_column_get_alignment(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_reorderable(Xen tree_column, Xen reorderable)
{
  #define H_gtk_tree_view_column_set_reorderable "void gtk_tree_view_column_set_reorderable(GtkTreeViewColumn* tree_column, \
gboolean reorderable)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_reorderable", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 2, "gtk_tree_view_column_set_reorderable", "gboolean");
  gtk_tree_view_column_set_reorderable(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_reorderable(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_reorderable "gboolean gtk_tree_view_column_get_reorderable(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_reorderable", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_reorderable(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sort_column_id(Xen tree_column, Xen sort_column_id)
{
  #define H_gtk_tree_view_column_set_sort_column_id "void gtk_tree_view_column_set_sort_column_id(GtkTreeViewColumn* tree_column, \
gint sort_column_id)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sort_column_id", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(sort_column_id), sort_column_id, 2, "gtk_tree_view_column_set_sort_column_id", "gint");
  gtk_tree_view_column_set_sort_column_id(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gint(sort_column_id));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sort_column_id(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sort_column_id "gint gtk_tree_view_column_get_sort_column_id(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sort_column_id", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_column_get_sort_column_id(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sort_indicator(Xen tree_column, Xen setting)
{
  #define H_gtk_tree_view_column_set_sort_indicator "void gtk_tree_view_column_set_sort_indicator(GtkTreeViewColumn* tree_column, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sort_indicator", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_tree_view_column_set_sort_indicator", "gboolean");
  gtk_tree_view_column_set_sort_indicator(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sort_indicator(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sort_indicator "gboolean gtk_tree_view_column_get_sort_indicator(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sort_indicator", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_sort_indicator(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_set_sort_order(Xen tree_column, Xen order)
{
  #define H_gtk_tree_view_column_set_sort_order "void gtk_tree_view_column_set_sort_order(GtkTreeViewColumn* tree_column, \
GtkSortType order)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_sort_order", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkSortType(order), order, 2, "gtk_tree_view_column_set_sort_order", "GtkSortType");
  gtk_tree_view_column_set_sort_order(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkSortType(order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_sort_order(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_sort_order "GtkSortType gtk_tree_view_column_get_sort_order(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_sort_order", "GtkTreeViewColumn*");
  return(C_to_Xen_GtkSortType(gtk_tree_view_column_get_sort_order(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_cell_set_cell_data(Xen tree_column, Xen tree_model, Xen iter, Xen is_expander, Xen is_expanded)
{
  #define H_gtk_tree_view_column_cell_set_cell_data "void gtk_tree_view_column_cell_set_cell_data(GtkTreeViewColumn* tree_column, \
GtkTreeModel* tree_model, GtkTreeIter* iter, gboolean is_expander, gboolean is_expanded)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_set_cell_data", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 2, "gtk_tree_view_column_cell_set_cell_data", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 3, "gtk_tree_view_column_cell_set_cell_data", "GtkTreeIter*");
  Xen_check_type(Xen_is_gboolean(is_expander), is_expander, 4, "gtk_tree_view_column_cell_set_cell_data", "gboolean");
  Xen_check_type(Xen_is_gboolean(is_expanded), is_expanded, 5, "gtk_tree_view_column_cell_set_cell_data", "gboolean");
  gtk_tree_view_column_cell_set_cell_data(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter), 
                                          Xen_to_C_gboolean(is_expander), Xen_to_C_gboolean(is_expanded));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_cell_get_size(Xen tree_column, Xen cell_area, Xen ignore_x_offset, Xen ignore_y_offset, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_tree_view_column_cell_get_size "void gtk_tree_view_column_cell_get_size(GtkTreeViewColumn* tree_column, \
GdkRectangle* cell_area, gint* [x_offset], gint* [y_offset], gint* [width], gint* [height])"
  gint ref_x_offset;
  gint ref_y_offset;
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_get_size", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GdkRectangle_(cell_area), cell_area, 2, "gtk_tree_view_column_cell_get_size", "GdkRectangle*");
  gtk_tree_view_column_cell_get_size(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GdkRectangle_(cell_area), &ref_x_offset, 
                                     &ref_y_offset, &ref_width, &ref_height);
  return(Xen_list_4(C_to_Xen_gint(ref_x_offset), C_to_Xen_gint(ref_y_offset), C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_tree_view_column_cell_is_visible(Xen tree_column)
{
  #define H_gtk_tree_view_column_cell_is_visible "gboolean gtk_tree_view_column_cell_is_visible(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_is_visible", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_cell_is_visible(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_tree_view_column_cell_get_position(Xen tree_column, Xen cell_renderer, Xen ignore_start_pos, Xen ignore_width)
{
  #define H_gtk_tree_view_column_cell_get_position "gboolean gtk_tree_view_column_cell_get_position(GtkTreeViewColumn* tree_column, \
GtkCellRenderer* cell_renderer, gint* [start_pos], gint* [width])"
  gint ref_start_pos;
  gint ref_width;
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_cell_get_position", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell_renderer), cell_renderer, 2, "gtk_tree_view_column_cell_get_position", "GtkCellRenderer*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_tree_view_column_cell_get_position(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_GtkCellRenderer_(cell_renderer), 
                                                                      &ref_start_pos, &ref_width));
    return(Xen_list_3(result, C_to_Xen_gint(ref_start_pos), C_to_Xen_gint(ref_width)));
   }
}

static Xen gxg_gtk_tree_view_new(void)
{
  #define H_gtk_tree_view_new "GtkWidget* gtk_tree_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_tree_view_new()));
}

static Xen gxg_gtk_tree_view_new_with_model(Xen model)
{
  #define H_gtk_tree_view_new_with_model "GtkWidget* gtk_tree_view_new_with_model(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_tree_view_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_tree_view_new_with_model(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_tree_view_get_model(Xen tree_view)
{
  #define H_gtk_tree_view_get_model "GtkTreeModel* gtk_tree_view_get_model(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_model", "GtkTreeView*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_view_get_model(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_model(Xen tree_view, Xen model)
{
  #define H_gtk_tree_view_set_model "void gtk_tree_view_set_model(GtkTreeView* tree_view, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_model", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_tree_view_set_model", "GtkTreeModel*");
  gtk_tree_view_set_model(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_selection(Xen tree_view)
{
  #define H_gtk_tree_view_get_selection "GtkTreeSelection* gtk_tree_view_get_selection(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_selection", "GtkTreeView*");
  return(C_to_Xen_GtkTreeSelection_(gtk_tree_view_get_selection(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_get_headers_visible(Xen tree_view)
{
  #define H_gtk_tree_view_get_headers_visible "gboolean gtk_tree_view_get_headers_visible(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_headers_visible", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_headers_visible(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_headers_visible(Xen tree_view, Xen headers_visible)
{
  #define H_gtk_tree_view_set_headers_visible "void gtk_tree_view_set_headers_visible(GtkTreeView* tree_view, \
gboolean headers_visible)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_headers_visible", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(headers_visible), headers_visible, 2, "gtk_tree_view_set_headers_visible", "gboolean");
  gtk_tree_view_set_headers_visible(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(headers_visible));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_columns_autosize(Xen tree_view)
{
  #define H_gtk_tree_view_columns_autosize "void gtk_tree_view_columns_autosize(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_columns_autosize", "GtkTreeView*");
  gtk_tree_view_columns_autosize(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_headers_clickable(Xen tree_view, Xen setting)
{
  #define H_gtk_tree_view_set_headers_clickable "void gtk_tree_view_set_headers_clickable(GtkTreeView* tree_view, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_headers_clickable", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_tree_view_set_headers_clickable", "gboolean");
  gtk_tree_view_set_headers_clickable(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_append_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_append_column "gint gtk_tree_view_append_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_append_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_append_column", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_append_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column))));
}

static Xen gxg_gtk_tree_view_remove_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_remove_column "gint gtk_tree_view_remove_column(GtkTreeView* tree_view, GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_remove_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_remove_column", "GtkTreeViewColumn*");
  return(C_to_Xen_gint(gtk_tree_view_remove_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column))));
}

static Xen gxg_gtk_tree_view_insert_column(Xen tree_view, Xen column, Xen position)
{
  #define H_gtk_tree_view_insert_column "gint gtk_tree_view_insert_column(GtkTreeView* tree_view, GtkTreeViewColumn* column, \
gint position)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_insert_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_insert_column", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_tree_view_insert_column", "gint");
  return(C_to_Xen_gint(gtk_tree_view_insert_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column), 
                                                   Xen_to_C_gint(position))));
}

static Xen gxg_gtk_tree_view_insert_column_with_attributes(Xen tree_view, Xen position, Xen title, Xen cell, Xen attributes)
{
  #define H_gtk_tree_view_insert_column_with_attributes "gint gtk_tree_view_insert_column_with_attributes(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, etc attributes)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_insert_column_with_attributes", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_tree_view_insert_column_with_attributes", "gint");
  Xen_check_type(Xen_is_gchar_(title), title, 3, "gtk_tree_view_insert_column_with_attributes", "gchar*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 4, "gtk_tree_view_insert_column_with_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 5, "gtk_tree_view_insert_column_with_attributes", "etc");
  {
    int etc_len = 0;
    gint result = 0;
    GtkTreeView* p_arg0;
    gint p_arg1;
    gchar* p_arg2;
    GtkCellRenderer* p_arg3;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_tree_view_insert_column_with_attributes", 4, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkTreeView_(tree_view);
    p_arg1 = Xen_to_C_gint(position);
    p_arg2 = Xen_to_C_gchar_(title);
    p_arg3 = Xen_to_C_GtkCellRenderer_(cell);
    switch (etc_len)
      {
        case 2: result = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: result = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: result = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: result = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: result = gtk_tree_view_insert_column_with_attributes(p_arg0, p_arg1, p_arg2, p_arg3, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(C_to_Xen_gint(result));
  }
}

static Xen gxg_gtk_tree_view_insert_column_with_data_func(Xen tree_view, Xen position, Xen title, Xen cell, Xen func, Xen func_info, Xen dnotify)
{
  #define H_gtk_tree_view_insert_column_with_data_func "gint gtk_tree_view_insert_column_with_data_func(GtkTreeView* tree_view, \
gint position, gchar* title, GtkCellRenderer* cell, GtkTreeCellDataFunc func, lambda_data func_info, \
GtkDestroyNotify dnotify)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_insert_column_with_data_func", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(position), position, 2, "gtk_tree_view_insert_column_with_data_func", "gint");
  Xen_check_type(Xen_is_gchar_(title), title, 3, "gtk_tree_view_insert_column_with_data_func", "gchar*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 4, "gtk_tree_view_insert_column_with_data_func", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkTreeCellDataFunc(func), func, 5, "gtk_tree_view_insert_column_with_data_func", "GtkTreeCellDataFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 6, "gtk_tree_view_insert_column_with_data_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(dnotify), dnotify, 7, "gtk_tree_view_insert_column_with_data_func", "GtkDestroyNotify");
  {
    Xen result;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, dnotify);
    result = C_to_Xen_gint(gtk_tree_view_insert_column_with_data_func(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(position), 
                                                                      Xen_to_C_gchar_(title), Xen_to_C_GtkCellRenderer_(cell), 
                                                                      Xen_to_C_GtkTreeCellDataFunc(func), Xen_to_C_lambda_data(func_info), 
                                                                      Xen_to_C_GtkDestroyNotify(dnotify)));
    return(result);
   }
}

static Xen gxg_gtk_tree_view_get_column(Xen tree_view, Xen n)
{
  #define H_gtk_tree_view_get_column "GtkTreeViewColumn* gtk_tree_view_get_column(GtkTreeView* tree_view, \
gint n)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_column", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(n), n, 2, "gtk_tree_view_get_column", "gint");
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_get_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(n))));
}

static Xen gxg_gtk_tree_view_get_columns(Xen tree_view)
{
  #define H_gtk_tree_view_get_columns "GList* gtk_tree_view_get_columns(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_columns", "GtkTreeView*");
  return(C_to_Xen_GList_(gtk_tree_view_get_columns(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_move_column_after(Xen tree_view, Xen column, Xen base_column)
{
  #define H_gtk_tree_view_move_column_after "void gtk_tree_view_move_column_after(GtkTreeView* tree_view, \
GtkTreeViewColumn* column, GtkTreeViewColumn* base_column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_move_column_after", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 2, "gtk_tree_view_move_column_after", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(base_column) || Xen_is_false(base_column), base_column, 3, "gtk_tree_view_move_column_after", "GtkTreeViewColumn*");
  gtk_tree_view_move_column_after(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column), Xen_to_C_GtkTreeViewColumn_(base_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_expander_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_set_expander_column "void gtk_tree_view_set_expander_column(GtkTreeView* tree_view, \
GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_expander_column", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 2, "gtk_tree_view_set_expander_column", "GtkTreeViewColumn*");
  gtk_tree_view_set_expander_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumn_(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_expander_column(Xen tree_view)
{
  #define H_gtk_tree_view_get_expander_column "GtkTreeViewColumn* gtk_tree_view_get_expander_column(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_expander_column", "GtkTreeView*");
  return(C_to_Xen_GtkTreeViewColumn_(gtk_tree_view_get_expander_column(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_column_drag_function(Xen tree_view, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_view_set_column_drag_function "void gtk_tree_view_set_column_drag_function(GtkTreeView* tree_view, \
GtkTreeViewColumnDropFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_column_drag_function", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewColumnDropFunc(func), func, 2, "gtk_tree_view_set_column_drag_function", "GtkTreeViewColumnDropFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_view_set_column_drag_function", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_view_set_column_drag_function", "GtkDestroyNotify");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_view_set_column_drag_function(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewColumnDropFunc(func), Xen_to_C_lambda_data(func_info), 
                                       Xen_to_C_GtkDestroyNotify(destroy));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_view_scroll_to_point(Xen tree_view, Xen tree_x, Xen tree_y)
{
  #define H_gtk_tree_view_scroll_to_point "void gtk_tree_view_scroll_to_point(GtkTreeView* tree_view, \
gint tree_x, gint tree_y)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_scroll_to_point", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(tree_x), tree_x, 2, "gtk_tree_view_scroll_to_point", "gint");
  Xen_check_type(Xen_is_gint(tree_y), tree_y, 3, "gtk_tree_view_scroll_to_point", "gint");
  gtk_tree_view_scroll_to_point(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(tree_x), Xen_to_C_gint(tree_y));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_scroll_to_cell(Xen tree_view, Xen path, Xen column, Xen use_align, Xen row_align, Xen col_align)
{
  #define H_gtk_tree_view_scroll_to_cell "void gtk_tree_view_scroll_to_cell(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, gboolean use_align, gfloat row_align, gfloat col_align)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_scroll_to_cell", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path) || Xen_is_false(path), path, 2, "gtk_tree_view_scroll_to_cell", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 3, "gtk_tree_view_scroll_to_cell", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 4, "gtk_tree_view_scroll_to_cell", "gboolean");
  Xen_check_type(Xen_is_gfloat(row_align), row_align, 5, "gtk_tree_view_scroll_to_cell", "gfloat");
  Xen_check_type(Xen_is_gfloat(col_align), col_align, 6, "gtk_tree_view_scroll_to_cell", "gfloat");
  gtk_tree_view_scroll_to_cell(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column), 
                               Xen_to_C_gboolean(use_align), Xen_to_C_gfloat(row_align), Xen_to_C_gfloat(col_align));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_row_activated(Xen tree_view, Xen path, Xen column)
{
  #define H_gtk_tree_view_row_activated "void gtk_tree_view_row_activated(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_row_activated", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_row_activated", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column), column, 3, "gtk_tree_view_row_activated", "GtkTreeViewColumn*");
  gtk_tree_view_row_activated(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_expand_all(Xen tree_view)
{
  #define H_gtk_tree_view_expand_all "void gtk_tree_view_expand_all(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_expand_all", "GtkTreeView*");
  gtk_tree_view_expand_all(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_collapse_all(Xen tree_view)
{
  #define H_gtk_tree_view_collapse_all "void gtk_tree_view_collapse_all(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_collapse_all", "GtkTreeView*");
  gtk_tree_view_collapse_all(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_expand_row(Xen tree_view, Xen path, Xen open_all)
{
  #define H_gtk_tree_view_expand_row "gboolean gtk_tree_view_expand_row(GtkTreeView* tree_view, GtkTreePath* path, \
gboolean open_all)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_expand_row", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_expand_row", "GtkTreePath*");
  Xen_check_type(Xen_is_gboolean(open_all), open_all, 3, "gtk_tree_view_expand_row", "gboolean");
  return(C_to_Xen_gboolean(gtk_tree_view_expand_row(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_gboolean(open_all))));
}

static Xen gxg_gtk_tree_view_collapse_row(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_collapse_row "gboolean gtk_tree_view_collapse_row(GtkTreeView* tree_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_collapse_row", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_collapse_row", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_view_collapse_row(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_view_map_expanded_rows(Xen tree_view, Xen func, Xen func_info)
{
  #define H_gtk_tree_view_map_expanded_rows "void gtk_tree_view_map_expanded_rows(GtkTreeView* tree_view, \
GtkTreeViewMappingFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_map_expanded_rows", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewMappingFunc(func), func, 2, "gtk_tree_view_map_expanded_rows", "GtkTreeViewMappingFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_view_map_expanded_rows", "lambda_data");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    gtk_tree_view_map_expanded_rows(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewMappingFunc(func), Xen_to_C_lambda_data(func_info));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_tree_view_row_expanded(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_row_expanded "gboolean gtk_tree_view_row_expanded(GtkTreeView* tree_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_row_expanded", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_row_expanded", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_tree_view_row_expanded(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_tree_view_set_reorderable(Xen tree_view, Xen reorderable)
{
  #define H_gtk_tree_view_set_reorderable "void gtk_tree_view_set_reorderable(GtkTreeView* tree_view, \
gboolean reorderable)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_reorderable", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 2, "gtk_tree_view_set_reorderable", "gboolean");
  gtk_tree_view_set_reorderable(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_reorderable(Xen tree_view)
{
  #define H_gtk_tree_view_get_reorderable "gboolean gtk_tree_view_get_reorderable(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_reorderable", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_reorderable(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_cursor(Xen tree_view, Xen path, Xen focus_column, Xen start_editing)
{
  #define H_gtk_tree_view_set_cursor "void gtk_tree_view_set_cursor(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* focus_column, gboolean start_editing)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_cursor", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_set_cursor", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(focus_column), focus_column, 3, "gtk_tree_view_set_cursor", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(start_editing), start_editing, 4, "gtk_tree_view_set_cursor", "gboolean");
  gtk_tree_view_set_cursor(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(focus_column), 
                           Xen_to_C_gboolean(start_editing));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_cursor(Xen tree_view, Xen ignore_path, Xen ignore_focus_column)
{
  #define H_gtk_tree_view_get_cursor "void gtk_tree_view_get_cursor(GtkTreeView* tree_view, GtkTreePath** [path], \
GtkTreeViewColumn** [focus_column])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_focus_column = NULL;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_cursor", "GtkTreeView*");
  gtk_tree_view_get_cursor(Xen_to_C_GtkTreeView_(tree_view), &ref_path, &ref_focus_column);
  return(Xen_list_2(C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewColumn_(ref_focus_column)));
}

static Xen gxg_gtk_tree_view_get_path_at_pos(Xen tree_view, Xen x, Xen y, Xen ignore_path, Xen ignore_column, Xen ignore_cell_x, Xen ignore_cell_y)
{
  #define H_gtk_tree_view_get_path_at_pos "gboolean gtk_tree_view_get_path_at_pos(GtkTreeView* tree_view, \
gint x, gint y, GtkTreePath** [path], GtkTreeViewColumn** [column], gint* [cell_x], gint* [cell_y])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewColumn* ref_column = NULL;
  gint ref_cell_x;
  gint ref_cell_y;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_path_at_pos", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_tree_view_get_path_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_tree_view_get_path_at_pos", "gint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_tree_view_get_path_at_pos(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(x), Xen_to_C_gint(y), 
                                                             &ref_path, &ref_column, &ref_cell_x, &ref_cell_y));
    return(Xen_list_5(result, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewColumn_(ref_column), C_to_Xen_gint(ref_cell_x), C_to_Xen_gint(ref_cell_y)));
   }
}

static Xen gxg_gtk_tree_view_get_cell_area(Xen tree_view, Xen path, Xen column, Xen rect)
{
  #define H_gtk_tree_view_get_cell_area "void gtk_tree_view_get_cell_area(GtkTreeView* tree_view, GtkTreePath* path, \
GtkTreeViewColumn* column, GdkRectangle* rect)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_cell_area", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path) || Xen_is_false(path), path, 2, "gtk_tree_view_get_cell_area", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 3, "gtk_tree_view_get_cell_area", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 4, "gtk_tree_view_get_cell_area", "GdkRectangle*");
  gtk_tree_view_get_cell_area(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column), 
                              Xen_to_C_GdkRectangle_(rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_background_area(Xen tree_view, Xen path, Xen column, Xen rect)
{
  #define H_gtk_tree_view_get_background_area "void gtk_tree_view_get_background_area(GtkTreeView* tree_view, \
GtkTreePath* path, GtkTreeViewColumn* column, GdkRectangle* rect)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_background_area", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path) || Xen_is_false(path), path, 2, "gtk_tree_view_get_background_area", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewColumn_(column) || Xen_is_false(column), column, 3, "gtk_tree_view_get_background_area", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_GdkRectangle_(rect), rect, 4, "gtk_tree_view_get_background_area", "GdkRectangle*");
  gtk_tree_view_get_background_area(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewColumn_(column), 
                                    Xen_to_C_GdkRectangle_(rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_visible_rect(Xen tree_view, Xen visible_rect)
{
  #define H_gtk_tree_view_get_visible_rect "void gtk_tree_view_get_visible_rect(GtkTreeView* tree_view, \
GdkRectangle* visible_rect)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_visible_rect", "GtkTreeView*");
  Xen_check_type(Xen_is_GdkRectangle_(visible_rect), visible_rect, 2, "gtk_tree_view_get_visible_rect", "GdkRectangle*");
  gtk_tree_view_get_visible_rect(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GdkRectangle_(visible_rect));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_unset_rows_drag_source(Xen tree_view)
{
  #define H_gtk_tree_view_unset_rows_drag_source "void gtk_tree_view_unset_rows_drag_source(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_unset_rows_drag_source", "GtkTreeView*");
  gtk_tree_view_unset_rows_drag_source(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_unset_rows_drag_dest(Xen tree_view)
{
  #define H_gtk_tree_view_unset_rows_drag_dest "void gtk_tree_view_unset_rows_drag_dest(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_unset_rows_drag_dest", "GtkTreeView*");
  gtk_tree_view_unset_rows_drag_dest(Xen_to_C_GtkTreeView_(tree_view));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_set_drag_dest_row(Xen tree_view, Xen path, Xen pos)
{
  #define H_gtk_tree_view_set_drag_dest_row "void gtk_tree_view_set_drag_dest_row(GtkTreeView* tree_view, \
GtkTreePath* path, GtkTreeViewDropPosition pos)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_drag_dest_row", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_set_drag_dest_row", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkTreeViewDropPosition(pos), pos, 3, "gtk_tree_view_set_drag_dest_row", "GtkTreeViewDropPosition");
  gtk_tree_view_set_drag_dest_row(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkTreeViewDropPosition(pos));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_drag_dest_row(Xen tree_view, Xen ignore_path, Xen ignore_pos)
{
  #define H_gtk_tree_view_get_drag_dest_row "void gtk_tree_view_get_drag_dest_row(GtkTreeView* tree_view, \
GtkTreePath** [path], GtkTreeViewDropPosition* [pos])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewDropPosition ref_pos;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_drag_dest_row", "GtkTreeView*");
  gtk_tree_view_get_drag_dest_row(Xen_to_C_GtkTreeView_(tree_view), &ref_path, &ref_pos);
  return(Xen_list_2(C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewDropPosition(ref_pos)));
}

static Xen gxg_gtk_tree_view_get_dest_row_at_pos(Xen tree_view, Xen drag_x, Xen drag_y, Xen ignore_path, Xen ignore_pos)
{
  #define H_gtk_tree_view_get_dest_row_at_pos "gboolean gtk_tree_view_get_dest_row_at_pos(GtkTreeView* tree_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkTreeViewDropPosition* [pos])"
  GtkTreePath* ref_path = NULL;
  GtkTreeViewDropPosition ref_pos;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_dest_row_at_pos", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(drag_x), drag_x, 2, "gtk_tree_view_get_dest_row_at_pos", "gint");
  Xen_check_type(Xen_is_gint(drag_y), drag_y, 3, "gtk_tree_view_get_dest_row_at_pos", "gint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_tree_view_get_dest_row_at_pos(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(drag_x), 
                                                                 Xen_to_C_gint(drag_y), &ref_path, &ref_pos));
    return(Xen_list_3(result, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkTreeViewDropPosition(ref_pos)));
   }
}

static Xen gxg_gtk_tree_view_set_enable_search(Xen tree_view, Xen enable_search)
{
  #define H_gtk_tree_view_set_enable_search "void gtk_tree_view_set_enable_search(GtkTreeView* tree_view, \
gboolean enable_search)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_enable_search", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enable_search), enable_search, 2, "gtk_tree_view_set_enable_search", "gboolean");
  gtk_tree_view_set_enable_search(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enable_search));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_enable_search(Xen tree_view)
{
  #define H_gtk_tree_view_get_enable_search "gboolean gtk_tree_view_get_enable_search(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_enable_search", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_enable_search(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_get_search_column(Xen tree_view)
{
  #define H_gtk_tree_view_get_search_column "gint gtk_tree_view_get_search_column(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_search_column", "GtkTreeView*");
  return(C_to_Xen_gint(gtk_tree_view_get_search_column(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_search_column(Xen tree_view, Xen column)
{
  #define H_gtk_tree_view_set_search_column "void gtk_tree_view_set_search_column(GtkTreeView* tree_view, \
gint column)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_search_column", "GtkTreeView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_tree_view_set_search_column", "gint");
  gtk_tree_view_set_search_column(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_search_equal_func(Xen tree_view)
{
  #define H_gtk_tree_view_get_search_equal_func "GtkTreeViewSearchEqualFunc gtk_tree_view_get_search_equal_func(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_search_equal_func", "GtkTreeView*");
  return(C_to_Xen_GtkTreeViewSearchEqualFunc(gtk_tree_view_get_search_equal_func(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_search_equal_func(Xen tree_view, Xen func, Xen func_info, Xen search_destroy)
{
  #define H_gtk_tree_view_set_search_equal_func "void gtk_tree_view_set_search_equal_func(GtkTreeView* tree_view, \
GtkTreeViewSearchEqualFunc func, lambda_data func_info, GtkDestroyNotify search_destroy)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_search_equal_func", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewSearchEqualFunc(func), func, 2, "gtk_tree_view_set_search_equal_func", "GtkTreeViewSearchEqualFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_view_set_search_equal_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(search_destroy), search_destroy, 4, "gtk_tree_view_set_search_equal_func", "GtkDestroyNotify");
  {
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, search_destroy);
    gtk_tree_view_set_search_equal_func(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewSearchEqualFunc(func), Xen_to_C_lambda_data(func_info), 
                                    Xen_to_C_GtkDestroyNotify(search_destroy));
    xm_unprotect_at(loc);
    return(Xen_false);
   }
}

static Xen gxg_gtk_viewport_new(Xen hadjustment, Xen vadjustment)
{
  #define H_gtk_viewport_new "GtkWidget* gtk_viewport_new(GtkAdjustment* hadjustment, GtkAdjustment* vadjustment)"
  Xen_check_type(Xen_is_GtkAdjustment_(hadjustment) || Xen_is_false(hadjustment), hadjustment, 1, "gtk_viewport_new", "GtkAdjustment*");
  Xen_check_type(Xen_is_GtkAdjustment_(vadjustment) || Xen_is_false(vadjustment), vadjustment, 2, "gtk_viewport_new", "GtkAdjustment*");
  return(C_to_Xen_GtkWidget_(gtk_viewport_new(Xen_to_C_GtkAdjustment_(hadjustment), Xen_to_C_GtkAdjustment_(vadjustment))));
}

static Xen gxg_gtk_viewport_set_shadow_type(Xen viewport, Xen type)
{
  #define H_gtk_viewport_set_shadow_type "void gtk_viewport_set_shadow_type(GtkViewport* viewport, GtkShadowType type)"
  Xen_check_type(Xen_is_GtkViewport_(viewport), viewport, 1, "gtk_viewport_set_shadow_type", "GtkViewport*");
  Xen_check_type(Xen_is_GtkShadowType(type), type, 2, "gtk_viewport_set_shadow_type", "GtkShadowType");
  gtk_viewport_set_shadow_type(Xen_to_C_GtkViewport_(viewport), Xen_to_C_GtkShadowType(type));
  return(Xen_false);
}

static Xen gxg_gtk_viewport_get_shadow_type(Xen viewport)
{
  #define H_gtk_viewport_get_shadow_type "GtkShadowType gtk_viewport_get_shadow_type(GtkViewport* viewport)"
  Xen_check_type(Xen_is_GtkViewport_(viewport), viewport, 1, "gtk_viewport_get_shadow_type", "GtkViewport*");
  return(C_to_Xen_GtkShadowType(gtk_viewport_get_shadow_type(Xen_to_C_GtkViewport_(viewport))));
}

static Xen gxg_gtk_widget_destroy(Xen widget)
{
  #define H_gtk_widget_destroy "void gtk_widget_destroy(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_destroy", "GtkWidget*");
  gtk_widget_destroy(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_destroyed(Xen widget, Xen ignore_widget_pointer)
{
  #define H_gtk_widget_destroyed "void gtk_widget_destroyed(GtkWidget* widget, GtkWidget** [widget_pointer])"
  GtkWidget* ref_widget_pointer = NULL;
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_destroyed", "GtkWidget*");
  gtk_widget_destroyed(Xen_to_C_GtkWidget_(widget), &ref_widget_pointer);
  return(Xen_list_1(C_to_Xen_GtkWidget_(ref_widget_pointer)));
}

static Xen gxg_gtk_widget_unparent(Xen widget)
{
  #define H_gtk_widget_unparent "void gtk_widget_unparent(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_unparent", "GtkWidget*");
  gtk_widget_unparent(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_show(Xen widget)
{
  #define H_gtk_widget_show "void gtk_widget_show(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_show", "GtkWidget*");
  gtk_widget_show(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_show_now(Xen widget)
{
  #define H_gtk_widget_show_now "void gtk_widget_show_now(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_show_now", "GtkWidget*");
  gtk_widget_show_now(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_hide(Xen widget)
{
  #define H_gtk_widget_hide "void gtk_widget_hide(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_hide", "GtkWidget*");
  gtk_widget_hide(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_map(Xen widget)
{
  #define H_gtk_widget_map "void gtk_widget_map(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_map", "GtkWidget*");
  gtk_widget_map(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_unmap(Xen widget)
{
  #define H_gtk_widget_unmap "void gtk_widget_unmap(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_unmap", "GtkWidget*");
  gtk_widget_unmap(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_realize(Xen widget)
{
  #define H_gtk_widget_realize "void gtk_widget_realize(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_realize", "GtkWidget*");
  gtk_widget_realize(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_unrealize(Xen widget)
{
  #define H_gtk_widget_unrealize "void gtk_widget_unrealize(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_unrealize", "GtkWidget*");
  gtk_widget_unrealize(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_queue_draw(Xen widget)
{
  #define H_gtk_widget_queue_draw "void gtk_widget_queue_draw(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_queue_draw", "GtkWidget*");
  gtk_widget_queue_draw(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_queue_draw_area(Xen widget, Xen x, Xen y, Xen width, Xen height)
{
  #define H_gtk_widget_queue_draw_area "void gtk_widget_queue_draw_area(GtkWidget* widget, gint x, gint y, \
gint width, gint height)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_queue_draw_area", "GtkWidget*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_widget_queue_draw_area", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_widget_queue_draw_area", "gint");
  Xen_check_type(Xen_is_gint(width), width, 4, "gtk_widget_queue_draw_area", "gint");
  Xen_check_type(Xen_is_gint(height), height, 5, "gtk_widget_queue_draw_area", "gint");
  gtk_widget_queue_draw_area(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(x), Xen_to_C_gint(y), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_widget_queue_resize(Xen widget)
{
  #define H_gtk_widget_queue_resize "void gtk_widget_queue_resize(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_queue_resize", "GtkWidget*");
  gtk_widget_queue_resize(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_add_accelerator(Xen widget, Xen accel_signal, Xen accel_group, Xen accel_key, Xen accel_mods, Xen accel_flags)
{
  #define H_gtk_widget_add_accelerator "void gtk_widget_add_accelerator(GtkWidget* widget, gchar* accel_signal, \
GtkAccelGroup* accel_group, guint accel_key, GdkModifierType accel_mods, GtkAccelFlags accel_flags)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_add_accelerator", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(accel_signal), accel_signal, 2, "gtk_widget_add_accelerator", "gchar*");
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 3, "gtk_widget_add_accelerator", "GtkAccelGroup*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 4, "gtk_widget_add_accelerator", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 5, "gtk_widget_add_accelerator", "GdkModifierType");
  Xen_check_type(Xen_is_GtkAccelFlags(accel_flags), accel_flags, 6, "gtk_widget_add_accelerator", "GtkAccelFlags");
  gtk_widget_add_accelerator(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(accel_signal), Xen_to_C_GtkAccelGroup_(accel_group), 
                             Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods), Xen_to_C_GtkAccelFlags(accel_flags));
  return(Xen_false);
}

static Xen gxg_gtk_widget_remove_accelerator(Xen widget, Xen accel_group, Xen accel_key, Xen accel_mods)
{
  #define H_gtk_widget_remove_accelerator "gboolean gtk_widget_remove_accelerator(GtkWidget* widget, \
GtkAccelGroup* accel_group, guint accel_key, GdkModifierType accel_mods)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_remove_accelerator", "GtkWidget*");
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 2, "gtk_widget_remove_accelerator", "GtkAccelGroup*");
  Xen_check_type(Xen_is_guint(accel_key), accel_key, 3, "gtk_widget_remove_accelerator", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accel_mods), accel_mods, 4, "gtk_widget_remove_accelerator", "GdkModifierType");
  return(C_to_Xen_gboolean(gtk_widget_remove_accelerator(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkAccelGroup_(accel_group), 
                                                         Xen_to_C_guint(accel_key), Xen_to_C_GdkModifierType(accel_mods))));
}

static Xen gxg_gtk_widget_list_accel_closures(Xen widget)
{
  #define H_gtk_widget_list_accel_closures "GList* gtk_widget_list_accel_closures(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_list_accel_closures", "GtkWidget*");
  return(C_to_Xen_GList_(gtk_widget_list_accel_closures(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_mnemonic_activate(Xen widget, Xen group_cycling)
{
  #define H_gtk_widget_mnemonic_activate "gboolean gtk_widget_mnemonic_activate(GtkWidget* widget, gboolean group_cycling)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_mnemonic_activate", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(group_cycling), group_cycling, 2, "gtk_widget_mnemonic_activate", "gboolean");
  return(C_to_Xen_gboolean(gtk_widget_mnemonic_activate(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(group_cycling))));
}

static Xen gxg_gtk_widget_event(Xen widget, Xen event)
{
  #define H_gtk_widget_event "gboolean gtk_widget_event(GtkWidget* widget, GdkEvent* event)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_event", "GtkWidget*");
  Xen_check_type(Xen_is_GdkEvent_(event), event, 2, "gtk_widget_event", "GdkEvent*");
  return(C_to_Xen_gboolean(gtk_widget_event(Xen_to_C_GtkWidget_(widget), Xen_to_C_GdkEvent_(event))));
}

static Xen gxg_gtk_widget_activate(Xen widget)
{
  #define H_gtk_widget_activate "gboolean gtk_widget_activate(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_activate", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_activate(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_intersect(Xen widget, Xen area, Xen intersection)
{
  #define H_gtk_widget_intersect "gboolean gtk_widget_intersect(GtkWidget* widget, GdkRectangle* area, \
GdkRectangle* intersection)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_intersect", "GtkWidget*");
  Xen_check_type(Xen_is_GdkRectangle_(area), area, 2, "gtk_widget_intersect", "GdkRectangle*");
  Xen_check_type(Xen_is_GdkRectangle_(intersection) || Xen_is_false(intersection), intersection, 3, "gtk_widget_intersect", "GdkRectangle*");
  return(C_to_Xen_gboolean(gtk_widget_intersect(Xen_to_C_GtkWidget_(widget), Xen_to_C_GdkRectangle_(area), Xen_to_C_GdkRectangle_(intersection))));
}

static Xen gxg_gtk_widget_freeze_child_notify(Xen widget)
{
  #define H_gtk_widget_freeze_child_notify "void gtk_widget_freeze_child_notify(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_freeze_child_notify", "GtkWidget*");
  gtk_widget_freeze_child_notify(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_child_notify(Xen widget, Xen child_property)
{
  #define H_gtk_widget_child_notify "void gtk_widget_child_notify(GtkWidget* widget, gchar* child_property)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_child_notify", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(child_property), child_property, 2, "gtk_widget_child_notify", "gchar*");
  gtk_widget_child_notify(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(child_property));
  return(Xen_false);
}

static Xen gxg_gtk_widget_thaw_child_notify(Xen widget)
{
  #define H_gtk_widget_thaw_child_notify "void gtk_widget_thaw_child_notify(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_thaw_child_notify", "GtkWidget*");
  gtk_widget_thaw_child_notify(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_is_focus(Xen widget)
{
  #define H_gtk_widget_is_focus "gboolean gtk_widget_is_focus(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_is_focus", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_is_focus(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_grab_focus(Xen widget)
{
  #define H_gtk_widget_grab_focus "void gtk_widget_grab_focus(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_grab_focus", "GtkWidget*");
  gtk_widget_grab_focus(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_grab_default(Xen widget)
{
  #define H_gtk_widget_grab_default "void gtk_widget_grab_default(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_grab_default", "GtkWidget*");
  gtk_widget_grab_default(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_name(Xen widget, Xen name)
{
  #define H_gtk_widget_set_name "void gtk_widget_set_name(GtkWidget* widget, gchar* name)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_name", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_widget_set_name", "gchar*");
  gtk_widget_set_name(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_name(Xen widget)
{
  #define H_gtk_widget_get_name "gchar* gtk_widget_get_name(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_name", "GtkWidget*");
  return(C_to_Xen_gchar_(gtk_widget_get_name(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_sensitive(Xen widget, Xen sensitive)
{
  #define H_gtk_widget_set_sensitive "void gtk_widget_set_sensitive(GtkWidget* widget, gboolean sensitive)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_sensitive", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(sensitive), sensitive, 2, "gtk_widget_set_sensitive", "gboolean");
  gtk_widget_set_sensitive(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(sensitive));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_parent(Xen widget, Xen parent)
{
  #define H_gtk_widget_set_parent "void gtk_widget_set_parent(GtkWidget* widget, GtkWidget* parent)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_parent", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(parent), parent, 2, "gtk_widget_set_parent", "GtkWidget*");
  gtk_widget_set_parent(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_parent_window(Xen widget, Xen parent_window)
{
  #define H_gtk_widget_set_parent_window "void gtk_widget_set_parent_window(GtkWidget* widget, GdkWindow* parent_window)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_parent_window", "GtkWidget*");
  Xen_check_type(Xen_is_GdkWindow_(parent_window), parent_window, 2, "gtk_widget_set_parent_window", "GdkWindow*");
  gtk_widget_set_parent_window(Xen_to_C_GtkWidget_(widget), Xen_to_C_GdkWindow_(parent_window));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_child_visible(Xen widget, Xen is_visible)
{
  #define H_gtk_widget_set_child_visible "void gtk_widget_set_child_visible(GtkWidget* widget, gboolean is_visible)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_child_visible", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(is_visible), is_visible, 2, "gtk_widget_set_child_visible", "gboolean");
  gtk_widget_set_child_visible(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(is_visible));
  return(Xen_false);
}

static Xen gxg_gtk_widget_set_accel_path(Xen widget, Xen accel_path, Xen accel_group)
{
  #define H_gtk_widget_set_accel_path "void gtk_widget_set_accel_path(GtkWidget* widget, gchar* accel_path, \
GtkAccelGroup* accel_group)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_accel_path", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(accel_path), accel_path, 2, "gtk_widget_set_accel_path", "gchar*");
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 3, "gtk_widget_set_accel_path", "GtkAccelGroup*");
  gtk_widget_set_accel_path(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(accel_path), Xen_to_C_GtkAccelGroup_(accel_group));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_child_visible(Xen widget)
{
  #define H_gtk_widget_get_child_visible "gboolean gtk_widget_get_child_visible(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_child_visible", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_get_child_visible(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_parent(Xen widget)
{
  #define H_gtk_widget_get_parent "GtkWidget* gtk_widget_get_parent(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_parent", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_widget_get_parent(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_parent_window(Xen widget)
{
  #define H_gtk_widget_get_parent_window "GdkWindow* gtk_widget_get_parent_window(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_parent_window", "GtkWidget*");
  return(C_to_Xen_GdkWindow_(gtk_widget_get_parent_window(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_child_focus(Xen widget, Xen direction)
{
  #define H_gtk_widget_child_focus "gboolean gtk_widget_child_focus(GtkWidget* widget, GtkDirectionType direction)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_child_focus", "GtkWidget*");
  Xen_check_type(Xen_is_GtkDirectionType(direction), direction, 2, "gtk_widget_child_focus", "GtkDirectionType");
  return(C_to_Xen_gboolean(gtk_widget_child_focus(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkDirectionType(direction))));
}

static Xen gxg_gtk_widget_set_size_request(Xen widget, Xen width, Xen height)
{
  #define H_gtk_widget_set_size_request "void gtk_widget_set_size_request(GtkWidget* widget, gint width, \
gint height)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_size_request", "GtkWidget*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_widget_set_size_request", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_widget_set_size_request", "gint");
  gtk_widget_set_size_request(Xen_to_C_GtkWidget_(widget), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_size_request(Xen widget, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_widget_get_size_request "void gtk_widget_get_size_request(GtkWidget* widget, gint* [width], \
gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_size_request", "GtkWidget*");
  gtk_widget_get_size_request(Xen_to_C_GtkWidget_(widget), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_widget_get_toplevel(Xen widget)
{
  #define H_gtk_widget_get_toplevel "GtkWidget* gtk_widget_get_toplevel(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_toplevel", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_widget_get_toplevel(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_ancestor(Xen widget, Xen widget_type)
{
  #define H_gtk_widget_get_ancestor "GtkWidget* gtk_widget_get_ancestor(GtkWidget* widget, GType widget_type)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_ancestor", "GtkWidget*");
  Xen_check_type(Xen_is_GType(widget_type), widget_type, 2, "gtk_widget_get_ancestor", "GType");
  return(C_to_Xen_GtkWidget_(gtk_widget_get_ancestor(Xen_to_C_GtkWidget_(widget), Xen_to_C_GType(widget_type))));
}

static Xen gxg_gtk_widget_get_settings(Xen widget)
{
  #define H_gtk_widget_get_settings "GtkSettings* gtk_widget_get_settings(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_settings", "GtkWidget*");
  return(C_to_Xen_GtkSettings_(gtk_widget_get_settings(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_accessible(Xen widget)
{
  #define H_gtk_widget_get_accessible "AtkObject* gtk_widget_get_accessible(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_accessible", "GtkWidget*");
  return(C_to_Xen_AtkObject_(gtk_widget_get_accessible(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_is_ancestor(Xen widget, Xen ancestor)
{
  #define H_gtk_widget_is_ancestor "gboolean gtk_widget_is_ancestor(GtkWidget* widget, GtkWidget* ancestor)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_is_ancestor", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(ancestor), ancestor, 2, "gtk_widget_is_ancestor", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_is_ancestor(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(ancestor))));
}

static Xen gxg_gtk_widget_translate_coordinates(Xen src_widget, Xen dest_widget, Xen src_x, Xen src_y, Xen ignore_dest_x, Xen ignore_dest_y)
{
  #define H_gtk_widget_translate_coordinates "gboolean gtk_widget_translate_coordinates(GtkWidget* src_widget, \
GtkWidget* dest_widget, gint src_x, gint src_y, gint* [dest_x], gint* [dest_y])"
  gint ref_dest_x;
  gint ref_dest_y;
  Xen_check_type(Xen_is_GtkWidget_(src_widget), src_widget, 1, "gtk_widget_translate_coordinates", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(dest_widget), dest_widget, 2, "gtk_widget_translate_coordinates", "GtkWidget*");
  Xen_check_type(Xen_is_gint(src_x), src_x, 3, "gtk_widget_translate_coordinates", "gint");
  Xen_check_type(Xen_is_gint(src_y), src_y, 4, "gtk_widget_translate_coordinates", "gint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_widget_translate_coordinates(Xen_to_C_GtkWidget_(src_widget), Xen_to_C_GtkWidget_(dest_widget), 
                                                                Xen_to_C_gint(src_x), Xen_to_C_gint(src_y), &ref_dest_x, 
                                                                &ref_dest_y));
    return(Xen_list_3(result, C_to_Xen_gint(ref_dest_x), C_to_Xen_gint(ref_dest_y)));
   }
}

static Xen gxg_gtk_widget_hide_on_delete(Xen widget)
{
  #define H_gtk_widget_hide_on_delete "gboolean gtk_widget_hide_on_delete(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_hide_on_delete", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_widget_hide_on_delete(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_create_pango_context(Xen widget)
{
  #define H_gtk_widget_create_pango_context "PangoContext* gtk_widget_create_pango_context(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_create_pango_context", "GtkWidget*");
  return(C_to_Xen_PangoContext_(gtk_widget_create_pango_context(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_get_pango_context(Xen widget)
{
  #define H_gtk_widget_get_pango_context "PangoContext* gtk_widget_get_pango_context(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_pango_context", "GtkWidget*");
  return(C_to_Xen_PangoContext_(gtk_widget_get_pango_context(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_create_pango_layout(Xen widget, Xen text)
{
  #define H_gtk_widget_create_pango_layout "PangoLayout* gtk_widget_create_pango_layout(GtkWidget* widget, \
gchar* text)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_create_pango_layout", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(text), text, 2, "gtk_widget_create_pango_layout", "gchar*");
  return(C_to_Xen_PangoLayout_(gtk_widget_create_pango_layout(Xen_to_C_GtkWidget_(widget), Xen_to_C_gchar_(text))));
}

static Xen gxg_gtk_widget_set_direction(Xen widget, Xen dir)
{
  #define H_gtk_widget_set_direction "void gtk_widget_set_direction(GtkWidget* widget, GtkTextDirection dir)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_set_direction", "GtkWidget*");
  Xen_check_type(Xen_is_GtkTextDirection(dir), dir, 2, "gtk_widget_set_direction", "GtkTextDirection");
  gtk_widget_set_direction(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkTextDirection(dir));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_direction(Xen widget)
{
  #define H_gtk_widget_get_direction "GtkTextDirection gtk_widget_get_direction(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_direction", "GtkWidget*");
  return(C_to_Xen_GtkTextDirection(gtk_widget_get_direction(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_set_default_direction(Xen dir)
{
  #define H_gtk_widget_set_default_direction "void gtk_widget_set_default_direction(GtkTextDirection dir)"
  Xen_check_type(Xen_is_GtkTextDirection(dir), dir, 1, "gtk_widget_set_default_direction", "GtkTextDirection");
  gtk_widget_set_default_direction(Xen_to_C_GtkTextDirection(dir));
  return(Xen_false);
}

static Xen gxg_gtk_widget_get_default_direction(void)
{
  #define H_gtk_widget_get_default_direction "GtkTextDirection gtk_widget_get_default_direction( void)"
  return(C_to_Xen_GtkTextDirection(gtk_widget_get_default_direction()));
}

static Xen gxg_gtk_widget_can_activate_accel(Xen widget, Xen signal_id)
{
  #define H_gtk_widget_can_activate_accel "gboolean gtk_widget_can_activate_accel(GtkWidget* widget, \
guint signal_id)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_can_activate_accel", "GtkWidget*");
  Xen_check_type(Xen_is_guint(signal_id), signal_id, 2, "gtk_widget_can_activate_accel", "guint");
  return(C_to_Xen_gboolean(gtk_widget_can_activate_accel(Xen_to_C_GtkWidget_(widget), Xen_to_C_guint(signal_id))));
}

static Xen gxg_gtk_window_is_active(Xen window)
{
  #define H_gtk_window_is_active "gboolean gtk_window_is_active(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_is_active", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_is_active(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_new(Xen type)
{
  #define H_gtk_window_new "GtkWidget* gtk_window_new(GtkWindowType type)"
  Xen_check_type(Xen_is_GtkWindowType(type), type, 1, "gtk_window_new", "GtkWindowType");
  return(C_to_Xen_GtkWidget_(gtk_window_new(Xen_to_C_GtkWindowType(type))));
}

static Xen gxg_gtk_window_set_title(Xen window, Xen title)
{
  #define H_gtk_window_set_title "void gtk_window_set_title(GtkWindow* window, gchar* title)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_title", "GtkWindow*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_window_set_title", "gchar*");
  gtk_window_set_title(Xen_to_C_GtkWindow_(window), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_auto_startup_notification(Xen setting)
{
  #define H_gtk_window_set_auto_startup_notification "void gtk_window_set_auto_startup_notification(gboolean setting)"
  Xen_check_type(Xen_is_gboolean(setting), setting, 1, "gtk_window_set_auto_startup_notification", "gboolean");
  gtk_window_set_auto_startup_notification(Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_title(Xen window)
{
  #define H_gtk_window_get_title "gchar* gtk_window_get_title(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_title", "GtkWindow*");
  return(C_to_Xen_gchar_(gtk_window_get_title(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_role(Xen window, Xen role)
{
  #define H_gtk_window_set_role "void gtk_window_set_role(GtkWindow* window, gchar* role)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_role", "GtkWindow*");
  Xen_check_type(Xen_is_gchar_(role), role, 2, "gtk_window_set_role", "gchar*");
  gtk_window_set_role(Xen_to_C_GtkWindow_(window), Xen_to_C_gchar_(role));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_role(Xen window)
{
  #define H_gtk_window_get_role "gchar* gtk_window_get_role(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_role", "GtkWindow*");
  return(C_to_Xen_gchar_(gtk_window_get_role(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_add_accel_group(Xen window, Xen accel_group)
{
  #define H_gtk_window_add_accel_group "void gtk_window_add_accel_group(GtkWindow* window, GtkAccelGroup* accel_group)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_add_accel_group", "GtkWindow*");
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 2, "gtk_window_add_accel_group", "GtkAccelGroup*");
  gtk_window_add_accel_group(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkAccelGroup_(accel_group));
  return(Xen_false);
}

static Xen gxg_gtk_window_remove_accel_group(Xen window, Xen accel_group)
{
  #define H_gtk_window_remove_accel_group "void gtk_window_remove_accel_group(GtkWindow* window, GtkAccelGroup* accel_group)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_remove_accel_group", "GtkWindow*");
  Xen_check_type(Xen_is_GtkAccelGroup_(accel_group), accel_group, 2, "gtk_window_remove_accel_group", "GtkAccelGroup*");
  gtk_window_remove_accel_group(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkAccelGroup_(accel_group));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_position(Xen window, Xen position)
{
  #define H_gtk_window_set_position "void gtk_window_set_position(GtkWindow* window, GtkWindowPosition position)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_position", "GtkWindow*");
  Xen_check_type(Xen_is_GtkWindowPosition(position), position, 2, "gtk_window_set_position", "GtkWindowPosition");
  gtk_window_set_position(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkWindowPosition(position));
  return(Xen_false);
}

static Xen gxg_gtk_window_activate_focus(Xen window)
{
  #define H_gtk_window_activate_focus "gboolean gtk_window_activate_focus(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_activate_focus", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_activate_focus(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_focus(Xen window, Xen focus)
{
  #define H_gtk_window_set_focus "void gtk_window_set_focus(GtkWindow* window, GtkWidget* focus)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_focus", "GtkWindow*");
  Xen_check_type(Xen_is_GtkWidget_(focus) || Xen_is_false(focus), focus, 2, "gtk_window_set_focus", "GtkWidget*");
  gtk_window_set_focus(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkWidget_(focus));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_focus(Xen window)
{
  #define H_gtk_window_get_focus "GtkWidget* gtk_window_get_focus(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_focus", "GtkWindow*");
  return(C_to_Xen_GtkWidget_(gtk_window_get_focus(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_default(Xen window, Xen default_widget)
{
  #define H_gtk_window_set_default "void gtk_window_set_default(GtkWindow* window, GtkWidget* default_widget)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_default", "GtkWindow*");
  Xen_check_type(Xen_is_GtkWidget_(default_widget) || Xen_is_false(default_widget), default_widget, 2, "gtk_window_set_default", "GtkWidget*");
  gtk_window_set_default(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkWidget_(default_widget));
  return(Xen_false);
}

static Xen gxg_gtk_window_activate_default(Xen window)
{
  #define H_gtk_window_activate_default "gboolean gtk_window_activate_default(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_activate_default", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_activate_default(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_transient_for(Xen window, Xen parent)
{
  #define H_gtk_window_set_transient_for "void gtk_window_set_transient_for(GtkWindow* window, GtkWindow* parent)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_transient_for", "GtkWindow*");
  Xen_check_type(Xen_is_GtkWindow_(parent) || Xen_is_false(parent), parent, 2, "gtk_window_set_transient_for", "GtkWindow*");
  gtk_window_set_transient_for(Xen_to_C_GtkWindow_(window), Xen_to_C_GtkWindow_(parent));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_transient_for(Xen window)
{
  #define H_gtk_window_get_transient_for "GtkWindow* gtk_window_get_transient_for(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_transient_for", "GtkWindow*");
  return(C_to_Xen_GtkWindow_(gtk_window_get_transient_for(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_type_hint(Xen window, Xen hint)
{
  #define H_gtk_window_set_type_hint "void gtk_window_set_type_hint(GtkWindow* window, GdkWindowTypeHint hint)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_type_hint", "GtkWindow*");
  Xen_check_type(Xen_is_GdkWindowTypeHint(hint), hint, 2, "gtk_window_set_type_hint", "GdkWindowTypeHint");
  gtk_window_set_type_hint(Xen_to_C_GtkWindow_(window), Xen_to_C_GdkWindowTypeHint(hint));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_type_hint(Xen window)
{
  #define H_gtk_window_get_type_hint "GdkWindowTypeHint gtk_window_get_type_hint(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_type_hint", "GtkWindow*");
  return(C_to_Xen_GdkWindowTypeHint(gtk_window_get_type_hint(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_destroy_with_parent(Xen window, Xen setting)
{
  #define H_gtk_window_set_destroy_with_parent "void gtk_window_set_destroy_with_parent(GtkWindow* window, \
gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_destroy_with_parent", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_destroy_with_parent", "gboolean");
  gtk_window_set_destroy_with_parent(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_destroy_with_parent(Xen window)
{
  #define H_gtk_window_get_destroy_with_parent "gboolean gtk_window_get_destroy_with_parent(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_destroy_with_parent", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_destroy_with_parent(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_resizable(Xen window, Xen resizable)
{
  #define H_gtk_window_set_resizable "void gtk_window_set_resizable(GtkWindow* window, gboolean resizable)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_resizable", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(resizable), resizable, 2, "gtk_window_set_resizable", "gboolean");
  gtk_window_set_resizable(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(resizable));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_resizable(Xen window)
{
  #define H_gtk_window_get_resizable "gboolean gtk_window_get_resizable(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_resizable", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_resizable(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_gravity(Xen window, Xen gravity)
{
  #define H_gtk_window_set_gravity "void gtk_window_set_gravity(GtkWindow* window, GdkGravity gravity)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_gravity", "GtkWindow*");
  Xen_check_type(Xen_is_GdkGravity(gravity), gravity, 2, "gtk_window_set_gravity", "GdkGravity");
  gtk_window_set_gravity(Xen_to_C_GtkWindow_(window), Xen_to_C_GdkGravity(gravity));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_gravity(Xen window)
{
  #define H_gtk_window_get_gravity "GdkGravity gtk_window_get_gravity(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_gravity", "GtkWindow*");
  return(C_to_Xen_GdkGravity(gtk_window_get_gravity(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_decorated(Xen window, Xen setting)
{
  #define H_gtk_window_set_decorated "void gtk_window_set_decorated(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_decorated", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_decorated", "gboolean");
  gtk_window_set_decorated(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_decorated(Xen window)
{
  #define H_gtk_window_get_decorated "gboolean gtk_window_get_decorated(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_decorated", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_decorated(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_icon_list(Xen window, Xen list)
{
  #define H_gtk_window_set_icon_list "void gtk_window_set_icon_list(GtkWindow* window, GList* list)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_icon_list", "GtkWindow*");
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 2, "gtk_window_set_icon_list", "GList*");
  gtk_window_set_icon_list(Xen_to_C_GtkWindow_(window), Xen_to_C_GList_(list));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_default_icon_list(void)
{
  #define H_gtk_window_get_default_icon_list "GList* gtk_window_get_default_icon_list( void)"
  return(C_to_Xen_GList_(gtk_window_get_default_icon_list()));
}

static Xen gxg_gtk_window_set_modal(Xen window, Xen modal)
{
  #define H_gtk_window_set_modal "void gtk_window_set_modal(GtkWindow* window, gboolean modal)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_modal", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(modal), modal, 2, "gtk_window_set_modal", "gboolean");
  gtk_window_set_modal(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(modal));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_modal(Xen window)
{
  #define H_gtk_window_get_modal "gboolean gtk_window_get_modal(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_modal", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_modal(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_list_toplevels(void)
{
  #define H_gtk_window_list_toplevels "GList* gtk_window_list_toplevels( void)"
  return(C_to_Xen_GList_(gtk_window_list_toplevels()));
}

static Xen gxg_gtk_window_add_mnemonic(Xen window, Xen keyval, Xen target)
{
  #define H_gtk_window_add_mnemonic "void gtk_window_add_mnemonic(GtkWindow* window, guint keyval, GtkWidget* target)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_add_mnemonic", "GtkWindow*");
  Xen_check_type(Xen_is_guint(keyval), keyval, 2, "gtk_window_add_mnemonic", "guint");
  Xen_check_type(Xen_is_GtkWidget_(target), target, 3, "gtk_window_add_mnemonic", "GtkWidget*");
  gtk_window_add_mnemonic(Xen_to_C_GtkWindow_(window), Xen_to_C_guint(keyval), Xen_to_C_GtkWidget_(target));
  return(Xen_false);
}

static Xen gxg_gtk_window_remove_mnemonic(Xen window, Xen keyval, Xen target)
{
  #define H_gtk_window_remove_mnemonic "void gtk_window_remove_mnemonic(GtkWindow* window, guint keyval, \
GtkWidget* target)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_remove_mnemonic", "GtkWindow*");
  Xen_check_type(Xen_is_guint(keyval), keyval, 2, "gtk_window_remove_mnemonic", "guint");
  Xen_check_type(Xen_is_GtkWidget_(target), target, 3, "gtk_window_remove_mnemonic", "GtkWidget*");
  gtk_window_remove_mnemonic(Xen_to_C_GtkWindow_(window), Xen_to_C_guint(keyval), Xen_to_C_GtkWidget_(target));
  return(Xen_false);
}

static Xen gxg_gtk_window_mnemonic_activate(Xen window, Xen keyval, Xen modifier)
{
  #define H_gtk_window_mnemonic_activate "gboolean gtk_window_mnemonic_activate(GtkWindow* window, guint keyval, \
GdkModifierType modifier)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_mnemonic_activate", "GtkWindow*");
  Xen_check_type(Xen_is_guint(keyval), keyval, 2, "gtk_window_mnemonic_activate", "guint");
  Xen_check_type(Xen_is_GdkModifierType(modifier), modifier, 3, "gtk_window_mnemonic_activate", "GdkModifierType");
  return(C_to_Xen_gboolean(gtk_window_mnemonic_activate(Xen_to_C_GtkWindow_(window), Xen_to_C_guint(keyval), Xen_to_C_GdkModifierType(modifier))));
}

static Xen gxg_gtk_window_set_mnemonic_modifier(Xen window, Xen modifier)
{
  #define H_gtk_window_set_mnemonic_modifier "void gtk_window_set_mnemonic_modifier(GtkWindow* window, \
GdkModifierType modifier)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_mnemonic_modifier", "GtkWindow*");
  Xen_check_type(Xen_is_GdkModifierType(modifier), modifier, 2, "gtk_window_set_mnemonic_modifier", "GdkModifierType");
  gtk_window_set_mnemonic_modifier(Xen_to_C_GtkWindow_(window), Xen_to_C_GdkModifierType(modifier));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_mnemonic_modifier(Xen window)
{
  #define H_gtk_window_get_mnemonic_modifier "GdkModifierType gtk_window_get_mnemonic_modifier(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_mnemonic_modifier", "GtkWindow*");
  return(C_to_Xen_GdkModifierType(gtk_window_get_mnemonic_modifier(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_present(Xen window)
{
  #define H_gtk_window_present "void gtk_window_present(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_present", "GtkWindow*");
  gtk_window_present(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_iconify(Xen window)
{
  #define H_gtk_window_iconify "void gtk_window_iconify(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_iconify", "GtkWindow*");
  gtk_window_iconify(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_deiconify(Xen window)
{
  #define H_gtk_window_deiconify "void gtk_window_deiconify(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_deiconify", "GtkWindow*");
  gtk_window_deiconify(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_stick(Xen window)
{
  #define H_gtk_window_stick "void gtk_window_stick(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_stick", "GtkWindow*");
  gtk_window_stick(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_unstick(Xen window)
{
  #define H_gtk_window_unstick "void gtk_window_unstick(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_unstick", "GtkWindow*");
  gtk_window_unstick(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_maximize(Xen window)
{
  #define H_gtk_window_maximize "void gtk_window_maximize(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_maximize", "GtkWindow*");
  gtk_window_maximize(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_unmaximize(Xen window)
{
  #define H_gtk_window_unmaximize "void gtk_window_unmaximize(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_unmaximize", "GtkWindow*");
  gtk_window_unmaximize(Xen_to_C_GtkWindow_(window));
  return(Xen_false);
}

static Xen gxg_gtk_window_begin_resize_drag(Xen window, Xen edge, Xen button, Xen root_x, Xen root_y, Xen timestamp)
{
  #define H_gtk_window_begin_resize_drag "void gtk_window_begin_resize_drag(GtkWindow* window, GdkWindowEdge edge, \
gint button, gint root_x, gint root_y, guint32 timestamp)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_begin_resize_drag", "GtkWindow*");
  Xen_check_type(Xen_is_GdkWindowEdge(edge), edge, 2, "gtk_window_begin_resize_drag", "GdkWindowEdge");
  Xen_check_type(Xen_is_gint(button), button, 3, "gtk_window_begin_resize_drag", "gint");
  Xen_check_type(Xen_is_gint(root_x), root_x, 4, "gtk_window_begin_resize_drag", "gint");
  Xen_check_type(Xen_is_gint(root_y), root_y, 5, "gtk_window_begin_resize_drag", "gint");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 6, "gtk_window_begin_resize_drag", "guint32");
  gtk_window_begin_resize_drag(Xen_to_C_GtkWindow_(window), Xen_to_C_GdkWindowEdge(edge), Xen_to_C_gint(button), Xen_to_C_gint(root_x), 
                               Xen_to_C_gint(root_y), Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gtk_window_begin_move_drag(Xen window, Xen button, Xen root_x, Xen root_y, Xen timestamp)
{
  #define H_gtk_window_begin_move_drag "void gtk_window_begin_move_drag(GtkWindow* window, gint button, \
gint root_x, gint root_y, guint32 timestamp)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_begin_move_drag", "GtkWindow*");
  Xen_check_type(Xen_is_gint(button), button, 2, "gtk_window_begin_move_drag", "gint");
  Xen_check_type(Xen_is_gint(root_x), root_x, 3, "gtk_window_begin_move_drag", "gint");
  Xen_check_type(Xen_is_gint(root_y), root_y, 4, "gtk_window_begin_move_drag", "gint");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 5, "gtk_window_begin_move_drag", "guint32");
  gtk_window_begin_move_drag(Xen_to_C_GtkWindow_(window), Xen_to_C_gint(button), Xen_to_C_gint(root_x), Xen_to_C_gint(root_y), 
                             Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_default_size(Xen window, Xen width, Xen height)
{
  #define H_gtk_window_set_default_size "void gtk_window_set_default_size(GtkWindow* window, gint width, \
gint height)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_default_size", "GtkWindow*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_window_set_default_size", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_window_set_default_size", "gint");
  gtk_window_set_default_size(Xen_to_C_GtkWindow_(window), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_default_size(Xen window, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_window_get_default_size "void gtk_window_get_default_size(GtkWindow* window, gint* [width], \
gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_default_size", "GtkWindow*");
  gtk_window_get_default_size(Xen_to_C_GtkWindow_(window), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_window_resize(Xen window, Xen width, Xen height)
{
  #define H_gtk_window_resize "void gtk_window_resize(GtkWindow* window, gint width, gint height)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_resize", "GtkWindow*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_window_resize", "gint");
  Xen_check_type(Xen_is_gint(height), height, 3, "gtk_window_resize", "gint");
  gtk_window_resize(Xen_to_C_GtkWindow_(window), Xen_to_C_gint(width), Xen_to_C_gint(height));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_size(Xen window, Xen ignore_width, Xen ignore_height)
{
  #define H_gtk_window_get_size "void gtk_window_get_size(GtkWindow* window, gint* [width], gint* [height])"
  gint ref_width;
  gint ref_height;
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_size", "GtkWindow*");
  gtk_window_get_size(Xen_to_C_GtkWindow_(window), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_gint(ref_width), C_to_Xen_gint(ref_height)));
}

static Xen gxg_gtk_window_move(Xen window, Xen x, Xen y)
{
  #define H_gtk_window_move "void gtk_window_move(GtkWindow* window, gint x, gint y)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_move", "GtkWindow*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_window_move", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_window_move", "gint");
  gtk_window_move(Xen_to_C_GtkWindow_(window), Xen_to_C_gint(x), Xen_to_C_gint(y));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_position(Xen window, Xen ignore_root_x, Xen ignore_root_y)
{
  #define H_gtk_window_get_position "void gtk_window_get_position(GtkWindow* window, gint* [root_x], \
gint* [root_y])"
  gint ref_root_x;
  gint ref_root_y;
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_position", "GtkWindow*");
  gtk_window_get_position(Xen_to_C_GtkWindow_(window), &ref_root_x, &ref_root_y);
  return(Xen_list_2(C_to_Xen_gint(ref_root_x), C_to_Xen_gint(ref_root_y)));
}

static Xen gxg_pango_color_copy(Xen src)
{
  #define H_pango_color_copy "PangoColor* pango_color_copy(PangoColor* src)"
  Xen_check_type(Xen_is_PangoColor_(src), src, 1, "pango_color_copy", "PangoColor*");
  return(C_to_Xen_PangoColor_(pango_color_copy(Xen_to_C_PangoColor_(src))));
}

static Xen gxg_pango_color_free(Xen color)
{
  #define H_pango_color_free "void pango_color_free(PangoColor* color)"
  Xen_check_type(Xen_is_PangoColor_(color), color, 1, "pango_color_free", "PangoColor*");
  pango_color_free(Xen_to_C_PangoColor_(color));
  return(Xen_false);
}

static Xen gxg_pango_color_parse(Xen color, Xen spec)
{
  #define H_pango_color_parse "gboolean pango_color_parse(PangoColor* color, char* spec)"
  Xen_check_type(Xen_is_PangoColor_(color), color, 1, "pango_color_parse", "PangoColor*");
  Xen_check_type(Xen_is_char_(spec), spec, 2, "pango_color_parse", "char*");
  return(C_to_Xen_gboolean(pango_color_parse(Xen_to_C_PangoColor_(color), Xen_to_C_char_(spec))));
}

static Xen gxg_pango_attr_type_register(Xen name)
{
  #define H_pango_attr_type_register "PangoAttrType pango_attr_type_register(gchar* name)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "pango_attr_type_register", "gchar*");
  return(C_to_Xen_PangoAttrType(pango_attr_type_register(Xen_to_C_gchar_(name))));
}

static Xen gxg_pango_attribute_copy(Xen attr)
{
  #define H_pango_attribute_copy "PangoAttribute* pango_attribute_copy(PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 1, "pango_attribute_copy", "PangoAttribute*");
  return(C_to_Xen_PangoAttribute_(pango_attribute_copy(Xen_to_C_PangoAttribute_(attr))));
}

static Xen gxg_pango_attribute_destroy(Xen attr)
{
  #define H_pango_attribute_destroy "void pango_attribute_destroy(PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 1, "pango_attribute_destroy", "PangoAttribute*");
  pango_attribute_destroy(Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attribute_equal(Xen attr1, Xen attr2)
{
  #define H_pango_attribute_equal "gboolean pango_attribute_equal(PangoAttribute* attr1, PangoAttribute* attr2)"
  Xen_check_type(Xen_is_PangoAttribute_(attr1), attr1, 1, "pango_attribute_equal", "PangoAttribute*");
  Xen_check_type(Xen_is_PangoAttribute_(attr2), attr2, 2, "pango_attribute_equal", "PangoAttribute*");
  return(C_to_Xen_gboolean(pango_attribute_equal(Xen_to_C_PangoAttribute_(attr1), Xen_to_C_PangoAttribute_(attr2))));
}

static Xen gxg_pango_attr_language_new(Xen language)
{
  #define H_pango_attr_language_new "PangoAttribute* pango_attr_language_new(PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 1, "pango_attr_language_new", "PangoLanguage*");
  return(C_to_Xen_PangoAttribute_(pango_attr_language_new(Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_attr_family_new(Xen family)
{
  #define H_pango_attr_family_new "PangoAttribute* pango_attr_family_new(char* family)"
  Xen_check_type(Xen_is_char_(family), family, 1, "pango_attr_family_new", "char*");
  return(C_to_Xen_PangoAttribute_(pango_attr_family_new(Xen_to_C_char_(family))));
}

static Xen gxg_pango_attr_foreground_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_foreground_new "PangoAttribute* pango_attr_foreground_new(guint16 red, guint16 green, \
guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_foreground_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_foreground_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_foreground_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_foreground_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_attr_background_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_background_new "PangoAttribute* pango_attr_background_new(guint16 red, guint16 green, \
guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_background_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_background_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_background_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_background_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_attr_size_new(Xen size)
{
  #define H_pango_attr_size_new "PangoAttribute* pango_attr_size_new(int size)"
  Xen_check_type(Xen_is_int(size), size, 1, "pango_attr_size_new", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_size_new(Xen_to_C_int(size))));
}

static Xen gxg_pango_attr_style_new(Xen style)
{
  #define H_pango_attr_style_new "PangoAttribute* pango_attr_style_new(PangoStyle style)"
  Xen_check_type(Xen_is_PangoStyle(style), style, 1, "pango_attr_style_new", "PangoStyle");
  return(C_to_Xen_PangoAttribute_(pango_attr_style_new(Xen_to_C_PangoStyle(style))));
}

static Xen gxg_pango_attr_weight_new(Xen weight)
{
  #define H_pango_attr_weight_new "PangoAttribute* pango_attr_weight_new(PangoWeight weight)"
  Xen_check_type(Xen_is_PangoWeight(weight), weight, 1, "pango_attr_weight_new", "PangoWeight");
  return(C_to_Xen_PangoAttribute_(pango_attr_weight_new(Xen_to_C_PangoWeight(weight))));
}

static Xen gxg_pango_attr_variant_new(Xen variant)
{
  #define H_pango_attr_variant_new "PangoAttribute* pango_attr_variant_new(PangoVariant variant)"
  Xen_check_type(Xen_is_PangoVariant(variant), variant, 1, "pango_attr_variant_new", "PangoVariant");
  return(C_to_Xen_PangoAttribute_(pango_attr_variant_new(Xen_to_C_PangoVariant(variant))));
}

static Xen gxg_pango_attr_stretch_new(Xen stretch)
{
  #define H_pango_attr_stretch_new "PangoAttribute* pango_attr_stretch_new(PangoStretch stretch)"
  Xen_check_type(Xen_is_PangoStretch(stretch), stretch, 1, "pango_attr_stretch_new", "PangoStretch");
  return(C_to_Xen_PangoAttribute_(pango_attr_stretch_new(Xen_to_C_PangoStretch(stretch))));
}

static Xen gxg_pango_attr_font_desc_new(Xen desc)
{
  #define H_pango_attr_font_desc_new "PangoAttribute* pango_attr_font_desc_new(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_attr_font_desc_new", "PangoFontDescription*");
  return(C_to_Xen_PangoAttribute_(pango_attr_font_desc_new(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_attr_underline_new(Xen underline)
{
  #define H_pango_attr_underline_new "PangoAttribute* pango_attr_underline_new(PangoUnderline underline)"
  Xen_check_type(Xen_is_PangoUnderline(underline), underline, 1, "pango_attr_underline_new", "PangoUnderline");
  return(C_to_Xen_PangoAttribute_(pango_attr_underline_new(Xen_to_C_PangoUnderline(underline))));
}

static Xen gxg_pango_attr_strikethrough_new(Xen strikethrough)
{
  #define H_pango_attr_strikethrough_new "PangoAttribute* pango_attr_strikethrough_new(gboolean strikethrough)"
  Xen_check_type(Xen_is_gboolean(strikethrough), strikethrough, 1, "pango_attr_strikethrough_new", "gboolean");
  return(C_to_Xen_PangoAttribute_(pango_attr_strikethrough_new(Xen_to_C_gboolean(strikethrough))));
}

static Xen gxg_pango_attr_rise_new(Xen rise)
{
  #define H_pango_attr_rise_new "PangoAttribute* pango_attr_rise_new(int rise)"
  Xen_check_type(Xen_is_int(rise), rise, 1, "pango_attr_rise_new", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_rise_new(Xen_to_C_int(rise))));
}

static Xen gxg_pango_attr_shape_new(Xen ink_rect, Xen logical_rect)
{
  #define H_pango_attr_shape_new "PangoAttribute* pango_attr_shape_new(PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 1, "pango_attr_shape_new", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 2, "pango_attr_shape_new", "PangoRectangle*");
  return(C_to_Xen_PangoAttribute_(pango_attr_shape_new(Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect))));
}

static Xen gxg_pango_attr_scale_new(Xen scale_factor)
{
  #define H_pango_attr_scale_new "PangoAttribute* pango_attr_scale_new(double scale_factor)"
  Xen_check_type(Xen_is_double(scale_factor), scale_factor, 1, "pango_attr_scale_new", "double");
  return(C_to_Xen_PangoAttribute_(pango_attr_scale_new(Xen_to_C_double(scale_factor))));
}

static Xen gxg_pango_attr_list_new(void)
{
  #define H_pango_attr_list_new "PangoAttrList* pango_attr_list_new( void)"
  return(C_to_Xen_PangoAttrList_(pango_attr_list_new()));
}

static Xen gxg_pango_attr_list_unref(Xen list)
{
  #define H_pango_attr_list_unref "void pango_attr_list_unref(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_unref", "PangoAttrList*");
  pango_attr_list_unref(Xen_to_C_PangoAttrList_(list));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_copy(Xen list)
{
  #define H_pango_attr_list_copy "PangoAttrList* pango_attr_list_copy(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_copy", "PangoAttrList*");
  return(C_to_Xen_PangoAttrList_(pango_attr_list_copy(Xen_to_C_PangoAttrList_(list))));
}

static Xen gxg_pango_attr_list_insert(Xen list, Xen attr)
{
  #define H_pango_attr_list_insert "void pango_attr_list_insert(PangoAttrList* list, PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_insert", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 2, "pango_attr_list_insert", "PangoAttribute*");
  pango_attr_list_insert(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_insert_before(Xen list, Xen attr)
{
  #define H_pango_attr_list_insert_before "void pango_attr_list_insert_before(PangoAttrList* list, PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_insert_before", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 2, "pango_attr_list_insert_before", "PangoAttribute*");
  pango_attr_list_insert_before(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_change(Xen list, Xen attr)
{
  #define H_pango_attr_list_change "void pango_attr_list_change(PangoAttrList* list, PangoAttribute* attr)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_change", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttribute_(attr), attr, 2, "pango_attr_list_change", "PangoAttribute*");
  pango_attr_list_change(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttribute_(attr));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_splice(Xen list, Xen other, Xen pos, Xen len)
{
  #define H_pango_attr_list_splice "void pango_attr_list_splice(PangoAttrList* list, PangoAttrList* other, \
gint pos, gint len)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_splice", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttrList_(other), other, 2, "pango_attr_list_splice", "PangoAttrList*");
  Xen_check_type(Xen_is_gint(pos), pos, 3, "pango_attr_list_splice", "gint");
  Xen_check_type(Xen_is_gint(len), len, 4, "pango_attr_list_splice", "gint");
  pango_attr_list_splice(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttrList_(other), Xen_to_C_gint(pos), Xen_to_C_gint(len));
  return(Xen_false);
}

static Xen gxg_pango_attr_list_get_iterator(Xen list)
{
  #define H_pango_attr_list_get_iterator "PangoAttrIterator* pango_attr_list_get_iterator(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_get_iterator", "PangoAttrList*");
  return(C_to_Xen_PangoAttrIterator_(pango_attr_list_get_iterator(Xen_to_C_PangoAttrList_(list))));
}

static Xen gxg_pango_attr_iterator_range(Xen iterator, Xen ignore_start, Xen ignore_end)
{
  #define H_pango_attr_iterator_range "void pango_attr_iterator_range(PangoAttrIterator* iterator, gint* [start], \
gint* [end])"
  gint ref_start;
  gint ref_end;
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_range", "PangoAttrIterator*");
  pango_attr_iterator_range(Xen_to_C_PangoAttrIterator_(iterator), &ref_start, &ref_end);
  return(Xen_list_2(C_to_Xen_gint(ref_start), C_to_Xen_gint(ref_end)));
}

static Xen gxg_pango_attr_iterator_next(Xen iterator)
{
  #define H_pango_attr_iterator_next "gboolean pango_attr_iterator_next(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_next", "PangoAttrIterator*");
  return(C_to_Xen_gboolean(pango_attr_iterator_next(Xen_to_C_PangoAttrIterator_(iterator))));
}

static Xen gxg_pango_attr_iterator_copy(Xen iterator)
{
  #define H_pango_attr_iterator_copy "PangoAttrIterator* pango_attr_iterator_copy(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_copy", "PangoAttrIterator*");
  return(C_to_Xen_PangoAttrIterator_(pango_attr_iterator_copy(Xen_to_C_PangoAttrIterator_(iterator))));
}

static Xen gxg_pango_attr_iterator_destroy(Xen iterator)
{
  #define H_pango_attr_iterator_destroy "void pango_attr_iterator_destroy(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_destroy", "PangoAttrIterator*");
  pango_attr_iterator_destroy(Xen_to_C_PangoAttrIterator_(iterator));
  return(Xen_false);
}

static Xen gxg_pango_attr_iterator_get(Xen iterator, Xen type)
{
  #define H_pango_attr_iterator_get "PangoAttribute* pango_attr_iterator_get(PangoAttrIterator* iterator, \
PangoAttrType type)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_get", "PangoAttrIterator*");
  Xen_check_type(Xen_is_PangoAttrType(type), type, 2, "pango_attr_iterator_get", "PangoAttrType");
  return(C_to_Xen_PangoAttribute_(pango_attr_iterator_get(Xen_to_C_PangoAttrIterator_(iterator), Xen_to_C_PangoAttrType(type))));
}

static Xen gxg_pango_attr_iterator_get_font(Xen iterator, Xen desc, Xen ignore_language, Xen ignore_extra_attrs)
{
  #define H_pango_attr_iterator_get_font "void pango_attr_iterator_get_font(PangoAttrIterator* iterator, \
PangoFontDescription* desc, PangoLanguage** [language], GSList** [extra_attrs])"
  PangoLanguage* ref_language = NULL;
  GSList* ref_extra_attrs = NULL;
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_get_font", "PangoAttrIterator*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_attr_iterator_get_font", "PangoFontDescription*");
  pango_attr_iterator_get_font(Xen_to_C_PangoAttrIterator_(iterator), Xen_to_C_PangoFontDescription_(desc), &ref_language, 
                               &ref_extra_attrs);
  return(Xen_list_2(C_to_Xen_PangoLanguage_(ref_language), C_to_Xen_GSList_(ref_extra_attrs)));
}

static Xen gxg_pango_parse_markup(Xen markup_text, Xen length, Xen accel_marker, Xen attr_list, Xen text, Xen accel_char, Xen ignore_error)
{
  #define H_pango_parse_markup "gboolean pango_parse_markup(char* markup_text, int length, gunichar accel_marker, \
PangoAttrList** attr_list, char** text, gunichar* accel_char, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_char_(markup_text), markup_text, 1, "pango_parse_markup", "char*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_parse_markup", "int");
  Xen_check_type(Xen_is_gunichar(accel_marker), accel_marker, 3, "pango_parse_markup", "gunichar");
  Xen_check_type(Xen_is_PangoAttrList__(attr_list), attr_list, 4, "pango_parse_markup", "PangoAttrList**");
  Xen_check_type(Xen_is_char__(text), text, 5, "pango_parse_markup", "char**");
  Xen_check_type(Xen_is_gunichar_(accel_char), accel_char, 6, "pango_parse_markup", "gunichar*");
  {
    Xen result;
    result = C_to_Xen_gboolean(pango_parse_markup(Xen_to_C_char_(markup_text), Xen_to_C_int(length), Xen_to_C_gunichar(accel_marker), 
                                                  Xen_to_C_PangoAttrList__(attr_list), Xen_to_C_char__(text), Xen_to_C_gunichar_(accel_char), 
                                                  &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_pango_break(Xen text, Xen length, Xen analysis, Xen attrs, Xen attrs_len)
{
  #define H_pango_break "void pango_break(gchar* text, int length, PangoAnalysis* analysis, PangoLogAttr* attrs, \
int attrs_len)"
  Xen_check_type(Xen_is_gchar_(text), text, 1, "pango_break", "gchar*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_break", "int");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 3, "pango_break", "PangoAnalysis*");
  Xen_check_type(Xen_is_PangoLogAttr_(attrs), attrs, 4, "pango_break", "PangoLogAttr*");
  Xen_check_type(Xen_is_int(attrs_len), attrs_len, 5, "pango_break", "int");
  pango_break(Xen_to_C_gchar_(text), Xen_to_C_int(length), Xen_to_C_PangoAnalysis_(analysis), Xen_to_C_PangoLogAttr_(attrs), 
              Xen_to_C_int(attrs_len));
  return(Xen_false);
}

static Xen gxg_pango_find_paragraph_boundary(Xen text, Xen length, Xen ignore_paragraph_delimiter_index, Xen ignore_next_paragraph_start)
{
  #define H_pango_find_paragraph_boundary "void pango_find_paragraph_boundary(gchar* text, gint length, \
gint* [paragraph_delimiter_index], gint* [next_paragraph_start])"
  gint ref_paragraph_delimiter_index;
  gint ref_next_paragraph_start;
  Xen_check_type(Xen_is_gchar_(text), text, 1, "pango_find_paragraph_boundary", "gchar*");
  Xen_check_type(Xen_is_gint(length), length, 2, "pango_find_paragraph_boundary", "gint");
  pango_find_paragraph_boundary(Xen_to_C_gchar_(text), Xen_to_C_gint(length), &ref_paragraph_delimiter_index, &ref_next_paragraph_start);
  return(Xen_list_2(C_to_Xen_gint(ref_paragraph_delimiter_index), C_to_Xen_gint(ref_next_paragraph_start)));
}

static Xen gxg_pango_get_log_attrs(Xen text, Xen length, Xen level, Xen language, Xen log_attrs, Xen attrs_len)
{
  #define H_pango_get_log_attrs "void pango_get_log_attrs(char* text, int length, int level, PangoLanguage* language, \
PangoLogAttr* log_attrs, int attrs_len)"
  Xen_check_type(Xen_is_char_(text), text, 1, "pango_get_log_attrs", "char*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_get_log_attrs", "int");
  Xen_check_type(Xen_is_int(level), level, 3, "pango_get_log_attrs", "int");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 4, "pango_get_log_attrs", "PangoLanguage*");
  Xen_check_type(Xen_is_PangoLogAttr_(log_attrs), log_attrs, 5, "pango_get_log_attrs", "PangoLogAttr*");
  Xen_check_type(Xen_is_int(attrs_len), attrs_len, 6, "pango_get_log_attrs", "int");
  pango_get_log_attrs(Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_int(level), Xen_to_C_PangoLanguage_(language), 
                      Xen_to_C_PangoLogAttr_(log_attrs), Xen_to_C_int(attrs_len));
  return(Xen_false);
}

static Xen gxg_pango_context_list_families(Xen context, Xen ignore_families, Xen ignore_n_families)
{
  #define H_pango_context_list_families "void pango_context_list_families(PangoContext* context, PangoFontFamily*** [families], \
int* [n_families])"
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_list_families", "PangoContext*");
  pango_context_list_families(Xen_to_C_PangoContext_(context), &ref_families, &ref_n_families);
  return(Xen_list_2(C_to_Xen_PangoFontFamily__(ref_families), C_to_Xen_int(ref_n_families)));
}

static Xen gxg_pango_context_load_font(Xen context, Xen desc)
{
  #define H_pango_context_load_font "PangoFont* pango_context_load_font(PangoContext* context, PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_load_font", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_load_font", "PangoFontDescription*");
  return(C_to_Xen_PangoFont_(pango_context_load_font(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_context_load_fontset(Xen context, Xen desc, Xen language)
{
  #define H_pango_context_load_fontset "PangoFontset* pango_context_load_fontset(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_load_fontset", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_load_fontset", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 3, "pango_context_load_fontset", "PangoLanguage*");
  return(C_to_Xen_PangoFontset_(pango_context_load_fontset(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc), 
                                                           Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_context_get_metrics(Xen context, Xen desc, Xen language)
{
  #define H_pango_context_get_metrics "PangoFontMetrics* pango_context_get_metrics(PangoContext* context, \
PangoFontDescription* desc, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_metrics", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_get_metrics", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 3, "pango_context_get_metrics", "PangoLanguage*");
  return(C_to_Xen_PangoFontMetrics_(pango_context_get_metrics(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc), 
                                                              Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_context_set_font_description(Xen context, Xen desc)
{
  #define H_pango_context_set_font_description "void pango_context_set_font_description(PangoContext* context, \
PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_set_font_description", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_context_set_font_description", "PangoFontDescription*");
  pango_context_set_font_description(Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc));
  return(Xen_false);
}

static Xen gxg_pango_context_get_font_description(Xen context)
{
  #define H_pango_context_get_font_description "PangoFontDescription* pango_context_get_font_description(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_font_description", "PangoContext*");
  return(C_to_Xen_PangoFontDescription_(pango_context_get_font_description(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_context_get_language(Xen context)
{
  #define H_pango_context_get_language "PangoLanguage* pango_context_get_language(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_language", "PangoContext*");
  return(C_to_Xen_PangoLanguage_(pango_context_get_language(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_context_set_language(Xen context, Xen language)
{
  #define H_pango_context_set_language "void pango_context_set_language(PangoContext* context, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_set_language", "PangoContext*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 2, "pango_context_set_language", "PangoLanguage*");
  pango_context_set_language(Xen_to_C_PangoContext_(context), Xen_to_C_PangoLanguage_(language));
  return(Xen_false);
}

static Xen gxg_pango_context_set_base_dir(Xen context, Xen direction)
{
  #define H_pango_context_set_base_dir "void pango_context_set_base_dir(PangoContext* context, PangoDirection direction)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_set_base_dir", "PangoContext*");
  Xen_check_type(Xen_is_PangoDirection(direction), direction, 2, "pango_context_set_base_dir", "PangoDirection");
  pango_context_set_base_dir(Xen_to_C_PangoContext_(context), Xen_to_C_PangoDirection(direction));
  return(Xen_false);
}

static Xen gxg_pango_context_get_base_dir(Xen context)
{
  #define H_pango_context_get_base_dir "PangoDirection pango_context_get_base_dir(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_context_get_base_dir", "PangoContext*");
  return(C_to_Xen_PangoDirection(pango_context_get_base_dir(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_itemize(Xen context, Xen text, Xen start_index, Xen length, Xen attrs, Xen cached_iter)
{
  #define H_pango_itemize "GList* pango_itemize(PangoContext* context, char* text, int start_index, int length, \
PangoAttrList* attrs, PangoAttrIterator* cached_iter)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_itemize", "PangoContext*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_itemize", "char*");
  Xen_check_type(Xen_is_int(start_index), start_index, 3, "pango_itemize", "int");
  Xen_check_type(Xen_is_int(length), length, 4, "pango_itemize", "int");
  Xen_check_type(Xen_is_PangoAttrList_(attrs), attrs, 5, "pango_itemize", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttrIterator_(cached_iter), cached_iter, 6, "pango_itemize", "PangoAttrIterator*");
  return(C_to_Xen_GList_(pango_itemize(Xen_to_C_PangoContext_(context), Xen_to_C_char_(text), Xen_to_C_int(start_index), 
                                       Xen_to_C_int(length), Xen_to_C_PangoAttrList_(attrs), Xen_to_C_PangoAttrIterator_(cached_iter))));
}

static Xen gxg_pango_coverage_new(void)
{
  #define H_pango_coverage_new "PangoCoverage* pango_coverage_new( void)"
  return(C_to_Xen_PangoCoverage_(pango_coverage_new()));
}

static Xen gxg_pango_coverage_ref(Xen coverage)
{
  #define H_pango_coverage_ref "PangoCoverage* pango_coverage_ref(PangoCoverage* coverage)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_ref", "PangoCoverage*");
  return(C_to_Xen_PangoCoverage_(pango_coverage_ref(Xen_to_C_PangoCoverage_(coverage))));
}

static Xen gxg_pango_coverage_unref(Xen coverage)
{
  #define H_pango_coverage_unref "void pango_coverage_unref(PangoCoverage* coverage)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_unref", "PangoCoverage*");
  pango_coverage_unref(Xen_to_C_PangoCoverage_(coverage));
  return(Xen_false);
}

static Xen gxg_pango_coverage_copy(Xen coverage)
{
  #define H_pango_coverage_copy "PangoCoverage* pango_coverage_copy(PangoCoverage* coverage)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_copy", "PangoCoverage*");
  return(C_to_Xen_PangoCoverage_(pango_coverage_copy(Xen_to_C_PangoCoverage_(coverage))));
}

static Xen gxg_pango_coverage_get(Xen coverage, Xen index)
{
  #define H_pango_coverage_get "PangoCoverageLevel pango_coverage_get(PangoCoverage* coverage, int index)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_get", "PangoCoverage*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_coverage_get", "int");
  return(C_to_Xen_PangoCoverageLevel(pango_coverage_get(Xen_to_C_PangoCoverage_(coverage), Xen_to_C_int(index))));
}

static Xen gxg_pango_coverage_set(Xen coverage, Xen index, Xen level)
{
  #define H_pango_coverage_set "void pango_coverage_set(PangoCoverage* coverage, int index, PangoCoverageLevel level)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_set", "PangoCoverage*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_coverage_set", "int");
  Xen_check_type(Xen_is_PangoCoverageLevel(level), level, 3, "pango_coverage_set", "PangoCoverageLevel");
  pango_coverage_set(Xen_to_C_PangoCoverage_(coverage), Xen_to_C_int(index), Xen_to_C_PangoCoverageLevel(level));
  return(Xen_false);
}

static Xen gxg_pango_coverage_max(Xen coverage, Xen other)
{
  #define H_pango_coverage_max "void pango_coverage_max(PangoCoverage* coverage, PangoCoverage* other)"
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_max", "PangoCoverage*");
  Xen_check_type(Xen_is_PangoCoverage_(other), other, 2, "pango_coverage_max", "PangoCoverage*");
  pango_coverage_max(Xen_to_C_PangoCoverage_(coverage), Xen_to_C_PangoCoverage_(other));
  return(Xen_false);
}

static Xen gxg_pango_coverage_to_bytes(Xen coverage, Xen ignore_bytes, Xen ignore_n_bytes)
{
  #define H_pango_coverage_to_bytes "void pango_coverage_to_bytes(PangoCoverage* coverage, guchar** [bytes], \
int* [n_bytes])"
  guchar* ref_bytes = NULL;
  int ref_n_bytes;
  Xen_check_type(Xen_is_PangoCoverage_(coverage), coverage, 1, "pango_coverage_to_bytes", "PangoCoverage*");
  pango_coverage_to_bytes(Xen_to_C_PangoCoverage_(coverage), &ref_bytes, &ref_n_bytes);
  return(Xen_list_2(C_to_Xen_guchar_(ref_bytes), C_to_Xen_int(ref_n_bytes)));
}

static Xen gxg_pango_coverage_from_bytes(Xen bytes, Xen n_bytes)
{
  #define H_pango_coverage_from_bytes "PangoCoverage* pango_coverage_from_bytes(guchar* bytes, int n_bytes)"
  Xen_check_type(Xen_is_guchar_(bytes), bytes, 1, "pango_coverage_from_bytes", "guchar*");
  Xen_check_type(Xen_is_int(n_bytes), n_bytes, 2, "pango_coverage_from_bytes", "int");
  return(C_to_Xen_PangoCoverage_(pango_coverage_from_bytes(Xen_to_C_guchar_(bytes), Xen_to_C_int(n_bytes))));
}

static Xen gxg_pango_font_description_new(void)
{
  #define H_pango_font_description_new "PangoFontDescription* pango_font_description_new( void)"
  return(C_to_Xen_PangoFontDescription_(pango_font_description_new()));
}

static Xen gxg_pango_font_description_copy(Xen desc)
{
  #define H_pango_font_description_copy "PangoFontDescription* pango_font_description_copy(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_copy", "PangoFontDescription*");
  return(C_to_Xen_PangoFontDescription_(pango_font_description_copy(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_copy_static(Xen desc)
{
  #define H_pango_font_description_copy_static "PangoFontDescription* pango_font_description_copy_static(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_copy_static", "PangoFontDescription*");
  return(C_to_Xen_PangoFontDescription_(pango_font_description_copy_static(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_hash(Xen desc)
{
  #define H_pango_font_description_hash "guint pango_font_description_hash(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_hash", "PangoFontDescription*");
  return(C_to_Xen_guint(pango_font_description_hash(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_equal(Xen desc1, Xen desc2)
{
  #define H_pango_font_description_equal "gboolean pango_font_description_equal(PangoFontDescription* desc1, \
PangoFontDescription* desc2)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc1), desc1, 1, "pango_font_description_equal", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc2), desc2, 2, "pango_font_description_equal", "PangoFontDescription*");
  return(C_to_Xen_gboolean(pango_font_description_equal(Xen_to_C_PangoFontDescription_(desc1), Xen_to_C_PangoFontDescription_(desc2))));
}

static Xen gxg_pango_font_description_free(Xen desc)
{
  #define H_pango_font_description_free "void pango_font_description_free(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_free", "PangoFontDescription*");
  pango_font_description_free(Xen_to_C_PangoFontDescription_(desc));
  return(Xen_false);
}

static Xen gxg_pango_font_descriptions_free(Xen descs, Xen n_descs)
{
  #define H_pango_font_descriptions_free "void pango_font_descriptions_free(PangoFontDescription** descs, \
int n_descs)"
  Xen_check_type(Xen_is_PangoFontDescription__(descs), descs, 1, "pango_font_descriptions_free", "PangoFontDescription**");
  Xen_check_type(Xen_is_int(n_descs), n_descs, 2, "pango_font_descriptions_free", "int");
  pango_font_descriptions_free(Xen_to_C_PangoFontDescription__(descs), Xen_to_C_int(n_descs));
  return(Xen_false);
}

static Xen gxg_pango_font_description_set_family(Xen desc, Xen family)
{
  #define H_pango_font_description_set_family "void pango_font_description_set_family(PangoFontDescription* desc, \
char* family)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_family", "PangoFontDescription*");
  Xen_check_type(Xen_is_char_(family), family, 2, "pango_font_description_set_family", "char*");
  pango_font_description_set_family(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_char_(family));
  return(Xen_false);
}

static Xen gxg_pango_font_description_set_family_static(Xen desc, Xen family)
{
  #define H_pango_font_description_set_family_static "void pango_font_description_set_family_static(PangoFontDescription* desc, \
char* family)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_family_static", "PangoFontDescription*");
  Xen_check_type(Xen_is_char_(family), family, 2, "pango_font_description_set_family_static", "char*");
  pango_font_description_set_family_static(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_char_(family));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_family(Xen desc)
{
  #define H_pango_font_description_get_family "char* pango_font_description_get_family(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_family", "PangoFontDescription*");
  return(C_to_Xen_char_(pango_font_description_get_family(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_style(Xen desc, Xen style)
{
  #define H_pango_font_description_set_style "void pango_font_description_set_style(PangoFontDescription* desc, \
PangoStyle style)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_style", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoStyle(style), style, 2, "pango_font_description_set_style", "PangoStyle");
  pango_font_description_set_style(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoStyle(style));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_style(Xen desc)
{
  #define H_pango_font_description_get_style "PangoStyle pango_font_description_get_style(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_style", "PangoFontDescription*");
  return(C_to_Xen_PangoStyle(pango_font_description_get_style(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_variant(Xen desc, Xen variant)
{
  #define H_pango_font_description_set_variant "void pango_font_description_set_variant(PangoFontDescription* desc, \
PangoVariant variant)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_variant", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoVariant(variant), variant, 2, "pango_font_description_set_variant", "PangoVariant");
  pango_font_description_set_variant(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoVariant(variant));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_variant(Xen desc)
{
  #define H_pango_font_description_get_variant "PangoVariant pango_font_description_get_variant(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_variant", "PangoFontDescription*");
  return(C_to_Xen_PangoVariant(pango_font_description_get_variant(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_weight(Xen desc, Xen weight)
{
  #define H_pango_font_description_set_weight "void pango_font_description_set_weight(PangoFontDescription* desc, \
PangoWeight weight)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_weight", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoWeight(weight), weight, 2, "pango_font_description_set_weight", "PangoWeight");
  pango_font_description_set_weight(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoWeight(weight));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_weight(Xen desc)
{
  #define H_pango_font_description_get_weight "PangoWeight pango_font_description_get_weight(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_weight", "PangoFontDescription*");
  return(C_to_Xen_PangoWeight(pango_font_description_get_weight(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_stretch(Xen desc, Xen stretch)
{
  #define H_pango_font_description_set_stretch "void pango_font_description_set_stretch(PangoFontDescription* desc, \
PangoStretch stretch)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_stretch", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoStretch(stretch), stretch, 2, "pango_font_description_set_stretch", "PangoStretch");
  pango_font_description_set_stretch(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoStretch(stretch));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_stretch(Xen desc)
{
  #define H_pango_font_description_get_stretch "PangoStretch pango_font_description_get_stretch(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_stretch", "PangoFontDescription*");
  return(C_to_Xen_PangoStretch(pango_font_description_get_stretch(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_set_size(Xen desc, Xen size)
{
  #define H_pango_font_description_set_size "void pango_font_description_set_size(PangoFontDescription* desc, \
gint size)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_size", "PangoFontDescription*");
  Xen_check_type(Xen_is_gint(size), size, 2, "pango_font_description_set_size", "gint");
  pango_font_description_set_size(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_gint(size));
  return(Xen_false);
}

static Xen gxg_pango_font_description_get_size(Xen desc)
{
  #define H_pango_font_description_get_size "gint pango_font_description_get_size(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_size", "PangoFontDescription*");
  return(C_to_Xen_gint(pango_font_description_get_size(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_get_set_fields(Xen desc)
{
  #define H_pango_font_description_get_set_fields "PangoFontMask pango_font_description_get_set_fields(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_get_set_fields", "PangoFontDescription*");
  return(C_to_Xen_PangoFontMask(pango_font_description_get_set_fields(Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_description_unset_fields(Xen desc, Xen to_unset)
{
  #define H_pango_font_description_unset_fields "void pango_font_description_unset_fields(PangoFontDescription* desc, \
PangoFontMask to_unset)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_unset_fields", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontMask(to_unset), to_unset, 2, "pango_font_description_unset_fields", "PangoFontMask");
  pango_font_description_unset_fields(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontMask(to_unset));
  return(Xen_false);
}

static Xen gxg_pango_font_description_merge(Xen desc, Xen desc_to_merge, Xen replace_existing)
{
  #define H_pango_font_description_merge "void pango_font_description_merge(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_merge", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc_to_merge), desc_to_merge, 2, "pango_font_description_merge", "PangoFontDescription*");
  Xen_check_type(Xen_is_gboolean(replace_existing), replace_existing, 3, "pango_font_description_merge", "gboolean");
  pango_font_description_merge(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontDescription_(desc_to_merge), Xen_to_C_gboolean(replace_existing));
  return(Xen_false);
}

static Xen gxg_pango_font_description_merge_static(Xen desc, Xen desc_to_merge, Xen replace_existing)
{
  #define H_pango_font_description_merge_static "void pango_font_description_merge_static(PangoFontDescription* desc, \
PangoFontDescription* desc_to_merge, gboolean replace_existing)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_merge_static", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc_to_merge), desc_to_merge, 2, "pango_font_description_merge_static", "PangoFontDescription*");
  Xen_check_type(Xen_is_gboolean(replace_existing), replace_existing, 3, "pango_font_description_merge_static", "gboolean");
  pango_font_description_merge_static(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontDescription_(desc_to_merge), 
                                      Xen_to_C_gboolean(replace_existing));
  return(Xen_false);
}

static Xen gxg_pango_font_description_better_match(Xen desc, Xen old_match, Xen new_match)
{
  #define H_pango_font_description_better_match "gboolean pango_font_description_better_match(PangoFontDescription* desc, \
PangoFontDescription* old_match, PangoFontDescription* new_match)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_better_match", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(old_match), old_match, 2, "pango_font_description_better_match", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoFontDescription_(new_match), new_match, 3, "pango_font_description_better_match", "PangoFontDescription*");
  return(C_to_Xen_gboolean(pango_font_description_better_match(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoFontDescription_(old_match), 
                                                               Xen_to_C_PangoFontDescription_(new_match))));
}

static Xen gxg_pango_font_description_from_string(Xen str)
{
  #define H_pango_font_description_from_string "PangoFontDescription* pango_font_description_from_string(char* str)"
  Xen_check_type(Xen_is_char_(str), str, 1, "pango_font_description_from_string", "char*");
  return(C_to_Xen_PangoFontDescription_(pango_font_description_from_string(Xen_to_C_char_(str))));
}

static Xen gxg_pango_font_description_to_string(Xen desc)
{
  #define H_pango_font_description_to_string "char* pango_font_description_to_string(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_to_string", "PangoFontDescription*");
  {
   char* result;
   Xen rtn;
   result = pango_font_description_to_string(Xen_to_C_PangoFontDescription_(desc));
   rtn = C_to_Xen_char_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_pango_font_description_to_filename(Xen desc)
{
  #define H_pango_font_description_to_filename "char* pango_font_description_to_filename(PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_to_filename", "PangoFontDescription*");
  {
   char* result;
   Xen rtn;
   result = pango_font_description_to_filename(Xen_to_C_PangoFontDescription_(desc));
   rtn = C_to_Xen_char_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_pango_font_metrics_ref(Xen metrics)
{
  #define H_pango_font_metrics_ref "PangoFontMetrics* pango_font_metrics_ref(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_ref", "PangoFontMetrics*");
  return(C_to_Xen_PangoFontMetrics_(pango_font_metrics_ref(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_unref(Xen metrics)
{
  #define H_pango_font_metrics_unref "void pango_font_metrics_unref(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_unref", "PangoFontMetrics*");
  pango_font_metrics_unref(Xen_to_C_PangoFontMetrics_(metrics));
  return(Xen_false);
}

static Xen gxg_pango_font_metrics_get_ascent(Xen metrics)
{
  #define H_pango_font_metrics_get_ascent "int pango_font_metrics_get_ascent(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_ascent", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_ascent(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_descent(Xen metrics)
{
  #define H_pango_font_metrics_get_descent "int pango_font_metrics_get_descent(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_descent", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_descent(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_approximate_char_width(Xen metrics)
{
  #define H_pango_font_metrics_get_approximate_char_width "int pango_font_metrics_get_approximate_char_width(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_approximate_char_width", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_approximate_char_width(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_approximate_digit_width(Xen metrics)
{
  #define H_pango_font_metrics_get_approximate_digit_width "int pango_font_metrics_get_approximate_digit_width(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_approximate_digit_width", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_approximate_digit_width(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_family_list_faces(Xen family, Xen ignore_faces, Xen ignore_n_faces)
{
  #define H_pango_font_family_list_faces "void pango_font_family_list_faces(PangoFontFamily* family, \
PangoFontFace*** [faces], int* [n_faces])"
  PangoFontFace** ref_faces = NULL;
  int ref_n_faces;
  Xen_check_type(Xen_is_PangoFontFamily_(family), family, 1, "pango_font_family_list_faces", "PangoFontFamily*");
  pango_font_family_list_faces(Xen_to_C_PangoFontFamily_(family), &ref_faces, &ref_n_faces);
  return(Xen_list_2(C_to_Xen_PangoFontFace__(ref_faces), C_to_Xen_int(ref_n_faces)));
}

static Xen gxg_pango_font_family_get_name(Xen family)
{
  #define H_pango_font_family_get_name "char* pango_font_family_get_name(PangoFontFamily* family)"
  Xen_check_type(Xen_is_PangoFontFamily_(family), family, 1, "pango_font_family_get_name", "PangoFontFamily*");
  return(C_to_Xen_char_(pango_font_family_get_name(Xen_to_C_PangoFontFamily_(family))));
}

static Xen gxg_pango_font_face_describe(Xen face)
{
  #define H_pango_font_face_describe "PangoFontDescription* pango_font_face_describe(PangoFontFace* face)"
  Xen_check_type(Xen_is_PangoFontFace_(face), face, 1, "pango_font_face_describe", "PangoFontFace*");
  return(C_to_Xen_PangoFontDescription_(pango_font_face_describe(Xen_to_C_PangoFontFace_(face))));
}

static Xen gxg_pango_font_face_get_face_name(Xen face)
{
  #define H_pango_font_face_get_face_name "char* pango_font_face_get_face_name(PangoFontFace* face)"
  Xen_check_type(Xen_is_PangoFontFace_(face), face, 1, "pango_font_face_get_face_name", "PangoFontFace*");
  return(C_to_Xen_char_(pango_font_face_get_face_name(Xen_to_C_PangoFontFace_(face))));
}

static Xen gxg_pango_font_describe(Xen font)
{
  #define H_pango_font_describe "PangoFontDescription* pango_font_describe(PangoFont* font)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_describe", "PangoFont*");
  return(C_to_Xen_PangoFontDescription_(pango_font_describe(Xen_to_C_PangoFont_(font))));
}

static Xen gxg_pango_font_get_coverage(Xen font, Xen language)
{
  #define H_pango_font_get_coverage "PangoCoverage* pango_font_get_coverage(PangoFont* font, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_get_coverage", "PangoFont*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 2, "pango_font_get_coverage", "PangoLanguage*");
  return(C_to_Xen_PangoCoverage_(pango_font_get_coverage(Xen_to_C_PangoFont_(font), Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_font_get_metrics(Xen font, Xen language)
{
  #define H_pango_font_get_metrics "PangoFontMetrics* pango_font_get_metrics(PangoFont* font, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_get_metrics", "PangoFont*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 2, "pango_font_get_metrics", "PangoLanguage*");
  return(C_to_Xen_PangoFontMetrics_(pango_font_get_metrics(Xen_to_C_PangoFont_(font), Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_font_get_glyph_extents(Xen font, Xen glyph, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_font_get_glyph_extents "void pango_font_get_glyph_extents(PangoFont* font, PangoGlyph glyph, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoFont_(font), font, 1, "pango_font_get_glyph_extents", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyph(glyph), glyph, 2, "pango_font_get_glyph_extents", "PangoGlyph");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 3, "pango_font_get_glyph_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 4, "pango_font_get_glyph_extents", "PangoRectangle*");
  pango_font_get_glyph_extents(Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyph(glyph), Xen_to_C_PangoRectangle_(ink_rect), 
                               Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_font_map_load_font(Xen fontmap, Xen context, Xen desc)
{
  #define H_pango_font_map_load_font "PangoFont* pango_font_map_load_font(PangoFontMap* fontmap, PangoContext* context, \
PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoFontMap_(fontmap), fontmap, 1, "pango_font_map_load_font", "PangoFontMap*");
  Xen_check_type(Xen_is_PangoContext_(context), context, 2, "pango_font_map_load_font", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 3, "pango_font_map_load_font", "PangoFontDescription*");
  return(C_to_Xen_PangoFont_(pango_font_map_load_font(Xen_to_C_PangoFontMap_(fontmap), Xen_to_C_PangoContext_(context), Xen_to_C_PangoFontDescription_(desc))));
}

static Xen gxg_pango_font_map_load_fontset(Xen fontmap, Xen context, Xen desc, Xen language)
{
  #define H_pango_font_map_load_fontset "PangoFontset* pango_font_map_load_fontset(PangoFontMap* fontmap, \
PangoContext* context, PangoFontDescription* desc, PangoLanguage* language)"
  Xen_check_type(Xen_is_PangoFontMap_(fontmap), fontmap, 1, "pango_font_map_load_fontset", "PangoFontMap*");
  Xen_check_type(Xen_is_PangoContext_(context), context, 2, "pango_font_map_load_fontset", "PangoContext*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 3, "pango_font_map_load_fontset", "PangoFontDescription*");
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 4, "pango_font_map_load_fontset", "PangoLanguage*");
  return(C_to_Xen_PangoFontset_(pango_font_map_load_fontset(Xen_to_C_PangoFontMap_(fontmap), Xen_to_C_PangoContext_(context), 
                                                            Xen_to_C_PangoFontDescription_(desc), Xen_to_C_PangoLanguage_(language))));
}

static Xen gxg_pango_font_map_list_families(Xen fontmap, Xen ignore_families, Xen ignore_n_families)
{
  #define H_pango_font_map_list_families "void pango_font_map_list_families(PangoFontMap* fontmap, PangoFontFamily*** [families], \
int* [n_families])"
  PangoFontFamily** ref_families = NULL;
  int ref_n_families;
  Xen_check_type(Xen_is_PangoFontMap_(fontmap), fontmap, 1, "pango_font_map_list_families", "PangoFontMap*");
  pango_font_map_list_families(Xen_to_C_PangoFontMap_(fontmap), &ref_families, &ref_n_families);
  return(Xen_list_2(C_to_Xen_PangoFontFamily__(ref_families), C_to_Xen_int(ref_n_families)));
}

static Xen gxg_pango_glyph_string_new(void)
{
  #define H_pango_glyph_string_new "PangoGlyphString* pango_glyph_string_new( void)"
  return(C_to_Xen_PangoGlyphString_(pango_glyph_string_new()));
}

static Xen gxg_pango_glyph_string_set_size(Xen string, Xen new_len)
{
  #define H_pango_glyph_string_set_size "void pango_glyph_string_set_size(PangoGlyphString* string, gint new_len)"
  Xen_check_type(Xen_is_PangoGlyphString_(string), string, 1, "pango_glyph_string_set_size", "PangoGlyphString*");
  Xen_check_type(Xen_is_gint(new_len), new_len, 2, "pango_glyph_string_set_size", "gint");
  pango_glyph_string_set_size(Xen_to_C_PangoGlyphString_(string), Xen_to_C_gint(new_len));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_copy(Xen string)
{
  #define H_pango_glyph_string_copy "PangoGlyphString* pango_glyph_string_copy(PangoGlyphString* string)"
  Xen_check_type(Xen_is_PangoGlyphString_(string), string, 1, "pango_glyph_string_copy", "PangoGlyphString*");
  return(C_to_Xen_PangoGlyphString_(pango_glyph_string_copy(Xen_to_C_PangoGlyphString_(string))));
}

static Xen gxg_pango_glyph_string_free(Xen string)
{
  #define H_pango_glyph_string_free "void pango_glyph_string_free(PangoGlyphString* string)"
  Xen_check_type(Xen_is_PangoGlyphString_(string), string, 1, "pango_glyph_string_free", "PangoGlyphString*");
  pango_glyph_string_free(Xen_to_C_PangoGlyphString_(string));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_extents(Xen glyphs, Xen font, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_glyph_string_extents "void pango_glyph_string_extents(PangoGlyphString* glyphs, PangoFont* font, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_extents", "PangoGlyphString*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_glyph_string_extents", "PangoFont*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 3, "pango_glyph_string_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 4, "pango_glyph_string_extents", "PangoRectangle*");
  pango_glyph_string_extents(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_PangoFont_(font), Xen_to_C_PangoRectangle_(ink_rect), 
                             Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_extents_range(Xen glyphs, Xen start, Xen end, Xen font, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_glyph_string_extents_range "void pango_glyph_string_extents_range(PangoGlyphString* glyphs, \
int start, int end, PangoFont* font, PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_extents_range", "PangoGlyphString*");
  Xen_check_type(Xen_is_int(start), start, 2, "pango_glyph_string_extents_range", "int");
  Xen_check_type(Xen_is_int(end), end, 3, "pango_glyph_string_extents_range", "int");
  Xen_check_type(Xen_is_PangoFont_(font), font, 4, "pango_glyph_string_extents_range", "PangoFont*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 5, "pango_glyph_string_extents_range", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 6, "pango_glyph_string_extents_range", "PangoRectangle*");
  pango_glyph_string_extents_range(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_int(start), Xen_to_C_int(end), Xen_to_C_PangoFont_(font), 
                                   Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_glyph_string_get_logical_widths(Xen glyphs, Xen text, Xen length, Xen embedding_level, Xen ignore_logical_widths)
{
  #define H_pango_glyph_string_get_logical_widths "void pango_glyph_string_get_logical_widths(PangoGlyphString* glyphs, \
char* text, int length, int embedding_level, int* [logical_widths])"
  int ref_logical_widths;
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_get_logical_widths", "PangoGlyphString*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_glyph_string_get_logical_widths", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_glyph_string_get_logical_widths", "int");
  Xen_check_type(Xen_is_int(embedding_level), embedding_level, 4, "pango_glyph_string_get_logical_widths", "int");
  pango_glyph_string_get_logical_widths(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_int(embedding_level), 
                                        &ref_logical_widths);
  return(Xen_list_1(C_to_Xen_int(ref_logical_widths)));
}

static Xen gxg_pango_glyph_string_index_to_x(Xen glyphs, Xen text, Xen length, Xen analysis, Xen index, Xen trailing, Xen ignore_x_pos)
{
  #define H_pango_glyph_string_index_to_x "void pango_glyph_string_index_to_x(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int index, gboolean trailing, int* [x_pos])"
  int ref_x_pos;
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_index_to_x", "PangoGlyphString*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_glyph_string_index_to_x", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_glyph_string_index_to_x", "int");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 4, "pango_glyph_string_index_to_x", "PangoAnalysis*");
  Xen_check_type(Xen_is_int(index), index, 5, "pango_glyph_string_index_to_x", "int");
  Xen_check_type(Xen_is_gboolean(trailing), trailing, 6, "pango_glyph_string_index_to_x", "gboolean");
  pango_glyph_string_index_to_x(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_PangoAnalysis_(analysis), 
                                Xen_to_C_int(index), Xen_to_C_gboolean(trailing), &ref_x_pos);
  return(Xen_list_1(C_to_Xen_int(ref_x_pos)));
}

static Xen gxg_pango_glyph_string_x_to_index(Xen glyphs, Xen text, Xen length, Xen analysis, Xen x_pos, Xen ignore_index, Xen ignore_trailing)
{
  #define H_pango_glyph_string_x_to_index "void pango_glyph_string_x_to_index(PangoGlyphString* glyphs, \
char* text, int length, PangoAnalysis* analysis, int x_pos, int* [index], int* [trailing])"
  int ref_index;
  int ref_trailing;
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 1, "pango_glyph_string_x_to_index", "PangoGlyphString*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_glyph_string_x_to_index", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_glyph_string_x_to_index", "int");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 4, "pango_glyph_string_x_to_index", "PangoAnalysis*");
  Xen_check_type(Xen_is_int(x_pos), x_pos, 5, "pango_glyph_string_x_to_index", "int");
  pango_glyph_string_x_to_index(Xen_to_C_PangoGlyphString_(glyphs), Xen_to_C_char_(text), Xen_to_C_int(length), Xen_to_C_PangoAnalysis_(analysis), 
                                Xen_to_C_int(x_pos), &ref_index, &ref_trailing);
  return(Xen_list_2(C_to_Xen_int(ref_index), C_to_Xen_int(ref_trailing)));
}

static Xen gxg_pango_shape(Xen text, Xen length, Xen analysis, Xen glyphs)
{
  #define H_pango_shape "void pango_shape(gchar* text, gint length, PangoAnalysis* analysis, PangoGlyphString* glyphs)"
  Xen_check_type(Xen_is_gchar_(text), text, 1, "pango_shape", "gchar*");
  Xen_check_type(Xen_is_gint(length), length, 2, "pango_shape", "gint");
  Xen_check_type(Xen_is_PangoAnalysis_(analysis), analysis, 3, "pango_shape", "PangoAnalysis*");
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 4, "pango_shape", "PangoGlyphString*");
  pango_shape(Xen_to_C_gchar_(text), Xen_to_C_gint(length), Xen_to_C_PangoAnalysis_(analysis), Xen_to_C_PangoGlyphString_(glyphs));
  return(Xen_false);
}

static Xen gxg_pango_reorder_items(Xen logical_items)
{
  #define H_pango_reorder_items "GList* pango_reorder_items(GList* logical_items)"
  Xen_check_type(Xen_is_GList_(logical_items), logical_items, 1, "pango_reorder_items", "GList*");
  return(C_to_Xen_GList_(pango_reorder_items(Xen_to_C_GList_(logical_items))));
}

static Xen gxg_pango_item_new(void)
{
  #define H_pango_item_new "PangoItem* pango_item_new( void)"
  return(C_to_Xen_PangoItem_(pango_item_new()));
}

static Xen gxg_pango_item_copy(Xen item)
{
  #define H_pango_item_copy "PangoItem* pango_item_copy(PangoItem* item)"
  Xen_check_type(Xen_is_PangoItem_(item), item, 1, "pango_item_copy", "PangoItem*");
  return(C_to_Xen_PangoItem_(pango_item_copy(Xen_to_C_PangoItem_(item))));
}

static Xen gxg_pango_item_free(Xen item)
{
  #define H_pango_item_free "void pango_item_free(PangoItem* item)"
  Xen_check_type(Xen_is_PangoItem_(item), item, 1, "pango_item_free", "PangoItem*");
  pango_item_free(Xen_to_C_PangoItem_(item));
  return(Xen_false);
}

static Xen gxg_pango_item_split(Xen orig, Xen split_index, Xen split_offset)
{
  #define H_pango_item_split "PangoItem* pango_item_split(PangoItem* orig, int split_index, int split_offset)"
  Xen_check_type(Xen_is_PangoItem_(orig), orig, 1, "pango_item_split", "PangoItem*");
  Xen_check_type(Xen_is_int(split_index), split_index, 2, "pango_item_split", "int");
  Xen_check_type(Xen_is_int(split_offset), split_offset, 3, "pango_item_split", "int");
  return(C_to_Xen_PangoItem_(pango_item_split(Xen_to_C_PangoItem_(orig), Xen_to_C_int(split_index), Xen_to_C_int(split_offset))));
}

static Xen gxg_pango_layout_new(Xen context)
{
  #define H_pango_layout_new "PangoLayout* pango_layout_new(PangoContext* context)"
  Xen_check_type(Xen_is_PangoContext_(context), context, 1, "pango_layout_new", "PangoContext*");
  return(C_to_Xen_PangoLayout_(pango_layout_new(Xen_to_C_PangoContext_(context))));
}

static Xen gxg_pango_layout_copy(Xen src)
{
  #define H_pango_layout_copy "PangoLayout* pango_layout_copy(PangoLayout* src)"
  Xen_check_type(Xen_is_PangoLayout_(src), src, 1, "pango_layout_copy", "PangoLayout*");
  return(C_to_Xen_PangoLayout_(pango_layout_copy(Xen_to_C_PangoLayout_(src))));
}

static Xen gxg_pango_layout_get_context(Xen layout)
{
  #define H_pango_layout_get_context "PangoContext* pango_layout_get_context(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_context", "PangoLayout*");
  return(C_to_Xen_PangoContext_(pango_layout_get_context(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_attributes(Xen layout, Xen attrs)
{
  #define H_pango_layout_set_attributes "void pango_layout_set_attributes(PangoLayout* layout, PangoAttrList* attrs)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_attributes", "PangoLayout*");
  Xen_check_type(Xen_is_PangoAttrList_(attrs), attrs, 2, "pango_layout_set_attributes", "PangoAttrList*");
  pango_layout_set_attributes(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoAttrList_(attrs));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_attributes(Xen layout)
{
  #define H_pango_layout_get_attributes "PangoAttrList* pango_layout_get_attributes(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_attributes", "PangoLayout*");
  return(C_to_Xen_PangoAttrList_(pango_layout_get_attributes(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_text(Xen layout, Xen text, Xen length)
{
  #define H_pango_layout_set_text "void pango_layout_set_text(PangoLayout* layout, char* text, int length)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_text", "PangoLayout*");
  Xen_check_type(Xen_is_char_(text), text, 2, "pango_layout_set_text", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_layout_set_text", "int");
  pango_layout_set_text(Xen_to_C_PangoLayout_(layout), Xen_to_C_char_(text), Xen_to_C_int(length));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_text(Xen layout)
{
  #define H_pango_layout_get_text "char* pango_layout_get_text(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_text", "PangoLayout*");
  return(C_to_Xen_char_(pango_layout_get_text(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_markup(Xen layout, Xen markup, Xen length)
{
  #define H_pango_layout_set_markup "void pango_layout_set_markup(PangoLayout* layout, char* markup, \
int length)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_markup", "PangoLayout*");
  Xen_check_type(Xen_is_char_(markup), markup, 2, "pango_layout_set_markup", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_layout_set_markup", "int");
  pango_layout_set_markup(Xen_to_C_PangoLayout_(layout), Xen_to_C_char_(markup), Xen_to_C_int(length));
  return(Xen_false);
}

static Xen gxg_pango_layout_set_markup_with_accel(Xen layout, Xen markup, Xen length, Xen accel_marker, Xen accel_char)
{
  #define H_pango_layout_set_markup_with_accel "void pango_layout_set_markup_with_accel(PangoLayout* layout, \
char* markup, int length, gunichar accel_marker, gunichar* accel_char)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_markup_with_accel", "PangoLayout*");
  Xen_check_type(Xen_is_char_(markup), markup, 2, "pango_layout_set_markup_with_accel", "char*");
  Xen_check_type(Xen_is_int(length), length, 3, "pango_layout_set_markup_with_accel", "int");
  Xen_check_type(Xen_is_gunichar(accel_marker), accel_marker, 4, "pango_layout_set_markup_with_accel", "gunichar");
  Xen_check_type(Xen_is_gunichar_(accel_char), accel_char, 5, "pango_layout_set_markup_with_accel", "gunichar*");
  pango_layout_set_markup_with_accel(Xen_to_C_PangoLayout_(layout), Xen_to_C_char_(markup), Xen_to_C_int(length), Xen_to_C_gunichar(accel_marker), 
                                     Xen_to_C_gunichar_(accel_char));
  return(Xen_false);
}

static Xen gxg_pango_layout_set_font_description(Xen layout, Xen desc)
{
  #define H_pango_layout_set_font_description "void pango_layout_set_font_description(PangoLayout* layout, \
PangoFontDescription* desc)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_font_description", "PangoLayout*");
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 2, "pango_layout_set_font_description", "PangoFontDescription*");
  pango_layout_set_font_description(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoFontDescription_(desc));
  return(Xen_false);
}

static Xen gxg_pango_layout_set_width(Xen layout, Xen width)
{
  #define H_pango_layout_set_width "void pango_layout_set_width(PangoLayout* layout, int width)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_width", "PangoLayout*");
  Xen_check_type(Xen_is_int(width), width, 2, "pango_layout_set_width", "int");
  pango_layout_set_width(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(width));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_width(Xen layout)
{
  #define H_pango_layout_get_width "int pango_layout_get_width(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_width", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_width(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_wrap(Xen layout, Xen wrap)
{
  #define H_pango_layout_set_wrap "void pango_layout_set_wrap(PangoLayout* layout, PangoWrapMode wrap)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_wrap", "PangoLayout*");
  Xen_check_type(Xen_is_PangoWrapMode(wrap), wrap, 2, "pango_layout_set_wrap", "PangoWrapMode");
  pango_layout_set_wrap(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoWrapMode(wrap));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_wrap(Xen layout)
{
  #define H_pango_layout_get_wrap "PangoWrapMode pango_layout_get_wrap(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_wrap", "PangoLayout*");
  return(C_to_Xen_PangoWrapMode(pango_layout_get_wrap(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_indent(Xen layout, Xen indent)
{
  #define H_pango_layout_set_indent "void pango_layout_set_indent(PangoLayout* layout, int indent)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_indent", "PangoLayout*");
  Xen_check_type(Xen_is_int(indent), indent, 2, "pango_layout_set_indent", "int");
  pango_layout_set_indent(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(indent));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_indent(Xen layout)
{
  #define H_pango_layout_get_indent "int pango_layout_get_indent(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_indent", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_indent(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_spacing(Xen layout, Xen spacing)
{
  #define H_pango_layout_set_spacing "void pango_layout_set_spacing(PangoLayout* layout, int spacing)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_spacing", "PangoLayout*");
  Xen_check_type(Xen_is_int(spacing), spacing, 2, "pango_layout_set_spacing", "int");
  pango_layout_set_spacing(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(spacing));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_spacing(Xen layout)
{
  #define H_pango_layout_get_spacing "int pango_layout_get_spacing(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_spacing", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_spacing(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_justify(Xen layout, Xen justify)
{
  #define H_pango_layout_set_justify "void pango_layout_set_justify(PangoLayout* layout, gboolean justify)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_justify", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(justify), justify, 2, "pango_layout_set_justify", "gboolean");
  pango_layout_set_justify(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(justify));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_justify(Xen layout)
{
  #define H_pango_layout_get_justify "gboolean pango_layout_get_justify(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_justify", "PangoLayout*");
  return(C_to_Xen_gboolean(pango_layout_get_justify(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_alignment(Xen layout, Xen alignment)
{
  #define H_pango_layout_set_alignment "void pango_layout_set_alignment(PangoLayout* layout, PangoAlignment alignment)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_alignment", "PangoLayout*");
  Xen_check_type(Xen_is_PangoAlignment(alignment), alignment, 2, "pango_layout_set_alignment", "PangoAlignment");
  pango_layout_set_alignment(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoAlignment(alignment));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_alignment(Xen layout)
{
  #define H_pango_layout_get_alignment "PangoAlignment pango_layout_get_alignment(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_alignment", "PangoLayout*");
  return(C_to_Xen_PangoAlignment(pango_layout_get_alignment(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_tabs(Xen layout, Xen tabs)
{
  #define H_pango_layout_set_tabs "void pango_layout_set_tabs(PangoLayout* layout, PangoTabArray* tabs)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_tabs", "PangoLayout*");
  Xen_check_type(Xen_is_PangoTabArray_(tabs) || Xen_is_false(tabs), tabs, 2, "pango_layout_set_tabs", "PangoTabArray*");
  pango_layout_set_tabs(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoTabArray_(tabs));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_tabs(Xen layout)
{
  #define H_pango_layout_get_tabs "PangoTabArray* pango_layout_get_tabs(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_tabs", "PangoLayout*");
  return(C_to_Xen_PangoTabArray_(pango_layout_get_tabs(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_set_single_paragraph_mode(Xen layout, Xen setting)
{
  #define H_pango_layout_set_single_paragraph_mode "void pango_layout_set_single_paragraph_mode(PangoLayout* layout, \
gboolean setting)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_single_paragraph_mode", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "pango_layout_set_single_paragraph_mode", "gboolean");
  pango_layout_set_single_paragraph_mode(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_single_paragraph_mode(Xen layout)
{
  #define H_pango_layout_get_single_paragraph_mode "gboolean pango_layout_get_single_paragraph_mode(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_single_paragraph_mode", "PangoLayout*");
  return(C_to_Xen_gboolean(pango_layout_get_single_paragraph_mode(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_context_changed(Xen layout)
{
  #define H_pango_layout_context_changed "void pango_layout_context_changed(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_context_changed", "PangoLayout*");
  pango_layout_context_changed(Xen_to_C_PangoLayout_(layout));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_log_attrs(Xen layout, Xen ignore_attrs, Xen ignore_n_attrs)
{
  #define H_pango_layout_get_log_attrs "void pango_layout_get_log_attrs(PangoLayout* layout, PangoLogAttr** [attrs], \
gint* [n_attrs])"
  PangoLogAttr* ref_attrs = NULL;
  gint ref_n_attrs;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_log_attrs", "PangoLayout*");
  pango_layout_get_log_attrs(Xen_to_C_PangoLayout_(layout), &ref_attrs, &ref_n_attrs);
  return(Xen_list_2(C_to_Xen_PangoLogAttr_(ref_attrs), C_to_Xen_gint(ref_n_attrs)));
}

static Xen gxg_pango_layout_index_to_pos(Xen layout, Xen index, Xen pos)
{
  #define H_pango_layout_index_to_pos "void pango_layout_index_to_pos(PangoLayout* layout, int index, \
PangoRectangle* pos)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_index_to_pos", "PangoLayout*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_layout_index_to_pos", "int");
  Xen_check_type(Xen_is_PangoRectangle_(pos), pos, 3, "pango_layout_index_to_pos", "PangoRectangle*");
  pango_layout_index_to_pos(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(index), Xen_to_C_PangoRectangle_(pos));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_cursor_pos(Xen layout, Xen index, Xen strong_pos, Xen weak_pos)
{
  #define H_pango_layout_get_cursor_pos "void pango_layout_get_cursor_pos(PangoLayout* layout, int index, \
PangoRectangle* strong_pos, PangoRectangle* weak_pos)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_cursor_pos", "PangoLayout*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_layout_get_cursor_pos", "int");
  Xen_check_type(Xen_is_PangoRectangle_(strong_pos), strong_pos, 3, "pango_layout_get_cursor_pos", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(weak_pos), weak_pos, 4, "pango_layout_get_cursor_pos", "PangoRectangle*");
  pango_layout_get_cursor_pos(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(index), Xen_to_C_PangoRectangle_(strong_pos), Xen_to_C_PangoRectangle_(weak_pos));
  return(Xen_false);
}

static Xen gxg_pango_layout_move_cursor_visually(Xen layout, Xen strong, Xen old_index, Xen old_trailing, Xen direction, Xen new_index, Xen new_trailing)
{
  #define H_pango_layout_move_cursor_visually "void pango_layout_move_cursor_visually(PangoLayout* layout, \
gboolean strong, int old_index, int old_trailing, int direction, int* new_index, int* new_trailing)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_move_cursor_visually", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(strong), strong, 2, "pango_layout_move_cursor_visually", "gboolean");
  Xen_check_type(Xen_is_int(old_index), old_index, 3, "pango_layout_move_cursor_visually", "int");
  Xen_check_type(Xen_is_int(old_trailing), old_trailing, 4, "pango_layout_move_cursor_visually", "int");
  Xen_check_type(Xen_is_int(direction), direction, 5, "pango_layout_move_cursor_visually", "int");
  Xen_check_type(Xen_is_int_(new_index), new_index, 6, "pango_layout_move_cursor_visually", "int*");
  Xen_check_type(Xen_is_int_(new_trailing), new_trailing, 7, "pango_layout_move_cursor_visually", "int*");
  pango_layout_move_cursor_visually(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(strong), Xen_to_C_int(old_index), Xen_to_C_int(old_trailing), 
                                    Xen_to_C_int(direction), Xen_to_C_int_(new_index), Xen_to_C_int_(new_trailing));
  return(Xen_false);
}

static Xen gxg_pango_layout_xy_to_index(Xen layout, Xen x, Xen y, Xen ignore_index, Xen ignore_trailing)
{
  #define H_pango_layout_xy_to_index "gboolean pango_layout_xy_to_index(PangoLayout* layout, int x, int y, \
int* [index], int* [trailing])"
  int ref_index;
  int ref_trailing;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_xy_to_index", "PangoLayout*");
  Xen_check_type(Xen_is_int(x), x, 2, "pango_layout_xy_to_index", "int");
  Xen_check_type(Xen_is_int(y), y, 3, "pango_layout_xy_to_index", "int");
  {
    Xen result;
    result = C_to_Xen_gboolean(pango_layout_xy_to_index(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(x), Xen_to_C_int(y), 
                                                        &ref_index, &ref_trailing));
    return(Xen_list_3(result, C_to_Xen_int(ref_index), C_to_Xen_int(ref_trailing)));
   }
}

static Xen gxg_pango_layout_get_extents(Xen layout, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_get_extents "void pango_layout_get_extents(PangoLayout* layout, PangoRectangle* ink_rect, \
PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_extents", "PangoLayout*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_get_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_get_extents", "PangoRectangle*");
  pango_layout_get_extents(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_pixel_extents(Xen layout, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_get_pixel_extents "void pango_layout_get_pixel_extents(PangoLayout* layout, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_pixel_extents", "PangoLayout*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_get_pixel_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_get_pixel_extents", "PangoRectangle*");
  pango_layout_get_pixel_extents(Xen_to_C_PangoLayout_(layout), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_size(Xen layout, Xen ignore_width, Xen ignore_height)
{
  #define H_pango_layout_get_size "void pango_layout_get_size(PangoLayout* layout, int* [width], int* [height])"
  int ref_width;
  int ref_height;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_size", "PangoLayout*");
  pango_layout_get_size(Xen_to_C_PangoLayout_(layout), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_int(ref_width), C_to_Xen_int(ref_height)));
}

static Xen gxg_pango_layout_get_pixel_size(Xen layout, Xen ignore_width, Xen ignore_height)
{
  #define H_pango_layout_get_pixel_size "void pango_layout_get_pixel_size(PangoLayout* layout, int* [width], \
int* [height])"
  int ref_width;
  int ref_height;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_pixel_size", "PangoLayout*");
  pango_layout_get_pixel_size(Xen_to_C_PangoLayout_(layout), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_int(ref_width), C_to_Xen_int(ref_height)));
}

static Xen gxg_pango_layout_get_line_count(Xen layout)
{
  #define H_pango_layout_get_line_count "int pango_layout_get_line_count(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_line_count", "PangoLayout*");
  return(C_to_Xen_int(pango_layout_get_line_count(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_get_line(Xen layout, Xen line)
{
  #define H_pango_layout_get_line "PangoLayoutLine* pango_layout_get_line(PangoLayout* layout, int line)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_line", "PangoLayout*");
  Xen_check_type(Xen_is_int(line), line, 2, "pango_layout_get_line", "int");
  return(C_to_Xen_PangoLayoutLine_(pango_layout_get_line(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(line))));
}

static Xen gxg_pango_layout_get_lines(Xen layout)
{
  #define H_pango_layout_get_lines "GSList* pango_layout_get_lines(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_lines", "PangoLayout*");
  return(C_to_Xen_GSList_(pango_layout_get_lines(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_line_unref(Xen line)
{
  #define H_pango_layout_line_unref "void pango_layout_line_unref(PangoLayoutLine* line)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_unref", "PangoLayoutLine*");
  pango_layout_line_unref(Xen_to_C_PangoLayoutLine_(line));
  return(Xen_false);
}

static Xen gxg_pango_layout_line_x_to_index(Xen line, Xen x_pos, Xen ignore_index, Xen ignore_trailing)
{
  #define H_pango_layout_line_x_to_index "gboolean pango_layout_line_x_to_index(PangoLayoutLine* line, \
int x_pos, int* [index], int* [trailing])"
  int ref_index;
  int ref_trailing;
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_x_to_index", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(x_pos), x_pos, 2, "pango_layout_line_x_to_index", "int");
  {
    Xen result;
    result = C_to_Xen_gboolean(pango_layout_line_x_to_index(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(x_pos), &ref_index, 
                                                            &ref_trailing));
    return(Xen_list_3(result, C_to_Xen_int(ref_index), C_to_Xen_int(ref_trailing)));
   }
}

static Xen gxg_pango_layout_line_index_to_x(Xen line, Xen index, Xen trailing, Xen ignore_x_pos)
{
  #define H_pango_layout_line_index_to_x "void pango_layout_line_index_to_x(PangoLayoutLine* line, int index, \
gboolean trailing, int* [x_pos])"
  int ref_x_pos;
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_index_to_x", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(index), index, 2, "pango_layout_line_index_to_x", "int");
  Xen_check_type(Xen_is_gboolean(trailing), trailing, 3, "pango_layout_line_index_to_x", "gboolean");
  pango_layout_line_index_to_x(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(index), Xen_to_C_gboolean(trailing), &ref_x_pos);
  return(Xen_list_1(C_to_Xen_int(ref_x_pos)));
}

static Xen gxg_pango_layout_line_get_x_ranges(Xen line, Xen start_index, Xen end_index, Xen ignore_ranges, Xen ignore_n_ranges)
{
  #define H_pango_layout_line_get_x_ranges "void pango_layout_line_get_x_ranges(PangoLayoutLine* line, \
int start_index, int end_index, int** [ranges], int* [n_ranges])"
  int* ref_ranges = NULL;
  int ref_n_ranges;
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_get_x_ranges", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(start_index), start_index, 2, "pango_layout_line_get_x_ranges", "int");
  Xen_check_type(Xen_is_int(end_index), end_index, 3, "pango_layout_line_get_x_ranges", "int");
  pango_layout_line_get_x_ranges(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(start_index), Xen_to_C_int(end_index), &ref_ranges, 
                                 &ref_n_ranges);
  return(Xen_list_2(C_to_Xen_int_(ref_ranges), C_to_Xen_int(ref_n_ranges)));
}

static Xen gxg_pango_layout_line_get_extents(Xen line, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_line_get_extents "void pango_layout_line_get_extents(PangoLayoutLine* line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_get_extents", "PangoLayoutLine*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_line_get_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_line_get_extents", "PangoRectangle*");
  pango_layout_line_get_extents(Xen_to_C_PangoLayoutLine_(line), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_line_get_pixel_extents(Xen layout_line, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_line_get_pixel_extents "void pango_layout_line_get_pixel_extents(PangoLayoutLine* layout_line, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutLine_(layout_line), layout_line, 1, "pango_layout_line_get_pixel_extents", "PangoLayoutLine*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_line_get_pixel_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_line_get_pixel_extents", "PangoRectangle*");
  pango_layout_line_get_pixel_extents(Xen_to_C_PangoLayoutLine_(layout_line), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_iter(Xen layout)
{
  #define H_pango_layout_get_iter "PangoLayoutIter* pango_layout_get_iter(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_iter", "PangoLayout*");
  return(C_to_Xen_PangoLayoutIter_(pango_layout_get_iter(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_layout_iter_free(Xen iter)
{
  #define H_pango_layout_iter_free "void pango_layout_iter_free(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_free", "PangoLayoutIter*");
  pango_layout_iter_free(Xen_to_C_PangoLayoutIter_(iter));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_index(Xen iter)
{
  #define H_pango_layout_iter_get_index "int pango_layout_iter_get_index(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_index", "PangoLayoutIter*");
  return(C_to_Xen_int(pango_layout_iter_get_index(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_get_run(Xen iter)
{
  #define H_pango_layout_iter_get_run "PangoLayoutRun* pango_layout_iter_get_run(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_run", "PangoLayoutIter*");
  return(C_to_Xen_PangoLayoutRun_(pango_layout_iter_get_run(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_get_line(Xen iter)
{
  #define H_pango_layout_iter_get_line "PangoLayoutLine* pango_layout_iter_get_line(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_line", "PangoLayoutIter*");
  return(C_to_Xen_PangoLayoutLine_(pango_layout_iter_get_line(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_at_last_line(Xen iter)
{
  #define H_pango_layout_iter_at_last_line "gboolean pango_layout_iter_at_last_line(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_at_last_line", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_at_last_line(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_char(Xen iter)
{
  #define H_pango_layout_iter_next_char "gboolean pango_layout_iter_next_char(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_char", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_char(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_cluster(Xen iter)
{
  #define H_pango_layout_iter_next_cluster "gboolean pango_layout_iter_next_cluster(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_cluster", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_cluster(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_run(Xen iter)
{
  #define H_pango_layout_iter_next_run "gboolean pango_layout_iter_next_run(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_run", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_run(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_next_line(Xen iter)
{
  #define H_pango_layout_iter_next_line "gboolean pango_layout_iter_next_line(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_next_line", "PangoLayoutIter*");
  return(C_to_Xen_gboolean(pango_layout_iter_next_line(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_layout_iter_get_char_extents(Xen iter, Xen logical_rect)
{
  #define H_pango_layout_iter_get_char_extents "void pango_layout_iter_get_char_extents(PangoLayoutIter* iter, \
PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_char_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 2, "pango_layout_iter_get_char_extents", "PangoRectangle*");
  pango_layout_iter_get_char_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_cluster_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_cluster_extents "void pango_layout_iter_get_cluster_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_cluster_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_cluster_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_cluster_extents", "PangoRectangle*");
  pango_layout_iter_get_cluster_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_run_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_run_extents "void pango_layout_iter_get_run_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_run_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_run_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_run_extents", "PangoRectangle*");
  pango_layout_iter_get_run_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_line_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_line_extents "void pango_layout_iter_get_line_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_line_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_line_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_line_extents", "PangoRectangle*");
  pango_layout_iter_get_line_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_line_yrange(Xen iter, Xen ignore_y0, Xen ignore_y1)
{
  #define H_pango_layout_iter_get_line_yrange "void pango_layout_iter_get_line_yrange(PangoLayoutIter* iter, \
int* [y0], int* [y1])"
  int ref_y0;
  int ref_y1;
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_line_yrange", "PangoLayoutIter*");
  pango_layout_iter_get_line_yrange(Xen_to_C_PangoLayoutIter_(iter), &ref_y0, &ref_y1);
  return(Xen_list_2(C_to_Xen_int(ref_y0), C_to_Xen_int(ref_y1)));
}

static Xen gxg_pango_layout_iter_get_layout_extents(Xen iter, Xen ink_rect, Xen logical_rect)
{
  #define H_pango_layout_iter_get_layout_extents "void pango_layout_iter_get_layout_extents(PangoLayoutIter* iter, \
PangoRectangle* ink_rect, PangoRectangle* logical_rect)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_layout_extents", "PangoLayoutIter*");
  Xen_check_type(Xen_is_PangoRectangle_(ink_rect), ink_rect, 2, "pango_layout_iter_get_layout_extents", "PangoRectangle*");
  Xen_check_type(Xen_is_PangoRectangle_(logical_rect), logical_rect, 3, "pango_layout_iter_get_layout_extents", "PangoRectangle*");
  pango_layout_iter_get_layout_extents(Xen_to_C_PangoLayoutIter_(iter), Xen_to_C_PangoRectangle_(ink_rect), Xen_to_C_PangoRectangle_(logical_rect));
  return(Xen_false);
}

static Xen gxg_pango_layout_iter_get_baseline(Xen iter)
{
  #define H_pango_layout_iter_get_baseline "int pango_layout_iter_get_baseline(PangoLayoutIter* iter)"
  Xen_check_type(Xen_is_PangoLayoutIter_(iter), iter, 1, "pango_layout_iter_get_baseline", "PangoLayoutIter*");
  return(C_to_Xen_int(pango_layout_iter_get_baseline(Xen_to_C_PangoLayoutIter_(iter))));
}

static Xen gxg_pango_language_from_string(Xen language)
{
  #define H_pango_language_from_string "PangoLanguage* pango_language_from_string(char* language)"
  Xen_check_type(Xen_is_char_(language), language, 1, "pango_language_from_string", "char*");
  return(C_to_Xen_PangoLanguage_(pango_language_from_string(Xen_to_C_char_(language))));
}

static Xen gxg_pango_language_matches(Xen language, Xen range_list)
{
  #define H_pango_language_matches "gboolean pango_language_matches(PangoLanguage* language, char* range_list)"
  Xen_check_type(Xen_is_PangoLanguage_(language), language, 1, "pango_language_matches", "PangoLanguage*");
  Xen_check_type(Xen_is_char_(range_list), range_list, 2, "pango_language_matches", "char*");
  return(C_to_Xen_gboolean(pango_language_matches(Xen_to_C_PangoLanguage_(language), Xen_to_C_char_(range_list))));
}

static Xen gxg_G_OBJECT_TYPE(Xen object)
{
  #define H_G_OBJECT_TYPE "GType G_OBJECT_TYPE(GObject* object)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "G_OBJECT_TYPE", "GObject*");
  return(C_to_Xen_GType(G_OBJECT_TYPE(Xen_to_C_GObject_(object))));
}

static Xen gxg_gtk_tree_model_get_string_from_iter(Xen tree_model, Xen iter)
{
  #define H_gtk_tree_model_get_string_from_iter "gchar* gtk_tree_model_get_string_from_iter(GtkTreeModel* tree_model, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModel_(tree_model), tree_model, 1, "gtk_tree_model_get_string_from_iter", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_get_string_from_iter", "GtkTreeIter*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_tree_model_get_string_from_iter(Xen_to_C_GtkTreeModel_(tree_model), Xen_to_C_GtkTreeIter_(iter));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_tree_model_sort_iter_is_valid(Xen tree_model_sort, Xen iter)
{
  #define H_gtk_tree_model_sort_iter_is_valid "gboolean gtk_tree_model_sort_iter_is_valid(GtkTreeModelSort* tree_model_sort, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkTreeModelSort_(tree_model_sort), tree_model_sort, 1, "gtk_tree_model_sort_iter_is_valid", "GtkTreeModelSort*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_tree_model_sort_iter_is_valid", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_tree_model_sort_iter_is_valid(Xen_to_C_GtkTreeModelSort_(tree_model_sort), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_tree_view_expand_to_path(Xen tree_view, Xen path)
{
  #define H_gtk_tree_view_expand_to_path "void gtk_tree_view_expand_to_path(GtkTreeView* tree_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_expand_to_path", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_tree_view_expand_to_path", "GtkTreePath*");
  gtk_tree_view_expand_to_path(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_tree_selection_get_selected_rows(Xen selection, Xen model)
{
  #define H_gtk_tree_selection_get_selected_rows "GList* gtk_tree_selection_get_selected_rows(GtkTreeSelection* selection, \
GtkTreeModel** model)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_get_selected_rows", "GtkTreeSelection*");
  Xen_check_type(Xen_is_GtkTreeModel__(model), model, 2, "gtk_tree_selection_get_selected_rows", "GtkTreeModel**");
  return(C_to_Xen_GList_(gtk_tree_selection_get_selected_rows(Xen_to_C_GtkTreeSelection_(selection), Xen_to_C_GtkTreeModel__(model))));
}

static Xen gxg_gtk_tree_selection_count_selected_rows(Xen selection)
{
  #define H_gtk_tree_selection_count_selected_rows "int gtk_tree_selection_count_selected_rows(GtkTreeSelection* selection)"
  Xen_check_type(Xen_is_GtkTreeSelection_(selection), selection, 1, "gtk_tree_selection_count_selected_rows", "GtkTreeSelection*");
  return(C_to_Xen_int(gtk_tree_selection_count_selected_rows(Xen_to_C_GtkTreeSelection_(selection))));
}

static Xen gxg_gtk_menu_shell_select_first(Xen menu_shell, Xen search_sensitive)
{
  #define H_gtk_menu_shell_select_first "void gtk_menu_shell_select_first(GtkMenuShell* menu_shell, gboolean search_sensitive)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_select_first", "GtkMenuShell*");
  Xen_check_type(Xen_is_gboolean(search_sensitive), search_sensitive, 2, "gtk_menu_shell_select_first", "gboolean");
  gtk_menu_shell_select_first(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_gboolean(search_sensitive));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_n_pages(Xen notebook)
{
  #define H_gtk_notebook_get_n_pages "int gtk_notebook_get_n_pages(GtkNotebook* notebook)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_n_pages", "GtkNotebook*");
  return(C_to_Xen_int(gtk_notebook_get_n_pages(Xen_to_C_GtkNotebook_(notebook))));
}

static Xen gxg_gtk_list_store_reorder(Xen store, Xen new_order)
{
  #define H_gtk_list_store_reorder "void gtk_list_store_reorder(GtkListStore* store, int* new_order)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_reorder", "GtkListStore*");
  Xen_check_type(Xen_is_int_(new_order), new_order, 2, "gtk_list_store_reorder", "int*");
  gtk_list_store_reorder(Xen_to_C_GtkListStore_(store), Xen_to_C_int_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_swap(Xen store, Xen a, Xen b)
{
  #define H_gtk_list_store_swap "void gtk_list_store_swap(GtkListStore* store, GtkTreeIter* a, GtkTreeIter* b)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_swap", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(a), a, 2, "gtk_list_store_swap", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(b), b, 3, "gtk_list_store_swap", "GtkTreeIter*");
  gtk_list_store_swap(Xen_to_C_GtkListStore_(store), Xen_to_C_GtkTreeIter_(a), Xen_to_C_GtkTreeIter_(b));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_move_after(Xen store, Xen iter, Xen position)
{
  #define H_gtk_list_store_move_after "void gtk_list_store_move_after(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_move_after", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_move_after", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(position) || Xen_is_false(position), position, 3, "gtk_list_store_move_after", "GtkTreeIter*");
  gtk_list_store_move_after(Xen_to_C_GtkListStore_(store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(position));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_move_before(Xen store, Xen iter, Xen position)
{
  #define H_gtk_list_store_move_before "void gtk_list_store_move_before(GtkListStore* store, GtkTreeIter* iter, \
GtkTreeIter* position)"
  Xen_check_type(Xen_is_GtkListStore_(store), store, 1, "gtk_list_store_move_before", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_move_before", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(position) || Xen_is_false(position), position, 3, "gtk_list_store_move_before", "GtkTreeIter*");
  gtk_list_store_move_before(Xen_to_C_GtkListStore_(store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_GtkTreeIter_(position));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_reorder(Xen tree_store, Xen parent, Xen new_order)
{
  #define H_gtk_tree_store_reorder "void gtk_tree_store_reorder(GtkTreeStore* tree_store, GtkTreeIter* parent, \
int* new_order)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_reorder", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(parent), parent, 2, "gtk_tree_store_reorder", "GtkTreeIter*");
  Xen_check_type(Xen_is_int_(new_order), new_order, 3, "gtk_tree_store_reorder", "int*");
  gtk_tree_store_reorder(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(parent), Xen_to_C_int_(new_order));
  return(Xen_false);
}

static Xen gxg_gtk_tree_store_swap(Xen tree_store, Xen a, Xen b)
{
  #define H_gtk_tree_store_swap "void gtk_tree_store_swap(GtkTreeStore* tree_store, GtkTreeIter* a, GtkTreeIter* b)"
  Xen_check_type(Xen_is_GtkTreeStore_(tree_store), tree_store, 1, "gtk_tree_store_swap", "GtkTreeStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(a), a, 2, "gtk_tree_store_swap", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(b), b, 3, "gtk_tree_store_swap", "GtkTreeIter*");
  gtk_tree_store_swap(Xen_to_C_GtkTreeStore_(tree_store), Xen_to_C_GtkTreeIter_(a), Xen_to_C_GtkTreeIter_(b));
  return(Xen_false);
}

static Xen gxg_gdk_display_open(Xen display_name)
{
  #define H_gdk_display_open "GdkDisplay* gdk_display_open(gchar* display_name)"
  Xen_check_type(Xen_is_gchar_(display_name), display_name, 1, "gdk_display_open", "gchar*");
  return(C_to_Xen_GdkDisplay_(gdk_display_open(Xen_to_C_gchar_(display_name))));
}

static Xen gxg_gdk_display_get_name(Xen display)
{
  #define H_gdk_display_get_name "gchar* gdk_display_get_name(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_name", "GdkDisplay*");
  return(C_to_Xen_gchar_(gdk_display_get_name(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_beep(Xen display)
{
  #define H_gdk_display_beep "void gdk_display_beep(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_beep", "GdkDisplay*");
  gdk_display_beep(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_sync(Xen display)
{
  #define H_gdk_display_sync "void gdk_display_sync(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_sync", "GdkDisplay*");
  gdk_display_sync(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_close(Xen display)
{
  #define H_gdk_display_close "void gdk_display_close(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_close", "GdkDisplay*");
  gdk_display_close(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_get_event(Xen display)
{
  #define H_gdk_display_get_event "GdkEvent* gdk_display_get_event(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_event", "GdkDisplay*");
  return(C_to_Xen_GdkEvent_(gdk_display_get_event(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_peek_event(Xen display)
{
  #define H_gdk_display_peek_event "GdkEvent* gdk_display_peek_event(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_peek_event", "GdkDisplay*");
  return(C_to_Xen_GdkEvent_(gdk_display_peek_event(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_put_event(Xen display, Xen event)
{
  #define H_gdk_display_put_event "void gdk_display_put_event(GdkDisplay* display, GdkEvent* event)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_put_event", "GdkDisplay*");
  Xen_check_type(Xen_is_GdkEvent_(event), event, 2, "gdk_display_put_event", "GdkEvent*");
  gdk_display_put_event(Xen_to_C_GdkDisplay_(display), Xen_to_C_GdkEvent_(event));
  return(Xen_false);
}

static Xen gxg_gdk_display_get_default(void)
{
  #define H_gdk_display_get_default "GdkDisplay* gdk_display_get_default( void)"
  return(C_to_Xen_GdkDisplay_(gdk_display_get_default()));
}

static Xen gxg_gtk_widget_get_display(Xen widget)
{
  #define H_gtk_widget_get_display "GdkDisplay* gtk_widget_get_display(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_get_display", "GtkWidget*");
  return(C_to_Xen_GdkDisplay_(gtk_widget_get_display(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_g_list_free(Xen list)
{
  #define H_g_list_free "void g_list_free(GList* list)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_free", "GList*");
  g_list_free(Xen_to_C_GList_(list));
  return(Xen_false);
}

static Xen gxg_g_list_reverse(Xen list)
{
  #define H_g_list_reverse "GList* g_list_reverse(GList* list)"
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 1, "g_list_reverse", "GList*");
  return(C_to_Xen_GList_(g_list_reverse(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_copy(Xen list)
{
  #define H_g_list_copy "GList* g_list_copy(GList* list)"
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 1, "g_list_copy", "GList*");
  return(C_to_Xen_GList_(g_list_copy(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_last(Xen list)
{
  #define H_g_list_last "GList* g_list_last(GList* list)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_last", "GList*");
  return(C_to_Xen_GList_(g_list_last(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_first(Xen list)
{
  #define H_g_list_first "GList* g_list_first(GList* list)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_first", "GList*");
  return(C_to_Xen_GList_(g_list_first(Xen_to_C_GList_(list))));
}

static Xen gxg_g_list_length(Xen list)
{
  #define H_g_list_length "guint g_list_length(GList* list)"
  Xen_check_type(Xen_is_GList_(list) || Xen_is_false(list), list, 1, "g_list_length", "GList*");
  return(C_to_Xen_guint(g_list_length(Xen_to_C_GList_(list))));
}

static Xen gxg_g_free(Xen mem)
{
  #define H_g_free "void g_free(gpointer mem)"
  Xen_check_type(Xen_is_gpointer(mem), mem, 1, "g_free", "gpointer");
  g_free(Xen_to_C_gpointer(mem));
  return(Xen_false);
}

static Xen gxg_g_list_remove_link(Xen list, Xen llink)
{
  #define H_g_list_remove_link "GList* g_list_remove_link(GList* list, GList* llink)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_remove_link", "GList*");
  Xen_check_type(Xen_is_GList_(llink), llink, 2, "g_list_remove_link", "GList*");
  return(C_to_Xen_GList_(g_list_remove_link(Xen_to_C_GList_(list), Xen_to_C_GList_(llink))));
}

static Xen gxg_g_object_get_data(Xen object, Xen key)
{
  #define H_g_object_get_data "gpointer g_object_get_data(GObject* object, gchar* key)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "g_object_get_data", "GObject*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "g_object_get_data", "gchar*");
  return(C_to_Xen_gpointer(g_object_get_data(Xen_to_C_GObject_(object), (const gchar*)Xen_to_C_gchar_(key))));
}

static Xen gxg_g_object_set_data(Xen object, Xen key, Xen data)
{
  #define H_g_object_set_data "void g_object_set_data(GObject* object, gchar* key, gpointer data)"
  Xen_check_type(Xen_is_GObject_(object), object, 1, "g_object_set_data", "GObject*");
  Xen_check_type(Xen_is_gchar_(key), key, 2, "g_object_set_data", "gchar*");
  Xen_check_type(Xen_is_gpointer(data), data, 3, "g_object_set_data", "gpointer");
  g_object_set_data(Xen_to_C_GObject_(object), (const gchar*)Xen_to_C_gchar_(key), Xen_to_C_gpointer(data));
  return(Xen_false);
}

static Xen gxg_gdk_display_flush(Xen display)
{
  #define H_gdk_display_flush "void gdk_display_flush(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_flush", "GdkDisplay*");
  gdk_display_flush(Xen_to_C_GdkDisplay_(display));
  return(Xen_false);
}

static Xen gxg_gdk_display_supports_cursor_alpha(Xen display)
{
  #define H_gdk_display_supports_cursor_alpha "gboolean gdk_display_supports_cursor_alpha(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_supports_cursor_alpha", "GdkDisplay*");
  return(C_to_Xen_gboolean(gdk_display_supports_cursor_alpha(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_supports_cursor_color(Xen display)
{
  #define H_gdk_display_supports_cursor_color "gboolean gdk_display_supports_cursor_color(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_supports_cursor_color", "GdkDisplay*");
  return(C_to_Xen_gboolean(gdk_display_supports_cursor_color(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_get_default_cursor_size(Xen display)
{
  #define H_gdk_display_get_default_cursor_size "guint gdk_display_get_default_cursor_size(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_default_cursor_size", "GdkDisplay*");
  return(C_to_Xen_guint(gdk_display_get_default_cursor_size(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_get_maximal_cursor_size(Xen display, Xen ignore_width, Xen ignore_height)
{
  #define H_gdk_display_get_maximal_cursor_size "void gdk_display_get_maximal_cursor_size(GdkDisplay* display, \
guint* [width], guint* [height])"
  guint ref_width;
  guint ref_height;
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_maximal_cursor_size", "GdkDisplay*");
  gdk_display_get_maximal_cursor_size(Xen_to_C_GdkDisplay_(display), &ref_width, &ref_height);
  return(Xen_list_2(C_to_Xen_guint(ref_width), C_to_Xen_guint(ref_height)));
}

static Xen gxg_gdk_window_set_keep_above(Xen window, Xen setting)
{
  #define H_gdk_window_set_keep_above "void gdk_window_set_keep_above(GdkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_keep_above", "GdkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gdk_window_set_keep_above", "gboolean");
  gdk_window_set_keep_above(Xen_to_C_GdkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gdk_window_set_keep_below(Xen window, Xen setting)
{
  #define H_gdk_window_set_keep_below "void gdk_window_set_keep_below(GdkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_keep_below", "GdkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gdk_window_set_keep_below", "gboolean");
  gdk_window_set_keep_below(Xen_to_C_GdkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_button_box_get_child_secondary(Xen widget, Xen child)
{
  #define H_gtk_button_box_get_child_secondary "gboolean gtk_button_box_get_child_secondary(GtkButtonBox* widget, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkButtonBox_(widget), widget, 1, "gtk_button_box_get_child_secondary", "GtkButtonBox*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_button_box_get_child_secondary", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_button_box_get_child_secondary(Xen_to_C_GtkButtonBox_(widget), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_calendar_set_display_options(Xen calendar, Xen flags)
{
  #define H_gtk_calendar_set_display_options "void gtk_calendar_set_display_options(GtkCalendar* calendar, \
GtkCalendarDisplayOptions flags)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_set_display_options", "GtkCalendar*");
  Xen_check_type(Xen_is_GtkCalendarDisplayOptions(flags), flags, 2, "gtk_calendar_set_display_options", "GtkCalendarDisplayOptions");
  gtk_calendar_set_display_options(Xen_to_C_GtkCalendar_(calendar), Xen_to_C_GtkCalendarDisplayOptions(flags));
  return(Xen_false);
}

static Xen gxg_gtk_calendar_get_display_options(Xen calendar)
{
  #define H_gtk_calendar_get_display_options "GtkCalendarDisplayOptions gtk_calendar_get_display_options(GtkCalendar* calendar)"
  Xen_check_type(Xen_is_GtkCalendar_(calendar), calendar, 1, "gtk_calendar_get_display_options", "GtkCalendar*");
  return(C_to_Xen_GtkCalendarDisplayOptions(gtk_calendar_get_display_options(Xen_to_C_GtkCalendar_(calendar))));
}

static Xen gxg_gtk_check_menu_item_set_draw_as_radio(Xen check_menu_item, Xen draw_as_radio)
{
  #define H_gtk_check_menu_item_set_draw_as_radio "void gtk_check_menu_item_set_draw_as_radio(GtkCheckMenuItem* check_menu_item, \
gboolean draw_as_radio)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_set_draw_as_radio", "GtkCheckMenuItem*");
  Xen_check_type(Xen_is_gboolean(draw_as_radio), draw_as_radio, 2, "gtk_check_menu_item_set_draw_as_radio", "gboolean");
  gtk_check_menu_item_set_draw_as_radio(Xen_to_C_GtkCheckMenuItem_(check_menu_item), Xen_to_C_gboolean(draw_as_radio));
  return(Xen_false);
}

static Xen gxg_gtk_check_menu_item_get_draw_as_radio(Xen check_menu_item)
{
  #define H_gtk_check_menu_item_get_draw_as_radio "gboolean gtk_check_menu_item_get_draw_as_radio(GtkCheckMenuItem* check_menu_item)"
  Xen_check_type(Xen_is_GtkCheckMenuItem_(check_menu_item), check_menu_item, 1, "gtk_check_menu_item_get_draw_as_radio", "GtkCheckMenuItem*");
  return(C_to_Xen_gboolean(gtk_check_menu_item_get_draw_as_radio(Xen_to_C_GtkCheckMenuItem_(check_menu_item))));
}

static Xen gxg_gtk_entry_set_completion(Xen entry, Xen completion)
{
  #define H_gtk_entry_set_completion "void gtk_entry_set_completion(GtkEntry* entry, GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_completion", "GtkEntry*");
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 2, "gtk_entry_set_completion", "GtkEntryCompletion*");
  gtk_entry_set_completion(Xen_to_C_GtkEntry_(entry), Xen_to_C_GtkEntryCompletion_(completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_completion(Xen entry)
{
  #define H_gtk_entry_get_completion "GtkEntryCompletion* gtk_entry_get_completion(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_completion", "GtkEntry*");
  return(C_to_Xen_GtkEntryCompletion_(gtk_entry_get_completion(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_menu_attach(Xen menu, Xen child, Xen left_attach, Xen right_attach, Xen top_attach, Xen bottom_attach)
{
  #define H_gtk_menu_attach "void gtk_menu_attach(GtkMenu* menu, GtkWidget* child, guint left_attach, \
guint right_attach, guint top_attach, guint bottom_attach)"
  Xen_check_type(Xen_is_GtkMenu_(menu), menu, 1, "gtk_menu_attach", "GtkMenu*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_menu_attach", "GtkWidget*");
  Xen_check_type(Xen_is_guint(left_attach), left_attach, 3, "gtk_menu_attach", "guint");
  Xen_check_type(Xen_is_guint(right_attach), right_attach, 4, "gtk_menu_attach", "guint");
  Xen_check_type(Xen_is_guint(top_attach), top_attach, 5, "gtk_menu_attach", "guint");
  Xen_check_type(Xen_is_guint(bottom_attach), bottom_attach, 6, "gtk_menu_attach", "guint");
  gtk_menu_attach(Xen_to_C_GtkMenu_(menu), Xen_to_C_GtkWidget_(child), Xen_to_C_guint(left_attach), Xen_to_C_guint(right_attach), 
                  Xen_to_C_guint(top_attach), Xen_to_C_guint(bottom_attach));
  return(Xen_false);
}

static Xen gxg_gtk_text_buffer_select_range(Xen buffer, Xen ins, Xen bound)
{
  #define H_gtk_text_buffer_select_range "void gtk_text_buffer_select_range(GtkTextBuffer* buffer, GtkTextIter* ins, \
GtkTextIter* bound)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_select_range", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(ins), ins, 2, "gtk_text_buffer_select_range", "GtkTextIter*");
  Xen_check_type(Xen_is_GtkTextIter_(bound), bound, 3, "gtk_text_buffer_select_range", "GtkTextIter*");
  gtk_text_buffer_select_range(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(ins), Xen_to_C_GtkTextIter_(bound));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_set_overwrite(Xen text_view, Xen overwrite)
{
  #define H_gtk_text_view_set_overwrite "void gtk_text_view_set_overwrite(GtkTextView* text_view, gboolean overwrite)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_overwrite", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(overwrite), overwrite, 2, "gtk_text_view_set_overwrite", "gboolean");
  gtk_text_view_set_overwrite(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(overwrite));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_overwrite(Xen text_view)
{
  #define H_gtk_text_view_get_overwrite "gboolean gtk_text_view_get_overwrite(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_overwrite", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_overwrite(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_text_view_set_accepts_tab(Xen text_view, Xen accepts_tab)
{
  #define H_gtk_text_view_set_accepts_tab "void gtk_text_view_set_accepts_tab(GtkTextView* text_view, \
gboolean accepts_tab)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_set_accepts_tab", "GtkTextView*");
  Xen_check_type(Xen_is_gboolean(accepts_tab), accepts_tab, 2, "gtk_text_view_set_accepts_tab", "gboolean");
  gtk_text_view_set_accepts_tab(Xen_to_C_GtkTextView_(text_view), Xen_to_C_gboolean(accepts_tab));
  return(Xen_false);
}

static Xen gxg_gtk_text_view_get_accepts_tab(Xen text_view)
{
  #define H_gtk_text_view_get_accepts_tab "gboolean gtk_text_view_get_accepts_tab(GtkTextView* text_view)"
  Xen_check_type(Xen_is_GtkTextView_(text_view), text_view, 1, "gtk_text_view_get_accepts_tab", "GtkTextView*");
  return(C_to_Xen_gboolean(gtk_text_view_get_accepts_tab(Xen_to_C_GtkTextView_(text_view))));
}

static Xen gxg_gtk_toolbar_insert(Xen toolbar, Xen item, Xen pos)
{
  #define H_gtk_toolbar_insert "void gtk_toolbar_insert(GtkToolbar* toolbar, GtkToolItem* item, gint pos)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_insert", "GtkToolbar*");
  Xen_check_type(Xen_is_GtkToolItem_(item), item, 2, "gtk_toolbar_insert", "GtkToolItem*");
  Xen_check_type(Xen_is_gint(pos), pos, 3, "gtk_toolbar_insert", "gint");
  gtk_toolbar_insert(Xen_to_C_GtkToolbar_(toolbar), Xen_to_C_GtkToolItem_(item), Xen_to_C_gint(pos));
  return(Xen_false);
}

static Xen gxg_gtk_toolbar_get_item_index(Xen toolbar, Xen item)
{
  #define H_gtk_toolbar_get_item_index "gint gtk_toolbar_get_item_index(GtkToolbar* toolbar, GtkToolItem* item)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_get_item_index", "GtkToolbar*");
  Xen_check_type(Xen_is_GtkToolItem_(item), item, 2, "gtk_toolbar_get_item_index", "GtkToolItem*");
  return(C_to_Xen_gint(gtk_toolbar_get_item_index(Xen_to_C_GtkToolbar_(toolbar), Xen_to_C_GtkToolItem_(item))));
}

static Xen gxg_gtk_toolbar_get_n_items(Xen toolbar)
{
  #define H_gtk_toolbar_get_n_items "gint gtk_toolbar_get_n_items(GtkToolbar* toolbar)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_get_n_items", "GtkToolbar*");
  return(C_to_Xen_gint(gtk_toolbar_get_n_items(Xen_to_C_GtkToolbar_(toolbar))));
}

static Xen gxg_gtk_toolbar_get_nth_item(Xen toolbar, Xen n)
{
  #define H_gtk_toolbar_get_nth_item "GtkToolItem* gtk_toolbar_get_nth_item(GtkToolbar* toolbar, gint n)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_get_nth_item", "GtkToolbar*");
  Xen_check_type(Xen_is_gint(n), n, 2, "gtk_toolbar_get_nth_item", "gint");
  return(C_to_Xen_GtkToolItem_(gtk_toolbar_get_nth_item(Xen_to_C_GtkToolbar_(toolbar), Xen_to_C_gint(n))));
}

static Xen gxg_gtk_toolbar_set_show_arrow(Xen toolbar, Xen show_arrow)
{
  #define H_gtk_toolbar_set_show_arrow "void gtk_toolbar_set_show_arrow(GtkToolbar* toolbar, gboolean show_arrow)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_set_show_arrow", "GtkToolbar*");
  Xen_check_type(Xen_is_gboolean(show_arrow), show_arrow, 2, "gtk_toolbar_set_show_arrow", "gboolean");
  gtk_toolbar_set_show_arrow(Xen_to_C_GtkToolbar_(toolbar), Xen_to_C_gboolean(show_arrow));
  return(Xen_false);
}

static Xen gxg_gtk_toolbar_get_show_arrow(Xen toolbar)
{
  #define H_gtk_toolbar_get_show_arrow "gboolean gtk_toolbar_get_show_arrow(GtkToolbar* toolbar)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_get_show_arrow", "GtkToolbar*");
  return(C_to_Xen_gboolean(gtk_toolbar_get_show_arrow(Xen_to_C_GtkToolbar_(toolbar))));
}

static Xen gxg_gtk_toolbar_get_drop_index(Xen toolbar, Xen x, Xen y)
{
  #define H_gtk_toolbar_get_drop_index "gint gtk_toolbar_get_drop_index(GtkToolbar* toolbar, gint x, \
gint y)"
  Xen_check_type(Xen_is_GtkToolbar_(toolbar), toolbar, 1, "gtk_toolbar_get_drop_index", "GtkToolbar*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_toolbar_get_drop_index", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_toolbar_get_drop_index", "gint");
  return(C_to_Xen_gint(gtk_toolbar_get_drop_index(Xen_to_C_GtkToolbar_(toolbar), Xen_to_C_gint(x), Xen_to_C_gint(y))));
}

static Xen gxg_gtk_tree_view_column_set_expand(Xen tree_column, Xen expand)
{
  #define H_gtk_tree_view_column_set_expand "void gtk_tree_view_column_set_expand(GtkTreeViewColumn* tree_column, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_set_expand", "GtkTreeViewColumn*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_tree_view_column_set_expand", "gboolean");
  gtk_tree_view_column_set_expand(Xen_to_C_GtkTreeViewColumn_(tree_column), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_column_get_expand(Xen tree_column)
{
  #define H_gtk_tree_view_column_get_expand "gboolean gtk_tree_view_column_get_expand(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_get_expand", "GtkTreeViewColumn*");
  return(C_to_Xen_gboolean(gtk_tree_view_column_get_expand(Xen_to_C_GtkTreeViewColumn_(tree_column))));
}

static Xen gxg_gtk_widget_queue_resize_no_redraw(Xen widget)
{
  #define H_gtk_widget_queue_resize_no_redraw "void gtk_widget_queue_resize_no_redraw(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_queue_resize_no_redraw", "GtkWidget*");
  gtk_widget_queue_resize_no_redraw(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_keep_above(Xen window, Xen setting)
{
  #define H_gtk_window_set_keep_above "void gtk_window_set_keep_above(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_keep_above", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_keep_above", "gboolean");
  gtk_window_set_keep_above(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_set_keep_below(Xen window, Xen setting)
{
  #define H_gtk_window_set_keep_below "void gtk_window_set_keep_below(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_keep_below", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_keep_below", "gboolean");
  gtk_window_set_keep_below(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_dialog_new(Xen title, Xen parent, Xen action, Xen buttons)
{
  #define H_gtk_file_chooser_dialog_new "GtkWidget* gtk_file_chooser_dialog_new(gchar* title, GtkWindow* parent, \
GtkFileChooserAction action, etc buttons)"
  Xen_check_type(Xen_is_gchar_(title), title, 1, "gtk_file_chooser_dialog_new", "gchar*");
  Xen_check_type(Xen_is_GtkWindow_(parent) || Xen_is_false(parent), parent, 2, "gtk_file_chooser_dialog_new", "GtkWindow*");
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 3, "gtk_file_chooser_dialog_new", "GtkFileChooserAction");
  if (!Xen_is_bound(buttons)) buttons = Xen_false; 
  else Xen_check_type(Xen_is_etc(buttons), buttons, 4, "gtk_file_chooser_dialog_new", "etc");
  {
    int etc_len = 0;
    GtkWidget* result = NULL;
    gchar* p_arg0;
    GtkWindow* p_arg1;
    GtkFileChooserAction p_arg2;
    if (Xen_is_list(buttons)) etc_len = Xen_list_length(buttons);
    if (etc_len > 10) Xen_out_of_range_error("gtk_file_chooser_dialog_new", 3, buttons, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_file_chooser_dialog_new", 3, buttons, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_gchar_(title);
    p_arg1 = Xen_to_C_GtkWindow_(parent);
    p_arg2 = Xen_to_C_GtkFileChooserAction(action);
    switch (etc_len)
      {
        case 0: result = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, NULL, NULL); break;
        case 2: result = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), NULL); break;
        case 4: result = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), NULL); break;
        case 6: result = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), NULL); break;
        case 8: result = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), NULL); break;
        case 10: result = gtk_file_chooser_dialog_new(p_arg0, p_arg1, p_arg2, XLS(buttons, 0), XLI(buttons, 1), XLS(buttons, 2), XLI(buttons, 3), XLS(buttons, 4), XLI(buttons, 5), XLS(buttons, 6), XLI(buttons, 7), XLS(buttons, 8), XLI(buttons, 9), NULL); break;
      }
    return(C_to_Xen_GtkWidget_(result));
  }
}

static Xen gxg_gtk_file_chooser_widget_new(Xen action)
{
  #define H_gtk_file_chooser_widget_new "GtkWidget* gtk_file_chooser_widget_new(GtkFileChooserAction action)"
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 1, "gtk_file_chooser_widget_new", "GtkFileChooserAction");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_widget_new(Xen_to_C_GtkFileChooserAction(action))));
}

static Xen gxg_gtk_tree_model_filter_new(Xen child_model, Xen root)
{
  #define H_gtk_tree_model_filter_new "GtkTreeModel* gtk_tree_model_filter_new(GtkTreeModel* child_model, \
GtkTreePath* root)"
  Xen_check_type(Xen_is_GtkTreeModel_(child_model), child_model, 1, "gtk_tree_model_filter_new", "GtkTreeModel*");
  Xen_check_type(Xen_is_GtkTreePath_(root) || Xen_is_false(root), root, 2, "gtk_tree_model_filter_new", "GtkTreePath*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_filter_new(Xen_to_C_GtkTreeModel_(child_model), Xen_to_C_GtkTreePath_(root))));
}

static Xen gxg_gtk_tree_model_filter_set_visible_column(Xen filter, Xen column)
{
  #define H_gtk_tree_model_filter_set_visible_column "void gtk_tree_model_filter_set_visible_column(GtkTreeModelFilter* filter, \
gint column)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_set_visible_column", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_tree_model_filter_set_visible_column", "gint");
  gtk_tree_model_filter_set_visible_column(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_filter_get_model(Xen filter)
{
  #define H_gtk_tree_model_filter_get_model "GtkTreeModel* gtk_tree_model_filter_get_model(GtkTreeModelFilter* filter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_get_model", "GtkTreeModelFilter*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_model_filter_get_model(Xen_to_C_GtkTreeModelFilter_(filter))));
}

static Xen gxg_gtk_tree_model_filter_convert_iter_to_child_iter(Xen filter, Xen child_iter, Xen filter_iter)
{
  #define H_gtk_tree_model_filter_convert_iter_to_child_iter "void gtk_tree_model_filter_convert_iter_to_child_iter(GtkTreeModelFilter* filter, \
GtkTreeIter* child_iter, GtkTreeIter* filter_iter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_convert_iter_to_child_iter", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreeIter_(child_iter), child_iter, 2, "gtk_tree_model_filter_convert_iter_to_child_iter", "GtkTreeIter*");
  Xen_check_type(Xen_is_GtkTreeIter_(filter_iter), filter_iter, 3, "gtk_tree_model_filter_convert_iter_to_child_iter", "GtkTreeIter*");
  gtk_tree_model_filter_convert_iter_to_child_iter(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_GtkTreeIter_(child_iter), 
                                                   Xen_to_C_GtkTreeIter_(filter_iter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_filter_convert_child_path_to_path(Xen filter, Xen child_path)
{
  #define H_gtk_tree_model_filter_convert_child_path_to_path "GtkTreePath* gtk_tree_model_filter_convert_child_path_to_path(GtkTreeModelFilter* filter, \
GtkTreePath* child_path)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_convert_child_path_to_path", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreePath_(child_path), child_path, 2, "gtk_tree_model_filter_convert_child_path_to_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_filter_convert_child_path_to_path(Xen_to_C_GtkTreeModelFilter_(filter), Xen_to_C_GtkTreePath_(child_path))));
}

static Xen gxg_gtk_tree_model_filter_convert_path_to_child_path(Xen path, Xen filter_path)
{
  #define H_gtk_tree_model_filter_convert_path_to_child_path "GtkTreePath* gtk_tree_model_filter_convert_path_to_child_path(GtkTreeModelFilter* path, \
GtkTreePath* filter_path)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(path), path, 1, "gtk_tree_model_filter_convert_path_to_child_path", "GtkTreeModelFilter*");
  Xen_check_type(Xen_is_GtkTreePath_(filter_path), filter_path, 2, "gtk_tree_model_filter_convert_path_to_child_path", "GtkTreePath*");
  return(C_to_Xen_GtkTreePath_(gtk_tree_model_filter_convert_path_to_child_path(Xen_to_C_GtkTreeModelFilter_(path), Xen_to_C_GtkTreePath_(filter_path))));
}

static Xen gxg_gtk_tree_model_filter_refilter(Xen filter)
{
  #define H_gtk_tree_model_filter_refilter "void gtk_tree_model_filter_refilter(GtkTreeModelFilter* filter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_refilter", "GtkTreeModelFilter*");
  gtk_tree_model_filter_refilter(Xen_to_C_GtkTreeModelFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_tree_model_filter_clear_cache(Xen filter)
{
  #define H_gtk_tree_model_filter_clear_cache "void gtk_tree_model_filter_clear_cache(GtkTreeModelFilter* filter)"
  Xen_check_type(Xen_is_GtkTreeModelFilter_(filter), filter, 1, "gtk_tree_model_filter_clear_cache", "GtkTreeModelFilter*");
  gtk_tree_model_filter_clear_cache(Xen_to_C_GtkTreeModelFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_new(void)
{
  #define H_gtk_combo_box_new "GtkWidget* gtk_combo_box_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_combo_box_new()));
}

static Xen gxg_gtk_combo_box_new_with_model(Xen model)
{
  #define H_gtk_combo_box_new_with_model "GtkWidget* gtk_combo_box_new_with_model(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_combo_box_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_combo_box_new_with_model(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_combo_box_set_model(Xen combo_box, Xen model)
{
  #define H_gtk_combo_box_set_model "void gtk_combo_box_set_model(GtkComboBox* combo_box, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_model", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_combo_box_set_model", "GtkTreeModel*");
  gtk_combo_box_set_model(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_set_wrap_width(Xen combo_box, Xen width)
{
  #define H_gtk_combo_box_set_wrap_width "void gtk_combo_box_set_wrap_width(GtkComboBox* combo_box, gint width)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_wrap_width", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(width), width, 2, "gtk_combo_box_set_wrap_width", "gint");
  gtk_combo_box_set_wrap_width(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(width));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_set_row_span_column(Xen combo_box, Xen row_span)
{
  #define H_gtk_combo_box_set_row_span_column "void gtk_combo_box_set_row_span_column(GtkComboBox* combo_box, \
gint row_span)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_row_span_column", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(row_span), row_span, 2, "gtk_combo_box_set_row_span_column", "gint");
  gtk_combo_box_set_row_span_column(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(row_span));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_set_column_span_column(Xen combo_box, Xen column_span)
{
  #define H_gtk_combo_box_set_column_span_column "void gtk_combo_box_set_column_span_column(GtkComboBox* combo_box, \
gint column_span)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_column_span_column", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(column_span), column_span, 2, "gtk_combo_box_set_column_span_column", "gint");
  gtk_combo_box_set_column_span_column(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(column_span));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_active(Xen combo_box)
{
  #define H_gtk_combo_box_get_active "gint gtk_combo_box_get_active(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_active", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_active(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_set_active(Xen combo_box, Xen index)
{
  #define H_gtk_combo_box_set_active "void gtk_combo_box_set_active(GtkComboBox* combo_box, gint index)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_active", "GtkComboBox*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_combo_box_set_active", "gint");
  gtk_combo_box_set_active(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_active_iter(Xen combo_box, Xen iter)
{
  #define H_gtk_combo_box_get_active_iter "gboolean gtk_combo_box_get_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_active_iter", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_combo_box_get_active_iter", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_combo_box_get_active_iter(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gtk_combo_box_set_active_iter(Xen combo_box, Xen iter)
{
  #define H_gtk_combo_box_set_active_iter "void gtk_combo_box_set_active_iter(GtkComboBox* combo_box, \
GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_active_iter", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_combo_box_set_active_iter", "GtkTreeIter*");
  gtk_combo_box_set_active_iter(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_get_model(Xen combo_box)
{
  #define H_gtk_combo_box_get_model "GtkTreeModel* gtk_combo_box_get_model(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_model", "GtkComboBox*");
  return(C_to_Xen_GtkTreeModel_(gtk_combo_box_get_model(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_expander_new(Xen label)
{
  #define H_gtk_expander_new "GtkWidget* gtk_expander_new(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_expander_new", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_expander_new(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_expander_new_with_mnemonic(Xen label)
{
  #define H_gtk_expander_new_with_mnemonic "GtkWidget* gtk_expander_new_with_mnemonic(gchar* label)"
  Xen_check_type(Xen_is_gchar_(label), label, 1, "gtk_expander_new_with_mnemonic", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_expander_new_with_mnemonic(Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_expander_set_expanded(Xen expander, Xen expanded)
{
  #define H_gtk_expander_set_expanded "void gtk_expander_set_expanded(GtkExpander* expander, gboolean expanded)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_expanded", "GtkExpander*");
  Xen_check_type(Xen_is_gboolean(expanded), expanded, 2, "gtk_expander_set_expanded", "gboolean");
  gtk_expander_set_expanded(Xen_to_C_GtkExpander_(expander), Xen_to_C_gboolean(expanded));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_expanded(Xen expander)
{
  #define H_gtk_expander_get_expanded "gboolean gtk_expander_get_expanded(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_expanded", "GtkExpander*");
  return(C_to_Xen_gboolean(gtk_expander_get_expanded(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_label(Xen expander, Xen label)
{
  #define H_gtk_expander_set_label "void gtk_expander_set_label(GtkExpander* expander, gchar* label)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_label", "GtkExpander*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_expander_set_label", "gchar*");
  gtk_expander_set_label(Xen_to_C_GtkExpander_(expander), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_label(Xen expander)
{
  #define H_gtk_expander_get_label "gchar* gtk_expander_get_label(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_label", "GtkExpander*");
  return(C_to_Xen_gchar_(gtk_expander_get_label(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_use_underline(Xen expander, Xen use_underline)
{
  #define H_gtk_expander_set_use_underline "void gtk_expander_set_use_underline(GtkExpander* expander, \
gboolean use_underline)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_use_underline", "GtkExpander*");
  Xen_check_type(Xen_is_gboolean(use_underline), use_underline, 2, "gtk_expander_set_use_underline", "gboolean");
  gtk_expander_set_use_underline(Xen_to_C_GtkExpander_(expander), Xen_to_C_gboolean(use_underline));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_use_underline(Xen expander)
{
  #define H_gtk_expander_get_use_underline "gboolean gtk_expander_get_use_underline(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_use_underline", "GtkExpander*");
  return(C_to_Xen_gboolean(gtk_expander_get_use_underline(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_label_widget(Xen expander, Xen label_widget)
{
  #define H_gtk_expander_set_label_widget "void gtk_expander_set_label_widget(GtkExpander* expander, \
GtkWidget* label_widget)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_label_widget", "GtkExpander*");
  Xen_check_type(Xen_is_GtkWidget_(label_widget), label_widget, 2, "gtk_expander_set_label_widget", "GtkWidget*");
  gtk_expander_set_label_widget(Xen_to_C_GtkExpander_(expander), Xen_to_C_GtkWidget_(label_widget));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_label_widget(Xen expander)
{
  #define H_gtk_expander_get_label_widget "GtkWidget* gtk_expander_get_label_widget(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_label_widget", "GtkExpander*");
  return(C_to_Xen_GtkWidget_(gtk_expander_get_label_widget(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_expander_set_use_markup(Xen expander, Xen use_markup)
{
  #define H_gtk_expander_set_use_markup "void gtk_expander_set_use_markup(GtkExpander* expander, gboolean use_markup)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_set_use_markup", "GtkExpander*");
  Xen_check_type(Xen_is_gboolean(use_markup), use_markup, 2, "gtk_expander_set_use_markup", "gboolean");
  gtk_expander_set_use_markup(Xen_to_C_GtkExpander_(expander), Xen_to_C_gboolean(use_markup));
  return(Xen_false);
}

static Xen gxg_gtk_expander_get_use_markup(Xen expander)
{
  #define H_gtk_expander_get_use_markup "gboolean gtk_expander_get_use_markup(GtkExpander* expander)"
  Xen_check_type(Xen_is_GtkExpander_(expander), expander, 1, "gtk_expander_get_use_markup", "GtkExpander*");
  return(C_to_Xen_gboolean(gtk_expander_get_use_markup(Xen_to_C_GtkExpander_(expander))));
}

static Xen gxg_gtk_font_button_new(void)
{
  #define H_gtk_font_button_new "GtkWidget* gtk_font_button_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_font_button_new()));
}

static Xen gxg_gtk_font_button_new_with_font(Xen fontname)
{
  #define H_gtk_font_button_new_with_font "GtkWidget* gtk_font_button_new_with_font(gchar* fontname)"
  Xen_check_type(Xen_is_gchar_(fontname), fontname, 1, "gtk_font_button_new_with_font", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_font_button_new_with_font(Xen_to_C_gchar_(fontname))));
}

static Xen gxg_gtk_font_button_get_title(Xen font_button)
{
  #define H_gtk_font_button_get_title "gchar* gtk_font_button_get_title(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_title", "GtkFontButton*");
  return(C_to_Xen_gchar_(gtk_font_button_get_title(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_title(Xen font_button, Xen title)
{
  #define H_gtk_font_button_set_title "void gtk_font_button_set_title(GtkFontButton* font_button, gchar* title)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_title", "GtkFontButton*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_font_button_set_title", "gchar*");
  gtk_font_button_set_title(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gtk_font_button_get_use_font(Xen font_button)
{
  #define H_gtk_font_button_get_use_font "gboolean gtk_font_button_get_use_font(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_use_font", "GtkFontButton*");
  return(C_to_Xen_gboolean(gtk_font_button_get_use_font(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_use_font(Xen font_button, Xen use_font)
{
  #define H_gtk_font_button_set_use_font "void gtk_font_button_set_use_font(GtkFontButton* font_button, \
gboolean use_font)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_use_font", "GtkFontButton*");
  Xen_check_type(Xen_is_gboolean(use_font), use_font, 2, "gtk_font_button_set_use_font", "gboolean");
  gtk_font_button_set_use_font(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gboolean(use_font));
  return(Xen_false);
}

static Xen gxg_gtk_font_button_get_use_size(Xen font_button)
{
  #define H_gtk_font_button_get_use_size "gboolean gtk_font_button_get_use_size(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_use_size", "GtkFontButton*");
  return(C_to_Xen_gboolean(gtk_font_button_get_use_size(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_use_size(Xen font_button, Xen use_size)
{
  #define H_gtk_font_button_set_use_size "void gtk_font_button_set_use_size(GtkFontButton* font_button, \
gboolean use_size)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_use_size", "GtkFontButton*");
  Xen_check_type(Xen_is_gboolean(use_size), use_size, 2, "gtk_font_button_set_use_size", "gboolean");
  gtk_font_button_set_use_size(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gboolean(use_size));
  return(Xen_false);
}

static Xen gxg_gtk_font_button_get_show_style(Xen font_button)
{
  #define H_gtk_font_button_get_show_style "gboolean gtk_font_button_get_show_style(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_show_style", "GtkFontButton*");
  return(C_to_Xen_gboolean(gtk_font_button_get_show_style(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_show_style(Xen font_button, Xen show_style)
{
  #define H_gtk_font_button_set_show_style "void gtk_font_button_set_show_style(GtkFontButton* font_button, \
gboolean show_style)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_show_style", "GtkFontButton*");
  Xen_check_type(Xen_is_gboolean(show_style), show_style, 2, "gtk_font_button_set_show_style", "gboolean");
  gtk_font_button_set_show_style(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gboolean(show_style));
  return(Xen_false);
}

static Xen gxg_gtk_font_button_get_show_size(Xen font_button)
{
  #define H_gtk_font_button_get_show_size "gboolean gtk_font_button_get_show_size(GtkFontButton* font_button)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_get_show_size", "GtkFontButton*");
  return(C_to_Xen_gboolean(gtk_font_button_get_show_size(Xen_to_C_GtkFontButton_(font_button))));
}

static Xen gxg_gtk_font_button_set_show_size(Xen font_button, Xen show_size)
{
  #define H_gtk_font_button_set_show_size "void gtk_font_button_set_show_size(GtkFontButton* font_button, \
gboolean show_size)"
  Xen_check_type(Xen_is_GtkFontButton_(font_button), font_button, 1, "gtk_font_button_set_show_size", "GtkFontButton*");
  Xen_check_type(Xen_is_gboolean(show_size), show_size, 2, "gtk_font_button_set_show_size", "gboolean");
  gtk_font_button_set_show_size(Xen_to_C_GtkFontButton_(font_button), Xen_to_C_gboolean(show_size));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_new(void)
{
  #define H_gtk_entry_completion_new "GtkEntryCompletion* gtk_entry_completion_new( void)"
  return(C_to_Xen_GtkEntryCompletion_(gtk_entry_completion_new()));
}

static Xen gxg_gtk_entry_completion_get_entry(Xen entry)
{
  #define H_gtk_entry_completion_get_entry "GtkWidget* gtk_entry_completion_get_entry(GtkEntryCompletion* entry)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(entry), entry, 1, "gtk_entry_completion_get_entry", "GtkEntryCompletion*");
  return(C_to_Xen_GtkWidget_(gtk_entry_completion_get_entry(Xen_to_C_GtkEntryCompletion_(entry))));
}

static Xen gxg_gtk_entry_completion_set_model(Xen completion, Xen model)
{
  #define H_gtk_entry_completion_set_model "void gtk_entry_completion_set_model(GtkEntryCompletion* completion, \
GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_model", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_entry_completion_set_model", "GtkTreeModel*");
  gtk_entry_completion_set_model(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_model(Xen completion)
{
  #define H_gtk_entry_completion_get_model "GtkTreeModel* gtk_entry_completion_get_model(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_model", "GtkEntryCompletion*");
  return(C_to_Xen_GtkTreeModel_(gtk_entry_completion_get_model(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_set_match_func(Xen completion, Xen func, Xen func_info, Xen func_notify)
{
  #define H_gtk_entry_completion_set_match_func "void gtk_entry_completion_set_match_func(GtkEntryCompletion* completion, \
GtkEntryCompletionMatchFunc func, lambda_data func_info, GtkDestroyNotify func_notify)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_match_func", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_GtkEntryCompletionMatchFunc(func), func, 2, "gtk_entry_completion_set_match_func", "GtkEntryCompletionMatchFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_entry_completion_set_match_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(func_notify), func_notify, 4, "gtk_entry_completion_set_match_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, func_notify);
    gtk_entry_completion_set_match_func(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_GtkEntryCompletionMatchFunc(func), 
                                    Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(func_notify));
    return(Xen_false);
   }
}

static Xen gxg_gtk_entry_completion_set_minimum_key_length(Xen completion, Xen length)
{
  #define H_gtk_entry_completion_set_minimum_key_length "void gtk_entry_completion_set_minimum_key_length(GtkEntryCompletion* completion, \
gint length)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_minimum_key_length", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(length), length, 2, "gtk_entry_completion_set_minimum_key_length", "gint");
  gtk_entry_completion_set_minimum_key_length(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(length));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_minimum_key_length(Xen completion)
{
  #define H_gtk_entry_completion_get_minimum_key_length "gint gtk_entry_completion_get_minimum_key_length(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_minimum_key_length", "GtkEntryCompletion*");
  return(C_to_Xen_gint(gtk_entry_completion_get_minimum_key_length(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_complete(Xen completion)
{
  #define H_gtk_entry_completion_complete "void gtk_entry_completion_complete(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_complete", "GtkEntryCompletion*");
  gtk_entry_completion_complete(Xen_to_C_GtkEntryCompletion_(completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_insert_action_text(Xen completion, Xen index, Xen text)
{
  #define H_gtk_entry_completion_insert_action_text "void gtk_entry_completion_insert_action_text(GtkEntryCompletion* completion, \
gint index, gchar* text)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_insert_action_text", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_entry_completion_insert_action_text", "gint");
  Xen_check_type(Xen_is_gchar_(text), text, 3, "gtk_entry_completion_insert_action_text", "gchar*");
  gtk_entry_completion_insert_action_text(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(index), Xen_to_C_gchar_(text));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_insert_action_markup(Xen completion, Xen index, Xen markup)
{
  #define H_gtk_entry_completion_insert_action_markup "void gtk_entry_completion_insert_action_markup(GtkEntryCompletion* completion, \
gint index, gchar* markup)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_insert_action_markup", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_entry_completion_insert_action_markup", "gint");
  Xen_check_type(Xen_is_gchar_(markup), markup, 3, "gtk_entry_completion_insert_action_markup", "gchar*");
  gtk_entry_completion_insert_action_markup(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(index), Xen_to_C_gchar_(markup));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_delete_action(Xen completion, Xen index)
{
  #define H_gtk_entry_completion_delete_action "void gtk_entry_completion_delete_action(GtkEntryCompletion* completion, \
gint index)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_delete_action", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(index), index, 2, "gtk_entry_completion_delete_action", "gint");
  gtk_entry_completion_delete_action(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(index));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_set_text_column(Xen completion, Xen column)
{
  #define H_gtk_entry_completion_set_text_column "void gtk_entry_completion_set_text_column(GtkEntryCompletion* completion, \
gint column)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_text_column", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_entry_completion_set_text_column", "gint");
  gtk_entry_completion_set_text_column(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_radio_tool_button_new(Xen group)
{
  #define H_gtk_radio_tool_button_new "GtkToolItem* gtk_radio_tool_button_new(GSList* group)"
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 1, "gtk_radio_tool_button_new", "GSList*");
  return(C_to_Xen_GtkToolItem_(gtk_radio_tool_button_new(Xen_to_C_GSList_(group))));
}

static Xen gxg_gtk_radio_tool_button_new_from_widget(Xen group)
{
  #define H_gtk_radio_tool_button_new_from_widget "GtkToolItem* gtk_radio_tool_button_new_from_widget(GtkRadioToolButton* group)"
  Xen_check_type(Xen_is_GtkRadioToolButton_(group), group, 1, "gtk_radio_tool_button_new_from_widget", "GtkRadioToolButton*");
  return(C_to_Xen_GtkToolItem_(gtk_radio_tool_button_new_from_widget(Xen_to_C_GtkRadioToolButton_(group))));
}

static Xen gxg_gtk_radio_tool_button_get_group(Xen button)
{
  #define H_gtk_radio_tool_button_get_group "GSList* gtk_radio_tool_button_get_group(GtkRadioToolButton* button)"
  Xen_check_type(Xen_is_GtkRadioToolButton_(button), button, 1, "gtk_radio_tool_button_get_group", "GtkRadioToolButton*");
  return(C_to_Xen_GSList_(gtk_radio_tool_button_get_group(Xen_to_C_GtkRadioToolButton_(button))));
}

static Xen gxg_gtk_radio_tool_button_set_group(Xen button, Xen group)
{
  #define H_gtk_radio_tool_button_set_group "void gtk_radio_tool_button_set_group(GtkRadioToolButton* button, \
GSList* group)"
  Xen_check_type(Xen_is_GtkRadioToolButton_(button), button, 1, "gtk_radio_tool_button_set_group", "GtkRadioToolButton*");
  Xen_check_type(Xen_is_GSList_(group) || Xen_is_false(group), group, 2, "gtk_radio_tool_button_set_group", "GSList*");
  gtk_radio_tool_button_set_group(Xen_to_C_GtkRadioToolButton_(button), Xen_to_C_GSList_(group));
  return(Xen_false);
}

static Xen gxg_gtk_separator_tool_item_new(void)
{
  #define H_gtk_separator_tool_item_new "GtkToolItem* gtk_separator_tool_item_new( void)"
  return(C_to_Xen_GtkToolItem_(gtk_separator_tool_item_new()));
}

static Xen gxg_gtk_separator_tool_item_get_draw(Xen item)
{
  #define H_gtk_separator_tool_item_get_draw "gboolean gtk_separator_tool_item_get_draw(GtkSeparatorToolItem* item)"
  Xen_check_type(Xen_is_GtkSeparatorToolItem_(item), item, 1, "gtk_separator_tool_item_get_draw", "GtkSeparatorToolItem*");
  return(C_to_Xen_gboolean(gtk_separator_tool_item_get_draw(Xen_to_C_GtkSeparatorToolItem_(item))));
}

static Xen gxg_gtk_separator_tool_item_set_draw(Xen tool_item, Xen draw)
{
  #define H_gtk_separator_tool_item_set_draw "void gtk_separator_tool_item_set_draw(GtkSeparatorToolItem* tool_item, \
gboolean draw)"
  Xen_check_type(Xen_is_GtkSeparatorToolItem_(tool_item), tool_item, 1, "gtk_separator_tool_item_set_draw", "GtkSeparatorToolItem*");
  Xen_check_type(Xen_is_gboolean(draw), draw, 2, "gtk_separator_tool_item_set_draw", "gboolean");
  gtk_separator_tool_item_set_draw(Xen_to_C_GtkSeparatorToolItem_(tool_item), Xen_to_C_gboolean(draw));
  return(Xen_false);
}

static Xen gxg_gtk_toggle_tool_button_new(void)
{
  #define H_gtk_toggle_tool_button_new "GtkToolItem* gtk_toggle_tool_button_new( void)"
  return(C_to_Xen_GtkToolItem_(gtk_toggle_tool_button_new()));
}

static Xen gxg_gtk_toggle_tool_button_set_active(Xen button, Xen is_active)
{
  #define H_gtk_toggle_tool_button_set_active "void gtk_toggle_tool_button_set_active(GtkToggleToolButton* button, \
gboolean is_active)"
  Xen_check_type(Xen_is_GtkToggleToolButton_(button), button, 1, "gtk_toggle_tool_button_set_active", "GtkToggleToolButton*");
  Xen_check_type(Xen_is_gboolean(is_active), is_active, 2, "gtk_toggle_tool_button_set_active", "gboolean");
  gtk_toggle_tool_button_set_active(Xen_to_C_GtkToggleToolButton_(button), Xen_to_C_gboolean(is_active));
  return(Xen_false);
}

static Xen gxg_gtk_toggle_tool_button_get_active(Xen button)
{
  #define H_gtk_toggle_tool_button_get_active "gboolean gtk_toggle_tool_button_get_active(GtkToggleToolButton* button)"
  Xen_check_type(Xen_is_GtkToggleToolButton_(button), button, 1, "gtk_toggle_tool_button_get_active", "GtkToggleToolButton*");
  return(C_to_Xen_gboolean(gtk_toggle_tool_button_get_active(Xen_to_C_GtkToggleToolButton_(button))));
}

static Xen gxg_g_timeout_add_full(Xen priority, Xen interval, Xen func, Xen func_info, Xen notify)
{
  #define H_g_timeout_add_full "guint g_timeout_add_full(gint priority, guint interval, GSourceFunc func, \
lambda_data func_info, GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_gint(priority), priority, 1, "g_timeout_add_full", "gint");
  Xen_check_type(Xen_is_guint(interval), interval, 2, "g_timeout_add_full", "guint");
  Xen_check_type(Xen_is_GSourceFunc(func), func, 3, "g_timeout_add_full", "GSourceFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "g_timeout_add_full", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 5, "g_timeout_add_full", "GtkDestroyNotify");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, notify);
    result = C_to_Xen_guint(g_timeout_add_full(Xen_to_C_gint(priority), Xen_to_C_guint(interval), Xen_to_C_GSourceFunc(func), 
                                               Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(notify)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, result, C_int_to_Xen_integer(loc)));
    return(result);
   }
}

static Xen gxg_g_timeout_add(Xen interval, Xen func, Xen func_info)
{
  #define H_g_timeout_add "guint g_timeout_add(guint interval, GSourceFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_guint(interval), interval, 1, "g_timeout_add", "guint");
  Xen_check_type(Xen_is_GSourceFunc(func), func, 2, "g_timeout_add", "GSourceFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "g_timeout_add", "lambda_data");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_guint(g_timeout_add(Xen_to_C_guint(interval), Xen_to_C_GSourceFunc(func), Xen_to_C_lambda_data(func_info)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, result, C_int_to_Xen_integer(loc)));
    return(result);
   }
}

static Xen gxg_g_idle_add(Xen func, Xen func_info)
{
  #define H_g_idle_add "guint g_idle_add(GSourceFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GSourceFunc(func), func, 1, "g_idle_add", "GSourceFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 2, "g_idle_add", "lambda_data");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    result = C_to_Xen_guint(g_idle_add(Xen_to_C_GSourceFunc(func), Xen_to_C_lambda_data(func_info)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, result, C_int_to_Xen_integer(loc)));
    return(result);
   }
}

static Xen gxg_g_idle_add_full(Xen priority, Xen func, Xen func_info, Xen notify)
{
  #define H_g_idle_add_full "guint g_idle_add_full(gint priority, GSourceFunc func, lambda_data func_info, \
GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_gint(priority), priority, 1, "g_idle_add_full", "gint");
  Xen_check_type(Xen_is_GSourceFunc(func), func, 2, "g_idle_add_full", "GSourceFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "g_idle_add_full", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 4, "g_idle_add_full", "GtkDestroyNotify");
  {
    Xen result;
    int loc;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    loc = xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 2, C_int_to_Xen_integer(loc));
    Xen_list_set(gxg_ptr, 3, notify);
    result = C_to_Xen_guint(g_idle_add_full(Xen_to_C_gint(priority), Xen_to_C_GSourceFunc(func), Xen_to_C_lambda_data(func_info), 
                                            Xen_to_C_GtkDestroyNotify(notify)));
    Xen_list_set(gxg_ptr, 2, Xen_list_3(xg_idler_symbol, result, C_int_to_Xen_integer(loc)));
    return(result);
   }
}

static Xen gxg_g_idle_remove_by_data(Xen data)
{
  #define H_g_idle_remove_by_data "gboolean g_idle_remove_by_data(gpointer data)"
  Xen_check_type(Xen_is_gpointer(data), data, 1, "g_idle_remove_by_data", "gpointer");
  xm_unprotect_at(Xen_integer_to_C_int(Xen_caddr(data)));
  return(C_to_Xen_gboolean(g_idle_remove_by_data(Xen_to_C_gpointer(data))));
}

static Xen gxg_g_source_remove(Xen tag)
{
  #define H_g_source_remove "gboolean g_source_remove(guint tag)"
  Xen_check_type(Xen_is_guint(tag), tag, 1, "g_source_remove", "guint");
  xm_unprotect_at(Xen_integer_to_C_int(Xen_caddr(tag)));
  return(C_to_Xen_gboolean(g_source_remove(Xen_to_C_guint(tag))));
}

static Xen gxg_gtk_file_filter_new(void)
{
  #define H_gtk_file_filter_new "GtkFileFilter* gtk_file_filter_new( void)"
  return(C_to_Xen_GtkFileFilter_(gtk_file_filter_new()));
}

static Xen gxg_gtk_file_filter_set_name(Xen filter, Xen name)
{
  #define H_gtk_file_filter_set_name "void gtk_file_filter_set_name(GtkFileFilter* filter, gchar* name)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_set_name", "GtkFileFilter*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_file_filter_set_name", "gchar*");
  gtk_file_filter_set_name(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_file_filter_get_name(Xen filter)
{
  #define H_gtk_file_filter_get_name "gchar* gtk_file_filter_get_name(GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_get_name", "GtkFileFilter*");
  return(C_to_Xen_gchar_(gtk_file_filter_get_name(Xen_to_C_GtkFileFilter_(filter))));
}

static Xen gxg_gtk_file_filter_add_mime_type(Xen filter, Xen mime_type)
{
  #define H_gtk_file_filter_add_mime_type "void gtk_file_filter_add_mime_type(GtkFileFilter* filter, \
gchar* mime_type)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_mime_type", "GtkFileFilter*");
  Xen_check_type(Xen_is_gchar_(mime_type), mime_type, 2, "gtk_file_filter_add_mime_type", "gchar*");
  gtk_file_filter_add_mime_type(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_gchar_(mime_type));
  return(Xen_false);
}

static Xen gxg_gtk_file_filter_add_pattern(Xen filter, Xen pattern)
{
  #define H_gtk_file_filter_add_pattern "void gtk_file_filter_add_pattern(GtkFileFilter* filter, gchar* pattern)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_pattern", "GtkFileFilter*");
  Xen_check_type(Xen_is_gchar_(pattern), pattern, 2, "gtk_file_filter_add_pattern", "gchar*");
  gtk_file_filter_add_pattern(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_gchar_(pattern));
  return(Xen_false);
}

static Xen gxg_gtk_file_filter_add_custom(Xen filter, Xen needed, Xen func, Xen func_info, Xen notify)
{
  #define H_gtk_file_filter_add_custom "void gtk_file_filter_add_custom(GtkFileFilter* filter, GtkFileFilterFlags needed, \
GtkFileFilterFunc func, lambda_data func_info, GtkDestroyNotify notify)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_custom", "GtkFileFilter*");
  Xen_check_type(Xen_is_GtkFileFilterFlags(needed), needed, 2, "gtk_file_filter_add_custom", "GtkFileFilterFlags");
  Xen_check_type(Xen_is_GtkFileFilterFunc(func), func, 3, "gtk_file_filter_add_custom", "GtkFileFilterFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "gtk_file_filter_add_custom", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(notify), notify, 5, "gtk_file_filter_add_custom", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, notify);
    gtk_file_filter_add_custom(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_GtkFileFilterFlags(needed), Xen_to_C_GtkFileFilterFunc(func), 
                           Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(notify));
    return(Xen_false);
   }
}

static Xen gxg_gtk_file_filter_get_needed(Xen filter)
{
  #define H_gtk_file_filter_get_needed "GtkFileFilterFlags gtk_file_filter_get_needed(GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_get_needed", "GtkFileFilter*");
  return(C_to_Xen_GtkFileFilterFlags(gtk_file_filter_get_needed(Xen_to_C_GtkFileFilter_(filter))));
}

static Xen gxg_gtk_file_filter_filter(Xen filter, Xen filter_info)
{
  #define H_gtk_file_filter_filter "gboolean gtk_file_filter_filter(GtkFileFilter* filter, GtkFileFilterInfo* filter_info)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_filter", "GtkFileFilter*");
  Xen_check_type(Xen_is_GtkFileFilterInfo_(filter_info), filter_info, 2, "gtk_file_filter_filter", "GtkFileFilterInfo*");
  return(C_to_Xen_gboolean(gtk_file_filter_filter(Xen_to_C_GtkFileFilter_(filter), Xen_to_C_GtkFileFilterInfo_(filter_info))));
}

static Xen gxg_gtk_cell_layout_pack_start(Xen cell_layout, Xen cell, Xen expand)
{
  #define H_gtk_cell_layout_pack_start "void gtk_cell_layout_pack_start(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_pack_start", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_pack_start", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_cell_layout_pack_start", "gboolean");
  gtk_cell_layout_pack_start(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_pack_end(Xen cell_layout, Xen cell, Xen expand)
{
  #define H_gtk_cell_layout_pack_end "void gtk_cell_layout_pack_end(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_pack_end", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_pack_end", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 3, "gtk_cell_layout_pack_end", "gboolean");
  gtk_cell_layout_pack_end(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_clear(Xen cell_layout)
{
  #define H_gtk_cell_layout_clear "void gtk_cell_layout_clear(GtkCellLayout* cell_layout)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_clear", "GtkCellLayout*");
  gtk_cell_layout_clear(Xen_to_C_GtkCellLayout_(cell_layout));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_set_attributes(Xen cell_layout, Xen cell, Xen attributes)
{
  #define H_gtk_cell_layout_set_attributes "void gtk_cell_layout_set_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, etc attributes)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_set_attributes", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_set_attributes", "GtkCellRenderer*");
  Xen_check_type(Xen_is_etc(attributes), attributes, 3, "gtk_cell_layout_set_attributes", "etc");
  {
    int etc_len = 0;
    GtkCellLayout* p_arg0;
    GtkCellRenderer* p_arg1;
    if (Xen_is_list(attributes)) etc_len = Xen_list_length(attributes);
    if (etc_len < 2) Xen_out_of_range_error("gtk_cell_layout_set_attributes", 2, attributes, "... list must have at least 2 entries");
    if (etc_len > 10) Xen_out_of_range_error("gtk_cell_layout_set_attributes", 2, attributes, "... list too long (max len: 10)");
    if ((etc_len % 2) != 0) Xen_out_of_range_error("gtk_cell_layout_set_attributes", 2, attributes, "... list len must be multiple of 2");
    p_arg0 = Xen_to_C_GtkCellLayout_(cell_layout);
    p_arg1 = Xen_to_C_GtkCellRenderer_(cell);
    switch (etc_len)
      {
        case 2: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), NULL); break;
        case 4: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), NULL); break;
        case 6: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), NULL); break;
        case 8: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), NULL); break;
        case 10: gtk_cell_layout_set_attributes(p_arg0, p_arg1, XLS(attributes, 0), XLI(attributes, 1), XLS(attributes, 2), XLI(attributes, 3), XLS(attributes, 4), XLI(attributes, 5), XLS(attributes, 6), XLI(attributes, 7), XLS(attributes, 8), XLI(attributes, 9), NULL); break;
      }
    return(Xen_false);
  }
}

static Xen gxg_gtk_cell_layout_add_attribute(Xen cell_layout, Xen cell, Xen attribute, Xen column)
{
  #define H_gtk_cell_layout_add_attribute "void gtk_cell_layout_add_attribute(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, gchar* attribute, gint column)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_add_attribute", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_add_attribute", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gchar_(attribute), attribute, 3, "gtk_cell_layout_add_attribute", "gchar*");
  Xen_check_type(Xen_is_gint(column), column, 4, "gtk_cell_layout_add_attribute", "gint");
  gtk_cell_layout_add_attribute(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gchar_(attribute), 
                                Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_cell_layout_set_cell_data_func(Xen cell_layout, Xen cell, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_cell_layout_set_cell_data_func "void gtk_cell_layout_set_cell_data_func(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell, GtkCellLayoutDataFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_set_cell_data_func", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_set_cell_data_func", "GtkCellRenderer*");
  Xen_check_type(Xen_is_GtkCellLayoutDataFunc(func), func, 3, "gtk_cell_layout_set_cell_data_func", "GtkCellLayoutDataFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "gtk_cell_layout_set_cell_data_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 5, "gtk_cell_layout_set_cell_data_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_cell_layout_set_cell_data_func(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_GtkCellLayoutDataFunc(func), 
                                   Xen_to_C_lambda_data(func_info), Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_cell_layout_clear_attributes(Xen cell_layout, Xen cell)
{
  #define H_gtk_cell_layout_clear_attributes "void gtk_cell_layout_clear_attributes(GtkCellLayout* cell_layout, \
GtkCellRenderer* cell)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_clear_attributes", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_clear_attributes", "GtkCellRenderer*");
  gtk_cell_layout_clear_attributes(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_set_action(Xen chooser, Xen action)
{
  #define H_gtk_file_chooser_set_action "void gtk_file_chooser_set_action(GtkFileChooser* chooser, GtkFileChooserAction action)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_action", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 2, "gtk_file_chooser_set_action", "GtkFileChooserAction");
  gtk_file_chooser_set_action(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkFileChooserAction(action));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_action(Xen chooser)
{
  #define H_gtk_file_chooser_get_action "GtkFileChooserAction gtk_file_chooser_get_action(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_action", "GtkFileChooser*");
  return(C_to_Xen_GtkFileChooserAction(gtk_file_chooser_get_action(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_local_only(Xen chooser, Xen files_only)
{
  #define H_gtk_file_chooser_set_local_only "void gtk_file_chooser_set_local_only(GtkFileChooser* chooser, \
gboolean files_only)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_local_only", "GtkFileChooser*");
  Xen_check_type(Xen_is_gboolean(files_only), files_only, 2, "gtk_file_chooser_set_local_only", "gboolean");
  gtk_file_chooser_set_local_only(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gboolean(files_only));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_local_only(Xen chooser)
{
  #define H_gtk_file_chooser_get_local_only "gboolean gtk_file_chooser_get_local_only(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_local_only", "GtkFileChooser*");
  return(C_to_Xen_gboolean(gtk_file_chooser_get_local_only(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_select_multiple(Xen chooser, Xen select_multiple)
{
  #define H_gtk_file_chooser_set_select_multiple "void gtk_file_chooser_set_select_multiple(GtkFileChooser* chooser, \
gboolean select_multiple)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_select_multiple", "GtkFileChooser*");
  Xen_check_type(Xen_is_gboolean(select_multiple), select_multiple, 2, "gtk_file_chooser_set_select_multiple", "gboolean");
  gtk_file_chooser_set_select_multiple(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gboolean(select_multiple));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_select_multiple(Xen chooser)
{
  #define H_gtk_file_chooser_get_select_multiple "gboolean gtk_file_chooser_get_select_multiple(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_select_multiple", "GtkFileChooser*");
  return(C_to_Xen_gboolean(gtk_file_chooser_get_select_multiple(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_current_name(Xen chooser, Xen name)
{
  #define H_gtk_file_chooser_set_current_name "void gtk_file_chooser_set_current_name(GtkFileChooser* chooser, \
gchar* name)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_current_name", "GtkFileChooser*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_file_chooser_set_current_name", "gchar*");
  gtk_file_chooser_set_current_name(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_filename(Xen chooser)
{
  #define H_gtk_file_chooser_get_filename "gchar* gtk_file_chooser_get_filename(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_filename", "GtkFileChooser*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_file_chooser_get_filename(Xen_to_C_GtkFileChooser_(chooser));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_set_filename(Xen chooser, Xen filename)
{
  #define H_gtk_file_chooser_set_filename "gboolean gtk_file_chooser_set_filename(GtkFileChooser* chooser, \
char* filename)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_filename", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(filename), filename, 2, "gtk_file_chooser_set_filename", "char*");
  return(C_to_Xen_gboolean(gtk_file_chooser_set_filename(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(filename))));
}

static Xen gxg_gtk_file_chooser_select_filename(Xen chooser, Xen filename)
{
  #define H_gtk_file_chooser_select_filename "gboolean gtk_file_chooser_select_filename(GtkFileChooser* chooser, \
char* filename)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_select_filename", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(filename), filename, 2, "gtk_file_chooser_select_filename", "char*");
  return(C_to_Xen_gboolean(gtk_file_chooser_select_filename(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(filename))));
}

static Xen gxg_gtk_file_chooser_unselect_filename(Xen chooser, Xen filename)
{
  #define H_gtk_file_chooser_unselect_filename "void gtk_file_chooser_unselect_filename(GtkFileChooser* chooser, \
char* filename)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_unselect_filename", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(filename), filename, 2, "gtk_file_chooser_unselect_filename", "char*");
  gtk_file_chooser_unselect_filename(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(filename));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_select_all(Xen chooser)
{
  #define H_gtk_file_chooser_select_all "void gtk_file_chooser_select_all(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_select_all", "GtkFileChooser*");
  gtk_file_chooser_select_all(Xen_to_C_GtkFileChooser_(chooser));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_unselect_all(Xen chooser)
{
  #define H_gtk_file_chooser_unselect_all "void gtk_file_chooser_unselect_all(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_unselect_all", "GtkFileChooser*");
  gtk_file_chooser_unselect_all(Xen_to_C_GtkFileChooser_(chooser));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_filenames(Xen chooser)
{
  #define H_gtk_file_chooser_get_filenames "GSList* gtk_file_chooser_get_filenames(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_filenames", "GtkFileChooser*");
  return(C_to_Xen_GSList_(gtk_file_chooser_get_filenames(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_current_folder(Xen chooser, Xen filename)
{
  #define H_gtk_file_chooser_set_current_folder "gboolean gtk_file_chooser_set_current_folder(GtkFileChooser* chooser, \
gchar* filename)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_current_folder", "GtkFileChooser*");
  Xen_check_type(Xen_is_gchar_(filename), filename, 2, "gtk_file_chooser_set_current_folder", "gchar*");
  return(C_to_Xen_gboolean(gtk_file_chooser_set_current_folder(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gchar_(filename))));
}

static Xen gxg_gtk_file_chooser_get_current_folder(Xen chooser)
{
  #define H_gtk_file_chooser_get_current_folder "gchar* gtk_file_chooser_get_current_folder(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_current_folder", "GtkFileChooser*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_file_chooser_get_current_folder(Xen_to_C_GtkFileChooser_(chooser));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_get_uri(Xen chooser)
{
  #define H_gtk_file_chooser_get_uri "gchar* gtk_file_chooser_get_uri(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_uri", "GtkFileChooser*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_file_chooser_get_uri(Xen_to_C_GtkFileChooser_(chooser));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_set_uri(Xen chooser, Xen uri)
{
  #define H_gtk_file_chooser_set_uri "gboolean gtk_file_chooser_set_uri(GtkFileChooser* chooser, char* uri)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_uri", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(uri), uri, 2, "gtk_file_chooser_set_uri", "char*");
  return(C_to_Xen_gboolean(gtk_file_chooser_set_uri(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(uri))));
}

static Xen gxg_gtk_file_chooser_select_uri(Xen chooser, Xen uri)
{
  #define H_gtk_file_chooser_select_uri "gboolean gtk_file_chooser_select_uri(GtkFileChooser* chooser, \
char* uri)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_select_uri", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(uri), uri, 2, "gtk_file_chooser_select_uri", "char*");
  return(C_to_Xen_gboolean(gtk_file_chooser_select_uri(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(uri))));
}

static Xen gxg_gtk_file_chooser_unselect_uri(Xen chooser, Xen uri)
{
  #define H_gtk_file_chooser_unselect_uri "void gtk_file_chooser_unselect_uri(GtkFileChooser* chooser, \
char* uri)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_unselect_uri", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(uri), uri, 2, "gtk_file_chooser_unselect_uri", "char*");
  gtk_file_chooser_unselect_uri(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(uri));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_uris(Xen chooser)
{
  #define H_gtk_file_chooser_get_uris "GSList* gtk_file_chooser_get_uris(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_uris", "GtkFileChooser*");
  return(C_to_Xen_GSList_(gtk_file_chooser_get_uris(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_current_folder_uri(Xen chooser, Xen uri)
{
  #define H_gtk_file_chooser_set_current_folder_uri "gboolean gtk_file_chooser_set_current_folder_uri(GtkFileChooser* chooser, \
gchar* uri)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_current_folder_uri", "GtkFileChooser*");
  Xen_check_type(Xen_is_gchar_(uri), uri, 2, "gtk_file_chooser_set_current_folder_uri", "gchar*");
  return(C_to_Xen_gboolean(gtk_file_chooser_set_current_folder_uri(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gchar_(uri))));
}

static Xen gxg_gtk_file_chooser_get_current_folder_uri(Xen chooser)
{
  #define H_gtk_file_chooser_get_current_folder_uri "gchar* gtk_file_chooser_get_current_folder_uri(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_current_folder_uri", "GtkFileChooser*");
  {
   gchar* result;
   Xen rtn;
   result = gtk_file_chooser_get_current_folder_uri(Xen_to_C_GtkFileChooser_(chooser));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_set_preview_widget(Xen chooser, Xen preview_widget)
{
  #define H_gtk_file_chooser_set_preview_widget "void gtk_file_chooser_set_preview_widget(GtkFileChooser* chooser, \
GtkWidget* preview_widget)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_preview_widget", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkWidget_(preview_widget), preview_widget, 2, "gtk_file_chooser_set_preview_widget", "GtkWidget*");
  gtk_file_chooser_set_preview_widget(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkWidget_(preview_widget));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_preview_widget(Xen chooser)
{
  #define H_gtk_file_chooser_get_preview_widget "GtkWidget* gtk_file_chooser_get_preview_widget(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_preview_widget", "GtkFileChooser*");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_get_preview_widget(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_preview_widget_active(Xen chooser, Xen active)
{
  #define H_gtk_file_chooser_set_preview_widget_active "void gtk_file_chooser_set_preview_widget_active(GtkFileChooser* chooser, \
gboolean active)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_preview_widget_active", "GtkFileChooser*");
  Xen_check_type(Xen_is_gboolean(active), active, 2, "gtk_file_chooser_set_preview_widget_active", "gboolean");
  gtk_file_chooser_set_preview_widget_active(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gboolean(active));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_preview_widget_active(Xen chooser)
{
  #define H_gtk_file_chooser_get_preview_widget_active "gboolean gtk_file_chooser_get_preview_widget_active(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_preview_widget_active", "GtkFileChooser*");
  return(C_to_Xen_gboolean(gtk_file_chooser_get_preview_widget_active(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_get_preview_filename(Xen file_chooser)
{
  #define H_gtk_file_chooser_get_preview_filename "char* gtk_file_chooser_get_preview_filename(GtkFileChooser* file_chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(file_chooser), file_chooser, 1, "gtk_file_chooser_get_preview_filename", "GtkFileChooser*");
  {
   char* result;
   Xen rtn;
   result = gtk_file_chooser_get_preview_filename(Xen_to_C_GtkFileChooser_(file_chooser));
   rtn = C_to_Xen_char_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_get_preview_uri(Xen file_chooser)
{
  #define H_gtk_file_chooser_get_preview_uri "char* gtk_file_chooser_get_preview_uri(GtkFileChooser* file_chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(file_chooser), file_chooser, 1, "gtk_file_chooser_get_preview_uri", "GtkFileChooser*");
  {
   char* result;
   Xen rtn;
   result = gtk_file_chooser_get_preview_uri(Xen_to_C_GtkFileChooser_(file_chooser));
   rtn = C_to_Xen_char_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_file_chooser_set_extra_widget(Xen chooser, Xen extra_widget)
{
  #define H_gtk_file_chooser_set_extra_widget "void gtk_file_chooser_set_extra_widget(GtkFileChooser* chooser, \
GtkWidget* extra_widget)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_extra_widget", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkWidget_(extra_widget), extra_widget, 2, "gtk_file_chooser_set_extra_widget", "GtkWidget*");
  gtk_file_chooser_set_extra_widget(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkWidget_(extra_widget));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_extra_widget(Xen chooser)
{
  #define H_gtk_file_chooser_get_extra_widget "GtkWidget* gtk_file_chooser_get_extra_widget(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_extra_widget", "GtkFileChooser*");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_get_extra_widget(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_add_filter(Xen chooser, Xen filter)
{
  #define H_gtk_file_chooser_add_filter "void gtk_file_chooser_add_filter(GtkFileChooser* chooser, GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_add_filter", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 2, "gtk_file_chooser_add_filter", "GtkFileFilter*");
  gtk_file_chooser_add_filter(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkFileFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_remove_filter(Xen chooser, Xen filter)
{
  #define H_gtk_file_chooser_remove_filter "void gtk_file_chooser_remove_filter(GtkFileChooser* chooser, \
GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_remove_filter", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 2, "gtk_file_chooser_remove_filter", "GtkFileFilter*");
  gtk_file_chooser_remove_filter(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkFileFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_list_filters(Xen chooser)
{
  #define H_gtk_file_chooser_list_filters "GSList* gtk_file_chooser_list_filters(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_list_filters", "GtkFileChooser*");
  return(C_to_Xen_GSList_(gtk_file_chooser_list_filters(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_set_filter(Xen chooser, Xen filter)
{
  #define H_gtk_file_chooser_set_filter "void gtk_file_chooser_set_filter(GtkFileChooser* chooser, GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_filter", "GtkFileChooser*");
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 2, "gtk_file_chooser_set_filter", "GtkFileFilter*");
  gtk_file_chooser_set_filter(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_GtkFileFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_filter(Xen chooser)
{
  #define H_gtk_file_chooser_get_filter "GtkFileFilter* gtk_file_chooser_get_filter(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_filter", "GtkFileChooser*");
  return(C_to_Xen_GtkFileFilter_(gtk_file_chooser_get_filter(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_add_shortcut_folder(Xen chooser, Xen folder, Xen ignore_error)
{
  #define H_gtk_file_chooser_add_shortcut_folder "gboolean gtk_file_chooser_add_shortcut_folder(GtkFileChooser* chooser, \
char* folder, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_add_shortcut_folder", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(folder), folder, 2, "gtk_file_chooser_add_shortcut_folder", "char*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_file_chooser_add_shortcut_folder(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(folder), 
                                                                    &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_file_chooser_remove_shortcut_folder(Xen chooser, Xen folder, Xen ignore_error)
{
  #define H_gtk_file_chooser_remove_shortcut_folder "gboolean gtk_file_chooser_remove_shortcut_folder(GtkFileChooser* chooser, \
char* folder, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_remove_shortcut_folder", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(folder), folder, 2, "gtk_file_chooser_remove_shortcut_folder", "char*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_file_chooser_remove_shortcut_folder(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(folder), 
                                                                       &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_file_chooser_list_shortcut_folders(Xen chooser)
{
  #define H_gtk_file_chooser_list_shortcut_folders "GSList* gtk_file_chooser_list_shortcut_folders(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_list_shortcut_folders", "GtkFileChooser*");
  return(C_to_Xen_GSList_(gtk_file_chooser_list_shortcut_folders(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_file_chooser_add_shortcut_folder_uri(Xen chooser, Xen folder, Xen ignore_error)
{
  #define H_gtk_file_chooser_add_shortcut_folder_uri "gboolean gtk_file_chooser_add_shortcut_folder_uri(GtkFileChooser* chooser, \
char* folder, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_add_shortcut_folder_uri", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(folder), folder, 2, "gtk_file_chooser_add_shortcut_folder_uri", "char*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_file_chooser_add_shortcut_folder_uri(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(folder), 
                                                                        &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_file_chooser_remove_shortcut_folder_uri(Xen chooser, Xen folder, Xen ignore_error)
{
  #define H_gtk_file_chooser_remove_shortcut_folder_uri "gboolean gtk_file_chooser_remove_shortcut_folder_uri(GtkFileChooser* chooser, \
char* folder, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_remove_shortcut_folder_uri", "GtkFileChooser*");
  Xen_check_type(Xen_is_char_(folder), folder, 2, "gtk_file_chooser_remove_shortcut_folder_uri", "char*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_file_chooser_remove_shortcut_folder_uri(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_char_(folder), 
                                                                           &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_file_chooser_list_shortcut_folder_uris(Xen chooser)
{
  #define H_gtk_file_chooser_list_shortcut_folder_uris "GSList* gtk_file_chooser_list_shortcut_folder_uris(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_list_shortcut_folder_uris", "GtkFileChooser*");
  return(C_to_Xen_GSList_(gtk_file_chooser_list_shortcut_folder_uris(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_icon_theme_new(void)
{
  #define H_gtk_icon_theme_new "GtkIconTheme* gtk_icon_theme_new( void)"
  return(C_to_Xen_GtkIconTheme_(gtk_icon_theme_new()));
}

static Xen gxg_gtk_icon_theme_get_default(void)
{
  #define H_gtk_icon_theme_get_default "GtkIconTheme* gtk_icon_theme_get_default( void)"
  return(C_to_Xen_GtkIconTheme_(gtk_icon_theme_get_default()));
}

static Xen gxg_gtk_icon_theme_get_search_path(Xen icon_theme, Xen ignore_path, Xen ignore_n_elements)
{
  #define H_gtk_icon_theme_get_search_path "void gtk_icon_theme_get_search_path(GtkIconTheme* icon_theme, \
gchar*** [path], gint* [n_elements])"
  gchar** ref_path = NULL;
  gint ref_n_elements;
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_get_search_path", "GtkIconTheme*");
  gtk_icon_theme_get_search_path(Xen_to_C_GtkIconTheme_(icon_theme), &ref_path, &ref_n_elements);
  return(Xen_list_2(C_to_Xen_gchar__(ref_path), C_to_Xen_gint(ref_n_elements)));
}

static Xen gxg_gtk_icon_theme_append_search_path(Xen icon_theme, Xen path)
{
  #define H_gtk_icon_theme_append_search_path "void gtk_icon_theme_append_search_path(GtkIconTheme* icon_theme, \
gchar* path)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_append_search_path", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(path), path, 2, "gtk_icon_theme_append_search_path", "gchar*");
  gtk_icon_theme_append_search_path(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_theme_prepend_search_path(Xen icon_theme, Xen path)
{
  #define H_gtk_icon_theme_prepend_search_path "void gtk_icon_theme_prepend_search_path(GtkIconTheme* icon_theme, \
gchar* path)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_prepend_search_path", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(path), path, 2, "gtk_icon_theme_prepend_search_path", "gchar*");
  gtk_icon_theme_prepend_search_path(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_theme_set_custom_theme(Xen icon_theme, Xen theme_name)
{
  #define H_gtk_icon_theme_set_custom_theme "void gtk_icon_theme_set_custom_theme(GtkIconTheme* icon_theme, \
gchar* theme_name)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_set_custom_theme", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(theme_name), theme_name, 2, "gtk_icon_theme_set_custom_theme", "gchar*");
  gtk_icon_theme_set_custom_theme(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(theme_name));
  return(Xen_false);
}

static Xen gxg_gtk_icon_theme_has_icon(Xen icon_theme, Xen icon_name)
{
  #define H_gtk_icon_theme_has_icon "gboolean gtk_icon_theme_has_icon(GtkIconTheme* icon_theme, gchar* icon_name)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_has_icon", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_icon_theme_has_icon", "gchar*");
  return(C_to_Xen_gboolean(gtk_icon_theme_has_icon(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(icon_name))));
}

static Xen gxg_gtk_icon_theme_lookup_icon(Xen icon_theme, Xen icon_name, Xen size, Xen flags)
{
  #define H_gtk_icon_theme_lookup_icon "GtkIconInfo* gtk_icon_theme_lookup_icon(GtkIconTheme* icon_theme, \
gchar* icon_name, gint size, GtkIconLookupFlags flags)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_lookup_icon", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_icon_theme_lookup_icon", "gchar*");
  Xen_check_type(Xen_is_gint(size), size, 3, "gtk_icon_theme_lookup_icon", "gint");
  Xen_check_type(Xen_is_GtkIconLookupFlags(flags), flags, 4, "gtk_icon_theme_lookup_icon", "GtkIconLookupFlags");
  return(C_to_Xen_GtkIconInfo_(gtk_icon_theme_lookup_icon(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(icon_name), 
                                                          Xen_to_C_gint(size), Xen_to_C_GtkIconLookupFlags(flags))));
}

static Xen gxg_gtk_icon_theme_load_icon(Xen icon_theme, Xen icon_name, Xen size, Xen flags, Xen ignore_error)
{
  #define H_gtk_icon_theme_load_icon "GdkPixbuf* gtk_icon_theme_load_icon(GtkIconTheme* icon_theme, gchar* icon_name, \
gint size, GtkIconLookupFlags flags, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_load_icon", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_icon_theme_load_icon", "gchar*");
  Xen_check_type(Xen_is_gint(size), size, 3, "gtk_icon_theme_load_icon", "gint");
  Xen_check_type(Xen_is_GtkIconLookupFlags(flags), flags, 4, "gtk_icon_theme_load_icon", "GtkIconLookupFlags");
  {
    Xen result;
    result = C_to_Xen_GdkPixbuf_(gtk_icon_theme_load_icon(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(icon_name), 
                                                          Xen_to_C_gint(size), Xen_to_C_GtkIconLookupFlags(flags), &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_icon_theme_list_icons(Xen icon_theme, Xen context)
{
  #define H_gtk_icon_theme_list_icons "GList* gtk_icon_theme_list_icons(GtkIconTheme* icon_theme, gchar* context)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_list_icons", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(context), context, 2, "gtk_icon_theme_list_icons", "gchar*");
  return(C_to_Xen_GList_(gtk_icon_theme_list_icons(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(context))));
}

static Xen gxg_gtk_icon_theme_get_example_icon_name(Xen icon_theme)
{
  #define H_gtk_icon_theme_get_example_icon_name "char* gtk_icon_theme_get_example_icon_name(GtkIconTheme* icon_theme)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_get_example_icon_name", "GtkIconTheme*");
  return(C_to_Xen_char_(gtk_icon_theme_get_example_icon_name(Xen_to_C_GtkIconTheme_(icon_theme))));
}

static Xen gxg_gtk_icon_theme_rescan_if_needed(Xen icon_theme)
{
  #define H_gtk_icon_theme_rescan_if_needed "gboolean gtk_icon_theme_rescan_if_needed(GtkIconTheme* icon_theme)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_rescan_if_needed", "GtkIconTheme*");
  return(C_to_Xen_gboolean(gtk_icon_theme_rescan_if_needed(Xen_to_C_GtkIconTheme_(icon_theme))));
}

static Xen gxg_gtk_icon_info_get_base_size(Xen icon_info)
{
  #define H_gtk_icon_info_get_base_size "gint gtk_icon_info_get_base_size(GtkIconInfo* icon_info)"
  Xen_check_type(Xen_is_GtkIconInfo_(icon_info), icon_info, 1, "gtk_icon_info_get_base_size", "GtkIconInfo*");
  return(C_to_Xen_gint(gtk_icon_info_get_base_size(Xen_to_C_GtkIconInfo_(icon_info))));
}

static Xen gxg_gtk_icon_info_get_filename(Xen icon_info)
{
  #define H_gtk_icon_info_get_filename "gchar* gtk_icon_info_get_filename(GtkIconInfo* icon_info)"
  Xen_check_type(Xen_is_GtkIconInfo_(icon_info), icon_info, 1, "gtk_icon_info_get_filename", "GtkIconInfo*");
  return(C_to_Xen_gchar_(gtk_icon_info_get_filename(Xen_to_C_GtkIconInfo_(icon_info))));
}

static Xen gxg_gtk_icon_info_load_icon(Xen icon_info, Xen ignore_error)
{
  #define H_gtk_icon_info_load_icon "GdkPixbuf* gtk_icon_info_load_icon(GtkIconInfo* icon_info, GError** [error])"
  GError* ref_error = NULL;
  Xen_check_type(Xen_is_GtkIconInfo_(icon_info), icon_info, 1, "gtk_icon_info_load_icon", "GtkIconInfo*");
  {
    Xen result;
    result = C_to_Xen_GdkPixbuf_(gtk_icon_info_load_icon(Xen_to_C_GtkIconInfo_(icon_info), &ref_error));
    return(Xen_list_2(result, C_to_Xen_GError_(ref_error)));
   }
}

static Xen gxg_gtk_tool_button_new(Xen icon_widget, Xen label)
{
  #define H_gtk_tool_button_new "GtkToolItem* gtk_tool_button_new(GtkWidget* icon_widget, gchar* label)"
  Xen_check_type(Xen_is_GtkWidget_(icon_widget) || Xen_is_false(icon_widget), icon_widget, 1, "gtk_tool_button_new", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_tool_button_new", "gchar*");
  return(C_to_Xen_GtkToolItem_(gtk_tool_button_new(Xen_to_C_GtkWidget_(icon_widget), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_tool_button_set_label(Xen button, Xen label)
{
  #define H_gtk_tool_button_set_label "void gtk_tool_button_set_label(GtkToolButton* button, gchar* label)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_set_label", "GtkToolButton*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_tool_button_set_label", "gchar*");
  gtk_tool_button_set_label(Xen_to_C_GtkToolButton_(button), Xen_to_C_gchar_(label));
  return(Xen_false);
}

static Xen gxg_gtk_tool_button_get_label(Xen button)
{
  #define H_gtk_tool_button_get_label "gchar* gtk_tool_button_get_label(GtkToolButton* button)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_get_label", "GtkToolButton*");
  return(C_to_Xen_gchar_(gtk_tool_button_get_label(Xen_to_C_GtkToolButton_(button))));
}

static Xen gxg_gtk_tool_button_set_use_underline(Xen button, Xen use_underline)
{
  #define H_gtk_tool_button_set_use_underline "void gtk_tool_button_set_use_underline(GtkToolButton* button, \
gboolean use_underline)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_set_use_underline", "GtkToolButton*");
  Xen_check_type(Xen_is_gboolean(use_underline), use_underline, 2, "gtk_tool_button_set_use_underline", "gboolean");
  gtk_tool_button_set_use_underline(Xen_to_C_GtkToolButton_(button), Xen_to_C_gboolean(use_underline));
  return(Xen_false);
}

static Xen gxg_gtk_tool_button_get_use_underline(Xen button)
{
  #define H_gtk_tool_button_get_use_underline "gboolean gtk_tool_button_get_use_underline(GtkToolButton* button)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_get_use_underline", "GtkToolButton*");
  return(C_to_Xen_gboolean(gtk_tool_button_get_use_underline(Xen_to_C_GtkToolButton_(button))));
}

static Xen gxg_gtk_tool_button_set_icon_widget(Xen button, Xen icon_widget)
{
  #define H_gtk_tool_button_set_icon_widget "void gtk_tool_button_set_icon_widget(GtkToolButton* button, \
GtkWidget* icon_widget)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_set_icon_widget", "GtkToolButton*");
  Xen_check_type(Xen_is_GtkWidget_(icon_widget) || Xen_is_false(icon_widget), icon_widget, 2, "gtk_tool_button_set_icon_widget", "GtkWidget*");
  gtk_tool_button_set_icon_widget(Xen_to_C_GtkToolButton_(button), Xen_to_C_GtkWidget_(icon_widget));
  return(Xen_false);
}

static Xen gxg_gtk_tool_button_get_icon_widget(Xen button)
{
  #define H_gtk_tool_button_get_icon_widget "GtkWidget* gtk_tool_button_get_icon_widget(GtkToolButton* button)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_get_icon_widget", "GtkToolButton*");
  return(C_to_Xen_GtkWidget_(gtk_tool_button_get_icon_widget(Xen_to_C_GtkToolButton_(button))));
}

static Xen gxg_gtk_tool_button_set_label_widget(Xen button, Xen label_widget)
{
  #define H_gtk_tool_button_set_label_widget "void gtk_tool_button_set_label_widget(GtkToolButton* button, \
GtkWidget* label_widget)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_set_label_widget", "GtkToolButton*");
  Xen_check_type(Xen_is_GtkWidget_(label_widget) || Xen_is_false(label_widget), label_widget, 2, "gtk_tool_button_set_label_widget", "GtkWidget*");
  gtk_tool_button_set_label_widget(Xen_to_C_GtkToolButton_(button), Xen_to_C_GtkWidget_(label_widget));
  return(Xen_false);
}

static Xen gxg_gtk_tool_button_get_label_widget(Xen button)
{
  #define H_gtk_tool_button_get_label_widget "GtkWidget* gtk_tool_button_get_label_widget(GtkToolButton* button)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_get_label_widget", "GtkToolButton*");
  return(C_to_Xen_GtkWidget_(gtk_tool_button_get_label_widget(Xen_to_C_GtkToolButton_(button))));
}

static Xen gxg_gtk_tool_item_new(void)
{
  #define H_gtk_tool_item_new "GtkToolItem* gtk_tool_item_new( void)"
  return(C_to_Xen_GtkToolItem_(gtk_tool_item_new()));
}

static Xen gxg_gtk_tool_item_set_homogeneous(Xen tool_item, Xen homogeneous)
{
  #define H_gtk_tool_item_set_homogeneous "void gtk_tool_item_set_homogeneous(GtkToolItem* tool_item, \
gboolean homogeneous)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_set_homogeneous", "GtkToolItem*");
  Xen_check_type(Xen_is_gboolean(homogeneous), homogeneous, 2, "gtk_tool_item_set_homogeneous", "gboolean");
  gtk_tool_item_set_homogeneous(Xen_to_C_GtkToolItem_(tool_item), Xen_to_C_gboolean(homogeneous));
  return(Xen_false);
}

static Xen gxg_gtk_tool_item_get_homogeneous(Xen tool_item)
{
  #define H_gtk_tool_item_get_homogeneous "gboolean gtk_tool_item_get_homogeneous(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_get_homogeneous", "GtkToolItem*");
  return(C_to_Xen_gboolean(gtk_tool_item_get_homogeneous(Xen_to_C_GtkToolItem_(tool_item))));
}

static Xen gxg_gtk_tool_item_set_expand(Xen tool_item, Xen expand)
{
  #define H_gtk_tool_item_set_expand "void gtk_tool_item_set_expand(GtkToolItem* tool_item, gboolean expand)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_set_expand", "GtkToolItem*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_tool_item_set_expand", "gboolean");
  gtk_tool_item_set_expand(Xen_to_C_GtkToolItem_(tool_item), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tool_item_get_expand(Xen tool_item)
{
  #define H_gtk_tool_item_get_expand "gboolean gtk_tool_item_get_expand(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_get_expand", "GtkToolItem*");
  return(C_to_Xen_gboolean(gtk_tool_item_get_expand(Xen_to_C_GtkToolItem_(tool_item))));
}

static Xen gxg_gtk_tool_item_set_visible_horizontal(Xen toolitem, Xen visible_horizontal)
{
  #define H_gtk_tool_item_set_visible_horizontal "void gtk_tool_item_set_visible_horizontal(GtkToolItem* toolitem, \
gboolean visible_horizontal)"
  Xen_check_type(Xen_is_GtkToolItem_(toolitem), toolitem, 1, "gtk_tool_item_set_visible_horizontal", "GtkToolItem*");
  Xen_check_type(Xen_is_gboolean(visible_horizontal), visible_horizontal, 2, "gtk_tool_item_set_visible_horizontal", "gboolean");
  gtk_tool_item_set_visible_horizontal(Xen_to_C_GtkToolItem_(toolitem), Xen_to_C_gboolean(visible_horizontal));
  return(Xen_false);
}

static Xen gxg_gtk_tool_item_get_visible_horizontal(Xen toolitem)
{
  #define H_gtk_tool_item_get_visible_horizontal "gboolean gtk_tool_item_get_visible_horizontal(GtkToolItem* toolitem)"
  Xen_check_type(Xen_is_GtkToolItem_(toolitem), toolitem, 1, "gtk_tool_item_get_visible_horizontal", "GtkToolItem*");
  return(C_to_Xen_gboolean(gtk_tool_item_get_visible_horizontal(Xen_to_C_GtkToolItem_(toolitem))));
}

static Xen gxg_gtk_tool_item_set_visible_vertical(Xen toolitem, Xen visible_vertical)
{
  #define H_gtk_tool_item_set_visible_vertical "void gtk_tool_item_set_visible_vertical(GtkToolItem* toolitem, \
gboolean visible_vertical)"
  Xen_check_type(Xen_is_GtkToolItem_(toolitem), toolitem, 1, "gtk_tool_item_set_visible_vertical", "GtkToolItem*");
  Xen_check_type(Xen_is_gboolean(visible_vertical), visible_vertical, 2, "gtk_tool_item_set_visible_vertical", "gboolean");
  gtk_tool_item_set_visible_vertical(Xen_to_C_GtkToolItem_(toolitem), Xen_to_C_gboolean(visible_vertical));
  return(Xen_false);
}

static Xen gxg_gtk_tool_item_get_visible_vertical(Xen toolitem)
{
  #define H_gtk_tool_item_get_visible_vertical "gboolean gtk_tool_item_get_visible_vertical(GtkToolItem* toolitem)"
  Xen_check_type(Xen_is_GtkToolItem_(toolitem), toolitem, 1, "gtk_tool_item_get_visible_vertical", "GtkToolItem*");
  return(C_to_Xen_gboolean(gtk_tool_item_get_visible_vertical(Xen_to_C_GtkToolItem_(toolitem))));
}

static Xen gxg_gtk_tool_item_get_is_important(Xen tool_item)
{
  #define H_gtk_tool_item_get_is_important "gboolean gtk_tool_item_get_is_important(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_get_is_important", "GtkToolItem*");
  return(C_to_Xen_gboolean(gtk_tool_item_get_is_important(Xen_to_C_GtkToolItem_(tool_item))));
}

static Xen gxg_gtk_tool_item_set_is_important(Xen tool_item, Xen is_important)
{
  #define H_gtk_tool_item_set_is_important "void gtk_tool_item_set_is_important(GtkToolItem* tool_item, \
gboolean is_important)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_set_is_important", "GtkToolItem*");
  Xen_check_type(Xen_is_gboolean(is_important), is_important, 2, "gtk_tool_item_set_is_important", "gboolean");
  gtk_tool_item_set_is_important(Xen_to_C_GtkToolItem_(tool_item), Xen_to_C_gboolean(is_important));
  return(Xen_false);
}

static Xen gxg_gtk_tool_item_get_orientation(Xen tool_item)
{
  #define H_gtk_tool_item_get_orientation "GtkOrientation gtk_tool_item_get_orientation(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_get_orientation", "GtkToolItem*");
  return(C_to_Xen_GtkOrientation(gtk_tool_item_get_orientation(Xen_to_C_GtkToolItem_(tool_item))));
}

static Xen gxg_gtk_tool_item_get_toolbar_style(Xen tool_item)
{
  #define H_gtk_tool_item_get_toolbar_style "GtkToolbarStyle gtk_tool_item_get_toolbar_style(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_get_toolbar_style", "GtkToolItem*");
  return(C_to_Xen_GtkToolbarStyle(gtk_tool_item_get_toolbar_style(Xen_to_C_GtkToolItem_(tool_item))));
}

static Xen gxg_gtk_tool_item_retrieve_proxy_menu_item(Xen tool_item)
{
  #define H_gtk_tool_item_retrieve_proxy_menu_item "GtkWidget* gtk_tool_item_retrieve_proxy_menu_item(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_retrieve_proxy_menu_item", "GtkToolItem*");
  return(C_to_Xen_GtkWidget_(gtk_tool_item_retrieve_proxy_menu_item(Xen_to_C_GtkToolItem_(tool_item))));
}

static Xen gxg_gtk_tool_item_get_proxy_menu_item(Xen tool_item, Xen menu_item_id)
{
  #define H_gtk_tool_item_get_proxy_menu_item "GtkWidget* gtk_tool_item_get_proxy_menu_item(GtkToolItem* tool_item, \
gchar* menu_item_id)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_get_proxy_menu_item", "GtkToolItem*");
  Xen_check_type(Xen_is_gchar_(menu_item_id), menu_item_id, 2, "gtk_tool_item_get_proxy_menu_item", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_tool_item_get_proxy_menu_item(Xen_to_C_GtkToolItem_(tool_item), Xen_to_C_gchar_(menu_item_id))));
}

static Xen gxg_gtk_tool_item_set_proxy_menu_item(Xen tool_item, Xen menu_item_id, Xen menu_item)
{
  #define H_gtk_tool_item_set_proxy_menu_item "void gtk_tool_item_set_proxy_menu_item(GtkToolItem* tool_item, \
gchar* menu_item_id, GtkWidget* menu_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item) || Xen_is_false(tool_item), tool_item, 1, "gtk_tool_item_set_proxy_menu_item", "GtkToolItem*");
  Xen_check_type(Xen_is_gchar_(menu_item_id), menu_item_id, 2, "gtk_tool_item_set_proxy_menu_item", "gchar*");
  Xen_check_type(Xen_is_GtkWidget_(menu_item) || Xen_is_false(menu_item), menu_item, 3, "gtk_tool_item_set_proxy_menu_item", "GtkWidget*");
  gtk_tool_item_set_proxy_menu_item(Xen_to_C_GtkToolItem_(tool_item), Xen_to_C_gchar_(menu_item_id), Xen_to_C_GtkWidget_(menu_item));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_remove(Xen list_store, Xen iter)
{
  #define H_gtk_list_store_remove "gboolean gtk_list_store_remove(GtkListStore* list_store, GtkTreeIter* iter)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_remove", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_remove", "GtkTreeIter*");
  return(C_to_Xen_gboolean(gtk_list_store_remove(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter))));
}

static Xen gxg_gdk_display_get_default_group(Xen display)
{
  #define H_gdk_display_get_default_group "GdkWindow* gdk_display_get_default_group(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_get_default_group", "GdkDisplay*");
  return(C_to_Xen_GdkWindow_(gdk_display_get_default_group(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_window_get_group(Xen window)
{
  #define H_gdk_window_get_group "GdkWindow* gdk_window_get_group(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_group", "GdkWindow*");
  return(C_to_Xen_GdkWindow_(gdk_window_get_group(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gtk_cell_layout_reorder(Xen cell_layout, Xen cell, Xen position)
{
  #define H_gtk_cell_layout_reorder "void gtk_cell_layout_reorder(GtkCellLayout* cell_layout, GtkCellRenderer* cell, \
gint position)"
  Xen_check_type(Xen_is_GtkCellLayout_(cell_layout), cell_layout, 1, "gtk_cell_layout_reorder", "GtkCellLayout*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 2, "gtk_cell_layout_reorder", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_cell_layout_reorder", "gint");
  gtk_cell_layout_reorder(Xen_to_C_GtkCellLayout_(cell_layout), Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_cancel(Xen menu_shell)
{
  #define H_gtk_menu_shell_cancel "void gtk_menu_shell_cancel(GtkMenuShell* menu_shell)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_cancel", "GtkMenuShell*");
  gtk_menu_shell_cancel(Xen_to_C_GtkMenuShell_(menu_shell));
  return(Xen_false);
}

static Xen gxg_gtk_paned_get_child1(Xen paned)
{
  #define H_gtk_paned_get_child1 "GtkWidget* gtk_paned_get_child1(GtkPaned* paned)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_get_child1", "GtkPaned*");
  return(C_to_Xen_GtkWidget_(gtk_paned_get_child1(Xen_to_C_GtkPaned_(paned))));
}

static Xen gxg_gtk_paned_get_child2(Xen paned)
{
  #define H_gtk_paned_get_child2 "GtkWidget* gtk_paned_get_child2(GtkPaned* paned)"
  Xen_check_type(Xen_is_GtkPaned_(paned), paned, 1, "gtk_paned_get_child2", "GtkPaned*");
  return(C_to_Xen_GtkWidget_(gtk_paned_get_child2(Xen_to_C_GtkPaned_(paned))));
}

static Xen gxg_gtk_window_set_accept_focus(Xen window, Xen setting)
{
  #define H_gtk_window_set_accept_focus "void gtk_window_set_accept_focus(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_accept_focus", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_accept_focus", "gboolean");
  gtk_window_set_accept_focus(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_accept_focus(Xen window)
{
  #define H_gtk_window_get_accept_focus "gboolean gtk_window_get_accept_focus(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_accept_focus", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_accept_focus(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_g_list_nth_data(Xen list, Xen n)
{
  #define H_g_list_nth_data "gpointer g_list_nth_data(GList* list, guint n)"
  Xen_check_type(Xen_is_GList_(list), list, 1, "g_list_nth_data", "GList*");
  Xen_check_type(Xen_is_guint(n), n, 2, "g_list_nth_data", "guint");
  return(C_to_Xen_gpointer(g_list_nth_data(Xen_to_C_GList_(list), Xen_to_C_guint(n))));
}

static Xen gxg_gtk_accel_map_get(void)
{
  #define H_gtk_accel_map_get "GtkAccelMap* gtk_accel_map_get( void)"
  return(C_to_Xen_GtkAccelMap_(gtk_accel_map_get()));
}

static Xen gxg_gtk_combo_box_popup(Xen combo_box)
{
  #define H_gtk_combo_box_popup "void gtk_combo_box_popup(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_popup", "GtkComboBox*");
  gtk_combo_box_popup(Xen_to_C_GtkComboBox_(combo_box));
  return(Xen_false);
}

static Xen gxg_gtk_combo_box_popdown(Xen combo_box)
{
  #define H_gtk_combo_box_popdown "void gtk_combo_box_popdown(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_popdown", "GtkComboBox*");
  gtk_combo_box_popdown(Xen_to_C_GtkComboBox_(combo_box));
  return(Xen_false);
}

static Xen gxg_gtk_radio_menu_item_new_from_widget(Xen group)
{
  #define H_gtk_radio_menu_item_new_from_widget "GtkWidget* gtk_radio_menu_item_new_from_widget(GtkRadioMenuItem* group)"
  Xen_check_type(Xen_is_GtkRadioMenuItem_(group), group, 1, "gtk_radio_menu_item_new_from_widget", "GtkRadioMenuItem*");
  return(C_to_Xen_GtkWidget_(gtk_radio_menu_item_new_from_widget(Xen_to_C_GtkRadioMenuItem_(group))));
}

static Xen gxg_gtk_radio_menu_item_new_with_mnemonic_from_widget(Xen group, Xen label)
{
  #define H_gtk_radio_menu_item_new_with_mnemonic_from_widget "GtkWidget* gtk_radio_menu_item_new_with_mnemonic_from_widget(GtkRadioMenuItem* group, \
gchar* label)"
  Xen_check_type(Xen_is_GtkRadioMenuItem_(group), group, 1, "gtk_radio_menu_item_new_with_mnemonic_from_widget", "GtkRadioMenuItem*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_menu_item_new_with_mnemonic_from_widget", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_menu_item_new_with_mnemonic_from_widget(Xen_to_C_GtkRadioMenuItem_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_radio_menu_item_new_with_label_from_widget(Xen group, Xen label)
{
  #define H_gtk_radio_menu_item_new_with_label_from_widget "GtkWidget* gtk_radio_menu_item_new_with_label_from_widget(GtkRadioMenuItem* group, \
gchar* label)"
  Xen_check_type(Xen_is_GtkRadioMenuItem_(group), group, 1, "gtk_radio_menu_item_new_with_label_from_widget", "GtkRadioMenuItem*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_radio_menu_item_new_with_label_from_widget", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_radio_menu_item_new_with_label_from_widget(Xen_to_C_GtkRadioMenuItem_(group), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_scale_get_layout(Xen scale)
{
  #define H_gtk_scale_get_layout "PangoLayout* gtk_scale_get_layout(GtkScale* scale)"
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_layout", "GtkScale*");
  return(C_to_Xen_PangoLayout_(gtk_scale_get_layout(Xen_to_C_GtkScale_(scale))));
}

static Xen gxg_gtk_scale_get_layout_offsets(Xen scale, Xen ignore_x, Xen ignore_y)
{
  #define H_gtk_scale_get_layout_offsets "void gtk_scale_get_layout_offsets(GtkScale* scale, gint* [x], \
gint* [y])"
  gint ref_x;
  gint ref_y;
  Xen_check_type(Xen_is_GtkScale_(scale), scale, 1, "gtk_scale_get_layout_offsets", "GtkScale*");
  gtk_scale_get_layout_offsets(Xen_to_C_GtkScale_(scale), &ref_x, &ref_y);
  return(Xen_list_2(C_to_Xen_gint(ref_x), C_to_Xen_gint(ref_y)));
}

static Xen gxg_gtk_entry_set_alignment(Xen entry, Xen xalign)
{
  #define H_gtk_entry_set_alignment "void gtk_entry_set_alignment(GtkEntry* entry, gfloat xalign)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_set_alignment", "GtkEntry*");
  Xen_check_type(Xen_is_gfloat(xalign), xalign, 2, "gtk_entry_set_alignment", "gfloat");
  gtk_entry_set_alignment(Xen_to_C_GtkEntry_(entry), Xen_to_C_gfloat(xalign));
  return(Xen_false);
}

static Xen gxg_gtk_entry_get_alignment(Xen entry)
{
  #define H_gtk_entry_get_alignment "gfloat gtk_entry_get_alignment(GtkEntry* entry)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_get_alignment", "GtkEntry*");
  return(C_to_Xen_gfloat(gtk_entry_get_alignment(Xen_to_C_GtkEntry_(entry))));
}

static Xen gxg_gtk_file_chooser_set_use_preview_label(Xen chooser, Xen use_label)
{
  #define H_gtk_file_chooser_set_use_preview_label "void gtk_file_chooser_set_use_preview_label(GtkFileChooser* chooser, \
gboolean use_label)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_use_preview_label", "GtkFileChooser*");
  Xen_check_type(Xen_is_gboolean(use_label), use_label, 2, "gtk_file_chooser_set_use_preview_label", "gboolean");
  gtk_file_chooser_set_use_preview_label(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gboolean(use_label));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_use_preview_label(Xen chooser)
{
  #define H_gtk_file_chooser_get_use_preview_label "gboolean gtk_file_chooser_get_use_preview_label(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_use_preview_label", "GtkFileChooser*");
  return(C_to_Xen_gboolean(gtk_file_chooser_get_use_preview_label(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_widget_list_mnemonic_labels(Xen widget)
{
  #define H_gtk_widget_list_mnemonic_labels "GList* gtk_widget_list_mnemonic_labels(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_list_mnemonic_labels", "GtkWidget*");
  return(C_to_Xen_GList_(gtk_widget_list_mnemonic_labels(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_widget_add_mnemonic_label(Xen widget, Xen label)
{
  #define H_gtk_widget_add_mnemonic_label "void gtk_widget_add_mnemonic_label(GtkWidget* widget, GtkWidget* label)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_add_mnemonic_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(label), label, 2, "gtk_widget_add_mnemonic_label", "GtkWidget*");
  gtk_widget_add_mnemonic_label(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(label));
  return(Xen_false);
}

static Xen gxg_gtk_widget_remove_mnemonic_label(Xen widget, Xen label)
{
  #define H_gtk_widget_remove_mnemonic_label "void gtk_widget_remove_mnemonic_label(GtkWidget* widget, \
GtkWidget* label)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_widget_remove_mnemonic_label", "GtkWidget*");
  Xen_check_type(Xen_is_GtkWidget_(label), label, 2, "gtk_widget_remove_mnemonic_label", "GtkWidget*");
  gtk_widget_remove_mnemonic_label(Xen_to_C_GtkWidget_(widget), Xen_to_C_GtkWidget_(label));
  return(Xen_false);
}

static Xen gxg_gtk_window_activate_key(Xen window, Xen event)
{
  #define H_gtk_window_activate_key "gboolean gtk_window_activate_key(GtkWindow* window, GdkEventKey* event)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_activate_key", "GtkWindow*");
  Xen_check_type(Xen_is_GdkEventKey_(event), event, 2, "gtk_window_activate_key", "GdkEventKey*");
  return(C_to_Xen_gboolean(gtk_window_activate_key(Xen_to_C_GtkWindow_(window), Xen_to_C_GdkEventKey_(event))));
}

static Xen gxg_gtk_window_propagate_key_event(Xen window, Xen event)
{
  #define H_gtk_window_propagate_key_event "gboolean gtk_window_propagate_key_event(GtkWindow* window, \
GdkEventKey* event)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_propagate_key_event", "GtkWindow*");
  Xen_check_type(Xen_is_GdkEventKey_(event), event, 2, "gtk_window_propagate_key_event", "GdkEventKey*");
  return(C_to_Xen_gboolean(gtk_window_propagate_key_event(Xen_to_C_GtkWindow_(window), Xen_to_C_GdkEventKey_(event))));
}

static Xen gxg_g_quark_from_string(Xen string)
{
  #define H_g_quark_from_string "GQuark g_quark_from_string(gchar* string)"
  Xen_check_type(Xen_is_gchar_(string), string, 1, "g_quark_from_string", "gchar*");
  return(C_to_Xen_GQuark(g_quark_from_string(Xen_to_C_gchar_(string))));
}

static Xen gxg_g_quark_to_string(Xen quark)
{
  #define H_g_quark_to_string "gchar* g_quark_to_string(GQuark quark)"
  Xen_check_type(Xen_is_GQuark(quark), quark, 1, "g_quark_to_string", "GQuark");
  return(C_to_Xen_gchar_(g_quark_to_string(Xen_to_C_GQuark(quark))));
}

static Xen gxg_gtk_cell_view_new(void)
{
  #define H_gtk_cell_view_new "GtkWidget* gtk_cell_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_cell_view_new()));
}

static Xen gxg_gtk_cell_view_new_with_text(Xen text)
{
  #define H_gtk_cell_view_new_with_text "GtkWidget* gtk_cell_view_new_with_text(gchar* text)"
  Xen_check_type(Xen_is_gchar_(text), text, 1, "gtk_cell_view_new_with_text", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_cell_view_new_with_text(Xen_to_C_gchar_(text))));
}

static Xen gxg_gtk_cell_view_new_with_markup(Xen markup)
{
  #define H_gtk_cell_view_new_with_markup "GtkWidget* gtk_cell_view_new_with_markup(gchar* markup)"
  Xen_check_type(Xen_is_gchar_(markup), markup, 1, "gtk_cell_view_new_with_markup", "gchar*");
  return(C_to_Xen_GtkWidget_(gtk_cell_view_new_with_markup(Xen_to_C_gchar_(markup))));
}

static Xen gxg_gtk_cell_view_set_model(Xen cell_view, Xen model)
{
  #define H_gtk_cell_view_set_model "void gtk_cell_view_set_model(GtkCellView* cell_view, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_set_model", "GtkCellView*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_cell_view_set_model", "GtkTreeModel*");
  gtk_cell_view_set_model(Xen_to_C_GtkCellView_(cell_view), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_cell_view_set_displayed_row(Xen cell_view, Xen path)
{
  #define H_gtk_cell_view_set_displayed_row "void gtk_cell_view_set_displayed_row(GtkCellView* cell_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_set_displayed_row", "GtkCellView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_cell_view_set_displayed_row", "GtkTreePath*");
  gtk_cell_view_set_displayed_row(Xen_to_C_GtkCellView_(cell_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_cell_view_get_displayed_row(Xen cell_view)
{
  #define H_gtk_cell_view_get_displayed_row "GtkTreePath* gtk_cell_view_get_displayed_row(GtkCellView* cell_view)"
  Xen_check_type(Xen_is_GtkCellView_(cell_view), cell_view, 1, "gtk_cell_view_get_displayed_row", "GtkCellView*");
  return(C_to_Xen_GtkTreePath_(gtk_cell_view_get_displayed_row(Xen_to_C_GtkCellView_(cell_view))));
}

static Xen gxg_gtk_combo_box_get_wrap_width(Xen combo_box)
{
  #define H_gtk_combo_box_get_wrap_width "gint gtk_combo_box_get_wrap_width(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_wrap_width", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_wrap_width(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_get_row_span_column(Xen combo_box)
{
  #define H_gtk_combo_box_get_row_span_column "gint gtk_combo_box_get_row_span_column(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_row_span_column", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_row_span_column(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_combo_box_get_column_span_column(Xen combo_box)
{
  #define H_gtk_combo_box_get_column_span_column "gint gtk_combo_box_get_column_span_column(GtkComboBox* combo_box)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_get_column_span_column", "GtkComboBox*");
  return(C_to_Xen_gint(gtk_combo_box_get_column_span_column(Xen_to_C_GtkComboBox_(combo_box))));
}

static Xen gxg_gtk_drag_dest_add_text_targets(Xen widget)
{
  #define H_gtk_drag_dest_add_text_targets "void gtk_drag_dest_add_text_targets(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_dest_add_text_targets", "GtkWidget*");
  gtk_drag_dest_add_text_targets(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_source_add_text_targets(Xen widget)
{
  #define H_gtk_drag_source_add_text_targets "void gtk_drag_source_add_text_targets(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_source_add_text_targets", "GtkWidget*");
  gtk_drag_source_add_text_targets(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_insert_prefix(Xen completion)
{
  #define H_gtk_entry_completion_insert_prefix "void gtk_entry_completion_insert_prefix(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_insert_prefix", "GtkEntryCompletion*");
  gtk_entry_completion_insert_prefix(Xen_to_C_GtkEntryCompletion_(completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_set_inline_completion(Xen completion, Xen inline_completion)
{
  #define H_gtk_entry_completion_set_inline_completion "void gtk_entry_completion_set_inline_completion(GtkEntryCompletion* completion, \
gboolean inline_completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_inline_completion", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(inline_completion), inline_completion, 2, "gtk_entry_completion_set_inline_completion", "gboolean");
  gtk_entry_completion_set_inline_completion(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(inline_completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_inline_completion(Xen completion)
{
  #define H_gtk_entry_completion_get_inline_completion "gboolean gtk_entry_completion_get_inline_completion(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_inline_completion", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_inline_completion(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_set_popup_completion(Xen completion, Xen popup_completion)
{
  #define H_gtk_entry_completion_set_popup_completion "void gtk_entry_completion_set_popup_completion(GtkEntryCompletion* completion, \
gboolean popup_completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_popup_completion", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(popup_completion), popup_completion, 2, "gtk_entry_completion_set_popup_completion", "gboolean");
  gtk_entry_completion_set_popup_completion(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(popup_completion));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_popup_completion(Xen completion)
{
  #define H_gtk_entry_completion_get_popup_completion "gboolean gtk_entry_completion_get_popup_completion(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_popup_completion", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_popup_completion(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_get_text_column(Xen completion)
{
  #define H_gtk_entry_completion_get_text_column "gint gtk_entry_completion_get_text_column(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_text_column", "GtkEntryCompletion*");
  return(C_to_Xen_gint(gtk_entry_completion_get_text_column(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_icon_theme_get_icon_sizes(Xen icon_theme, Xen icon_name)
{
  #define H_gtk_icon_theme_get_icon_sizes "gint* gtk_icon_theme_get_icon_sizes(GtkIconTheme* icon_theme, \
gchar* icon_name)"
  Xen_check_type(Xen_is_GtkIconTheme_(icon_theme), icon_theme, 1, "gtk_icon_theme_get_icon_sizes", "GtkIconTheme*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_icon_theme_get_icon_sizes", "gchar*");
  return(C_to_Xen_gint_(gtk_icon_theme_get_icon_sizes(Xen_to_C_GtkIconTheme_(icon_theme), Xen_to_C_gchar_(icon_name))));
}

static Xen gxg_gtk_menu_get_for_attach_widget(Xen widget )
{
  #define H_gtk_menu_get_for_attach_widget "GList* gtk_menu_get_for_attach_widget(GtkWidget* widget, \
)"
  Xen_check_type(Xen_is_GtkWidget_(widget ), widget , 1, "gtk_menu_get_for_attach_widget", "GtkWidget*");
  return(C_to_Xen_GList_(gtk_menu_get_for_attach_widget(Xen_to_C_GtkWidget_(widget ))));
}

static Xen gxg_gtk_tree_view_set_fixed_height_mode(Xen tree_view, Xen enable)
{
  #define H_gtk_tree_view_set_fixed_height_mode "void gtk_tree_view_set_fixed_height_mode(GtkTreeView* tree_view, \
gboolean enable)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_fixed_height_mode", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(enable), enable, 2, "gtk_tree_view_set_fixed_height_mode", "gboolean");
  gtk_tree_view_set_fixed_height_mode(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(enable));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_fixed_height_mode(Xen tree_view)
{
  #define H_gtk_tree_view_get_fixed_height_mode "gboolean gtk_tree_view_get_fixed_height_mode(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_fixed_height_mode", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_fixed_height_mode(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_hover_selection(Xen tree_view, Xen hover)
{
  #define H_gtk_tree_view_set_hover_selection "void gtk_tree_view_set_hover_selection(GtkTreeView* tree_view, \
gboolean hover)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_hover_selection", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(hover), hover, 2, "gtk_tree_view_set_hover_selection", "gboolean");
  gtk_tree_view_set_hover_selection(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(hover));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_hover_selection(Xen tree_view)
{
  #define H_gtk_tree_view_get_hover_selection "gboolean gtk_tree_view_get_hover_selection(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_hover_selection", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_hover_selection(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tree_view_set_row_separator_func(Xen tree_view, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_tree_view_set_row_separator_func "void gtk_tree_view_set_row_separator_func(GtkTreeView* tree_view, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_row_separator_func", "GtkTreeView*");
  Xen_check_type(Xen_is_GtkTreeViewRowSeparatorFunc(func), func, 2, "gtk_tree_view_set_row_separator_func", "GtkTreeViewRowSeparatorFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_tree_view_set_row_separator_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_tree_view_set_row_separator_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_tree_view_set_row_separator_func(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_GtkTreeViewRowSeparatorFunc(func), Xen_to_C_lambda_data(func_info), 
                                     Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_window_set_focus_on_map(Xen window, Xen setting)
{
  #define H_gtk_window_set_focus_on_map "void gtk_window_set_focus_on_map(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_focus_on_map", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_focus_on_map", "gboolean");
  gtk_window_set_focus_on_map(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_focus_on_map(Xen window)
{
  #define H_gtk_window_get_focus_on_map "gboolean gtk_window_get_focus_on_map(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_focus_on_map", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_focus_on_map(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_icon_name(Xen window, Xen name)
{
  #define H_gtk_window_set_icon_name "void gtk_window_set_icon_name(GtkWindow* window, gchar* name)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_icon_name", "GtkWindow*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_window_set_icon_name", "gchar*");
  gtk_window_set_icon_name(Xen_to_C_GtkWindow_(window), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_icon_name(Xen window)
{
  #define H_gtk_window_get_icon_name "gchar* gtk_window_get_icon_name(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_icon_name", "GtkWindow*");
  return(C_to_Xen_gchar_(gtk_window_get_icon_name(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_set_default_icon_name(Xen name)
{
  #define H_gtk_window_set_default_icon_name "void gtk_window_set_default_icon_name(gchar* name)"
  Xen_check_type(Xen_is_gchar_(name), name, 1, "gtk_window_set_default_icon_name", "gchar*");
  gtk_window_set_default_icon_name(Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_new(void)
{
  #define H_gtk_about_dialog_new "GtkWidget* gtk_about_dialog_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_about_dialog_new()));
}

static Xen gxg_gtk_about_dialog_get_version(Xen about)
{
  #define H_gtk_about_dialog_get_version "gchar* gtk_about_dialog_get_version(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_version", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_version(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_version(Xen about, Xen version)
{
  #define H_gtk_about_dialog_set_version "void gtk_about_dialog_set_version(GtkAboutDialog* about, gchar* version)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_version", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(version), version, 2, "gtk_about_dialog_set_version", "gchar*");
  gtk_about_dialog_set_version(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(version));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_copyright(Xen about)
{
  #define H_gtk_about_dialog_get_copyright "gchar* gtk_about_dialog_get_copyright(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_copyright", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_copyright(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_copyright(Xen about, Xen copyright)
{
  #define H_gtk_about_dialog_set_copyright "void gtk_about_dialog_set_copyright(GtkAboutDialog* about, \
gchar* copyright)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_copyright", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(copyright), copyright, 2, "gtk_about_dialog_set_copyright", "gchar*");
  gtk_about_dialog_set_copyright(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(copyright));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_comments(Xen about)
{
  #define H_gtk_about_dialog_get_comments "gchar* gtk_about_dialog_get_comments(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_comments", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_comments(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_comments(Xen about, Xen comments)
{
  #define H_gtk_about_dialog_set_comments "void gtk_about_dialog_set_comments(GtkAboutDialog* about, \
gchar* comments)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_comments", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(comments), comments, 2, "gtk_about_dialog_set_comments", "gchar*");
  gtk_about_dialog_set_comments(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(comments));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_website(Xen about)
{
  #define H_gtk_about_dialog_get_website "gchar* gtk_about_dialog_get_website(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_website", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_website(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_website(Xen about, Xen website)
{
  #define H_gtk_about_dialog_set_website "void gtk_about_dialog_set_website(GtkAboutDialog* about, gchar* website)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_website", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(website), website, 2, "gtk_about_dialog_set_website", "gchar*");
  gtk_about_dialog_set_website(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(website));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_website_label(Xen about)
{
  #define H_gtk_about_dialog_get_website_label "gchar* gtk_about_dialog_get_website_label(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_website_label", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_website_label(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_website_label(Xen about, Xen website_label)
{
  #define H_gtk_about_dialog_set_website_label "void gtk_about_dialog_set_website_label(GtkAboutDialog* about, \
gchar* website_label)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_website_label", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(website_label), website_label, 2, "gtk_about_dialog_set_website_label", "gchar*");
  gtk_about_dialog_set_website_label(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(website_label));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_authors(Xen about)
{
  #define H_gtk_about_dialog_get_authors "gchar** gtk_about_dialog_get_authors(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_authors", "GtkAboutDialog*");
    return(C_to_Xen_gchar__((gchar**)gtk_about_dialog_get_authors(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_authors(Xen about, Xen authors)
{
  #define H_gtk_about_dialog_set_authors "void gtk_about_dialog_set_authors(GtkAboutDialog* about, gchar** authors)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_authors", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar__(authors), authors, 2, "gtk_about_dialog_set_authors", "gchar**");
  gtk_about_dialog_set_authors(Xen_to_C_GtkAboutDialog_(about), (const gchar**)Xen_to_C_gchar__(authors));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_documenters(Xen about)
{
  #define H_gtk_about_dialog_get_documenters "gchar** gtk_about_dialog_get_documenters(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_documenters", "GtkAboutDialog*");
    return(C_to_Xen_gchar__((gchar**)gtk_about_dialog_get_documenters(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_documenters(Xen about, Xen documenters)
{
  #define H_gtk_about_dialog_set_documenters "void gtk_about_dialog_set_documenters(GtkAboutDialog* about, \
gchar** documenters)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_documenters", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar__(documenters), documenters, 2, "gtk_about_dialog_set_documenters", "gchar**");
  gtk_about_dialog_set_documenters(Xen_to_C_GtkAboutDialog_(about), (const gchar**)Xen_to_C_gchar__(documenters));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_artists(Xen about)
{
  #define H_gtk_about_dialog_get_artists "gchar** gtk_about_dialog_get_artists(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_artists", "GtkAboutDialog*");
    return(C_to_Xen_gchar__((gchar**)gtk_about_dialog_get_artists(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_artists(Xen about, Xen artists)
{
  #define H_gtk_about_dialog_set_artists "void gtk_about_dialog_set_artists(GtkAboutDialog* about, gchar** artists)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_artists", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar__(artists), artists, 2, "gtk_about_dialog_set_artists", "gchar**");
  gtk_about_dialog_set_artists(Xen_to_C_GtkAboutDialog_(about), (const gchar**)Xen_to_C_gchar__(artists));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_translator_credits(Xen about)
{
  #define H_gtk_about_dialog_get_translator_credits "gchar* gtk_about_dialog_get_translator_credits(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_translator_credits", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_translator_credits(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_translator_credits(Xen about, Xen translator_credits)
{
  #define H_gtk_about_dialog_set_translator_credits "void gtk_about_dialog_set_translator_credits(GtkAboutDialog* about, \
gchar* translator_credits)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_translator_credits", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(translator_credits), translator_credits, 2, "gtk_about_dialog_set_translator_credits", "gchar*");
  gtk_about_dialog_set_translator_credits(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(translator_credits));
  return(Xen_false);
}

static Xen gxg_gtk_about_dialog_get_program_name(Xen about)
{
  #define H_gtk_about_dialog_get_program_name "gchar* gtk_about_dialog_get_program_name(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_program_name", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_program_name(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_program_name(Xen about, Xen name)
{
  #define H_gtk_about_dialog_set_program_name "void gtk_about_dialog_set_program_name(GtkAboutDialog* about, \
gchar* name)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_program_name", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(name), name, 2, "gtk_about_dialog_set_program_name", "gchar*");
  gtk_about_dialog_set_program_name(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(name));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_new(void)
{
  #define H_gtk_icon_view_new "GtkWidget* gtk_icon_view_new( void)"
  return(C_to_Xen_GtkWidget_(gtk_icon_view_new()));
}

static Xen gxg_gtk_icon_view_new_with_model(Xen model)
{
  #define H_gtk_icon_view_new_with_model "GtkWidget* gtk_icon_view_new_with_model(GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkTreeModel_(model), model, 1, "gtk_icon_view_new_with_model", "GtkTreeModel*");
  return(C_to_Xen_GtkWidget_(gtk_icon_view_new_with_model(Xen_to_C_GtkTreeModel_(model))));
}

static Xen gxg_gtk_icon_view_set_model(Xen icon_view, Xen model)
{
  #define H_gtk_icon_view_set_model "void gtk_icon_view_set_model(GtkIconView* icon_view, GtkTreeModel* model)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_model", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreeModel_(model) || Xen_is_false(model), model, 2, "gtk_icon_view_set_model", "GtkTreeModel*");
  gtk_icon_view_set_model(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreeModel_(model));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_model(Xen icon_view)
{
  #define H_gtk_icon_view_get_model "GtkTreeModel* gtk_icon_view_get_model(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_model", "GtkIconView*");
  return(C_to_Xen_GtkTreeModel_(gtk_icon_view_get_model(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_text_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_text_column "void gtk_icon_view_set_text_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_text_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_text_column", "gint");
  gtk_icon_view_set_text_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_text_column(Xen icon_view)
{
  #define H_gtk_icon_view_get_text_column "gint gtk_icon_view_get_text_column(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_text_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_text_column(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_markup_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_markup_column "void gtk_icon_view_set_markup_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_markup_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_markup_column", "gint");
  gtk_icon_view_set_markup_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_markup_column(Xen icon_view)
{
  #define H_gtk_icon_view_get_markup_column "gint gtk_icon_view_get_markup_column(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_markup_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_markup_column(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_pixbuf_column(Xen icon_view, Xen column)
{
  #define H_gtk_icon_view_set_pixbuf_column "void gtk_icon_view_set_pixbuf_column(GtkIconView* icon_view, \
gint column)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_pixbuf_column", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column), column, 2, "gtk_icon_view_set_pixbuf_column", "gint");
  gtk_icon_view_set_pixbuf_column(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_pixbuf_column(Xen icon_view)
{
  #define H_gtk_icon_view_get_pixbuf_column "gint gtk_icon_view_get_pixbuf_column(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_pixbuf_column", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_pixbuf_column(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_get_path_at_pos(Xen icon_view, Xen x, Xen y)
{
  #define H_gtk_icon_view_get_path_at_pos "GtkTreePath* gtk_icon_view_get_path_at_pos(GtkIconView* icon_view, \
gint x, gint y)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_path_at_pos", "GtkIconView*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_icon_view_get_path_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_icon_view_get_path_at_pos", "gint");
  return(C_to_Xen_GtkTreePath_(gtk_icon_view_get_path_at_pos(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(x), Xen_to_C_gint(y))));
}

static Xen gxg_gtk_icon_view_selected_foreach(Xen icon_view, Xen func, Xen func_info)
{
  #define H_gtk_icon_view_selected_foreach "void gtk_icon_view_selected_foreach(GtkIconView* icon_view, \
GtkIconViewForeachFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_selected_foreach", "GtkIconView*");
  Xen_check_type(Xen_is_GtkIconViewForeachFunc(func), func, 2, "gtk_icon_view_selected_foreach", "GtkIconViewForeachFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_icon_view_selected_foreach", "lambda_data");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    gtk_icon_view_selected_foreach(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkIconViewForeachFunc(func), Xen_to_C_lambda_data(func_info));
    return(Xen_false);
   }
}

static Xen gxg_gtk_icon_view_set_selection_mode(Xen icon_view, Xen mode)
{
  #define H_gtk_icon_view_set_selection_mode "void gtk_icon_view_set_selection_mode(GtkIconView* icon_view, \
GtkSelectionMode mode)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_selection_mode", "GtkIconView*");
  Xen_check_type(Xen_is_GtkSelectionMode(mode), mode, 2, "gtk_icon_view_set_selection_mode", "GtkSelectionMode");
  gtk_icon_view_set_selection_mode(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkSelectionMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_selection_mode(Xen icon_view)
{
  #define H_gtk_icon_view_get_selection_mode "GtkSelectionMode gtk_icon_view_get_selection_mode(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_selection_mode", "GtkIconView*");
  return(C_to_Xen_GtkSelectionMode(gtk_icon_view_get_selection_mode(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_select_path(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_select_path "void gtk_icon_view_select_path(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_select_path", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_select_path", "GtkTreePath*");
  gtk_icon_view_select_path(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unselect_path(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_unselect_path "void gtk_icon_view_unselect_path(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unselect_path", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_unselect_path", "GtkTreePath*");
  gtk_icon_view_unselect_path(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_path_is_selected(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_path_is_selected "gboolean gtk_icon_view_path_is_selected(GtkIconView* icon_view, \
GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_path_is_selected", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_path_is_selected", "GtkTreePath*");
  return(C_to_Xen_gboolean(gtk_icon_view_path_is_selected(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path))));
}

static Xen gxg_gtk_icon_view_get_selected_items(Xen icon_view)
{
  #define H_gtk_icon_view_get_selected_items "GList* gtk_icon_view_get_selected_items(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_selected_items", "GtkIconView*");
  return(C_to_Xen_GList_(gtk_icon_view_get_selected_items(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_select_all(Xen icon_view)
{
  #define H_gtk_icon_view_select_all "void gtk_icon_view_select_all(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_select_all", "GtkIconView*");
  gtk_icon_view_select_all(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unselect_all(Xen icon_view)
{
  #define H_gtk_icon_view_unselect_all "void gtk_icon_view_unselect_all(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unselect_all", "GtkIconView*");
  gtk_icon_view_unselect_all(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_item_activated(Xen icon_view, Xen path)
{
  #define H_gtk_icon_view_item_activated "void gtk_icon_view_item_activated(GtkIconView* icon_view, GtkTreePath* path)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_item_activated", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_item_activated", "GtkTreePath*");
  gtk_icon_view_item_activated(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_combo_new(void)
{
  #define H_gtk_cell_renderer_combo_new "GtkCellRenderer* gtk_cell_renderer_combo_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_combo_new()));
}

static Xen gxg_gtk_cell_renderer_progress_new(void)
{
  #define H_gtk_cell_renderer_progress_new "GtkCellRenderer* gtk_cell_renderer_progress_new( void)"
  return(C_to_Xen_GtkCellRenderer_(gtk_cell_renderer_progress_new()));
}

static Xen gxg_gtk_combo_box_set_row_separator_func(Xen combo_box, Xen func, Xen func_info, Xen destroy)
{
  #define H_gtk_combo_box_set_row_separator_func "void gtk_combo_box_set_row_separator_func(GtkComboBox* combo_box, \
GtkTreeViewRowSeparatorFunc func, lambda_data func_info, GtkDestroyNotify destroy)"
  Xen_check_type(Xen_is_GtkComboBox_(combo_box), combo_box, 1, "gtk_combo_box_set_row_separator_func", "GtkComboBox*");
  Xen_check_type(Xen_is_GtkTreeViewRowSeparatorFunc(func), func, 2, "gtk_combo_box_set_row_separator_func", "GtkTreeViewRowSeparatorFunc");
  Xen_check_type(Xen_is_lambda_data(func_info), func_info, 3, "gtk_combo_box_set_row_separator_func", "lambda_data");
  Xen_check_type(Xen_is_GtkDestroyNotify(destroy), destroy, 4, "gtk_combo_box_set_row_separator_func", "GtkDestroyNotify");
  {
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    Xen_list_set(gxg_ptr, 3, destroy);
    gtk_combo_box_set_row_separator_func(Xen_to_C_GtkComboBox_(combo_box), Xen_to_C_GtkTreeViewRowSeparatorFunc(func), Xen_to_C_lambda_data(func_info), 
                                     Xen_to_C_GtkDestroyNotify(destroy));
    return(Xen_false);
   }
}

static Xen gxg_gtk_label_set_ellipsize(Xen label, Xen mode)
{
  #define H_gtk_label_set_ellipsize "void gtk_label_set_ellipsize(GtkLabel* label, PangoEllipsizeMode mode)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_ellipsize", "GtkLabel*");
  Xen_check_type(Xen_is_PangoEllipsizeMode(mode), mode, 2, "gtk_label_set_ellipsize", "PangoEllipsizeMode");
  gtk_label_set_ellipsize(Xen_to_C_GtkLabel_(label), Xen_to_C_PangoEllipsizeMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_ellipsize(Xen label)
{
  #define H_gtk_label_get_ellipsize "PangoEllipsizeMode gtk_label_get_ellipsize(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_ellipsize", "GtkLabel*");
  return(C_to_Xen_PangoEllipsizeMode(gtk_label_get_ellipsize(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_pango_attr_fallback_new(Xen enable_fallback)
{
  #define H_pango_attr_fallback_new "PangoAttribute* pango_attr_fallback_new(gboolean enable_fallback)"
  Xen_check_type(Xen_is_gboolean(enable_fallback), enable_fallback, 1, "pango_attr_fallback_new", "gboolean");
  return(C_to_Xen_PangoAttribute_(pango_attr_fallback_new(Xen_to_C_gboolean(enable_fallback))));
}

static Xen gxg_pango_attr_letter_spacing_new(Xen letter_spacing)
{
  #define H_pango_attr_letter_spacing_new "PangoAttribute* pango_attr_letter_spacing_new(int letter_spacing)"
  Xen_check_type(Xen_is_int(letter_spacing), letter_spacing, 1, "pango_attr_letter_spacing_new", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_letter_spacing_new(Xen_to_C_int(letter_spacing))));
}

static Xen gxg_pango_attr_list_filter(Xen list, Xen func, Xen data)
{
  #define H_pango_attr_list_filter "PangoAttrList* pango_attr_list_filter(PangoAttrList* list, PangoAttrFilterFunc func, \
gpointer data)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_filter", "PangoAttrList*");
  Xen_check_type(Xen_is_PangoAttrFilterFunc(func), func, 2, "pango_attr_list_filter", "PangoAttrFilterFunc");
  Xen_check_type(Xen_is_gpointer(data), data, 3, "pango_attr_list_filter", "gpointer");
  return(C_to_Xen_PangoAttrList_(pango_attr_list_filter(Xen_to_C_PangoAttrList_(list), Xen_to_C_PangoAttrFilterFunc(func), 
                                                        Xen_to_C_gpointer(data))));
}

static Xen gxg_pango_attr_iterator_get_attrs(Xen iterator)
{
  #define H_pango_attr_iterator_get_attrs "GSList* pango_attr_iterator_get_attrs(PangoAttrIterator* iterator)"
  Xen_check_type(Xen_is_PangoAttrIterator_(iterator), iterator, 1, "pango_attr_iterator_get_attrs", "PangoAttrIterator*");
  return(C_to_Xen_GSList_(pango_attr_iterator_get_attrs(Xen_to_C_PangoAttrIterator_(iterator))));
}

static Xen gxg_pango_font_metrics_get_underline_position(Xen metrics)
{
  #define H_pango_font_metrics_get_underline_position "int pango_font_metrics_get_underline_position(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_underline_position", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_underline_position(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_underline_thickness(Xen metrics)
{
  #define H_pango_font_metrics_get_underline_thickness "int pango_font_metrics_get_underline_thickness(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_underline_thickness", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_underline_thickness(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_strikethrough_position(Xen metrics)
{
  #define H_pango_font_metrics_get_strikethrough_position "int pango_font_metrics_get_strikethrough_position(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_strikethrough_position", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_strikethrough_position(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_metrics_get_strikethrough_thickness(Xen metrics)
{
  #define H_pango_font_metrics_get_strikethrough_thickness "int pango_font_metrics_get_strikethrough_thickness(PangoFontMetrics* metrics)"
  Xen_check_type(Xen_is_PangoFontMetrics_(metrics), metrics, 1, "pango_font_metrics_get_strikethrough_thickness", "PangoFontMetrics*");
  return(C_to_Xen_int(pango_font_metrics_get_strikethrough_thickness(Xen_to_C_PangoFontMetrics_(metrics))));
}

static Xen gxg_pango_font_family_is_monospace(Xen family)
{
  #define H_pango_font_family_is_monospace "gboolean pango_font_family_is_monospace(PangoFontFamily* family)"
  Xen_check_type(Xen_is_PangoFontFamily_(family), family, 1, "pango_font_family_is_monospace", "PangoFontFamily*");
  return(C_to_Xen_gboolean(pango_font_family_is_monospace(Xen_to_C_PangoFontFamily_(family))));
}

static Xen gxg_pango_font_face_list_sizes(Xen face, Xen ignore_sizes, Xen ignore_n_sizes)
{
  #define H_pango_font_face_list_sizes "void pango_font_face_list_sizes(PangoFontFace* face, int** [sizes], \
int* [n_sizes])"
  int* ref_sizes = NULL;
  int ref_n_sizes;
  Xen_check_type(Xen_is_PangoFontFace_(face), face, 1, "pango_font_face_list_sizes", "PangoFontFace*");
  pango_font_face_list_sizes(Xen_to_C_PangoFontFace_(face), &ref_sizes, &ref_n_sizes);
  return(Xen_list_2(C_to_Xen_int_(ref_sizes), C_to_Xen_int(ref_n_sizes)));
}

static Xen gxg_pango_layout_set_auto_dir(Xen layout, Xen auto_dir)
{
  #define H_pango_layout_set_auto_dir "void pango_layout_set_auto_dir(PangoLayout* layout, gboolean auto_dir)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_set_auto_dir", "PangoLayout*");
  Xen_check_type(Xen_is_gboolean(auto_dir), auto_dir, 2, "pango_layout_set_auto_dir", "gboolean");
  pango_layout_set_auto_dir(Xen_to_C_PangoLayout_(layout), Xen_to_C_gboolean(auto_dir));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_auto_dir(Xen layout)
{
  #define H_pango_layout_get_auto_dir "gboolean pango_layout_get_auto_dir(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_auto_dir", "PangoLayout*");
  return(C_to_Xen_gboolean(pango_layout_get_auto_dir(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_pango_script_for_unichar(Xen ch)
{
  #define H_pango_script_for_unichar "PangoScript pango_script_for_unichar(gunichar ch)"
  Xen_check_type(Xen_is_gunichar(ch), ch, 1, "pango_script_for_unichar", "gunichar");
  return(C_to_Xen_PangoScript(pango_script_for_unichar(Xen_to_C_gunichar(ch))));
}

static Xen gxg_pango_script_iter_new(Xen text, Xen length)
{
  #define H_pango_script_iter_new "PangoScriptIter* pango_script_iter_new(char* text, int length)"
  Xen_check_type(Xen_is_char_(text), text, 1, "pango_script_iter_new", "char*");
  Xen_check_type(Xen_is_int(length), length, 2, "pango_script_iter_new", "int");
  return(C_to_Xen_PangoScriptIter_(pango_script_iter_new(Xen_to_C_char_(text), Xen_to_C_int(length))));
}

static Xen gxg_pango_script_iter_get_range(Xen iter, Xen ignore_start, Xen ignore_end, Xen ignore_script)
{
  #define H_pango_script_iter_get_range "void pango_script_iter_get_range(PangoScriptIter* iter, char** [start], \
char** [end], PangoScript* [script])"
  char* ref_start = NULL;
  char* ref_end = NULL;
  PangoScript ref_script;
  Xen_check_type(Xen_is_PangoScriptIter_(iter), iter, 1, "pango_script_iter_get_range", "PangoScriptIter*");
  pango_script_iter_get_range(Xen_to_C_PangoScriptIter_(iter), (const char**)&ref_start, (const char**)&ref_end, &ref_script);
  return(Xen_list_3(C_to_Xen_char_(ref_start), C_to_Xen_char_(ref_end), C_to_Xen_PangoScript(ref_script)));
}

static Xen gxg_pango_script_iter_next(Xen iter)
{
  #define H_pango_script_iter_next "gboolean pango_script_iter_next(PangoScriptIter* iter)"
  Xen_check_type(Xen_is_PangoScriptIter_(iter), iter, 1, "pango_script_iter_next", "PangoScriptIter*");
  return(C_to_Xen_gboolean(pango_script_iter_next(Xen_to_C_PangoScriptIter_(iter))));
}

static Xen gxg_pango_script_iter_free(Xen iter)
{
  #define H_pango_script_iter_free "void pango_script_iter_free(PangoScriptIter* iter)"
  Xen_check_type(Xen_is_PangoScriptIter_(iter), iter, 1, "pango_script_iter_free", "PangoScriptIter*");
  pango_script_iter_free(Xen_to_C_PangoScriptIter_(iter));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_button_new_with_dialog(Xen dialog)
{
  #define H_gtk_file_chooser_button_new_with_dialog "GtkWidget* gtk_file_chooser_button_new_with_dialog(GtkWidget* dialog)"
  Xen_check_type(Xen_is_GtkWidget_(dialog), dialog, 1, "gtk_file_chooser_button_new_with_dialog", "GtkWidget*");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_button_new_with_dialog(Xen_to_C_GtkWidget_(dialog))));
}

static Xen gxg_gtk_file_chooser_button_get_title(Xen button)
{
  #define H_gtk_file_chooser_button_get_title "gchar* gtk_file_chooser_button_get_title(GtkFileChooserButton* button)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_get_title", "GtkFileChooserButton*");
  return(C_to_Xen_gchar_(gtk_file_chooser_button_get_title(Xen_to_C_GtkFileChooserButton_(button))));
}

static Xen gxg_gtk_file_chooser_button_set_title(Xen button, Xen title)
{
  #define H_gtk_file_chooser_button_set_title "void gtk_file_chooser_button_set_title(GtkFileChooserButton* button, \
gchar* title)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_set_title", "GtkFileChooserButton*");
  Xen_check_type(Xen_is_gchar_(title), title, 2, "gtk_file_chooser_button_set_title", "gchar*");
  gtk_file_chooser_button_set_title(Xen_to_C_GtkFileChooserButton_(button), Xen_to_C_gchar_(title));
  return(Xen_false);
}

static Xen gxg_gdk_drag_drop_succeeded(Xen context)
{
  #define H_gdk_drag_drop_succeeded "gboolean gdk_drag_drop_succeeded(GdkDragContext* context)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gdk_drag_drop_succeeded", "GdkDragContext*");
  return(C_to_Xen_gboolean(gdk_drag_drop_succeeded(Xen_to_C_GdkDragContext_(context))));
}

static Xen gxg_gtk_entry_layout_index_to_text_index(Xen entry, Xen layout_index)
{
  #define H_gtk_entry_layout_index_to_text_index "gint gtk_entry_layout_index_to_text_index(GtkEntry* entry, \
gint layout_index)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_layout_index_to_text_index", "GtkEntry*");
  Xen_check_type(Xen_is_gint(layout_index), layout_index, 2, "gtk_entry_layout_index_to_text_index", "gint");
  return(C_to_Xen_gint(gtk_entry_layout_index_to_text_index(Xen_to_C_GtkEntry_(entry), Xen_to_C_gint(layout_index))));
}

static Xen gxg_gtk_entry_text_index_to_layout_index(Xen entry, Xen text_index)
{
  #define H_gtk_entry_text_index_to_layout_index "gint gtk_entry_text_index_to_layout_index(GtkEntry* entry, \
gint text_index)"
  Xen_check_type(Xen_is_GtkEntry_(entry), entry, 1, "gtk_entry_text_index_to_layout_index", "GtkEntry*");
  Xen_check_type(Xen_is_gint(text_index), text_index, 2, "gtk_entry_text_index_to_layout_index", "gint");
  return(C_to_Xen_gint(gtk_entry_text_index_to_layout_index(Xen_to_C_GtkEntry_(entry), Xen_to_C_gint(text_index))));
}

static Xen gxg_gtk_file_chooser_set_show_hidden(Xen chooser, Xen show_hidden)
{
  #define H_gtk_file_chooser_set_show_hidden "void gtk_file_chooser_set_show_hidden(GtkFileChooser* chooser, \
gboolean show_hidden)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_show_hidden", "GtkFileChooser*");
  Xen_check_type(Xen_is_gboolean(show_hidden), show_hidden, 2, "gtk_file_chooser_set_show_hidden", "gboolean");
  gtk_file_chooser_set_show_hidden(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gboolean(show_hidden));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_show_hidden(Xen chooser)
{
  #define H_gtk_file_chooser_get_show_hidden "gboolean gtk_file_chooser_get_show_hidden(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_show_hidden", "GtkFileChooser*");
  return(C_to_Xen_gboolean(gtk_file_chooser_get_show_hidden(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_tree_view_set_hover_expand(Xen tree_view, Xen expand)
{
  #define H_gtk_tree_view_set_hover_expand "void gtk_tree_view_set_hover_expand(GtkTreeView* tree_view, \
gboolean expand)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_set_hover_expand", "GtkTreeView*");
  Xen_check_type(Xen_is_gboolean(expand), expand, 2, "gtk_tree_view_set_hover_expand", "gboolean");
  gtk_tree_view_set_hover_expand(Xen_to_C_GtkTreeView_(tree_view), Xen_to_C_gboolean(expand));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_hover_expand(Xen tree_view)
{
  #define H_gtk_tree_view_get_hover_expand "gboolean gtk_tree_view_get_hover_expand(GtkTreeView* tree_view)"
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_hover_expand", "GtkTreeView*");
  return(C_to_Xen_gboolean(gtk_tree_view_get_hover_expand(Xen_to_C_GtkTreeView_(tree_view))));
}

static Xen gxg_gtk_tool_item_rebuild_menu(Xen tool_item)
{
  #define H_gtk_tool_item_rebuild_menu "void gtk_tool_item_rebuild_menu(GtkToolItem* tool_item)"
  Xen_check_type(Xen_is_GtkToolItem_(tool_item), tool_item, 1, "gtk_tool_item_rebuild_menu", "GtkToolItem*");
  gtk_tool_item_rebuild_menu(Xen_to_C_GtkToolItem_(tool_item));
  return(Xen_false);
}

static Xen gxg_gtk_menu_tool_button_new(Xen icon_widget, Xen label)
{
  #define H_gtk_menu_tool_button_new "GtkToolItem* gtk_menu_tool_button_new(GtkWidget* icon_widget, gchar* label)"
  Xen_check_type(Xen_is_GtkWidget_(icon_widget) || Xen_is_false(icon_widget), icon_widget, 1, "gtk_menu_tool_button_new", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(label), label, 2, "gtk_menu_tool_button_new", "gchar*");
  return(C_to_Xen_GtkToolItem_(gtk_menu_tool_button_new(Xen_to_C_GtkWidget_(icon_widget), Xen_to_C_gchar_(label))));
}

static Xen gxg_gtk_menu_tool_button_set_menu(Xen button, Xen menu)
{
  #define H_gtk_menu_tool_button_set_menu "void gtk_menu_tool_button_set_menu(GtkMenuToolButton* button, \
GtkWidget* menu)"
  Xen_check_type(Xen_is_GtkMenuToolButton_(button), button, 1, "gtk_menu_tool_button_set_menu", "GtkMenuToolButton*");
  Xen_check_type(Xen_is_GtkWidget_(menu), menu, 2, "gtk_menu_tool_button_set_menu", "GtkWidget*");
  gtk_menu_tool_button_set_menu(Xen_to_C_GtkMenuToolButton_(button), Xen_to_C_GtkWidget_(menu));
  return(Xen_false);
}

static Xen gxg_gtk_menu_tool_button_get_menu(Xen button)
{
  #define H_gtk_menu_tool_button_get_menu "GtkWidget* gtk_menu_tool_button_get_menu(GtkMenuToolButton* button)"
  Xen_check_type(Xen_is_GtkMenuToolButton_(button), button, 1, "gtk_menu_tool_button_get_menu", "GtkMenuToolButton*");
  return(C_to_Xen_GtkWidget_(gtk_menu_tool_button_get_menu(Xen_to_C_GtkMenuToolButton_(button))));
}

static Xen gxg_gtk_about_dialog_get_logo_icon_name(Xen about)
{
  #define H_gtk_about_dialog_get_logo_icon_name "gchar* gtk_about_dialog_get_logo_icon_name(GtkAboutDialog* about)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_get_logo_icon_name", "GtkAboutDialog*");
  return(C_to_Xen_gchar_(gtk_about_dialog_get_logo_icon_name(Xen_to_C_GtkAboutDialog_(about))));
}

static Xen gxg_gtk_about_dialog_set_logo_icon_name(Xen about, Xen icon_name)
{
  #define H_gtk_about_dialog_set_logo_icon_name "void gtk_about_dialog_set_logo_icon_name(GtkAboutDialog* about, \
gchar* icon_name)"
  Xen_check_type(Xen_is_GtkAboutDialog_(about), about, 1, "gtk_about_dialog_set_logo_icon_name", "GtkAboutDialog*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_about_dialog_set_logo_icon_name", "gchar*");
  gtk_about_dialog_set_logo_icon_name(Xen_to_C_GtkAboutDialog_(about), Xen_to_C_gchar_(icon_name));
  return(Xen_false);
}

static Xen gxg_gtk_accelerator_get_label(Xen accelerator_key, Xen accelerator_mods)
{
  #define H_gtk_accelerator_get_label "gchar* gtk_accelerator_get_label(guint accelerator_key, GdkModifierType accelerator_mods)"
  Xen_check_type(Xen_is_guint(accelerator_key), accelerator_key, 1, "gtk_accelerator_get_label", "guint");
  Xen_check_type(Xen_is_GdkModifierType(accelerator_mods), accelerator_mods, 2, "gtk_accelerator_get_label", "GdkModifierType");
  {
   gchar* result;
   Xen rtn;
   result = gtk_accelerator_get_label(Xen_to_C_guint(accelerator_key), Xen_to_C_GdkModifierType(accelerator_mods));
   rtn = C_to_Xen_gchar_(result);
   g_free(result);
   return(rtn);
  }
}

static Xen gxg_gtk_drag_dest_add_image_targets(Xen widget)
{
  #define H_gtk_drag_dest_add_image_targets "void gtk_drag_dest_add_image_targets(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_dest_add_image_targets", "GtkWidget*");
  gtk_drag_dest_add_image_targets(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_dest_add_uri_targets(Xen widget)
{
  #define H_gtk_drag_dest_add_uri_targets "void gtk_drag_dest_add_uri_targets(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_dest_add_uri_targets", "GtkWidget*");
  gtk_drag_dest_add_uri_targets(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_source_add_image_targets(Xen widget)
{
  #define H_gtk_drag_source_add_image_targets "void gtk_drag_source_add_image_targets(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_source_add_image_targets", "GtkWidget*");
  gtk_drag_source_add_image_targets(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_drag_source_add_uri_targets(Xen widget)
{
  #define H_gtk_drag_source_add_uri_targets "void gtk_drag_source_add_uri_targets(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_source_add_uri_targets", "GtkWidget*");
  gtk_drag_source_add_uri_targets(Xen_to_C_GtkWidget_(widget));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_button_get_width_chars(Xen button)
{
  #define H_gtk_file_chooser_button_get_width_chars "gint gtk_file_chooser_button_get_width_chars(GtkFileChooserButton* button)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_get_width_chars", "GtkFileChooserButton*");
  return(C_to_Xen_gint(gtk_file_chooser_button_get_width_chars(Xen_to_C_GtkFileChooserButton_(button))));
}

static Xen gxg_gtk_file_chooser_button_set_width_chars(Xen button, Xen n_chars)
{
  #define H_gtk_file_chooser_button_set_width_chars "void gtk_file_chooser_button_set_width_chars(GtkFileChooserButton* button, \
gint n_chars)"
  Xen_check_type(Xen_is_GtkFileChooserButton_(button), button, 1, "gtk_file_chooser_button_set_width_chars", "GtkFileChooserButton*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_file_chooser_button_set_width_chars", "gint");
  gtk_file_chooser_button_set_width_chars(Xen_to_C_GtkFileChooserButton_(button), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_image_set_pixel_size(Xen image, Xen pixel_size)
{
  #define H_gtk_image_set_pixel_size "void gtk_image_set_pixel_size(GtkImage* image, gint pixel_size)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_set_pixel_size", "GtkImage*");
  Xen_check_type(Xen_is_gint(pixel_size), pixel_size, 2, "gtk_image_set_pixel_size", "gint");
  gtk_image_set_pixel_size(Xen_to_C_GtkImage_(image), Xen_to_C_gint(pixel_size));
  return(Xen_false);
}

static Xen gxg_gtk_image_get_pixel_size(Xen image)
{
  #define H_gtk_image_get_pixel_size "gint gtk_image_get_pixel_size(GtkImage* image)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_get_pixel_size", "GtkImage*");
  return(C_to_Xen_gint(gtk_image_get_pixel_size(Xen_to_C_GtkImage_(image))));
}

static Xen gxg_gtk_label_set_width_chars(Xen label, Xen n_chars)
{
  #define H_gtk_label_set_width_chars "void gtk_label_set_width_chars(GtkLabel* label, gint n_chars)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_width_chars", "GtkLabel*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_label_set_width_chars", "gint");
  gtk_label_set_width_chars(Xen_to_C_GtkLabel_(label), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_width_chars(Xen label)
{
  #define H_gtk_label_get_width_chars "gint gtk_label_get_width_chars(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_width_chars", "GtkLabel*");
  return(C_to_Xen_gint(gtk_label_get_width_chars(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_text_buffer_backspace(Xen buffer, Xen iter, Xen interactive, Xen default_editable)
{
  #define H_gtk_text_buffer_backspace "gboolean gtk_text_buffer_backspace(GtkTextBuffer* buffer, GtkTextIter* iter, \
gboolean interactive, gboolean default_editable)"
  Xen_check_type(Xen_is_GtkTextBuffer_(buffer), buffer, 1, "gtk_text_buffer_backspace", "GtkTextBuffer*");
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 2, "gtk_text_buffer_backspace", "GtkTextIter*");
  Xen_check_type(Xen_is_gboolean(interactive), interactive, 3, "gtk_text_buffer_backspace", "gboolean");
  Xen_check_type(Xen_is_gboolean(default_editable), default_editable, 4, "gtk_text_buffer_backspace", "gboolean");
  return(C_to_Xen_gboolean(gtk_text_buffer_backspace(Xen_to_C_GtkTextBuffer_(buffer), Xen_to_C_GtkTextIter_(iter), Xen_to_C_gboolean(interactive), 
                                                     Xen_to_C_gboolean(default_editable))));
}

static Xen gxg_gtk_file_filter_add_pixbuf_formats(Xen filter)
{
  #define H_gtk_file_filter_add_pixbuf_formats "void gtk_file_filter_add_pixbuf_formats(GtkFileFilter* filter)"
  Xen_check_type(Xen_is_GtkFileFilter_(filter), filter, 1, "gtk_file_filter_add_pixbuf_formats", "GtkFileFilter*");
  gtk_file_filter_add_pixbuf_formats(Xen_to_C_GtkFileFilter_(filter));
  return(Xen_false);
}

static Xen gxg_gtk_label_set_single_line_mode(Xen label, Xen single_line_mode)
{
  #define H_gtk_label_set_single_line_mode "void gtk_label_set_single_line_mode(GtkLabel* label, gboolean single_line_mode)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_single_line_mode", "GtkLabel*");
  Xen_check_type(Xen_is_gboolean(single_line_mode), single_line_mode, 2, "gtk_label_set_single_line_mode", "gboolean");
  gtk_label_set_single_line_mode(Xen_to_C_GtkLabel_(label), Xen_to_C_gboolean(single_line_mode));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_single_line_mode(Xen label)
{
  #define H_gtk_label_get_single_line_mode "gboolean gtk_label_get_single_line_mode(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_single_line_mode", "GtkLabel*");
  return(C_to_Xen_gboolean(gtk_label_get_single_line_mode(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_progress_bar_set_ellipsize(Xen pbar, Xen mode)
{
  #define H_gtk_progress_bar_set_ellipsize "void gtk_progress_bar_set_ellipsize(GtkProgressBar* pbar, \
PangoEllipsizeMode mode)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_set_ellipsize", "GtkProgressBar*");
  Xen_check_type(Xen_is_PangoEllipsizeMode(mode), mode, 2, "gtk_progress_bar_set_ellipsize", "PangoEllipsizeMode");
  gtk_progress_bar_set_ellipsize(Xen_to_C_GtkProgressBar_(pbar), Xen_to_C_PangoEllipsizeMode(mode));
  return(Xen_false);
}

static Xen gxg_gtk_progress_bar_get_ellipsize(Xen pbar)
{
  #define H_gtk_progress_bar_get_ellipsize "PangoEllipsizeMode gtk_progress_bar_get_ellipsize(GtkProgressBar* pbar)"
  Xen_check_type(Xen_is_GtkProgressBar_(pbar), pbar, 1, "gtk_progress_bar_get_ellipsize", "GtkProgressBar*");
  return(C_to_Xen_PangoEllipsizeMode(gtk_progress_bar_get_ellipsize(Xen_to_C_GtkProgressBar_(pbar))));
}

static Xen gxg_gtk_selection_data_targets_include_image(Xen selection_data, Xen writable)
{
  #define H_gtk_selection_data_targets_include_image "gboolean gtk_selection_data_targets_include_image(GtkSelectionData* selection_data, \
gboolean writable)"
  Xen_check_type(Xen_is_GtkSelectionData_(selection_data), selection_data, 1, "gtk_selection_data_targets_include_image", "GtkSelectionData*");
  Xen_check_type(Xen_is_gboolean(writable), writable, 2, "gtk_selection_data_targets_include_image", "gboolean");
  return(C_to_Xen_gboolean(gtk_selection_data_targets_include_image(Xen_to_C_GtkSelectionData_(selection_data), Xen_to_C_gboolean(writable))));
}

static Xen gxg_pango_attr_underline_color_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_underline_color_new "PangoAttribute* pango_attr_underline_color_new(guint16 red, \
guint16 green, guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_underline_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_underline_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_underline_color_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_underline_color_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_attr_strikethrough_color_new(Xen red, Xen green, Xen blue)
{
  #define H_pango_attr_strikethrough_color_new "PangoAttribute* pango_attr_strikethrough_color_new(guint16 red, \
guint16 green, guint16 blue)"
  Xen_check_type(Xen_is_guint16(red), red, 1, "pango_attr_strikethrough_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(green), green, 2, "pango_attr_strikethrough_color_new", "guint16");
  Xen_check_type(Xen_is_guint16(blue), blue, 3, "pango_attr_strikethrough_color_new", "guint16");
  return(C_to_Xen_PangoAttribute_(pango_attr_strikethrough_color_new(Xen_to_C_guint16(red), Xen_to_C_guint16(green), Xen_to_C_guint16(blue))));
}

static Xen gxg_pango_renderer_draw_layout(Xen renderer, Xen layout, Xen x, Xen y)
{
  #define H_pango_renderer_draw_layout "void pango_renderer_draw_layout(PangoRenderer* renderer, PangoLayout* layout, \
int x, int y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_layout", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 2, "pango_renderer_draw_layout", "PangoLayout*");
  Xen_check_type(Xen_is_int(x), x, 3, "pango_renderer_draw_layout", "int");
  Xen_check_type(Xen_is_int(y), y, 4, "pango_renderer_draw_layout", "int");
  pango_renderer_draw_layout(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoLayout_(layout), Xen_to_C_int(x), Xen_to_C_int(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_layout_line(Xen renderer, Xen line, Xen x, Xen y)
{
  #define H_pango_renderer_draw_layout_line "void pango_renderer_draw_layout_line(PangoRenderer* renderer, \
PangoLayoutLine* line, int x, int y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_layout_line", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 2, "pango_renderer_draw_layout_line", "PangoLayoutLine*");
  Xen_check_type(Xen_is_int(x), x, 3, "pango_renderer_draw_layout_line", "int");
  Xen_check_type(Xen_is_int(y), y, 4, "pango_renderer_draw_layout_line", "int");
  pango_renderer_draw_layout_line(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoLayoutLine_(line), Xen_to_C_int(x), Xen_to_C_int(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_glyphs(Xen renderer, Xen font, Xen glyphs, Xen x, Xen y)
{
  #define H_pango_renderer_draw_glyphs "void pango_renderer_draw_glyphs(PangoRenderer* renderer, PangoFont* font, \
PangoGlyphString* glyphs, int x, int y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_glyphs", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_renderer_draw_glyphs", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyphString_(glyphs), glyphs, 3, "pango_renderer_draw_glyphs", "PangoGlyphString*");
  Xen_check_type(Xen_is_int(x), x, 4, "pango_renderer_draw_glyphs", "int");
  Xen_check_type(Xen_is_int(y), y, 5, "pango_renderer_draw_glyphs", "int");
  pango_renderer_draw_glyphs(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyphString_(glyphs), 
                             Xen_to_C_int(x), Xen_to_C_int(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_rectangle(Xen renderer, Xen part, Xen x, Xen y, Xen width, Xen height)
{
  #define H_pango_renderer_draw_rectangle "void pango_renderer_draw_rectangle(PangoRenderer* renderer, \
PangoRenderPart part, int x, int y, int width, int height)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_rectangle", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_draw_rectangle", "PangoRenderPart");
  Xen_check_type(Xen_is_int(x), x, 3, "pango_renderer_draw_rectangle", "int");
  Xen_check_type(Xen_is_int(y), y, 4, "pango_renderer_draw_rectangle", "int");
  Xen_check_type(Xen_is_int(width), width, 5, "pango_renderer_draw_rectangle", "int");
  Xen_check_type(Xen_is_int(height), height, 6, "pango_renderer_draw_rectangle", "int");
  pango_renderer_draw_rectangle(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part), Xen_to_C_int(x), Xen_to_C_int(y), 
                                Xen_to_C_int(width), Xen_to_C_int(height));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_error_underline(Xen renderer, Xen x, Xen y, Xen width, Xen height)
{
  #define H_pango_renderer_draw_error_underline "void pango_renderer_draw_error_underline(PangoRenderer* renderer, \
int x, int y, int width, int height)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_error_underline", "PangoRenderer*");
  Xen_check_type(Xen_is_int(x), x, 2, "pango_renderer_draw_error_underline", "int");
  Xen_check_type(Xen_is_int(y), y, 3, "pango_renderer_draw_error_underline", "int");
  Xen_check_type(Xen_is_int(width), width, 4, "pango_renderer_draw_error_underline", "int");
  Xen_check_type(Xen_is_int(height), height, 5, "pango_renderer_draw_error_underline", "int");
  pango_renderer_draw_error_underline(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_int(x), Xen_to_C_int(y), Xen_to_C_int(width), 
                                      Xen_to_C_int(height));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_trapezoid(Xen arglist)
{
  #define H_pango_renderer_draw_trapezoid "void pango_renderer_draw_trapezoid(PangoRenderer* renderer, \
PangoRenderPart part, double y1, double x11, double x21, double y2, double x12, double x22)"
  Xen renderer, part, y1, x11, x21, y2, x12, x22;
  renderer = Xen_list_ref(arglist, 0);
  part = Xen_list_ref(arglist, 1);
  y1 = Xen_list_ref(arglist, 2);
  x11 = Xen_list_ref(arglist, 3);
  x21 = Xen_list_ref(arglist, 4);
  y2 = Xen_list_ref(arglist, 5);
  x12 = Xen_list_ref(arglist, 6);
  x22 = Xen_list_ref(arglist, 7);
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_trapezoid", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_draw_trapezoid", "PangoRenderPart");
  Xen_check_type(Xen_is_double(y1), y1, 3, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x11), x11, 4, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x21), x21, 5, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(y2), y2, 6, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x12), x12, 7, "pango_renderer_draw_trapezoid", "double");
  Xen_check_type(Xen_is_double(x22), x22, 8, "pango_renderer_draw_trapezoid", "double");
  pango_renderer_draw_trapezoid(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part), Xen_to_C_double(y1), Xen_to_C_double(x11), 
                                Xen_to_C_double(x21), Xen_to_C_double(y2), Xen_to_C_double(x12), Xen_to_C_double(x22));
  return(Xen_false);
}

static Xen gxg_pango_renderer_draw_glyph(Xen renderer, Xen font, Xen glyph, Xen x, Xen y)
{
  #define H_pango_renderer_draw_glyph "void pango_renderer_draw_glyph(PangoRenderer* renderer, PangoFont* font, \
PangoGlyph glyph, double x, double y)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_draw_glyph", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoFont_(font), font, 2, "pango_renderer_draw_glyph", "PangoFont*");
  Xen_check_type(Xen_is_PangoGlyph(glyph), glyph, 3, "pango_renderer_draw_glyph", "PangoGlyph");
  Xen_check_type(Xen_is_double(x), x, 4, "pango_renderer_draw_glyph", "double");
  Xen_check_type(Xen_is_double(y), y, 5, "pango_renderer_draw_glyph", "double");
  pango_renderer_draw_glyph(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoFont_(font), Xen_to_C_PangoGlyph(glyph), Xen_to_C_double(x), 
                            Xen_to_C_double(y));
  return(Xen_false);
}

static Xen gxg_pango_renderer_activate(Xen renderer)
{
  #define H_pango_renderer_activate "void pango_renderer_activate(PangoRenderer* renderer)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_activate", "PangoRenderer*");
  pango_renderer_activate(Xen_to_C_PangoRenderer_(renderer));
  return(Xen_false);
}

static Xen gxg_pango_renderer_deactivate(Xen renderer)
{
  #define H_pango_renderer_deactivate "void pango_renderer_deactivate(PangoRenderer* renderer)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_deactivate", "PangoRenderer*");
  pango_renderer_deactivate(Xen_to_C_PangoRenderer_(renderer));
  return(Xen_false);
}

static Xen gxg_pango_renderer_part_changed(Xen renderer, Xen part)
{
  #define H_pango_renderer_part_changed "void pango_renderer_part_changed(PangoRenderer* renderer, PangoRenderPart part)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_part_changed", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_part_changed", "PangoRenderPart");
  pango_renderer_part_changed(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part));
  return(Xen_false);
}

static Xen gxg_pango_renderer_set_color(Xen renderer, Xen part, Xen color)
{
  #define H_pango_renderer_set_color "void pango_renderer_set_color(PangoRenderer* renderer, PangoRenderPart part, \
PangoColor* color)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_set_color", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_set_color", "PangoRenderPart");
  Xen_check_type(Xen_is_PangoColor_(color), color, 3, "pango_renderer_set_color", "PangoColor*");
  pango_renderer_set_color(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part), Xen_to_C_PangoColor_(color));
  return(Xen_false);
}

static Xen gxg_pango_renderer_get_color(Xen renderer, Xen part)
{
  #define H_pango_renderer_get_color "PangoColor* pango_renderer_get_color(PangoRenderer* renderer, PangoRenderPart part)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_get_color", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoRenderPart(part), part, 2, "pango_renderer_get_color", "PangoRenderPart");
  return(C_to_Xen_PangoColor_(pango_renderer_get_color(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoRenderPart(part))));
}

static Xen gxg_pango_renderer_set_matrix(Xen renderer, Xen matrix)
{
  #define H_pango_renderer_set_matrix "void pango_renderer_set_matrix(PangoRenderer* renderer, PangoMatrix* matrix)"
  Xen_check_type(Xen_is_PangoRenderer_(renderer), renderer, 1, "pango_renderer_set_matrix", "PangoRenderer*");
  Xen_check_type(Xen_is_PangoMatrix_(matrix), matrix, 2, "pango_renderer_set_matrix", "PangoMatrix*");
  pango_renderer_set_matrix(Xen_to_C_PangoRenderer_(renderer), Xen_to_C_PangoMatrix_(matrix));
  return(Xen_false);
}

static Xen gxg_g_log_set_handler(Xen log_domain, Xen log_levels, Xen func, Xen func_info)
{
  #define H_g_log_set_handler "guint g_log_set_handler(gchar* log_domain, GLogLevelFlags log_levels, \
GLogFunc func, lambda_data func_info)"
  Xen_check_type(Xen_is_gchar_(log_domain), log_domain, 1, "g_log_set_handler", "gchar*");
  Xen_check_type(Xen_is_GLogLevelFlags(log_levels), log_levels, 2, "g_log_set_handler", "GLogLevelFlags");
  Xen_check_type(Xen_is_GLogFunc(func), func, 3, "g_log_set_handler", "GLogFunc");
  if (!Xen_is_bound(func_info)) func_info = Xen_false; 
  else Xen_check_type(Xen_is_lambda_data(func_info), func_info, 4, "g_log_set_handler", "lambda_data");
  {
    Xen result;
    Xen gxg_ptr = Xen_list_5(func, func_info, Xen_false, Xen_false, Xen_false);
    xm_protect(gxg_ptr);
    result = C_to_Xen_guint(g_log_set_handler(Xen_to_C_gchar_(log_domain), Xen_to_C_GLogLevelFlags(log_levels), Xen_to_C_GLogFunc(func), 
                                              Xen_to_C_lambda_data(func_info)));
    return(result);
   }
}

static Xen gxg_g_log_remove_handler(Xen log_domain, Xen handler_id)
{
  #define H_g_log_remove_handler "void g_log_remove_handler(gchar* log_domain, guint handler_id)"
  Xen_check_type(Xen_is_gchar_(log_domain), log_domain, 1, "g_log_remove_handler", "gchar*");
  Xen_check_type(Xen_is_guint(handler_id), handler_id, 2, "g_log_remove_handler", "guint");
  g_log_remove_handler(Xen_to_C_gchar_(log_domain), Xen_to_C_guint(handler_id));
  return(Xen_false);
}

static Xen gxg_gtk_cell_renderer_stop_editing(Xen cell, Xen canceled)
{
  #define H_gtk_cell_renderer_stop_editing "void gtk_cell_renderer_stop_editing(GtkCellRenderer* cell, \
gboolean canceled)"
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 1, "gtk_cell_renderer_stop_editing", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(canceled), canceled, 2, "gtk_cell_renderer_stop_editing", "gboolean");
  gtk_cell_renderer_stop_editing(Xen_to_C_GtkCellRenderer_(cell), Xen_to_C_gboolean(canceled));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_button_new(Xen title, Xen action)
{
  #define H_gtk_file_chooser_button_new "GtkWidget* gtk_file_chooser_button_new(gchar* title, GtkFileChooserAction action)"
  Xen_check_type(Xen_is_gchar_(title), title, 1, "gtk_file_chooser_button_new", "gchar*");
  Xen_check_type(Xen_is_GtkFileChooserAction(action), action, 2, "gtk_file_chooser_button_new", "GtkFileChooserAction");
  return(C_to_Xen_GtkWidget_(gtk_file_chooser_button_new((const gchar*)Xen_to_C_gchar_(title), Xen_to_C_GtkFileChooserAction(action))));
}

static Xen gxg_gtk_icon_view_set_columns(Xen icon_view, Xen columns)
{
  #define H_gtk_icon_view_set_columns "void gtk_icon_view_set_columns(GtkIconView* icon_view, gint columns)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_columns", "GtkIconView*");
  Xen_check_type(Xen_is_gint(columns), columns, 2, "gtk_icon_view_set_columns", "gint");
  gtk_icon_view_set_columns(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(columns));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_columns(Xen icon_view)
{
  #define H_gtk_icon_view_get_columns "gint gtk_icon_view_get_columns(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_columns", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_columns(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_item_width(Xen icon_view, Xen item_width)
{
  #define H_gtk_icon_view_set_item_width "void gtk_icon_view_set_item_width(GtkIconView* icon_view, gint item_width)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_item_width", "GtkIconView*");
  Xen_check_type(Xen_is_gint(item_width), item_width, 2, "gtk_icon_view_set_item_width", "gint");
  gtk_icon_view_set_item_width(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(item_width));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_item_width(Xen icon_view)
{
  #define H_gtk_icon_view_get_item_width "gint gtk_icon_view_get_item_width(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_width", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_item_width(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_spacing(Xen icon_view, Xen spacing)
{
  #define H_gtk_icon_view_set_spacing "void gtk_icon_view_set_spacing(GtkIconView* icon_view, gint spacing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_spacing", "GtkIconView*");
  Xen_check_type(Xen_is_gint(spacing), spacing, 2, "gtk_icon_view_set_spacing", "gint");
  gtk_icon_view_set_spacing(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(spacing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_spacing(Xen icon_view)
{
  #define H_gtk_icon_view_get_spacing "gint gtk_icon_view_get_spacing(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_spacing", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_spacing(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_row_spacing(Xen icon_view, Xen row_spacing)
{
  #define H_gtk_icon_view_set_row_spacing "void gtk_icon_view_set_row_spacing(GtkIconView* icon_view, \
gint row_spacing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_row_spacing", "GtkIconView*");
  Xen_check_type(Xen_is_gint(row_spacing), row_spacing, 2, "gtk_icon_view_set_row_spacing", "gint");
  gtk_icon_view_set_row_spacing(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(row_spacing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_row_spacing(Xen icon_view)
{
  #define H_gtk_icon_view_get_row_spacing "gint gtk_icon_view_get_row_spacing(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_row_spacing", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_row_spacing(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_column_spacing(Xen icon_view, Xen column_spacing)
{
  #define H_gtk_icon_view_set_column_spacing "void gtk_icon_view_set_column_spacing(GtkIconView* icon_view, \
gint column_spacing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_column_spacing", "GtkIconView*");
  Xen_check_type(Xen_is_gint(column_spacing), column_spacing, 2, "gtk_icon_view_set_column_spacing", "gint");
  gtk_icon_view_set_column_spacing(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(column_spacing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_column_spacing(Xen icon_view)
{
  #define H_gtk_icon_view_get_column_spacing "gint gtk_icon_view_get_column_spacing(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_column_spacing", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_column_spacing(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_margin(Xen icon_view, Xen margin)
{
  #define H_gtk_icon_view_set_margin "void gtk_icon_view_set_margin(GtkIconView* icon_view, gint margin)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_margin", "GtkIconView*");
  Xen_check_type(Xen_is_gint(margin), margin, 2, "gtk_icon_view_set_margin", "gint");
  gtk_icon_view_set_margin(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(margin));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_margin(Xen icon_view)
{
  #define H_gtk_icon_view_get_margin "gint gtk_icon_view_get_margin(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_margin", "GtkIconView*");
  return(C_to_Xen_gint(gtk_icon_view_get_margin(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_label_set_max_width_chars(Xen label, Xen n_chars)
{
  #define H_gtk_label_set_max_width_chars "void gtk_label_set_max_width_chars(GtkLabel* label, gint n_chars)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_set_max_width_chars", "GtkLabel*");
  Xen_check_type(Xen_is_gint(n_chars), n_chars, 2, "gtk_label_set_max_width_chars", "gint");
  gtk_label_set_max_width_chars(Xen_to_C_GtkLabel_(label), Xen_to_C_gint(n_chars));
  return(Xen_false);
}

static Xen gxg_gtk_label_get_max_width_chars(Xen label)
{
  #define H_gtk_label_get_max_width_chars "gint gtk_label_get_max_width_chars(GtkLabel* label)"
  Xen_check_type(Xen_is_GtkLabel_(label), label, 1, "gtk_label_get_max_width_chars", "GtkLabel*");
  return(C_to_Xen_gint(gtk_label_get_max_width_chars(Xen_to_C_GtkLabel_(label))));
}

static Xen gxg_gtk_list_store_insert_with_values(Xen list_store, Xen iter, Xen position)
{
  #define H_gtk_list_store_insert_with_values "void gtk_list_store_insert_with_values(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, ...)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_with_values", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_with_values", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_list_store_insert_with_values", "gint");
  gtk_list_store_insert_with_values(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint(position));
  return(Xen_false);
}

static Xen gxg_gtk_list_store_insert_with_valuesv(Xen list_store, Xen iter, Xen position, Xen columns, Xen values, Xen n_values)
{
  #define H_gtk_list_store_insert_with_valuesv "void gtk_list_store_insert_with_valuesv(GtkListStore* list_store, \
GtkTreeIter* iter, gint position, gint* columns, GValue* values, gint n_values)"
  Xen_check_type(Xen_is_GtkListStore_(list_store), list_store, 1, "gtk_list_store_insert_with_valuesv", "GtkListStore*");
  Xen_check_type(Xen_is_GtkTreeIter_(iter), iter, 2, "gtk_list_store_insert_with_valuesv", "GtkTreeIter*");
  Xen_check_type(Xen_is_gint(position), position, 3, "gtk_list_store_insert_with_valuesv", "gint");
  Xen_check_type(Xen_is_gint_(columns), columns, 4, "gtk_list_store_insert_with_valuesv", "gint*");
  Xen_check_type(Xen_is_GValue_(values), values, 5, "gtk_list_store_insert_with_valuesv", "GValue*");
  Xen_check_type(Xen_is_gint(n_values), n_values, 6, "gtk_list_store_insert_with_valuesv", "gint");
  gtk_list_store_insert_with_valuesv(Xen_to_C_GtkListStore_(list_store), Xen_to_C_GtkTreeIter_(iter), Xen_to_C_gint(position), 
                                     Xen_to_C_gint_(columns), Xen_to_C_GValue_(values), Xen_to_C_gint(n_values));
  return(Xen_false);
}

static Xen gxg_pango_attr_size_new_absolute(Xen size)
{
  #define H_pango_attr_size_new_absolute "PangoAttribute* pango_attr_size_new_absolute(int size)"
  Xen_check_type(Xen_is_int(size), size, 1, "pango_attr_size_new_absolute", "int");
  return(C_to_Xen_PangoAttribute_(pango_attr_size_new_absolute(Xen_to_C_int(size))));
}

static Xen gxg_pango_font_description_set_absolute_size(Xen desc, Xen size)
{
  #define H_pango_font_description_set_absolute_size "void pango_font_description_set_absolute_size(PangoFontDescription* desc, \
double size)"
  Xen_check_type(Xen_is_PangoFontDescription_(desc), desc, 1, "pango_font_description_set_absolute_size", "PangoFontDescription*");
  Xen_check_type(Xen_is_double(size), size, 2, "pango_font_description_set_absolute_size", "double");
  pango_font_description_set_absolute_size(Xen_to_C_PangoFontDescription_(desc), Xen_to_C_double(size));
  return(Xen_false);
}

static Xen gxg_pango_layout_get_font_description(Xen layout)
{
  #define H_pango_layout_get_font_description "PangoFontDescription* pango_layout_get_font_description(PangoLayout* layout)"
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_get_font_description", "PangoLayout*");
    return(C_to_Xen_PangoFontDescription_((PangoFontDescription*)pango_layout_get_font_description(Xen_to_C_PangoLayout_(layout))));
}

static Xen gxg_gdk_window_set_urgency_hint(Xen window, Xen urgent)
{
  #define H_gdk_window_set_urgency_hint "void gdk_window_set_urgency_hint(GdkWindow* window, gboolean urgent)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_set_urgency_hint", "GdkWindow*");
  Xen_check_type(Xen_is_gboolean(urgent), urgent, 2, "gdk_window_set_urgency_hint", "gboolean");
  gdk_window_set_urgency_hint(Xen_to_C_GdkWindow_(window), Xen_to_C_gboolean(urgent));
  return(Xen_false);
}

static Xen gxg_gtk_dialog_get_response_for_widget(Xen dialog, Xen widget)
{
  #define H_gtk_dialog_get_response_for_widget "gint gtk_dialog_get_response_for_widget(GtkDialog* dialog, \
GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkDialog_(dialog), dialog, 1, "gtk_dialog_get_response_for_widget", "GtkDialog*");
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 2, "gtk_dialog_get_response_for_widget", "GtkWidget*");
  return(C_to_Xen_gint(gtk_dialog_get_response_for_widget(Xen_to_C_GtkDialog_(dialog), Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_drag_source_set_icon_name(Xen widget, Xen icon_name)
{
  #define H_gtk_drag_source_set_icon_name "void gtk_drag_source_set_icon_name(GtkWidget* widget, gchar* icon_name)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_source_set_icon_name", "GtkWidget*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_drag_source_set_icon_name", "gchar*");
  gtk_drag_source_set_icon_name(Xen_to_C_GtkWidget_(widget), (const gchar*)Xen_to_C_gchar_(icon_name));
  return(Xen_false);
}

static Xen gxg_gtk_drag_set_icon_name(Xen context, Xen icon_name, Xen hot_x, Xen hot_y)
{
  #define H_gtk_drag_set_icon_name "void gtk_drag_set_icon_name(GdkDragContext* context, gchar* icon_name, \
gint hot_x, gint hot_y)"
  Xen_check_type(Xen_is_GdkDragContext_(context), context, 1, "gtk_drag_set_icon_name", "GdkDragContext*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_drag_set_icon_name", "gchar*");
  Xen_check_type(Xen_is_gint(hot_x), hot_x, 3, "gtk_drag_set_icon_name", "gint");
  Xen_check_type(Xen_is_gint(hot_y), hot_y, 4, "gtk_drag_set_icon_name", "gint");
  gtk_drag_set_icon_name(Xen_to_C_GdkDragContext_(context), (const gchar*)Xen_to_C_gchar_(icon_name), Xen_to_C_gint(hot_x), Xen_to_C_gint(hot_y));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_set_popup_set_width(Xen completion, Xen popup_set_width)
{
  #define H_gtk_entry_completion_set_popup_set_width "void gtk_entry_completion_set_popup_set_width(GtkEntryCompletion* completion, \
gboolean popup_set_width)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_popup_set_width", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(popup_set_width), popup_set_width, 2, "gtk_entry_completion_set_popup_set_width", "gboolean");
  gtk_entry_completion_set_popup_set_width(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(popup_set_width));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_popup_set_width(Xen completion)
{
  #define H_gtk_entry_completion_get_popup_set_width "gboolean gtk_entry_completion_get_popup_set_width(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_popup_set_width", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_popup_set_width(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_entry_completion_set_popup_single_match(Xen completion, Xen popup_single_match)
{
  #define H_gtk_entry_completion_set_popup_single_match "void gtk_entry_completion_set_popup_single_match(GtkEntryCompletion* completion, \
gboolean popup_single_match)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_set_popup_single_match", "GtkEntryCompletion*");
  Xen_check_type(Xen_is_gboolean(popup_single_match), popup_single_match, 2, "gtk_entry_completion_set_popup_single_match", "gboolean");
  gtk_entry_completion_set_popup_single_match(Xen_to_C_GtkEntryCompletion_(completion), Xen_to_C_gboolean(popup_single_match));
  return(Xen_false);
}

static Xen gxg_gtk_entry_completion_get_popup_single_match(Xen completion)
{
  #define H_gtk_entry_completion_get_popup_single_match "gboolean gtk_entry_completion_get_popup_single_match(GtkEntryCompletion* completion)"
  Xen_check_type(Xen_is_GtkEntryCompletion_(completion), completion, 1, "gtk_entry_completion_get_popup_single_match", "GtkEntryCompletion*");
  return(C_to_Xen_gboolean(gtk_entry_completion_get_popup_single_match(Xen_to_C_GtkEntryCompletion_(completion))));
}

static Xen gxg_gtk_icon_view_get_item_at_pos(Xen icon_view, Xen x, Xen y, Xen ignore_path, Xen ignore_cell)
{
  #define H_gtk_icon_view_get_item_at_pos "gboolean gtk_icon_view_get_item_at_pos(GtkIconView* icon_view, \
gint x, gint y, GtkTreePath** [path], GtkCellRenderer** [cell])"
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_item_at_pos", "GtkIconView*");
  Xen_check_type(Xen_is_gint(x), x, 2, "gtk_icon_view_get_item_at_pos", "gint");
  Xen_check_type(Xen_is_gint(y), y, 3, "gtk_icon_view_get_item_at_pos", "gint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_icon_view_get_item_at_pos(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(x), Xen_to_C_gint(y), 
                                                             &ref_path, &ref_cell));
    return(Xen_list_3(result, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkCellRenderer_(ref_cell)));
   }
}

static Xen gxg_gtk_icon_view_get_visible_range(Xen icon_view, Xen ignore_start_path, Xen ignore_end_path)
{
  #define H_gtk_icon_view_get_visible_range "gboolean gtk_icon_view_get_visible_range(GtkIconView* icon_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_visible_range", "GtkIconView*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_icon_view_get_visible_range(Xen_to_C_GtkIconView_(icon_view), &ref_start_path, &ref_end_path));
    return(Xen_list_3(result, C_to_Xen_GtkTreePath_(ref_start_path), C_to_Xen_GtkTreePath_(ref_end_path)));
   }
}

static Xen gxg_gtk_icon_view_set_cursor(Xen icon_view, Xen path, Xen cell, Xen start_editing)
{
  #define H_gtk_icon_view_set_cursor "void gtk_icon_view_set_cursor(GtkIconView* icon_view, GtkTreePath* path, \
GtkCellRenderer* cell, gboolean start_editing)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_cursor", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_set_cursor", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkCellRenderer_(cell), cell, 3, "gtk_icon_view_set_cursor", "GtkCellRenderer*");
  Xen_check_type(Xen_is_gboolean(start_editing), start_editing, 4, "gtk_icon_view_set_cursor", "gboolean");
  gtk_icon_view_set_cursor(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkCellRenderer_(cell), 
                           Xen_to_C_gboolean(start_editing));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_cursor(Xen icon_view, Xen ignore_path, Xen ignore_cell)
{
  #define H_gtk_icon_view_get_cursor "gboolean gtk_icon_view_get_cursor(GtkIconView* icon_view, GtkTreePath** [path], \
GtkCellRenderer** [cell])"
  GtkTreePath* ref_path = NULL;
  GtkCellRenderer* ref_cell = NULL;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_cursor", "GtkIconView*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_icon_view_get_cursor(Xen_to_C_GtkIconView_(icon_view), &ref_path, &ref_cell));
    return(Xen_list_3(result, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkCellRenderer_(ref_cell)));
   }
}

static Xen gxg_gtk_icon_view_scroll_to_path(Xen icon_view, Xen path, Xen use_align, Xen row_align, Xen col_align)
{
  #define H_gtk_icon_view_scroll_to_path "void gtk_icon_view_scroll_to_path(GtkIconView* icon_view, GtkTreePath* path, \
gboolean use_align, gfloat row_align, gfloat col_align)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_scroll_to_path", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_scroll_to_path", "GtkTreePath*");
  Xen_check_type(Xen_is_gboolean(use_align), use_align, 3, "gtk_icon_view_scroll_to_path", "gboolean");
  Xen_check_type(Xen_is_gfloat(row_align), row_align, 4, "gtk_icon_view_scroll_to_path", "gfloat");
  Xen_check_type(Xen_is_gfloat(col_align), col_align, 5, "gtk_icon_view_scroll_to_path", "gfloat");
  gtk_icon_view_scroll_to_path(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_gboolean(use_align), 
                               Xen_to_C_gfloat(row_align), Xen_to_C_gfloat(col_align));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unset_model_drag_source(Xen icon_view)
{
  #define H_gtk_icon_view_unset_model_drag_source "void gtk_icon_view_unset_model_drag_source(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unset_model_drag_source", "GtkIconView*");
  gtk_icon_view_unset_model_drag_source(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_unset_model_drag_dest(Xen icon_view)
{
  #define H_gtk_icon_view_unset_model_drag_dest "void gtk_icon_view_unset_model_drag_dest(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_unset_model_drag_dest", "GtkIconView*");
  gtk_icon_view_unset_model_drag_dest(Xen_to_C_GtkIconView_(icon_view));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_set_reorderable(Xen icon_view, Xen reorderable)
{
  #define H_gtk_icon_view_set_reorderable "void gtk_icon_view_set_reorderable(GtkIconView* icon_view, \
gboolean reorderable)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_reorderable", "GtkIconView*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 2, "gtk_icon_view_set_reorderable", "gboolean");
  gtk_icon_view_set_reorderable(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_reorderable(Xen icon_view)
{
  #define H_gtk_icon_view_get_reorderable "gboolean gtk_icon_view_get_reorderable(GtkIconView* icon_view)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_reorderable", "GtkIconView*");
  return(C_to_Xen_gboolean(gtk_icon_view_get_reorderable(Xen_to_C_GtkIconView_(icon_view))));
}

static Xen gxg_gtk_icon_view_set_drag_dest_item(Xen icon_view, Xen path, Xen pos)
{
  #define H_gtk_icon_view_set_drag_dest_item "void gtk_icon_view_set_drag_dest_item(GtkIconView* icon_view, \
GtkTreePath* path, GtkIconViewDropPosition pos)"
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_set_drag_dest_item", "GtkIconView*");
  Xen_check_type(Xen_is_GtkTreePath_(path), path, 2, "gtk_icon_view_set_drag_dest_item", "GtkTreePath*");
  Xen_check_type(Xen_is_GtkIconViewDropPosition(pos), pos, 3, "gtk_icon_view_set_drag_dest_item", "GtkIconViewDropPosition");
  gtk_icon_view_set_drag_dest_item(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_GtkTreePath_(path), Xen_to_C_GtkIconViewDropPosition(pos));
  return(Xen_false);
}

static Xen gxg_gtk_icon_view_get_drag_dest_item(Xen icon_view, Xen ignore_path, Xen ignore_pos)
{
  #define H_gtk_icon_view_get_drag_dest_item "void gtk_icon_view_get_drag_dest_item(GtkIconView* icon_view, \
GtkTreePath** [path], GtkIconViewDropPosition* [pos])"
  GtkTreePath* ref_path = NULL;
  GtkIconViewDropPosition ref_pos;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_drag_dest_item", "GtkIconView*");
  gtk_icon_view_get_drag_dest_item(Xen_to_C_GtkIconView_(icon_view), &ref_path, &ref_pos);
  return(Xen_list_2(C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkIconViewDropPosition(ref_pos)));
}

static Xen gxg_gtk_icon_view_get_dest_item_at_pos(Xen icon_view, Xen drag_x, Xen drag_y, Xen ignore_path, Xen ignore_pos)
{
  #define H_gtk_icon_view_get_dest_item_at_pos "gboolean gtk_icon_view_get_dest_item_at_pos(GtkIconView* icon_view, \
gint drag_x, gint drag_y, GtkTreePath** [path], GtkIconViewDropPosition* [pos])"
  GtkTreePath* ref_path = NULL;
  GtkIconViewDropPosition ref_pos;
  Xen_check_type(Xen_is_GtkIconView_(icon_view), icon_view, 1, "gtk_icon_view_get_dest_item_at_pos", "GtkIconView*");
  Xen_check_type(Xen_is_gint(drag_x), drag_x, 2, "gtk_icon_view_get_dest_item_at_pos", "gint");
  Xen_check_type(Xen_is_gint(drag_y), drag_y, 3, "gtk_icon_view_get_dest_item_at_pos", "gint");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_icon_view_get_dest_item_at_pos(Xen_to_C_GtkIconView_(icon_view), Xen_to_C_gint(drag_x), 
                                                                  Xen_to_C_gint(drag_y), &ref_path, &ref_pos));
    return(Xen_list_3(result, C_to_Xen_GtkTreePath_(ref_path), C_to_Xen_GtkIconViewDropPosition(ref_pos)));
   }
}

static Xen gxg_gtk_image_clear(Xen image)
{
  #define H_gtk_image_clear "void gtk_image_clear(GtkImage* image)"
  Xen_check_type(Xen_is_GtkImage_(image), image, 1, "gtk_image_clear", "GtkImage*");
  gtk_image_clear(Xen_to_C_GtkImage_(image));
  return(Xen_false);
}

static Xen gxg_gtk_menu_bar_get_pack_direction(Xen menubar)
{
  #define H_gtk_menu_bar_get_pack_direction "GtkPackDirection gtk_menu_bar_get_pack_direction(GtkMenuBar* menubar)"
  Xen_check_type(Xen_is_GtkMenuBar_(menubar), menubar, 1, "gtk_menu_bar_get_pack_direction", "GtkMenuBar*");
  return(C_to_Xen_GtkPackDirection(gtk_menu_bar_get_pack_direction(Xen_to_C_GtkMenuBar_(menubar))));
}

static Xen gxg_gtk_menu_bar_set_pack_direction(Xen menubar, Xen pack_dir)
{
  #define H_gtk_menu_bar_set_pack_direction "void gtk_menu_bar_set_pack_direction(GtkMenuBar* menubar, \
GtkPackDirection pack_dir)"
  Xen_check_type(Xen_is_GtkMenuBar_(menubar), menubar, 1, "gtk_menu_bar_set_pack_direction", "GtkMenuBar*");
  Xen_check_type(Xen_is_GtkPackDirection(pack_dir), pack_dir, 2, "gtk_menu_bar_set_pack_direction", "GtkPackDirection");
  gtk_menu_bar_set_pack_direction(Xen_to_C_GtkMenuBar_(menubar), Xen_to_C_GtkPackDirection(pack_dir));
  return(Xen_false);
}

static Xen gxg_gtk_menu_bar_get_child_pack_direction(Xen menubar)
{
  #define H_gtk_menu_bar_get_child_pack_direction "GtkPackDirection gtk_menu_bar_get_child_pack_direction(GtkMenuBar* menubar)"
  Xen_check_type(Xen_is_GtkMenuBar_(menubar), menubar, 1, "gtk_menu_bar_get_child_pack_direction", "GtkMenuBar*");
  return(C_to_Xen_GtkPackDirection(gtk_menu_bar_get_child_pack_direction(Xen_to_C_GtkMenuBar_(menubar))));
}

static Xen gxg_gtk_menu_bar_set_child_pack_direction(Xen menubar, Xen child_pack_dir)
{
  #define H_gtk_menu_bar_set_child_pack_direction "void gtk_menu_bar_set_child_pack_direction(GtkMenuBar* menubar, \
GtkPackDirection child_pack_dir)"
  Xen_check_type(Xen_is_GtkMenuBar_(menubar), menubar, 1, "gtk_menu_bar_set_child_pack_direction", "GtkMenuBar*");
  Xen_check_type(Xen_is_GtkPackDirection(child_pack_dir), child_pack_dir, 2, "gtk_menu_bar_set_child_pack_direction", "GtkPackDirection");
  gtk_menu_bar_set_child_pack_direction(Xen_to_C_GtkMenuBar_(menubar), Xen_to_C_GtkPackDirection(child_pack_dir));
  return(Xen_false);
}

static Xen gxg_gtk_menu_shell_get_take_focus(Xen menu_shell)
{
  #define H_gtk_menu_shell_get_take_focus "gboolean gtk_menu_shell_get_take_focus(GtkMenuShell* menu_shell)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_get_take_focus", "GtkMenuShell*");
  return(C_to_Xen_gboolean(gtk_menu_shell_get_take_focus(Xen_to_C_GtkMenuShell_(menu_shell))));
}

static Xen gxg_gtk_menu_shell_set_take_focus(Xen menu_shell, Xen take_focus)
{
  #define H_gtk_menu_shell_set_take_focus "void gtk_menu_shell_set_take_focus(GtkMenuShell* menu_shell, \
gboolean take_focus)"
  Xen_check_type(Xen_is_GtkMenuShell_(menu_shell), menu_shell, 1, "gtk_menu_shell_set_take_focus", "GtkMenuShell*");
  Xen_check_type(Xen_is_gboolean(take_focus), take_focus, 2, "gtk_menu_shell_set_take_focus", "gboolean");
  gtk_menu_shell_set_take_focus(Xen_to_C_GtkMenuShell_(menu_shell), Xen_to_C_gboolean(take_focus));
  return(Xen_false);
}

static Xen gxg_gtk_text_iter_forward_visible_line(Xen iter)
{
  #define H_gtk_text_iter_forward_visible_line "gboolean gtk_text_iter_forward_visible_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_visible_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_visible_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_backward_visible_line(Xen iter)
{
  #define H_gtk_text_iter_backward_visible_line "gboolean gtk_text_iter_backward_visible_line(GtkTextIter* iter)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_visible_line", "GtkTextIter*");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_visible_line(Xen_to_C_GtkTextIter_(iter))));
}

static Xen gxg_gtk_text_iter_forward_visible_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_forward_visible_lines "gboolean gtk_text_iter_forward_visible_lines(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_forward_visible_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_forward_visible_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_forward_visible_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_text_iter_backward_visible_lines(Xen iter, Xen count)
{
  #define H_gtk_text_iter_backward_visible_lines "gboolean gtk_text_iter_backward_visible_lines(GtkTextIter* iter, \
gint count)"
  Xen_check_type(Xen_is_GtkTextIter_(iter), iter, 1, "gtk_text_iter_backward_visible_lines", "GtkTextIter*");
  Xen_check_type(Xen_is_gint(count), count, 2, "gtk_text_iter_backward_visible_lines", "gint");
  return(C_to_Xen_gboolean(gtk_text_iter_backward_visible_lines(Xen_to_C_GtkTextIter_(iter), Xen_to_C_gint(count))));
}

static Xen gxg_gtk_tool_button_set_icon_name(Xen button, Xen icon_name)
{
  #define H_gtk_tool_button_set_icon_name "void gtk_tool_button_set_icon_name(GtkToolButton* button, \
gchar* icon_name)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_set_icon_name", "GtkToolButton*");
  Xen_check_type(Xen_is_gchar_(icon_name), icon_name, 2, "gtk_tool_button_set_icon_name", "gchar*");
  gtk_tool_button_set_icon_name(Xen_to_C_GtkToolButton_(button), (const gchar*)Xen_to_C_gchar_(icon_name));
  return(Xen_false);
}

static Xen gxg_gtk_tool_button_get_icon_name(Xen button)
{
  #define H_gtk_tool_button_get_icon_name "gchar* gtk_tool_button_get_icon_name(GtkToolButton* button)"
  Xen_check_type(Xen_is_GtkToolButton_(button), button, 1, "gtk_tool_button_get_icon_name", "GtkToolButton*");
    return(C_to_Xen_gchar_((gchar*)gtk_tool_button_get_icon_name(Xen_to_C_GtkToolButton_(button))));
}

static Xen gxg_gtk_window_set_urgency_hint(Xen window, Xen setting)
{
  #define H_gtk_window_set_urgency_hint "void gtk_window_set_urgency_hint(GtkWindow* window, gboolean setting)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_set_urgency_hint", "GtkWindow*");
  Xen_check_type(Xen_is_gboolean(setting), setting, 2, "gtk_window_set_urgency_hint", "gboolean");
  gtk_window_set_urgency_hint(Xen_to_C_GtkWindow_(window), Xen_to_C_gboolean(setting));
  return(Xen_false);
}

static Xen gxg_gtk_window_get_urgency_hint(Xen window)
{
  #define H_gtk_window_get_urgency_hint "gboolean gtk_window_get_urgency_hint(GtkWindow* window)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_get_urgency_hint", "GtkWindow*");
  return(C_to_Xen_gboolean(gtk_window_get_urgency_hint(Xen_to_C_GtkWindow_(window))));
}

static Xen gxg_gtk_window_present_with_time(Xen window, Xen timestamp)
{
  #define H_gtk_window_present_with_time "void gtk_window_present_with_time(GtkWindow* window, guint32 timestamp)"
  Xen_check_type(Xen_is_GtkWindow_(window), window, 1, "gtk_window_present_with_time", "GtkWindow*");
  Xen_check_type(Xen_is_guint32(timestamp), timestamp, 2, "gtk_window_present_with_time", "guint32");
  gtk_window_present_with_time(Xen_to_C_GtkWindow_(window), Xen_to_C_guint32(timestamp));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_set_do_overwrite_confirmation(Xen chooser, Xen do_overwrite_confirmation)
{
  #define H_gtk_file_chooser_set_do_overwrite_confirmation "void gtk_file_chooser_set_do_overwrite_confirmation(GtkFileChooser* chooser, \
gboolean do_overwrite_confirmation)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_set_do_overwrite_confirmation", "GtkFileChooser*");
  Xen_check_type(Xen_is_gboolean(do_overwrite_confirmation), do_overwrite_confirmation, 2, "gtk_file_chooser_set_do_overwrite_confirmation", "gboolean");
  gtk_file_chooser_set_do_overwrite_confirmation(Xen_to_C_GtkFileChooser_(chooser), Xen_to_C_gboolean(do_overwrite_confirmation));
  return(Xen_false);
}

static Xen gxg_gtk_file_chooser_get_do_overwrite_confirmation(Xen chooser)
{
  #define H_gtk_file_chooser_get_do_overwrite_confirmation "gboolean gtk_file_chooser_get_do_overwrite_confirmation(GtkFileChooser* chooser)"
  Xen_check_type(Xen_is_GtkFileChooser_(chooser), chooser, 1, "gtk_file_chooser_get_do_overwrite_confirmation", "GtkFileChooser*");
  return(C_to_Xen_gboolean(gtk_file_chooser_get_do_overwrite_confirmation(Xen_to_C_GtkFileChooser_(chooser))));
}

static Xen gxg_gtk_tree_row_reference_get_model(Xen reference)
{
  #define H_gtk_tree_row_reference_get_model "GtkTreeModel* gtk_tree_row_reference_get_model(GtkTreeRowReference* reference)"
  Xen_check_type(Xen_is_GtkTreeRowReference_(reference), reference, 1, "gtk_tree_row_reference_get_model", "GtkTreeRowReference*");
  return(C_to_Xen_GtkTreeModel_(gtk_tree_row_reference_get_model(Xen_to_C_GtkTreeRowReference_(reference))));
}

static Xen gxg_gtk_tree_view_column_queue_resize(Xen tree_column)
{
  #define H_gtk_tree_view_column_queue_resize "void gtk_tree_view_column_queue_resize(GtkTreeViewColumn* tree_column)"
  Xen_check_type(Xen_is_GtkTreeViewColumn_(tree_column), tree_column, 1, "gtk_tree_view_column_queue_resize", "GtkTreeViewColumn*");
  gtk_tree_view_column_queue_resize(Xen_to_C_GtkTreeViewColumn_(tree_column));
  return(Xen_false);
}

static Xen gxg_gtk_tree_view_get_visible_range(Xen tree_view, Xen ignore_start_path, Xen ignore_end_path)
{
  #define H_gtk_tree_view_get_visible_range "gboolean gtk_tree_view_get_visible_range(GtkTreeView* tree_view, \
GtkTreePath** [start_path], GtkTreePath** [end_path])"
  GtkTreePath* ref_start_path = NULL;
  GtkTreePath* ref_end_path = NULL;
  Xen_check_type(Xen_is_GtkTreeView_(tree_view), tree_view, 1, "gtk_tree_view_get_visible_range", "GtkTreeView*");
  {
    Xen result;
    result = C_to_Xen_gboolean(gtk_tree_view_get_visible_range(Xen_to_C_GtkTreeView_(tree_view), &ref_start_path, &ref_end_path));
    return(Xen_list_3(result, C_to_Xen_GtkTreePath_(ref_start_path), C_to_Xen_GtkTreePath_(ref_end_path)));
   }
}

static Xen gxg_pango_attr_list_ref(Xen list)
{
  #define H_pango_attr_list_ref "PangoAttrList* pango_attr_list_ref(PangoAttrList* list)"
  Xen_check_type(Xen_is_PangoAttrList_(list), list, 1, "pango_attr_list_ref", "PangoAttrList*");
  return(C_to_Xen_PangoAttrList_(pango_attr_list_ref(Xen_to_C_PangoAttrList_(list))));
}

static Xen gxg_pango_layout_line_ref(Xen line)
{
  #define H_pango_layout_line_ref "PangoLayoutLine* pango_layout_line_ref(PangoLayoutLine* line)"
  Xen_check_type(Xen_is_PangoLayoutLine_(line), line, 1, "pango_layout_line_ref", "PangoLayoutLine*");
  return(C_to_Xen_PangoLayoutLine_(pango_layout_line_ref(Xen_to_C_PangoLayoutLine_(line))));
}

static Xen gxg_pango_layout_index_to_line_x(Xen layout, Xen index_, Xen trailing, Xen ignore_line, Xen ignore_x_pos)
{
  #define H_pango_layout_index_to_line_x "void pango_layout_index_to_line_x(PangoLayout* layout, int index_, \
gboolean trailing, int* [line], int* [x_pos])"
  int ref_line;
  int ref_x_pos;
  Xen_check_type(Xen_is_PangoLayout_(layout), layout, 1, "pango_layout_index_to_line_x", "PangoLayout*");
  Xen_check_type(Xen_is_int(index_), index_, 2, "pango_layout_index_to_line_x", "int");
  Xen_check_type(Xen_is_gboolean(trailing), trailing, 3, "pango_layout_index_to_line_x", "gboolean");
  pango_layout_index_to_line_x(Xen_to_C_PangoLayout_(layout), Xen_to_C_int(index_), Xen_to_C_gboolean(trailing), &ref_line, 
                               &ref_x_pos);
  return(Xen_list_2(C_to_Xen_int(ref_line), C_to_Xen_int(ref_x_pos)));
}

static Xen gxg_gdk_display_supports_shapes(Xen display)
{
  #define H_gdk_display_supports_shapes "gboolean gdk_display_supports_shapes(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_supports_shapes", "GdkDisplay*");
  return(C_to_Xen_gboolean(gdk_display_supports_shapes(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_display_supports_input_shapes(Xen display)
{
  #define H_gdk_display_supports_input_shapes "gboolean gdk_display_supports_input_shapes(GdkDisplay* display)"
  Xen_check_type(Xen_is_GdkDisplay_(display), display, 1, "gdk_display_supports_input_shapes", "GdkDisplay*");
  return(C_to_Xen_gboolean(gdk_display_supports_input_shapes(Xen_to_C_GdkDisplay_(display))));
}

static Xen gxg_gdk_window_get_type_hint(Xen window)
{
  #define H_gdk_window_get_type_hint "GdkWindowTypeHint gdk_window_get_type_hint(GdkWindow* window)"
  Xen_check_type(Xen_is_GdkWindow_(window), window, 1, "gdk_window_get_type_hint", "GdkWindow*");
  return(C_to_Xen_GdkWindowTypeHint(gdk_window_get_type_hint(Xen_to_C_GdkWindow_(window))));
}

static Xen gxg_gtk_drag_dest_set_track_motion(Xen widget, Xen track_motion)
{
  #define H_gtk_drag_dest_set_track_motion "void gtk_drag_dest_set_track_motion(GtkWidget* widget, gboolean track_motion)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_dest_set_track_motion", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(track_motion), track_motion, 2, "gtk_drag_dest_set_track_motion", "gboolean");
  gtk_drag_dest_set_track_motion(Xen_to_C_GtkWidget_(widget), Xen_to_C_gboolean(track_motion));
  return(Xen_false);
}

static Xen gxg_gtk_drag_dest_get_track_motion(Xen widget)
{
  #define H_gtk_drag_dest_get_track_motion "gboolean gtk_drag_dest_get_track_motion(GtkWidget* widget)"
  Xen_check_type(Xen_is_GtkWidget_(widget), widget, 1, "gtk_drag_dest_get_track_motion", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_drag_dest_get_track_motion(Xen_to_C_GtkWidget_(widget))));
}

static Xen gxg_gtk_notebook_get_tab_reorderable(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_reorderable "gboolean gtk_notebook_get_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_reorderable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_reorderable", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_notebook_get_tab_reorderable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_tab_reorderable(Xen notebook, Xen child, Xen reorderable)
{
  #define H_gtk_notebook_set_tab_reorderable "void gtk_notebook_set_tab_reorderable(GtkNotebook* notebook, \
GtkWidget* child, gboolean reorderable)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_reorderable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_reorderable", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(reorderable), reorderable, 3, "gtk_notebook_set_tab_reorderable", "gboolean");
  gtk_notebook_set_tab_reorderable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(reorderable));
  return(Xen_false);
}

static Xen gxg_gtk_notebook_get_tab_detachable(Xen notebook, Xen child)
{
  #define H_gtk_notebook_get_tab_detachable "gboolean gtk_notebook_get_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_get_tab_detachable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_get_tab_detachable", "GtkWidget*");
  return(C_to_Xen_gboolean(gtk_notebook_get_tab_detachable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child))));
}

static Xen gxg_gtk_notebook_set_tab_detachable(Xen notebook, Xen child, Xen detachable)
{
  #define H_gtk_notebook_set_tab_detachable "void gtk_notebook_set_tab_detachable(GtkNotebook* notebook, \
GtkWidget* child, gboolean detachable)"
  Xen_check_type(Xen_is_GtkNotebook_(notebook), notebook, 1, "gtk_notebook_set_tab_detachable", "GtkNotebook*");
  Xen_check_type(Xen_is_GtkWidget_(child), child, 2, "gtk_notebook_set_tab_detachable", "GtkWidget*");
  Xen_check_type(Xen_is_gboolean(detachable), detachable, 3, "gtk_notebook_set_tab_detachable", "gboolean");
  gtk_notebook_set_tab_detachable(Xen_to_C_GtkNotebook_(notebook), Xen_to_C_GtkWidget_(child), Xen_to_C_gboolean(detachable));
  return(Xen_false);
}

static Xen gxg_gtk_range_set_lower_stepper_sensitivity(Xen range, Xen sensitivity)
{
  #define H_gtk_range_set_lower_stepper_sensitivity "void gtk_range_set_lower_stepper_sensitivity(GtkRange* range, \
GtkSensitivityType sensitivity)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_lower_stepper_sensitivity", "GtkRange*");
  Xen_check_type(Xen_is_GtkSensitivityType(sensitivity), sensitivity, 2, "gtk_range_set_lower_stepper_sensitivity", "GtkSensitivityType");
  gtk_range_set_lower_stepper_sensitivity(Xen_to_C_GtkRange_(range), Xen_to_C_GtkSensitivityType(sensitivity));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_lower_stepper_sensitivity(Xen range)
{
  #define H_gtk_range_get_lower_stepper_sensitivity "GtkSensitivityType gtk_range_get_lower_stepper_sensitivity(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_lower_stepper_sensitivity", "GtkRange*");
  return(C_to_Xen_GtkSensitivityType(gtk_range_get_lower_stepper_sensitivity(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_range_set_upper_stepper_sensitivity(Xen range, Xen sensitivity)
{
  #define H_gtk_range_set_upper_stepper_sensitivity "void gtk_range_set_upper_stepper_sensitivity(GtkRange* range, \
GtkSensitivityType sensitivity)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_set_upper_stepper_sensitivity", "GtkRange*");
  Xen_check_type(Xen_is_GtkSensitivityType(sensitivity), sensitivity, 2, "gtk_range_set_upper_stepper_sensitivity", "GtkSensitivityType");
  gtk_range_set_upper_stepper_sensitivity(Xen_to_C_GtkRange_(range), Xen_to_C_GtkSensitivityType(sensitivity));
  return(Xen_false);
}

static Xen gxg_gtk_range_get_upper_stepper_sensitivity(Xen range)
{
  #define H_gtk_range_get_upper_stepper_sensitivity "GtkSensitivityType gtk_range_get_upper_stepper_sensitivity(GtkRange* range)"
  Xen_check_type(Xen_is_GtkRange_(range), range, 1, "gtk_range_get_upper_stepper_sensitivity", "GtkRange*");
  return(C_to_Xen_GtkSensitivityType(gtk_range_get_upper_stepper_sensitivity(Xen_to_C_GtkRange_(range))));
}

static Xen gxg_gtk_scrolled_window_unset_placement(Xen scrolled_window)
{
  #define H_gtk_scrolled_window_unset_placement "void gtk_scrolled_window_unset_placement(GtkScrolledWindow* scrolled_window)"
  Xen_check_type(Xen_is_GtkScrolledWindow_(scrolled_window), scrolled_window, 1, "gtk_scrolled_window_unset_placement", "GtkScrolledWindow*");
  gtk_scrolled_window_unset_placement(Xen_to_C_GtkScrolledWindow_(scrolled_window));
  return(Xen_false);
}

static Xen gxg_gtk_size_group_get_widgets(Xen size_group)
{
  #define H_gtk_size_group_get_widgets "GSList* gtk_size_group_get_widgets(GtkSizeGroup* size_group)"
  Xen_check_type(Xen_is_GtkSizeGroup_(size_group), size_group, 1,