/*
 * conf.h -- compile time SMA configuration
 * All but DEFAULT_CONF can be changed at runtime with command line
 * options (-f and -F).
 *
 * $Date: 2002/09/14 11:27:00 $
 */


/*
 * This is a default configuration file.
 */
#define DEFAULT_CONF	"./sma.conf"

/*
 * Default hostname.
 * This is used only if the hostname cannot be defined from log files
 * (Sendmail for NT).
 */
#define HOSTNAME	"mailserver"


/*
 * Bounce address and host. These are used for DSN and other error
 * messages as a envelope sender/relay host.
 */
#define	BOUNCE_ADDR	"MAILER-DAEMON" 
#define	BOUNCE_HOST	"localhost" 


/*
 * Default header for report
 */
#define COMMENT		"Sendmail Log Analysis Report"


/*
 * Defaults for Envelope senders/recipients and Relays
 */
#define LDEF		10	/* Envelope sender */
#define LRDEF		10	/* Envelope recipient */
#define RDEF		5	/* Relay sender */
#define RRDEF		5	/* Relay recipient */


/*
 * HTML defaults
 */
#define BG_COLOR	"FFFFFF"	/* Background color */
#define TB_COLOR	"CCCCCC"	/* Table border color */
#define PICTURE_ALT	"Logo"		/* ALT for HTML picture */


/*
 * Reasonable defaults for internal hash table size.
 */
#define ASIZE_NORMAL	1699	/* Address table */
#define RSIZE_NORMAL	101	/* Relay table */
#define ASIZE_BIG	30011	/* Address table */
#define RSIZE_BIG	1783	/* Relay table */
#define ASIZE_HUGE	100003	/* Address table */
#define RSIZE_HUGE	5953	/* Relay table */
