" Vim color file
" Name:            def256-ruby
" Maintainer:      Ralph Amissah <ralph@amissah.com>
" Last Change:     2013-02-14
" URL:             <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=data/sisu/conf/editor-syntax-etc/vim/colors/def256-ruby.vim;hb=HEAD>
" Note:            based on colorscheme defx, this scheme has 256 colors
"                  selected primarily from 16 colors around the colors available
"                  for 16 color cterm (with occasional other colors selected
"                  from 256 color palate) .Xdefaults settings provided to make
"                  term 16 colors match this, using 256 color palate.
:hi clear
if exists("syntax_on")
  syntax reset
endif
:set t_Co=256
:set background=dark
:let colors_name = "def256-ruby"
" -------
" terminal def
" -------
:hi Normal                             ctermbg=0           ctermfg=7
":hi Cursor                             ctermbg=5           ctermfg=0
:hi lCursor        cterm=reverse
:hi StatusLine     cterm=reverse
:hi StatusLineNC   cterm=reverse
:hi Search         cterm=none          ctermbg=57          ctermfg=0
:hi IncSearch      cterm=none          ctermbg=154         ctermfg=0
:hi SpecialKey                                             ctermfg=24
:hi Visual         cterm=reverse
:hi VisualNOS      cterm=bold,underline
:hi MoreMsg                                                ctermfg=112
:hi ModeMsg        cterm=bold
:hi Question                                               ctermfg=112
:hi Title                                                  ctermfg=160
:hi NonText        cterm=bold                              ctermfg=24
:hi LineNr         cterm=bold          ctermbg=0           ctermfg=8
:hi CursorLineNr   cterm=bold          ctermbg=166         ctermfg=0
:hi Directory                                              ctermfg=24
:hi WildMenu                           ctermbg=178         ctermfg=0
:hi VertSplit      cterm=reverse
:hi Folded         cterm=none          ctermbg=0           ctermfg=59
:hi FoldColumn                         ctermbg=7           ctermfg=24
:hi DiffAdd        cterm=none          ctermbg=112         ctermfg=0
:hi DiffChange     cterm=none          ctermbg=7           ctermfg=0
:hi DiffDelete     cterm=none          ctermbg=7           ctermfg=0
:hi DiffText       cterm=none          ctermbg=37          ctermfg=0
:hi String         cterm=none                              ctermfg=178
:hi Comment        cterm=none          ctermbg=0           ctermfg=24
:hi Constant                                               ctermfg=160
:hi Special                                                ctermfg=37
:hi Identifier     cterm=none                              ctermfg=37
:hi Statement      cterm=none                              ctermfg=112
:hi Operator                                               ctermfg=160
:hi PreProc                                                ctermfg=160
:hi Type           cterm=bold                              ctermfg=178
:hi Delimiter      cterm=none                              ctermfg=112
:hi Ignore         cterm=bold                              ctermfg=7
:hi Todo                               ctermbg=178         ctermfg=0
:hi Underlined     cterm=underline
:hi Include                                                ctermfg=160
:hi Define                                                 ctermfg=178
:hi Function                                               ctermfg=37
:hi Structure                                              ctermfg=112
:hi MatchParen     cterm=bold          ctermbg=24          ctermfg=7
:hi CursorLine     cterm=bold
:hi CursorColumn                       ctermbg=17
:hi ColorColumn                        ctermbg=17
:hi SpellBad       cterm=underline     ctermbg=0           ctermfg=90
:hi SpellCap       cterm=underline     ctermbg=0           ctermfg=90
:hi SpellLocal     cterm=underline     ctermbg=0           ctermfg=90
:hi SpellRare      cterm=underline     ctermbg=0           ctermfg=90
:hi TrailingWhitespace                 ctermbg=160
:hi ExtraWhitespace                    ctermbg=160
:hi WarningMsg                                             ctermfg=160
:hi ErrorMsg       cterm=bold          ctermbg=160         ctermfg=7
:hi Error          cterm=bold          ctermbg=160         ctermfg=7
" -------
" gui def
" -------
:hi Normal                             guibg=#000000       guifg=#C0C0C0
:hi Cursor                             guibg=#CC9966       guifg=#000000
:hi lCursor        gui=reverse
:hi StatusLine     gui=reverse
:hi StatusLineNC   gui=reverse
:hi Search         gui=none            guibg=#5F00FF       guifg=#000000
:hi IncSearch      gui=none            guibg=#AFFF00       guifg=#000000
:hi SpecialKey                                             guifg=#005F87
:hi Visual         gui=reverse
:hi VisualNOS      gui=bold,underline
:hi MoreMsg                                                guifg=#87DF00
:hi ModeMsg        gui=bold
:hi Question                                               guifg=#87DF00
:hi Title                                                  guifg=#CC0000
:hi NonText        gui=bold                                guifg=#005F87
:hi LineNr         gui=bold            guibg=#000000       guifg=#808080
:hi CursorLineNr   gui=bold            guibg=#D75F00       guifg=#000000
:hi Directory                                              guifg=#005F87
:hi WildMenu                           guibg=#DFAF00       guifg=#000000
:hi VertSplit      gui=reverse
:hi Folded         gui=none            guibg=#000000       guifg=#808080
:hi FoldColumn                         guibg=#C0C0C0       guifg=#005F87
:hi DiffAdd        gui=none            guibg=#87DF00       guifg=#000000
:hi DiffChange     gui=none            guibg=#C0C0C0       guifg=#000000
:hi DiffDelete     gui=none            guibg=#C0C0C0       guifg=#000000
:hi DiffText       gui=none            guibg=#00AFAF       guifg=#000000
:hi String         gui=none                                guifg=#DFAF00
:hi Comment        gui=none            guibg=#000000       guifg=#005F87
:hi Constant                                               guifg=#CC0000
:hi Special                                                guifg=#06989A
:hi Identifier     gui=none                                guifg=#06989A
:hi Statement      gui=none                                guifg=#87DF00
:hi Operator                                               guifg=#CC0000
:hi PreProc                                                guifg=#CC0000
:hi Type           gui=bold                                guifg=#DFAF00
:hi Delimiter      gui=none                                guifg=#87DF00
:hi Ignore         gui=bold                                guifg=#C0C0C0
:hi Todo                               guibg=#DFAF00       guifg=#000000
:hi Underlined     gui=underline
:hi Include                                                guifg=#CC0000
:hi Define                                                 guifg=#DFAF00
:hi Function                                               guifg=#00AFAF
:hi Structure                                              guifg=#87DF00
:hi MatchParen     gui=bold            guibg=#005F87       guifg=#C0C0C0
:hi CursorLine     gui=bold
:hi CursorColumn                       guibg=#00005F
:hi ColorColumn                        guibg=#00005F
:hi SpellBad       gui=underline       guibg=#000000       guifg=#870087
:hi SpellCap       gui=underline       guibg=#000000       guifg=#870087
:hi SpellLocal     gui=underline       guibg=#000000       guifg=#870087
:hi SpellRare      gui=underline       guibg=#000000       guifg=#870087
:hi TrailingWhitespace                 guibg=#CC0000
:hi ExtraWhitespace                    guibg=#CC0000
:hi WarningMsg                                             guifg=#CC0000
:hi ErrorMsg       gui=bold            guibg=#CC0000       guifg=#C0C0C0
:hi Error          gui=bold            guibg=#CC0000       guifg=#C0C0C0
" -------
"256 color .Xdefaults vim: cterm giu
"<http://vim.wikia.com/wiki/Xterm256_color_names_for_console_Vim>
"<http://guns.github.com/xterm-color-table.vim/images/xterm-color-table-with-visible-rgb.png>
" -------
" 256 color .Xdefaults vim: cterm giu def
" -------
"      16 color     standard     altered 256     altered beyond 256
" black/dark grey
"        0        [ 0:#000000]                   #000000
"        8        [ 8:#808080]   [59:#5F5F5F]    #555555
" red
"        1        [ 1:#800000]   160:#DF0000     #CC0000
"        9        [ 9:#FF0000]                   #EF2929
" green
"        2        [ 2:#008000]   112:#87DF00     #4E9A06
"       10        [10:#00FF00]   154:#AFFF00     #8AE234
" yellow/orange
"        3        [ 3:#808000]   178:#DFAF00     #C4A000
"       11        [11:#FFFF00]   184:#DFDF00     #FC9E4F
" blue
"        4        [ 4:#000080]    24:#005F87     #5971AD
"       12        [12:#0000FF]    73:#5FAFAF     #729FCF
" magenta
"        5        [ 5:#800080]    90:#870087     #75507B
"       13        [13:#FF00FF]   126:#AF0087     #AD7FA8
" cyan
"        6        [ 6:#008080]    37:#00AFAF     #06989A
"       14        [14:#00FFFF]    87:#5FFFFF     #34E2E2
" white
"        7        [ 7:#C0C0C0]                   #D3D3D3
"       15        [15:#FFFFFF]                   #EEEEEE
" --------
" .Xdefaults 256 (rxvt urxvt setting, vim colorscheme "def256" cterm & gui settings)
" (vim colorscheme "def" cterm matches "def256" if .Xdefaults set thus)
" --------
" ! black
" Rxvt.color0  : #000000
" Rxvt.color8  : #5F5F5F
" ! red
" Rxvt.color1  : #DF0000
" Rxvt.color9  : #FF0000
" ! green
" Rxvt.color2  : #87DF00
" Rxvt.color10 : #AFFF00
" ! yellow
" Rxvt.color3  : #DFAF00
" Rxvt.color11 : #FFFF00
" ! blue
" Rxvt.color4  : #5F87DF
" Rxvt.color12 : #87DFFF
" ! magenta
" Rxvt.color5  : #8700DF
" Rxvt.color13 : #87DFFF
" ! cyan
" Rxvt.color6  : #00DFDF
" Rxvt.color14 : #5F5FDF
" ! white
" Rxvt.color7  : #C0C0C0
" Rxvt.color15 : #FFFFFF
