// Copyright 2015 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// DO NOT EDIT: autogenerated by etc/platform-intrinsics/generator.py
// ignore-tidy-linelength

#![allow(unused_imports)]

use {Intrinsic, Type};
use IntrinsicDef::Named;

// The default inlining settings trigger a pathological behaviour in
// LLVM, which causes makes compilation very slow. See #28273.
#[inline(never)]
pub fn find(name: &str) -> Option<Intrinsic> {
    if !name.starts_with("arm_v") { return None }
    Some(match &name["arm_v".len()..] {
        "hadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vhadds.v8i8")
        },
        "hadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vhaddu.v8i8")
        },
        "hadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vhadds.v4i16")
        },
        "hadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vhaddu.v4i16")
        },
        "hadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vhadds.v2i32")
        },
        "hadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vhaddu.v2i32")
        },
        "haddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vhadds.v16i8")
        },
        "haddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vhaddu.v16i8")
        },
        "haddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vhadds.v8i16")
        },
        "haddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vhaddu.v8i16")
        },
        "haddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vhadds.v4i32")
        },
        "haddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vhaddu.v4i32")
        },
        "rhadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vrhadds.v8i8")
        },
        "rhadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vrhaddu.v8i8")
        },
        "rhadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vrhadds.v4i16")
        },
        "rhadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vrhaddu.v4i16")
        },
        "rhadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vrhadds.v2i32")
        },
        "rhadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vrhaddu.v2i32")
        },
        "rhaddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vrhadds.v16i8")
        },
        "rhaddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vrhaddu.v16i8")
        },
        "rhaddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vrhadds.v8i16")
        },
        "rhaddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vrhaddu.v8i16")
        },
        "rhaddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vrhadds.v4i32")
        },
        "rhaddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vrhaddu.v4i32")
        },
        "qadd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqadds.v8i8")
        },
        "qadd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqaddu.v8i8")
        },
        "qadd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqadds.v4i16")
        },
        "qadd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqaddu.v4i16")
        },
        "qadd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqadds.v2i32")
        },
        "qadd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqaddu.v2i32")
        },
        "qadd_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vqadds.v1i64")
        },
        "qadd_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vqaddu.v1i64")
        },
        "qaddq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vqadds.v16i8")
        },
        "qaddq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vqaddu.v16i8")
        },
        "qaddq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vqadds.v8i16")
        },
        "qaddq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vqaddu.v8i16")
        },
        "qaddq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vqadds.v4i32")
        },
        "qaddq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vqaddu.v4i32")
        },
        "qaddq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vqadds.v2i64")
        },
        "qaddq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vqaddu.v2i64")
        },
        "raddhn_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vraddhn.v8i8")
        },
        "raddhn_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vraddhn.v8i8")
        },
        "raddhn_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vraddhn.v4i16")
        },
        "raddhn_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vraddhn.v4i16")
        },
        "raddhn_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vraddhn.v2i32")
        },
        "raddhn_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vraddhn.v2i32")
        },
        "fma_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.fma.v2f32")
        },
        "fmaq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.fma.v4f32")
        },
        "qdmulh_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vsqdmulh.v4i16")
        },
        "qdmulh_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vsqdmulh.v2i32")
        },
        "qdmulhq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vsqdmulh.v8i16")
        },
        "qdmulhq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vsqdmulh.v4i32")
        },
        "qrdmulh_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vsqrdmulh.v4i16")
        },
        "qrdmulh_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vsqrdmulh.v2i32")
        },
        "qrdmulhq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vsqrdmulh.v8i16")
        },
        "qrdmulhq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vsqrdmulh.v4i32")
        },
        "mull_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vmulls.v8i16")
        },
        "mull_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vmullu.v8i16")
        },
        "mull_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vmulls.v4i32")
        },
        "mull_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vmullu.v4i32")
        },
        "mull_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vmulls.v2i64")
        },
        "mull_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vmullu.v2i64")
        },
        "qdmullq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vsqdmull.v8i16")
        },
        "qdmullq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vsqdmull.v4i32")
        },
        "hsub_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vhsubs.v8i8")
        },
        "hsub_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vhsubu.v8i8")
        },
        "hsub_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vhsubs.v4i16")
        },
        "hsub_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vhsubu.v4i16")
        },
        "hsub_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vhsubs.v2i32")
        },
        "hsub_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vhsubu.v2i32")
        },
        "hsubq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vhsubs.v16i8")
        },
        "hsubq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vhsubu.v16i8")
        },
        "hsubq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vhsubs.v8i16")
        },
        "hsubq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vhsubu.v8i16")
        },
        "hsubq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vhsubs.v4i32")
        },
        "hsubq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vhsubu.v4i32")
        },
        "qsub_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqsubs.v8i8")
        },
        "qsub_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqsubu.v8i8")
        },
        "qsub_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqsubs.v4i16")
        },
        "qsub_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqsubu.v4i16")
        },
        "qsub_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqsubs.v2i32")
        },
        "qsub_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqsubu.v2i32")
        },
        "qsub_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vqsubs.v1i64")
        },
        "qsub_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vqsubu.v1i64")
        },
        "qsubq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vqsubs.v16i8")
        },
        "qsubq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vqsubu.v16i8")
        },
        "qsubq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vqsubs.v8i16")
        },
        "qsubq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vqsubu.v8i16")
        },
        "qsubq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vqsubs.v4i32")
        },
        "qsubq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vqsubu.v4i32")
        },
        "qsubq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vqsubs.v2i64")
        },
        "qsubq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vqsubu.v2i64")
        },
        "rsubhn_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vrsubhn.v8i8")
        },
        "rsubhn_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vrsubhn.v8i8")
        },
        "rsubhn_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vrsubhn.v4i16")
        },
        "rsubhn_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vrsubhn.v4i16")
        },
        "rsubhn_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vrsubhn.v2i32")
        },
        "rsubhn_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vrsubhn.v2i32")
        },
        "abd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vabds.v8i8")
        },
        "abd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vabdu.v8i8")
        },
        "abd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vabds.v4i16")
        },
        "abd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vabdu.v4i16")
        },
        "abd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vabds.v2i32")
        },
        "abd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vabdu.v2i32")
        },
        "abd_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vabdf.v2f32")
        },
        "abdq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vabds.v16i8")
        },
        "abdq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vabdu.v16i8")
        },
        "abdq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vabds.v8i16")
        },
        "abdq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vabdu.v8i16")
        },
        "abdq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vabds.v4i32")
        },
        "abdq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vabdu.v4i32")
        },
        "abdq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vabdf.v4f32")
        },
        "max_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vmaxs.v8i8")
        },
        "max_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vmaxu.v8i8")
        },
        "max_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vmaxs.v4i16")
        },
        "max_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vmaxu.v4i16")
        },
        "max_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vmaxs.v2i32")
        },
        "max_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vmaxu.v2i32")
        },
        "max_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vmaxf.v2f32")
        },
        "maxq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vmaxs.v16i8")
        },
        "maxq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vmaxu.v16i8")
        },
        "maxq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vmaxs.v8i16")
        },
        "maxq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vmaxu.v8i16")
        },
        "maxq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vmaxs.v4i32")
        },
        "maxq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vmaxu.v4i32")
        },
        "maxq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vmaxf.v4f32")
        },
        "min_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vmins.v8i8")
        },
        "min_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vminu.v8i8")
        },
        "min_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vmins.v4i16")
        },
        "min_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vminu.v4i16")
        },
        "min_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vmins.v2i32")
        },
        "min_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vminu.v2i32")
        },
        "min_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vminf.v2f32")
        },
        "minq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vmins.v16i8")
        },
        "minq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vminu.v16i8")
        },
        "minq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vmins.v8i16")
        },
        "minq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vminu.v8i16")
        },
        "minq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vmins.v4i32")
        },
        "minq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vminu.v4i32")
        },
        "minq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vminf.v4f32")
        },
        "shl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vshls.v8i8")
        },
        "shl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vshlu.v8i8")
        },
        "shl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vshls.v4i16")
        },
        "shl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vshlu.v4i16")
        },
        "shl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vshls.v2i32")
        },
        "shl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vshlu.v2i32")
        },
        "shl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vshls.v1i64")
        },
        "shl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vshlu.v1i64")
        },
        "shlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vshls.v16i8")
        },
        "shlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vshlu.v16i8")
        },
        "shlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vshls.v8i16")
        },
        "shlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vshlu.v8i16")
        },
        "shlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vshls.v4i32")
        },
        "shlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vshlu.v4i32")
        },
        "shlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vshls.v2i64")
        },
        "shlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vshlu.v2i64")
        },
        "qshl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqshls.v8i8")
        },
        "qshl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqshlu.v8i8")
        },
        "qshl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqshls.v4i16")
        },
        "qshl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqshlu.v4i16")
        },
        "qshl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqshls.v2i32")
        },
        "qshl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqshlu.v2i32")
        },
        "qshl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vqshls.v1i64")
        },
        "qshl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vqshlu.v1i64")
        },
        "qshlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vqshls.v16i8")
        },
        "qshlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vqshlu.v16i8")
        },
        "qshlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vqshls.v8i16")
        },
        "qshlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vqshlu.v8i16")
        },
        "qshlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vqshls.v4i32")
        },
        "qshlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vqshlu.v4i32")
        },
        "qshlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vqshls.v2i64")
        },
        "qshlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vqshlu.v2i64")
        },
        "rshl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vrshls.v8i8")
        },
        "rshl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vrshlu.v8i8")
        },
        "rshl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vrshls.v4i16")
        },
        "rshl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vrshlu.v4i16")
        },
        "rshl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vrshls.v2i32")
        },
        "rshl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vrshlu.v2i32")
        },
        "rshl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vrshls.v1i64")
        },
        "rshl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vrshlu.v1i64")
        },
        "rshlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vrshls.v16i8")
        },
        "rshlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vrshlu.v16i8")
        },
        "rshlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vrshls.v8i16")
        },
        "rshlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vrshlu.v8i16")
        },
        "rshlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vrshls.v4i32")
        },
        "rshlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vrshlu.v4i32")
        },
        "rshlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vrshls.v2i64")
        },
        "rshlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vrshlu.v2i64")
        },
        "qrshl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqrshls.v8i8")
        },
        "qrshl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqrshlu.v8i8")
        },
        "qrshl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqrshls.v4i16")
        },
        "qrshl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqrshlu.v4i16")
        },
        "qrshl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqrshls.v2i32")
        },
        "qrshl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqrshlu.v2i32")
        },
        "qrshl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vqrshls.v1i64")
        },
        "qrshl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vqrshlu.v1i64")
        },
        "qrshlq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vqrshls.v16i8")
        },
        "qrshlq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vqrshlu.v16i8")
        },
        "qrshlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vqrshls.v8i16")
        },
        "qrshlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vqrshlu.v8i16")
        },
        "qrshlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vqrshls.v4i32")
        },
        "qrshlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vqrshlu.v4i32")
        },
        "qrshlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vqrshls.v2i64")
        },
        "qrshlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vqrshlu.v2i64")
        },
        "qshrun_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vsqshrun.v8i8")
        },
        "qshrun_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vsqshrun.v4i16")
        },
        "qshrun_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vsqshrun.v2i32")
        },
        "qrshrun_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vsqrshrun.v8i8")
        },
        "qrshrun_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vsqrshrun.v4i16")
        },
        "qrshrun_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vsqrshrun.v2i32")
        },
        "qshrn_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqshrns.v8i8")
        },
        "qshrn_n_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U32]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqshrnu.v8i8")
        },
        "qshrn_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqshrns.v4i16")
        },
        "qshrn_n_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqshrnu.v4i16")
        },
        "qshrn_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqshrns.v2i32")
        },
        "qshrn_n_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqshrnu.v2i32")
        },
        "rshrn_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vrshrn.v8i8")
        },
        "rshrn_n_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U32]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vrshrn.v8i8")
        },
        "rshrn_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vrshrn.v4i16")
        },
        "rshrn_n_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vrshrn.v4i16")
        },
        "rshrn_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vrshrn.v2i32")
        },
        "rshrn_n_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vrshrn.v2i32")
        },
        "qrshrn_n_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::U32]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqrshrns.v8i8")
        },
        "qrshrn_n_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U32]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqrshrnu.v8i8")
        },
        "qrshrn_n_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::U32]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqrshrns.v4i16")
        },
        "qrshrn_n_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqrshrnu.v4i16")
        },
        "qrshrn_n_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::U32]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqrshrns.v2i32")
        },
        "qrshrn_n_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqrshrnu.v2i32")
        },
        "sri_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vvsri.v8i8")
        },
        "sri_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vvsri.v8i8")
        },
        "sri_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vvsri.v4i16")
        },
        "sri_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vvsri.v4i16")
        },
        "sri_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vvsri.v2i32")
        },
        "sri_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vvsri.v2i32")
        },
        "sri_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vvsri.v1i64")
        },
        "sri_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vvsri.v1i64")
        },
        "sriq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vvsri.v16i8")
        },
        "sriq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vvsri.v16i8")
        },
        "sriq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vvsri.v8i16")
        },
        "sriq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vvsri.v8i16")
        },
        "sriq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vvsri.v4i32")
        },
        "sriq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vvsri.v4i32")
        },
        "sriq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vvsri.v2i64")
        },
        "sriq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vvsri.v2i64")
        },
        "sli_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vvsli.v8i8")
        },
        "sli_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vvsli.v8i8")
        },
        "sli_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vvsli.v4i16")
        },
        "sli_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vvsli.v4i16")
        },
        "sli_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vvsli.v2i32")
        },
        "sli_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vvsli.v2i32")
        },
        "sli_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vvsli.v1i64")
        },
        "sli_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vvsli.v1i64")
        },
        "sliq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vvsli.v16i8")
        },
        "sliq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vvsli.v16i8")
        },
        "sliq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vvsli.v8i16")
        },
        "sliq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vvsli.v8i16")
        },
        "sliq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vvsli.v4i32")
        },
        "sliq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vvsli.v4i32")
        },
        "sliq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vvsli.v2i64")
        },
        "sliq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vvsli.v2i64")
        },
        "vqmovn_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vqxtns.v8i8")
        },
        "vqmovn_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vqxtnu.v8i8")
        },
        "vqmovn_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vqxtns.v4i16")
        },
        "vqmovn_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vqxtnu.v4i16")
        },
        "vqmovn_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I64x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vqxtns.v2i32")
        },
        "vqmovn_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U64x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vqxtnu.v2i32")
        },
        "abs_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vabs.v8i8")
        },
        "abs_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vabs.v4i16")
        },
        "abs_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vabs.v2i32")
        },
        "absq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vabs.v16i8")
        },
        "absq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vabs.v8i16")
        },
        "absq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vabs.v4i32")
        },
        "abs_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.fabs.v2f32")
        },
        "absq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.fabs.v4f32")
        },
        "qabs_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vsqabs.v8i8")
        },
        "qabs_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vsqabs.v4i16")
        },
        "qabs_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vsqabs.v2i32")
        },
        "qabsq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vsqabs.v16i8")
        },
        "qabsq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vsqabs.v8i16")
        },
        "qabsq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vsqabs.v4i32")
        },
        "qneg_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vsqneg.v8i8")
        },
        "qneg_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vsqneg.v4i16")
        },
        "qneg_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vsqneg.v2i32")
        },
        "qnegq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vsqneg.v16i8")
        },
        "qnegq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vsqneg.v8i16")
        },
        "qnegq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vsqneg.v4i32")
        },
        "clz_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.ctlz.v8i8")
        },
        "clz_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.ctlz.v8i8")
        },
        "clz_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.ctlz.v4i16")
        },
        "clz_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.ctlz.v4i16")
        },
        "clz_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.ctlz.v2i32")
        },
        "clz_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.ctlz.v2i32")
        },
        "clzq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.ctlz.v16i8")
        },
        "clzq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.ctlz.v16i8")
        },
        "clzq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.ctlz.v8i16")
        },
        "clzq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.ctlz.v8i16")
        },
        "clzq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.ctlz.v4i32")
        },
        "clzq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.ctlz.v4i32")
        },
        "cls_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vcls.v8i8")
        },
        "cls_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vcls.v8i8")
        },
        "cls_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vcls.v4i16")
        },
        "cls_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vcls.v4i16")
        },
        "cls_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vcls.v2i32")
        },
        "cls_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vcls.v2i32")
        },
        "clsq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vcls.v16i8")
        },
        "clsq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vcls.v16i8")
        },
        "clsq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vcls.v8i16")
        },
        "clsq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vcls.v8i16")
        },
        "clsq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vcls.v4i32")
        },
        "clsq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vcls.v4i32")
        },
        "cnt_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.ctpop.v8i8")
        },
        "cnt_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.ctpop.v8i8")
        },
        "cntq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.ctpop.v16i8")
        },
        "cntq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.ctpop.v16i8")
        },
        "recpe_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vrecpe.v2i32")
        },
        "recpe_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vrecpe.v2f32")
        },
        "recpeq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vrecpe.v4i32")
        },
        "recpeq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vrecpe.v4f32")
        },
        "recps_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vfrecps.v2f32")
        },
        "recpsq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vfrecps.v4f32")
        },
        "sqrt_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.sqrt.v2f32")
        },
        "sqrtq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.sqrt.v4f32")
        },
        "rsqrte_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vrsqrte.v2i32")
        },
        "rsqrte_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vrsqrte.v2f32")
        },
        "rsqrteq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vrsqrte.v4i32")
        },
        "rsqrteq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vrsqrte.v4f32")
        },
        "rsqrts_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vrsqrts.v2f32")
        },
        "rsqrtsq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vrsqrts.v4f32")
        },
        "bsl_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vbsl.v8i8")
        },
        "bsl_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vbsl.v8i8")
        },
        "bsl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vbsl.v4i16")
        },
        "bsl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vbsl.v4i16")
        },
        "bsl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vbsl.v2i32")
        },
        "bsl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vbsl.v2i32")
        },
        "bsl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::I64x1]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vbsl.v1i64")
        },
        "bsl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U64x1]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vbsl.v1i64")
        },
        "bslq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vbsl.v16i8")
        },
        "bslq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vbsl.v16i8")
        },
        "bslq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vbsl.v8i16")
        },
        "bslq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vbsl.v8i16")
        },
        "bslq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vbsl.v4i32")
        },
        "bslq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vbsl.v4i32")
        },
        "bslq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::I64x2]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vbsl.v2i64")
        },
        "bslq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U64x2]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vbsl.v2i64")
        },
        "padd_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vpadd.v8i8")
        },
        "padd_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vpadd.v8i8")
        },
        "padd_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vpadd.v4i16")
        },
        "padd_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vpadd.v4i16")
        },
        "padd_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vpadd.v2i32")
        },
        "padd_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vpadd.v2i32")
        },
        "padd_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vpadd.v2f32")
        },
        "paddl_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x8]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vpaddls.v4i16.v8i8")
        },
        "paddl_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x8]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vpaddlu.v4i16.v8i8")
        },
        "paddl_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x4]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vpaddls.v2i32.v4i16")
        },
        "paddl_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x4]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vpaddlu.v2i32.v4i16")
        },
        "paddl_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x2]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vpaddls.v1i64.v2i32")
        },
        "paddl_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x2]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vpaddlu.v1i64.v2i32")
        },
        "paddlq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I8x16]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vpaddls.v8i16.v16i8")
        },
        "paddlq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U8x16]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vpaddlu.v8i16.v16i8")
        },
        "paddlq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I16x8]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vpaddls.v4i32.v8i16")
        },
        "paddlq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U16x8]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vpaddlu.v4i32.v8i16")
        },
        "paddlq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::I32x4]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vpaddls.v2i64.v4i32")
        },
        "paddlq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 1] = [&::U32x4]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vpaddlu.v2i64.v4i32")
        },
        "padal_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I8x8]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vpadals.v4i16.v4i16")
        },
        "padal_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U8x8]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vpadalu.v4i16.v4i16")
        },
        "padal_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I16x4]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vpadals.v2i32.v2i32")
        },
        "padal_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U16x4]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vpadalu.v2i32.v2i32")
        },
        "padal_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x1, &::I32x2]; &INPUTS },
            output: &::I64x1,
            definition: Named("llvm.arm.neon.vpadals.v1i64.v1i64")
        },
        "padal_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x1, &::U32x2]; &INPUTS },
            output: &::U64x1,
            definition: Named("llvm.arm.neon.vpadalu.v1i64.v1i64")
        },
        "padalq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I8x16]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vpadals.v8i16.v8i16")
        },
        "padalq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U8x16]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vpadalu.v8i16.v8i16")
        },
        "padalq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I16x8]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vpadals.v4i32.v4i32")
        },
        "padalq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U16x8]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vpadalu.v4i32.v4i32")
        },
        "padalq_s64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I64x2, &::I32x4]; &INPUTS },
            output: &::I64x2,
            definition: Named("llvm.arm.neon.vpadals.v2i64.v2i64")
        },
        "padalq_u64" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U64x2, &::U32x4]; &INPUTS },
            output: &::U64x2,
            definition: Named("llvm.arm.neon.vpadalu.v2i64.v2i64")
        },
        "pmax_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vpmaxs.v8i8")
        },
        "pmax_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vpmaxu.v8i8")
        },
        "pmax_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vpmaxs.v4i16")
        },
        "pmax_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vpmaxu.v4i16")
        },
        "pmax_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vpmaxs.v2i32")
        },
        "pmax_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vpmaxu.v2i32")
        },
        "pmax_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vpmaxf.v2f32")
        },
        "pmin_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vpmins.v8i8")
        },
        "pmin_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vpminu.v8i8")
        },
        "pmin_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x4, &::I16x4]; &INPUTS },
            output: &::I16x4,
            definition: Named("llvm.arm.neon.vpmins.v4i16")
        },
        "pmin_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x4, &::U16x4]; &INPUTS },
            output: &::U16x4,
            definition: Named("llvm.arm.neon.vpminu.v4i16")
        },
        "pmin_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x2, &::I32x2]; &INPUTS },
            output: &::I32x2,
            definition: Named("llvm.arm.neon.vpmins.v2i32")
        },
        "pmin_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x2, &::U32x2]; &INPUTS },
            output: &::U32x2,
            definition: Named("llvm.arm.neon.vpminu.v2i32")
        },
        "pmin_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x2, &::F32x2]; &INPUTS },
            output: &::F32x2,
            definition: Named("llvm.arm.neon.vpminf.v2f32")
        },
        "pminq_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x16, &::I8x16]; &INPUTS },
            output: &::I8x16,
            definition: Named("llvm.arm.neon.vpmins.v16i8")
        },
        "pminq_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x16, &::U8x16]; &INPUTS },
            output: &::U8x16,
            definition: Named("llvm.arm.neon.vpminu.v16i8")
        },
        "pminq_s16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I16x8, &::I16x8]; &INPUTS },
            output: &::I16x8,
            definition: Named("llvm.arm.neon.vpmins.v8i16")
        },
        "pminq_u16" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U16x8, &::U16x8]; &INPUTS },
            output: &::U16x8,
            definition: Named("llvm.arm.neon.vpminu.v8i16")
        },
        "pminq_s32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I32x4, &::I32x4]; &INPUTS },
            output: &::I32x4,
            definition: Named("llvm.arm.neon.vpmins.v4i32")
        },
        "pminq_u32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U32x4, &::U32x4]; &INPUTS },
            output: &::U32x4,
            definition: Named("llvm.arm.neon.vpminu.v4i32")
        },
        "pminq_f32" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::F32x4, &::F32x4]; &INPUTS },
            output: &::F32x4,
            definition: Named("llvm.arm.neon.vpminf.v4f32")
        },
        "tbl1_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::I8x8, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbl1")
        },
        "tbl1_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbl1")
        },
        "tbx1_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x8, &::I8x8, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbx1")
        },
        "tbx1_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x8, &::U8x8, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbx1")
        },
        "tbl2_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbl2")
        },
        "tbl2_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbl2")
        },
        "tbx2_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::I8x8, &::I8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbx2")
        },
        "tbx2_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 2] = [&::U8x8, &::U8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbx2")
        },
        "tbl3_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbl3")
        },
        "tbl3_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbl3")
        },
        "tbx3_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbx3")
        },
        "tbx3_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 3] = [&::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbx3")
        },
        "tbl4_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::I8x8, &::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbl4")
        },
        "tbl4_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 2] = [{ static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::U8x8, &::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbl4")
        },
        "tbx4_s8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::I8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::I8x8, &::I8x8, &::I8x8, &::I8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::I8x8,
            definition: Named("llvm.arm.neon.vtbx4")
        },
        "tbx4_u8" => Intrinsic {
            inputs: { static INPUTS: [&'static Type; 3] = [&::U8x8, { static AGG: Type = Type::Aggregate(true, { static PARTS: [&'static Type; 4] = [&::U8x8, &::U8x8, &::U8x8, &::U8x8]; &PARTS }); &AGG }, &::U8x8]; &INPUTS },
            output: &::U8x8,
            definition: Named("llvm.arm.neon.vtbx4")
        },
        _ => return None,
    })
}
