//! Test case / example for `${select }`
use std::fmt::Debug;
use derive_deftly::{derive_deftly_adhoc, Deftly};
use derive_deftly_tests::*;
#[derive_deftly_adhoc]
struct Both {
    #[deftly(left)]
    a: usize,
    #[deftly(right)]
    b: usize,
    #[deftly(right)]
    c: usize,
}
#[automatically_derived]
impl ::core::default::Default for Both {
    #[inline]
    fn default() -> Both {
        Both {
            a: ::core::default::Default::default(),
            b: ::core::default::Default::default(),
            c: ::core::default::Default::default(),
        }
    }
}
#[automatically_derived]
impl ::core::fmt::Debug for Both {
    #[inline]
    fn fmt(&self, f: &mut ::core::fmt::Formatter) -> ::core::fmt::Result {
        ::core::fmt::Formatter::debug_struct_field3_finish(
            f,
            "Both",
            "a",
            &self.a,
            "b",
            &self.b,
            "c",
            &&self.c,
        )
    }
}
struct Left {
    a: usize,
}
#[automatically_derived]
impl ::core::default::Default for Left {
    #[inline]
    fn default() -> Left {
        Left {
            a: ::core::default::Default::default(),
        }
    }
}
#[automatically_derived]
impl ::core::fmt::Debug for Left {
    #[inline]
    fn fmt(&self, f: &mut ::core::fmt::Formatter) -> ::core::fmt::Result {
        ::core::fmt::Formatter::debug_struct_field1_finish(f, "Left", "a", &&self.a)
    }
}
struct Right {
    b: usize,
    c: usize,
}
fn main() {
    match (&Left::default().to_debug(), &"Left { a: 0 }") {
        (left_val, right_val) => {
            if !(*left_val == *right_val) {
                let kind = ::core::panicking::AssertKind::Eq;
                ::core::panicking::assert_failed(
                    kind,
                    &*left_val,
                    &*right_val,
                    ::core::option::Option::None,
                );
            }
        }
    }
}
