#include "neumann-laplace-assembly.h"
struct cahouet_chabart {
  cahouet_chabart (const space& Qh, Float lambda_1)
    : fact_m(), fact_c(), lambda(lambda_1) {
    form m (Qh, Qh, "mass");
    fact_m = ldlt(m.uu);
    trial p (Qh); test q (Qh);
    form a = integrate (dot(grad(p),grad(q)));
    form_diag dm (Qh, "mass");
    field mh (dm);
    csr<Float> c = neumann_laplace_assembly (a.uu, mh.u);
    fact_c = ldlt(c);
  }
  vec<Float> solve (const vec<Float>& Mp) const {
    vec<Float> q1 = fact_m.solve(Mp);
    vec<Float> Mp_e (Mp.size()+1);
    for (size_t i = 0; i < Mp.size(); i++) Mp_e.at(i) = Mp.at(i);
    Mp_e.at(Mp.size()) = 0;
    vec<Float> q2_e = fact_c.solve(Mp_e);
    vec<Float> q2 (Mp.size());
    for (size_t i = 0; i < q2.size(); i++) q2.at(i) = q2_e.at(i);
    vec<Float> q = q1 + lambda*q2;
    return q;
  }
  ssk<Float> fact_m;
  ssk<Float> fact_c;
  Float lambda;
};
