#ifndef _RHEO_COMPUTE_BBOX_H
#define _RHEO_COMPUTE_BBOX_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
namespace rheolef { 
//
// used by cad and geo classes
//
template <
    	class PointIterator,
	class Point,
	class Size>
void
compute_bbox (
	PointIterator iter_p,
	PointIterator last_p,
	Size	      dim,
	Point&	      xmin,
	Point&	      xmax)
{
  typedef typename Point::float_type                               float_type;
  typedef typename std::iterator_traits<PointIterator>::value_type Point1;

  for (Size j = 0; j < dim; j++) {
    xmin[j] =  std::numeric_limits<float_type>::max();
    xmax[j] = -std::numeric_limits<float_type>::max();
  }
  for (Size j = dim+1; j < 3; j++) {
    xmin [j] = xmax [j] = 0;
  }
  while (iter_p != last_p) {
    const Point1& p = *iter_p++;
    for (Size j = 0 ; j < dim; j++) {
      xmin[j] = min(p[j], xmin[j]);
      xmax[j] = max(p[j], xmax[j]);
    }
  }
}
}// namespace rheolef
#endif // _RHEO_BBOX_H
