#! /bin/sh

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

set -ue
## set -x

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

TMP_DB_FILE=${TMP_DB_DIR}/samples.db
TMP_DB_META=${TMP_DB_DIR}/restful.db
TMP_DB_MAIN_ABS=$(cd $(dirname ${TMP_DB_FILE}); pwd)/samples.db

sqlite3 ${TMP_DB_FILE} <<END
    create table scientific_class (
        type varchar(255) not null,
        la_name varchar(255) not null,
        lt_name varchar(255),
        parent varchar(255) );

    create unique index la_name on scientific_class (la_name);

    insert into scientific_class values
        ( 'species', 'Cucurbita pepo', 'Paprastasis moliūgas', 'Cucurbita' ),
        ( 'genus',   'Cucurbita',      'Moliūgas',             'Cucurbiteae' ),
        ( 'tribe',   'Cucurbiteae',     NULL,                  'Cucurbitoideae' );
END

export REQUEST_URI="/~saulius/restful/website/samples.db/scientific_class/Cucurbita"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=get
export REMOTE_USER=tester

${INPUT_SCRIPT}

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
