# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "AuthManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# enumeration
class Type(Enumeration):
    idlType = "auth.Type:1.0.0"
    values = ["LOCAL", "RADIUS", "KERBEROS", "TACACS_PLUS", "LDAP"]

Type.LOCAL = Type(0)
Type.RADIUS = Type(1)
Type.KERBEROS = Type(2)
Type.TACACS_PLUS = Type(3)
Type.LDAP = Type(4)

# structure
class Policy(Structure):
    idlType = "auth.Policy:1.0.0"
    elements = ["type", "useLocalIfRemoteFailed"]

    def __init__(self, type=None, useLocalIfRemoteFailed=False):
        if type is None:
            type = raritan.rpc.auth.Type.LOCAL
        typecheck.is_enum(type, raritan.rpc.auth.Type, AssertionError)
        typecheck.is_bool(useLocalIfRemoteFailed, AssertionError)

        self.type = type
        self.useLocalIfRemoteFailed = useLocalIfRemoteFailed

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            type = raritan.rpc.auth.Type.decode(json['type']),
            useLocalIfRemoteFailed = json['useLocalIfRemoteFailed'],
        )
        return obj

    def encode(self):
        json = {}
        json['type'] = raritan.rpc.auth.Type.encode(self.type)
        json['useLocalIfRemoteFailed'] = self.useLocalIfRemoteFailed
        return json

# interface
class AuthManager(Interface):
    idlType = "auth.AuthManager:1.0.0"

    ERR_UNSUPPORTED_TYPE = 1

    class _getPolicy(Interface.Method):
        name = 'getPolicy'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.auth.Policy.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.auth.Policy, DecodeException)
            return _ret_

    class _setPolicy(Interface.Method):
        name = 'setPolicy'

        @staticmethod
        def encode(p):
            typecheck.is_struct(p, raritan.rpc.auth.Policy, AssertionError)
            args = {}
            args['p'] = raritan.rpc.auth.Policy.encode(p)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(AuthManager, self).__init__(target, agent)
        self.getPolicy = AuthManager._getPolicy(self)
        self.setPolicy = AuthManager._setPolicy(self)

#
# Section generated by IdlC from "LdapManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# interface
class LdapManager(Interface):
    idlType = "auth.LdapManager:3.0.1"

    # enumeration
    class ServerType(Enumeration):
        idlType = "auth.LdapManager_3_0_1.ServerType:1.0.0"
        values = ["ACTIVE_DIRECTORY", "OPEN_LDAP"]

    ServerType.ACTIVE_DIRECTORY = ServerType(0)
    ServerType.OPEN_LDAP = ServerType(1)

    # enumeration
    class SecurityProtocol(Enumeration):
        idlType = "auth.LdapManager_3_0_1.SecurityProtocol:1.0.0"
        values = ["SEC_PROTO_NONE", "SEC_PROTO_SSL", "SEC_PROTO_STARTTLS"]

    SecurityProtocol.SEC_PROTO_NONE = SecurityProtocol(0)
    SecurityProtocol.SEC_PROTO_SSL = SecurityProtocol(1)
    SecurityProtocol.SEC_PROTO_STARTTLS = SecurityProtocol(2)

    # structure
    class ServerSettings(Structure):
        idlType = "auth.LdapManager_3_0_1.ServerSettings:1.0.0"
        elements = ["id", "server", "adoptSettingsId", "type", "secProto", "port", "sslPort", "forceTrustedCert", "allowOffTimeRangeCerts", "certificate", "adsDomain", "useAnonymousBind", "bindDN", "bindPwd", "searchBaseDN", "loginNameAttr", "userEntryObjClass", "userSearchFilter", "groupInfoInUserEntry", "groupMemberAttr", "groupEntryObjClass", "groupSearchFilter"]

        def __init__(self, id="", server="", adoptSettingsId="", type=None, secProto=None, port=0, sslPort=0, forceTrustedCert=False, allowOffTimeRangeCerts=False, certificate="", adsDomain="", useAnonymousBind=False, bindDN="", bindPwd="", searchBaseDN="", loginNameAttr="", userEntryObjClass="", userSearchFilter="", groupInfoInUserEntry=False, groupMemberAttr="", groupEntryObjClass="", groupSearchFilter=""):
            if type is None:
                type = raritan.rpc.auth.LdapManager.ServerType.ACTIVE_DIRECTORY
            if secProto is None:
                secProto = raritan.rpc.auth.LdapManager.SecurityProtocol.SEC_PROTO_NONE
            typecheck.is_string(id, AssertionError)
            typecheck.is_string(server, AssertionError)
            typecheck.is_string(adoptSettingsId, AssertionError)
            typecheck.is_enum(type, raritan.rpc.auth.LdapManager.ServerType, AssertionError)
            typecheck.is_enum(secProto, raritan.rpc.auth.LdapManager.SecurityProtocol, AssertionError)
            typecheck.is_int(port, AssertionError)
            typecheck.is_int(sslPort, AssertionError)
            typecheck.is_bool(forceTrustedCert, AssertionError)
            typecheck.is_bool(allowOffTimeRangeCerts, AssertionError)
            typecheck.is_string(certificate, AssertionError)
            typecheck.is_string(adsDomain, AssertionError)
            typecheck.is_bool(useAnonymousBind, AssertionError)
            typecheck.is_string(bindDN, AssertionError)
            typecheck.is_string(bindPwd, AssertionError)
            typecheck.is_string(searchBaseDN, AssertionError)
            typecheck.is_string(loginNameAttr, AssertionError)
            typecheck.is_string(userEntryObjClass, AssertionError)
            typecheck.is_string(userSearchFilter, AssertionError)
            typecheck.is_bool(groupInfoInUserEntry, AssertionError)
            typecheck.is_string(groupMemberAttr, AssertionError)
            typecheck.is_string(groupEntryObjClass, AssertionError)
            typecheck.is_string(groupSearchFilter, AssertionError)

            self.id = id
            self.server = server
            self.adoptSettingsId = adoptSettingsId
            self.type = type
            self.secProto = secProto
            self.port = port
            self.sslPort = sslPort
            self.forceTrustedCert = forceTrustedCert
            self.allowOffTimeRangeCerts = allowOffTimeRangeCerts
            self.certificate = certificate
            self.adsDomain = adsDomain
            self.useAnonymousBind = useAnonymousBind
            self.bindDN = bindDN
            self.bindPwd = bindPwd
            self.searchBaseDN = searchBaseDN
            self.loginNameAttr = loginNameAttr
            self.userEntryObjClass = userEntryObjClass
            self.userSearchFilter = userSearchFilter
            self.groupInfoInUserEntry = groupInfoInUserEntry
            self.groupMemberAttr = groupMemberAttr
            self.groupEntryObjClass = groupEntryObjClass
            self.groupSearchFilter = groupSearchFilter

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                server = json['server'],
                adoptSettingsId = json['adoptSettingsId'],
                type = raritan.rpc.auth.LdapManager.ServerType.decode(json['type']),
                secProto = raritan.rpc.auth.LdapManager.SecurityProtocol.decode(json['secProto']),
                port = json['port'],
                sslPort = json['sslPort'],
                forceTrustedCert = json['forceTrustedCert'],
                allowOffTimeRangeCerts = json['allowOffTimeRangeCerts'],
                certificate = json['certificate'],
                adsDomain = json['adsDomain'],
                useAnonymousBind = json['useAnonymousBind'],
                bindDN = json['bindDN'],
                bindPwd = json['bindPwd'],
                searchBaseDN = json['searchBaseDN'],
                loginNameAttr = json['loginNameAttr'],
                userEntryObjClass = json['userEntryObjClass'],
                userSearchFilter = json['userSearchFilter'],
                groupInfoInUserEntry = json['groupInfoInUserEntry'],
                groupMemberAttr = json['groupMemberAttr'],
                groupEntryObjClass = json['groupEntryObjClass'],
                groupSearchFilter = json['groupSearchFilter'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['server'] = self.server
            json['adoptSettingsId'] = self.adoptSettingsId
            json['type'] = raritan.rpc.auth.LdapManager.ServerType.encode(self.type)
            json['secProto'] = raritan.rpc.auth.LdapManager.SecurityProtocol.encode(self.secProto)
            json['port'] = self.port
            json['sslPort'] = self.sslPort
            json['forceTrustedCert'] = self.forceTrustedCert
            json['allowOffTimeRangeCerts'] = self.allowOffTimeRangeCerts
            json['certificate'] = self.certificate
            json['adsDomain'] = self.adsDomain
            json['useAnonymousBind'] = self.useAnonymousBind
            json['bindDN'] = self.bindDN
            json['bindPwd'] = self.bindPwd
            json['searchBaseDN'] = self.searchBaseDN
            json['loginNameAttr'] = self.loginNameAttr
            json['userEntryObjClass'] = self.userEntryObjClass
            json['userSearchFilter'] = self.userSearchFilter
            json['groupInfoInUserEntry'] = self.groupInfoInUserEntry
            json['groupMemberAttr'] = self.groupMemberAttr
            json['groupEntryObjClass'] = self.groupEntryObjClass
            json['groupSearchFilter'] = self.groupSearchFilter
            return json

    class _getLdapServers(Interface.Method):
        name = 'getLdapServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.auth.LdapManager.ServerSettings.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.auth.LdapManager.ServerSettings, DecodeException)
            return _ret_

    ERR_CYCLIC_DEP = 1

    ERR_INVALID_CFG = 2

    class _setLdapServers(Interface.Method):
        name = 'setLdapServers'

        @staticmethod
        def encode(serverList):
            for x0 in serverList:
                typecheck.is_struct(x0, raritan.rpc.auth.LdapManager.ServerSettings, AssertionError)
            args = {}
            args['serverList'] = [raritan.rpc.auth.LdapManager.ServerSettings.encode(x0) for x0 in serverList]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    ERR_SERVER_UNSPECIFIED = 1

    ERR_SERVER_UNREACHABLE = 3

    ERR_AUTHENTICATION_FAILED = 4

    ERR_NO_ROLES = 5

    ERR_NO_KNOWN_ROLES = 6

    class _testLdapServer(Interface.Method):
        name = 'testLdapServer'

        @staticmethod
        def encode(username, password, settings):
            typecheck.is_string(username, AssertionError)
            typecheck.is_string(password, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.auth.LdapManager.ServerSettings, AssertionError)
            args = {}
            args['username'] = username
            args['password'] = password
            args['settings'] = raritan.rpc.auth.LdapManager.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            diagMsg = rsp['diagMsg']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_string(diagMsg, DecodeException)
            return (_ret_, diagMsg)
    def __init__(self, target, agent):
        super(LdapManager, self).__init__(target, agent)
        self.getLdapServers = LdapManager._getLdapServers(self)
        self.setLdapServers = LdapManager._setLdapServers(self)
        self.testLdapServer = LdapManager._testLdapServer(self)

#
# Section generated by IdlC from "RadiusManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# interface
class RadiusManager(Interface):
    idlType = "auth.RadiusManager:3.0.1"

    # enumeration
    class AuthType(Enumeration):
        idlType = "auth.RadiusManager_3_0_1.AuthType:1.0.0"
        values = ["PAP", "CHAP", "MSCHAPv2"]

    AuthType.PAP = AuthType(0)
    AuthType.CHAP = AuthType(1)
    AuthType.MSCHAPv2 = AuthType(2)

    # structure
    class ServerSettings(Structure):
        idlType = "auth.RadiusManager_3_0_1.ServerSettings:1.0.0"
        elements = ["id", "server", "sharedSecret", "udpAuthPort", "udpAccountPort", "timeout", "retries", "authType", "disableAccounting"]

        def __init__(self, id="", server="", sharedSecret="", udpAuthPort=0, udpAccountPort=0, timeout=0, retries=0, authType=None, disableAccounting=False):
            if authType is None:
                authType = raritan.rpc.auth.RadiusManager.AuthType.PAP
            typecheck.is_string(id, AssertionError)
            typecheck.is_string(server, AssertionError)
            typecheck.is_string(sharedSecret, AssertionError)
            typecheck.is_int(udpAuthPort, AssertionError)
            typecheck.is_int(udpAccountPort, AssertionError)
            typecheck.is_int(timeout, AssertionError)
            typecheck.is_int(retries, AssertionError)
            typecheck.is_enum(authType, raritan.rpc.auth.RadiusManager.AuthType, AssertionError)
            typecheck.is_bool(disableAccounting, AssertionError)

            self.id = id
            self.server = server
            self.sharedSecret = sharedSecret
            self.udpAuthPort = udpAuthPort
            self.udpAccountPort = udpAccountPort
            self.timeout = timeout
            self.retries = retries
            self.authType = authType
            self.disableAccounting = disableAccounting

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                server = json['server'],
                sharedSecret = json['sharedSecret'],
                udpAuthPort = json['udpAuthPort'],
                udpAccountPort = json['udpAccountPort'],
                timeout = json['timeout'],
                retries = json['retries'],
                authType = raritan.rpc.auth.RadiusManager.AuthType.decode(json['authType']),
                disableAccounting = json['disableAccounting'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['server'] = self.server
            json['sharedSecret'] = self.sharedSecret
            json['udpAuthPort'] = self.udpAuthPort
            json['udpAccountPort'] = self.udpAccountPort
            json['timeout'] = self.timeout
            json['retries'] = self.retries
            json['authType'] = raritan.rpc.auth.RadiusManager.AuthType.encode(self.authType)
            json['disableAccounting'] = self.disableAccounting
            return json

    ERR_INVALID_CFG = 1

    ERR_SERVER_UNSPECIFIED = 2

    ERR_INVALID_SHARED_SECRET = 3

    ERR_SERVER_UNREACHABLE = 4

    ERR_AUTHENTICATION_FAILED = 5

    ERR_NO_ROLES = 6

    ERR_NO_KNOWN_ROLES = 7

    class _getRadiusServers(Interface.Method):
        name = 'getRadiusServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.auth.RadiusManager.ServerSettings.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.auth.RadiusManager.ServerSettings, DecodeException)
            return _ret_

    class _setRadiusServers(Interface.Method):
        name = 'setRadiusServers'

        @staticmethod
        def encode(serverList):
            for x0 in serverList:
                typecheck.is_struct(x0, raritan.rpc.auth.RadiusManager.ServerSettings, AssertionError)
            args = {}
            args['serverList'] = [raritan.rpc.auth.RadiusManager.ServerSettings.encode(x0) for x0 in serverList]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _testRadiusServer(Interface.Method):
        name = 'testRadiusServer'

        @staticmethod
        def encode(username, password, settings):
            typecheck.is_string(username, AssertionError)
            typecheck.is_string(password, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.auth.RadiusManager.ServerSettings, AssertionError)
            args = {}
            args['username'] = username
            args['password'] = password
            args['settings'] = raritan.rpc.auth.RadiusManager.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(RadiusManager, self).__init__(target, agent)
        self.getRadiusServers = RadiusManager._getRadiusServers(self)
        self.setRadiusServers = RadiusManager._setRadiusServers(self)
        self.testRadiusServer = RadiusManager._testRadiusServer(self)

#
# Section generated by IdlC from "TacPlusManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.auth


# interface
class TacPlusManager(Interface):
    idlType = "auth.TacPlusManager:1.0.1"

    # enumeration
    class AuthenType(Enumeration):
        idlType = "auth.TacPlusManager_1_0_1.AuthenType:1.0.0"
        values = ["ASCII", "PAP", "CHAP", "MSCHAP"]

    AuthenType.ASCII = AuthenType(0)
    AuthenType.PAP = AuthenType(1)
    AuthenType.CHAP = AuthenType(2)
    AuthenType.MSCHAP = AuthenType(3)

    # structure
    class ServerSettings(Structure):
        idlType = "auth.TacPlusManager_1_0_1.ServerSettings:1.0.0"
        elements = ["server", "port", "timeoutSeconds", "retries", "sharedSecret", "authenType", "disableAccounting"]

        def __init__(self, server="", port=0, timeoutSeconds=0, retries=0, sharedSecret="", authenType=None, disableAccounting=False):
            if authenType is None:
                authenType = raritan.rpc.auth.TacPlusManager.AuthenType.ASCII
            typecheck.is_string(server, AssertionError)
            typecheck.is_int(port, AssertionError)
            typecheck.is_int(timeoutSeconds, AssertionError)
            typecheck.is_int(retries, AssertionError)
            typecheck.is_string(sharedSecret, AssertionError)
            typecheck.is_enum(authenType, raritan.rpc.auth.TacPlusManager.AuthenType, AssertionError)
            typecheck.is_bool(disableAccounting, AssertionError)

            self.server = server
            self.port = port
            self.timeoutSeconds = timeoutSeconds
            self.retries = retries
            self.sharedSecret = sharedSecret
            self.authenType = authenType
            self.disableAccounting = disableAccounting

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                server = json['server'],
                port = json['port'],
                timeoutSeconds = json['timeoutSeconds'],
                retries = json['retries'],
                sharedSecret = json['sharedSecret'],
                authenType = raritan.rpc.auth.TacPlusManager.AuthenType.decode(json['authenType']),
                disableAccounting = json['disableAccounting'],
            )
            return obj

        def encode(self):
            json = {}
            json['server'] = self.server
            json['port'] = self.port
            json['timeoutSeconds'] = self.timeoutSeconds
            json['retries'] = self.retries
            json['sharedSecret'] = self.sharedSecret
            json['authenType'] = raritan.rpc.auth.TacPlusManager.AuthenType.encode(self.authenType)
            json['disableAccounting'] = self.disableAccounting
            return json

    ERR_INVALID_CFG = 1

    ERR_SERVER_UNSPECIFIED = 2

    ERR_INVALID_SHARED_SECRET = 3

    ERR_SERVER_UNREACHABLE = 4

    ERR_AUTHENTICATION_FAILED = 5

    ERR_NO_ROLES = 6

    ERR_NO_KNOWN_ROLES = 7

    class _getTacPlusServers(Interface.Method):
        name = 'getTacPlusServers'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.auth.TacPlusManager.ServerSettings.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.auth.TacPlusManager.ServerSettings, DecodeException)
            return _ret_

    class _setTacPlusServers(Interface.Method):
        name = 'setTacPlusServers'

        @staticmethod
        def encode(serverList):
            for x0 in serverList:
                typecheck.is_struct(x0, raritan.rpc.auth.TacPlusManager.ServerSettings, AssertionError)
            args = {}
            args['serverList'] = [raritan.rpc.auth.TacPlusManager.ServerSettings.encode(x0) for x0 in serverList]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _testTacPlusServer(Interface.Method):
        name = 'testTacPlusServer'

        @staticmethod
        def encode(username, password, settings):
            typecheck.is_string(username, AssertionError)
            typecheck.is_string(password, AssertionError)
            typecheck.is_struct(settings, raritan.rpc.auth.TacPlusManager.ServerSettings, AssertionError)
            args = {}
            args['username'] = username
            args['password'] = password
            args['settings'] = raritan.rpc.auth.TacPlusManager.ServerSettings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(TacPlusManager, self).__init__(target, agent)
        self.getTacPlusServers = TacPlusManager._getTacPlusServers(self)
        self.setTacPlusServers = TacPlusManager._setTacPlusServers(self)
        self.testTacPlusServer = TacPlusManager._testTacPlusServer(self)
