% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{stri_opts_collator}
\alias{stri_opts_collator}
\title{Generate a List with Collator Settings}
\usage{
stri_opts_collator(locale = NULL, strength = 3L,
  alternate_shifted = FALSE, french = FALSE, uppercase_first = NA,
  case_level = FALSE, normalization = FALSE, numeric = FALSE, ...)
}
\arguments{
\item{locale}{single string, \code{NULL} or
\code{""} for default locale}

\item{strength}{single integer in \{1,2,3,4\}, which defines collation strength;
\code{1} for the most permissive collation rules, \code{4} for the most
strict ones}

\item{alternate_shifted}{single logical value; \code{FALSE}
treats all the code points with non-ignorable primary weights in the same way,
\code{TRUE} causes code points with primary weights that are equal or below
the variable top value to be ignored on primary level and moved to the quaternary level}

\item{french}{single logical value; used in Canadian French;
\code{TRUE} results in secondary weights being considered backwards}

\item{uppercase_first}{single logical value; \code{NA}
orders upper and lower case letters in accordance to their tertiary weights,
\code{TRUE} forces upper case letters to sort before lower case letters,
\code{FALSE} does the opposite}

\item{case_level}{single logical value;
controls whether an extra case level (positioned before the third level) is generated or not}

\item{normalization}{single logical value; if \code{TRUE},
then incremental check is performed to see whether the input data is in
the FCD form. If the data is not in the FCD form, incremental NFD
normalization is performed}

\item{numeric}{single logical value;
when turned on, this attribute generates a collation key for
the numeric value of substrings of digits;
this is a way to get '100' to sort AFTER '2'}

\item{...}{any other arguments to this function are purposely ignored}
}
\value{
Returns a named list object; missing settings are left with default values.
}
\description{
A convenience function to tune the \pkg{ICU} Collator's behavior,
e.g. in \code{\link{stri_compare}}, \code{\link{stri_order}},
\code{\link{stri_unique}}, \code{\link{stri_duplicated}},
as well as \code{\link{stri_detect_coll}}
and other \link{stringi-search-coll} functions.
}
\details{
\pkg{ICU}'s \emph{collator} performs a locale-aware, natural-language
alike string comparison.
This is a more reliable way of establishing relationships between
string than that provided by base \R, and definitely
one that is more complex and appropriate than ordinary byte-comparison.

A note on collation \code{strength}:
generally, \code{strength} set to 4 is
the least permissive.
Set to 2 to ignore case differences.
Set to 1 to also ignore diacritical differences.

The strings are Unicode-normalized before the comparison.
}
\examples{
stri_cmp("number100", "number2")
stri_cmp("number100", "number2", opts_collator=stri_opts_collator(numeric=TRUE))
stri_cmp("number100", "number2", numeric=TRUE) # equivalent
stri_cmp("above mentioned", "above-mentioned")
stri_cmp("above mentioned", "above-mentioned", alternate_shifted=TRUE)
}
\references{
\emph{Collation} -- ICU User Guide,
\url{http://userguide.icu-project.org/collation}

\emph{ICU Collation Service Architecture} -- ICU User Guide,
\url{http://userguide.icu-project.org/collation/architecture}

\emph{\code{icu::Collator} Class Reference} -- ICU4C API Documentation,
\url{http://www.icu-project.org/apiref/icu4c/classicu_1_1Collator.html}
}
\seealso{
Other locale_sensitive: \code{\link{\%s<\%}},
  \code{\link{stri_compare}},
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_duplicated}},
  \code{\link{stri_enc_detect2}},
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_order}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_unique}}, \code{\link{stri_wrap}},
  \code{\link{stringi-locale}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search-coll}}

Other search_coll: \code{\link{stringi-search-coll}},
  \code{\link{stringi-search}}
}
