% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_tweet}
\alias{post_tweet}
\alias{post_status}
\title{Posts status update to user's Twitter account}
\usage{
post_tweet(
  status = "my first rtweet #rstats",
  media = NULL,
  token = NULL,
  in_reply_to_status_id = NULL,
  destroy_id = NULL,
  retweet_id = NULL,
  auto_populate_reply_metadata = FALSE
)
}
\arguments{
\item{status}{Character, tweet status. Must be 280 characters or less.}

\item{media}{File path to image or video media to be included in tweet.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable tokens.}

\item{in_reply_to_status_id}{Status ID of tweet to which you'd like to reply.
Note: in line with the Twitter API, this parameter is ignored unless the
author of the tweet this parameter references is mentioned within the
status text.}

\item{destroy_id}{To delete a status, supply the single status ID here. If a
character string is supplied, overriding the default (NULL), then a destroy
request is made (and the status text and media attachments) are irrelevant.}

\item{retweet_id}{To retweet a status, supply the single status ID here. If a
character string is supplied, overriding the default (NULL), then a retweet
request is made (and the status text and media attachments) are irrelevant.}

\item{auto_populate_reply_metadata}{If set to TRUE and used with
in_reply_to_status_id, leading @mentions will be looked up from the
original Tweet, and added to the new Tweet from there. Defaults to FALSE.}
}
\description{
Posts status update to user's Twitter account
}
\examples{
\dontrun{
## generate data to make/save plot (as a .png file)
x <- rnorm(300)
y <- x + rnorm(300, 0, .75)
col <- c(rep("#002244aa", 50), rep("#440000aa", 50))
bg <- c(rep("#6699ffaa", 50), rep("#dd6666aa", 50))

## crate temporary file name
tmp <- tempfile(fileext = ".png")

## save as png
png(tmp, 6, 6, "in", res = 127.5)
par(tcl = -.15, family = "Inconsolata",
    font.main = 2, bty = "n", xaxt = "l", yaxt = "l",
    bg = "#f0f0f0", mar = c(3, 3, 2, 1.5))
plot(x, y, xlab = NULL, ylab = NULL, pch = 21, cex = 1,
     bg = bg, col = col,
     main = "This image was uploaded by rtweet")
grid(8, lwd = .15, lty = 2, col = "#00000088")
dev.off()

## post tweet with media attachment
post_tweet("a tweet with media attachment", media = tmp)

# example of replying within a thread
## first post
post_tweet(status="first in a thread")

## lookup status_id
my_timeline <- get_timeline(rtweet:::home_user())

## ID for reply
reply_id <- my_timeline$status_id[1]

## post reply
post_tweet("second in the thread",
  in_reply_to_status_id = reply_id)
}
}
\seealso{
Other post: 
\code{\link{post_favorite}()},
\code{\link{post_follow}()},
\code{\link{post_friendship}()}
}
\concept{post}
