% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-na.R
\name{are_na}
\alias{are_na}
\alias{is_na}
\alias{is_lgl_na}
\alias{is_int_na}
\alias{is_dbl_na}
\alias{is_chr_na}
\alias{is_cpl_na}
\title{Test for missing values}
\usage{
are_na(x)

is_na(x)

is_lgl_na(x)

is_int_na(x)

is_dbl_na(x)

is_chr_na(x)

is_cpl_na(x)
}
\arguments{
\item{x}{An object to test}
}
\description{
\code{are_na()} checks for missing values in a vector and is equivalent
to \code{\link[base:is.na]{base::is.na()}}. It is a vectorised predicate, meaning that its
output is always the same length as its input. On the other hand,
\code{is_na()} is a scalar predicate and always returns a scalar
boolean, \code{TRUE} or \code{FALSE}. If its input is not scalar, it returns
\code{FALSE}. Finally, there are typed versions that check for
particular \link[=missing]{missing types}.
}
\details{
The scalar predicates accept non-vector inputs. They are equivalent
to \code{\link[=is_null]{is_null()}} in that respect. In contrast the vectorised
predicate \code{are_na()} requires a vector input since it is defined
over vector values.
}
\examples{
# are_na() is vectorised and works regardless of the type
are_na(c(1, 2, NA))
are_na(c(1L, NA, 3L))

# is_na() checks for scalar input and works for all types
is_na(NA)
is_na(na_dbl)
is_na(character(0))

# There are typed versions as well:
is_lgl_na(NA)
is_lgl_na(na_dbl)
}
