## ---- eval=TRUE----------------------------------------------------------
library(phangorn)
data(Laurasiatherian)
data(yeast)

## ---- eval=TRUE----------------------------------------------------------
set.seed(1)
bs <- bootstrap.phyDat(yeast, FUN = function(x)nj(dist.hamming(x)), 
    bs=100)
tree <- nj(dist.hamming(yeast))
par("mar" = rep(2, 4))
tree <- plotBS(tree, bs, "phylogram")
cnet <- consensusNet(bs, .3)
plot(cnet, "2D", show.edge.label=TRUE)

## ---- eval=FALSE---------------------------------------------------------
#  plot(cnet)
#  # rotate 3d plot
#  play3d(spin3d(axis=c(0,1,0), rpm=6), duration=10)
#  # create animated gif file
#  movie3d(spin3d(axis=c(0,1,0), rpm=6), duration=10)

## ---- eval=TRUE----------------------------------------------------------
dm <- dist.hamming(yeast)
nnet <- neighborNet(dm)
par("mar" = rep(2, 4))
plot(nnet, "2D")

## ---- eval=TRUE----------------------------------------------------------
nnet <- addConfidences(nnet, tree)
par("mar" = rep(2, 4))
plot(nnet, "2D", show.edge.label=TRUE)

## ---- eval=TRUE----------------------------------------------------------
tree2 <- rNNI(tree, 2)
tree2 <- addConfidences(tree2, tree)
# several support values are missing
plot(tree2, show.node.label=TRUE)

## ---- eval=TRUE----------------------------------------------------------
cnet <- nnls.networx(cnet, dm)
par("mar" = rep(2, 4))
plot(cnet, "2D", show.edge.label=TRUE)

