% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-specials.R
\name{make_time_mat}
\alias{make_time_mat}
\alias{make_latency_mat}
\alias{make_lag_lead_mat}
\alias{make_z_mat}
\title{Create matrix components for cumulative effects}
\usage{
make_time_mat(data, nz)

make_latency_mat(data, tz)

make_lag_lead_mat(data, tz, ll_fun = function(t, tz) t >= tz)

make_z_mat(data, z_var, nz, ...)
}
\arguments{
\item{data}{A data set (or similar) from which meta information on cut-points,
interval-specific time, covariates etc. can be obtained.}

\item{z_var}{Which should be transformed into functional covariate format
suitable to fit cumulative effects in \code{mgcv::gam}.}
}
\description{
These functions are called internally by \code{\link{get_cumulative}} and
should usually not be called directly.
}
\keyword{internal}
