% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dreg.R
\name{dreg}
\alias{dreg}
\title{Regression for data frames with dutility call}
\usage{
dreg(data, y, x = NULL, z = NULL, x.oneatatime = TRUE,
  x.base.names = NULL, z.arg = c("clever", "base", "group",
  "condition"), fun. = lm, summary. = summary, regex = FALSE,
  convert = NULL, doSummary = TRUE, special = NULL, equal = TRUE,
  test = 1, ...)
}
\arguments{
\item{data}{data frame}

\item{y}{name of variable, or fomula, or names of variables on data frame.}

\item{x}{name of variable, or fomula, or names of variables on data frame.}

\item{z}{name of variable, or fomula, or names of variables on data frame.}

\item{x.oneatatime}{x's one at a time}

\item{x.base.names}{base covarirates}

\item{z.arg}{what is Z, c("clever","base","group","condition"), clever decides based on type of Z, base means that Z is used as fixed baseline covaraites for all X, group means the analyses is done based on groups of Z, and condition means that Z specifies a condition on the data}

\item{fun.}{function  lm is default}

\item{summary.}{summary to use}

\item{regex}{regex}

\item{convert}{convert}

\item{doSummary}{doSummary or not}

\item{special}{special's}

\item{equal}{to do pairwise stuff}

\item{test}{development argument}

\item{...}{Additional arguments for fun}
}
\description{
Regression for data frames with dutility call
}
\examples{
##' 
data(iris)
data <- iris
drename(iris) <- ~.
names(iris)
set.seed(1)
iris$time <- runif(nrow(iris))
iris$time1 <- runif(nrow(iris))
iris$status <- rbinom(nrow(iris),1,0.5)
iris$S1 <- with(iris,Surv(time,status))
iris$S2 <- with(iris,Surv(time1,status))
iris$id <- 1:nrow(iris)

mm <- dreg(iris,"*.length"~"*.width"|I(species=="setosa" & status==1))
mm <- dreg(iris,"*.length"~"*.width"|species+status)
mm <- dreg(iris,"*.length"~"*.width"|species)
mm <- dreg(iris,"*.length"~"*.width"|species+status,z.arg="group")

\donttest{ ## Reduce Ex.Timings
y <- "S*"~"*.width"
xs <- dreg(iris,y,fun.=phreg)
xs <- dreg(iris,y,fun.=survdiff)

y <- "S*"~"*.width"
xs <- dreg(iris,y,x.oneatatime=FALSE,fun.=phreg)

## under condition
y <- S1~"*.width"|I(species=="setosa" & sepal.width>3)
xs <- dreg(iris,y,z.arg="condition",fun.=phreg)
xs <- dreg(iris,y,fun.=phreg)

## under condition
y <- S1~"*.width"|species=="setosa"
xs <- dreg(iris,y,z.arg="condition",fun.=phreg)
xs <- dreg(iris,y,fun.=phreg)

## with baseline  after |
y <- S1~"*.width"|sepal.length
xs <- dreg(iris,y,fun.=phreg)

## by group by species, not working
y <- S1~"*.width"|species
ss <- split(iris,paste(iris$species,iris$status))

xs <- dreg(iris,y,fun.=phreg)

## species as base, species is factor so assumes that this is grouping
y <- S1~"*.width"|species
xs <- dreg(iris,y,z.arg="base",fun.=phreg)

##  background var after | and then one of x's at at time
y <- S1~"*.width"|status+"sepal*"
xs <- dreg(iris,y,fun.=phreg)

##  background var after | and then one of x's at at time
##y <- S1~"*.width"|status+"sepal*"
##xs <- dreg(iris,y,x.oneatatime=FALSE,fun.=phreg)
##xs <- dreg(iris,y,fun.=phreg)

##  background var after | and then one of x's at at time
##y <- S1~"*.width"+factor(species)
##xs <- dreg(iris,y,fun.=phreg)
##xs <- dreg(iris,y,fun.=phreg,x.oneatatime=FALSE)

y <- S1~"*.width"|factor(species)
xs <- dreg(iris,y,z.arg="base",fun.=phreg)

y <- S1~"*.width"|cluster(id)+factor(species)
xs <- dreg(iris,y,z.arg="base",fun.=phreg)
xs <- dreg(iris,y,z.arg="base",fun.=coxph)

## under condition with groups
y <- S1~"*.width"|I(sepal.length>4)
xs <- dreg(subset(iris,species=="setosa"),y,z.arg="group",fun.=phreg)

## under condition with groups
y <- S1~"*.width"+I(log(sepal.length))|I(sepal.length>4)
xs <- dreg(subset(iris,species=="setosa"),y,z.arg="group",fun.=phreg)

y <- S1~"*.width"+I(dcut(sepal.length))|I(sepal.length>4)
xs <- dreg(subset(iris,species=="setosa"),y,z.arg="group",fun.=phreg)

ff <- function(formula,data,...) {
 ss <- survfit(formula,data,...)
 kmplot(ss,...)
 return(ss)
}

if (interactive()) {
dcut(iris) <- ~"*.width"
y <- S1~"*.4"|I(sepal.length>4)
par(mfrow=c(1,2))
xs <- dreg(iris,y,fun.=ff)
}
}

}
\author{
Klaus K. Holst, Thomas Scheike
}
