% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalar_in_linter.R
\name{scalar_in_linter}
\alias{scalar_in_linter}
\title{Block usage like x \%in\% "a"}
\usage{
scalar_in_linter(in_operators = NULL)
}
\arguments{
\item{in_operators}{Character vector of additional infix operators that behave like the \code{\%in\%} operator,
e.g. \code{{data.table}}'s \verb{\%chin\%} operator.}
}
\description{
\code{vector \%in\% set} is appropriate for matching a vector to a set, but if
that set has size 1, \code{==} is more appropriate. However, if \code{vector} has
also size 1 and can be \code{NA}, the use of \code{==} should be accompanied by extra
protection for the missing case (for example, \code{isTRUE(NA == "arg")} or
\code{!is.na(x) && x == "arg"}).
}
\details{
\code{scalar \%in\% vector} is OK, because the alternative (\code{any(vector == scalar)})
is more circuitous & potentially less clear.
}
\examples{
# will produce lints
lint(
  text = "x \%in\% 1L",
  linters = scalar_in_linter()
)

lint(
  text = "x \%chin\% 'a'",
  linters = scalar_in_linter(in_operators = "\%chin\%")
)

# okay
lint(
  text = "x \%in\% 1:10",
  linters = scalar_in_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
