% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_quote_linter.R
\name{keyword_quote_linter}
\alias{keyword_quote_linter}
\title{Block unnecessary quoting in calls}
\usage{
keyword_quote_linter()
}
\description{
Any valid symbol can be used as a keyword argument to an R function call.
Sometimes, it is necessary to quote (or backtick) an argument that is
not an otherwise valid symbol (e.g. creating a vector whose names have
spaces); besides this edge case, quoting should not be done.
}
\details{
The most common source of violation for this is creating named vectors,
lists, or data.frame-alikes, but it can be observed in other calls as well.

Similar reasoning applies to extractions with \code{$} or \code{@}.
}
\examples{
# will produce lints
lint(
  text = 'data.frame("a" = 1)',
  linters = keyword_quote_linter()
)

lint(
  text = "data.frame(`a` = 1)",
  linters = keyword_quote_linter()
)

lint(
  text = 'my_list$"key"',
  linters = keyword_quote_linter()
)

lint(
  text = 's4obj@"key"',
  linters = keyword_quote_linter()
)

# okay
lint(
  text = "data.frame(`a b` = 1)",
  linters = keyword_quote_linter()
)

lint(
  text = "my_list$`a b`",
  linters = keyword_quote_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
