% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_linter.R
\name{print_linter}
\alias{print_linter}
\title{Block usage of print() for logging}
\usage{
print_linter()
}
\description{
The default print method for character vectors is appropriate for interactively inspecting objects,
not for logging messages. Thus checked-in usage like \code{print(paste('Data has', nrow(DF), 'rows.'))}
is better served by using \code{\link[=cat]{cat()}}, e.g. \code{cat(sprintf('Data has \%d rows.\\n', nrow(DF)))} (noting that
using \code{cat()} entails supplying your own line returns, and that \code{\link[glue:glue]{glue::glue()}} might be preferable
to \code{\link[=sprintf]{sprintf()}} for constructing templated strings). Lastly, note that \code{\link[=message]{message()}} differs slightly
from \code{cat()} in that it prints to \code{stderr} by default, not \code{stdout}, but is still a good option
to consider for logging purposes.
}
\examples{
# will produce lints
lint(
  text = "print('a')",
  linters = print_linter()
)

lint(
  text = "print(paste(x, 'y'))",
  linters = print_linter()
)

# okay
lint(
  text = "print(x)",
  linters = print_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}
}
